// chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-params-data.h"
namespace mojom {

NOINLINE static const char* AutocompleteControllerTypeToStringHelper(AutocompleteControllerType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AutocompleteControllerType::kBrowser:
      return "kBrowser";
    case AutocompleteControllerType::kDebug:
      return "kDebug";
    case AutocompleteControllerType::kMlDisabledDebug:
      return "kMlDisabledDebug";
    default:
      return nullptr;
  }
}

std::string AutocompleteControllerTypeToString(AutocompleteControllerType value) {
  const char *str = AutocompleteControllerTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AutocompleteControllerType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AutocompleteControllerType value) {
  return os << AutocompleteControllerTypeToString(value);
}

namespace internal {


// static
bool ACMatchClassification_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ACMatchClassification_Data* object =
      static_cast<const ACMatchClassification_Data*>(data);

  return true;
}

ACMatchClassification_Data::ACMatchClassification_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Signals_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Signals_Data* object =
      static_cast<const Signals_Data*>(data);

  return true;
}

Signals_Data::Signals_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutocompleteMatch_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 176, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutocompleteMatch_Data* object =
      static_cast<const AutocompleteMatch_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->provider_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& provider_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->provider_name, validation_context,
                                         &provider_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fill_into_edit, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& fill_into_edit_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->fill_into_edit, validation_context,
                                         &fill_into_edit_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->inline_autocompletion, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& inline_autocompletion_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->inline_autocompletion, validation_context,
                                         &inline_autocompletion_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destination_url, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->destination_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stripped_destination_url, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->stripped_destination_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->contents, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& contents_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->contents, validation_context,
                                         &contents_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->contents_class, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& contents_class_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->contents_class, validation_context,
                                         &contents_class_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 13, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description_class, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_class_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description_class, validation_context,
                                         &description_class_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->answer, 16, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& answer_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->answer, validation_context,
                                         &answer_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transition, 17, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& transition_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->transition, validation_context,
                                         &transition_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 19, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->type, validation_context,
                                         &type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aqs_type_subtypes, 21, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& aqs_type_subtypes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->aqs_type_subtypes, validation_context,
                                         &aqs_type_subtypes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->associated_keyword, 23, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& associated_keyword_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->associated_keyword, validation_context,
                                         &associated_keyword_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keyword, 24, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& keyword_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->keyword, validation_context,
                                         &keyword_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scoring_signals, 29, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scoring_signals, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_info, 30, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& additional_info_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->additional_info, validation_context,
                                         &additional_info_validate_params)) {
    return false;
  }

  return true;
}

AutocompleteMatch_Data::AutocompleteMatch_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutocompleteResultsForProvider_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutocompleteResultsForProvider_Data* object =
      static_cast<const AutocompleteResultsForProvider_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->provider_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& provider_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->provider_name, validation_context,
                                         &provider_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->results, validation_context,
                                         &results_validate_params)) {
    return false;
  }

  return true;
}

AutocompleteResultsForProvider_Data::AutocompleteResultsForProvider_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OmniboxResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OmniboxResponse_Data* object =
      static_cast<const OmniboxResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->type, validation_context,
                                         &type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_text, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input_text, validation_context,
                                         &input_text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->combined_results, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& combined_results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->combined_results, validation_context,
                                         &combined_results_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results_by_provider, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& results_by_provider_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->results_by_provider, validation_context,
                                         &results_by_provider_validate_params)) {
    return false;
  }

  return true;
}

OmniboxResponse_Data::OmniboxResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OmniboxPageHandler_SetClientPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OmniboxPageHandler_SetClientPage_Params_Data* object =
      static_cast<const OmniboxPageHandler_SetClientPage_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  return true;
}

OmniboxPageHandler_SetClientPage_Params_Data::OmniboxPageHandler_SetClientPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OmniboxPageHandler_StartOmniboxQuery_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OmniboxPageHandler_StartOmniboxQuery_Params_Data* object =
      static_cast<const OmniboxPageHandler_StartOmniboxQuery_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_string, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_string_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input_string, validation_context,
                                         &input_string_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->current_url, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& current_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->current_url, validation_context,
                                         &current_url_validate_params)) {
    return false;
  }

  return true;
}

OmniboxPageHandler_StartOmniboxQuery_Params_Data::OmniboxPageHandler_StartOmniboxQuery_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OmniboxPageHandler_GetMlModelVersion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OmniboxPageHandler_GetMlModelVersion_Params_Data* object =
      static_cast<const OmniboxPageHandler_GetMlModelVersion_Params_Data*>(data);

  return true;
}

OmniboxPageHandler_GetMlModelVersion_Params_Data::OmniboxPageHandler_GetMlModelVersion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OmniboxPageHandler_GetMlModelVersion_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OmniboxPageHandler_GetMlModelVersion_ResponseParams_Data* object =
      static_cast<const OmniboxPageHandler_GetMlModelVersion_ResponseParams_Data*>(data);

  return true;
}

OmniboxPageHandler_GetMlModelVersion_ResponseParams_Data::OmniboxPageHandler_GetMlModelVersion_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OmniboxPageHandler_StartMl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OmniboxPageHandler_StartMl_Params_Data* object =
      static_cast<const OmniboxPageHandler_StartMl_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signals, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->signals, validation_context))
    return false;

  return true;
}

OmniboxPageHandler_StartMl_Params_Data::OmniboxPageHandler_StartMl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OmniboxPageHandler_StartMl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OmniboxPageHandler_StartMl_ResponseParams_Data* object =
      static_cast<const OmniboxPageHandler_StartMl_ResponseParams_Data*>(data);

  return true;
}

OmniboxPageHandler_StartMl_ResponseParams_Data::OmniboxPageHandler_StartMl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OmniboxPage_HandleNewAutocompleteQuery_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OmniboxPage_HandleNewAutocompleteQuery_Params_Data* object =
      static_cast<const OmniboxPage_HandleNewAutocompleteQuery_Params_Data*>(data);


  if (!::mojom::internal::AutocompleteControllerType_Data
        ::Validate(object->autocomplete_controller_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_text, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input_text, validation_context,
                                         &input_text_validate_params)) {
    return false;
  }

  return true;
}

OmniboxPage_HandleNewAutocompleteQuery_Params_Data::OmniboxPage_HandleNewAutocompleteQuery_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OmniboxPage_HandleNewAutocompleteResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OmniboxPage_HandleNewAutocompleteResponse_Params_Data* object =
      static_cast<const OmniboxPage_HandleNewAutocompleteResponse_Params_Data*>(data);


  if (!::mojom::internal::AutocompleteControllerType_Data
        ::Validate(object->autocomplete_controller_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

OmniboxPage_HandleNewAutocompleteResponse_Params_Data::OmniboxPage_HandleNewAutocompleteResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OmniboxPage_HandleNewMlResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OmniboxPage_HandleNewMlResponse_Params_Data* object =
      static_cast<const OmniboxPage_HandleNewMlResponse_Params_Data*>(data);


  if (!::mojom::internal::AutocompleteControllerType_Data
        ::Validate(object->autocomplete_controller_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_text, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input_text, validation_context,
                                         &input_text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->matches, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& matches_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->matches, validation_context,
                                         &matches_validate_params)) {
    return false;
  }

  return true;
}

OmniboxPage_HandleNewMlResponse_Params_Data::OmniboxPage_HandleNewMlResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OmniboxPage_HandleAnswerIconImageData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OmniboxPage_HandleAnswerIconImageData_Params_Data* object =
      static_cast<const OmniboxPage_HandleAnswerIconImageData_Params_Data*>(data);


  if (!::mojom::internal::AutocompleteControllerType_Data
        ::Validate(object->autocomplete_controller_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_data, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& image_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->image_data, validation_context,
                                         &image_data_validate_params)) {
    return false;
  }

  return true;
}

OmniboxPage_HandleAnswerIconImageData_Params_Data::OmniboxPage_HandleAnswerIconImageData_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom

namespace perfetto {

// static
void TraceFormatTraits<::mojom::AutocompleteControllerType>::WriteIntoTrace(
   perfetto::TracedValue context, ::mojom::AutocompleteControllerType value) {
  return std::move(context).WriteString(::mojom::AutocompleteControllerTypeToString(value));
}

} // namespace perfetto