// chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_ACTION_CHIPS_ACTION_CHIPS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_ACTION_CHIPS_ACTION_CHIPS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace action_chips::mojom {

class ActionChipsHandlerProxy;

template <typename ImplRefTraits>
class ActionChipsHandlerStub;

class ActionChipsHandlerRequestValidator;


class ActionChipsHandler
    : public ActionChipsHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "action_chips.mojom.ActionChipsHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ActionChipsHandlerInterfaceBase;
  using Proxy_ = ActionChipsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ActionChipsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = ActionChipsHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartActionChipsRetrievalMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartActionChipsRetrieval_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ActionChipsHandler() = default;

  virtual void StartActionChipsRetrieval() = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "action_chips.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnActionChipsChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnActionChipsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnActionChipsChanged(std::vector<ActionChipPtr> action_chips) = 0;
};

class ActionChipsHandlerFactoryProxy;

template <typename ImplRefTraits>
class ActionChipsHandlerFactoryStub;

class ActionChipsHandlerFactoryRequestValidator;


class ActionChipsHandlerFactory
    : public ActionChipsHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "action_chips.mojom.ActionChipsHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ActionChipsHandlerFactoryInterfaceBase;
  using Proxy_ = ActionChipsHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ActionChipsHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ActionChipsHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateActionChipsHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateActionChipsHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ActionChipsHandlerFactory() = default;

  virtual void CreateActionChipsHandler(::mojo::PendingReceiver<ActionChipsHandler> handler, ::mojo::PendingRemote<Page> page) = 0;
};



class  ActionChipsHandlerProxy
    : public ActionChipsHandler {
 public:
  using InterfaceType = ActionChipsHandler;

  explicit ActionChipsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartActionChipsRetrieval() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnActionChipsChanged(std::vector<ActionChipPtr> action_chips) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ActionChipsHandlerFactoryProxy
    : public ActionChipsHandlerFactory {
 public:
  using InterfaceType = ActionChipsHandlerFactory;

  explicit ActionChipsHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateActionChipsHandler(::mojo::PendingReceiver<ActionChipsHandler> handler, ::mojo::PendingRemote<Page> page) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ActionChipsHandlerStubDispatch {
 public:
  static bool Accept(ActionChipsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ActionChipsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ActionChipsHandler>>
class ActionChipsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ActionChipsHandlerStub() = default;
  ~ActionChipsHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActionChipsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActionChipsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ActionChipsHandlerFactoryStubDispatch {
 public:
  static bool Accept(ActionChipsHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ActionChipsHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ActionChipsHandlerFactory>>
class ActionChipsHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ActionChipsHandlerFactoryStub() = default;
  ~ActionChipsHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActionChipsHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActionChipsHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ActionChipsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ActionChipsHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  TabInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabInfo, T>::value>;
  using DataView = TabInfoDataView;
  using Data_ = internal::TabInfo_Data;

  template <typename... Args>
  static TabInfoPtr New(Args&&... args) {
    return TabInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabInfoPtr From(const U& u) {
    return mojo::TypeConverter<TabInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabInfo>::Convert(*this);
  }


  TabInfo();

  TabInfo(
      int32_t tab_id,
      const std::string& title,
      const ::GURL& url,
      ::base::Time last_active_time);


  ~TabInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabInfoPtr>
  TabInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabInfo_UnserializedMessageContext<
            UserType, TabInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabInfo_UnserializedMessageContext<
            UserType, TabInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t tab_id;
  
  std::string title;
  
  ::GURL url;
  
  ::base::Time last_active_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ActionChip {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ActionChip, T>::value>;
  using DataView = ActionChipDataView;
  using Data_ = internal::ActionChip_Data;

  template <typename... Args>
  static ActionChipPtr New(Args&&... args) {
    return ActionChipPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ActionChipPtr From(const U& u) {
    return mojo::TypeConverter<ActionChipPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ActionChip>::Convert(*this);
  }


  ActionChip();

  ActionChip(
      const std::string& title,
      const std::string& suggestion,
      ChipType type,
      TabInfoPtr tab);

ActionChip(const ActionChip&) = delete;
ActionChip& operator=(const ActionChip&) = delete;

  ~ActionChip();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ActionChipPtr>
  ActionChipPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ActionChip::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ActionChip::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ActionChip::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ActionChip::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ActionChip::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ActionChip::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ActionChip_UnserializedMessageContext<
            UserType, ActionChip::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ActionChip::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ActionChip::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ActionChip_UnserializedMessageContext<
            UserType, ActionChip::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ActionChip::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string title;
  
  std::string suggestion;
  
  ChipType type;
  
  TabInfoPtr tab;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ActionChip::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ActionChip::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ActionChip::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ActionChip::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TabInfoPtr TabInfo::Clone() const {
  return New(
      mojo::Clone(tab_id),
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(last_active_time)
  );
}

template <typename T, TabInfo::EnableIfSame<T>*>
bool TabInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab_id, other_struct.tab_id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->last_active_time, other_struct.last_active_time))
    return false;
  return true;
}

template <typename T, TabInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab_id < rhs.tab_id)
    return true;
  if (rhs.tab_id < lhs.tab_id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.last_active_time < rhs.last_active_time)
    return true;
  if (rhs.last_active_time < lhs.last_active_time)
    return false;
  return false;
}
template <typename StructPtrType>
ActionChipPtr ActionChip::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(suggestion),
      mojo::Clone(type),
      mojo::Clone(tab)
  );
}

template <typename T, ActionChip::EnableIfSame<T>*>
bool ActionChip::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->suggestion, other_struct.suggestion))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->tab, other_struct.tab))
    return false;
  return true;
}

template <typename T, ActionChip::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.suggestion < rhs.suggestion)
    return true;
  if (rhs.suggestion < lhs.suggestion)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.tab < rhs.tab)
    return true;
  if (rhs.tab < lhs.tab)
    return false;
  return false;
}


}  // action_chips::mojom

namespace mojo {


template <>
struct  StructTraits<::action_chips::mojom::TabInfo::DataView,
                                         ::action_chips::mojom::TabInfoPtr> {
  static bool IsNull(const ::action_chips::mojom::TabInfoPtr& input) { return !input; }
  static void SetToNull(::action_chips::mojom::TabInfoPtr* output) { output->reset(); }

  static decltype(::action_chips::mojom::TabInfo::tab_id) tab_id(
      const ::action_chips::mojom::TabInfoPtr& input) {
    return input->tab_id;
  }

  static const decltype(::action_chips::mojom::TabInfo::title)& title(
      const ::action_chips::mojom::TabInfoPtr& input) {
    return input->title;
  }

  static const decltype(::action_chips::mojom::TabInfo::url)& url(
      const ::action_chips::mojom::TabInfoPtr& input) {
    return input->url;
  }

  static const decltype(::action_chips::mojom::TabInfo::last_active_time)& last_active_time(
      const ::action_chips::mojom::TabInfoPtr& input) {
    return input->last_active_time;
  }

  static bool Read(::action_chips::mojom::TabInfo::DataView input, ::action_chips::mojom::TabInfoPtr* output);
};


template <>
struct  StructTraits<::action_chips::mojom::ActionChip::DataView,
                                         ::action_chips::mojom::ActionChipPtr> {
  static bool IsNull(const ::action_chips::mojom::ActionChipPtr& input) { return !input; }
  static void SetToNull(::action_chips::mojom::ActionChipPtr* output) { output->reset(); }

  static const decltype(::action_chips::mojom::ActionChip::title)& title(
      const ::action_chips::mojom::ActionChipPtr& input) {
    return input->title;
  }

  static const decltype(::action_chips::mojom::ActionChip::suggestion)& suggestion(
      const ::action_chips::mojom::ActionChipPtr& input) {
    return input->suggestion;
  }

  static decltype(::action_chips::mojom::ActionChip::type) type(
      const ::action_chips::mojom::ActionChipPtr& input) {
    return input->type;
  }

  static const decltype(::action_chips::mojom::ActionChip::tab)& tab(
      const ::action_chips::mojom::ActionChipPtr& input) {
    return input->tab;
  }

  static bool Read(::action_chips::mojom::ActionChip::DataView input, ::action_chips::mojom::ActionChipPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_ACTION_CHIPS_ACTION_CHIPS_MOJOM_H_