// chrome/browser/ui/webui/discards/discards.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  LifecycleUnitDiscardReasonSpec as mojom_LifecycleUnitDiscardReasonSpec,
  LifecycleUnitDiscardReason as mojom_LifecycleUnitDiscardReason,
  LifecycleUnitLoadingStateSpec as mojom_LifecycleUnitLoadingStateSpec,
  LifecycleUnitLoadingState as mojom_LifecycleUnitLoadingState,
  LifecycleUnitStateSpec as mojom_LifecycleUnitStateSpec,
  LifecycleUnitState as mojom_LifecycleUnitState
} from './lifecycle_unit_state.mojom-webui.js';
import {
  ProcessIdSpec as mojoBase_mojom_ProcessIdSpec,
  ProcessId as mojoBase_mojom_ProcessId
} from '//resources/mojo/mojo/public/mojom/base/process_id.mojom-webui.js';
import {
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeDelta as mojoBase_mojom_TimeDelta
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const LifecycleUnitVisibilitySpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum LifecycleUnitVisibility {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  HIDDEN = 0,
  OCCLUDED = 1,
  VISIBLE = 2,
}

export const CanFreezeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum CanFreeze {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  YES = 0,
  VARIES = 1,
  NO = 2,
}



export type DetailsProviderPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<DetailsProviderPendingReceiver>;

export class DetailsProviderPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<DetailsProvider> {

  handle: mojo.internal.interfaceSupport.Endpoint<DetailsProviderPendingReceiver>;
  constructor(handle: MojoHandle|DetailsProviderPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'discards.mojom.DetailsProvider',
        scope);
  }
}

export interface DetailsProviderInterface {
  getTabDiscardsInfo(): Promise<{
        infos: TabDiscardsInfo[], }>;
  setAutoDiscardable(tabId: number, isAutoDiscardable: boolean): Promise<void>;
  discardById(tabId: number, reason: mojom_LifecycleUnitDiscardReason): Promise<void>;
  freezeById(tabId: number): void;
  loadById(tabId: number): void;
  discard(): Promise<void>;
  toggleBatterySaverMode(): void;
  refreshPerformanceTabCpuMeasurements(): void;
}

export class DetailsProviderRemote implements DetailsProviderInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<DetailsProviderPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<DetailsProviderPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|DetailsProviderPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DetailsProviderPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getTabDiscardsInfo(): Promise<{
        infos: TabDiscardsInfo[], }> {
    return this.proxy.sendMessage(
        0,
        DetailsProvider_GetTabDiscardsInfo_ParamsSpec.$,
        DetailsProvider_GetTabDiscardsInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  setAutoDiscardable(
      tabId: number,
      isAutoDiscardable: boolean): Promise<void> {
    return this.proxy.sendMessage(
        1,
        DetailsProvider_SetAutoDiscardable_ParamsSpec.$,
        DetailsProvider_SetAutoDiscardable_ResponseParamsSpec.$,
        [
          tabId,
          isAutoDiscardable
        ],
        false);
  }

  discardById(
      tabId: number,
      reason: mojom_LifecycleUnitDiscardReason): Promise<void> {
    return this.proxy.sendMessage(
        2,
        DetailsProvider_DiscardById_ParamsSpec.$,
        DetailsProvider_DiscardById_ResponseParamsSpec.$,
        [
          tabId,
          reason
        ],
        false);
  }

  freezeById(
      tabId: number): void {
    this.proxy.sendMessage(
        3,
        DetailsProvider_FreezeById_ParamsSpec.$,
        null,
        [
          tabId
        ],
        false);
  }

  loadById(
      tabId: number): void {
    this.proxy.sendMessage(
        4,
        DetailsProvider_LoadById_ParamsSpec.$,
        null,
        [
          tabId
        ],
        false);
  }

  discard(): Promise<void> {
    return this.proxy.sendMessage(
        5,
        DetailsProvider_Discard_ParamsSpec.$,
        DetailsProvider_Discard_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  toggleBatterySaverMode(): void {
    this.proxy.sendMessage(
        6,
        DetailsProvider_ToggleBatterySaverMode_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  refreshPerformanceTabCpuMeasurements(): void {
    this.proxy.sendMessage(
        7,
        DetailsProvider_RefreshPerformanceTabCpuMeasurements_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DetailsProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DetailsProviderReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    DetailsProviderRemote, DetailsProviderPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    DetailsProviderRemote, DetailsProviderPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: DetailsProviderInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DetailsProviderRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DetailsProvider_GetTabDiscardsInfo_ParamsSpec.$,
        DetailsProvider_GetTabDiscardsInfo_ResponseParamsSpec.$,
        impl.getTabDiscardsInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DetailsProvider_SetAutoDiscardable_ParamsSpec.$,
        DetailsProvider_SetAutoDiscardable_ResponseParamsSpec.$,
        impl.setAutoDiscardable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DetailsProvider_DiscardById_ParamsSpec.$,
        DetailsProvider_DiscardById_ResponseParamsSpec.$,
        impl.discardById.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        DetailsProvider_FreezeById_ParamsSpec.$,
        null,
        impl.freezeById.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        DetailsProvider_LoadById_ParamsSpec.$,
        null,
        impl.loadById.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        DetailsProvider_Discard_ParamsSpec.$,
        DetailsProvider_Discard_ResponseParamsSpec.$,
        impl.discard.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        DetailsProvider_ToggleBatterySaverMode_ParamsSpec.$,
        null,
        impl.toggleBatterySaverMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        DetailsProvider_RefreshPerformanceTabCpuMeasurements_ParamsSpec.$,
        null,
        impl.refreshPerformanceTabCpuMeasurements.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DetailsProvider {
  static get $interfaceName(): string {
    return "discards.mojom.DetailsProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): DetailsProviderRemote {
    let remote = new DetailsProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the DetailsProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DetailsProviderCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    DetailsProviderRemote, DetailsProviderPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    DetailsProviderRemote, DetailsProviderPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getTabDiscardsInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setAutoDiscardable: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  discardById: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  freezeById: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  loadById: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  discard: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  toggleBatterySaverMode: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  refreshPerformanceTabCpuMeasurements: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DetailsProviderRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getTabDiscardsInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DetailsProvider_GetTabDiscardsInfo_ParamsSpec.$,
        DetailsProvider_GetTabDiscardsInfo_ResponseParamsSpec.$,
        this.getTabDiscardsInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setAutoDiscardable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DetailsProvider_SetAutoDiscardable_ParamsSpec.$,
        DetailsProvider_SetAutoDiscardable_ResponseParamsSpec.$,
        this.setAutoDiscardable.createReceiverHandler(true /* expectsResponse */),
        false);
    this.discardById =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DetailsProvider_DiscardById_ParamsSpec.$,
        DetailsProvider_DiscardById_ResponseParamsSpec.$,
        this.discardById.createReceiverHandler(true /* expectsResponse */),
        false);
    this.freezeById =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        DetailsProvider_FreezeById_ParamsSpec.$,
        null,
        this.freezeById.createReceiverHandler(false /* expectsResponse */),
        false);
    this.loadById =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        DetailsProvider_LoadById_ParamsSpec.$,
        null,
        this.loadById.createReceiverHandler(false /* expectsResponse */),
        false);
    this.discard =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        DetailsProvider_Discard_ParamsSpec.$,
        DetailsProvider_Discard_ResponseParamsSpec.$,
        this.discard.createReceiverHandler(true /* expectsResponse */),
        false);
    this.toggleBatterySaverMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        DetailsProvider_ToggleBatterySaverMode_ParamsSpec.$,
        null,
        this.toggleBatterySaverMode.createReceiverHandler(false /* expectsResponse */),
        false);
    this.refreshPerformanceTabCpuMeasurements =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        DetailsProvider_RefreshPerformanceTabCpuMeasurements_ParamsSpec.$,
        null,
        this.refreshPerformanceTabCpuMeasurements.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type GraphChangeStreamPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<GraphChangeStreamPendingReceiver>;

export class GraphChangeStreamPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<GraphChangeStream> {

  handle: mojo.internal.interfaceSupport.Endpoint<GraphChangeStreamPendingReceiver>;
  constructor(handle: MojoHandle|GraphChangeStreamPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'discards.mojom.GraphChangeStream',
        scope);
  }
}

export interface GraphChangeStreamInterface {
  frameCreated(frame: FrameInfo): void;
  pageCreated(pages: PageInfo): void;
  processCreated(process: ProcessInfo): void;
  workerCreated(worker: WorkerInfo): void;
  frameChanged(frame: FrameInfo): void;
  pageChanged(page: PageInfo): void;
  processChanged(process: ProcessInfo): void;
  workerChanged(worker: WorkerInfo): void;
  favIconDataAvailable(favicon: FavIconInfo): void;
  nodeDeleted(nodeId: bigint): void;
}

export class GraphChangeStreamRemote implements GraphChangeStreamInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<GraphChangeStreamPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<GraphChangeStreamPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|GraphChangeStreamPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GraphChangeStreamPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  frameCreated(
      frame: FrameInfo): void {
    this.proxy.sendMessage(
        0,
        GraphChangeStream_FrameCreated_ParamsSpec.$,
        null,
        [
          frame
        ],
        false);
  }

  pageCreated(
      pages: PageInfo): void {
    this.proxy.sendMessage(
        1,
        GraphChangeStream_PageCreated_ParamsSpec.$,
        null,
        [
          pages
        ],
        false);
  }

  processCreated(
      process: ProcessInfo): void {
    this.proxy.sendMessage(
        2,
        GraphChangeStream_ProcessCreated_ParamsSpec.$,
        null,
        [
          process
        ],
        false);
  }

  workerCreated(
      worker: WorkerInfo): void {
    this.proxy.sendMessage(
        3,
        GraphChangeStream_WorkerCreated_ParamsSpec.$,
        null,
        [
          worker
        ],
        false);
  }

  frameChanged(
      frame: FrameInfo): void {
    this.proxy.sendMessage(
        4,
        GraphChangeStream_FrameChanged_ParamsSpec.$,
        null,
        [
          frame
        ],
        false);
  }

  pageChanged(
      page: PageInfo): void {
    this.proxy.sendMessage(
        5,
        GraphChangeStream_PageChanged_ParamsSpec.$,
        null,
        [
          page
        ],
        false);
  }

  processChanged(
      process: ProcessInfo): void {
    this.proxy.sendMessage(
        6,
        GraphChangeStream_ProcessChanged_ParamsSpec.$,
        null,
        [
          process
        ],
        false);
  }

  workerChanged(
      worker: WorkerInfo): void {
    this.proxy.sendMessage(
        7,
        GraphChangeStream_WorkerChanged_ParamsSpec.$,
        null,
        [
          worker
        ],
        false);
  }

  favIconDataAvailable(
      favicon: FavIconInfo): void {
    this.proxy.sendMessage(
        8,
        GraphChangeStream_FavIconDataAvailable_ParamsSpec.$,
        null,
        [
          favicon
        ],
        false);
  }

  nodeDeleted(
      nodeId: bigint): void {
    this.proxy.sendMessage(
        9,
        GraphChangeStream_NodeDeleted_ParamsSpec.$,
        null,
        [
          nodeId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GraphChangeStream
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GraphChangeStreamReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GraphChangeStreamRemote, GraphChangeStreamPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GraphChangeStreamRemote, GraphChangeStreamPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: GraphChangeStreamInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GraphChangeStreamRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GraphChangeStream_FrameCreated_ParamsSpec.$,
        null,
        impl.frameCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        GraphChangeStream_PageCreated_ParamsSpec.$,
        null,
        impl.pageCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        GraphChangeStream_ProcessCreated_ParamsSpec.$,
        null,
        impl.processCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        GraphChangeStream_WorkerCreated_ParamsSpec.$,
        null,
        impl.workerCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        GraphChangeStream_FrameChanged_ParamsSpec.$,
        null,
        impl.frameChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        GraphChangeStream_PageChanged_ParamsSpec.$,
        null,
        impl.pageChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        GraphChangeStream_ProcessChanged_ParamsSpec.$,
        null,
        impl.processChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        GraphChangeStream_WorkerChanged_ParamsSpec.$,
        null,
        impl.workerChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        GraphChangeStream_FavIconDataAvailable_ParamsSpec.$,
        null,
        impl.favIconDataAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        GraphChangeStream_NodeDeleted_ParamsSpec.$,
        null,
        impl.nodeDeleted.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GraphChangeStream {
  static get $interfaceName(): string {
    return "discards.mojom.GraphChangeStream";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): GraphChangeStreamRemote {
    let remote = new GraphChangeStreamRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the GraphChangeStream
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GraphChangeStreamCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GraphChangeStreamRemote, GraphChangeStreamPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GraphChangeStreamRemote, GraphChangeStreamPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  frameCreated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  pageCreated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  processCreated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  workerCreated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  frameChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  pageChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  processChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  workerChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  favIconDataAvailable: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  nodeDeleted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GraphChangeStreamRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.frameCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GraphChangeStream_FrameCreated_ParamsSpec.$,
        null,
        this.frameCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.pageCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        GraphChangeStream_PageCreated_ParamsSpec.$,
        null,
        this.pageCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.processCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        GraphChangeStream_ProcessCreated_ParamsSpec.$,
        null,
        this.processCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.workerCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        GraphChangeStream_WorkerCreated_ParamsSpec.$,
        null,
        this.workerCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.frameChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        GraphChangeStream_FrameChanged_ParamsSpec.$,
        null,
        this.frameChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.pageChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        GraphChangeStream_PageChanged_ParamsSpec.$,
        null,
        this.pageChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.processChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        GraphChangeStream_ProcessChanged_ParamsSpec.$,
        null,
        this.processChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.workerChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        GraphChangeStream_WorkerChanged_ParamsSpec.$,
        null,
        this.workerChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.favIconDataAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        GraphChangeStream_FavIconDataAvailable_ParamsSpec.$,
        null,
        this.favIconDataAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    this.nodeDeleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        GraphChangeStream_NodeDeleted_ParamsSpec.$,
        null,
        this.nodeDeleted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type GraphDumpPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<GraphDumpPendingReceiver>;

export class GraphDumpPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<GraphDump> {

  handle: mojo.internal.interfaceSupport.Endpoint<GraphDumpPendingReceiver>;
  constructor(handle: MojoHandle|GraphDumpPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'discards.mojom.GraphDump',
        scope);
  }
}

export interface GraphDumpInterface {
  subscribeToChanges(changeSubscriber: GraphChangeStreamRemote): void;
  requestNodeDescriptions(nodeIds: bigint[]): Promise<{
        nodeDescriptionsJson: Map<bigint, string>, }>;
}

export class GraphDumpRemote implements GraphDumpInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<GraphDumpPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<GraphDumpPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|GraphDumpPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GraphDumpPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  subscribeToChanges(
      changeSubscriber: GraphChangeStreamRemote): void {
    this.proxy.sendMessage(
        0,
        GraphDump_SubscribeToChanges_ParamsSpec.$,
        null,
        [
          changeSubscriber
        ],
        false);
  }

  requestNodeDescriptions(
      nodeIds: bigint[]): Promise<{
        nodeDescriptionsJson: Map<bigint, string>, }> {
    return this.proxy.sendMessage(
        1,
        GraphDump_RequestNodeDescriptions_ParamsSpec.$,
        GraphDump_RequestNodeDescriptions_ResponseParamsSpec.$,
        [
          nodeIds
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GraphDump
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GraphDumpReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GraphDumpRemote, GraphDumpPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GraphDumpRemote, GraphDumpPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: GraphDumpInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GraphDumpRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GraphDump_SubscribeToChanges_ParamsSpec.$,
        null,
        impl.subscribeToChanges.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        GraphDump_RequestNodeDescriptions_ParamsSpec.$,
        GraphDump_RequestNodeDescriptions_ResponseParamsSpec.$,
        impl.requestNodeDescriptions.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GraphDump {
  static get $interfaceName(): string {
    return "discards.mojom.GraphDump";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): GraphDumpRemote {
    let remote = new GraphDumpRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the GraphDump
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GraphDumpCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GraphDumpRemote, GraphDumpPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GraphDumpRemote, GraphDumpPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  subscribeToChanges: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestNodeDescriptions: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GraphDumpRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.subscribeToChanges =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GraphDump_SubscribeToChanges_ParamsSpec.$,
        null,
        this.subscribeToChanges.createReceiverHandler(false /* expectsResponse */),
        false);
    this.requestNodeDescriptions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        GraphDump_RequestNodeDescriptions_ParamsSpec.$,
        GraphDump_RequestNodeDescriptions_ResponseParamsSpec.$,
        this.requestNodeDescriptions.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const TabDiscardsInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FrameInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProcessInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WorkerInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FavIconInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DetailsProvider_GetTabDiscardsInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DetailsProvider_GetTabDiscardsInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DetailsProvider_SetAutoDiscardable_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DetailsProvider_SetAutoDiscardable_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DetailsProvider_DiscardById_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DetailsProvider_DiscardById_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DetailsProvider_FreezeById_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DetailsProvider_LoadById_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DetailsProvider_Discard_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DetailsProvider_Discard_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DetailsProvider_ToggleBatterySaverMode_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DetailsProvider_RefreshPerformanceTabCpuMeasurements_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GraphChangeStream_FrameCreated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GraphChangeStream_PageCreated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GraphChangeStream_ProcessCreated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GraphChangeStream_WorkerCreated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GraphChangeStream_FrameChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GraphChangeStream_PageChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GraphChangeStream_ProcessChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GraphChangeStream_WorkerChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GraphChangeStream_FavIconDataAvailable_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GraphChangeStream_NodeDeleted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GraphDump_SubscribeToChanges_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GraphDump_RequestNodeDescriptions_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GraphDump_RequestNodeDescriptions_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface TabDiscardsInfoMojoType {
  tabUrl: string;
  title: string;
  visibility: LifecycleUnitVisibility;
  loadingState: mojom_LifecycleUnitLoadingState;
  state: mojom_LifecycleUnitState;
  canDiscard: boolean;
  isAutoDiscardable: boolean;
  hasFocus: boolean;
  cannotDiscardReasons: string[];
  canFreeze: CanFreeze;
  discardCount: number;
  cannotFreezeReasons: string[];
  discardReason: mojom_LifecycleUnitDiscardReason;
  utilityRank: number;
  lastActiveSeconds: number;
  id: number;
  siteEngagementScore: number;
  stateChangeTime: mojoBase_mojom_TimeDelta;
}


export type TabDiscardsInfo = TabDiscardsInfoMojoType;
mojo.internal.Struct<TabDiscardsInfoMojoType>(
    TabDiscardsInfoSpec.$,
    'TabDiscardsInfo',
    [
      mojo.internal.StructField<TabDiscardsInfoMojoType, string>(
        'tabUrl', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, string>(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, LifecycleUnitVisibility>(
        'visibility', 16,
        0,
        LifecycleUnitVisibilitySpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, mojom_LifecycleUnitLoadingState>(
        'loadingState', 20,
        0,
        mojom_LifecycleUnitLoadingStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, mojom_LifecycleUnitState>(
        'state', 24,
        0,
        mojom_LifecycleUnitStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, boolean>(
        'canDiscard', 28,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, string[]>(
        'cannotDiscardReasons', 32,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, CanFreeze>(
        'canFreeze', 40,
        0,
        CanFreezeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, string[]>(
        'cannotFreezeReasons', 48,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, number>(
        'discardCount', 44,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, mojom_LifecycleUnitDiscardReason>(
        'discardReason', 56,
        0,
        mojom_LifecycleUnitDiscardReasonSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, number>(
        'utilityRank', 60,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, number>(
        'lastActiveSeconds', 64,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, number>(
        'id', 68,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, boolean>(
        'isAutoDiscardable', 28,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, number>(
        'siteEngagementScore', 72,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, boolean>(
        'hasFocus', 28,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDiscardsInfoMojoType, mojoBase_mojom_TimeDelta>(
        'stateChangeTime', 80,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 96],]);





export interface PageInfoMojoType {
  id: bigint;
  mainFrameUrl: url_mojom_Url;
  openerFrameId: bigint;
  embedderFrameId: bigint;
  descriptionJson: string;
}


export type PageInfo = PageInfoMojoType;
mojo.internal.Struct<PageInfoMojoType>(
    PageInfoSpec.$,
    'PageInfo',
    [
      mojo.internal.StructField<PageInfoMojoType, bigint>(
        'id', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageInfoMojoType, url_mojom_Url>(
        'mainFrameUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageInfoMojoType, bigint>(
        'openerFrameId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageInfoMojoType, bigint>(
        'embedderFrameId', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageInfoMojoType, string>(
        'descriptionJson', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface FrameInfoMojoType {
  id: bigint;
  url: url_mojom_Url;
  pageId: bigint;
  parentFrameId: bigint;
  processId: bigint;
  descriptionJson: string;
}


export type FrameInfo = FrameInfoMojoType;
mojo.internal.Struct<FrameInfoMojoType>(
    FrameInfoSpec.$,
    'FrameInfo',
    [
      mojo.internal.StructField<FrameInfoMojoType, bigint>(
        'id', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FrameInfoMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FrameInfoMojoType, bigint>(
        'pageId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FrameInfoMojoType, bigint>(
        'parentFrameId', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FrameInfoMojoType, bigint>(
        'processId', 32,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FrameInfoMojoType, string>(
        'descriptionJson', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface ProcessInfoMojoType {
  id: bigint;
  pid: mojoBase_mojom_ProcessId;
  privateFootprintKb: bigint;
  descriptionJson: string;
}


export type ProcessInfo = ProcessInfoMojoType;
mojo.internal.Struct<ProcessInfoMojoType>(
    ProcessInfoSpec.$,
    'ProcessInfo',
    [
      mojo.internal.StructField<ProcessInfoMojoType, bigint>(
        'id', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProcessInfoMojoType, mojoBase_mojom_ProcessId>(
        'pid', 8,
        0,
        mojoBase_mojom_ProcessIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProcessInfoMojoType, bigint>(
        'privateFootprintKb', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProcessInfoMojoType, string>(
        'descriptionJson', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface WorkerInfoMojoType {
  id: bigint;
  url: url_mojom_Url;
  processId: bigint;
  clientFrameIds: bigint[];
  clientWorkerIds: bigint[];
  childWorkerIds: bigint[];
  descriptionJson: string;
}


export type WorkerInfo = WorkerInfoMojoType;
mojo.internal.Struct<WorkerInfoMojoType>(
    WorkerInfoSpec.$,
    'WorkerInfo',
    [
      mojo.internal.StructField<WorkerInfoMojoType, bigint>(
        'id', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WorkerInfoMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WorkerInfoMojoType, bigint>(
        'processId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WorkerInfoMojoType, bigint[]>(
        'clientFrameIds', 24,
        0,
        mojo.internal.Array(mojo.internal.Int64, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WorkerInfoMojoType, bigint[]>(
        'clientWorkerIds', 32,
        0,
        mojo.internal.Array(mojo.internal.Int64, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WorkerInfoMojoType, bigint[]>(
        'childWorkerIds', 40,
        0,
        mojo.internal.Array(mojo.internal.Int64, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WorkerInfoMojoType, string>(
        'descriptionJson', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 64],]);





export interface FavIconInfoMojoType {
  nodeId: bigint;
  iconData: string;
}


export type FavIconInfo = FavIconInfoMojoType;
mojo.internal.Struct<FavIconInfoMojoType>(
    FavIconInfoSpec.$,
    'FavIconInfo',
    [
      mojo.internal.StructField<FavIconInfoMojoType, bigint>(
        'nodeId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FavIconInfoMojoType, string>(
        'iconData', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface DetailsProvider_GetTabDiscardsInfo_ParamsMojoType {
}


export type DetailsProvider_GetTabDiscardsInfo_Params = DetailsProvider_GetTabDiscardsInfo_ParamsMojoType;
mojo.internal.Struct<DetailsProvider_GetTabDiscardsInfo_ParamsMojoType>(
    DetailsProvider_GetTabDiscardsInfo_ParamsSpec.$,
    'DetailsProvider_GetTabDiscardsInfo_Params',
    [
    ],
    [[0, 8],]);





export interface DetailsProvider_GetTabDiscardsInfo_ResponseParamsMojoType {
  infos: TabDiscardsInfo[];
}


export type DetailsProvider_GetTabDiscardsInfo_ResponseParams = DetailsProvider_GetTabDiscardsInfo_ResponseParamsMojoType;
mojo.internal.Struct<DetailsProvider_GetTabDiscardsInfo_ResponseParamsMojoType>(
    DetailsProvider_GetTabDiscardsInfo_ResponseParamsSpec.$,
    'DetailsProvider_GetTabDiscardsInfo_ResponseParams',
    [
      mojo.internal.StructField<DetailsProvider_GetTabDiscardsInfo_ResponseParamsMojoType, TabDiscardsInfo[]>(
        'infos', 0,
        0,
        mojo.internal.Array(TabDiscardsInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface DetailsProvider_SetAutoDiscardable_ParamsMojoType {
  tabId: number;
  isAutoDiscardable: boolean;
}


export type DetailsProvider_SetAutoDiscardable_Params = DetailsProvider_SetAutoDiscardable_ParamsMojoType;
mojo.internal.Struct<DetailsProvider_SetAutoDiscardable_ParamsMojoType>(
    DetailsProvider_SetAutoDiscardable_ParamsSpec.$,
    'DetailsProvider_SetAutoDiscardable_Params',
    [
      mojo.internal.StructField<DetailsProvider_SetAutoDiscardable_ParamsMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DetailsProvider_SetAutoDiscardable_ParamsMojoType, boolean>(
        'isAutoDiscardable', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface DetailsProvider_SetAutoDiscardable_ResponseParamsMojoType {
}


export type DetailsProvider_SetAutoDiscardable_ResponseParams = DetailsProvider_SetAutoDiscardable_ResponseParamsMojoType;
mojo.internal.Struct<DetailsProvider_SetAutoDiscardable_ResponseParamsMojoType>(
    DetailsProvider_SetAutoDiscardable_ResponseParamsSpec.$,
    'DetailsProvider_SetAutoDiscardable_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface DetailsProvider_DiscardById_ParamsMojoType {
  tabId: number;
  reason: mojom_LifecycleUnitDiscardReason;
}


export type DetailsProvider_DiscardById_Params = DetailsProvider_DiscardById_ParamsMojoType;
mojo.internal.Struct<DetailsProvider_DiscardById_ParamsMojoType>(
    DetailsProvider_DiscardById_ParamsSpec.$,
    'DetailsProvider_DiscardById_Params',
    [
      mojo.internal.StructField<DetailsProvider_DiscardById_ParamsMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DetailsProvider_DiscardById_ParamsMojoType, mojom_LifecycleUnitDiscardReason>(
        'reason', 4,
        0,
        mojom_LifecycleUnitDiscardReasonSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface DetailsProvider_DiscardById_ResponseParamsMojoType {
}


export type DetailsProvider_DiscardById_ResponseParams = DetailsProvider_DiscardById_ResponseParamsMojoType;
mojo.internal.Struct<DetailsProvider_DiscardById_ResponseParamsMojoType>(
    DetailsProvider_DiscardById_ResponseParamsSpec.$,
    'DetailsProvider_DiscardById_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface DetailsProvider_FreezeById_ParamsMojoType {
  tabId: number;
}


export type DetailsProvider_FreezeById_Params = DetailsProvider_FreezeById_ParamsMojoType;
mojo.internal.Struct<DetailsProvider_FreezeById_ParamsMojoType>(
    DetailsProvider_FreezeById_ParamsSpec.$,
    'DetailsProvider_FreezeById_Params',
    [
      mojo.internal.StructField<DetailsProvider_FreezeById_ParamsMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface DetailsProvider_LoadById_ParamsMojoType {
  tabId: number;
}


export type DetailsProvider_LoadById_Params = DetailsProvider_LoadById_ParamsMojoType;
mojo.internal.Struct<DetailsProvider_LoadById_ParamsMojoType>(
    DetailsProvider_LoadById_ParamsSpec.$,
    'DetailsProvider_LoadById_Params',
    [
      mojo.internal.StructField<DetailsProvider_LoadById_ParamsMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface DetailsProvider_Discard_ParamsMojoType {
}


export type DetailsProvider_Discard_Params = DetailsProvider_Discard_ParamsMojoType;
mojo.internal.Struct<DetailsProvider_Discard_ParamsMojoType>(
    DetailsProvider_Discard_ParamsSpec.$,
    'DetailsProvider_Discard_Params',
    [
    ],
    [[0, 8],]);





export interface DetailsProvider_Discard_ResponseParamsMojoType {
}


export type DetailsProvider_Discard_ResponseParams = DetailsProvider_Discard_ResponseParamsMojoType;
mojo.internal.Struct<DetailsProvider_Discard_ResponseParamsMojoType>(
    DetailsProvider_Discard_ResponseParamsSpec.$,
    'DetailsProvider_Discard_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface DetailsProvider_ToggleBatterySaverMode_ParamsMojoType {
}


export type DetailsProvider_ToggleBatterySaverMode_Params = DetailsProvider_ToggleBatterySaverMode_ParamsMojoType;
mojo.internal.Struct<DetailsProvider_ToggleBatterySaverMode_ParamsMojoType>(
    DetailsProvider_ToggleBatterySaverMode_ParamsSpec.$,
    'DetailsProvider_ToggleBatterySaverMode_Params',
    [
    ],
    [[0, 8],]);





export interface DetailsProvider_RefreshPerformanceTabCpuMeasurements_ParamsMojoType {
}


export type DetailsProvider_RefreshPerformanceTabCpuMeasurements_Params = DetailsProvider_RefreshPerformanceTabCpuMeasurements_ParamsMojoType;
mojo.internal.Struct<DetailsProvider_RefreshPerformanceTabCpuMeasurements_ParamsMojoType>(
    DetailsProvider_RefreshPerformanceTabCpuMeasurements_ParamsSpec.$,
    'DetailsProvider_RefreshPerformanceTabCpuMeasurements_Params',
    [
    ],
    [[0, 8],]);





export interface GraphChangeStream_FrameCreated_ParamsMojoType {
  frame: FrameInfo;
}


export type GraphChangeStream_FrameCreated_Params = GraphChangeStream_FrameCreated_ParamsMojoType;
mojo.internal.Struct<GraphChangeStream_FrameCreated_ParamsMojoType>(
    GraphChangeStream_FrameCreated_ParamsSpec.$,
    'GraphChangeStream_FrameCreated_Params',
    [
      mojo.internal.StructField<GraphChangeStream_FrameCreated_ParamsMojoType, FrameInfo>(
        'frame', 0,
        0,
        FrameInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GraphChangeStream_PageCreated_ParamsMojoType {
  pages: PageInfo;
}


export type GraphChangeStream_PageCreated_Params = GraphChangeStream_PageCreated_ParamsMojoType;
mojo.internal.Struct<GraphChangeStream_PageCreated_ParamsMojoType>(
    GraphChangeStream_PageCreated_ParamsSpec.$,
    'GraphChangeStream_PageCreated_Params',
    [
      mojo.internal.StructField<GraphChangeStream_PageCreated_ParamsMojoType, PageInfo>(
        'pages', 0,
        0,
        PageInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GraphChangeStream_ProcessCreated_ParamsMojoType {
  process: ProcessInfo;
}


export type GraphChangeStream_ProcessCreated_Params = GraphChangeStream_ProcessCreated_ParamsMojoType;
mojo.internal.Struct<GraphChangeStream_ProcessCreated_ParamsMojoType>(
    GraphChangeStream_ProcessCreated_ParamsSpec.$,
    'GraphChangeStream_ProcessCreated_Params',
    [
      mojo.internal.StructField<GraphChangeStream_ProcessCreated_ParamsMojoType, ProcessInfo>(
        'process', 0,
        0,
        ProcessInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GraphChangeStream_WorkerCreated_ParamsMojoType {
  worker: WorkerInfo;
}


export type GraphChangeStream_WorkerCreated_Params = GraphChangeStream_WorkerCreated_ParamsMojoType;
mojo.internal.Struct<GraphChangeStream_WorkerCreated_ParamsMojoType>(
    GraphChangeStream_WorkerCreated_ParamsSpec.$,
    'GraphChangeStream_WorkerCreated_Params',
    [
      mojo.internal.StructField<GraphChangeStream_WorkerCreated_ParamsMojoType, WorkerInfo>(
        'worker', 0,
        0,
        WorkerInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GraphChangeStream_FrameChanged_ParamsMojoType {
  frame: FrameInfo;
}


export type GraphChangeStream_FrameChanged_Params = GraphChangeStream_FrameChanged_ParamsMojoType;
mojo.internal.Struct<GraphChangeStream_FrameChanged_ParamsMojoType>(
    GraphChangeStream_FrameChanged_ParamsSpec.$,
    'GraphChangeStream_FrameChanged_Params',
    [
      mojo.internal.StructField<GraphChangeStream_FrameChanged_ParamsMojoType, FrameInfo>(
        'frame', 0,
        0,
        FrameInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GraphChangeStream_PageChanged_ParamsMojoType {
  page: PageInfo;
}


export type GraphChangeStream_PageChanged_Params = GraphChangeStream_PageChanged_ParamsMojoType;
mojo.internal.Struct<GraphChangeStream_PageChanged_ParamsMojoType>(
    GraphChangeStream_PageChanged_ParamsSpec.$,
    'GraphChangeStream_PageChanged_Params',
    [
      mojo.internal.StructField<GraphChangeStream_PageChanged_ParamsMojoType, PageInfo>(
        'page', 0,
        0,
        PageInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GraphChangeStream_ProcessChanged_ParamsMojoType {
  process: ProcessInfo;
}


export type GraphChangeStream_ProcessChanged_Params = GraphChangeStream_ProcessChanged_ParamsMojoType;
mojo.internal.Struct<GraphChangeStream_ProcessChanged_ParamsMojoType>(
    GraphChangeStream_ProcessChanged_ParamsSpec.$,
    'GraphChangeStream_ProcessChanged_Params',
    [
      mojo.internal.StructField<GraphChangeStream_ProcessChanged_ParamsMojoType, ProcessInfo>(
        'process', 0,
        0,
        ProcessInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GraphChangeStream_WorkerChanged_ParamsMojoType {
  worker: WorkerInfo;
}


export type GraphChangeStream_WorkerChanged_Params = GraphChangeStream_WorkerChanged_ParamsMojoType;
mojo.internal.Struct<GraphChangeStream_WorkerChanged_ParamsMojoType>(
    GraphChangeStream_WorkerChanged_ParamsSpec.$,
    'GraphChangeStream_WorkerChanged_Params',
    [
      mojo.internal.StructField<GraphChangeStream_WorkerChanged_ParamsMojoType, WorkerInfo>(
        'worker', 0,
        0,
        WorkerInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GraphChangeStream_FavIconDataAvailable_ParamsMojoType {
  favicon: FavIconInfo;
}


export type GraphChangeStream_FavIconDataAvailable_Params = GraphChangeStream_FavIconDataAvailable_ParamsMojoType;
mojo.internal.Struct<GraphChangeStream_FavIconDataAvailable_ParamsMojoType>(
    GraphChangeStream_FavIconDataAvailable_ParamsSpec.$,
    'GraphChangeStream_FavIconDataAvailable_Params',
    [
      mojo.internal.StructField<GraphChangeStream_FavIconDataAvailable_ParamsMojoType, FavIconInfo>(
        'favicon', 0,
        0,
        FavIconInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GraphChangeStream_NodeDeleted_ParamsMojoType {
  nodeId: bigint;
}


export type GraphChangeStream_NodeDeleted_Params = GraphChangeStream_NodeDeleted_ParamsMojoType;
mojo.internal.Struct<GraphChangeStream_NodeDeleted_ParamsMojoType>(
    GraphChangeStream_NodeDeleted_ParamsSpec.$,
    'GraphChangeStream_NodeDeleted_Params',
    [
      mojo.internal.StructField<GraphChangeStream_NodeDeleted_ParamsMojoType, bigint>(
        'nodeId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GraphDump_SubscribeToChanges_ParamsMojoType {
  changeSubscriber: GraphChangeStreamRemote;
}


export type GraphDump_SubscribeToChanges_Params = GraphDump_SubscribeToChanges_ParamsMojoType;
mojo.internal.Struct<GraphDump_SubscribeToChanges_ParamsMojoType>(
    GraphDump_SubscribeToChanges_ParamsSpec.$,
    'GraphDump_SubscribeToChanges_Params',
    [
      mojo.internal.StructField<GraphDump_SubscribeToChanges_ParamsMojoType, GraphChangeStreamRemote>(
        'changeSubscriber', 0,
        0,
        mojo.internal.InterfaceProxy(GraphChangeStreamRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GraphDump_RequestNodeDescriptions_ParamsMojoType {
  nodeIds: bigint[];
}


export type GraphDump_RequestNodeDescriptions_Params = GraphDump_RequestNodeDescriptions_ParamsMojoType;
mojo.internal.Struct<GraphDump_RequestNodeDescriptions_ParamsMojoType>(
    GraphDump_RequestNodeDescriptions_ParamsSpec.$,
    'GraphDump_RequestNodeDescriptions_Params',
    [
      mojo.internal.StructField<GraphDump_RequestNodeDescriptions_ParamsMojoType, bigint[]>(
        'nodeIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Int64, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GraphDump_RequestNodeDescriptions_ResponseParamsMojoType {
  nodeDescriptionsJson: Map<bigint, string>;
}


export type GraphDump_RequestNodeDescriptions_ResponseParams = GraphDump_RequestNodeDescriptions_ResponseParamsMojoType;
mojo.internal.Struct<GraphDump_RequestNodeDescriptions_ResponseParamsMojoType>(
    GraphDump_RequestNodeDescriptions_ResponseParamsSpec.$,
    'GraphDump_RequestNodeDescriptions_ResponseParams',
    [
      mojo.internal.StructField<GraphDump_RequestNodeDescriptions_ResponseParamsMojoType, Map<bigint, string>>(
        'nodeDescriptionsJson', 0,
        0,
        mojo.internal.Map(mojo.internal.Int64, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



