// chrome/browser/ui/webui/discards/discards.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DISCARDS_DISCARDS_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_UI_WEBUI_DISCARDS_DISCARDS_MOJOM_TEST_UTILS_H_

#include "chrome/browser/ui/webui/discards/discards.mojom.h"


namespace discards::mojom {


class  DetailsProviderInterceptorForTesting : public DetailsProvider {
  virtual DetailsProvider* GetForwardingInterface() = 0;
  void GetTabDiscardsInfo(GetTabDiscardsInfoCallback callback) override;
  void SetAutoDiscardable(int32_t tab_id, bool is_auto_discardable, SetAutoDiscardableCallback callback) override;
  void DiscardById(int32_t tab_id, ::mojom::LifecycleUnitDiscardReason reason, DiscardByIdCallback callback) override;
  void FreezeById(int32_t tab_id) override;
  void LoadById(int32_t tab_id) override;
  void Discard(DiscardCallback callback) override;
  void ToggleBatterySaverMode() override;
  void RefreshPerformanceTabCpuMeasurements() override;
};
class  DetailsProviderAsyncWaiter {
 public:
  explicit DetailsProviderAsyncWaiter(DetailsProvider* proxy);

  DetailsProviderAsyncWaiter(const DetailsProviderAsyncWaiter&) = delete;
  DetailsProviderAsyncWaiter& operator=(const DetailsProviderAsyncWaiter&) = delete;

  ~DetailsProviderAsyncWaiter();
  void GetTabDiscardsInfo(
      std::vector<TabDiscardsInfoPtr>* out_infos);
  std::vector<TabDiscardsInfoPtr> GetTabDiscardsInfo();
  void SetAutoDiscardable(
      int32_t tab_id, bool is_auto_discardable);
  
  void DiscardById(
      int32_t tab_id, ::mojom::LifecycleUnitDiscardReason reason);
  
  void Discard(
      );
  

 private:
  DetailsProvider* const proxy_;
};


class  GraphChangeStreamInterceptorForTesting : public GraphChangeStream {
  virtual GraphChangeStream* GetForwardingInterface() = 0;
  void FrameCreated(FrameInfoPtr frame) override;
  void PageCreated(PageInfoPtr pages) override;
  void ProcessCreated(ProcessInfoPtr process) override;
  void WorkerCreated(WorkerInfoPtr worker) override;
  void FrameChanged(FrameInfoPtr frame) override;
  void PageChanged(PageInfoPtr page) override;
  void ProcessChanged(ProcessInfoPtr process) override;
  void WorkerChanged(WorkerInfoPtr worker) override;
  void FavIconDataAvailable(FavIconInfoPtr favicon) override;
  void NodeDeleted(int64_t node_id) override;
};
class  GraphChangeStreamAsyncWaiter {
 public:
  explicit GraphChangeStreamAsyncWaiter(GraphChangeStream* proxy);

  GraphChangeStreamAsyncWaiter(const GraphChangeStreamAsyncWaiter&) = delete;
  GraphChangeStreamAsyncWaiter& operator=(const GraphChangeStreamAsyncWaiter&) = delete;

  ~GraphChangeStreamAsyncWaiter();

 private:
  GraphChangeStream* const proxy_;
};


class  GraphDumpInterceptorForTesting : public GraphDump {
  virtual GraphDump* GetForwardingInterface() = 0;
  void SubscribeToChanges(::mojo::PendingRemote<GraphChangeStream> change_subscriber) override;
  void RequestNodeDescriptions(const std::vector<int64_t>& node_ids, RequestNodeDescriptionsCallback callback) override;
};
class  GraphDumpAsyncWaiter {
 public:
  explicit GraphDumpAsyncWaiter(GraphDump* proxy);

  GraphDumpAsyncWaiter(const GraphDumpAsyncWaiter&) = delete;
  GraphDumpAsyncWaiter& operator=(const GraphDumpAsyncWaiter&) = delete;

  ~GraphDumpAsyncWaiter();
  void RequestNodeDescriptions(
      const std::vector<int64_t>& node_ids, base::flat_map<int64_t, std::string>* out_node_descriptions_json);
  base::flat_map<int64_t, std::string> RequestNodeDescriptions(const std::vector<int64_t>& node_ids);

 private:
  GraphDump* const proxy_;
};




}  // discards::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_DISCARDS_DISCARDS_MOJOM_TEST_UTILS_H_