// chrome/browser/ui/webui/data_sharing/data_sharing.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-forward.h"  // IWYU pragma: export
#include "components/data_sharing/public/protocol/group_data.mojom.h"
#include "mojo/public/mojom/base/absl_status.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace data_sharing::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "data_sharing.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "data_sharing.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kShowUIMinVersion = 0,
    kCloseUIMinVersion = 0,
    kApiInitCompleteMinVersion = 0,
    kMakeTabGroupSharedMinVersion = 0,
    kGetShareLinkMinVersion = 0,
    kGetTabGroupPreviewMinVersion = 0,
    kOpenTabGroupMinVersion = 0,
    kAboutToUnShareTabGroupMinVersion = 0,
    kOnTabGroupUnShareCompleteMinVersion = 0,
    kOnGroupActionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ShowUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ApiInitComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MakeTabGroupShared_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetShareLink_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTabGroupPreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenTabGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AboutToUnShareTabGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTabGroupUnShareComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnGroupAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void ShowUI() = 0;

  virtual void CloseUI(int32_t status_code) = 0;

  virtual void ApiInitComplete() = 0;

  using MakeTabGroupSharedCallback = base::OnceCallback<void(const std::optional<::GURL>&)>;
  using MakeTabGroupSharedMojoCallback = base::OnceCallback<void(const std::optional<::GURL>&)>;

  virtual void MakeTabGroupShared(const std::string& tab_group_id, const std::string& group_id, const std::string& access_token, MakeTabGroupSharedCallback callback) = 0;

  using GetShareLinkCallback = base::OnceCallback<void(const ::GURL&)>;
  using GetShareLinkMojoCallback = base::OnceCallback<void(const ::GURL&)>;

  virtual void GetShareLink(const std::string& group_id, const std::string& access_token, GetShareLinkCallback callback) = 0;

  using GetTabGroupPreviewCallback = base::OnceCallback<void(GroupPreviewPtr)>;
  using GetTabGroupPreviewMojoCallback = base::OnceCallback<void(GroupPreviewPtr)>;

  virtual void GetTabGroupPreview(const std::string& group_id, const std::string& access_token, GetTabGroupPreviewCallback callback) = 0;

  virtual void OpenTabGroup(const std::string& group_id) = 0;

  virtual void AboutToUnShareTabGroup(const std::string& tab_group_id) = 0;

  virtual void OnTabGroupUnShareComplete(const std::string& tab_group_id) = 0;

  virtual void OnGroupAction(GroupAction action, GroupActionProgress progress) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;
class PageResponseValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "data_sharing.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = PageResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnAccessTokenFetchedMinVersion = 0,
    kReadGroupsMinVersion = 0,
    kReadGroupWithTokenMinVersion = 0,
    kDeleteGroupMinVersion = 0,
    kLeaveGroupMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnAccessTokenFetched_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadGroups_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadGroupWithToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LeaveGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnAccessTokenFetched(const std::string& access_token) = 0;

  using ReadGroupsCallback = base::OnceCallback<void(ReadGroupsResultPtr)>;
  using ReadGroupsMojoCallback = base::OnceCallback<void(ReadGroupsResultPtr)>;

  virtual void ReadGroups(ReadGroupsParamsPtr read_groups_params, ReadGroupsCallback callback) = 0;

  using ReadGroupWithTokenCallback = base::OnceCallback<void(ReadGroupWithTokenResultPtr)>;
  using ReadGroupWithTokenMojoCallback = base::OnceCallback<void(ReadGroupWithTokenResultPtr)>;

  virtual void ReadGroupWithToken(ReadGroupWithTokenParamPtr param, ReadGroupWithTokenCallback callback) = 0;

  using DeleteGroupCallback = base::OnceCallback<void(int32_t)>;
  using DeleteGroupMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void DeleteGroup(const std::string& group_id, DeleteGroupCallback callback) = 0;

  using LeaveGroupCallback = base::OnceCallback<void(int32_t)>;
  using LeaveGroupMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void LeaveGroup(const std::string& group_id, LeaveGroupCallback callback) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ShowUI() final;
  
  void CloseUI(int32_t status_code) final;
  
  void ApiInitComplete() final;
  
  void MakeTabGroupShared(const std::string& tab_group_id, const std::string& group_id, const std::string& access_token, MakeTabGroupSharedCallback callback) final;
  
  void GetShareLink(const std::string& group_id, const std::string& access_token, GetShareLinkCallback callback) final;
  
  void GetTabGroupPreview(const std::string& group_id, const std::string& access_token, GetTabGroupPreviewCallback callback) final;
  
  void OpenTabGroup(const std::string& group_id) final;
  
  void AboutToUnShareTabGroup(const std::string& tab_group_id) final;
  
  void OnTabGroupUnShareComplete(const std::string& tab_group_id) final;
  
  void OnGroupAction(GroupAction action, GroupActionProgress progress) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnAccessTokenFetched(const std::string& access_token) final;
  
  void ReadGroups(ReadGroupsParamsPtr read_groups_params, ReadGroupsCallback callback) final;
  
  void ReadGroupWithToken(ReadGroupWithTokenParamPtr param, ReadGroupWithTokenCallback callback) final;
  
  void DeleteGroup(const std::string& group_id, DeleteGroupCallback callback) final;
  
  void LeaveGroup(const std::string& group_id, LeaveGroupCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  ReadGroupParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadGroupParams, T>::value>;
  using DataView = ReadGroupParamsDataView;
  using Data_ = internal::ReadGroupParams_Data;

  template <typename... Args>
  static ReadGroupParamsPtr New(Args&&... args) {
    return ReadGroupParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadGroupParamsPtr From(const U& u) {
    return mojo::TypeConverter<ReadGroupParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadGroupParams>::Convert(*this);
  }


  ReadGroupParams();

  ReadGroupParams(
      const std::string& group_id,
      const std::string& consistency_token);


  ~ReadGroupParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadGroupParamsPtr>
  ReadGroupParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadGroupParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReadGroupParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReadGroupParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadGroupParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadGroupParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadGroupParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadGroupParams_UnserializedMessageContext<
            UserType, ReadGroupParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReadGroupParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReadGroupParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadGroupParams_UnserializedMessageContext<
            UserType, ReadGroupParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadGroupParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string group_id;
  
  std::string consistency_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadGroupParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadGroupParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadGroupParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadGroupParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ReadGroupWithTokenParam {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadGroupWithTokenParam, T>::value>;
  using DataView = ReadGroupWithTokenParamDataView;
  using Data_ = internal::ReadGroupWithTokenParam_Data;

  template <typename... Args>
  static ReadGroupWithTokenParamPtr New(Args&&... args) {
    return ReadGroupWithTokenParamPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadGroupWithTokenParamPtr From(const U& u) {
    return mojo::TypeConverter<ReadGroupWithTokenParamPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadGroupWithTokenParam>::Convert(*this);
  }


  ReadGroupWithTokenParam();

  ReadGroupWithTokenParam(
      const std::string& group_id,
      const std::string& access_token);


  ~ReadGroupWithTokenParam();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadGroupWithTokenParamPtr>
  ReadGroupWithTokenParamPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadGroupWithTokenParam::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReadGroupWithTokenParam::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReadGroupWithTokenParam::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadGroupWithTokenParam::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadGroupWithTokenParam::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadGroupWithTokenParam::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadGroupWithTokenParam_UnserializedMessageContext<
            UserType, ReadGroupWithTokenParam::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReadGroupWithTokenParam::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReadGroupWithTokenParam::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadGroupWithTokenParam_UnserializedMessageContext<
            UserType, ReadGroupWithTokenParam::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadGroupWithTokenParam::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string group_id;
  
  std::string access_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadGroupWithTokenParam::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadGroupWithTokenParam::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadGroupWithTokenParam::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadGroupWithTokenParam::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  ReadGroupsParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadGroupsParams, T>::value>;
  using DataView = ReadGroupsParamsDataView;
  using Data_ = internal::ReadGroupsParams_Data;

  template <typename... Args>
  static ReadGroupsParamsPtr New(Args&&... args) {
    return ReadGroupsParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadGroupsParamsPtr From(const U& u) {
    return mojo::TypeConverter<ReadGroupsParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadGroupsParams>::Convert(*this);
  }


  ReadGroupsParams();

  explicit ReadGroupsParams(
      std::vector<ReadGroupParamsPtr> params);

ReadGroupsParams(const ReadGroupsParams&) = delete;
ReadGroupsParams& operator=(const ReadGroupsParams&) = delete;

  ~ReadGroupsParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadGroupsParamsPtr>
  ReadGroupsParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadGroupsParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReadGroupsParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReadGroupsParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadGroupsParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadGroupsParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadGroupsParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadGroupsParams_UnserializedMessageContext<
            UserType, ReadGroupsParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReadGroupsParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReadGroupsParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadGroupsParams_UnserializedMessageContext<
            UserType, ReadGroupsParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadGroupsParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<ReadGroupParamsPtr> params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadGroupsParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadGroupsParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadGroupsParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadGroupsParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ReadGroupsResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadGroupsResult, T>::value>;
  using DataView = ReadGroupsResultDataView;
  using Data_ = internal::ReadGroupsResult_Data;

  template <typename... Args>
  static ReadGroupsResultPtr New(Args&&... args) {
    return ReadGroupsResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadGroupsResultPtr From(const U& u) {
    return mojo::TypeConverter<ReadGroupsResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadGroupsResult>::Convert(*this);
  }


  ReadGroupsResult();

  ReadGroupsResult(
      std::vector<::data_sharing::mojom::GroupDataPtr> groups,
      int32_t status_code);

ReadGroupsResult(const ReadGroupsResult&) = delete;
ReadGroupsResult& operator=(const ReadGroupsResult&) = delete;

  ~ReadGroupsResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadGroupsResultPtr>
  ReadGroupsResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadGroupsResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReadGroupsResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReadGroupsResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadGroupsResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadGroupsResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadGroupsResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadGroupsResult_UnserializedMessageContext<
            UserType, ReadGroupsResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReadGroupsResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReadGroupsResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadGroupsResult_UnserializedMessageContext<
            UserType, ReadGroupsResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadGroupsResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::data_sharing::mojom::GroupDataPtr> groups;
  
  int32_t status_code;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadGroupsResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadGroupsResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadGroupsResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadGroupsResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ReadGroupWithTokenResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadGroupWithTokenResult, T>::value>;
  using DataView = ReadGroupWithTokenResultDataView;
  using Data_ = internal::ReadGroupWithTokenResult_Data;

  template <typename... Args>
  static ReadGroupWithTokenResultPtr New(Args&&... args) {
    return ReadGroupWithTokenResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadGroupWithTokenResultPtr From(const U& u) {
    return mojo::TypeConverter<ReadGroupWithTokenResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadGroupWithTokenResult>::Convert(*this);
  }


  ReadGroupWithTokenResult();

  ReadGroupWithTokenResult(
      ::data_sharing::mojom::GroupDataPtr group,
      int32_t status_code);

ReadGroupWithTokenResult(const ReadGroupWithTokenResult&) = delete;
ReadGroupWithTokenResult& operator=(const ReadGroupWithTokenResult&) = delete;

  ~ReadGroupWithTokenResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadGroupWithTokenResultPtr>
  ReadGroupWithTokenResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadGroupWithTokenResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReadGroupWithTokenResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReadGroupWithTokenResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadGroupWithTokenResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadGroupWithTokenResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadGroupWithTokenResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadGroupWithTokenResult_UnserializedMessageContext<
            UserType, ReadGroupWithTokenResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReadGroupWithTokenResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReadGroupWithTokenResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadGroupWithTokenResult_UnserializedMessageContext<
            UserType, ReadGroupWithTokenResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadGroupWithTokenResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::data_sharing::mojom::GroupDataPtr group;
  
  int32_t status_code;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadGroupWithTokenResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadGroupWithTokenResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadGroupWithTokenResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadGroupWithTokenResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SharedTab {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedTab, T>::value>;
  using DataView = SharedTabDataView;
  using Data_ = internal::SharedTab_Data;

  template <typename... Args>
  static SharedTabPtr New(Args&&... args) {
    return SharedTabPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedTabPtr From(const U& u) {
    return mojo::TypeConverter<SharedTabPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedTab>::Convert(*this);
  }


  SharedTab();

  SharedTab(
      const std::string& display_url,
      const ::GURL& favicon_url);


  ~SharedTab();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedTabPtr>
  SharedTabPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedTab::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedTab::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedTab::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedTab::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedTab::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedTab::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedTab_UnserializedMessageContext<
            UserType, SharedTab::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedTab::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedTab::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedTab_UnserializedMessageContext<
            UserType, SharedTab::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedTab::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string display_url;
  
  ::GURL favicon_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedTab::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedTab::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedTab::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedTab::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GroupPreview {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GroupPreview, T>::value>;
  using DataView = GroupPreviewDataView;
  using Data_ = internal::GroupPreview_Data;

  template <typename... Args>
  static GroupPreviewPtr New(Args&&... args) {
    return GroupPreviewPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GroupPreviewPtr From(const U& u) {
    return mojo::TypeConverter<GroupPreviewPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GroupPreview>::Convert(*this);
  }


  GroupPreview();

  GroupPreview(
      const std::string& title,
      std::vector<SharedTabPtr> shared_tabs,
      ::mojo_base::mojom::AbslStatusCode status_code);

GroupPreview(const GroupPreview&) = delete;
GroupPreview& operator=(const GroupPreview&) = delete;

  ~GroupPreview();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GroupPreviewPtr>
  GroupPreviewPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GroupPreview::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GroupPreview::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GroupPreview::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GroupPreview::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GroupPreview::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GroupPreview::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GroupPreview_UnserializedMessageContext<
            UserType, GroupPreview::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GroupPreview::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GroupPreview::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GroupPreview_UnserializedMessageContext<
            UserType, GroupPreview::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GroupPreview::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string title;
  
  std::vector<SharedTabPtr> shared_tabs;
  
  ::mojo_base::mojom::AbslStatusCode status_code;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GroupPreview::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GroupPreview::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GroupPreview::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GroupPreview::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ReadGroupsParamsPtr ReadGroupsParams::Clone() const {
  return New(
      mojo::Clone(params)
  );
}

template <typename T, ReadGroupsParams::EnableIfSame<T>*>
bool ReadGroupsParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  return true;
}

template <typename T, ReadGroupsParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.params < rhs.params)
    return true;
  if (rhs.params < lhs.params)
    return false;
  return false;
}
template <typename StructPtrType>
ReadGroupParamsPtr ReadGroupParams::Clone() const {
  return New(
      mojo::Clone(group_id),
      mojo::Clone(consistency_token)
  );
}

template <typename T, ReadGroupParams::EnableIfSame<T>*>
bool ReadGroupParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->consistency_token, other_struct.consistency_token))
    return false;
  return true;
}

template <typename T, ReadGroupParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  if (lhs.consistency_token < rhs.consistency_token)
    return true;
  if (rhs.consistency_token < lhs.consistency_token)
    return false;
  return false;
}
template <typename StructPtrType>
ReadGroupsResultPtr ReadGroupsResult::Clone() const {
  return New(
      mojo::Clone(groups),
      mojo::Clone(status_code)
  );
}

template <typename T, ReadGroupsResult::EnableIfSame<T>*>
bool ReadGroupsResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->groups, other_struct.groups))
    return false;
  if (!mojo::Equals(this->status_code, other_struct.status_code))
    return false;
  return true;
}

template <typename T, ReadGroupsResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.groups < rhs.groups)
    return true;
  if (rhs.groups < lhs.groups)
    return false;
  if (lhs.status_code < rhs.status_code)
    return true;
  if (rhs.status_code < lhs.status_code)
    return false;
  return false;
}
template <typename StructPtrType>
ReadGroupWithTokenParamPtr ReadGroupWithTokenParam::Clone() const {
  return New(
      mojo::Clone(group_id),
      mojo::Clone(access_token)
  );
}

template <typename T, ReadGroupWithTokenParam::EnableIfSame<T>*>
bool ReadGroupWithTokenParam::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->access_token, other_struct.access_token))
    return false;
  return true;
}

template <typename T, ReadGroupWithTokenParam::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  if (lhs.access_token < rhs.access_token)
    return true;
  if (rhs.access_token < lhs.access_token)
    return false;
  return false;
}
template <typename StructPtrType>
ReadGroupWithTokenResultPtr ReadGroupWithTokenResult::Clone() const {
  return New(
      mojo::Clone(group),
      mojo::Clone(status_code)
  );
}

template <typename T, ReadGroupWithTokenResult::EnableIfSame<T>*>
bool ReadGroupWithTokenResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->group, other_struct.group))
    return false;
  if (!mojo::Equals(this->status_code, other_struct.status_code))
    return false;
  return true;
}

template <typename T, ReadGroupWithTokenResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.group < rhs.group)
    return true;
  if (rhs.group < lhs.group)
    return false;
  if (lhs.status_code < rhs.status_code)
    return true;
  if (rhs.status_code < lhs.status_code)
    return false;
  return false;
}
template <typename StructPtrType>
SharedTabPtr SharedTab::Clone() const {
  return New(
      mojo::Clone(display_url),
      mojo::Clone(favicon_url)
  );
}

template <typename T, SharedTab::EnableIfSame<T>*>
bool SharedTab::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_url, other_struct.display_url))
    return false;
  if (!mojo::Equals(this->favicon_url, other_struct.favicon_url))
    return false;
  return true;
}

template <typename T, SharedTab::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.display_url < rhs.display_url)
    return true;
  if (rhs.display_url < lhs.display_url)
    return false;
  if (lhs.favicon_url < rhs.favicon_url)
    return true;
  if (rhs.favicon_url < lhs.favicon_url)
    return false;
  return false;
}
template <typename StructPtrType>
GroupPreviewPtr GroupPreview::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(shared_tabs),
      mojo::Clone(status_code)
  );
}

template <typename T, GroupPreview::EnableIfSame<T>*>
bool GroupPreview::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->shared_tabs, other_struct.shared_tabs))
    return false;
  if (!mojo::Equals(this->status_code, other_struct.status_code))
    return false;
  return true;
}

template <typename T, GroupPreview::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.shared_tabs < rhs.shared_tabs)
    return true;
  if (rhs.shared_tabs < lhs.shared_tabs)
    return false;
  if (lhs.status_code < rhs.status_code)
    return true;
  if (rhs.status_code < lhs.status_code)
    return false;
  return false;
}


}  // data_sharing::mojom

namespace mojo {


template <>
struct  StructTraits<::data_sharing::mojom::ReadGroupsParams::DataView,
                                         ::data_sharing::mojom::ReadGroupsParamsPtr> {
  static bool IsNull(const ::data_sharing::mojom::ReadGroupsParamsPtr& input) { return !input; }
  static void SetToNull(::data_sharing::mojom::ReadGroupsParamsPtr* output) { output->reset(); }

  static const decltype(::data_sharing::mojom::ReadGroupsParams::params)& params(
      const ::data_sharing::mojom::ReadGroupsParamsPtr& input) {
    return input->params;
  }

  static bool Read(::data_sharing::mojom::ReadGroupsParams::DataView input, ::data_sharing::mojom::ReadGroupsParamsPtr* output);
};


template <>
struct  StructTraits<::data_sharing::mojom::ReadGroupParams::DataView,
                                         ::data_sharing::mojom::ReadGroupParamsPtr> {
  static bool IsNull(const ::data_sharing::mojom::ReadGroupParamsPtr& input) { return !input; }
  static void SetToNull(::data_sharing::mojom::ReadGroupParamsPtr* output) { output->reset(); }

  static const decltype(::data_sharing::mojom::ReadGroupParams::group_id)& group_id(
      const ::data_sharing::mojom::ReadGroupParamsPtr& input) {
    return input->group_id;
  }

  static const decltype(::data_sharing::mojom::ReadGroupParams::consistency_token)& consistency_token(
      const ::data_sharing::mojom::ReadGroupParamsPtr& input) {
    return input->consistency_token;
  }

  static bool Read(::data_sharing::mojom::ReadGroupParams::DataView input, ::data_sharing::mojom::ReadGroupParamsPtr* output);
};


template <>
struct  StructTraits<::data_sharing::mojom::ReadGroupsResult::DataView,
                                         ::data_sharing::mojom::ReadGroupsResultPtr> {
  static bool IsNull(const ::data_sharing::mojom::ReadGroupsResultPtr& input) { return !input; }
  static void SetToNull(::data_sharing::mojom::ReadGroupsResultPtr* output) { output->reset(); }

  static const decltype(::data_sharing::mojom::ReadGroupsResult::groups)& groups(
      const ::data_sharing::mojom::ReadGroupsResultPtr& input) {
    return input->groups;
  }

  static decltype(::data_sharing::mojom::ReadGroupsResult::status_code) status_code(
      const ::data_sharing::mojom::ReadGroupsResultPtr& input) {
    return input->status_code;
  }

  static bool Read(::data_sharing::mojom::ReadGroupsResult::DataView input, ::data_sharing::mojom::ReadGroupsResultPtr* output);
};


template <>
struct  StructTraits<::data_sharing::mojom::ReadGroupWithTokenParam::DataView,
                                         ::data_sharing::mojom::ReadGroupWithTokenParamPtr> {
  static bool IsNull(const ::data_sharing::mojom::ReadGroupWithTokenParamPtr& input) { return !input; }
  static void SetToNull(::data_sharing::mojom::ReadGroupWithTokenParamPtr* output) { output->reset(); }

  static const decltype(::data_sharing::mojom::ReadGroupWithTokenParam::group_id)& group_id(
      const ::data_sharing::mojom::ReadGroupWithTokenParamPtr& input) {
    return input->group_id;
  }

  static const decltype(::data_sharing::mojom::ReadGroupWithTokenParam::access_token)& access_token(
      const ::data_sharing::mojom::ReadGroupWithTokenParamPtr& input) {
    return input->access_token;
  }

  static bool Read(::data_sharing::mojom::ReadGroupWithTokenParam::DataView input, ::data_sharing::mojom::ReadGroupWithTokenParamPtr* output);
};


template <>
struct  StructTraits<::data_sharing::mojom::ReadGroupWithTokenResult::DataView,
                                         ::data_sharing::mojom::ReadGroupWithTokenResultPtr> {
  static bool IsNull(const ::data_sharing::mojom::ReadGroupWithTokenResultPtr& input) { return !input; }
  static void SetToNull(::data_sharing::mojom::ReadGroupWithTokenResultPtr* output) { output->reset(); }

  static const decltype(::data_sharing::mojom::ReadGroupWithTokenResult::group)& group(
      const ::data_sharing::mojom::ReadGroupWithTokenResultPtr& input) {
    return input->group;
  }

  static decltype(::data_sharing::mojom::ReadGroupWithTokenResult::status_code) status_code(
      const ::data_sharing::mojom::ReadGroupWithTokenResultPtr& input) {
    return input->status_code;
  }

  static bool Read(::data_sharing::mojom::ReadGroupWithTokenResult::DataView input, ::data_sharing::mojom::ReadGroupWithTokenResultPtr* output);
};


template <>
struct  StructTraits<::data_sharing::mojom::SharedTab::DataView,
                                         ::data_sharing::mojom::SharedTabPtr> {
  static bool IsNull(const ::data_sharing::mojom::SharedTabPtr& input) { return !input; }
  static void SetToNull(::data_sharing::mojom::SharedTabPtr* output) { output->reset(); }

  static const decltype(::data_sharing::mojom::SharedTab::display_url)& display_url(
      const ::data_sharing::mojom::SharedTabPtr& input) {
    return input->display_url;
  }

  static const decltype(::data_sharing::mojom::SharedTab::favicon_url)& favicon_url(
      const ::data_sharing::mojom::SharedTabPtr& input) {
    return input->favicon_url;
  }

  static bool Read(::data_sharing::mojom::SharedTab::DataView input, ::data_sharing::mojom::SharedTabPtr* output);
};


template <>
struct  StructTraits<::data_sharing::mojom::GroupPreview::DataView,
                                         ::data_sharing::mojom::GroupPreviewPtr> {
  static bool IsNull(const ::data_sharing::mojom::GroupPreviewPtr& input) { return !input; }
  static void SetToNull(::data_sharing::mojom::GroupPreviewPtr* output) { output->reset(); }

  static const decltype(::data_sharing::mojom::GroupPreview::title)& title(
      const ::data_sharing::mojom::GroupPreviewPtr& input) {
    return input->title;
  }

  static const decltype(::data_sharing::mojom::GroupPreview::shared_tabs)& shared_tabs(
      const ::data_sharing::mojom::GroupPreviewPtr& input) {
    return input->shared_tabs;
  }

  static decltype(::data_sharing::mojom::GroupPreview::status_code) status_code(
      const ::data_sharing::mojom::GroupPreviewPtr& input) {
    return input->status_code;
  }

  static bool Read(::data_sharing::mojom::GroupPreview::DataView input, ::data_sharing::mojom::GroupPreviewPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_H_