// chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_CONNECTORS_INTERNALS_CONNECTORS_INTERNALS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_CONNECTORS_INTERNALS_CONNECTORS_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-shared-internal.h"


namespace connectors_internals::mojom {
class Int32ValueDataView;

class LoadedKeyInfoDataView;

class KeyInfoDataView;

class ConsentMetadataDataView;

class DeviceTrustStateDataView;

class CertificateMetadataDataView;

class ClientIdentityDataView;

class ClientCertificateStateDataView;

class SignalsReportingStateDataView;

class KeyUploadStatusDataView;


}  // connectors_internals::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::connectors_internals::mojom::Int32ValueDataView> {
  using Data = ::connectors_internals::mojom::internal::Int32Value_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::connectors_internals::mojom::LoadedKeyInfoDataView> {
  using Data = ::connectors_internals::mojom::internal::LoadedKeyInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::connectors_internals::mojom::KeyInfoDataView> {
  using Data = ::connectors_internals::mojom::internal::KeyInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::connectors_internals::mojom::ConsentMetadataDataView> {
  using Data = ::connectors_internals::mojom::internal::ConsentMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::connectors_internals::mojom::DeviceTrustStateDataView> {
  using Data = ::connectors_internals::mojom::internal::DeviceTrustState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::connectors_internals::mojom::CertificateMetadataDataView> {
  using Data = ::connectors_internals::mojom::internal::CertificateMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::connectors_internals::mojom::ClientIdentityDataView> {
  using Data = ::connectors_internals::mojom::internal::ClientIdentity_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::connectors_internals::mojom::ClientCertificateStateDataView> {
  using Data = ::connectors_internals::mojom::internal::ClientCertificateState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::connectors_internals::mojom::SignalsReportingStateDataView> {
  using Data = ::connectors_internals::mojom::internal::SignalsReportingState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::connectors_internals::mojom::KeyUploadStatusDataView> {
  using Data = ::connectors_internals::mojom::internal::KeyUploadStatus_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace connectors_internals::mojom {


enum class KeyManagerInitializedValue : int32_t {
  
  UNSUPPORTED = 0,
  
  KEY_LOADED = 1,
  
  NO_KEY = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, KeyManagerInitializedValue value);
inline bool IsKnownEnumValue(KeyManagerInitializedValue value) {
  return internal::KeyManagerInitializedValue_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class KeyTrustLevel : int32_t {
  
  UNSPECIFIED = 0,
  
  HW = 1,
  
  OS = 2,
  
  OS_SOFTWARE = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, KeyTrustLevel value);
inline bool IsKnownEnumValue(KeyTrustLevel value) {
  return internal::KeyTrustLevel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class KeyType : int32_t {
  
  UNKNOWN = 0,
  
  RSA = 1,
  
  EC = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, KeyType value);
inline bool IsKnownEnumValue(KeyType value) {
  return internal::KeyType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class KeyManagerPermanentFailure : int32_t {
  
  UNSPECIFIED = 0,
  
  CREATION_UPLOAD_CONFLICT = 1,
  
  INSUFFICIENT_PERMISSIONS = 2,
  
  OS_RESTRICTION = 3,
  
  INVALID_INSTALLATION = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, KeyManagerPermanentFailure value);
inline bool IsKnownEnumValue(KeyManagerPermanentFailure value) {
  return internal::KeyManagerPermanentFailure_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;


class Int32ValueDataView {
 public:
  Int32ValueDataView() = default;

  Int32ValueDataView(
      internal::Int32Value_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t value() const {
    return data_->value;
  }
 private:
  internal::Int32Value_Data* data_ = nullptr;
};


class LoadedKeyInfoDataView {
 public:
  LoadedKeyInfoDataView() = default;

  LoadedKeyInfoDataView(
      internal::LoadedKeyInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadTrustLevel(UserType* output) const {
    auto data_value = data_->trust_level;
    return mojo::internal::Deserialize<::connectors_internals::mojom::KeyTrustLevel>(
        data_value, output);
  }
  KeyTrustLevel trust_level() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::connectors_internals::mojom::KeyTrustLevel>(data_->trust_level));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadKeyType(UserType* output) const {
    auto data_value = data_->key_type;
    return mojo::internal::Deserialize<::connectors_internals::mojom::KeyType>(
        data_value, output);
  }
  KeyType key_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::connectors_internals::mojom::KeyType>(data_->key_type));
  }
  inline void GetEncodedSpkiHashDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncodedSpkiHash(UserType* output) {
    
    auto* pointer = data_->encoded_spki_hash.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetKeyUploadStatusDataView(
      KeyUploadStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyUploadStatus(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::connectors_internals::mojom::KeyUploadStatusDataView, UserType>(),
    "Attempting to read the optional `key_upload_status` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeyUploadStatus` instead "
    "of `ReadKeyUploadStatus if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->key_upload_status.is_null() ? &data_->key_upload_status : nullptr;
    return mojo::internal::Deserialize<::connectors_internals::mojom::KeyUploadStatusDataView>(
        pointer, output, message_);
  }
  bool has_ssl_key() const {
    return data_->has_ssl_key;
  }
 private:
  internal::LoadedKeyInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class KeyInfoDataView {
 public:
  KeyInfoDataView() = default;

  KeyInfoDataView(
      internal::KeyInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadIsKeyManagerInitialized(UserType* output) const {
    auto data_value = data_->is_key_manager_initialized;
    return mojo::internal::Deserialize<::connectors_internals::mojom::KeyManagerInitializedValue>(
        data_value, output);
  }
  KeyManagerInitializedValue is_key_manager_initialized() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::connectors_internals::mojom::KeyManagerInitializedValue>(data_->is_key_manager_initialized));
  }
  inline void GetLoadedKeyInfoDataView(
      LoadedKeyInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLoadedKeyInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::connectors_internals::mojom::LoadedKeyInfoDataView, UserType>(),
    "Attempting to read the optional `loaded_key_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLoadedKeyInfo` instead "
    "of `ReadLoadedKeyInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->loaded_key_info.Get();
    return mojo::internal::Deserialize<::connectors_internals::mojom::LoadedKeyInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPermanentFailure(UserType* output) const {
    auto data_value = data_->permanent_failure;
    return mojo::internal::Deserialize<::connectors_internals::mojom::KeyManagerPermanentFailure>(
        data_value, output);
  }
  KeyManagerPermanentFailure permanent_failure() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::connectors_internals::mojom::KeyManagerPermanentFailure>(data_->permanent_failure));
  }
 private:
  internal::KeyInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ConsentMetadataDataView {
 public:
  ConsentMetadataDataView() = default;

  ConsentMetadataDataView(
      internal::ConsentMetadata_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool can_collect_signals() const {
    return data_->can_collect_signals;
  }
  bool consent_received() const {
    return data_->consent_received;
  }
 private:
  internal::ConsentMetadata_Data* data_ = nullptr;
};


class DeviceTrustStateDataView {
 public:
  DeviceTrustStateDataView() = default;

  DeviceTrustStateDataView(
      internal::DeviceTrustState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_enabled() const {
    return data_->is_enabled;
  }
  inline void GetPolicyEnabledLevelsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyEnabledLevels(UserType* output) {
    
    auto* pointer = data_->policy_enabled_levels.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetKeyInfoDataView(
      KeyInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyInfo(UserType* output) {
    
    auto* pointer = data_->key_info.Get();
    return mojo::internal::Deserialize<::connectors_internals::mojom::KeyInfoDataView>(
        pointer, output, message_);
  }
  inline void GetSignalsJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignalsJson(UserType* output) {
    
    auto* pointer = data_->signals_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetConsentMetadataDataView(
      ConsentMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConsentMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::connectors_internals::mojom::ConsentMetadataDataView, UserType>(),
    "Attempting to read the optional `consent_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadConsentMetadata` instead "
    "of `ReadConsentMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->consent_metadata.Get();
    return mojo::internal::Deserialize<::connectors_internals::mojom::ConsentMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::DeviceTrustState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CertificateMetadataDataView {
 public:
  CertificateMetadataDataView() = default;

  CertificateMetadataDataView(
      internal::CertificateMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSerialNumberDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerialNumber(UserType* output) {
    
    auto* pointer = data_->serial_number.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFingerprintDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFingerprint(UserType* output) {
    
    auto* pointer = data_->fingerprint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCreationDateStringDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreationDateString(UserType* output) {
    
    auto* pointer = data_->creation_date_string.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExpirationDateStringDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpirationDateString(UserType* output) {
    
    auto* pointer = data_->expiration_date_string.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSubjectDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubjectDisplayName(UserType* output) {
    
    auto* pointer = data_->subject_display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIssuerDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssuerDisplayName(UserType* output) {
    
    auto* pointer = data_->issuer_display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CertificateMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ClientIdentityDataView {
 public:
  ClientIdentityDataView() = default;

  ClientIdentityDataView(
      internal::ClientIdentity_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdentityNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdentityName(UserType* output) {
    
    auto* pointer = data_->identity_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLoadedKeyInfoDataView(
      LoadedKeyInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLoadedKeyInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::connectors_internals::mojom::LoadedKeyInfoDataView, UserType>(),
    "Attempting to read the optional `loaded_key_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLoadedKeyInfo` instead "
    "of `ReadLoadedKeyInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->loaded_key_info.Get();
    return mojo::internal::Deserialize<::connectors_internals::mojom::LoadedKeyInfoDataView>(
        pointer, output, message_);
  }
  inline void GetCertificateMetadataDataView(
      CertificateMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCertificateMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::connectors_internals::mojom::CertificateMetadataDataView, UserType>(),
    "Attempting to read the optional `certificate_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCertificateMetadata` instead "
    "of `ReadCertificateMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->certificate_metadata.Get();
    return mojo::internal::Deserialize<::connectors_internals::mojom::CertificateMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::ClientIdentity_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ClientCertificateStateDataView {
 public:
  ClientCertificateStateDataView() = default;

  ClientCertificateStateDataView(
      internal::ClientCertificateState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPolicyEnabledLevelsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyEnabledLevels(UserType* output) {
    
    auto* pointer = data_->policy_enabled_levels.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetManagedProfileIdentityDataView(
      ClientIdentityDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManagedProfileIdentity(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::connectors_internals::mojom::ClientIdentityDataView, UserType>(),
    "Attempting to read the optional `managed_profile_identity` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadManagedProfileIdentity` instead "
    "of `ReadManagedProfileIdentity if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->managed_profile_identity.Get();
    return mojo::internal::Deserialize<::connectors_internals::mojom::ClientIdentityDataView>(
        pointer, output, message_);
  }
  inline void GetManagedBrowserIdentityDataView(
      ClientIdentityDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManagedBrowserIdentity(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::connectors_internals::mojom::ClientIdentityDataView, UserType>(),
    "Attempting to read the optional `managed_browser_identity` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadManagedBrowserIdentity` instead "
    "of `ReadManagedBrowserIdentity if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->managed_browser_identity.Get();
    return mojo::internal::Deserialize<::connectors_internals::mojom::ClientIdentityDataView>(
        pointer, output, message_);
  }
 private:
  internal::ClientCertificateState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SignalsReportingStateDataView {
 public:
  SignalsReportingStateDataView() = default;

  SignalsReportingStateDataView(
      internal::SignalsReportingState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetErrorInfoDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `error_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadErrorInfo` instead "
    "of `ReadErrorInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->error_info.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool status_report_enabled() const {
    return data_->status_report_enabled;
  }
  bool signals_report_enabled() const {
    return data_->signals_report_enabled;
  }
  inline void GetLastUploadAttemptTimestampDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUploadAttemptTimestamp(UserType* output) {
    
    auto* pointer = data_->last_upload_attempt_timestamp.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLastUploadSuccessTimestampDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUploadSuccessTimestamp(UserType* output) {
    
    auto* pointer = data_->last_upload_success_timestamp.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLastSignalsUploadConfigDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastSignalsUploadConfig(UserType* output) {
    
    auto* pointer = data_->last_signals_upload_config.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool can_collect_all_fields() const {
    return data_->can_collect_all_fields;
  }
 private:
  internal::SignalsReportingState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class KeyUploadStatusDataView {
 public:
  using Tag = internal::KeyUploadStatus_Data::KeyUploadStatus_Tag;

  KeyUploadStatusDataView() = default;

  KeyUploadStatusDataView(
      internal::KeyUploadStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_sync_key_response_code() const { return data_->tag == Tag::kSyncKeyResponseCode; }
  inline void GetSyncKeyResponseCodeDataView(
      Int32ValueDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSyncKeyResponseCode(UserType* output) const {
    
    CHECK(is_sync_key_response_code());
    return mojo::internal::Deserialize<::connectors_internals::mojom::Int32ValueDataView>(
        data_->data.f_sync_key_response_code.Get(), output, message_);
  }
  bool is_upload_client_error() const { return data_->tag == Tag::kUploadClientError; }
  inline void GetUploadClientErrorDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUploadClientError(UserType* output) const {
    
    CHECK(is_upload_client_error());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_upload_client_error.Get(), output, message_);
  }

 private:
  internal::KeyUploadStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // connectors_internals::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_CONNECTORS_INTERNALS_CONNECTORS_INTERNALS_MOJOM_DATA_VIEW_H_