// chrome/browser/ui/webui/app_home/app_home.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UserDisplayModeSpec as webApp_mojom_UserDisplayModeSpec,
  UserDisplayMode as webApp_mojom_UserDisplayMode
} from './user_display_mode.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const RunOnOsLoginModeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum RunOnOsLoginMode {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kNotRun = 0,
  kWindowed = 1,
  kMinimized = 2,
}

export const AppTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum AppType {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kWebApp = 0,
  kIsolatedWebApp = 1,
  kDeprecatedChromeApp = 2,
}



export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'app_home.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "app_home.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'app_home.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getApps(): Promise<{
        appList: AppInfo[], }>;
  getDeprecationLinkString(): Promise<{
        linkString: string, }>;
  uninstallApp(appId: string): void;
  showAppSettings(appId: string): void;
  createAppShortcut(appId: string): Promise<void>;
  launchApp(appId: string, clickEvent: (ClickEvent | null)): void;
  setRunOnOsLoginMode(appId: string, runOnOsLoginMode: RunOnOsLoginMode): void;
  launchDeprecatedAppDialog(): void;
  installAppLocally(appId: string): void;
  setUserDisplayMode(appId: string, displayMode: webApp_mojom_UserDisplayMode): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getApps(): Promise<{
        appList: AppInfo[], }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_GetApps_ParamsSpec.$,
        PageHandler_GetApps_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getDeprecationLinkString(): Promise<{
        linkString: string, }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_GetDeprecationLinkString_ParamsSpec.$,
        PageHandler_GetDeprecationLinkString_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  uninstallApp(
      appId: string): void {
    this.proxy.sendMessage(
        2,
        PageHandler_UninstallApp_ParamsSpec.$,
        null,
        [
          appId
        ],
        false);
  }

  showAppSettings(
      appId: string): void {
    this.proxy.sendMessage(
        3,
        PageHandler_ShowAppSettings_ParamsSpec.$,
        null,
        [
          appId
        ],
        false);
  }

  createAppShortcut(
      appId: string): Promise<void> {
    return this.proxy.sendMessage(
        4,
        PageHandler_CreateAppShortcut_ParamsSpec.$,
        PageHandler_CreateAppShortcut_ResponseParamsSpec.$,
        [
          appId
        ],
        false);
  }

  launchApp(
      appId: string,
      clickEvent: (ClickEvent | null)): void {
    this.proxy.sendMessage(
        5,
        PageHandler_LaunchApp_ParamsSpec.$,
        null,
        [
          appId,
          clickEvent
        ],
        false);
  }

  setRunOnOsLoginMode(
      appId: string,
      runOnOsLoginMode: RunOnOsLoginMode): void {
    this.proxy.sendMessage(
        6,
        PageHandler_SetRunOnOsLoginMode_ParamsSpec.$,
        null,
        [
          appId,
          runOnOsLoginMode
        ],
        false);
  }

  launchDeprecatedAppDialog(): void {
    this.proxy.sendMessage(
        7,
        PageHandler_LaunchDeprecatedAppDialog_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  installAppLocally(
      appId: string): void {
    this.proxy.sendMessage(
        8,
        PageHandler_InstallAppLocally_ParamsSpec.$,
        null,
        [
          appId
        ],
        false);
  }

  setUserDisplayMode(
      appId: string,
      displayMode: webApp_mojom_UserDisplayMode): void {
    this.proxy.sendMessage(
        9,
        PageHandler_SetUserDisplayMode_ParamsSpec.$,
        null,
        [
          appId,
          displayMode
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetApps_ParamsSpec.$,
        PageHandler_GetApps_ResponseParamsSpec.$,
        impl.getApps.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetDeprecationLinkString_ParamsSpec.$,
        PageHandler_GetDeprecationLinkString_ResponseParamsSpec.$,
        impl.getDeprecationLinkString.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_UninstallApp_ParamsSpec.$,
        null,
        impl.uninstallApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_ShowAppSettings_ParamsSpec.$,
        null,
        impl.showAppSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_CreateAppShortcut_ParamsSpec.$,
        PageHandler_CreateAppShortcut_ResponseParamsSpec.$,
        impl.createAppShortcut.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_LaunchApp_ParamsSpec.$,
        null,
        impl.launchApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_SetRunOnOsLoginMode_ParamsSpec.$,
        null,
        impl.setRunOnOsLoginMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_LaunchDeprecatedAppDialog_ParamsSpec.$,
        null,
        impl.launchDeprecatedAppDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_InstallAppLocally_ParamsSpec.$,
        null,
        impl.installAppLocally.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_SetUserDisplayMode_ParamsSpec.$,
        null,
        impl.setUserDisplayMode.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "app_home.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getApps: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getDeprecationLinkString: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  uninstallApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showAppSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  createAppShortcut: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  launchApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setRunOnOsLoginMode: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  launchDeprecatedAppDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  installAppLocally: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setUserDisplayMode: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getApps =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetApps_ParamsSpec.$,
        PageHandler_GetApps_ResponseParamsSpec.$,
        this.getApps.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getDeprecationLinkString =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetDeprecationLinkString_ParamsSpec.$,
        PageHandler_GetDeprecationLinkString_ResponseParamsSpec.$,
        this.getDeprecationLinkString.createReceiverHandler(true /* expectsResponse */),
        false);
    this.uninstallApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_UninstallApp_ParamsSpec.$,
        null,
        this.uninstallApp.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showAppSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_ShowAppSettings_ParamsSpec.$,
        null,
        this.showAppSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    this.createAppShortcut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_CreateAppShortcut_ParamsSpec.$,
        PageHandler_CreateAppShortcut_ResponseParamsSpec.$,
        this.createAppShortcut.createReceiverHandler(true /* expectsResponse */),
        false);
    this.launchApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_LaunchApp_ParamsSpec.$,
        null,
        this.launchApp.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setRunOnOsLoginMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_SetRunOnOsLoginMode_ParamsSpec.$,
        null,
        this.setRunOnOsLoginMode.createReceiverHandler(false /* expectsResponse */),
        false);
    this.launchDeprecatedAppDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_LaunchDeprecatedAppDialog_ParamsSpec.$,
        null,
        this.launchDeprecatedAppDialog.createReceiverHandler(false /* expectsResponse */),
        false);
    this.installAppLocally =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_InstallAppLocally_ParamsSpec.$,
        null,
        this.installAppLocally.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setUserDisplayMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_SetUserDisplayMode_ParamsSpec.$,
        null,
        this.setUserDisplayMode.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'app_home.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  addApp(appInfo: AppInfo): void;
  removeApp(appInfo: AppInfo): void;
  updateApp(appInfo: AppInfo): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  addApp(
      appInfo: AppInfo): void {
    this.proxy.sendMessage(
        0,
        Page_AddApp_ParamsSpec.$,
        null,
        [
          appInfo
        ],
        false);
  }

  removeApp(
      appInfo: AppInfo): void {
    this.proxy.sendMessage(
        1,
        Page_RemoveApp_ParamsSpec.$,
        null,
        [
          appInfo
        ],
        false);
  }

  updateApp(
      appInfo: AppInfo): void {
    this.proxy.sendMessage(
        2,
        Page_UpdateApp_ParamsSpec.$,
        null,
        [
          appInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_AddApp_ParamsSpec.$,
        null,
        impl.addApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_RemoveApp_ParamsSpec.$,
        null,
        impl.removeApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_UpdateApp_ParamsSpec.$,
        null,
        impl.updateApp.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "app_home.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  addApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  removeApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateApp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.addApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_AddApp_ParamsSpec.$,
        null,
        this.addApp.createReceiverHandler(false /* expectsResponse */),
        false);
    this.removeApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_RemoveApp_ParamsSpec.$,
        null,
        this.removeApp.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_UpdateApp_ParamsSpec.$,
        null,
        this.updateApp.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const AppInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ClickEventSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetApps_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetApps_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetDeprecationLinkString_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetDeprecationLinkString_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_UninstallApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowAppSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CreateAppShortcut_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CreateAppShortcut_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_LaunchApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetRunOnOsLoginMode_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_LaunchDeprecatedAppDialog_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_InstallAppLocally_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetUserDisplayMode_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_AddApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_RemoveApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_UpdateApp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface AppInfoMojoType {
  appType: AppType;
  mayShowRunOnOsLoginMode: boolean;
  mayToggleRunOnOsLoginMode: boolean;
  isLocallyInstalled: boolean;
  openInWindow: boolean;
  mayUninstall: boolean;
  id: string;
  startUrl: url_mojom_Url;
  name: string;
  iconUrl: url_mojom_Url;
  runOnOsLoginMode: RunOnOsLoginMode;
  storePageUrl: (url_mojom_Url | null);
}


export type AppInfo = AppInfoMojoType;
mojo.internal.Struct<AppInfoMojoType>(
    AppInfoSpec.$,
    'AppInfo',
    [
      mojo.internal.StructField<AppInfoMojoType, AppType>(
        'appType', 0,
        0,
        AppTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppInfoMojoType, string>(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppInfoMojoType, url_mojom_Url>(
        'startUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppInfoMojoType, string>(
        'name', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppInfoMojoType, url_mojom_Url>(
        'iconUrl', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppInfoMojoType, boolean>(
        'mayShowRunOnOsLoginMode', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppInfoMojoType, boolean>(
        'mayToggleRunOnOsLoginMode', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppInfoMojoType, RunOnOsLoginMode>(
        'runOnOsLoginMode', 40,
        0,
        RunOnOsLoginModeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppInfoMojoType, boolean>(
        'isLocallyInstalled', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppInfoMojoType, boolean>(
        'openInWindow', 4,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppInfoMojoType, boolean>(
        'mayUninstall', 4,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AppInfoMojoType, url_mojom_Url>(
        'storePageUrl', 48,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 64],]);





export interface ClickEventMojoType {
  button: number;
  altKey: boolean;
  ctrlKey: boolean;
  metaKey: boolean;
  shiftKey: boolean;
}


export type ClickEvent = ClickEventMojoType;
mojo.internal.Struct<ClickEventMojoType>(
    ClickEventSpec.$,
    'ClickEvent',
    [
      mojo.internal.StructField<ClickEventMojoType, number>(
        'button', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClickEventMojoType, boolean>(
        'altKey', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClickEventMojoType, boolean>(
        'ctrlKey', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClickEventMojoType, boolean>(
        'metaKey', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClickEventMojoType, boolean>(
        'shiftKey', 8,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetApps_ParamsMojoType {
}


export type PageHandler_GetApps_Params = PageHandler_GetApps_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetApps_ParamsMojoType>(
    PageHandler_GetApps_ParamsSpec.$,
    'PageHandler_GetApps_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetApps_ResponseParamsMojoType {
  appList: AppInfo[];
}


export type PageHandler_GetApps_ResponseParams = PageHandler_GetApps_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetApps_ResponseParamsMojoType>(
    PageHandler_GetApps_ResponseParamsSpec.$,
    'PageHandler_GetApps_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetApps_ResponseParamsMojoType, AppInfo[]>(
        'appList', 0,
        0,
        mojo.internal.Array(AppInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetDeprecationLinkString_ParamsMojoType {
}


export type PageHandler_GetDeprecationLinkString_Params = PageHandler_GetDeprecationLinkString_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetDeprecationLinkString_ParamsMojoType>(
    PageHandler_GetDeprecationLinkString_ParamsSpec.$,
    'PageHandler_GetDeprecationLinkString_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetDeprecationLinkString_ResponseParamsMojoType {
  linkString: string;
}


export type PageHandler_GetDeprecationLinkString_ResponseParams = PageHandler_GetDeprecationLinkString_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetDeprecationLinkString_ResponseParamsMojoType>(
    PageHandler_GetDeprecationLinkString_ResponseParamsSpec.$,
    'PageHandler_GetDeprecationLinkString_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetDeprecationLinkString_ResponseParamsMojoType, string>(
        'linkString', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_UninstallApp_ParamsMojoType {
  appId: string;
}


export type PageHandler_UninstallApp_Params = PageHandler_UninstallApp_ParamsMojoType;
mojo.internal.Struct<PageHandler_UninstallApp_ParamsMojoType>(
    PageHandler_UninstallApp_ParamsSpec.$,
    'PageHandler_UninstallApp_Params',
    [
      mojo.internal.StructField<PageHandler_UninstallApp_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ShowAppSettings_ParamsMojoType {
  appId: string;
}


export type PageHandler_ShowAppSettings_Params = PageHandler_ShowAppSettings_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowAppSettings_ParamsMojoType>(
    PageHandler_ShowAppSettings_ParamsSpec.$,
    'PageHandler_ShowAppSettings_Params',
    [
      mojo.internal.StructField<PageHandler_ShowAppSettings_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_CreateAppShortcut_ParamsMojoType {
  appId: string;
}


export type PageHandler_CreateAppShortcut_Params = PageHandler_CreateAppShortcut_ParamsMojoType;
mojo.internal.Struct<PageHandler_CreateAppShortcut_ParamsMojoType>(
    PageHandler_CreateAppShortcut_ParamsSpec.$,
    'PageHandler_CreateAppShortcut_Params',
    [
      mojo.internal.StructField<PageHandler_CreateAppShortcut_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_CreateAppShortcut_ResponseParamsMojoType {
}


export type PageHandler_CreateAppShortcut_ResponseParams = PageHandler_CreateAppShortcut_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_CreateAppShortcut_ResponseParamsMojoType>(
    PageHandler_CreateAppShortcut_ResponseParamsSpec.$,
    'PageHandler_CreateAppShortcut_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface PageHandler_LaunchApp_ParamsMojoType {
  appId: string;
  clickEvent: (ClickEvent | null);
}


export type PageHandler_LaunchApp_Params = PageHandler_LaunchApp_ParamsMojoType;
mojo.internal.Struct<PageHandler_LaunchApp_ParamsMojoType>(
    PageHandler_LaunchApp_ParamsSpec.$,
    'PageHandler_LaunchApp_Params',
    [
      mojo.internal.StructField<PageHandler_LaunchApp_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_LaunchApp_ParamsMojoType, ClickEvent>(
        'clickEvent', 8,
        0,
        ClickEventSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_SetRunOnOsLoginMode_ParamsMojoType {
  appId: string;
  runOnOsLoginMode: RunOnOsLoginMode;
}


export type PageHandler_SetRunOnOsLoginMode_Params = PageHandler_SetRunOnOsLoginMode_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetRunOnOsLoginMode_ParamsMojoType>(
    PageHandler_SetRunOnOsLoginMode_ParamsSpec.$,
    'PageHandler_SetRunOnOsLoginMode_Params',
    [
      mojo.internal.StructField<PageHandler_SetRunOnOsLoginMode_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetRunOnOsLoginMode_ParamsMojoType, RunOnOsLoginMode>(
        'runOnOsLoginMode', 8,
        0,
        RunOnOsLoginModeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_LaunchDeprecatedAppDialog_ParamsMojoType {
}


export type PageHandler_LaunchDeprecatedAppDialog_Params = PageHandler_LaunchDeprecatedAppDialog_ParamsMojoType;
mojo.internal.Struct<PageHandler_LaunchDeprecatedAppDialog_ParamsMojoType>(
    PageHandler_LaunchDeprecatedAppDialog_ParamsSpec.$,
    'PageHandler_LaunchDeprecatedAppDialog_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_InstallAppLocally_ParamsMojoType {
  appId: string;
}


export type PageHandler_InstallAppLocally_Params = PageHandler_InstallAppLocally_ParamsMojoType;
mojo.internal.Struct<PageHandler_InstallAppLocally_ParamsMojoType>(
    PageHandler_InstallAppLocally_ParamsSpec.$,
    'PageHandler_InstallAppLocally_Params',
    [
      mojo.internal.StructField<PageHandler_InstallAppLocally_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetUserDisplayMode_ParamsMojoType {
  appId: string;
  displayMode: webApp_mojom_UserDisplayMode;
}


export type PageHandler_SetUserDisplayMode_Params = PageHandler_SetUserDisplayMode_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetUserDisplayMode_ParamsMojoType>(
    PageHandler_SetUserDisplayMode_ParamsSpec.$,
    'PageHandler_SetUserDisplayMode_Params',
    [
      mojo.internal.StructField<PageHandler_SetUserDisplayMode_ParamsMojoType, string>(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetUserDisplayMode_ParamsMojoType, webApp_mojom_UserDisplayMode>(
        'displayMode', 8,
        0,
        webApp_mojom_UserDisplayModeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Page_AddApp_ParamsMojoType {
  appInfo: AppInfo;
}


export type Page_AddApp_Params = Page_AddApp_ParamsMojoType;
mojo.internal.Struct<Page_AddApp_ParamsMojoType>(
    Page_AddApp_ParamsSpec.$,
    'Page_AddApp_Params',
    [
      mojo.internal.StructField<Page_AddApp_ParamsMojoType, AppInfo>(
        'appInfo', 0,
        0,
        AppInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_RemoveApp_ParamsMojoType {
  appInfo: AppInfo;
}


export type Page_RemoveApp_Params = Page_RemoveApp_ParamsMojoType;
mojo.internal.Struct<Page_RemoveApp_ParamsMojoType>(
    Page_RemoveApp_ParamsSpec.$,
    'Page_RemoveApp_Params',
    [
      mojo.internal.StructField<Page_RemoveApp_ParamsMojoType, AppInfo>(
        'appInfo', 0,
        0,
        AppInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_UpdateApp_ParamsMojoType {
  appInfo: AppInfo;
}


export type Page_UpdateApp_Params = Page_UpdateApp_ParamsMojoType;
mojo.internal.Struct<Page_UpdateApp_ParamsMojoType>(
    Page_UpdateApp_ParamsSpec.$,
    'Page_UpdateApp_Params',
    [
      mojo.internal.StructField<Page_UpdateApp_ParamsMojoType, AppInfo>(
        'appInfo', 0,
        0,
        AppInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



