// chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_data_model.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_DATA_MODEL_MOJOM_H_
#define CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_DATA_MODEL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_data_model.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_data_model.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_data_model.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_types.mojom.h"
#include "chrome/browser/ui/webui/tabs/tabs.mojom.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>




#include "chrome/browser/ui/tabs/tab_strip_api/types/image_traits.h"
#include "chrome/browser/ui/tabs/tab_strip_api/types/node_id.h"
#include "chrome/browser/ui/tabs/tab_strip_api/types/node_id_traits.h"
#include "chrome/browser/ui/tabs/tab_strip_api/types/position.h"
#include "chrome/browser/ui/tabs/tab_strip_api/types/position_traits.h"
#include "chrome/browser/ui/tabs/tab_strip_api/types/split_tab_visual_data_traits.h"
#include "chrome/browser/ui/tabs/tab_strip_api/types/tab_group_visual_data_traits.h"
#include "components/tab_groups/tab_group_visual_data.h"
#include "components/tabs/public/split_tab_visual_data.h"
#include "ui/gfx/image/image_skia.h"




namespace tabs_api::mojom {











class  TabGroupVisualData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabGroupVisualData, T>::value>;
  using DataView = TabGroupVisualDataDataView;
  using Data_ = internal::TabGroupVisualData_Data;

  template <typename... Args>
  static TabGroupVisualDataPtr New(Args&&... args) {
    return TabGroupVisualDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabGroupVisualDataPtr From(const U& u) {
    return mojo::TypeConverter<TabGroupVisualDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabGroupVisualData>::Convert(*this);
  }


  TabGroupVisualData();

  TabGroupVisualData(
      const std::string& title,
      ::tab_groups::TabGroupColorId color,
      bool is_collapsed);


  ~TabGroupVisualData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabGroupVisualDataPtr>
  TabGroupVisualDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabGroupVisualData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabGroupVisualData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabGroupVisualData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabGroupVisualData_UnserializedMessageContext<
            UserType, TabGroupVisualData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabGroupVisualData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabGroupVisualData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabGroupVisualData_UnserializedMessageContext<
            UserType, TabGroupVisualData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabGroupVisualData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string title;
  
  ::tab_groups::TabGroupColorId color;
  
  bool is_collapsed;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabGroupVisualData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SplitTabVisualData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SplitTabVisualData, T>::value>;
  using DataView = SplitTabVisualDataDataView;
  using Data_ = internal::SplitTabVisualData_Data;
  using Layout = SplitTabVisualData_Layout;

  template <typename... Args>
  static SplitTabVisualDataPtr New(Args&&... args) {
    return SplitTabVisualDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SplitTabVisualDataPtr From(const U& u) {
    return mojo::TypeConverter<SplitTabVisualDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SplitTabVisualData>::Convert(*this);
  }


  SplitTabVisualData();

  SplitTabVisualData(
      SplitTabVisualData::Layout layout,
      double split_ratio);


  ~SplitTabVisualData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SplitTabVisualDataPtr>
  SplitTabVisualDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SplitTabVisualData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SplitTabVisualData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SplitTabVisualData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SplitTabVisualData_UnserializedMessageContext<
            UserType, SplitTabVisualData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SplitTabVisualData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SplitTabVisualData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SplitTabVisualData_UnserializedMessageContext<
            UserType, SplitTabVisualData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SplitTabVisualData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SplitTabVisualData::Layout layout;
  
  double split_ratio;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SplitTabVisualData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  Data {
 public:
  using DataView = DataDataView;
  using Data_ = internal::Data_Data;
  using Tag = Data_::Data_Tag;

  template <typename... Args>
  static DataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |tab|.
  static DataPtr NewTab(
      TabPtr value);
  // Construct an instance holding |tab_strip|.
  static DataPtr NewTabStrip(
      TabStripPtr value);
  // Construct an instance holding |pinned_tabs|.
  static DataPtr NewPinnedTabs(
      PinnedTabsPtr value);
  // Construct an instance holding |unpinned_tabs|.
  static DataPtr NewUnpinnedTabs(
      UnpinnedTabsPtr value);
  // Construct an instance holding |tab_group|.
  static DataPtr NewTabGroup(
      TabGroupPtr value);
  // Construct an instance holding |split_tab|.
  static DataPtr NewSplitTab(
      SplitTabPtr value);

  template <typename U>
  static DataPtr From(const U& u) {
    return mojo::TypeConverter<DataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Data>::Convert(*this);
  }
  ~Data();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  Data(const Data& other) = delete;
  Data& operator=(const Data& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DataPtr>
  DataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, Data>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, Data>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_tab() const { return tag_ == Tag::kTab; }
  const TabPtr& get_tab() const {
    CHECK(tag_ == Tag::kTab);
    return data_.tab;
  }
  TabPtr& get_tab() {
    CHECK(tag_ == Tag::kTab);
    return data_.tab;
  }
  void set_tab(TabPtr tab);

  bool is_tab_strip() const { return tag_ == Tag::kTabStrip; }
  const TabStripPtr& get_tab_strip() const {
    CHECK(tag_ == Tag::kTabStrip);
    return data_.tab_strip;
  }
  TabStripPtr& get_tab_strip() {
    CHECK(tag_ == Tag::kTabStrip);
    return data_.tab_strip;
  }
  void set_tab_strip(TabStripPtr tab_strip);

  bool is_pinned_tabs() const { return tag_ == Tag::kPinnedTabs; }
  const PinnedTabsPtr& get_pinned_tabs() const {
    CHECK(tag_ == Tag::kPinnedTabs);
    return data_.pinned_tabs;
  }
  PinnedTabsPtr& get_pinned_tabs() {
    CHECK(tag_ == Tag::kPinnedTabs);
    return data_.pinned_tabs;
  }
  void set_pinned_tabs(PinnedTabsPtr pinned_tabs);

  bool is_unpinned_tabs() const { return tag_ == Tag::kUnpinnedTabs; }
  const UnpinnedTabsPtr& get_unpinned_tabs() const {
    CHECK(tag_ == Tag::kUnpinnedTabs);
    return data_.unpinned_tabs;
  }
  UnpinnedTabsPtr& get_unpinned_tabs() {
    CHECK(tag_ == Tag::kUnpinnedTabs);
    return data_.unpinned_tabs;
  }
  void set_unpinned_tabs(UnpinnedTabsPtr unpinned_tabs);

  bool is_tab_group() const { return tag_ == Tag::kTabGroup; }
  const TabGroupPtr& get_tab_group() const {
    CHECK(tag_ == Tag::kTabGroup);
    return data_.tab_group;
  }
  TabGroupPtr& get_tab_group() {
    CHECK(tag_ == Tag::kTabGroup);
    return data_.tab_group;
  }
  void set_tab_group(TabGroupPtr tab_group);

  bool is_split_tab() const { return tag_ == Tag::kSplitTab; }
  const SplitTabPtr& get_split_tab() const {
    CHECK(tag_ == Tag::kSplitTab);
    return data_.split_tab;
  }
  SplitTabPtr& get_split_tab() {
    CHECK(tag_ == Tag::kSplitTab);
    return data_.split_tab;
  }
  void set_split_tab(SplitTabPtr split_tab);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Data::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<Data::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTab)>,
        TabPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTabStrip)>,
        TabStripPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPinnedTabs)>,
        PinnedTabsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUnpinnedTabs)>,
        UnpinnedTabsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTabGroup)>,
        TabGroupPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSplitTab)>,
        SplitTabPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    TabPtr tab;
    TabStripPtr tab_strip;
    PinnedTabsPtr pinned_tabs;
    UnpinnedTabsPtr unpinned_tabs;
    TabGroupPtr tab_group;
    SplitTabPtr split_tab;
  };

  Data(
      std::in_place_index_t<static_cast<size_t>(Tag::kTab)>,
      TabPtr value);
  Data(
      std::in_place_index_t<static_cast<size_t>(Tag::kTabStrip)>,
      TabStripPtr value);
  Data(
      std::in_place_index_t<static_cast<size_t>(Tag::kPinnedTabs)>,
      PinnedTabsPtr value);
  Data(
      std::in_place_index_t<static_cast<size_t>(Tag::kUnpinnedTabs)>,
      UnpinnedTabsPtr value);
  Data(
      std::in_place_index_t<static_cast<size_t>(Tag::kTabGroup)>,
      TabGroupPtr value);
  Data(
      std::in_place_index_t<static_cast<size_t>(Tag::kSplitTab)>,
      SplitTabPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  Image {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Image, T>::value>;
  using DataView = ImageDataView;
  using Data_ = internal::Image_Data;

  template <typename... Args>
  static ImagePtr New(Args&&... args) {
    return ImagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImagePtr From(const U& u) {
    return mojo::TypeConverter<ImagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Image>::Convert(*this);
  }


  Image();

  explicit Image(
      const ::GURL& data_url);


  ~Image();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImagePtr>
  ImagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Image::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Image::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Image::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Image::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Image::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Image::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Image_UnserializedMessageContext<
            UserType, Image::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Image::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Image::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Image_UnserializedMessageContext<
            UserType, Image::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Image::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL data_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Image::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Image::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Image::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Image::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Tab {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Tab, T>::value>;
  using DataView = TabDataView;
  using Data_ = internal::Tab_Data;

  template <typename... Args>
  static TabPtr New(Args&&... args) {
    return TabPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabPtr From(const U& u) {
    return mojo::TypeConverter<TabPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Tab>::Convert(*this);
  }


  Tab();

  Tab(
      const ::tabs_api::NodeId& id,
      const std::string& title,
      const ::GURL& url,
      const ::gfx::ImageSkia& favicon,
      std::vector<::tabs::TabAlert> alert_states,
      ::TabNetworkState network_state,
      bool is_active,
      bool is_selected,
      bool is_blocked);


  ~Tab();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabPtr>
  TabPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tab::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tab::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Tab::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Tab_UnserializedMessageContext<
            UserType, Tab::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Tab::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Tab::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Tab_UnserializedMessageContext<
            UserType, Tab::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Tab::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::tabs_api::NodeId id;
  
  std::string title;
  
  ::GURL url;
  
  ::gfx::ImageSkia favicon;
  
  std::vector<::tabs::TabAlert> alert_states;
  
  ::TabNetworkState network_state;
  
  bool is_active;
  
  bool is_selected;
  
  bool is_blocked;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabStrip {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabStrip, T>::value>;
  using DataView = TabStripDataView;
  using Data_ = internal::TabStrip_Data;

  template <typename... Args>
  static TabStripPtr New(Args&&... args) {
    return TabStripPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabStripPtr From(const U& u) {
    return mojo::TypeConverter<TabStripPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabStrip>::Convert(*this);
  }


  TabStrip();

  explicit TabStrip(
      const ::tabs_api::NodeId& id);


  ~TabStrip();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabStripPtr>
  TabStripPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabStrip::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabStrip::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabStrip::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabStrip::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabStrip::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabStrip::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabStrip_UnserializedMessageContext<
            UserType, TabStrip::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabStrip::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabStrip::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabStrip_UnserializedMessageContext<
            UserType, TabStrip::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabStrip::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::tabs_api::NodeId id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabStrip::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabStrip::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabStrip::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabStrip::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PinnedTabs {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PinnedTabs, T>::value>;
  using DataView = PinnedTabsDataView;
  using Data_ = internal::PinnedTabs_Data;

  template <typename... Args>
  static PinnedTabsPtr New(Args&&... args) {
    return PinnedTabsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PinnedTabsPtr From(const U& u) {
    return mojo::TypeConverter<PinnedTabsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PinnedTabs>::Convert(*this);
  }


  PinnedTabs();

  explicit PinnedTabs(
      const ::tabs_api::NodeId& id);


  ~PinnedTabs();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PinnedTabsPtr>
  PinnedTabsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PinnedTabs::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PinnedTabs::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PinnedTabs::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PinnedTabs::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PinnedTabs::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PinnedTabs::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PinnedTabs_UnserializedMessageContext<
            UserType, PinnedTabs::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PinnedTabs::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PinnedTabs::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PinnedTabs_UnserializedMessageContext<
            UserType, PinnedTabs::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PinnedTabs::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::tabs_api::NodeId id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PinnedTabs::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PinnedTabs::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PinnedTabs::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PinnedTabs::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UnpinnedTabs {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UnpinnedTabs, T>::value>;
  using DataView = UnpinnedTabsDataView;
  using Data_ = internal::UnpinnedTabs_Data;

  template <typename... Args>
  static UnpinnedTabsPtr New(Args&&... args) {
    return UnpinnedTabsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UnpinnedTabsPtr From(const U& u) {
    return mojo::TypeConverter<UnpinnedTabsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UnpinnedTabs>::Convert(*this);
  }


  UnpinnedTabs();

  explicit UnpinnedTabs(
      const ::tabs_api::NodeId& id);


  ~UnpinnedTabs();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UnpinnedTabsPtr>
  UnpinnedTabsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UnpinnedTabs::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UnpinnedTabs::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UnpinnedTabs::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UnpinnedTabs::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UnpinnedTabs::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UnpinnedTabs::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UnpinnedTabs_UnserializedMessageContext<
            UserType, UnpinnedTabs::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UnpinnedTabs::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UnpinnedTabs::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UnpinnedTabs_UnserializedMessageContext<
            UserType, UnpinnedTabs::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UnpinnedTabs::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::tabs_api::NodeId id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UnpinnedTabs::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UnpinnedTabs::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UnpinnedTabs::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UnpinnedTabs::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabGroup {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabGroup, T>::value>;
  using DataView = TabGroupDataView;
  using Data_ = internal::TabGroup_Data;

  template <typename... Args>
  static TabGroupPtr New(Args&&... args) {
    return TabGroupPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabGroupPtr From(const U& u) {
    return mojo::TypeConverter<TabGroupPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabGroup>::Convert(*this);
  }


  TabGroup();

  TabGroup(
      const ::tabs_api::NodeId& id,
      const ::tab_groups::TabGroupVisualData& data);


  ~TabGroup();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabGroupPtr>
  TabGroupPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabGroup::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabGroup::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabGroup::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabGroup_UnserializedMessageContext<
            UserType, TabGroup::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabGroup::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabGroup::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabGroup_UnserializedMessageContext<
            UserType, TabGroup::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabGroup::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::tabs_api::NodeId id;
  
  ::tab_groups::TabGroupVisualData data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabGroup::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SplitTab {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SplitTab, T>::value>;
  using DataView = SplitTabDataView;
  using Data_ = internal::SplitTab_Data;

  template <typename... Args>
  static SplitTabPtr New(Args&&... args) {
    return SplitTabPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SplitTabPtr From(const U& u) {
    return mojo::TypeConverter<SplitTabPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SplitTab>::Convert(*this);
  }


  SplitTab();

  SplitTab(
      const ::tabs_api::NodeId& id,
      const ::split_tabs::SplitTabVisualData& data);


  ~SplitTab();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SplitTabPtr>
  SplitTabPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SplitTab::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SplitTab::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SplitTab::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SplitTab::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SplitTab::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SplitTab::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SplitTab_UnserializedMessageContext<
            UserType, SplitTab::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SplitTab::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SplitTab::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SplitTab_UnserializedMessageContext<
            UserType, SplitTab::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SplitTab::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::tabs_api::NodeId id;
  
  ::split_tabs::SplitTabVisualData data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SplitTab::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SplitTab::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SplitTab::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SplitTab::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  Container {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Container, T>::value>;
  using DataView = ContainerDataView;
  using Data_ = internal::Container_Data;

  template <typename... Args>
  static ContainerPtr New(Args&&... args) {
    return ContainerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContainerPtr From(const U& u) {
    return mojo::TypeConverter<ContainerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Container>::Convert(*this);
  }


  Container();

  Container(
      DataPtr data,
      std::vector<ContainerPtr> children);

Container(const Container&) = delete;
Container& operator=(const Container&) = delete;

  ~Container();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContainerPtr>
  ContainerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Container::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Container::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Container::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Container::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Container::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Container::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Container_UnserializedMessageContext<
            UserType, Container::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Container::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Container::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Container_UnserializedMessageContext<
            UserType, Container::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Container::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DataPtr data;
  
  std::vector<ContainerPtr> children;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Container::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Container::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Container::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Container::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabCreatedContainer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabCreatedContainer, T>::value>;
  using DataView = TabCreatedContainerDataView;
  using Data_ = internal::TabCreatedContainer_Data;

  template <typename... Args>
  static TabCreatedContainerPtr New(Args&&... args) {
    return TabCreatedContainerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabCreatedContainerPtr From(const U& u) {
    return mojo::TypeConverter<TabCreatedContainerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabCreatedContainer>::Convert(*this);
  }


  TabCreatedContainer();

  TabCreatedContainer(
      TabPtr tab,
      const ::tabs_api::Position& position);

TabCreatedContainer(const TabCreatedContainer&) = delete;
TabCreatedContainer& operator=(const TabCreatedContainer&) = delete;

  ~TabCreatedContainer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabCreatedContainerPtr>
  TabCreatedContainerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabCreatedContainer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabCreatedContainer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabCreatedContainer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabCreatedContainer::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabCreatedContainer::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabCreatedContainer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabCreatedContainer_UnserializedMessageContext<
            UserType, TabCreatedContainer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabCreatedContainer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabCreatedContainer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabCreatedContainer_UnserializedMessageContext<
            UserType, TabCreatedContainer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabCreatedContainer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TabPtr tab;
  
  ::tabs_api::Position position;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabCreatedContainer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabCreatedContainer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabCreatedContainer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabCreatedContainer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
DataPtr Data::Clone() const {
  switch (tag_) {
    case Tag::kTab:
      return NewTab(
          mojo::Clone(data_.tab));
    case Tag::kTabStrip:
      return NewTabStrip(
          mojo::Clone(data_.tab_strip));
    case Tag::kPinnedTabs:
      return NewPinnedTabs(
          mojo::Clone(data_.pinned_tabs));
    case Tag::kUnpinnedTabs:
      return NewUnpinnedTabs(
          mojo::Clone(data_.unpinned_tabs));
    case Tag::kTabGroup:
      return NewTabGroup(
          mojo::Clone(data_.tab_group));
    case Tag::kSplitTab:
      return NewSplitTab(
          mojo::Clone(data_.split_tab));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, Data>::value>::type*>
bool Data::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTab:
      return mojo::Equals(data_.tab, other.data_.tab);
    case Tag::kTabStrip:
      return mojo::Equals(data_.tab_strip, other.data_.tab_strip);
    case Tag::kPinnedTabs:
      return mojo::Equals(data_.pinned_tabs, other.data_.pinned_tabs);
    case Tag::kUnpinnedTabs:
      return mojo::Equals(data_.unpinned_tabs, other.data_.unpinned_tabs);
    case Tag::kTabGroup:
      return mojo::Equals(data_.tab_group, other.data_.tab_group);
    case Tag::kSplitTab:
      return mojo::Equals(data_.split_tab, other.data_.split_tab);
  }

  return false;
}
template <typename StructPtrType>
ImagePtr Image::Clone() const {
  return New(
      mojo::Clone(data_url)
  );
}

template <typename T, Image::EnableIfSame<T>*>
bool Image::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data_url, other_struct.data_url))
    return false;
  return true;
}

template <typename T, Image::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data_url < rhs.data_url)
    return true;
  if (rhs.data_url < lhs.data_url)
    return false;
  return false;
}
template <typename StructPtrType>
TabPtr Tab::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(favicon),
      mojo::Clone(alert_states),
      mojo::Clone(network_state),
      mojo::Clone(is_active),
      mojo::Clone(is_selected),
      mojo::Clone(is_blocked)
  );
}

template <typename T, Tab::EnableIfSame<T>*>
bool Tab::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->favicon, other_struct.favicon))
    return false;
  if (!mojo::Equals(this->alert_states, other_struct.alert_states))
    return false;
  if (!mojo::Equals(this->network_state, other_struct.network_state))
    return false;
  if (!mojo::Equals(this->is_active, other_struct.is_active))
    return false;
  if (!mojo::Equals(this->is_selected, other_struct.is_selected))
    return false;
  if (!mojo::Equals(this->is_blocked, other_struct.is_blocked))
    return false;
  return true;
}

template <typename T, Tab::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.favicon < rhs.favicon)
    return true;
  if (rhs.favicon < lhs.favicon)
    return false;
  if (lhs.alert_states < rhs.alert_states)
    return true;
  if (rhs.alert_states < lhs.alert_states)
    return false;
  if (lhs.network_state < rhs.network_state)
    return true;
  if (rhs.network_state < lhs.network_state)
    return false;
  if (lhs.is_active < rhs.is_active)
    return true;
  if (rhs.is_active < lhs.is_active)
    return false;
  if (lhs.is_selected < rhs.is_selected)
    return true;
  if (rhs.is_selected < lhs.is_selected)
    return false;
  if (lhs.is_blocked < rhs.is_blocked)
    return true;
  if (rhs.is_blocked < lhs.is_blocked)
    return false;
  return false;
}
template <typename StructPtrType>
TabStripPtr TabStrip::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, TabStrip::EnableIfSame<T>*>
bool TabStrip::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, TabStrip::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
PinnedTabsPtr PinnedTabs::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, PinnedTabs::EnableIfSame<T>*>
bool PinnedTabs::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, PinnedTabs::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
UnpinnedTabsPtr UnpinnedTabs::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, UnpinnedTabs::EnableIfSame<T>*>
bool UnpinnedTabs::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, UnpinnedTabs::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
TabGroupPtr TabGroup::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(data)
  );
}

template <typename T, TabGroup::EnableIfSame<T>*>
bool TabGroup::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, TabGroup::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
TabGroupVisualDataPtr TabGroupVisualData::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(color),
      mojo::Clone(is_collapsed)
  );
}

template <typename T, TabGroupVisualData::EnableIfSame<T>*>
bool TabGroupVisualData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  if (!mojo::Equals(this->is_collapsed, other_struct.is_collapsed))
    return false;
  return true;
}

template <typename T, TabGroupVisualData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  if (lhs.is_collapsed < rhs.is_collapsed)
    return true;
  if (rhs.is_collapsed < lhs.is_collapsed)
    return false;
  return false;
}
template <typename StructPtrType>
SplitTabPtr SplitTab::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(data)
  );
}

template <typename T, SplitTab::EnableIfSame<T>*>
bool SplitTab::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, SplitTab::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
SplitTabVisualDataPtr SplitTabVisualData::Clone() const {
  return New(
      mojo::Clone(layout),
      mojo::Clone(split_ratio)
  );
}

template <typename T, SplitTabVisualData::EnableIfSame<T>*>
bool SplitTabVisualData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->layout, other_struct.layout))
    return false;
  if (!mojo::Equals(this->split_ratio, other_struct.split_ratio))
    return false;
  return true;
}

template <typename T, SplitTabVisualData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.layout < rhs.layout)
    return true;
  if (rhs.layout < lhs.layout)
    return false;
  if (lhs.split_ratio < rhs.split_ratio)
    return true;
  if (rhs.split_ratio < lhs.split_ratio)
    return false;
  return false;
}
template <typename StructPtrType>
ContainerPtr Container::Clone() const {
  return New(
      mojo::Clone(data),
      mojo::Clone(children)
  );
}

template <typename T, Container::EnableIfSame<T>*>
bool Container::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->children, other_struct.children))
    return false;
  return true;
}

template <typename T, Container::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.children < rhs.children)
    return true;
  if (rhs.children < lhs.children)
    return false;
  return false;
}
template <typename StructPtrType>
TabCreatedContainerPtr TabCreatedContainer::Clone() const {
  return New(
      mojo::Clone(tab),
      mojo::Clone(position)
  );
}

template <typename T, TabCreatedContainer::EnableIfSame<T>*>
bool TabCreatedContainer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab, other_struct.tab))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  return true;
}

template <typename T, TabCreatedContainer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab < rhs.tab)
    return true;
  if (rhs.tab < lhs.tab)
    return false;
  if (lhs.position < rhs.position)
    return true;
  if (rhs.position < lhs.position)
    return false;
  return false;
}


}  // tabs_api::mojom

namespace mojo {


template <>
struct  StructTraits<::tabs_api::mojom::Image::DataView,
                                         ::tabs_api::mojom::ImagePtr> {
  static bool IsNull(const ::tabs_api::mojom::ImagePtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::ImagePtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::Image::data_url)& data_url(
      const ::tabs_api::mojom::ImagePtr& input) {
    return input->data_url;
  }

  static bool Read(::tabs_api::mojom::Image::DataView input, ::tabs_api::mojom::ImagePtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::Tab::DataView,
                                         ::tabs_api::mojom::TabPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::Tab::id)& id(
      const ::tabs_api::mojom::TabPtr& input) {
    return input->id;
  }

  static const decltype(::tabs_api::mojom::Tab::title)& title(
      const ::tabs_api::mojom::TabPtr& input) {
    return input->title;
  }

  static const decltype(::tabs_api::mojom::Tab::url)& url(
      const ::tabs_api::mojom::TabPtr& input) {
    return input->url;
  }

  static const decltype(::tabs_api::mojom::Tab::favicon)& favicon(
      const ::tabs_api::mojom::TabPtr& input) {
    return input->favicon;
  }

  static const decltype(::tabs_api::mojom::Tab::alert_states)& alert_states(
      const ::tabs_api::mojom::TabPtr& input) {
    return input->alert_states;
  }

  static decltype(::tabs_api::mojom::Tab::network_state) network_state(
      const ::tabs_api::mojom::TabPtr& input) {
    return input->network_state;
  }

  static decltype(::tabs_api::mojom::Tab::is_active) is_active(
      const ::tabs_api::mojom::TabPtr& input) {
    return input->is_active;
  }

  static decltype(::tabs_api::mojom::Tab::is_selected) is_selected(
      const ::tabs_api::mojom::TabPtr& input) {
    return input->is_selected;
  }

  static decltype(::tabs_api::mojom::Tab::is_blocked) is_blocked(
      const ::tabs_api::mojom::TabPtr& input) {
    return input->is_blocked;
  }

  static bool Read(::tabs_api::mojom::Tab::DataView input, ::tabs_api::mojom::TabPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::TabStrip::DataView,
                                         ::tabs_api::mojom::TabStripPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabStripPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabStripPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::TabStrip::id)& id(
      const ::tabs_api::mojom::TabStripPtr& input) {
    return input->id;
  }

  static bool Read(::tabs_api::mojom::TabStrip::DataView input, ::tabs_api::mojom::TabStripPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::PinnedTabs::DataView,
                                         ::tabs_api::mojom::PinnedTabsPtr> {
  static bool IsNull(const ::tabs_api::mojom::PinnedTabsPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::PinnedTabsPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::PinnedTabs::id)& id(
      const ::tabs_api::mojom::PinnedTabsPtr& input) {
    return input->id;
  }

  static bool Read(::tabs_api::mojom::PinnedTabs::DataView input, ::tabs_api::mojom::PinnedTabsPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::UnpinnedTabs::DataView,
                                         ::tabs_api::mojom::UnpinnedTabsPtr> {
  static bool IsNull(const ::tabs_api::mojom::UnpinnedTabsPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::UnpinnedTabsPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::UnpinnedTabs::id)& id(
      const ::tabs_api::mojom::UnpinnedTabsPtr& input) {
    return input->id;
  }

  static bool Read(::tabs_api::mojom::UnpinnedTabs::DataView input, ::tabs_api::mojom::UnpinnedTabsPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::TabGroup::DataView,
                                         ::tabs_api::mojom::TabGroupPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabGroupPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabGroupPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::TabGroup::id)& id(
      const ::tabs_api::mojom::TabGroupPtr& input) {
    return input->id;
  }

  static const decltype(::tabs_api::mojom::TabGroup::data)& data(
      const ::tabs_api::mojom::TabGroupPtr& input) {
    return input->data;
  }

  static bool Read(::tabs_api::mojom::TabGroup::DataView input, ::tabs_api::mojom::TabGroupPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::TabGroupVisualData::DataView,
                                         ::tabs_api::mojom::TabGroupVisualDataPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabGroupVisualDataPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabGroupVisualDataPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::TabGroupVisualData::title)& title(
      const ::tabs_api::mojom::TabGroupVisualDataPtr& input) {
    return input->title;
  }

  static decltype(::tabs_api::mojom::TabGroupVisualData::color) color(
      const ::tabs_api::mojom::TabGroupVisualDataPtr& input) {
    return input->color;
  }

  static decltype(::tabs_api::mojom::TabGroupVisualData::is_collapsed) is_collapsed(
      const ::tabs_api::mojom::TabGroupVisualDataPtr& input) {
    return input->is_collapsed;
  }

  static bool Read(::tabs_api::mojom::TabGroupVisualData::DataView input, ::tabs_api::mojom::TabGroupVisualDataPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::SplitTab::DataView,
                                         ::tabs_api::mojom::SplitTabPtr> {
  static bool IsNull(const ::tabs_api::mojom::SplitTabPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::SplitTabPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::SplitTab::id)& id(
      const ::tabs_api::mojom::SplitTabPtr& input) {
    return input->id;
  }

  static const decltype(::tabs_api::mojom::SplitTab::data)& data(
      const ::tabs_api::mojom::SplitTabPtr& input) {
    return input->data;
  }

  static bool Read(::tabs_api::mojom::SplitTab::DataView input, ::tabs_api::mojom::SplitTabPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::SplitTabVisualData::DataView,
                                         ::tabs_api::mojom::SplitTabVisualDataPtr> {
  static bool IsNull(const ::tabs_api::mojom::SplitTabVisualDataPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::SplitTabVisualDataPtr* output) { output->reset(); }

  static decltype(::tabs_api::mojom::SplitTabVisualData::layout) layout(
      const ::tabs_api::mojom::SplitTabVisualDataPtr& input) {
    return input->layout;
  }

  static decltype(::tabs_api::mojom::SplitTabVisualData::split_ratio) split_ratio(
      const ::tabs_api::mojom::SplitTabVisualDataPtr& input) {
    return input->split_ratio;
  }

  static bool Read(::tabs_api::mojom::SplitTabVisualData::DataView input, ::tabs_api::mojom::SplitTabVisualDataPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::Container::DataView,
                                         ::tabs_api::mojom::ContainerPtr> {
  static bool IsNull(const ::tabs_api::mojom::ContainerPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::ContainerPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::Container::data)& data(
      const ::tabs_api::mojom::ContainerPtr& input) {
    return input->data;
  }

  static const decltype(::tabs_api::mojom::Container::children)& children(
      const ::tabs_api::mojom::ContainerPtr& input) {
    return input->children;
  }

  static bool Read(::tabs_api::mojom::Container::DataView input, ::tabs_api::mojom::ContainerPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::TabCreatedContainer::DataView,
                                         ::tabs_api::mojom::TabCreatedContainerPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabCreatedContainerPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabCreatedContainerPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::TabCreatedContainer::tab)& tab(
      const ::tabs_api::mojom::TabCreatedContainerPtr& input) {
    return input->tab;
  }

  static const decltype(::tabs_api::mojom::TabCreatedContainer::position)& position(
      const ::tabs_api::mojom::TabCreatedContainerPtr& input) {
    return input->position;
  }

  static bool Read(::tabs_api::mojom::TabCreatedContainer::DataView input, ::tabs_api::mojom::TabCreatedContainerPtr* output);
};


template <>
struct  UnionTraits<::tabs_api::mojom::Data::DataView,
                                        ::tabs_api::mojom::DataPtr> {
  static bool IsNull(const ::tabs_api::mojom::DataPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::DataPtr* output) { output->reset(); }

  static ::tabs_api::mojom::Data::Tag GetTag(const ::tabs_api::mojom::DataPtr& input) {
    return input->which();
  }

  static const ::tabs_api::mojom::TabPtr& tab(const ::tabs_api::mojom::DataPtr& input) {
    return input->get_tab();
  }

  static const ::tabs_api::mojom::TabStripPtr& tab_strip(const ::tabs_api::mojom::DataPtr& input) {
    return input->get_tab_strip();
  }

  static const ::tabs_api::mojom::PinnedTabsPtr& pinned_tabs(const ::tabs_api::mojom::DataPtr& input) {
    return input->get_pinned_tabs();
  }

  static const ::tabs_api::mojom::UnpinnedTabsPtr& unpinned_tabs(const ::tabs_api::mojom::DataPtr& input) {
    return input->get_unpinned_tabs();
  }

  static const ::tabs_api::mojom::TabGroupPtr& tab_group(const ::tabs_api::mojom::DataPtr& input) {
    return input->get_tab_group();
  }

  static const ::tabs_api::mojom::SplitTabPtr& split_tab(const ::tabs_api::mojom::DataPtr& input) {
    return input->get_split_tab();
  }

  static bool Read(::tabs_api::mojom::Data::DataView input, ::tabs_api::mojom::DataPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_DATA_MODEL_MOJOM_H_