// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { BrowserProxy } from './browser_proxy.js';
import { getCss } from './side_panel.css.js';
import { getHtml } from './side_panel.html.js';
import { WebviewElement } from './webview.js';
export class SidePanel extends CrLitElement {
    static get is() {
        return 'side-panel';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            showing_: { state: true, type: Boolean },
            title_: { state: true, type: String },
            webView: { state: true, type: Object },
        };
    }
    #webView_accessor_storage = null;
    get webView() { return this.#webView_accessor_storage; }
    set webView(value) { this.#webView_accessor_storage = value; }
    #title__accessor_storage = '';
    get title_() { return this.#title__accessor_storage; }
    set title_(value) { this.#title__accessor_storage = value; }
    #showing__accessor_storage = false;
    get showing_() { return this.#showing__accessor_storage; }
    set showing_(value) { this.#showing__accessor_storage = value; }
    show(guestContentsId, title) {
        this.webView = new WebviewElement();
        this.webView.guestId = guestContentsId;
        this.title_ = title;
        this.showing_ = true;
        this.requestUpdate();
    }
    async close() {
        this.showing_ = false;
        this.webView = null;
        this.dispatchEvent(new Event('side-panel-closed', { bubbles: true }));
        await this.updateComplete;
        BrowserProxy.getPageHandler().onSidePanelClosed();
    }
    hide() {
        this.showing_ = false;
    }
}
customElements.define(SidePanel.is, SidePanel);
