// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_elements/cr_icon/cr_icon.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/cr_elements/icons.html.js";import{assert}from"//resources/js/assert.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{TabElement}from"./tab_element.js";import{getCss}from"./tab_strip.css.js";import{getHtml}from"./tab_strip.html.js";export class TabStrip extends CrLitElement{static get is(){return"webui-browser-tabstrip"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{tabStripController:{type:Object}}}controller;activeTab_=null;tabs_=[];addTab(tab){const tabElement=new TabElement(tab);this.tabs_=[...this.tabs_,tabElement];if(this.tabs_.length===1){this.activateTab(tab.id)}this.requestUpdate()}activateTab(tabId){if(this.activeTab_){if(this.activeTab_.tabId===tabId){return}this.activeTab_.active=false}const activeTab=this.tabs_.find((tab=>tab.tabId===tabId));assert(activeTab);this.activeTab_=activeTab;this.activeTab_.active=true}setTabGroupForTab(_,_2){}setTabGroupVisualData(_,_2){}updateTab(tabData){const tab=this.tabs_.find((tab=>tab.tabId===tabData.id));if(!tab){return}tab.updateData(tabData)}removeTab(tabId){this.tabs_=this.tabs_.filter((tab=>tab.tabId!==tabId));this.requestUpdate()}onAddTab_(){this.dispatchEvent(new CustomEvent("tab-add",{bubbles:true,composed:true}))}dragging=false;mouseX=0;translateX=0;tabOrderX=0;tabInitialX=0;outOfBoundsDragX=0;outOfBoundsDragY=0;tabElement=null;dragMouseDown(e){e=e||window.event;e.preventDefault();const path=e.composedPath();const tabElement=path.find((el=>el instanceof Element&&el.localName==="webui-browser-tab"));if(tabElement){this.tabElement=tabElement;this.dragging=true;this.mouseX=e.clientX;this.tabOrderX=this.tabElement.getBoundingClientRect().left;this.tabInitialX=this.tabElement.getBoundingClientRect().left;this.outOfBoundsDragX=e.clientX;this.outOfBoundsDragY=e.clientY;this.$.tabstrip.classList.add("nodrag");this.activateTab(this.tabElement.tabId);this.requestUpdate()}}closeDragElement(){if(!this.dragging){return}this.dragging=false;this.tabElement=null;this.translateX=0;this.mouseX=0;this.tabOrderX=0;this.tabInitialX=0;this.$.tabstrip.classList.remove("nodrag");this.tabs_.forEach((tabElement=>{tabElement.style.transform="translateX(0px)"}));this.requestUpdate()}elementDrag(e){e=e||window.event;e.preventDefault();if(!this.dragging){return}assert(this.tabElement);this.translateX=this.translateX-(this.mouseX-e.clientX);this.mouseX=e.clientX;this.tabElement.style.transform=`translateX(${this.translateX}px)`;const dragElementVisualX=this.tabInitialX+this.translateX;const tabThreshold=this.tabElement.offsetWidth/2;if(dragElementVisualX>this.tabOrderX+tabThreshold||dragElementVisualX<this.tabOrderX-tabThreshold){const index=this.tabs_.indexOf(this.tabElement);const direction=dragElementVisualX>this.tabOrderX+tabThreshold?1:-1;const swapIndex=index+direction;if(index!==-1&&index<this.tabs_.length&&swapIndex<this.tabs_.length&&swapIndex!==-1&&this.tabs_[index]&&this.tabs_[swapIndex]){this.tabOrderX=this.tabs_[swapIndex].getBoundingClientRect().left;const swappedTabTranslateX=this.tabs_[swapIndex].getTransformX()+this.tabElement.offsetWidth*(direction*-1);this.tabs_[swapIndex].style.transform=`translateX(${swappedTabTranslateX}px)`;[this.tabs_[index],this.tabs_[swapIndex]]=[this.tabs_[swapIndex],this.tabs_[index]]}}if(e.clientX<this.getBoundingClientRect().left||e.clientX>=this.getBoundingClientRect().right-1||e.clientY<this.getBoundingClientRect().top||e.clientY>this.getBoundingClientRect().bottom+10){this.outOfBoundsHandler(this.tabElement.tabId)}}outOfBoundsHandler(tabId){this.dispatchEvent(new CustomEvent("tab-drag-out-of-bounds",{bubbles:true,composed:true,detail:{tabId:tabId,drag_offset_x:this.outOfBoundsDragX,drag_offset_y:this.outOfBoundsDragY}}));this.closeDragElement()}}customElements.define(TabStrip.is,TabStrip);