import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><!--
Copyright 2021 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="support-tool-shared">:host{block-size:fit-content;display:block;margin-inline-start:40px;margin-top:72px;width:fit-content}cr-button{margin-inline-start:8px}</style>

<div id="support-tool-pages">
  <cr-page-selector selected="[[selectedPage_]]" attr-for-selected="page-index">
    <issue-details id="issueDetails"
        page-index$="[[supportToolPageIndexEnum_.ISSUE_DETAILS]]">
    </issue-details>
    <data-collectors id="dataCollectors"
        page-index$="[[supportToolPageIndexEnum_.DATA_COLLECTOR_SELECTION]]">
    </data-collectors>
    <spinner-page id="spinnerPage"  page-title="$i18n{dataCollectionSpinner}"
        page-index$="[[supportToolPageIndexEnum_.SPINNER]]">
    </spinner-page>
    <pii-selection id="piiSelection"
        page-index$="[[supportToolPageIndexEnum_.PII_SELECTION]]">
    </pii-selection>
    <spinner-page id="exportSpinner" page-title="$i18n{dataExportSpinner}"
        page-index$="[[supportToolPageIndexEnum_.EXPORT_SPINNER]]">
    </spinner-page>
    <data-export-done id="dataExportDone"
        page-index$="[[supportToolPageIndexEnum_.DATA_EXPORT_DONE]]">
    </data-export-done>
  </cr-page-selector>
</div>
<div class="navigation-buttons" id="continueButtonContainer"
    hidden$="[[shouldHideContinueButtonContainer_(selectedPage_)]]">
  <cr-button id="backButton" hidden$="[[shouldHideBackButton_(selectedPage_)]]"
      on-click="onBackClick_">
    $i18n{backButtonText}
  </cr-button>
  <cr-button id="continueButton" class="action-button"
      on-click="onContinueClick_">
    $i18n{continueButtonText}
  </cr-button>
</div>
<cr-toast id="errorMessageToast" duration="0" tabindex="0"
    aria-labelledby="error-message">
  <span id="error-message">[[errorMessage_]]</span>
  <cr-button on-click="onErrorMessageToastCloseClicked_">
    $i18n{dismissButtonText}
  </cr-button>
</cr-toast>
<!--_html_template_end_-->`;
}