export declare const HIGHLIGHTED_LINK_CLASS = "highlighted-link";
export interface ContentListener {
    onContentStateChange(): void;
    onNewPageDrawn(): void;
}
export declare enum ContentType {
    LOADING = 0,
    NO_CONTENT = 1,
    NO_SELECTABLE_CONTENT = 2,
    HAS_CONTENT = 3
}
export interface ContentState {
    type: ContentType;
    imagePath: string;
    darkImagePath: string;
    heading: string;
    subheading: string;
}
export declare class ContentController {
    private nodeStore_;
    private speechController_;
    private logger_;
    private readonly listeners_;
    private currentState_;
    private previousRootId_?;
    getState(): ContentState;
    setState(type: ContentType): void;
    hasContent(): boolean;
    isEmpty(): boolean;
    setEmpty(): void;
    private getNoContentType_;
    addListener(listener: ContentListener): void;
    onNodeWillBeDeleted(nodeId: number): void;
    updateContent(shadowRoot?: ShadowRoot): Node | null;
    private buildSubtree_;
    private appendChildSubtrees_;
    private setLinkAttributes_;
    private createTextNode_;
    updateLinks(shadowRoot?: ShadowRoot): void;
    private transformLinkContainer_;
    private shouldShowLinks_;
    onSelectionChange(shadowRoot?: ShadowRoot): void;
    loadImages(): void;
    onImageDownloaded(nodeId: number): Promise<void>;
    updateImages(shadowRoot?: ShadowRoot): void;
    private markTextNodesHiddenIfImagesHidden_;
    static getInstance(): ContentController;
    static setInstance(obj: ContentController): void;
}
