// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import './button_label.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss } from './hover_button.css.js';
import { getHtml } from './hover_button.html.js';
export class HoverButtonElement extends CrLitElement {
    static get is() {
        return 'customize-chrome-hover-button';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            ariaButtonLabel: { type: String },
            label: { type: String },
            labelDescription: { type: String },
        };
    }
    #ariaButtonLabel_accessor_storage = null;
    get ariaButtonLabel() { return this.#ariaButtonLabel_accessor_storage; }
    set ariaButtonLabel(value) { this.#ariaButtonLabel_accessor_storage = value; }
    #label_accessor_storage = '';
    get label() { return this.#label_accessor_storage; }
    set label(value) { this.#label_accessor_storage = value; }
    #labelDescription_accessor_storage = null;
    get labelDescription() { return this.#labelDescription_accessor_storage; }
    set labelDescription(value) { this.#labelDescription_accessor_storage = value; }
    constructor() {
        super();
        this.addEventListener('keydown', this.onKeyDown_.bind(this));
    }
    focus() {
        this.$.hoverButton.focus();
    }
    onKeyDown_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        this.click();
    }
}
customElements.define(HoverButtonElement.is, HoverButtonElement);
