// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { PriceInsightsHandlerFactory, PriceInsightsHandlerRemote } from './price_insights.mojom-webui.js';
let instance = null;
export class PriceInsightsBrowserProxyImpl {
    handler;
    constructor() {
        this.handler = new PriceInsightsHandlerRemote();
        const factory = PriceInsightsHandlerFactory.getRemote();
        factory.createPriceInsightsHandler(this.handler.$.bindNewPipeAndPassReceiver());
    }
    showSidePanelUi() {
        this.handler.showSidePanelUI();
    }
    showFeedback() {
        this.handler.showFeedback();
    }
    static getInstance() {
        return instance || (instance = new PriceInsightsBrowserProxyImpl());
    }
    static setInstance(proxy) {
        instance = proxy;
    }
}
