import '/strings.m.js';
import './icons.html.js';
import '//bookmarks-side-panel.top-chrome/shared/sp_shared_style.css.js';
import '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/icons.html.js';
import type { CrActionMenuElement } from '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { BookmarksTreeNode } from './bookmarks.mojom-webui.js';
export interface PowerBookmarksContextMenuElement {
    $: {
        menu: CrActionMenuElement;
    };
}
export declare enum MenuItemId {
    OPEN_NEW_TAB = 0,
    OPEN_NEW_WINDOW = 1,
    OPEN_INCOGNITO = 2,
    OPEN_NEW_TAB_GROUP = 3,
    EDIT = 4,
    ADD_TO_BOOKMARKS_BAR = 5,
    REMOVE_FROM_BOOKMARKS_BAR = 6,
    TRACK_PRICE = 7,
    RENAME = 8,
    DELETE = 9,
    DIVIDER = 10,
    OPEN_SPLIT_VIEW = 11
}
export interface MenuItem {
    id: MenuItemId;
    label?: string;
    disabled?: boolean;
}
export declare class PowerBookmarksContextMenuElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        bookmarks_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        priceTracked_: BooleanConstructor;
        priceTrackingEligible_: BooleanConstructor;
        isInSplitView_: BooleanConstructor;
    };
    private bookmarksApi_;
    private priceTrackingProxy_;
    private bookmarks_;
    private priceTracked_;
    private priceTrackingEligible_;
    private isInSplitView_;
    showAt(target: HTMLElement, bookmarks: BookmarksTreeNode[], priceTracked: boolean, priceTrackingEligible: boolean, isInSplitView: boolean, onShown?: Function): void;
    showAtPosition(event: MouseEvent, bookmarks: BookmarksTreeNode[], priceTracked: boolean, priceTrackingEligible: boolean, isInSplitView: boolean, onShown?: Function): void;
    isOpen(): boolean;
    private getMenuItemsForBookmarks_;
    private showDivider_;
    private dispatchDisabledFeatureEvent_;
    /**
     * Close the menu on mousedown so clicks can propagate to the underlying UI.
     * This allows the user to right click the list while a context menu is
     * showing and get another context menu.
     */
    private onMousedown_;
    private onMenuItemClicked_;
}
declare global {
    interface HTMLElementTagNameMap {
        'power-bookmarks-context-menu': PowerBookmarksContextMenuElement;
    }
}
