import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/cr_elements/mwb_element_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_auto_img/cr_auto_img.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import './icons.html.js';
import type { BookmarkProductInfo } from '//resources/cr_components/commerce/shared.mojom-webui.js';
import type { CrToastElement } from 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export declare const LOCAL_STORAGE_EXPAND_STATUS_KEY = "shoppingListExpanded";
export declare const ACTION_BUTTON_TRACK_IMAGE = "shopping-list:shopping-list-track-icon";
export declare const ACTION_BUTTON_UNTRACK_IMAGE = "shopping-list:shopping-list-untrack-icon";
export interface ShoppingListElement {
    $: {
        errorToast: CrToastElement;
    };
}
export declare class ShoppingListElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        open_: {
            type: BooleanConstructor;
            value: boolean;
        };
        untrackedItems_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        productInfos: {
            type: ArrayConstructor;
            value: () => never[];
            observer: string;
        };
    };
    productInfos: BookmarkProductInfo[];
    private untrackedItems_;
    private open_;
    private bookmarksApi_;
    private priceTrackingProxy_;
    private listenerIds_;
    private retryOperationCallback_;
    connectedCallback(): void;
    disconnectedCallback(): void;
    private getFaviconUrl_;
    private onFolderClick_;
    private onProductAuxClick_;
    private onProductClick_;
    private onProductContextMenu_;
    private onActionButtonClick_;
    private getIconForItem_;
    private getButtonDescriptionForItem_;
    private onBookmarkPriceTracked;
    private onBookmarkPriceUntracked;
    private isSameProduct_;
    private onProductInfoChanged_;
    private onImageLoadSuccess_;
    private onImageLoadError_;
    private onBookmarkOperationFailed;
    private onErrorRetryClicked_;
}
declare global {
    interface HTMLElementTagNameMap {
        'shopping-list': ShoppingListElement;
    }
}
