// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{ClickModifiersSpec as ui_mojom_ClickModifiersSpec}from"//resources/mojo/ui/base/mojom/window_open_disposition.mojom-webui.js";import{PointSpec as gfx_mojom_PointSpec}from"//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js";export const ActionSourceSpec={$:mojo.internal.Enum()};export var ActionSource;(function(ActionSource){ActionSource[ActionSource["MIN_VALUE"]=0]="MIN_VALUE";ActionSource[ActionSource["MAX_VALUE"]=1]="MAX_VALUE";ActionSource[ActionSource["kBookmark"]=0]="kBookmark";ActionSource[ActionSource["kPriceTracking"]=1]="kPriceTracking"})(ActionSource||(ActionSource={}));export const SortOrderSpec={$:mojo.internal.Enum()};export var SortOrder;(function(SortOrder){SortOrder[SortOrder["MIN_VALUE"]=0]="MIN_VALUE";SortOrder[SortOrder["MAX_VALUE"]=5]="MAX_VALUE";SortOrder[SortOrder["kNewest"]=0]="kNewest";SortOrder[SortOrder["kOldest"]=1]="kOldest";SortOrder[SortOrder["kLastOpened"]=2]="kLastOpened";SortOrder[SortOrder["kAlphabetical"]=3]="kAlphabetical";SortOrder[SortOrder["kReverseAlphabetical"]=4]="kReverseAlphabetical";SortOrder[SortOrder["kCount"]=5]="kCount"})(SortOrder||(SortOrder={}));export const ViewTypeSpec={$:mojo.internal.Enum()};export var ViewType;(function(ViewType){ViewType[ViewType["MIN_VALUE"]=0]="MIN_VALUE";ViewType[ViewType["MAX_VALUE"]=2]="MAX_VALUE";ViewType[ViewType["kCompact"]=0]="kCompact";ViewType[ViewType["kExpanded"]=1]="kExpanded";ViewType[ViewType["kCount"]=2]="kCount"})(ViewType||(ViewType={}));export class BookmarksPageHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"side_panel.mojom.BookmarksPageHandlerFactory",scope)}}export class BookmarksPageHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(BookmarksPageHandlerFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createBookmarksPageHandler(page,handler){this.proxy.sendMessage(0,BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsSpec.$,null,[page,handler],false)}}export class BookmarksPageHandlerFactoryReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BookmarksPageHandlerFactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsSpec.$,null,impl.createBookmarksPageHandler.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class BookmarksPageHandlerFactory{static get $interfaceName(){return"side_panel.mojom.BookmarksPageHandlerFactory"}static getRemote(){let remote=new BookmarksPageHandlerFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class BookmarksPageHandlerFactoryCallbackRouter{helper_internal_;$;router_;createBookmarksPageHandler;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BookmarksPageHandlerFactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.createBookmarksPageHandler=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsSpec.$,null,this.createBookmarksPageHandler.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class BookmarksPageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"side_panel.mojom.BookmarksPageHandler",scope)}}export class BookmarksPageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(BookmarksPageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}bookmarkCurrentTabInFolder(folderId){this.proxy.sendMessage(0,BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsSpec.$,null,[folderId],false)}createFolder(folderId,title){return this.proxy.sendMessage(1,BookmarksPageHandler_CreateFolder_ParamsSpec.$,BookmarksPageHandler_CreateFolder_ResponseParamsSpec.$,[folderId,title],false)}dropBookmarks(folderId){return this.proxy.sendMessage(2,BookmarksPageHandler_DropBookmarks_ParamsSpec.$,BookmarksPageHandler_DropBookmarks_ResponseParamsSpec.$,[folderId],false)}executeEditCommand(nodeIds,source){this.proxy.sendMessage(3,BookmarksPageHandler_ExecuteEditCommand_ParamsSpec.$,null,[nodeIds,source],false)}executeMoveCommand(nodeIds,source){this.proxy.sendMessage(4,BookmarksPageHandler_ExecuteMoveCommand_ParamsSpec.$,null,[nodeIds,source],false)}executeOpenInNewTabCommand(sidePanelIds,source){this.proxy.sendMessage(5,BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsSpec.$,null,[sidePanelIds,source],false)}executeOpenInNewWindowCommand(sidePanelIds,source){this.proxy.sendMessage(6,BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsSpec.$,null,[sidePanelIds,source],false)}executeOpenInIncognitoWindowCommand(sidePanelIds,source){this.proxy.sendMessage(7,BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsSpec.$,null,[sidePanelIds,source],false)}executeOpenInNewTabGroupCommand(sidePanelIds,source){this.proxy.sendMessage(8,BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsSpec.$,null,[sidePanelIds,source],false)}executeOpenInSplitViewCommand(nodeIds,source){this.proxy.sendMessage(9,BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsSpec.$,null,[nodeIds,source],false)}executeAddToBookmarksBarCommand(nodeId,source){this.proxy.sendMessage(10,BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsSpec.$,null,[nodeId,source],false)}executeRemoveFromBookmarksBarCommand(nodeId,source){this.proxy.sendMessage(11,BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsSpec.$,null,[nodeId,source],false)}executeDeleteCommand(nodeIds,source){this.proxy.sendMessage(12,BookmarksPageHandler_ExecuteDeleteCommand_ParamsSpec.$,null,[nodeIds,source],false)}openBookmark(nodeId,parentFolderDepth,clickModifiers,source){this.proxy.sendMessage(13,BookmarksPageHandler_OpenBookmark_ParamsSpec.$,null,[nodeId,parentFolderDepth,clickModifiers,source],false)}undo(){this.proxy.sendMessage(14,BookmarksPageHandler_Undo_ParamsSpec.$,null,[],false)}renameBookmark(nodeId,newTitle){this.proxy.sendMessage(15,BookmarksPageHandler_RenameBookmark_ParamsSpec.$,null,[nodeId,newTitle],false)}moveBookmark(nodeId,folderId){this.proxy.sendMessage(16,BookmarksPageHandler_MoveBookmark_ParamsSpec.$,null,[nodeId,folderId],false)}removeBookmarks(nodeIds){return this.proxy.sendMessage(17,BookmarksPageHandler_RemoveBookmarks_ParamsSpec.$,BookmarksPageHandler_RemoveBookmarks_ResponseParamsSpec.$,[nodeIds],false)}setSortOrder(sortOrder){this.proxy.sendMessage(18,BookmarksPageHandler_SetSortOrder_ParamsSpec.$,null,[sortOrder],false)}setViewType(viewType){this.proxy.sendMessage(19,BookmarksPageHandler_SetViewType_ParamsSpec.$,null,[viewType],false)}showContextMenu(id,point,source){this.proxy.sendMessage(20,BookmarksPageHandler_ShowContextMenu_ParamsSpec.$,null,[id,point,source],false)}showUI(){this.proxy.sendMessage(21,BookmarksPageHandler_ShowUI_ParamsSpec.$,null,[],false)}getAllBookmarks(){return this.proxy.sendMessage(22,BookmarksPageHandler_GetAllBookmarks_ParamsSpec.$,BookmarksPageHandler_GetAllBookmarks_ResponseParamsSpec.$,[],false)}}export class BookmarksPageHandlerReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BookmarksPageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsSpec.$,null,impl.bookmarkCurrentTabInFolder.bind(impl),false);this.helper_internal_.registerHandler(1,BookmarksPageHandler_CreateFolder_ParamsSpec.$,BookmarksPageHandler_CreateFolder_ResponseParamsSpec.$,impl.createFolder.bind(impl),false);this.helper_internal_.registerHandler(2,BookmarksPageHandler_DropBookmarks_ParamsSpec.$,BookmarksPageHandler_DropBookmarks_ResponseParamsSpec.$,impl.dropBookmarks.bind(impl),false);this.helper_internal_.registerHandler(3,BookmarksPageHandler_ExecuteEditCommand_ParamsSpec.$,null,impl.executeEditCommand.bind(impl),false);this.helper_internal_.registerHandler(4,BookmarksPageHandler_ExecuteMoveCommand_ParamsSpec.$,null,impl.executeMoveCommand.bind(impl),false);this.helper_internal_.registerHandler(5,BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsSpec.$,null,impl.executeOpenInNewTabCommand.bind(impl),false);this.helper_internal_.registerHandler(6,BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsSpec.$,null,impl.executeOpenInNewWindowCommand.bind(impl),false);this.helper_internal_.registerHandler(7,BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsSpec.$,null,impl.executeOpenInIncognitoWindowCommand.bind(impl),false);this.helper_internal_.registerHandler(8,BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsSpec.$,null,impl.executeOpenInNewTabGroupCommand.bind(impl),false);this.helper_internal_.registerHandler(9,BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsSpec.$,null,impl.executeOpenInSplitViewCommand.bind(impl),false);this.helper_internal_.registerHandler(10,BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsSpec.$,null,impl.executeAddToBookmarksBarCommand.bind(impl),false);this.helper_internal_.registerHandler(11,BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsSpec.$,null,impl.executeRemoveFromBookmarksBarCommand.bind(impl),false);this.helper_internal_.registerHandler(12,BookmarksPageHandler_ExecuteDeleteCommand_ParamsSpec.$,null,impl.executeDeleteCommand.bind(impl),false);this.helper_internal_.registerHandler(13,BookmarksPageHandler_OpenBookmark_ParamsSpec.$,null,impl.openBookmark.bind(impl),false);this.helper_internal_.registerHandler(14,BookmarksPageHandler_Undo_ParamsSpec.$,null,impl.undo.bind(impl),false);this.helper_internal_.registerHandler(15,BookmarksPageHandler_RenameBookmark_ParamsSpec.$,null,impl.renameBookmark.bind(impl),false);this.helper_internal_.registerHandler(16,BookmarksPageHandler_MoveBookmark_ParamsSpec.$,null,impl.moveBookmark.bind(impl),false);this.helper_internal_.registerHandler(17,BookmarksPageHandler_RemoveBookmarks_ParamsSpec.$,BookmarksPageHandler_RemoveBookmarks_ResponseParamsSpec.$,impl.removeBookmarks.bind(impl),false);this.helper_internal_.registerHandler(18,BookmarksPageHandler_SetSortOrder_ParamsSpec.$,null,impl.setSortOrder.bind(impl),false);this.helper_internal_.registerHandler(19,BookmarksPageHandler_SetViewType_ParamsSpec.$,null,impl.setViewType.bind(impl),false);this.helper_internal_.registerHandler(20,BookmarksPageHandler_ShowContextMenu_ParamsSpec.$,null,impl.showContextMenu.bind(impl),false);this.helper_internal_.registerHandler(21,BookmarksPageHandler_ShowUI_ParamsSpec.$,null,impl.showUI.bind(impl),false);this.helper_internal_.registerHandler(22,BookmarksPageHandler_GetAllBookmarks_ParamsSpec.$,BookmarksPageHandler_GetAllBookmarks_ResponseParamsSpec.$,impl.getAllBookmarks.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class BookmarksPageHandler{static get $interfaceName(){return"side_panel.mojom.BookmarksPageHandler"}static getRemote(){let remote=new BookmarksPageHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class BookmarksPageHandlerCallbackRouter{helper_internal_;$;router_;bookmarkCurrentTabInFolder;createFolder;dropBookmarks;executeEditCommand;executeMoveCommand;executeOpenInNewTabCommand;executeOpenInNewWindowCommand;executeOpenInIncognitoWindowCommand;executeOpenInNewTabGroupCommand;executeOpenInSplitViewCommand;executeAddToBookmarksBarCommand;executeRemoveFromBookmarksBarCommand;executeDeleteCommand;openBookmark;undo;renameBookmark;moveBookmark;removeBookmarks;setSortOrder;setViewType;showContextMenu;showUI;getAllBookmarks;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BookmarksPageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.bookmarkCurrentTabInFolder=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsSpec.$,null,this.bookmarkCurrentTabInFolder.createReceiverHandler(false),false);this.createFolder=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,BookmarksPageHandler_CreateFolder_ParamsSpec.$,BookmarksPageHandler_CreateFolder_ResponseParamsSpec.$,this.createFolder.createReceiverHandler(true),false);this.dropBookmarks=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,BookmarksPageHandler_DropBookmarks_ParamsSpec.$,BookmarksPageHandler_DropBookmarks_ResponseParamsSpec.$,this.dropBookmarks.createReceiverHandler(true),false);this.executeEditCommand=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,BookmarksPageHandler_ExecuteEditCommand_ParamsSpec.$,null,this.executeEditCommand.createReceiverHandler(false),false);this.executeMoveCommand=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,BookmarksPageHandler_ExecuteMoveCommand_ParamsSpec.$,null,this.executeMoveCommand.createReceiverHandler(false),false);this.executeOpenInNewTabCommand=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsSpec.$,null,this.executeOpenInNewTabCommand.createReceiverHandler(false),false);this.executeOpenInNewWindowCommand=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsSpec.$,null,this.executeOpenInNewWindowCommand.createReceiverHandler(false),false);this.executeOpenInIncognitoWindowCommand=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsSpec.$,null,this.executeOpenInIncognitoWindowCommand.createReceiverHandler(false),false);this.executeOpenInNewTabGroupCommand=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsSpec.$,null,this.executeOpenInNewTabGroupCommand.createReceiverHandler(false),false);this.executeOpenInSplitViewCommand=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsSpec.$,null,this.executeOpenInSplitViewCommand.createReceiverHandler(false),false);this.executeAddToBookmarksBarCommand=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsSpec.$,null,this.executeAddToBookmarksBarCommand.createReceiverHandler(false),false);this.executeRemoveFromBookmarksBarCommand=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsSpec.$,null,this.executeRemoveFromBookmarksBarCommand.createReceiverHandler(false),false);this.executeDeleteCommand=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,BookmarksPageHandler_ExecuteDeleteCommand_ParamsSpec.$,null,this.executeDeleteCommand.createReceiverHandler(false),false);this.openBookmark=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(13,BookmarksPageHandler_OpenBookmark_ParamsSpec.$,null,this.openBookmark.createReceiverHandler(false),false);this.undo=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(14,BookmarksPageHandler_Undo_ParamsSpec.$,null,this.undo.createReceiverHandler(false),false);this.renameBookmark=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(15,BookmarksPageHandler_RenameBookmark_ParamsSpec.$,null,this.renameBookmark.createReceiverHandler(false),false);this.moveBookmark=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(16,BookmarksPageHandler_MoveBookmark_ParamsSpec.$,null,this.moveBookmark.createReceiverHandler(false),false);this.removeBookmarks=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(17,BookmarksPageHandler_RemoveBookmarks_ParamsSpec.$,BookmarksPageHandler_RemoveBookmarks_ResponseParamsSpec.$,this.removeBookmarks.createReceiverHandler(true),false);this.setSortOrder=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(18,BookmarksPageHandler_SetSortOrder_ParamsSpec.$,null,this.setSortOrder.createReceiverHandler(false),false);this.setViewType=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(19,BookmarksPageHandler_SetViewType_ParamsSpec.$,null,this.setViewType.createReceiverHandler(false),false);this.showContextMenu=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(20,BookmarksPageHandler_ShowContextMenu_ParamsSpec.$,null,this.showContextMenu.createReceiverHandler(false),false);this.showUI=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(21,BookmarksPageHandler_ShowUI_ParamsSpec.$,null,this.showUI.createReceiverHandler(false),false);this.getAllBookmarks=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(22,BookmarksPageHandler_GetAllBookmarks_ParamsSpec.$,BookmarksPageHandler_GetAllBookmarks_ResponseParamsSpec.$,this.getAllBookmarks.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class BookmarksPagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"side_panel.mojom.BookmarksPage",scope)}}export class BookmarksPageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(BookmarksPagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onBookmarkNodeAdded(node){this.proxy.sendMessage(0,BookmarksPage_OnBookmarkNodeAdded_ParamsSpec.$,null,[node],false)}onBookmarkNodesRemoved(nodeIds){this.proxy.sendMessage(1,BookmarksPage_OnBookmarkNodesRemoved_ParamsSpec.$,null,[nodeIds],false)}onBookmarkParentFolderChildrenReordered(folderId,childrenOrderedIds){this.proxy.sendMessage(2,BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsSpec.$,null,[folderId,childrenOrderedIds],false)}onBookmarkNodeMoved(oldParentIndex,oldNodeIndex,newParentIndex,newNodeIndex){this.proxy.sendMessage(3,BookmarksPage_OnBookmarkNodeMoved_ParamsSpec.$,null,[oldParentIndex,oldNodeIndex,newParentIndex,newNodeIndex],false)}onBookmarkNodeChanged(id,newTitle,newUrl){this.proxy.sendMessage(4,BookmarksPage_OnBookmarkNodeChanged_ParamsSpec.$,null,[id,newTitle,newUrl],false)}}export class BookmarksPageReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BookmarksPageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,BookmarksPage_OnBookmarkNodeAdded_ParamsSpec.$,null,impl.onBookmarkNodeAdded.bind(impl),false);this.helper_internal_.registerHandler(1,BookmarksPage_OnBookmarkNodesRemoved_ParamsSpec.$,null,impl.onBookmarkNodesRemoved.bind(impl),false);this.helper_internal_.registerHandler(2,BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsSpec.$,null,impl.onBookmarkParentFolderChildrenReordered.bind(impl),false);this.helper_internal_.registerHandler(3,BookmarksPage_OnBookmarkNodeMoved_ParamsSpec.$,null,impl.onBookmarkNodeMoved.bind(impl),false);this.helper_internal_.registerHandler(4,BookmarksPage_OnBookmarkNodeChanged_ParamsSpec.$,null,impl.onBookmarkNodeChanged.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class BookmarksPage{static get $interfaceName(){return"side_panel.mojom.BookmarksPage"}static getRemote(){let remote=new BookmarksPageRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class BookmarksPageCallbackRouter{helper_internal_;$;router_;onBookmarkNodeAdded;onBookmarkNodesRemoved;onBookmarkParentFolderChildrenReordered;onBookmarkNodeMoved;onBookmarkNodeChanged;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BookmarksPageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onBookmarkNodeAdded=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,BookmarksPage_OnBookmarkNodeAdded_ParamsSpec.$,null,this.onBookmarkNodeAdded.createReceiverHandler(false),false);this.onBookmarkNodesRemoved=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,BookmarksPage_OnBookmarkNodesRemoved_ParamsSpec.$,null,this.onBookmarkNodesRemoved.createReceiverHandler(false),false);this.onBookmarkParentFolderChildrenReordered=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsSpec.$,null,this.onBookmarkParentFolderChildrenReordered.createReceiverHandler(false),false);this.onBookmarkNodeMoved=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,BookmarksPage_OnBookmarkNodeMoved_ParamsSpec.$,null,this.onBookmarkNodeMoved.createReceiverHandler(false),false);this.onBookmarkNodeChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,BookmarksPage_OnBookmarkNodeChanged_ParamsSpec.$,null,this.onBookmarkNodeChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const BookmarksTreeNodeSpec={$:{}};export const BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsSpec={$:{}};export const BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsSpec={$:{}};export const BookmarksPageHandler_CreateFolder_ParamsSpec={$:{}};export const BookmarksPageHandler_CreateFolder_ResponseParamsSpec={$:{}};export const BookmarksPageHandler_DropBookmarks_ParamsSpec={$:{}};export const BookmarksPageHandler_DropBookmarks_ResponseParamsSpec={$:{}};export const BookmarksPageHandler_ExecuteEditCommand_ParamsSpec={$:{}};export const BookmarksPageHandler_ExecuteMoveCommand_ParamsSpec={$:{}};export const BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsSpec={$:{}};export const BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsSpec={$:{}};export const BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsSpec={$:{}};export const BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsSpec={$:{}};export const BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsSpec={$:{}};export const BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsSpec={$:{}};export const BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsSpec={$:{}};export const BookmarksPageHandler_ExecuteDeleteCommand_ParamsSpec={$:{}};export const BookmarksPageHandler_OpenBookmark_ParamsSpec={$:{}};export const BookmarksPageHandler_Undo_ParamsSpec={$:{}};export const BookmarksPageHandler_RenameBookmark_ParamsSpec={$:{}};export const BookmarksPageHandler_MoveBookmark_ParamsSpec={$:{}};export const BookmarksPageHandler_RemoveBookmarks_ParamsSpec={$:{}};export const BookmarksPageHandler_RemoveBookmarks_ResponseParamsSpec={$:{}};export const BookmarksPageHandler_SetSortOrder_ParamsSpec={$:{}};export const BookmarksPageHandler_SetViewType_ParamsSpec={$:{}};export const BookmarksPageHandler_ShowContextMenu_ParamsSpec={$:{}};export const BookmarksPageHandler_ShowUI_ParamsSpec={$:{}};export const BookmarksPageHandler_GetAllBookmarks_ParamsSpec={$:{}};export const BookmarksPageHandler_GetAllBookmarks_ResponseParamsSpec={$:{}};export const BookmarksPage_OnBookmarkNodeAdded_ParamsSpec={$:{}};export const BookmarksPage_OnBookmarkNodesRemoved_ParamsSpec={$:{}};export const BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsSpec={$:{}};export const BookmarksPage_OnBookmarkNodeMoved_ParamsSpec={$:{}};export const BookmarksPage_OnBookmarkNodeChanged_ParamsSpec={$:{}};mojo.internal.Struct(BookmarksTreeNodeSpec.$,"BookmarksTreeNode",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("parentId",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("index",16,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("title",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("url",32,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("children",40,0,mojo.internal.Array(BookmarksTreeNodeSpec.$,false),null,true,0,undefined,undefined),mojo.internal.StructField("date_added_$flag",20,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"date_added_$value",originalFieldName:"dateAdded"},undefined),mojo.internal.StructField("date_added_$value",48,0,mojo.internal.Double,0,false,0,{isPrimary:false,originalFieldName:"dateAdded"},undefined),mojo.internal.StructField("date_last_used_$flag",20,1,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"date_last_used_$value",originalFieldName:"dateLastUsed"},undefined),mojo.internal.StructField("date_last_used_$value",56,0,mojo.internal.Double,0,false,0,{isPrimary:false,originalFieldName:"dateLastUsed"},undefined),mojo.internal.StructField("unmodifiable",20,2,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,72]]);mojo.internal.Struct(BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsSpec.$,"BookmarksPageHandlerFactory_CreateBookmarksPageHandler_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(BookmarksPageRemote),null,false,0,undefined,undefined),mojo.internal.StructField("handler",8,0,mojo.internal.InterfaceRequest(BookmarksPageHandlerPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsSpec.$,"BookmarksPageHandler_BookmarkCurrentTabInFolder_Params",[mojo.internal.StructField("folderId",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(BookmarksPageHandler_CreateFolder_ParamsSpec.$,"BookmarksPageHandler_CreateFolder_Params",[mojo.internal.StructField("folderId",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("title",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_CreateFolder_ResponseParamsSpec.$,"BookmarksPageHandler_CreateFolder_ResponseParams",[mojo.internal.StructField("newFolderId",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(BookmarksPageHandler_DropBookmarks_ParamsSpec.$,"BookmarksPageHandler_DropBookmarks_Params",[mojo.internal.StructField("folderId",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(BookmarksPageHandler_DropBookmarks_ResponseParamsSpec.$,"BookmarksPageHandler_DropBookmarks_ResponseParams",[],[[0,8]]);mojo.internal.Struct(BookmarksPageHandler_ExecuteEditCommand_ParamsSpec.$,"BookmarksPageHandler_ExecuteEditCommand_Params",[mojo.internal.StructField("nodeIds",0,0,mojo.internal.Array(mojo.internal.Int64,false),null,false,0,undefined,undefined),mojo.internal.StructField("source",8,0,ActionSourceSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_ExecuteMoveCommand_ParamsSpec.$,"BookmarksPageHandler_ExecuteMoveCommand_Params",[mojo.internal.StructField("nodeIds",0,0,mojo.internal.Array(mojo.internal.Int64,false),null,false,0,undefined,undefined),mojo.internal.StructField("source",8,0,ActionSourceSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsSpec.$,"BookmarksPageHandler_ExecuteOpenInNewTabCommand_Params",[mojo.internal.StructField("sidePanelIds",0,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined),mojo.internal.StructField("source",8,0,ActionSourceSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsSpec.$,"BookmarksPageHandler_ExecuteOpenInNewWindowCommand_Params",[mojo.internal.StructField("sidePanelIds",0,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined),mojo.internal.StructField("source",8,0,ActionSourceSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsSpec.$,"BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_Params",[mojo.internal.StructField("sidePanelIds",0,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined),mojo.internal.StructField("source",8,0,ActionSourceSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsSpec.$,"BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_Params",[mojo.internal.StructField("sidePanelIds",0,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined),mojo.internal.StructField("source",8,0,ActionSourceSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsSpec.$,"BookmarksPageHandler_ExecuteOpenInSplitViewCommand_Params",[mojo.internal.StructField("nodeIds",0,0,mojo.internal.Array(mojo.internal.Int64,false),null,false,0,undefined,undefined),mojo.internal.StructField("source",8,0,ActionSourceSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsSpec.$,"BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_Params",[mojo.internal.StructField("nodeId",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("source",8,0,ActionSourceSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsSpec.$,"BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_Params",[mojo.internal.StructField("nodeId",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("source",8,0,ActionSourceSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_ExecuteDeleteCommand_ParamsSpec.$,"BookmarksPageHandler_ExecuteDeleteCommand_Params",[mojo.internal.StructField("nodeIds",0,0,mojo.internal.Array(mojo.internal.Int64,false),null,false,0,undefined,undefined),mojo.internal.StructField("source",8,0,ActionSourceSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_OpenBookmark_ParamsSpec.$,"BookmarksPageHandler_OpenBookmark_Params",[mojo.internal.StructField("nodeId",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("parentFolderDepth",8,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("clickModifiers",16,0,ui_mojom_ClickModifiersSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("source",12,0,ActionSourceSpec.$,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(BookmarksPageHandler_Undo_ParamsSpec.$,"BookmarksPageHandler_Undo_Params",[],[[0,8]]);mojo.internal.Struct(BookmarksPageHandler_RenameBookmark_ParamsSpec.$,"BookmarksPageHandler_RenameBookmark_Params",[mojo.internal.StructField("nodeId",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("newTitle",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_MoveBookmark_ParamsSpec.$,"BookmarksPageHandler_MoveBookmark_Params",[mojo.internal.StructField("nodeId",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("folderId",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPageHandler_RemoveBookmarks_ParamsSpec.$,"BookmarksPageHandler_RemoveBookmarks_Params",[mojo.internal.StructField("nodeIds",0,0,mojo.internal.Array(mojo.internal.Int64,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(BookmarksPageHandler_RemoveBookmarks_ResponseParamsSpec.$,"BookmarksPageHandler_RemoveBookmarks_ResponseParams",[],[[0,8]]);mojo.internal.Struct(BookmarksPageHandler_SetSortOrder_ParamsSpec.$,"BookmarksPageHandler_SetSortOrder_Params",[mojo.internal.StructField("sortOrder",0,0,SortOrderSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(BookmarksPageHandler_SetViewType_ParamsSpec.$,"BookmarksPageHandler_SetViewType_Params",[mojo.internal.StructField("viewType",0,0,ViewTypeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(BookmarksPageHandler_ShowContextMenu_ParamsSpec.$,"BookmarksPageHandler_ShowContextMenu_Params",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("point",8,0,gfx_mojom_PointSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("source",16,0,ActionSourceSpec.$,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(BookmarksPageHandler_ShowUI_ParamsSpec.$,"BookmarksPageHandler_ShowUI_Params",[],[[0,8]]);mojo.internal.Struct(BookmarksPageHandler_GetAllBookmarks_ParamsSpec.$,"BookmarksPageHandler_GetAllBookmarks_Params",[],[[0,8]]);mojo.internal.Struct(BookmarksPageHandler_GetAllBookmarks_ResponseParamsSpec.$,"BookmarksPageHandler_GetAllBookmarks_ResponseParams",[mojo.internal.StructField("nodes",0,0,mojo.internal.Array(BookmarksTreeNodeSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(BookmarksPage_OnBookmarkNodeAdded_ParamsSpec.$,"BookmarksPage_OnBookmarkNodeAdded_Params",[mojo.internal.StructField("node",0,0,BookmarksTreeNodeSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(BookmarksPage_OnBookmarkNodesRemoved_ParamsSpec.$,"BookmarksPage_OnBookmarkNodesRemoved_Params",[mojo.internal.StructField("nodeIds",0,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsSpec.$,"BookmarksPage_OnBookmarkParentFolderChildrenReordered_Params",[mojo.internal.StructField("folderId",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("childrenOrderedIds",8,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BookmarksPage_OnBookmarkNodeMoved_ParamsSpec.$,"BookmarksPage_OnBookmarkNodeMoved_Params",[mojo.internal.StructField("oldParentIndex",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("oldNodeIndex",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("newParentIndex",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("newNodeIndex",12,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(BookmarksPage_OnBookmarkNodeChanged_ParamsSpec.$,"BookmarksPage_OnBookmarkNodeChanged_Params",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("newTitle",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("newUrl",16,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,32]]);