// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{dedupingMixin}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";export const PrefsMixin=dedupingMixin((superClass=>{class PrefsMixin extends superClass{static get properties(){return{prefs:{type:Object,notify:true}}}getPref(prefPath){const pref=this.get(prefPath,this.prefs);assert(typeof pref!=="undefined","Pref is missing: "+prefPath);return pref}setPrefValue(prefPath,value){this.getPref(prefPath);this.set("prefs."+prefPath+".value",value)}appendPrefListItem(key,item){const pref=this.getPref(key);assert(pref&&pref.type===chrome.settingsPrivate.PrefType.LIST);if(pref.value.indexOf(item)===-1){this.push("prefs."+key+".value",item)}}updatePrefListItem(key,item,newItem){const pref=this.getPref(key);assert(pref&&pref.type===chrome.settingsPrivate.PrefType.LIST);const index=pref.value.indexOf(item);if(index!==-1){this.set(`prefs.${key}.value.${index}`,newItem)}}deletePrefListItem(key,item){assert(this.getPref(key).type===chrome.settingsPrivate.PrefType.LIST);const index=this.getPref(key).value.indexOf(item);if(index!==-1){this.splice(`prefs.${key}.value`,index,1)}}setPrefDictEntry(prefPath,key,value){const pref=this.getPref(prefPath);assert(pref&&pref.type===chrome.settingsPrivate.PrefType.DICTIONARY);pref.value[key]=value;this.set("prefs."+prefPath+".value",{...pref.value})}deletePrefDictEntry(prefPath,key){const pref=this.getPref(prefPath);assert(pref&&pref.type===chrome.settingsPrivate.PrefType.DICTIONARY);delete pref.value[key];this.set("prefs."+prefPath+".value",{...pref.value})}computePref(pref){return pref}}return PrefsMixin}));