/**
 * @fileoverview
 * 'settings-your-saved-info-page' is the entry point for users to see
 * and manage their saved info.
 */
import './account_card_element.js';
import './category_reference_card.js';
import './collapsible_autofill_settings_card.js';
import '/shared/settings/prefs/prefs.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
declare const SettingsYourSavedInfoPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SettingsYourSavedInfoPageElement extends SettingsYourSavedInfoPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        prefs: ObjectConstructor;
        passwordsCardData_: {
            type: ArrayConstructor;
            computed: string;
        };
        paymentsCardData_: {
            type: ArrayConstructor;
            computed: string;
        };
        addressesCardData_: {
            type: ArrayConstructor;
            computed: string;
        };
        identityCardData_: {
            type: ArrayConstructor;
            computed: string;
        };
        travelCardData_: {
            type: ArrayConstructor;
            computed: string;
        };
        enableIbans_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        enablePayOverTime_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        passwordsCount: NumberConstructor;
        passkeysCount: NumberConstructor;
        addressesCount: NumberConstructor;
        creditCardsCount: NumberConstructor;
        ibansCount: NumberConstructor;
        payOverTimeIssuersCount: NumberConstructor;
        passportsCount: NumberConstructor;
        driversLicensesCount: NumberConstructor;
        vehiclesCount: NumberConstructor;
        nationalIdCardsCount: NumberConstructor;
        travelInfoCount: NumberConstructor;
        flightReservationsCount: NumberConstructor;
        loyaltyCardsCount: NumberConstructor;
    };
    prefs: {
        [key: string]: any;
    };
    passwordsCount: number | undefined;
    passkeysCount: number | undefined;
    addressesCount: number | undefined;
    creditCardsCount: number | undefined;
    ibansCount: number | undefined;
    payOverTimeIssuersCount: number | undefined;
    passportsCount: number | undefined;
    driversLicensesCount: number | undefined;
    vehiclesCount: number | undefined;
    nationalIdCardsCount: number | undefined;
    travelInfoCount: number | undefined;
    flightReservationsCount: number | undefined;
    loyaltyCardsCount: number | undefined;
    private passwordsCardData_;
    private paymentsCardData_;
    private addressesCardData_;
    private identityCardData_;
    private travelCardData_;
    private enableIbans_;
    private enablePayOverTime_;
    private paymentsManager_;
    private autofillManager_;
    private autofillAiEntityManager_;
    private setPersonalDataListener_;
    private onAutofillAiEntitiesChangedListener_;
    connectedCallback(): void;
    private setupDataTypeCounters;
    private onAutofillAiEntitiesChanged;
    disconnectedCallback(): void;
    getFocusConfig(): Map<any, any>;
    getAssociatedControlFor(childViewId: string): HTMLElement;
    private computePasswordsCardData_;
    private computePaymentsCardData_;
    private computeAddressesCardData_;
    private computeIdentityCardData_;
    private computeTravelCardData_;
    /**
     * Shows the manage payment methods sub page.
     */
    private onPaymentManagerClick_;
    /**
     * Shows the manage addresses sub page.
     */
    private onAddressesManagerClick_;
    /**
     * Shows the manage identity sub page.
     */
    private onIdentityManagerClick_;
    /**
     * Shows the manage travel sub page.
     */
    private onTravelManagerClick_;
    /**
     * Shows Password Manager page.
     */
    private onPasswordManagerExternalLinkClick_;
    /**
     * Opens Wallet page in a new tab.
     */
    private onGoogleWalletExternalLinkClick_;
    /**
     * Opens Google Account page in a new tab.
     */
    private onGoogleAccountExternalLinkClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-your-saved-info-page': SettingsYourSavedInfoPageElement;
    }
}
export {};
