/**
 * @fileoverview
 * 'storage-access-embedding-site-list-entry' is an element representing a
 * single storage access permission. To be used within
 * 'storage-access-site-list-entry'.
 */
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import '../settings_shared.css.js';
import '../site_favicon.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface StorageAccessStaticSiteListEntry {
    faviconOrigin: string;
    displayName: string;
    description?: string;
    resetAriaLabel: string;
    origin: string;
    embeddingOrigin: string;
    incognito: boolean;
}
export interface StorageAccessStaticSiteListEntryElement {
    $: {
        displayName: HTMLElement;
        resetButton: HTMLElement;
    };
}
declare const StorageAccessStaticSiteListEntryElementBase: typeof PolymerElement & (new (...args: any[]) => import("./site_settings_mixin.js").SiteSettingsMixinInterface);
export declare class StorageAccessStaticSiteListEntryElement extends StorageAccessStaticSiteListEntryElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        model: ObjectConstructor;
    };
    model: StorageAccessStaticSiteListEntry;
    /**
     * Triggered when the reset button is clicked. Resets a single storage access
     * site permission.
     */
    private onResetButtonClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'storage-access-static-site-list-entry': StorageAccessStaticSiteListEntryElement;
    }
}
export {};
