/**
 * @fileoverview
 * 'settings-section' shows a paper material themed section with a header
 * which shows its page title.
 *
 * Example:
 *
 *    <settings-section page-title="[[pageTitle]]">
 *      <!-- Insert your section controls here -->
 *    </settings-section>
 */
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export declare class SettingsSectionElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Title for the section header. Initialize so we can use the
         * getTitleHiddenStatus_ method for accessibility.
         */
        pageTitle: {
            type: StringConstructor;
            value: string;
        };
        /**
         * When this attribute is enabled, a send feedback button will be shown
         * that emits a 'send-feedback' event.
         */
        showSendFeedbackButton: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    pageTitle: string;
    showSendFeedbackButton: boolean;
    /**
     * Get the value to which to set the aria-hidden attribute of the section
     * heading.
     * @return A return value of false will not add aria-hidden while aria-hidden
     *    requires a string of 'true' to be hidden as per aria specs. This
     *    function ensures we have the right return type.
     */
    private getTitleHiddenStatus_;
    focus(): void;
    private onSendFeedbackClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-section': SettingsSectionElement;
    }
}
