/**
 * @fileoverview 'settings-search-engines-page' is the settings page
 * containing search engines settings.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/js/cr.js';
import '../controls/controlled_radio_button.js';
import '../controls/settings_radio_group.js';
import '../simple_confirmation_dialog.js';
import './search_engine_edit_dialog.js';
import './search_engines_list.js';
import './omnibox_extension_entry.js';
import '../settings_page/settings_subpage.js';
import '../settings_shared.css.js';
import '../settings_vars.css.js';
import type { IronListElement } from 'chrome://resources/polymer/v3_0/iron-list/iron-list.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsRadioGroupElement } from '../controls/settings_radio_group.js';
import type { Route } from '../router.js';
import type { SearchEngine } from './search_engines_browser_proxy.js';
export interface SettingsSearchEnginesPageElement {
    $: {
        extensions: IronListElement;
        keyboardShortcutSettingGroup: SettingsRadioGroupElement;
    };
}
declare const SettingsSearchEnginesPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../global_scroll_target_mixin.js").GlobalScrollTargetMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsSearchEnginesPageElement extends SettingsSearchEnginesPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Preferences state.
         */
        prefs: {
            type: ObjectConstructor;
            notify: boolean;
        };
        defaultEngines: ArrayConstructor;
        activeEngines: ArrayConstructor;
        otherEngines: ArrayConstructor;
        extensions: ArrayConstructor;
        /**
         * Needed by GlobalScrollTargetMixin.
         */
        subpageRoute: {
            type: ObjectConstructor;
            value: Route;
        };
        showExtensionsList_: {
            type: BooleanConstructor;
            computed: string;
        };
        /** Filters out all search engines that do not match. */
        filter_: {
            type: StringConstructor;
            value: string;
        };
        matchingDefaultEngines_: {
            type: ArrayConstructor;
            computed: string;
        };
        matchingActiveEngines_: {
            type: ArrayConstructor;
            computed: string;
        };
        matchingOtherEngines_: {
            type: ArrayConstructor;
            computed: string;
        };
        matchingExtensions_: {
            type: ArrayConstructor;
            computed: string;
        };
        omniboxExtensionlastFocused_: ObjectConstructor;
        omniboxExtensionListBlurred_: BooleanConstructor;
        dialogModel_: {
            type: ObjectConstructor;
            value: null;
        };
        dialogAnchorElement_: {
            type: ObjectConstructor;
            value: null;
        };
        showEditDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showDeleteConfirmationDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    static get observers(): string[];
    prefs: {
        [key: string]: any;
    };
    defaultEngines: SearchEngine[];
    activeEngines: SearchEngine[];
    otherEngines: SearchEngine[];
    extensions: SearchEngine[];
    subpageRoute: Route;
    private showExtensionsList_;
    private filter_;
    private matchingDefaultEngines_;
    private matchingActiveEngines_;
    private matchingOtherEngines_;
    private matchingExtensions_;
    private omniboxExtensionlastFocused_;
    private omniboxExtensionListBlurred_;
    private dialogModel_;
    private dialogAnchorElement_;
    private showEditDialog_;
    private showDeleteConfirmationDialog_;
    private browserProxy_;
    ready(): void;
    private openEditDialog_;
    private openDeleteConfirmationDialog_;
    private getDeleteConfirmationBodyText_;
    private onCloseEditDialog_;
    private onCloseDeleteConfirmationDialog_;
    private onEditSearchEngine_;
    private onDeleteSearchEngine_;
    private extensionsChanged_;
    private enginesChanged_;
    private onAddSearchEngineClick_;
    private computeShowExtensionsList_;
    /**
     * Filters the given list based on the currently existing filter string.
     */
    private computeMatchingEngines_;
    /**
     * @param list The original list.
     * @param filteredList The filtered list.
     * @return Whether to show the "no results" message.
     */
    private showNoResultsMessage_;
    private onKeyboardShortcutSettingChange_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-search-engines-page': SettingsSearchEnginesPageElement;
    }
}
export {};
