import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{display:block}cr-tooltip{--paper-tooltip-min-width:max-content}</style>
<settings-safety-hub-module
    id="module"
    animated
    on-sh-module-item-button-click="onAllowAgainClick_"
    header="[[headerString_]]"
    subheader="[[subheaderString_]]"
    button-aria-label-id="safetyHubUnusedSitePermissionsAllowAgainAriaLabel"
    button-icon="settings20:undo"
    button-tooltip-text="$i18n{safetyHubUnusedSitePermissionsAllowAgainLabel}"
    sites="[[sites_]]">
  <div slot="button-container">
    <cr-button id="gotItButton" on-click="onGotItClick_"
        hidden$="[[shouldShowCompletionInfo_]]"
        aria-description$="[[subheaderString_]]">
      $i18n{safetyHubUnusedSitePermissionsGotItLabel}
    </cr-button>
    <cr-icon-button id="moreActionButton" class="icon-more-vert"
        on-click="onMoreActionClick_" hidden$="[[shouldShowCompletionInfo_]]"
        title="$i18n{moreActions}"
        aria-description$="[[headerString_]]">
    </cr-icon-button>
    <cr-icon-button id="bulkUndoButton" iron-icon="settings20:undo"
        on-click="onUndoClick_" hidden$="[[!shouldShowCompletionInfo_]]"
        on-focus="showUndoTooltip_" on-mouseenter="showUndoTooltip_"
        aria-label="$i18n{safetyHubUnusedSitePermissionsUndoLabel}"
        aria-description$="[[headerString_]]">
    </cr-icon-button>
  </div>
</settings-safety-hub-module>
<cr-toast id="undoToast" duration="5000">
  <div>[[toastText_]]</div>
  <cr-button id="toastUndoButton" on-click="onUndoClick_">
    $i18n{safetyHubUnusedSitePermissionsUndoLabel}
  </cr-button>
</cr-toast>
<cr-action-menu id="headerActionMenu" role-description="$i18n{menu}">
  <button class="dropdown-item" id="goToSettings"
      on-click="onGoToSettingsClick_">
    $i18n{safetyHubGoSiteSettingsItem}
  </button>
</cr-action-menu>
<cr-tooltip fit-to-visible-bounds manual-mode position="top" offset="3">
  $i18n{safetyHubUnusedSitePermissionsUndoLabel}
</cr-tooltip>
<!--_html_template_end_-->`;
}
