import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">#prefs{padding-inline-start:40px}#v2buttons{display:flex;width:100%}#learnMoreV2{margin-inline-end:auto}</style>
<cr-dialog id="dialog" close-text="$i18n{close}"
    ignore-popstate on-cancel="onCancel_">
  <div slot="title">
    <div hidden="[[!showResetProfileBannerV2]]">
      $i18n{resetAutomatedDialogV2Title}
    </div>
    <div hidden="[[showResetProfileBannerV2]]">
      $i18n{resetAutomatedDialogTitle}
    </div>
  </div>
  <div slot="body">
    <div hidden="[[!showResetProfileBannerV2]]">
      $i18n{resetAutomatedDialogV2Body}
      <div id="tamperedPrefsList" hidden="[[!showTamperedPrefsList]]">
        <ul id="prefs">
          <template is="dom-repeat" items="[[tamperedPrefs]]">
            <li>[[item]]</li>
          </template>
        </ul>
      </div>
    </div>
    <div hidden="[[showResetProfileBannerV2]]">
      <span id="description">
        $i18n{resetProfileBannerDescription}
        <a id="learnMore"
            aria-label="$i18n{resetLearnMoreAccessibilityText}"
            aria-description="$i18n{opensInNewTab}"
            href="$i18nRaw{resetProfileBannerLearnMoreUrl}"
            target="_blank">$i18n{learnMore}</a>
      </span>
    </div>
  </div>
  <div slot="button-container">
    <div id="v2buttons" hidden="[[!showResetProfileBannerV2]]">
      <cr-button id="learnMoreV2"
          aria-label="$i18n{resetLearnMoreAccessibilityText}"
          on-click="onLearnMoreClick_">
        $i18n{learnMore}
      </cr-button>
      <cr-button class="action-button" id="confirm"
          on-click="onConfirmClick_">
        $i18n{gotIt}
      </cr-button>
    </div>
    <div hidden="[[showResetProfileBannerV2]]">
      <cr-button class="cancel-button" on-click="onOkClick_" id="ok">
        $i18n{ok}
      </cr-button>
      <cr-button class="action-button" on-click="onResetClick_" id="reset">
        $i18n{resetProfileBannerButton}
      </cr-button>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
