import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="settings-shared cr-spinner-style">div[slot='body']{padding-inline-end:16px}#header{display:flex}#header .header-label{flex:auto}h3{font-size:inherit;font-weight:500;margin:0;padding-bottom:12px;padding-top:32px}cr-icon{padding-inline-end:12px}.list-item .name{word-break:break-word}.name{flex:3}#container{padding-inline-start:var(--cr-section-padding)}.spinner{padding-bottom:16px}@media (prefers-color-scheme:dark){#lightIcon{display:none}}@media (prefers-color-scheme:light){#darkIcon{display:none}}
    </style>

    <cr-dialog id="dialog" close-text="$i18n{cancel}" ignore-popstate
        on-close="onDialogClosed_">
      <div slot="title">[[dialogTitle_(dialogPage_)]]</div>

      <div slot="body">
        <cr-page-selector attr-for-selected="id" selected="[[dialogPage_]]"
            on-iron-select="onIronSelect_">
          <div id="initial">
            <p>$i18n{securityKeysTouchToContinue}</p>
            <div class="spinner"></div>
          </div>

          <div id="pinPrompt">
            <settings-security-keys-pin-field id="pin"
                min-pin-length="[[minPinLength_]]">
            </settings-security-keys-pin-field>
          </div>

          <div id="enrollments">
            <div id="header" class="list-item column-header">
              <h3 class="header-label">[[enrollmentsHeader_(enrollments_)]]</h3>
              <cr-button id="addButton" on-click="addButtonClick_"
                  class="secondary-button header-aligned-button">
                $i18n{add}
              </cr-button>
            </div>

            <div id="container">
              <iron-list id="enrollmentList" items="[[enrollments_]]"
                  class="cr-separators" role="list">
                <template>
                  <div class="list-item" first$="[[!index]]" role="listitem">
                    <cr-icon id="darkIcon"
                        icon="fingerprint-icon:fingerprint-scanned-dark">
                    </cr-icon>
                    <cr-icon id="lightIcon"
                        icon="fingerprint-icon:fingerprint-scanned-light">
                    </cr-icon>
                    <div class="name">
                      [[item.name]]
                    </div>
                    <cr-icon-button class="icon-clear"
                        aria-label="$i18n{securityKeysBioEnrollmentDelete}"
                        on-click="deleteEnrollment_"
                        disabled="[[deleteInProgress_]]">
                    </cr-icon-button>
                  </div>
                </template>
              </iron-list>
            </div>
          </div>

          <div id="enroll">
            <p>[[progressArcLabel_]]</p>
            <fingerprint-progress-arc id="arc" autoplay>
            </fingerprint-progress-arc>
          </div>

          <div id="chooseName">
            <p>$i18n{securityKeysBioEnrollmentChooseName}</p>
            <cr-input type="text" id="enrollmentName"
                max-length="[[enrollmentNameMaxUtf8Length_]]"
                value="{{recentEnrollmentName_}}"
                label="$i18n{securityKeysBioEnrollmentNameLabel}"
                on-input="onEnrollmentNameInput_"
                error-message="[[enrollmentNameError_]]"
                invalid="[[!isNullOrEmpty_(enrollmentNameError_)]]"
                spellcheck="false">
            </cr-input>
          </div>

          <div id="error">[[errorMsg_]]</div>
        </cr-page-selector>
      </div>

      <div slot="button-container">
        <cr-button id="cancelButton" class="cancel-button" on-click="cancel_"
            hidden="[[!cancelButtonVisible_]]"
            disabled="[[cancelButtonDisabled_]]">
          $i18n{cancel}
        </cr-button>
        <cr-button id="confirmButton" class="action-button"
            hidden="[[!confirmButtonVisible_]]"
            disabled="[[confirmButtonDisabled_]]"
            on-click="confirmButtonClick_">
          [[confirmButtonLabel_]]
        </cr-button>
        <cr-button id="doneButton" class="action-button"
            on-click="done_" hidden="[[!doneButtonVisible_]]">
          $i18n{done}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}
