// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '/shared/settings/prefs/prefs.js';
import '../../controls/controlled_radio_button.js';
import '../../controls/settings_radio_group.js';
import '../../settings_page/settings_subpage.js';
import './security_page_feature_row.js';
import { PrefsMixin } from '/shared/settings/prefs/prefs_mixin.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { SettingsViewMixin } from '../../settings_page/settings_view_mixin.js';
import { getTemplate } from './security_page_v2.html.js';
/** Enumeration of all security settings bundle modes.*/
// LINT.IfChange(SecuritySettingsBundleSetting)
export var SecuritySettingsBundleSetting;
(function (SecuritySettingsBundleSetting) {
    SecuritySettingsBundleSetting[SecuritySettingsBundleSetting["STANDARD"] = 0] = "STANDARD";
    SecuritySettingsBundleSetting[SecuritySettingsBundleSetting["ENHANCED"] = 1] = "ENHANCED";
})(SecuritySettingsBundleSetting || (SecuritySettingsBundleSetting = {}));
// LINT.ThenChange(/chrome/browser/safe_browsing/generated_security_settings_bundle_pref.h:SecuritySettingsBundleSetting)
/**
 * Enumeration of all Safe Browsing modes. Must be kept in sync with the enum
 * of the same name located in:
 * chrome/browser/safe_browsing/generated_safe_browsing_pref.h
 */
// LINT.IfChange(SafeBrowsingSetting)
export var SafeBrowsingSetting;
(function (SafeBrowsingSetting) {
    SafeBrowsingSetting[SafeBrowsingSetting["ENHANCED"] = 0] = "ENHANCED";
    SafeBrowsingSetting[SafeBrowsingSetting["STANDARD"] = 1] = "STANDARD";
    SafeBrowsingSetting[SafeBrowsingSetting["DISABLED"] = 2] = "DISABLED";
})(SafeBrowsingSetting || (SafeBrowsingSetting = {}));
const SettingsSecurityPageV2ElementBase = SettingsViewMixin(PrefsMixin(PolymerElement));
export class SettingsSecurityPageV2Element extends SettingsSecurityPageV2ElementBase {
    static get is() {
        return 'settings-security-page-v2';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            securitySettingsBundleSettingEnum_: {
                type: Object,
                value: SecuritySettingsBundleSetting,
            },
            safeBrowsingSettingEnum_: {
                type: Object,
                value: SafeBrowsingSetting,
            },
            safeBrowsingOff_: {
                type: Array,
                value: () => [SafeBrowsingSetting.DISABLED],
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsSecurityPageV2Element.is, SettingsSecurityPageV2Element);
