/**
 * @fileoverview
 * `security-page-feature-row` is a toggle with an expand button that
 * controls a supplied preference and also allows for expanding and
 * collapsing so a user can learn more about a setting.
 */
import 'chrome://resources/cr_elements/cr_collapse/cr_collapse.js';
import 'chrome://resources/cr_elements/cr_expand_button/cr_expand_button.js';
import '../../controls/settings_toggle_button.js';
import '../../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export declare class SecurityPageFeatureRowElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        expanded: {
            type: BooleanConstructor;
            notify: boolean;
            value: boolean;
        };
        label: StringConstructor;
        pref: ObjectConstructor;
        subLabel: StringConstructor;
        numericUncheckedValues: ArrayConstructor;
    };
    expanded: boolean;
    label: string;
    pref: chrome.settingsPrivate.PrefObject;
    subLabel: string;
    numericUncheckedValues: number[];
}
declare global {
    interface HTMLElementTagNameMap {
        'security-page-feature-row': SecurityPageFeatureRowElement;
    }
}
