/**
 * @fileoverview 'security-keys-subpage' is a settings subpage
 * containing operations on security keys.
 */
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import '../../settings_page/settings_subpage.js';
import '../../settings_shared.css.js';
import './security_keys_credential_management_dialog.js';
import './security_keys_bio_enroll_dialog.js';
import './security_keys_set_pin_dialog.js';
import './security_keys_reset_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SecurityKeysSubpageElement {
    $: {
        setPINButton: HTMLElement;
        resetButton: HTMLElement;
    };
}
declare const SecurityKeysSubpageElementBase: typeof PolymerElement & (new (...args: any[]) => import("../../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SecurityKeysSubpageElement extends SecurityKeysSubpageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        enableBioEnrollment_: {
            type: BooleanConstructor;
            readOnly: boolean;
            value(): boolean;
        };
        showSetPINDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showCredentialManagementDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showResetDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showBioEnrollDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    private enableBioEnrollment_;
    private showSetPINDialog_;
    private showCredentialManagementDialog_;
    private showResetDialog_;
    private showBioEnrollDialog_;
    private onSetPin_;
    private onSetPinDialogClosed_;
    private onCredentialManagement_;
    private onCredentialManagementDialogClosed_;
    private onReset_;
    private onResetDialogClosed_;
    private onBioEnroll_;
    private onBioEnrollDialogClosed_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'security-keys-subpage': SecurityKeysSubpageElement;
    }
}
export {};
