import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="privacy-guide-fragment-shared"></style>
<div class="settings-fragment-header" focus-element tabindex="-1">
  <picture>
    <source
        srcset="./images/privacy_guide/safe_browsing_graphic_dark_v2.svg"
        media="(prefers-color-scheme: dark)">
    <img alt="" src="./images/privacy_guide/safe_browsing_graphic_v2.svg">
  </picture>
  <h2 class="settings-fragment-header-label">
    $i18n{privacyGuideSafeBrowsingCardHeader}
  </h2>
</div>
<div class="fragment-content">
  <settings-radio-group id="safeBrowsingRadioGroup"
      pref="{{prefs.generated.safe_browsing}}"
      selectable-elements="settings-collapse-radio-button">
    <settings-collapse-radio-button id="safeBrowsingRadioEnhanced"
        pref="[[prefs.generated.safe_browsing]]"
        name="[[safeBrowsingSettingEnum_.ENHANCED]]"
        label="$i18n{safeBrowsingEnhanced}"
        sub-label="$i18n{safeBrowsingEnhancedDescUpdated}"
        expand-aria-label="$i18n{safeBrowsingEnhancedExpandA11yLabel}"
        on-click="onSafeBrowsingEnhancedClick_">
          <div slot="collapse" class="settings-columned-section">
            <div class="column">
              <h3 class="description-header">
                $i18n{columnHeadingWhenOn}
              </h3>
              <ul id="updatedDescItemContainer" class="icon-bulleted-list">
                <li>
                  <cr-icon icon="settings20:data" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedWhenOnBulOne}
                  </div>
                </li>
                <li>
                  <cr-icon icon="settings20:download" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedWhenOnBulTwo}
                  </div>
                </li>
                <li>
                  <cr-icon icon="settings20:gshield" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedWhenOnBulThree}
                  </div>
                </li>
                <li>
                  <cr-icon icon="settings:language" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedWhenOnBulFour}
                  </div>
                </li>
              </ul>
            </div>
            <div class="column">
              <h3 class="description-header">
                $i18n{columnHeadingConsider}
              </h3>
              <ul class="icon-bulleted-list">
                <li>
                  <cr-icon icon="settings20:link" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedThingsToConsiderBulOne}
                  </div>
                </li>
                <li>
                  <cr-icon icon="settings20:account-circle" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedThingsToConsiderBulTwo}
                  </div>
                </li>
                <li>
                  <cr-icon icon="settings:performance" aria-hidden="true">
                  </cr-icon>
                  <div class="secondary">
                    $i18n{safeBrowsingEnhancedThingsToConsiderBulThree}
                  </div>
                </li>
              </ul>
            </div>
          </div>
    </settings-collapse-radio-button>
    <settings-collapse-radio-button id="safeBrowsingRadioStandard"
        no-collapse
        pref="[[prefs.generated.safe_browsing]]"
        name="[[safeBrowsingSettingEnum_.STANDARD]]"
        label="$i18n{safeBrowsingStandard}"
        sub-label="[[getSafeBrowsingStandardSubLabel_(
                    enableHashPrefixRealTimeLookups_)]]"
        expand-aria-label="$i18n{safeBrowsingStandardExpandA11yLabel}"
        on-click="onSafeBrowsingStandardClick_">
    </settings-collapse-radio-button>
  </settings-radio-group>
</div>
<!--_html_template_end_-->`;
}
