import 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import '/shared/settings/prefs/prefs.js';
import '../settings_shared.css.js';
import './battery_page.js';
import './memory_page.js';
import './performance_page.js';
import './speed_page.js';
import type { CrViewManagerElement } from 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route } from '../router.js';
import type { SettingsPlugin } from '../settings_main/settings_plugin.js';
export interface SettingsPerformancePageIndexElement {
    $: {
        viewManager: CrViewManagerElement;
    };
}
declare const SettingsPerformancePageIndexElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface) & (new (...args: any[]) => import("../settings_page/searchable_view_container_mixin.js").SearchableViewContainerMixinInterface);
export declare class SettingsPerformancePageIndexElement extends SettingsPerformancePageIndexElementBase implements SettingsPlugin {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        prefs: ObjectConstructor;
        showBatterySettings_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    prefs: {
        [key: string]: any;
    };
    private showBatterySettings_;
    private showDefaultViews_;
    connectedCallback(): void;
    currentRouteChanged(newRoute: Route, oldRoute?: Route): void;
    private onDeviceHasBatteryChanged_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-performance-page-index': SettingsPerformancePageIndexElement;
    }
}
export {};
