import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">#sync-data-types .list-item:not([hidden])~.list-item:not([hidden]){border-top:var(--cr-separator-line)}.list-item{display:flex}.list-item>div:not(.separator){flex:1}cr-policy-indicator{margin-inline-end:var(--cr-controlled-by-spacing)}#toggles-header .cr-row.first h2{padding-top:18px}
    </style>



    <template is="dom-if" if="[[!isAccountSettingsPage_]]" restamp>
      <div id="sync-data-radio" class="cr-row first">
        <cr-radio-group
            selected="[[selectedSyncDataRadio_(syncPrefs)]]"
            on-selected-changed="onSyncDataRadioSelectionChanged_">
          <cr-radio-button name="sync-everything">
            $i18n{syncEverythingCheckboxLabel}
          </cr-radio-button>
          <cr-radio-button name="customize-sync">
            $i18n{customizeSyncLabel}
          </cr-radio-button>
        </cr-radio-group>
      </div>
    </template>


    <div hidden="[[!showSyncDisabledInformation]]">
      <div class="cr-row first">
        <cr-policy-indicator id="syncDisabledIndicator"
            indicator-type="userPolicy">
        </cr-policy-indicator>
        <div class="cr-secondary-text flex">
          $i18n{syncDisabledUserInformation}
        </div>
      </div>
    </div>


    <div class="cr-row first" hidden="[[isAccountSettingsPage_]]">
      <h2 class="cr-title-text flex">$i18n{syncData}</h2>
    </div>

    <div id="toggles-header" hidden="[[!isAccountSettingsPage_]]">
      <div class="cr-row first">
        <h2 class="cr-title-text flex">$i18n{accountDataTypesHeading}</h2>
      </div>
      <div class="cr-row continuation">
        <div class="cr-secondary-text flex">$i18n{accountDataTypesBody}</div>
      </div>
    </div>


    <div class="list-frame" id="sync-data-types">

      <template is="dom-if" if="[[isAccountSettingsPage_]]" restamp>
        <div class="list-item">
          <div id="historyTabsCheckboxLabel">
            $i18n{historyTabsCheckboxLabel}
          </div>
          <cr-policy-indicator id="mergedHistoryTabsToggleIndicator"
              indicator-type="userPolicy"
              hidden="[[!mergedHistoryTabsTogglePolicyIndicatorShown_(
                  syncStatus, syncPrefs.tabsManaged,
                  syncPrefs.typedUrlsManaged)]]">
          </cr-policy-indicator>
          <cr-toggle id="mergedHistoryTabsToggle"
              checked="[[mergedHistoryTabsToggleChecked_(syncPrefs)]]"
              on-change="onMergedHistoryTabsToggleChanged_"
              disabled="[[mergedHistoryTabsToggleDisabled_(syncStatus,
                  syncPrefs.tabsManaged, syncPrefs.typedUrlsManaged,
                  syncStatus.disabled)]]"
              aria-labelledby="historyTabsCheckboxLabel">
          </cr-toggle>
        </div>
      </template>


      <div hidden="[[isAccountSettingsPage_]]">
        <div class="list-item" hidden="[[!syncPrefs.typedUrlsRegistered]]">
          <div id="historyCheckboxLabel">
            $i18n{historyCheckboxLabel}
          </div>
          <cr-policy-indicator indicator-type="userPolicy"
              hidden="[[!showPolicyIndicator_(syncStatus,
                    syncPrefs.typedUrlsManaged)]]">
          </cr-policy-indicator>
          <cr-toggle id="historyToggle"
              checked="{{syncPrefs.typedUrlsSynced}}"
              on-change="onSingleSyncDataTypeChanged_"
              disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes, syncPrefs.typedUrlsManaged,
                syncStatus.disabled)]]"
              aria-labelledby="historyCheckboxLabel"
              data-type$="[[UserSelectableTypeEnum_.HISTORY]]">
          </cr-toggle>
        </div>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.bookmarksRegistered]]">
        <div id="bookmarksCheckboxLabel">
          $i18n{bookmarksCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.bookmarksManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.bookmarksSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes, syncPrefs.bookmarksManaged,
                syncStatus.disabled)]]"
            aria-labelledby="bookmarksCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.BOOKMARKS]]">
        </cr-toggle>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.readingListRegistered]]">
        <div id="readingListCheckboxLabel">
          $i18n{readingListCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.readingListManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.readingListSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes ,syncPrefs.readingListManaged,
                syncStatus.disabled)]]"
            aria-labelledby="readingListCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.READING_LIST]]">
        </cr-toggle>
      </div>

      <div hidden="[[isAccountSettingsPage_]]">
        <div class="list-item" hidden="[[!syncPrefs.tabsRegistered]]">
          <div id="openTabsCheckboxLabel">
            $i18n{openTabsCheckboxLabel}
          </div>
          <cr-policy-indicator indicator-type="userPolicy"
              hidden="[[!showPolicyIndicator_(syncStatus,
                    syncPrefs.tabsManaged)]]">
          </cr-policy-indicator>
          <cr-toggle checked="{{syncPrefs.tabsSynced}}"
              on-change="onSingleSyncDataTypeChanged_"
              disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes,syncPrefs.tabsManaged,
                syncStatus.disabled)]]"
              aria-labelledby="openTabsCheckboxLabel"
              data-type$="[[UserSelectableTypeEnum_.TABS]]">
          </cr-toggle>
        </div>

        <div class="list-item" hidden="[[!syncPrefs.savedTabGroupsRegistered]]">
          <div id="savedTabGroupsCheckboxLabel">
            $i18n{savedTabGroupsCheckboxLabel}
          </div>
          <cr-policy-indicator indicator-type="userPolicy"
              hidden="[[!showPolicyIndicator_(syncStatus,
                    syncPrefs.savedTabGroupsManaged, syncStatus.disabled)]]">
          </cr-policy-indicator>
          <cr-toggle checked="{{syncPrefs.savedTabGroupsSynced}}"
              on-change="onSingleSyncDataTypeChanged_"
              disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes, syncPrefs.savedTabGroupsManaged,
                syncStatus.disabled)]]"
              aria-labelledby="savedTabGroupsCheckboxLabel"
              data-type$="[[UserSelectableTypeEnum_.SAVED_TAB_GROUPS]]">
          </cr-toggle>
        </div>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.autofillRegistered]]">
        <div id="autofillCheckboxLabel">
          $i18n{autofillCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
             hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.autofillManaged)]]">
         </cr-policy-indicator>
        <cr-toggle id="autofillCheckbox"
            checked="{{syncPrefs.autofillSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
              syncPrefs.syncAllDataTypes,syncPrefs.autofillManaged,
              syncStatus.disabled)]]"
            aria-labelledby="autofillCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.AUTOFILL]]">
        </cr-toggle>
      </div>

      <div class="list-item"
           hidden="[[!syncPrefs.paymentsRegistered]]">
        <div>
          $i18n{paymentsCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.paymentsManaged)]]">
        </cr-policy-indicator>
        <cr-toggle id="paymentsCheckbox"
            checked="{{syncPrefs.paymentsSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes, syncPrefs.paymentsManaged,
                syncStatus.disabled)]]"
            aria-label="$i18n{paymentsCheckboxLabel}"
            data-type$="[[UserSelectableTypeEnum_.PAYMENTS]]">
        </cr-toggle>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.passwordsRegistered]]">
        <div id="passwordsCheckboxLabel">
          $i18n{passwordsCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.passwordsManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.passwordsSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
              syncPrefs.syncAllDataTypes, syncPrefs.passwordsManaged,
              syncStatus.disabled)]]"
            aria-labelledby="passwordsCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.PASSWORDS]]">
        </cr-toggle>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.preferencesRegistered]]">
        <div id="settingsCheckboxLabel">
          $i18n{settingsCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.preferencesManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.preferencesSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes, syncPrefs.preferencesManaged,
                syncStatus.disabled)]]"
            aria-labelledby="settingsCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.PREFERENCES]]">
        </cr-toggle>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.appsRegistered]]">
        <div id="appCheckboxLabel">$i18n{appCheckboxLabel}</div>
        <cr-policy-indicator indicator-type="userPolicy"
              hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.appsManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.appsSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes, syncPrefs.appsManaged,
                syncStatus.disabled)]]"
            aria-labelledby="appCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.APPS]]">
        </cr-toggle>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.extensionsRegistered]]">
        <div id="extensionsCheckboxLabel">
          $i18n{extensionsCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.extensionsManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.extensionsSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes , syncPrefs.extensionsManaged,
                syncStatus.disabled)]]"
            aria-labelledby="extensionsCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.EXTENSIONS]]">
        </cr-toggle>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.themesRegistered]]">
        <div id="themeCheckboxLabel">
          $i18n{themeCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.themesManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.themesSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes ,syncPrefs.themesManaged,
                syncStatus.disabled)]]"
            aria-labelledby="themeCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.THEMES]]">
        </cr-toggle>
      </div>

      <div class="list-item"
           hidden="[[!syncPrefs.productComparisonRegistered]]">
        <div id="productComparisonsCheckboxLabel">
          $i18n{productComparisonsCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.productComparisonManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.productComparisonSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
              syncPrefs.syncAllDataTypes, syncPrefs.productComparisonManaged,
              syncStatus.disabled)]]"
            aria-labelledby="productComparisonsCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.PRODUCT_COMPARISON]]">
        </cr-toggle>
      </div>


<!--_html_template_end_-->`;
}
