import '//resources/cr_components/localized_link/localized_link.js';
import '//resources/cr_elements/cr_radio_button/cr_radio_button.js';
import '//resources/cr_elements/cr_radio_group/cr_radio_group.js';
import '//resources/cr_elements/cr_toggle/cr_toggle.js';
import '//resources/cr_elements/cr_shared_style.css.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import '//resources/cr_elements/policy/cr_policy_indicator.js';
import '../settings_shared.css.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SyncPrefs, SyncStatus } from '/shared/settings/people_page/sync_browser_proxy.js';
import { UserSelectableType } from '/shared/settings/people_page/sync_browser_proxy.js';
import type { Route } from '../router.js';
/**
 * @fileoverview
 * 'settings-sync-controls' contains all sync data type controls.
 */
declare const SettingsSyncControlsElementBase: typeof PolymerElement & (new (...args: any[]) => import("//resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface);
export declare class SettingsSyncControlsElement extends SettingsSyncControlsElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        hidden: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
            reflectToAttribute: boolean;
        };
        /**
         * The current sync preferences, supplied by SyncBrowserProxy.
         */
        syncPrefs: ObjectConstructor;
        /**
         * The current sync status, supplied by the parent.
         */
        syncStatus: {
            type: ObjectConstructor;
            observer: string;
        };
        /** Expose UserSelectableType enum to HTML bindings. */
        UserSelectableTypeEnum_: {
            type: ObjectConstructor;
            value: typeof UserSelectableType;
        };
        /**
         * Communicates to the user that the toggles are disabled because sync is
         * disabled by their administrator.
         */
        showSyncDisabledInformation: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
            reflectToAttribute: boolean;
        };
        /**
         * Returns whether this element is currently displayed on the account
         * settings page. Always false on ChromeOS and with
         * `replaceSyncPromosWithSignInPromos` disabled.
         */
        isAccountSettingsPage_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    hidden: boolean;
    syncPrefs?: SyncPrefs;
    syncStatus: SyncStatus | null;
    private browserProxy_;
    private cachedSyncPrefs_;
    showSyncDisabledInformation: boolean;
    private isAccountSettingsPage_;
    constructor();
    connectedCallback(): void;
    /**
     * Handler for when the sync preferences are updated.
     */
    private handleSyncPrefsChanged_;
    /**
     * @return Computed binding returning the selected sync data radio button.
     */
    private selectedSyncDataRadio_;
    /**
     * Called when the sync data radio button selection changes.
     */
    private onSyncDataRadioSelectionChanged_;
    currentRouteChanged(newRoute: Route, oldRoute?: Route): void;
    private mergedHistoryTabsToggleDisabled_;
    private mergedHistoryTabsTogglePolicyIndicatorShown_;
    private mergedHistoryTabsToggleChecked_;
    private onMergedHistoryTabsToggleChanged_;
    private handleSyncAllDataTypesChanged_;
    /**
     * Handler for when any sync data type checkbox is changed.
     */
    private onSingleSyncDataTypeChanged_;
    private disableTypeCheckBox_;
    private showPolicyIndicator_;
    private computeShowSyncDisabledInformation_;
    private syncStatusChanged_;
    /**
     * @return Whether the sync controls are hidden.
     */
    private syncControlsHidden_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-sync-controls': SettingsSyncControlsElement;
    }
}
export {};
