/**
 * @fileoverview
 * 'settings-account-page' is the settings subpage containing controls to
 * manage features related to the user's primary account, such as sync
 * controls and advanced sync settings.
 */
import './sync_account_control.js';
import './sync_encryption_options.js';
import '../settings_page/settings_subpage.js';
import type { SyncPrefs } from '/shared/settings/people_page/sync_browser_proxy.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
declare const SettingsAccountPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsAccountPageElement extends SettingsAccountPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * The current sync status.
         */
        syncStatus_: {
            type: ObjectConstructor;
        };
        /**
         * The current sync preferences, supplied by SyncBrowserProxy.
         */
        syncPrefs: ObjectConstructor;
        isEeaChoiceCountry_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        personalizationCollapseExpanded_: {
            type: BooleanConstructor;
            value: boolean;
        };
        existingPassphraseLabel_: {
            type: StringConstructor;
            computed: string;
        };
        dataEncrypted_: {
            type: BooleanConstructor;
            computed: string;
        };
        encryptionExpanded_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    static get observers(): string[];
    private syncBrowserProxy_;
    private syncStatus_;
    syncPrefs?: SyncPrefs;
    private isEeaChoiceCountry_;
    private personalizationCollapseExpanded_;
    private dataEncrypted_;
    private encryptionExpanded_;
    private existingPassphraseLabel_;
    connectedCallback(): void;
    private onSyncStatusChanged_;
    /**
     * Handler for when the sync preferences are updated.
     */
    private onSyncPrefsChanged_;
    private onActivityControlsClick_;
    private onLinkedServicesClick_;
    private onSyncDashboardLinkClick_;
    private onResetSyncClick_;
    private onManageGoogleAccountClicked_;
    private computeExistingPassphraseLabel_;
    private computeDataEncrypted_;
    private expandEncryptionIfNeeded_;
    private shouldShowPageContents_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-account-page': SettingsAccountPageElement;
    }
}
export {};
