// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-on-startup-page' is a settings page.
 */
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../controls/controlled_radio_button.js';
import '/shared/settings/controls/extension_controlled_indicator.js';
import '../controls/settings_radio_group.js';
import '../i18n_setup.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import './startup_urls_page.js';
import { WebUiListenerMixin } from 'chrome://resources/cr_elements/web_ui_listener_mixin.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getSearchManager } from '../search_settings.js';
import { OnStartupBrowserProxyImpl } from './on_startup_browser_proxy.js';
import { getTemplate } from './on_startup_page.html.js';
/** Enum values for the 'session.restore_on_startup' preference. */
var PrefValues;
(function (PrefValues) {
    PrefValues[PrefValues["CONTINUE"] = 1] = "CONTINUE";
    PrefValues[PrefValues["OPEN_NEW_TAB"] = 5] = "OPEN_NEW_TAB";
    PrefValues[PrefValues["OPEN_SPECIFIC"] = 4] = "OPEN_SPECIFIC";
    PrefValues[PrefValues["CONTINUE_AND_OPEN_SPECIFIC"] = 6] = "CONTINUE_AND_OPEN_SPECIFIC";
})(PrefValues || (PrefValues = {}));
const SettingsOnStartupPageElementBase = WebUiListenerMixin(PolymerElement);
export class SettingsOnStartupPageElement extends SettingsOnStartupPageElementBase {
    static get is() {
        return 'settings-on-startup-page';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            prefs: {
                type: Object,
                notify: true,
            },
            ntpExtension_: Object,
            prefValuesEnum_: { readOnly: true, type: Object, value: PrefValues },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        const updateNtpExtension = (ntpExtension) => {
            // Note that |ntpExtension| is empty if there is no NTP extension.
            this.ntpExtension_ = ntpExtension;
        };
        OnStartupBrowserProxyImpl.getInstance().getNtpExtension().then(updateNtpExtension);
        this.addWebUiListener('update-ntp-extension', updateNtpExtension);
    }
    getName_(value) {
        return value.toString();
    }
    /**
     * Determine whether to show the user defined startup pages.
     * @param restoreOnStartup Enum value from PrefValues.
     * @return Whether the "open specific pages" or "continue and open specific
     *     pages" is selected.
     */
    showStartupUrls_(restoreOnStartup) {
        return restoreOnStartup === PrefValues.OPEN_SPECIFIC ||
            restoreOnStartup === PrefValues.CONTINUE_AND_OPEN_SPECIFIC;
    }
    /**
     * Determine whether to show "continue and open specific pages" option.
     * @param restoreOnStartup pref.
     * @return Whether the restoreOnStartup pref is recommended or enforced by
     *     policy.
     */
    showContinueAndOpenSpecific_(pref) {
        return pref.enforcement === chrome.settingsPrivate.Enforcement.ENFORCED ||
            pref.enforcement === chrome.settingsPrivate.Enforcement.RECOMMENDED;
    }
    // SettingsPlugin implementation
    async searchContents(query) {
        const searchRequest = await getSearchManager().search(query, this);
        return searchRequest.getSearchResult();
    }
}
customElements.define(SettingsOnStartupPageElement.is, SettingsOnStartupPageElement);
