/**
 * @fileoverview 'settings-languages-page' is the settings page
 * for language and input method settings.
 */
import 'chrome://resources/cr_components/managed_dialog/managed_dialog.js';
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_checkbox/cr_checkbox.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import 'chrome://resources/cr_elements/icons.html.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/js/action_link.js';
import 'chrome://resources/cr_elements/action_link.css.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import './add_languages_dialog.js';
import '../icons.html.js';
import '../relaunch_confirmation_dialog.js';
import '../settings_shared.css.js';
import '../settings_vars.css.js';
import type { CrActionMenuElement } from '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrLazyRenderElement } from 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route } from '../router.js';
import type { LanguagesModel } from './languages_types.js';
/**
 * Millisecond delay that can be used when closing an action menu to keep it
 * briefly on-screen.
 */
export declare const kMenuCloseDelay: number;
export interface SettingsLanguagesPageElement {
    $: {
        menu: CrLazyRenderElement<CrActionMenuElement>;
    };
}
declare const SettingsLanguagesPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../relaunch_mixin.js").RelaunchMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface);
export declare class SettingsLanguagesPageElement extends SettingsLanguagesPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Read-only reference to the languages model provided by the
         * 'settings-languages' instance.
         */
        languages: ObjectConstructor;
        /**
         * The language to display the details for.
         */
        detailLanguage_: ObjectConstructor;
        showAddLanguagesDialog_: BooleanConstructor;
        addLanguagesDialogLanguages_: ArrayConstructor;
        showManagedLanguageDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    languages?: LanguagesModel;
    private detailLanguage_?;
    private showAddLanguagesDialog_;
    private addLanguagesDialogLanguages_;
    private showManagedLanguageDialog_;
    private languageHelper_;
    private languageSettingsMetricsProxy_;
    connectedCallback(): void;
    /**
     * Stamps and opens the Add Languages dialog, registering a listener to
     * disable the dialog's dom-if again on close.
     */
    private onAddLanguagesClick_;
    private onLanguagesAdded_;
    private onAddLanguagesDialogClose_;
    /**
     * Formats language index (zero-indexed)
     */
    private formatIndex_;
    /**
     * Checks if there are supported languages that are not enabled but can be
     * enabled.
     * @return True if there is at least one available language.
     */
    private canEnableSomeSupportedLanguage_;
    /**
     * Used to determine which "Move" buttons to show for ordering enabled
     * languages.
     * @return True if |language| is at the |n|th index in the list of enabled
     *     languages.
     */
    private isNthLanguage_;
    /**
     * @return True if the "Move to top" option for |language| should be visible.
     */
    private showMoveUp_;
    /**
     * @return True if the "Move down" option for |language| should be visible.
     */
    private showMoveDown_;
    /**
     * @param languageCode The language code identifying a language.
     * @param translateTarget The target language.
     * @return 'target' if |languageCode| matches the target language,
     *     'non-target' otherwise.
     */
    private isTranslationTarget_;
    /**
     * Moves the language to the top of the list.
     */
    private onMoveToTopClick_;
    /**
     * Moves the language up in the list.
     */
    private onMoveUpClick_;
    /**
     * Moves the language down in the list.
     */
    private onMoveDownClick_;
    /**
     * Disables the language.
     */
    private onRemoveLanguageClick_;
    /**
     * Returns either the "selected" class, if the language matches the
     * prospective UI language, or an empty string. Languages can only be
     * selected on Chrome OS and Windows.
     * @param languageCode The language code identifying a language.
     * @param prospectiveUILanguage The prospective UI language.
     * @return The class name for the language item.
     */
    private getLanguageItemClass_;
    private onDotsClick_;
    /**
     * Closes the shared action menu after a short delay, so when a checkbox is
     * clicked it can be seen to change state before disappearing.
     */
    private closeMenuSoon_;
    /**
     * Triggered when the managed language dialog is dismissed.
     */
    private onManagedLanguageDialogClosed_;
    currentRouteChanged(currentRoute: Route): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-languages-page': SettingsLanguagesPageElement;
    }
}
export {};
