import 'chrome://resources/cr_elements/cr_icons.css.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import '../icons.html.js';
import '../settings_page/settings_section.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsGlicPageElement {
    $: {
        glicLinkRow: HTMLElement;
        learnMoreLabel: HTMLAnchorElement;
    };
}
declare const SettingsGlicPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsGlicPageElement extends SettingsGlicPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        spark_: {
            type: StringConstructor;
            value: () => "settings-internal:sparkv2" | "settings-internal:spark";
        };
    };
    private metricsBrowserProxy_;
    private spark_;
    private onGlicPageClick_;
    private onSettingsPageLearnMoreClick_;
    getFocusConfig(): Map<string, string>;
    getAssociatedControlFor(childViewId: string): HTMLElement;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-glic-page': SettingsGlicPageElement;
    }
}
export {};
