/**
 * @fileoverview 'passkey-edit-dialog' is the dialog that allows showing or
 * editing a passkey.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_icons.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import '../icons.html.js';
import '../settings_shared.css.js';
import '../settings_vars.css.js';
import './passwords_shared.css.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface PasskeyEditDialogElement {
    $: {
        dialog: CrDialogElement;
    };
}
declare const PasskeyEditDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export type SavedPasskeyEditedEvent = CustomEvent<string>;
declare global {
    interface HTMLElementEventMap {
        'saved-passkey-edited': SavedPasskeyEditedEvent;
    }
}
export declare class PasskeyEditDialogElement extends PasskeyEditDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        username: StringConstructor;
        relyingPartyId: StringConstructor;
        usernameInputErrorMessage_: StringConstructor;
        dialogFootnote_: StringConstructor;
        usernameInputInvalid_: {
            type: BooleanConstructor;
            computed: string;
        };
    };
    username: string;
    relyingPartyId: string;
    private usernameInputInvalid_;
    private usernameInputErrorMessage_;
    private dialogFootnote_;
    ready(): void;
    private onSaveButtonClick_;
    private computeUsernameInputInvalid_;
    private onCancel_;
    close(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'passkey-edit-dialog': PasskeyEditDialogElement;
    }
}
export {};
