/**
 * @fileoverview 'address-remove-confirmation-dialog' is the dialog that allows
 * removing a saved address.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsAddressRemoveConfirmationDialogElement {
    $: {
        description: HTMLElement;
        cancel: HTMLElement;
        dialog: CrDialogElement;
        remove: HTMLElement;
    };
}
declare const SettingsAddressRemoveConfirmationDialogBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class SettingsAddressRemoveConfirmationDialogElement extends SettingsAddressRemoveConfirmationDialogBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        address: ObjectConstructor;
        accountInfo: ObjectConstructor;
        /**
         * The title of the confirmation dialog.
         */
        confirmationTitle_: {
            type: StringConstructor;
            computed: string;
        };
        /**
         * The body of the confirmation dialog.
         */
        confirmationDescription_: {
            type: StringConstructor;
            computed: string;
        };
        /**
         * The label for the remove button.
         */
        removeButtonLabel_: {
            type: StringConstructor;
            computed: string;
        };
    };
    address: chrome.autofillPrivate.AddressEntry;
    accountInfo?: chrome.autofillPrivate.AccountInfo;
    private confirmationTitle_;
    private confirmationDescription_;
    private removeButtonLabel_;
    wasConfirmed(): boolean;
    private computeConfirmationTitle_;
    private computeConfirmationDescription_;
    private computeRemoveButtonLabel_;
    private isAccountHomeAddress_;
    private isAccountWorkAddress_;
    private isAccountNameEmailAddress_;
    private onRemoveClick;
    private onCancelClick;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-address-remove-confirmation-dialog': SettingsAddressRemoveConfirmationDialogElement;
    }
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-address-remove-confirmation-dialog': SettingsAddressRemoveConfirmationDialogElement;
    }
}
export {};
