/**
 * @fileoverview
 * `home-url-input` is a single-line text field intending to be used with
 * prefs.homepage
 */
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import '/shared/settings/controls/cr_policy_pref_indicator.js';
import type { CrPolicyPrefMixinInterface } from '/shared/settings/controls/cr_policy_pref_mixin.js';
import type { CrInputElement } from 'chrome://resources/cr_elements/cr_input/cr_input.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface HomeUrlInputElement {
    $: {
        input: CrInputElement;
    };
}
declare const HomeUrlInputElementBase: {
    new (): PolymerElement & CrPolicyPrefMixinInterface;
};
export declare class HomeUrlInputElement extends HomeUrlInputElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * The preference object to control.
         */
        pref: {
            observer: string;
        };
        disabled: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        canTab: BooleanConstructor;
        invalid: {
            type: BooleanConstructor;
            value: boolean;
        };
        value: {
            type: StringConstructor;
            value: string;
            notify: boolean;
        };
    };
    pref: chrome.settingsPrivate.PrefObject<string> | undefined;
    disabled: boolean;
    canTab: boolean;
    invalid: boolean;
    value: string;
    private browserProxy_;
    constructor();
    /**
     * Focuses the 'input' element.
     */
    focus(): void;
    /**
     * Polymer changed observer for |pref|.
     */
    private prefChanged_;
    private setInputValueFromPref_;
    /**
     * Gets a tab index for this control if it can be tabbed to.
     */
    private getTabindex_;
    /**
     * Change event handler for cr-input. Updates the pref value.
     * settings-input uses the change event because it is fired by the Enter key.
     */
    private onChange_;
    private resetValue_;
    /**
     * Keydown handler to specify enter-key and escape-key interactions.
     */
    private onKeydown_;
    /**
     * This function prevents unwanted change of selection of the containing
     * cr-radio-group, when the user traverses the input with arrow keys.
     */
    private stopKeyEventPropagation_;
    /** @return Whether the element should be disabled. */
    private isDisabled_;
    private validate_;
}
declare global {
    interface HTMLElementTagNameMap {
        'home-url-input': HomeUrlInputElement;
    }
}
export {};
