import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../controls/settings_slider.js';
import '../settings_page/settings_subpage.js';
import '../settings_shared.css.js';
import '../controls/settings_dropdown_menu.js';
import type { SliderTick } from 'chrome://resources/cr_elements/cr_slider/cr_slider.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
/**
 * 'settings-appearance-fonts-page' is the settings page containing appearance
 * settings.
 */
export interface SettingsAppearanceFontsPageElement {
    $: {
        fixedFontPreview: HTMLElement;
        minimumSizeFontPreview: HTMLElement;
        sansSerifFontPreview: HTMLElement;
        serifFontPreview: HTMLElement;
        standardFontPreview: HTMLElement;
    };
}
declare const SettingsAppearanceFontsPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsAppearanceFontsPageElement extends SettingsAppearanceFontsPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        fontOptions_: ObjectConstructor;
        /** Common font sizes. */
        fontSizeRange_: {
            readOnly: boolean;
            type: ArrayConstructor;
            value: SliderTick[];
        };
        /** Reasonable, minimum font sizes. */
        minimumFontSizeRange_: {
            readOnly: boolean;
            type: ArrayConstructor;
            value: SliderTick[];
        };
        /**
         * Preferences state.
         */
        prefs: {
            type: ObjectConstructor;
            notify: boolean;
        };
    };
    static get observers(): string[];
    prefs: Object;
    private fontOptions_;
    private fontSizeRange_;
    private minimumFontSizeRange_;
    private browserProxy_;
    ready(): void;
    private setFontsData_;
    /**
     * Get the minimum font size, accounting for unset prefs.
     */
    private computeMinimumFontSize_;
    private onMinimumSizeChange_;
    private fontFamilyValueForFixed_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-appearance-fonts-page': SettingsAppearanceFontsPageElement;
    }
}
export {};
