/**
 * @fileoverview
 * 'settings-ax-annotations-section' is a section holding the toggle for main
 * node accessibility annotations. It appears on the accessibility page
 * (chrome://settings/accessibility) on Windows, macOS, and Linux.
 */
import '../controls/settings_toggle_button.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
declare const SettingsAxAnnotationsSectionBaseElement: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface);
export declare class SettingsAxAnnotationsSectionElement extends SettingsAxAnnotationsSectionBaseElement {
    static get is(): "settings-ax-annotations-section";
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * `screenAIProgress_` stores the downloading progress in percentage of
         * the ScreenAI library, which ranges from 0.0 to 100.0.
         */
        screenAIProgress_: NumberConstructor;
        /**
         * `screenAIStatus_` stores the ScreenAI library install state.
         */
        screenAIStatus_: NumberConstructor;
    };
    private browserProxy_;
    private screenAIProgress_;
    private screenAIStatus_;
    connectedCallback(): void;
    private getMainNodeAnnotationsToggleSublabel_;
}
declare global {
    interface HTMLElementTagNameMap {
        [SettingsAxAnnotationsSectionElement.is]: SettingsAxAnnotationsSectionElement;
    }
}
export {};
