import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="privacy-guide-fragment-shared"></style>
<div class="settings-fragment-header" focus-element tabindex="-1">
  <picture>
    <source
        srcset="./images/privacy_guide/ad_topics_graphic_dark.svg"
        media="(prefers-color-scheme: dark)">
    <img alt="" src="./images/privacy_guide/ad_topics_graphic.svg">
  </picture>
  <h2 class="settings-fragment-header-label">
    $i18n{privacyGuideAdTopicsHeading}
  </h2>
</div>
<div class="fragment-content">
  <div class="embedded-setting-wrapper">
    <settings-toggle-button id="adTopicsToggle"
        pref="{{prefs.privacy_sandbox.m1.topics_enabled}}"
        on-settings-boolean-control-change="onToggleChange_"
        label="$i18n{privacyGuideAdTopicsToggleLabel}">
    </settings-toggle-button>
  </div>
  <div class="settings-columned-section">
    <div class="column">
      <h3 class="description-header">$i18n{columnHeadingWhenOn}</h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:history" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{privacyGuideAdTopicsWhenOnBullet1}</div>
        </li>
        <li>
          <cr-icon icon="settings20:security" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{privacyGuideAdTopicsWhenOnBullet2}</div>
        </li>
        <li>
          <cr-icon icon="settings20:auto-delete" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{privacyGuideAdTopicsWhenOnBullet3}</div>
        </li>
      </ul>
    </div>
    <div class="column">
      <h3 class="description-header">$i18n{columnHeadingConsider}</h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:rule-folder" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideAdTopicsThingsToConsiderBullet1}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:web" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideAdTopicsThingsToConsiderBullet2}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:gavel" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18nRaw{privacyGuideAdTopicsThingsToConsiderBullet3Desktop}
          </div>
        </li>
      </ul>
    </div>
  </div>
</div>
<!--_html_template_end_-->`;
}