import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><settings-section

    page-title="$i18n{generalPageTitle}">
  <settings-toggle-button id="performanceInterventionToggleButton"
    on-change="onPerformanceInterventionToggleButtonChange_"
    pref="{{prefs.performance_tuning.intervention_notification.enabled}}"
    label="$i18n{performanceInterventionEnabledLabel}"
    sub-label-with-link="$i18n{performanceInterventionEnabledDescription}"
    on-sub-label-link-clicked="onPerformanceInterventionLearnMoreLinkClick_">
  </settings-toggle-button>
  <settings-toggle-button id="discardRingTreatmentToggleButton"
    on-change="onDiscardRingChange_"
    pref="{{prefs.performance_tuning.discard_ring_treatment.enabled}}"
    label="$i18n{discardRingTreatmentEnabledLabel}"
    sub-label-with-link="
          $i18n{discardRingTreatmentEnabledDescriptionWithLearnLink}"
    on-sub-label-link-clicked="onDiscardRingTreatmentLearnMoreLinkClick_">
  </settings-toggle-button>
  <cr-link-row
      label="$i18n{tabHoverPreviewCardLinkTitle}"
      sub-label="$i18n{tabHoverPreviewCardLinkSubtitle}"
      on-click="onTabHoverPreviewCardLinkClick_" external>
  </cr-link-row>
  <tab-discard-exception-list id="exceptionList" prefs="{{prefs}}">
  </tab-discard-exception-list>
</settings-section>
<!--_html_template_end_-->`;
}