import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">#minimumSize{align-items:flex-end;display:flex;flex-direction:column}#minimumSizeFontPreview{text-align:end}div[id$='FontPreview']{line-height:initial}
  </style>
  <settings-subpage page-title="$i18n{customizeFonts}"
      route-path$="[[routePath]]">
    <div class="cr-row first">
      <div class="flex cr-padded-text" aria-hidden="true">
        $i18n{fontSize}
      </div>
      <settings-slider id="sizeSlider"
          pref="{{prefs.webkit.webprefs.default_font_size}}"
          ticks="[[fontSizeRange_]]" label-aria="$i18n{fontSize}"
          label-min="$i18n{tiny}" label-max="$i18n{huge}">
      </settings-slider>
    </div>
    <div class="cr-row">
      <div class="flex cr-padded-text" aria-hidden="true">
        $i18n{minimumFont}
      </div>
      <div id="minimumSize">
        <settings-slider  pref="{{prefs.webkit.webprefs.minimum_font_size}}"
            ticks="[[minimumFontSizeRange_]]" label-aria="$i18n{minimumFont}"
            label-min="$i18n{tiny}" label-max="$i18n{huge}">
        </settings-slider>
        <div id="minimumSizeFontPreview"
            style="
                font-size:[[computeMinimumFontSize_(
                    prefs.webkit.webprefs.minimum_font_size.value)]]px;
                font-family:
                    '[[prefs.webkit.webprefs.fonts.standard.Zyyy.value]]';"
            hidden>
          [[computeMinimumFontSize_(
                  prefs.webkit.webprefs.minimum_font_size.value)]]:
          $i18n{quickBrownFox}
        </div>
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{standardFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{standardFont}"
            pref="{{prefs.webkit.webprefs.fonts.standard.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <div id="standardFontPreview" class="list-item cr-padded-text"
          style="
              font-size:[[prefs.webkit.webprefs.default_font_size.value]]px;
              font-family:
                  '[[prefs.webkit.webprefs.fonts.standard.Zyyy.value]]';">
        [[prefs.webkit.webprefs.default_font_size.value]]:
        $i18n{quickBrownFox}
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{serifFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{serifFont}"
            pref="{{prefs.webkit.webprefs.fonts.serif.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <div id="serifFontPreview" class="list-item cr-padded-text"
          style="
              font-size:[[prefs.webkit.webprefs.default_font_size.value]]px;
              font-family:
                  '[[prefs.webkit.webprefs.fonts.serif.Zyyy.value]]';">
        [[prefs.webkit.webprefs.default_font_size.value]]:
        $i18n{quickBrownFox}
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{sansSerifFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{sansSerifFont}"
            pref="{{prefs.webkit.webprefs.fonts.sansserif.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <div id="sansSerifFontPreview" class="list-item cr-padded-text"
          style="
              font-size:[[prefs.webkit.webprefs.default_font_size.value]]px;
              font-family:
                  '[[prefs.webkit.webprefs.fonts.sansserif.Zyyy.value]]';">
        [[prefs.webkit.webprefs.default_font_size.value]]:
        $i18n{quickBrownFox}
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{fixedWidthFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{fixedWidthFont}"
            pref="{{prefs.webkit.webprefs.fonts.fixed.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <div id="fixedFontPreview" class="list-item cr-padded-text"
          style="
              font-size:
                  [[prefs.webkit.webprefs.default_fixed_font_size.value]]px;
              font-family: '[[fontFamilyValueForFixed_(
                  prefs.webkit.webprefs.fonts.fixed.Zyyy.value)]]';">
        [[prefs.webkit.webprefs.default_fixed_font_size.value]]:
        $i18n{quickBrownFox}
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{mathFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{mathFont}"
            pref="{{prefs.webkit.webprefs.fonts.math.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <!-- A text preview like quickBrownFox is not really helpful for
           mathematical fonts. Not only it's desired to show special math
           characters but also to demo advanced features involving the
           OpenType MATH table such as big/stretchy operators or special
           layout constants. This is what the formula below tries to do. -->
      <div id="mathFontPreview" class="list-item cr-padded-text"
          style="
              font-size:[[prefs.webkit.webprefs.default_font_size.value]]px;
              font-family:
                  '[[prefs.webkit.webprefs.fonts.math.Zyyy.value]]';">
        [[prefs.webkit.webprefs.default_font_size.value]]:
        <math style="font: inherit;" displaystyle="true">
          <mrow>
            <msqrt>
              <mrow>
                <munderover>
                  <mo>∑</mo>
                  <mrow>
                    <mi>n</mi>
                    <mo>=</mo>
                    <mn>1</mn>
                  </mrow>
                  <mn>∞</mn>
                </munderover>
                <mfrac>
                  <mn>10</mn>
                  <msup>
                    <mi>n</mi>
                    <mn>4</mn>
                  </msup>
                </mfrac>
              </mrow>
            </msqrt>
            <mo>=</mo>
            <mrow>
              <msubsup>
                <mo>∫</mo>
                <mn>0</mn>
                <mn>∞</mn>
              </msubsup>
              <mfrac>
                <mrow>
                  <mn>2</mn>
                  <mi>x</mi>
                  <mrow>
                    <mi>d</mi>
                    <mi>x</mi>
                  </mrow>
                </mrow>
                <mrow>
                  <msup>
                    <mi>e</mi>
                    <mi>x</mi>
                  </msup>
                  <mo>−</mo>
                  <mn>1</mn>
                </mrow>
              </mfrac>
            </mrow>
            <mo>=</mo>
            <mfrac>
              <msup>
                <mi>π</mi>
                <mn>2</mn>
              </msup>
              <mn>3</mn>
            </mfrac>
            <mo>∊</mo>
            <mi>ℝ</mi>
          </mrow>
        </math>
      </div>
    </div>
  </settings-subpage>
<!--_html_template_end_-->`;
}