import { p as PrefControlMixin, a5 as ModelExecutionEnterprisePolicyValue, S as SettingsViewMixin, P as PrefsMixin, a4 as AiEnterpriseFeaturePrefName, M as MetricsBrowserProxyImpl, aX as AiPageTabOrganizationInteractions, j as AiPageActions, F as FeatureOptInState, aW as AiPageHistorySearchInteractions, O as OpenWindowProxyImpl, e as I18nMixin, L as ListPropertyUpdateMixin, aV as AiPageComposeInteractions, c as getCss$a, bl as EventTracker, d as assert, bm as CrRippleMixin, o as CrPolicyPrefMixin, a3 as EntityDataManagerProxyImpl, bn as CountryDetailManagerProxyImpl, s as sanitizeInnerHtml, a7 as AutofillManagerImpl, y as focusWithoutInk, ab as getInstance, a as assertNotReached, bo as AnchorAlignment, a6 as PaymentsManagerImpl, aY as CardBenefitsUserAction, a$ as PrivacyElementInteractions, aZ as CvcDeletionUserAction, E as SignedInState, J as StatusAction, W as WebUiListenerMixin, B as SyncBrowserProxyImpl, bp as SettingsBooleanControlMixin, n as RouteObserverMixin, bq as TimePeriod, br as ClearBrowsingDataBrowserProxyImpl, ac as FocusOutlineManager, r as routes, h as Router, bs as assertNotReachedCase, u as PasswordManagerImpl, v as PasswordManagerPage, bt as BrowsingDataType, k as CrSettingsPrefs, aK as SettingsToggleButtonElement, aH as getTrustedHTML, aG as PluralStringProxyImpl, bb as PrivacySandboxBrowserProxyImpl, bu as CardState, R as RelaunchMixin, bv as SafetyHubBrowserProxyImpl, b8 as SafetyHubSurfaces, bw as SafetyHubEvent, f as RestartType, b7 as SafetyHubModuleType, a2 as SearchEnginesBrowserProxyImpl, ah as ChoiceMadeLocation, w as FocusRowMixin, am as ExtensionControlBrowserProxyImpl, bx as GlobalScrollTargetMixin, bf as SearchEnginesInteractions, by as SiteSettingsBrowserProxyImpl, bz as SiteSettingSource, bA as CookiesExceptionType, bB as ContentSettingsTypes, bC as ContentSetting, bD as SITE_EXCEPTION_WILDCARD, K as BaseMixin, bE as ChooserType, T as TooltipMixin, bF as INVALID_CATEGORY_SUBTYPE, bG as DefaultSettingSource, bH as isSettingEnabled, bI as AllSitesAction2, bJ as SortMethod, a_ as DeleteBrowsingDataAction, bK as AllSitesDialog, bL as SettingsState, b6 as SafetyHubEntryPoint, bM as JavascriptOptimizerSetting, bN as getLocalizationStringForContentType, Z as CookieControlsMode, bO as SafeBrowsingSetting$1, _ as PromiseResolver, aR as convertLanguageCodeForTranslate, aQ as convertLanguageCodeForChrome, aS as getBaseLanguage, aT as isTranslateBaseLanguage, x as ScrollableMixin, ae as FindShortcutMixin, bP as getFullName, D as ProfileInfoBrowserProxyImpl, H as HelpBubbleMixin, ao as ChromeSigninUserChoice, aw as PrivacyPageBrowserProxyImpl, q as pageVisibility, b as getCss$b, I as I18nMixinLit, bQ as hasKeyModifiers, g as getCss$c, G as getImage, as as UserSelectableType, aq as syncPrefsIndividualDataTypes, ap as PageStatus, m as SearchableViewContainerMixin, z as getSearchManager, bR as isWindows, a1 as ResetBrowserProxyImpl, aU as AiPageCompareInteractions, bS as ThirdPartyCookieBlockingSetting, b1 as PrivacyGuideStepsEligibleAndReached, b0 as PrivacyGuideSettingsStates, b3 as SafetyCheckNotificationsModuleInteractions, bT as isUndoKeyboardEvent, bU as PermissionsRevocationType, b4 as SafetyCheckUnusedSitePermissionsModuleInteractions } from './shared.rollup.js';
export { aA as CrButtonElement, bW as CrCheckboxElement, bX as CrCollapseElement, aB as CrDialogElement, bY as CrExpandButtonElement, bZ as CrIconButtonElement, b_ as CrInputElement, b$ as CrLazyRenderElement, bV as CrShortcutInputElement, c0 as CrTextareaElement, c1 as CrToastElement, c2 as CrTooltipElement, ci as HttpsFirstModeSetting, Q as NetworkPredictionOptions, c7 as PrivacyGuideCompletionFragmentElement, c8 as PrivacyGuideCookiesFragmentElement, ca as PrivacyGuideHistorySyncFragmentElement, cb as PrivacyGuideMsbbFragmentElement, cd as PrivacyGuideSafeBrowsingFragmentElement, c6 as PrivacyGuideStep, ce as PrivacyGuideWelcomeFragmentElement, ch as SecureDnsInputElement, cf as SecureDnsResolverType, i as SettingsAiPageFeaturePrefName, c3 as SettingsAutofillAiAddOrEditDialogElement, aL as SettingsAutofillAiEntriesListElement, c4 as SettingsCollapseRadioButtonElement, c9 as SettingsPrivacyGuideDialogElement, cc as SettingsPrivacyGuidePageElement, c5 as SettingsRadioGroupElement, ck as SettingsSafetyHubEntryPointElement, cl as SettingsSafetyHubModuleElement, cg as SettingsSecureDnsElement, cj as SettingsSecurityPageElement, cm as SettingsSimpleConfirmationDialogElement } from './shared.rollup.js';
import { html, PolymerElement, microTask, flush, afterNextRender, dedupingMixin } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import 'chrome://settings/strings.m.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { css, html as html$1, CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { sendWithPromise } from 'chrome://resources/js/cr.js';
import { mojo } from 'chrome://resources/mojo/mojo/public/js/bindings.js';
import { SkColorSpec } from 'chrome://resources/mojo/skia/public/mojom/skcolor.mojom-webui.js';

function getTemplate$2m() {
    return html `<!--_html_template_start_--><style include="settings-shared">.cr-row{--cr-section-min-height:0;padding-top:2px;padding-bottom:16px}cr-policy-pref-indicator{margin-inline-end:var(--cr-icon-button-margin-start)}</style>

<template is="dom-if" if="[[isFeatureDisabledByPolicy_(pref)]]" restamp>
  <div class="cr-row first" id="aiPolicyIndicator">
    <cr-policy-pref-indicator pref="[[pref]]"></cr-policy-pref-indicator>
    $i18n{aiSubpageFeatureManagedDisabledLabel}
  </div>
</template><!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-ai-policy-indicator' is an indicator that informs the user if the
 * feature is controlled by policy.
 */
function isFeatureDisabledByPolicy(enterprisePref) {
    return !!enterprisePref &&
        enterprisePref.value === ModelExecutionEnterprisePolicyValue.DISABLE;
}
const SettingsAiPolicyIndicatorBase = PrefControlMixin(PolymerElement);
class SettingsAiPolicyIndicator extends SettingsAiPolicyIndicatorBase {
    static get is() {
        return 'settings-ai-policy-indicator';
    }
    static get template() {
        return getTemplate$2m();
    }
    isFeatureDisabledByPolicy_() {
        return isFeatureDisabledByPolicy(this.pref);
    }
}
customElements.define(SettingsAiPolicyIndicator.is, SettingsAiPolicyIndicator);

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getAiLearnMoreUrl(enterprisePref, learnMoreUrl, learnMoreEnterpriseUrl) {
    return enterprisePref.value ===
        ModelExecutionEnterprisePolicyValue.ALLOW_WITHOUT_LOGGING ?
        learnMoreEnterpriseUrl :
        learnMoreUrl;
}

function getTemplate$2l() {
    return html `<!--_html_template_start_--><style include="settings-shared settings-columned-section">cr-icon{flex-shrink:0}</style>

<settings-subpage page-title="$i18n{tabOrganizationSettingLabel}"
    route-path$="[[routePath]]">
<settings-ai-policy-indicator pref="[[enterprisePref_]]">
</settings-ai-policy-indicator>
<div class="cr-row first">
  <div class="flex cr-padded-text">
    <div id="tabOrganizationLabel">$i18n{tabOrganizationSettingLabel}</div>
    <div class="secondary">
      $i18n{tabOrganizationSettingSublabelV2}$i18n{sentenceEnd}
      <a href="[[getLearnMoreUrl_(enterprisePref_)]]"
          aria-label="$i18n{tabOrganizationSettingLearnMoreA11y}"
          aria-description="$i18n{opensInNewTab}"
          on-click="onLearnMoreClick_" target="_blank">
        $i18n{learnMore}
      </a>
    </div>
  </div>
</div>
<div class="settings-columned-section">
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingWhenUsed}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:auto-tab-group" aria-hidden="true"></cr-icon>
        <div class="secondary">
          $i18n{tabOrganizationSettingWhenOnAutoGroups}
        </div>
      </li>
      <li>
        <cr-icon icon="settings20:tab" aria-hidden="true"></cr-icon>
        <div class="secondary">
          $i18n{tabOrganizationSettingWhenOnImproveFocus}
        </div>
      </li>
    </ul>
  </div>
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:psychiatry" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiSubpageSublabelAi}</div>
      </li>
      <li>
        <cr-icon icon="settings20:googleg" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{tabOrganizationSettingConsiderData}</div>
      </li>
      <settings-ai-logging-info-bullet pref="[[enterprisePref_]]">
      </settings-ai-logging-info-bullet>
    </ul>
  </div>
</div>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsAiTabOrganizationSubpageElementBase = SettingsViewMixin(PrefsMixin(PolymerElement));
class SettingsAiTabOrganizationSubpageElement extends SettingsAiTabOrganizationSubpageElementBase {
    static get is() {
        return 'settings-ai-tab-organization-subpage';
    }
    static get template() {
        return getTemplate$2l();
    }
    static get properties() {
        return {
            enterprisePref_: {
                type: Object,
                computed: `computePref(prefs.${AiEnterpriseFeaturePrefName.TAB_ORGANIZATION})`,
            },
        };
    }
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    recordInteractionMetrics_(interaction, action) {
        this.metricsBrowserProxy_.recordAiPageTabOrganizationInteractions(interaction);
        this.metricsBrowserProxy_.recordAction(action);
    }
    onLearnMoreClick_() {
        this.recordInteractionMetrics_(AiPageTabOrganizationInteractions.LEARN_MORE_LINK_CLICKED, AiPageActions.TAB_ORGANIZATION_LEARN_MORE_CLICKED);
    }
    getLearnMoreUrl_() {
        return getAiLearnMoreUrl(this.enterprisePref_, loadTimeData.getString('tabOrganizationLearnMoreUrl'), loadTimeData.getString('tabOrganizationLearnMoreManagedUrl'));
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsAiTabOrganizationSubpageElement.is, SettingsAiTabOrganizationSubpageElement);

function getTemplate$2k() {
    return html `<!--_html_template_start_--><style include="settings-shared settings-columned-section">.separator{margin:0 4px}.separator+settings-toggle-button{margin-inline-end:12px}cr-icon{flex-shrink:0}cr-policy-pref-indicator{margin-inline-end:4px}</style>

<settings-subpage page-title="$i18n{historySearchSettingLabel}"
    route-path$="[[routePath]]">
<div class="settings-row first">
  <template is="dom-if" if="[[!isDisabledByPolicy_(enterprisePref_)]]"
      restamp>
    <cr-link-row label="$i18n{historySearchSettingLabel}"
        on-click="onHistorySearchLinkoutClick_" external>
      <div slot="sub-label">
        <span id="linkoutText">[[toggleSubLabelV2_]]</span>
        <a href="[[getLearnMoreUrl_(enterprisePref_)]]"
            aria-label="$i18n{historySearchLearnMoreA11yLabel}"
            aria-description="$i18n{opensInNewTab}"
            on-click="onLearnMoreClick_" target="_blank">
          $i18n{learnMore}
        </a>
      </div>
    </cr-link-row>
    <div class="separator"></div>
  </template>
  <template is="dom-if" if="[[isDisabledByPolicy_(enterprisePref_)]]" restamp>
    <div class="cr-row first">
      <div class="flex cr-padded-text">
        <div id="historySearchLabel">$i18n{historySearchSettingLabel}</div>
        <div class="secondary">
          [[toggleSubLabelV2_]]
          <a href="[[getLearnMoreUrl_(enterprisePref_)]]"
              aria-label="$i18n{historySearchLearnMoreA11yLabel}"
              aria-description="$i18n{opensInNewTab}"
              on-click="onLearnMoreClick_" target="_blank">
            $i18n{learnMore}
          </a>
        </div>
      </div>
    </div>
    <cr-policy-pref-indicator id="policyIndicator"
          pref="[[enterprisePref_]]">
    </cr-policy-pref-indicator>
  </template>
  <settings-toggle-button aria-label="$i18n{historySearchSettingLabel}"
      learn-more-url="[[getLearnMoreUrl_(enterprisePref_)]]"
      learn-more-aria-label="$i18n{historySearchLearnMoreA11yLabel}"
      pref="{{prefs.optimization_guide.history_search_setting_state}}"
      numeric-unchecked-values="[[numericUncheckedValues_]]"
      numeric-checked-value="[[featureOptInStateEnum_.ENABLED]]"
      on-settings-boolean-control-change="onHistorySearchToggleChange_"
      disabled="[[isDisabledByPolicy_(enterprisePref_)]]">
  </settings-toggle-button>
</div>
<div class="settings-columned-section">
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingWhenOn}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:search-spark" aria-hidden="true"></cr-icon>
        <div id="whenOnPageContentText" class="secondary"
            hidden="[[isAnswersFeatureEnabled_]]">
          $i18n{historySearchWhenOnPageContent}
        </div>
        <div id="whenOnPageContentTextWithAnswers" class="secondary"
            hidden="[[!isAnswersFeatureEnabled_]]">
          $i18n{historySearchWithAnswersWhenOnPageContent}
        </div>
      </li>
      <li id="whenOnRecallInfoWithAnswers"
          hidden="[[!isAnswersFeatureEnabled_]]">
        <cr-icon icon="settings20:auto-summarize" aria-hidden="true">
        </cr-icon>
        <div class="secondary">
          $i18n{historySearchWithAnswersWhenOnRecallInfo}
        </div>
      </li>
      <li>
        <cr-icon icon="settings20:quick-reference-all" aria-hidden="true">
        </cr-icon>
        <div class="secondary">$i18n{historySearchWhenOnSearchFrom}</div>
      </li>
      <li id="whenOnLogStartItem">
        <cr-icon icon="settings20:history" aria-hidden="true">
        </cr-icon>
        <div class="secondary">
          $i18n{historySearchWhenOnLogStart}
        </div>
      </li>
    </ul>
  </div>
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:psychiatry" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiSubpageSublabelAi}</div>
      </li>
      <li>
        <cr-icon icon="settings20:googleg" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{historySearchConsiderData}</div>
      </li>
      <settings-ai-logging-info-bullet pref="[[enterprisePref_]]">
      </settings-ai-logging-info-bullet>
      <li>
        <cr-icon icon="settings20:file-save" aria-hidden="true"></cr-icon>
        <div id="considerDataEncryptedText" class="secondary"
            hidden="[[isAnswersFeatureEnabled_]]">
          $i18n{historySearchConsiderDataEncrypted}
        </div>
        <div id="considerDataEncryptedTextWithAnswers" class="secondary"
            hidden="[[!isAnswersFeatureEnabled_]]">
          $i18n{historySearchWithAnswersConsiderDataEncrypted}
        </div>
      </li>
      <li id="considerOutDatedItem" hidden="[[!isAnswersFeatureEnabled_]]">
        <cr-icon icon="settings20:difference" aria-hidden="true"></cr-icon>
        <div class="secondary">
          $i18n{historySearchWithAnswersConsiderOutdated}
        </div>
      </li>
    </ul>
  </div>
</div>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsHistorySearchPageElementBase = SettingsViewMixin(PrefsMixin(PolymerElement));
class SettingsHistorySearchPageElement extends SettingsHistorySearchPageElementBase {
    static get is() {
        return 'settings-history-search-page';
    }
    static get template() {
        return getTemplate$2k();
    }
    static get properties() {
        return {
            featureOptInStateEnum_: {
                type: Object,
                value: FeatureOptInState,
            },
            isAnswersFeatureEnabled_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('historyEmbeddingsAnswersFeatureEnabled'),
            },
            numericUncheckedValues_: {
                type: Array,
                value: () => [FeatureOptInState.DISABLED, FeatureOptInState.NOT_INITIALIZED],
            },
            // TODO(crbug.com/362225975): Remove V2 suffixes.
            toggleSubLabelV2_: {
                type: String,
                value: () => {
                    return (loadTimeData.getBoolean('historyEmbeddingsAnswersFeatureEnabled') ?
                        loadTimeData.getString('historySearchWithAnswersSettingSublabelV2') :
                        loadTimeData.getString('historySearchSettingSublabelV2')) +
                        loadTimeData.getString('sentenceEnd') +
                        ' '; // Whitespace is needed to separate the sub-label from the
                    // following Learn More.
                },
            },
            enterprisePref_: {
                type: Object,
                computed: `computePref(prefs.${AiEnterpriseFeaturePrefName.HISTORY_SEARCH})`,
            },
        };
    }
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    recordInteractionMetrics_(interaction, action) {
        this.metricsBrowserProxy_.recordAiPageHistorySearchInteractions(interaction);
        this.metricsBrowserProxy_.recordAction(action);
    }
    onHistorySearchLinkoutClick_() {
        this.recordInteractionMetrics_(AiPageHistorySearchInteractions.FEATURE_LINK_CLICKED, AiPageActions.HISTORY_SEARCH_FEATURE_LINK_CLICKED);
        OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString('historySearchDataHomeUrl'));
    }
    onLearnMoreClick_(event) {
        // Stop the propagation of events, so that clicking on the 'Learn More' link
        // won't trigger the external linkout action on the parent cr-link-row
        // element.
        event.stopPropagation();
        this.recordInteractionMetrics_(AiPageHistorySearchInteractions.LEARN_MORE_LINK_CLICKED, AiPageActions.HISTORY_SEARCH_LEARN_MORE_CLICKED);
    }
    onHistorySearchToggleChange_(e) {
        const toggle = e.target;
        if (toggle.checked) {
            this.recordInteractionMetrics_(AiPageHistorySearchInteractions.HISTORY_SEARCH_ENABLED, AiPageActions.HISTORY_SEARCH_ENABLED);
            return;
        }
        this.recordInteractionMetrics_(AiPageHistorySearchInteractions.HISTORY_SEARCH_DISABLED, AiPageActions.HISTORY_SEARCH_DISABLED);
    }
    getLearnMoreUrl_() {
        return getAiLearnMoreUrl(this.enterprisePref_, loadTimeData.getString('historySearchLearnMoreUrl'), loadTimeData.getString('historySearchLearnMoreManagedUrl'));
    }
    isDisabledByPolicy_() {
        return isFeatureDisabledByPolicy(this.enterprisePref_);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsHistorySearchPageElement.is, SettingsHistorySearchPageElement);

function getTemplate$2j() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared settings-columned-section">.cr-row{border-top:none}.list-frame{padding-inline-start:var(--cr-section-indent-width)}#disabledSitesList{display:flex;flex-direction:column}#disabledSitesList>div:not(:first-child){border-top:var(--cr-separator-line)}cr-icon{flex-shrink:0}settings-toggle-button.hr{padding-top:16px}</style>

<settings-subpage page-title="$i18n{aiComposeLabel}"
    route-path$="[[routePath]]">
<settings-ai-policy-indicator pref="[[enterprisePref_]]">
</settings-ai-policy-indicator>
<div class="cr-row first">
  <div class="flex cr-padded-text">
    <div id="helpMeWriteLabel">$i18n{aiComposeLabel}</div>
    <div class="secondary">
      $i18n{aiComposeSublabelV2}$i18n{sentenceEnd}
      <a href="[[getLearnMoreUrl_(enterprisePref_)]]"
          aria-label="$i18n{aiComposeSettingLearnMoreA11y}"
          aria-description="$i18n{opensInNewTab}"
          on-click="onLearnMoreClick_" target="_blank">
        $i18n{learnMore}
      </a>
    </div>
  </div>
</div>
<div class="settings-columned-section">
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingWhenUsed}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:pen-spark" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiComposeWhenOnWritingHelp}</div>
      </li>
      <li>
        <cr-icon icon="settings20:summarize" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiComposeWhenOnWritingExamples}</div>
      </li>
      <li>
        <cr-icon icon="settings20:text-analysis" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiComposeWhenOnWritingReferences}</div>
      </li>
    </ul>
  </div>
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:psychiatry" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiSubpageSublabelAi}</div>
      </li>
      <li>
        <cr-icon icon="settings20:googleg" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiComposeComposeConsiderData}</div>
      </li>
      <settings-ai-logging-info-bullet pref="[[enterprisePref_]]">
      </settings-ai-logging-info-bullet>
    </ul>
  </div>
</div>

<template is="dom-if" if="[[enableComposeProactiveNudge_]]" restamp>
  <settings-toggle-button class="hr"
      pref="{{prefs.compose.proactive_nudge_enabled}}"
      label="$i18n{offerWritingHelpToggleLabel}"
      sub-label="$i18n{offerWritingHelpToggleSublabel}"
      on-settings-boolean-control-change="onComposeProactiveNudgeToggleChange_">
  </settings-toggle-button>
  <div class="cr-row">
    <div id="disabledSitesHeading" class="flex">
      $i18n{offerWritingHelpDisabledSitesLabelV2}
    </div>
  </div>
  <div id="noDisabledSitesLabel" class="list-frame"
      hidden$="[[hasSites_(siteList_.*)]]">
    <div class="list-item secondary">
      $i18n{offerWritingHelpNoDisabledSites}
    </div>
  </div>
  <div id="disabledSitesList" class="list-frame" role="list">
    <template is="dom-repeat" items="[[siteList_]]">
      <div class="list-item" role="listitem">
        <div class="start cr-padded-text">[[item]]</div>
        <cr-icon-button
            class="icon-delete-gray"
            aria-label="[[i18n('offerWritingHelpRemoveDisabledSiteAriaLabel',
                          item)]]"
            on-click="onDeleteClick_"
            title="$i18n{delete}">
        </cr-icon-button>
      </div>
    </template>
  </div>
</template>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const COMPOSE_PROACTIVE_NUDGE_PREF = 'compose.proactive_nudge_enabled';
const COMPOSE_PROACTIVE_NUDGE_DISABLED_SITES_PREF = 'compose.proactive_nudge_disabled_sites_with_time';
const SettingsOfferWritingHelpPageElementBase = SettingsViewMixin(I18nMixin(ListPropertyUpdateMixin(PrefsMixin(PolymerElement))));
class SettingsOfferWritingHelpPageElement extends SettingsOfferWritingHelpPageElementBase {
    static get is() {
        return 'settings-offer-writing-help-page';
    }
    static get template() {
        return getTemplate$2j();
    }
    static get properties() {
        return {
            siteList_: {
                type: Array,
                value: () => [],
            },
            enableComposeProactiveNudge_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('enableComposeProactiveNudge'),
            },
            enterprisePref_: {
                type: Object,
                computed: `computePref(prefs.${AiEnterpriseFeaturePrefName.COMPOSE})`,
            },
        };
    }
    static get observers() {
        return [`onPrefsChanged_(
        prefs.${COMPOSE_PROACTIVE_NUDGE_DISABLED_SITES_PREF}.value.*)`];
    }
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    recordInteractionMetrics_(interaction, action) {
        this.metricsBrowserProxy_.recordAiPageComposeInteractions(interaction);
        this.metricsBrowserProxy_.recordAction(action);
    }
    onLearnMoreClick_() {
        this.recordInteractionMetrics_(AiPageComposeInteractions.LEARN_MORE_LINK_CLICKED, AiPageActions.COMPOSE_LEARN_MORE_CLICKED);
    }
    onComposeProactiveNudgeToggleChange_(e) {
        const toggle = e.target;
        if (toggle.checked) {
            this.recordInteractionMetrics_(AiPageComposeInteractions.COMPOSE_PROACTIVE_NUDGE_ENABLED, AiPageActions.COMPOSE_PROACTIVE_NUDGE_ENABLED);
            return;
        }
        this.recordInteractionMetrics_(AiPageComposeInteractions.COMPOSE_PROACTIVE_NUDGE_DISABLED, AiPageActions.COMPOSE_PROACTIVE_NUDGE_DISABLED);
    }
    hasSites_() {
        return this.siteList_.length > 0;
    }
    onDeleteClick_(e) {
        this.deletePrefDictEntry(COMPOSE_PROACTIVE_NUDGE_DISABLED_SITES_PREF, e.model.item);
    }
    onPrefsChanged_() {
        const prefDict = this.getPref(COMPOSE_PROACTIVE_NUDGE_DISABLED_SITES_PREF)
            .value;
        const newSites = Object.keys(prefDict);
        this.updateList('siteList_', (entry) => entry, newSites);
    }
    getLearnMoreUrl_() {
        return getAiLearnMoreUrl(this.enterprisePref_, loadTimeData.getString('composeLearnMorePageURL'), loadTimeData.getString('composeLearnMorePageManagedURL'));
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsOfferWritingHelpPageElement.is, SettingsOfferWritingHelpPageElement);

let instance$m = null;
function getCss$9() {
    return instance$m || (instance$m = [...[getCss$a()], css `:host{--cr-slider-active-color:var(--google-blue-600);--cr-slider-container-color:rgba(var(--google-blue-600-rgb),.24);--cr-slider-container-disabled-color:rgba(var(--google-grey-600-rgb),.24);--cr-slider-disabled-color:var(--google-grey-600);--cr-slider-knob-color-rgb:var(--google-blue-600-rgb);--cr-slider-knob-disabled-color:white;--cr-slider-marker-active-color:rgba(255,255,255,.54);--cr-slider-marker-color:rgba(26,115,232,.54);--cr-slider-marker-disabled-color:rgba(128,134,139,.54);--cr-slider-position-transition:80ms ease;--cr-slider-ripple-color:rgba(var(--cr-slider-knob-color-rgb),.25);-webkit-tap-highlight-color:rgba(0,0,0,0);cursor:default;height:32px;isolation:isolate;outline:none;padding:0 16px;user-select:none}@media (prefers-color-scheme:dark){:host{--cr-slider-active-color:var(--google-blue-300);--cr-slider-container-color:rgba(var(--google-blue-500-rgb),.48);--cr-slider-container-disabled-color:rgba(var(--google-grey-600-rgb),.48);--cr-slider-knob-color-rgb:var(--google-blue-300-rgb);--cr-slider-knob-disabled-color:var(--google-grey-900-white-4-percent);--cr-slider-marker-active-color:var(--google-blue-300);--cr-slider-marker-color:var(--google-blue-300);--cr-slider-marker-disabled-color:rgba(255,255,255,.54);--cr-slider-ripple-color:rgba(var(--cr-slider-knob-color-rgb),.4)}}:host,:host>#container{touch-action:none}#container,#bar{border-top-style:solid;border-top-width:2px}#container{border-top-color:var(--cr-slider-container-color);position:relative;top:16px}#container>div{position:absolute}#markers,#bar{top:-2px}#markers{display:flex;flex-direction:row;left:0;pointer-events:none;right:0}.active-marker,.inactive-marker{flex:1}#markers::before,#markers::after,.active-marker::after,.inactive-marker::after{border-radius:50%;content:'';display:block;height:2px;margin-inline-start:-1px;width:2px}#markers::before,.active-marker::after{background-color:var(--cr-slider-marker-active-color)}#markers::after,.inactive-marker::after{background-color:var(--cr-slider-marker-color)}#bar{border-top-color:var(--cr-slider-active-color)}:host([transiting_]) #bar{transition:width var(--cr-slider-position-transition)}#knobAndLabel{top:-1px}:host([transiting_]) #knobAndLabel{transition:margin-inline-start var(--cr-slider-position-transition)}#knob{background-color:rgb(var(--cr-slider-knob-color-rgb));border-radius:50%;box-shadow:0 1px 3px 0 rgba(0,0,0,.4);height:10px;outline:none;position:relative;transform:translate(-50%,-50%);width:10px}:host-context([dir=rtl]) #knob{transform:translate(50%,-50%)}#label{background:rgb(var(--cr-slider-knob-color-rgb));border-radius:.75em;bottom:22px;color:white;font-size:12px;line-height:1.5em;opacity:0;outline:1px transparent solid;padding:0 .67em;position:absolute;transform:translateX(-50%);transition:opacity 80ms ease-in-out;white-space:nowrap}:host-context([dir=rtl]) #label{transform:translateX(50%)}:host(:hover) #label,:host([show-label_]) #label{opacity:1}#ink{--paper-ripple-opacity:var(--cr-slider-ripple-opacity,1);color:var(--cr-slider-ripple-color);height:var(--cr-slider-ripple-size,32px);pointer-events:none;transition:color linear 80ms;transform:translate(-50%,-50%);top:50%;left:50%;width:var(--cr-slider-ripple-size,32px);z-index:var(--cr-slider-ripple-z-index,auto)}:host-context([dir=rtl]) #ink{left:auto;right:50%;transform:translate(50%,-50%)}:host([disabled_]){pointer-events:none}:host([disabled_]) #container{border-top-color:var(--cr-slider-container-disabled-color)}:host([disabled_]) #bar{border-top-color:var(--cr-slider-disabled-color)}:host([disabled_]) .inactive-marker::after,:host([disabled_]) #markers::after{background-color:var(--cr-slider-marker-disabled-color)}:host([disabled_]) #knob{background-color:var(--cr-slider-disabled-color);border:2px solid var(--cr-slider-knob-disabled-color);box-shadow:unset}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$9() {
    return html$1 `
<div id="container" part="container">
  <div id="bar"></div>
  <div id="markers" ?hidden="${!this.markerCount}">
    ${this.getMarkers_().map((_item, index) => html$1 `
      <div class="${this.getMarkerClass_(index)}"></div>
    `)}
  </div>
  <div id="knobAndLabel" @transitionend="${this.onTransitionEnd_}">
    <div id="knob" part="knob"></div>
    <div id="label" part="label">${this.label_}</div>
  </div>
</div>`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-slider' is a slider component used to select a number from
 * a continuous or discrete range of numbers.
 */
function clamp(min, max, value) {
    return Math.min(max, Math.max(min, value));
}
function getAriaValue(tick) {
    if (Number.isFinite(tick)) {
        return tick;
    }
    const sliderTick = tick;
    return sliderTick.ariaValue !== undefined ? sliderTick.ariaValue :
        sliderTick.value;
}
const CrSliderElementBase = CrRippleMixin(CrLitElement);
class CrSliderElement extends CrSliderElementBase {
    static get is() {
        return 'cr-slider';
    }
    static get styles() {
        return getCss$9();
    }
    render() {
        return getHtml$9.bind(this)();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
            },
            /**
             * Internal representation of disabled depending on |disabled| and
             * |ticks|.
             */
            disabled_: {
                type: Boolean,
                reflect: true,
            },
            dragging: {
                type: Boolean,
                notify: true,
            },
            updatingFromKey: {
                type: Boolean,
                notify: true,
            },
            /**
             * The amount the slider value increments by when pressing any of the keys
             * from `deltaKeyMap_`. Defaults to 1.
             */
            keyPressSliderIncrement: {
                type: Number,
            },
            markerCount: {
                type: Number,
            },
            max: {
                type: Number,
            },
            min: {
                type: Number,
            },
            /**
             * When set to false, the keybindings are not handled by this component,
             * for example when the owner of the component wants to set up its own
             * keybindings.
             */
            noKeybindings: {
                type: Boolean,
            },
            snaps: {
                type: Boolean,
            },
            /**
             * The data associated with each tick on the slider. Each element in the
             * array contains a value and the label corresponding to that value.
             */
            ticks: {
                type: Array,
            },
            value: {
                type: Number,
            },
            label_: {
                type: String,
                state: true,
            },
            showLabel_: {
                type: Boolean,
                reflect: true,
            },
            /**
             * |transiting_| is set to true when bar is touched or clicked. This
             * triggers a single position transition effect to take place for the
             * knob, bar and label. When the transition is complete, |transiting_| is
             * set to false resulting in no transition effect during dragging, manual
             * value updates and keyboard events.
             */
            transiting_: {
                type: Boolean,
                reflect: true,
            },
        };
    }
    #disabled_accessor_storage = false;
    get disabled() { return this.#disabled_accessor_storage; }
    set disabled(value) { this.#disabled_accessor_storage = value; }
    #dragging_accessor_storage = false;
    get dragging() { return this.#dragging_accessor_storage; }
    set dragging(value) { this.#dragging_accessor_storage = value; }
    #updatingFromKey_accessor_storage = false;
    get updatingFromKey() { return this.#updatingFromKey_accessor_storage; }
    set updatingFromKey(value) { this.#updatingFromKey_accessor_storage = value; }
    #keyPressSliderIncrement_accessor_storage = 1;
    get keyPressSliderIncrement() { return this.#keyPressSliderIncrement_accessor_storage; }
    set keyPressSliderIncrement(value) { this.#keyPressSliderIncrement_accessor_storage = value; }
    #markerCount_accessor_storage = 0;
    get markerCount() { return this.#markerCount_accessor_storage; }
    set markerCount(value) { this.#markerCount_accessor_storage = value; }
    #max_accessor_storage = 100;
    get max() { return this.#max_accessor_storage; }
    set max(value) { this.#max_accessor_storage = value; }
    #min_accessor_storage = 0;
    get min() { return this.#min_accessor_storage; }
    set min(value) { this.#min_accessor_storage = value; }
    #noKeybindings_accessor_storage = false;
    get noKeybindings() { return this.#noKeybindings_accessor_storage; }
    set noKeybindings(value) { this.#noKeybindings_accessor_storage = value; }
    #snaps_accessor_storage = false;
    get snaps() { return this.#snaps_accessor_storage; }
    set snaps(value) { this.#snaps_accessor_storage = value; }
    #ticks_accessor_storage = [];
    get ticks() { return this.#ticks_accessor_storage; }
    set ticks(value) { this.#ticks_accessor_storage = value; }
    #value_accessor_storage = 0;
    get value() { return this.#value_accessor_storage; }
    set value(value) { this.#value_accessor_storage = value; }
    #disabled__accessor_storage = false;
    get disabled_() { return this.#disabled__accessor_storage; }
    set disabled_(value) { this.#disabled__accessor_storage = value; }
    #label__accessor_storage = '';
    get label_() { return this.#label__accessor_storage; }
    set label_(value) { this.#label__accessor_storage = value; }
    #showLabel__accessor_storage = false;
    get showLabel_() { return this.#showLabel__accessor_storage; }
    set showLabel_(value) { this.#showLabel__accessor_storage = value; }
    #transiting__accessor_storage = false;
    get transiting_() { return this.#transiting__accessor_storage; }
    set transiting_(value) { this.#transiting__accessor_storage = value; }
    deltaKeyMap_ = null;
    draggingEventTracker_ = null;
    firstUpdated() {
        this.setAttribute('role', 'slider');
        this.addEventListener('blur', this.hideRipple_);
        this.addEventListener('focus', this.showRipple_);
        this.addEventListener('keydown', this.onKeyDown_);
        this.addEventListener('keyup', this.onKeyUp_);
        this.addEventListener('pointerdown', this.onPointerDown_.bind(this));
    }
    connectedCallback() {
        super.connectedCallback();
        this.draggingEventTracker_ = new EventTracker();
    }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('keyPressSliderIncrement')) {
            this.onKeyPressSliderIncrementChanged_();
        }
        if (changedProperties.has('value') || changedProperties.has('min') ||
            changedProperties.has('max')) {
            if (this.value !== undefined) {
                this.updateValue_(this.value);
            }
        }
        if (changedProperties.has('disabled') || changedProperties.has('ticks')) {
            this.disabled_ = this.disabled || this.ticks.length === 1;
        }
        if (changedProperties.has('ticks')) {
            if (this.ticks.length > 1) {
                this.snaps = true;
                this.max = this.ticks.length - 1;
                this.min = 0;
            }
        }
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        if (changedProperties.has('disabled_')) {
            this.setAttribute('tabindex', this.disabled_ ? '-1' : '0');
            this.blur();
        }
        if (changedProperties.has('ticks')) {
            if (this.value !== undefined) {
                this.updateValue_(this.value);
            }
        }
        if (changedProperties.has('value') || changedProperties.has('min') ||
            changedProperties.has('max') || changedProperties.has('ticks')) {
            this.updateUi_();
        }
    }
    /**
     * When markers are displayed on the slider, they are evenly spaced across
     * the entire slider bar container and are rendered on top of the bar and
     * bar container. The location of the marks correspond to the discrete
     * values that the slider can have.
     */
    getMarkers_() {
        const array = Array.from({ length: Math.max(0, this.markerCount - 1) });
        // Fill with dummy data so that Array#map() actually works in the template.
        array.fill(0);
        return array;
    }
    getMarkerClass_(index) {
        const currentStep = (this.markerCount - 1) * this.getRatio();
        return index < currentStep ? 'active-marker' : 'inactive-marker';
    }
    /**
     * The ratio is a value from 0 to 1.0 corresponding to a location along the
     * slider bar where 0 is the minimum value and 1.0 is the maximum value.
     * This is a helper function used to calculate the bar width, knob location
     * and label location.
     */
    getRatio() {
        return (this.value - this.min) / (this.max - this.min);
    }
    /**
     * Removes all event listeners related to dragging, and cancels ripple.
     */
    stopDragging_(pointerId) {
        this.draggingEventTracker_.removeAll();
        this.releasePointerCapture(pointerId);
        this.dragging = false;
        this.hideRipple_();
    }
    hideRipple_() {
        if (this.noink) {
            return;
        }
        this.getRipple().clear();
        this.showLabel_ = false;
    }
    showRipple_() {
        if (this.noink) {
            return;
        }
        if (!this.getRipple().holdDown) {
            this.getRipple().showAndHoldDown();
        }
        this.showLabel_ = true;
    }
    onKeyDown_(event) {
        if (this.disabled_ || this.noKeybindings) {
            return;
        }
        if (event.metaKey || event.shiftKey || event.altKey || event.ctrlKey) {
            return;
        }
        let newValue;
        if (event.key === 'Home') {
            newValue = this.min;
        }
        else if (event.key === 'End') {
            newValue = this.max;
        }
        else if (this.deltaKeyMap_.has(event.key)) {
            newValue = this.value + this.deltaKeyMap_.get(event.key);
        }
        if (newValue === undefined) {
            return;
        }
        this.updatingFromKey = true;
        if (this.updateValue_(newValue)) {
            this.fire('cr-slider-value-changed');
        }
        event.preventDefault();
        event.stopPropagation();
        this.showRipple_();
    }
    onKeyUp_(event) {
        if (event.key === 'Home' || event.key === 'End' ||
            this.deltaKeyMap_.has(event.key)) {
            setTimeout(() => {
                this.updatingFromKey = false;
            });
        }
    }
    /**
     * When the left-mouse button is pressed, the knob location is updated and
     * dragging starts.
     */
    onPointerDown_(event) {
        if (this.disabled_ ||
            event.buttons !== 1 && event.pointerType === 'mouse') {
            return;
        }
        this.dragging = true;
        this.transiting_ = true;
        this.updateValueFromClientX_(event.clientX);
        this.showRipple_();
        this.setPointerCapture(event.pointerId);
        const stopDragging = this.stopDragging_.bind(this, event.pointerId);
        assert(!!this.draggingEventTracker_);
        this.draggingEventTracker_.add(this, 'pointermove', (e) => {
            // Prevent unwanted text selection to occur while moving the pointer,
            // this is important.
            e.preventDefault();
            // If the left-button on the mouse is pressed by itself, then update.
            // Otherwise stop capturing the mouse events because the drag operation
            // is complete.
            if (e.buttons !== 1 && e.pointerType === 'mouse') {
                stopDragging();
                return;
            }
            this.updateValueFromClientX_(e.clientX);
        });
        this.draggingEventTracker_.add(this, 'pointercancel', stopDragging);
        this.draggingEventTracker_.add(this, 'pointerdown', stopDragging);
        this.draggingEventTracker_.add(this, 'pointerup', stopDragging);
        this.draggingEventTracker_.add(this, 'keydown', (e) => {
            if (e.key === 'Escape' || e.key === 'Tab' || e.key === 'Home' ||
                e.key === 'End' || this.deltaKeyMap_.has(e.key)) {
                stopDragging();
            }
        });
    }
    onTransitionEnd_() {
        this.transiting_ = false;
    }
    updateUi_() {
        const percent = `${this.getRatio() * 100}%`;
        this.$.bar.style.width = percent;
        this.$.knobAndLabel.style.marginInlineStart = percent;
        const ticks = this.ticks;
        const value = this.value;
        if (ticks && ticks.length > 0 && Number.isInteger(value) && value >= 0 &&
            value < ticks.length) {
            const tick = ticks[this.value];
            this.label_ = Number.isFinite(tick) ? '' : tick.label;
            const ariaValueNow = getAriaValue(tick);
            this.setAttribute('aria-valuetext', String(this.label_ || ariaValueNow));
            this.setAttribute('aria-valuenow', ariaValueNow.toString());
            this.setAttribute('aria-valuemin', getAriaValue(ticks[0]).toString());
            this.setAttribute('aria-valuemax', getAriaValue(ticks.slice(-1)[0]).toString());
        }
        else {
            this.setAttribute('aria-valuetext', value !== undefined ? value.toString() : '');
            this.setAttribute('aria-valuenow', value !== undefined ? value.toString() : '');
            this.setAttribute('aria-valuemin', this.min.toString());
            this.setAttribute('aria-valuemax', this.max.toString());
        }
    }
    updateValue_(value) {
        if (this.snaps) {
            // Skip update if |value| has not passed the next value .8 units away.
            // The value will update as the drag approaches the next value.
            if (Math.abs(this.value - value) < .8) {
                return false;
            }
            value = Math.round(value);
        }
        value = clamp(this.min, this.max, value);
        if (this.value === value) {
            return false;
        }
        this.value = value;
        return true;
    }
    isRtl_() {
        return this.matches(':host-context([dir=rtl]) cr-slider');
    }
    updateValueFromClientX_(clientX) {
        const rect = this.$.container.getBoundingClientRect();
        let ratio = (clientX - rect.left) / rect.width;
        if (this.isRtl_()) {
            ratio = 1 - ratio;
        }
        if (this.updateValue_(ratio * (this.max - this.min) + this.min)) {
            this.fire('cr-slider-value-changed');
        }
    }
    onKeyPressSliderIncrementChanged_() {
        const isRtl = this.isRtl_();
        const increment = this.keyPressSliderIncrement;
        const decrement = -this.keyPressSliderIncrement;
        this.deltaKeyMap_ = new Map([
            ['ArrowDown', decrement],
            ['ArrowUp', increment],
            ['PageDown', decrement],
            ['PageUp', increment],
            ['ArrowLeft', isRtl ? increment : decrement],
            ['ArrowRight', isRtl ? decrement : increment],
        ]);
    }
    // Overridden from CrRippleMixin
    createRipple() {
        this.rippleContainer = this.$.knob;
        const ripple = super.createRipple();
        ripple.setAttribute('recenters', '');
        ripple.classList.add('circle');
        return ripple;
    }
}
customElements.define(CrSliderElement.is, CrSliderElement);

function getTemplate$2i() {
    return html `<!--_html_template_start_--><style>:host{display:inline-flex}cr-policy-pref-indicator{align-self:center;margin-inline-start:var(--cr-controlled-by-spacing)}#labels[disabled]{color:var(--google-grey-400)}@media (prefers-color-scheme:dark){#labels[disabled]{color:var(--google-grey-500)}}div.outer{align-items:stretch;display:flex;flex-direction:column;margin:8px 0;min-width:200px}#labels{display:flex;flex-direction:row;justify-content:space-between;margin:-4px 16px 0 16px}#labels>div{font-size:12px}#label-begin{margin-inline-end:4px}#label-end{margin-inline-start:4px}</style>
<template is="dom-if" if="[[pref.controlledBy]]" restamp>
  <cr-policy-pref-indicator pref="[[pref]]"></cr-policy-pref-indicator>
</template>
<div class="outer">
  <cr-slider id="slider" disabled$="[[disableSlider_]]" ticks="[[ticks]]"
      on-cr-slider-value-changed="onSliderChanged_" max="[[max]]"
      min="[[min]]" on-dragging-changed="onSliderChanged_"
      on-updating-from-key="onSliderChanged_"
      aria-roledescription$="[[getRoleDescription_()]]"
      aria-label$="[[labelAria]]"
      aria-disabled="[[ariaDisabled]]">
  </cr-slider>
  <!-- aria-hidden because role description on #slider contains min/max. -->
  <div id="labels" disabled$="[[disableSlider_]]" aria-hidden="true">
    <div id="label-begin">[[labelMin]]</div>
    <div id="label-end">[[labelMax]]</div>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * settings-slider wraps a cr-slider. It maps the slider's values from a
 * linear UI range to a range of real values.  When |value| does not map exactly
 * to a tick mark, it interpolates to the nearest tick.
 */
const SettingsSliderElementBase = CrPolicyPrefMixin(PolymerElement);
class SettingsSliderElement extends SettingsSliderElementBase {
    static get is() {
        return 'settings-slider';
    }
    static get template() {
        return getTemplate$2i();
    }
    static get properties() {
        return {
            pref: Object,
            /**
             * Values corresponding to each tick.
             */
            ticks: {
                type: Array,
                value: () => [],
            },
            /**
             * A scale factor used to support fractional pref values. This is not
             * compatible with |ticks|, i.e. if |scale| is not 1 then |ticks| must be
             * empty.
             */
            scale: {
                type: Number,
                value: 1,
            },
            min: Number,
            max: Number,
            labelAria: String,
            labelMin: String,
            labelMax: String,
            disabled: Boolean,
            // The value of ariaDisabled should only be "true" or "false".
            ariaDisabled: String,
            showMarkers: Boolean,
            disableSlider_: {
                computed: 'computeDisableSlider_(pref.*, disabled, ticks.*)',
                type: Boolean,
            },
            updateValueInstantly: {
                type: Boolean,
                value: true,
                observer: 'onSliderChanged_',
            },
            loaded_: Boolean,
        };
    }
    static get observers() {
        return [
            'valueChanged_(pref.*, ticks.*, loaded_)',
        ];
    }
    connectedCallback() {
        super.connectedCallback();
        this.loaded_ = true;
    }
    focus() {
        this.$.slider.focus();
    }
    getTickValue_(tick) {
        return typeof tick === 'object' ? tick.value : tick;
    }
    getTickValueAtIndex_(index) {
        return this.getTickValue_(this.ticks[index]);
    }
    /**
     * Sets the |pref.value| property to the value corresponding to the knob
     * position after a user action.
     */
    onSliderChanged_() {
        if (!this.loaded_) {
            return;
        }
        if (this.$.slider.dragging && !this.updateValueInstantly) {
            return;
        }
        const sliderValue = this.$.slider.value;
        let newValue;
        if (this.ticks && this.ticks.length > 0) {
            newValue = this.getTickValueAtIndex_(sliderValue);
        }
        else {
            newValue = sliderValue / this.scale;
        }
        this.set('pref.value', newValue);
    }
    computeDisableSlider_() {
        return this.disabled || this.isPrefEnforced();
    }
    /**
     * Updates the knob position when |pref.value| changes. If the knob is still
     * being dragged, this instead forces |pref.value| back to the current
     * position.
     */
    valueChanged_() {
        if (this.pref === undefined || !this.loaded_ || this.$.slider.dragging ||
            this.$.slider.updatingFromKey) {
            return;
        }
        // First update the slider settings if |ticks| was set.
        const numTicks = this.ticks.length;
        if (numTicks === 1) {
            this.$.slider.disabled = true;
            return;
        }
        const prefValue = this.pref.value;
        // The preference and slider values are continuous when |ticks| is empty.
        if (numTicks === 0) {
            this.$.slider.value = prefValue * this.scale;
            return;
        }
        assert(this.scale === 1);
        // Limit the number of ticks to 10 to keep the slider from looking too busy.
        const MAX_TICKS = 10;
        this.$.slider.markerCount =
            (this.showMarkers || numTicks <= MAX_TICKS) ? numTicks : 0;
        // Convert from the public |value| to the slider index (where the knob
        // should be positioned on the slider).
        const index = this.ticks
            .map((tick) => Math.abs(this.getTickValue_(tick) - prefValue))
            .reduce((acc, diff, index) => diff < acc.diff ? { index, diff } : acc, { index: -1, diff: Number.MAX_VALUE })
            .index;
        assert(index !== -1);
        if (this.$.slider.value !== index) {
            this.$.slider.value = index;
        }
        const tickValue = this.getTickValueAtIndex_(index);
        if (this.pref.value !== tickValue) {
            this.set('pref.value', tickValue);
        }
    }
    getRoleDescription_() {
        return loadTimeData.getStringF('settingsSliderRoleDescription', this.labelMin, this.labelMax);
    }
}
customElements.define(SettingsSliderElement.is, SettingsSliderElement);

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// clang-format off
class FontsBrowserProxyImpl {
    fetchFontsData() {
        return sendWithPromise('fetchFontsData');
    }
    static getInstance() {
        return instance$l || (instance$l = new FontsBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance$l = obj;
    }
}
let instance$l = null;

function getTemplate$2h() {
    return html `<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">#minimumSize{align-items:flex-end;display:flex;flex-direction:column}#minimumSizeFontPreview{text-align:end}div[id$='FontPreview']{line-height:initial}
  </style>
  <settings-subpage page-title="$i18n{customizeFonts}"
      route-path$="[[routePath]]">
    <div class="cr-row first">
      <div class="flex cr-padded-text" aria-hidden="true">
        $i18n{fontSize}
      </div>
      <settings-slider id="sizeSlider"
          pref="{{prefs.webkit.webprefs.default_font_size}}"
          ticks="[[fontSizeRange_]]" label-aria="$i18n{fontSize}"
          label-min="$i18n{tiny}" label-max="$i18n{huge}">
      </settings-slider>
    </div>
    <div class="cr-row">
      <div class="flex cr-padded-text" aria-hidden="true">
        $i18n{minimumFont}
      </div>
      <div id="minimumSize">
        <settings-slider  pref="{{prefs.webkit.webprefs.minimum_font_size}}"
            ticks="[[minimumFontSizeRange_]]" label-aria="$i18n{minimumFont}"
            label-min="$i18n{tiny}" label-max="$i18n{huge}">
        </settings-slider>
        <div id="minimumSizeFontPreview"
            style="
                font-size:[[computeMinimumFontSize_(
                    prefs.webkit.webprefs.minimum_font_size.value)]]px;
                font-family:
                    '[[prefs.webkit.webprefs.fonts.standard.Zyyy.value]]';"
            hidden>
          [[computeMinimumFontSize_(
                  prefs.webkit.webprefs.minimum_font_size.value)]]:
          $i18n{quickBrownFox}
        </div>
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{standardFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{standardFont}"
            pref="{{prefs.webkit.webprefs.fonts.standard.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <div id="standardFontPreview" class="list-item cr-padded-text"
          style="
              font-size:[[prefs.webkit.webprefs.default_font_size.value]]px;
              font-family:
                  '[[prefs.webkit.webprefs.fonts.standard.Zyyy.value]]';">
        [[prefs.webkit.webprefs.default_font_size.value]]:
        $i18n{quickBrownFox}
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{serifFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{serifFont}"
            pref="{{prefs.webkit.webprefs.fonts.serif.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <div id="serifFontPreview" class="list-item cr-padded-text"
          style="
              font-size:[[prefs.webkit.webprefs.default_font_size.value]]px;
              font-family:
                  '[[prefs.webkit.webprefs.fonts.serif.Zyyy.value]]';">
        [[prefs.webkit.webprefs.default_font_size.value]]:
        $i18n{quickBrownFox}
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{sansSerifFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{sansSerifFont}"
            pref="{{prefs.webkit.webprefs.fonts.sansserif.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <div id="sansSerifFontPreview" class="list-item cr-padded-text"
          style="
              font-size:[[prefs.webkit.webprefs.default_font_size.value]]px;
              font-family:
                  '[[prefs.webkit.webprefs.fonts.sansserif.Zyyy.value]]';">
        [[prefs.webkit.webprefs.default_font_size.value]]:
        $i18n{quickBrownFox}
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{fixedWidthFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{fixedWidthFont}"
            pref="{{prefs.webkit.webprefs.fonts.fixed.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <div id="fixedFontPreview" class="list-item cr-padded-text"
          style="
              font-size:
                  [[prefs.webkit.webprefs.default_fixed_font_size.value]]px;
              font-family: '[[fontFamilyValueForFixed_(
                  prefs.webkit.webprefs.fonts.fixed.Zyyy.value)]]';">
        [[prefs.webkit.webprefs.default_fixed_font_size.value]]:
        $i18n{quickBrownFox}
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{mathFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{mathFont}"
            pref="{{prefs.webkit.webprefs.fonts.math.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <!-- A text preview like quickBrownFox is not really helpful for
           mathematical fonts. Not only it's desired to show special math
           characters but also to demo advanced features involving the
           OpenType MATH table such as big/stretchy operators or special
           layout constants. This is what the formula below tries to do. -->
      <div id="mathFontPreview" class="list-item cr-padded-text"
          style="
              font-size:[[prefs.webkit.webprefs.default_font_size.value]]px;
              font-family:
                  '[[prefs.webkit.webprefs.fonts.math.Zyyy.value]]';">
        [[prefs.webkit.webprefs.default_font_size.value]]:
        <math style="font: inherit;" displaystyle="true">
          <mrow>
            <msqrt>
              <mrow>
                <munderover>
                  <mo>∑</mo>
                  <mrow>
                    <mi>n</mi>
                    <mo>=</mo>
                    <mn>1</mn>
                  </mrow>
                  <mn>∞</mn>
                </munderover>
                <mfrac>
                  <mn>10</mn>
                  <msup>
                    <mi>n</mi>
                    <mn>4</mn>
                  </msup>
                </mfrac>
              </mrow>
            </msqrt>
            <mo>=</mo>
            <mrow>
              <msubsup>
                <mo>∫</mo>
                <mn>0</mn>
                <mn>∞</mn>
              </msubsup>
              <mfrac>
                <mrow>
                  <mn>2</mn>
                  <mi>x</mi>
                  <mrow>
                    <mi>d</mi>
                    <mi>x</mi>
                  </mrow>
                </mrow>
                <mrow>
                  <msup>
                    <mi>e</mi>
                    <mi>x</mi>
                  </msup>
                  <mo>−</mo>
                  <mn>1</mn>
                </mrow>
              </mfrac>
            </mrow>
            <mo>=</mo>
            <mfrac>
              <msup>
                <mi>π</mi>
                <mn>2</mn>
              </msup>
              <mn>3</mn>
            </mfrac>
            <mo>∊</mo>
            <mi>ℝ</mi>
          </mrow>
        </math>
      </div>
    </div>
  </settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const FONT_SIZE_RANGE = [
    9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 22, 24,
    26, 28, 30, 32, 34, 36, 40, 44, 48, 56, 64, 72,
];
const MINIMUM_FONT_SIZE_RANGE = [0, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 22, 24];
function ticksWithLabels(ticks) {
    return ticks.map(x => ({ label: `${x}`, value: x, ariaValue: undefined }));
}
const SettingsAppearanceFontsPageElementBase = SettingsViewMixin(PolymerElement);
class SettingsAppearanceFontsPageElement extends SettingsAppearanceFontsPageElementBase {
    static get is() {
        return 'settings-appearance-fonts-page';
    }
    static get template() {
        return getTemplate$2h();
    }
    static get properties() {
        return {
            fontOptions_: Object,
            /** Common font sizes. */
            fontSizeRange_: {
                readOnly: true,
                type: Array,
                value: ticksWithLabels(FONT_SIZE_RANGE),
            },
            /** Reasonable, minimum font sizes. */
            minimumFontSizeRange_: {
                readOnly: true,
                type: Array,
                value: ticksWithLabels(MINIMUM_FONT_SIZE_RANGE),
            },
            /**
             * Preferences state.
             */
            prefs: {
                type: Object,
                notify: true,
            },
        };
    }
    static get observers() {
        return [
            'onMinimumSizeChange_(prefs.webkit.webprefs.minimum_font_size.value)',
        ];
    }
    browserProxy_ = FontsBrowserProxyImpl.getInstance();
    ready() {
        super.ready();
        this.browserProxy_.fetchFontsData().then(this.setFontsData_.bind(this));
    }
    setFontsData_(response) {
        const fontMenuOptions = [];
        for (const fontData of response.fontList) {
            fontMenuOptions.push({ value: fontData[0], name: fontData[1] });
        }
        this.fontOptions_ = fontMenuOptions;
    }
    /**
     * Get the minimum font size, accounting for unset prefs.
     */
    computeMinimumFontSize_() {
        const prefValue = this.get('prefs.webkit.webprefs.minimum_font_size.value');
        return prefValue || MINIMUM_FONT_SIZE_RANGE[0];
    }
    onMinimumSizeChange_() {
        this.$.minimumSizeFontPreview.hidden = this.computeMinimumFontSize_() <= 0;
    }
    fontFamilyValueForFixed_(prefValue) {
        // 
        // Osaka font family, which is bundled with macOS, contains a proportional
        // and a fixed-width fonts. The CSS `font-family` property distinguishes
        // them by assuming 'Osaka' for the proportional font and 'Osaka-Mono' for
        // the fixed-width font. See crbug.com/40535332.
        if (prefValue === 'Osaka') {
            return 'Osaka-Mono';
        }
        // 
        return prefValue;
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsAppearanceFontsPageElement.is, SettingsAppearanceFontsPageElement);

function getTemplate$2g() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared cr-icons
    settings-columned-section"></style>
<settings-subpage page-title="$i18n{autofillAiPageTitle}">
<div id="topSection">
  <settings-toggle-button id="prefToggle"
      on-settings-boolean-control-change="onOptInToggleChange_"
      disabled="[[ineligibleUser]]" pref="{{optedIn_}}"
      no-extension-indicator label="$i18n{autofillAiPageTitle}"
      sub-label="$i18n{autofillAiToggleSubLabel}">
  </settings-toggle-button>

  <div class="settings-columned-section">
    <div class="column">
      <h3 class="description-header">$i18n{columnHeadingWhenOn}</h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:sync-saved-locally" aria-hidden="true">
          </cr-icon>
          <div class="cr-secondary-text">
            $i18n{autofillAiWhenOnSavedInfo}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:text-analysis" aria-hidden="true"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{autofillAiWhenOnUseToFill}
          </div>
        </li>
      </ul>
    </div>
    <div class="column">
      <h3 class="description-header">
        $i18n{columnHeadingConsider}
      </h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:googleg" aria-hidden="true"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{autofillAiToConsiderDataUsage}
          </div>
        </li>
        <template is="dom-if" if="[[showLoggingInfoBullet_(
            prefs.optimization_guide.model_execution.autofill_prediction_improvements_enterprise_policy_allowed.value)]]"
            restamp>
          <settings-ai-logging-info-bullet
              id="enterpriseInfoBullet"
              pref=
                  "[[prefs.optimization_guide.model_execution.autofill_prediction_improvements_enterprise_policy_allowed]]"
              logging-managed-disabled-custom-label=
                  "$i18n{autofillAiSubpageSublabelLoggingManagedDisabled}">
          </settings-ai-logging-info-bullet>
        </template>
      </ul>
    </div>
  </div>
</div>

<settings-autofill-ai-entries-list-element prefs="{{prefs}}">
</settings-autofill-ai-entries-list-element>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-autofill-ai-section' contains configuration options
 * for Autofill AI.
 */
const SettingsAutofillAiSectionElementBase = SettingsViewMixin(I18nMixin(PrefsMixin(PolymerElement)));
class SettingsAutofillAiSectionElement extends SettingsAutofillAiSectionElementBase {
    static get is() {
        return 'settings-autofill-ai-section';
    }
    static get template() {
        return getTemplate$2g();
    }
    static get properties() {
        return {
            /**
               If a user is not eligible for Autofill with Ai, but they have data
               saved, the code allows them only to edit and delete their data. They
               are not allowed to add new data, or to opt-in or opt-out of Autofill
               with Ai using the toggle at the top of this page.
               If a user is not eligible for Autofill with Ai and they also have no
               data saved, then they cannot access this page at all.
             */
            ineligibleUser: {
                type: Boolean,
                value() {
                    return !loadTimeData.getBoolean('userEligibleForAutofillAi');
                },
            },
            /**
               A "fake" preference object that reflects the state of the opt-in
               toggle and the presence/absence of an enterprise policy.
               This allows leveraging the settings-toggle-button component
               to reflect enterprise enabled/disabled states.
             */
            optedIn_: {
                type: Object,
                value: () => ({
                    // Does not correspond to an actual pref - this is faked to allow
                    // writing it into a GAIA-id keyed dictionary of opt-ins.
                    type: chrome.settingsPrivate.PrefType.BOOLEAN,
                    value: false,
                }),
            },
            /**
              If reflects whether Wallet server data is available for storage.
            */
            isWalletServerStorageEnabled_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('isWalletServerStorageEnabled');
                },
            },
        };
    }
    static get observers() {
        return [
            `onAutofillAiPrefChanged_(
          prefs.autofill.profile_enabled.value)`,
        ];
    }
    entityDataManager_ = EntityDataManagerProxyImpl.getInstance();
    connectedCallback() {
        super.connectedCallback();
        this.entityDataManager_.getOptInStatus().then(optedIn => this.set('optedIn_.value', !this.ineligibleUser && optedIn));
        const policyDisabled = this.getPref(AiEnterpriseFeaturePrefName.AUTOFILL_AI).value ===
            ModelExecutionEnterprisePolicyValue.DISABLE;
        if (policyDisabled) {
            this.set('optedIn_.enforcement', chrome.settingsPrivate.Enforcement.ENFORCED);
            this.set('optedIn_.controlledBy', chrome.settingsPrivate.ControlledBy.USER_POLICY);
        }
    }
    disconnectedCallback() {
        super.disconnectedCallback();
    }
    async onOptInToggleChange_() {
        // `setOptInStatus` returns false when the user tries to toggle the opt-in
        // status when they're ineligible.  This shouldn't happen usually but in
        // some cases it can happen (see crbug.com/408145195).
        this.ineligibleUser = !(await this.entityDataManager_.setOptInStatus(this.$.prefToggle.checked));
        if (this.ineligibleUser) {
            this.set('optedIn_.value', false);
        }
    }
    /**
     * Whether an info bullet regarding logging is shown. Autofill Ai only shows
     * logging behaviour information for enterprise clients who have either the
     * feature disabled or just logging disabled.
     */
    showLoggingInfoBullet_(pref) {
        return pref !== ModelExecutionEnterprisePolicyValue.ALLOW;
    }
    // Adjusts the opt-in state when address autofill status changes.
    //
    // This covers the case where a user disables address autofill and then checks
    // the AutofillAI opt-in status. In this case, we do not remove the AutofillAI
    // entry, but just set the opt-in to false. Note that other
    // preconditions (e.g., sync) are not covered.
    async onAutofillAiPrefChanged_(prefValue) {
        const optedIn = await this.entityDataManager_.getOptInStatus();
        this.set('optedIn_.value', !this.ineligibleUser && optedIn && prefValue);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsAutofillAiSectionElement.is, SettingsAutofillAiSectionElement);

const styleMod$5 = document.createElement('dom-module');
styleMod$5.appendChild(html `
  <template>
    <style>
.multi-card>.card{background-color:var(--cr-card-background-color);border-radius:var(--cr-card-border-radius);box-shadow:var(--cr-card-shadow);margin-top:var(--cr-section-vertical-margin)}.multi-card>.card:first-of-type{margin-top:0}.card h2{align-self:auto;padding-bottom:0;padding-top:12px}
    </style>
  </template>
`.content);
styleMod$5.register('your-saved-info-shared');

function getTemplate$2f() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared md-select">:host{white-space:nowrap}:host-context([dir=rtl]) cr-input.phone-number-input::part(input){direction:ltr;text-align:end}.address-row{display:flex}.address-column{margin-inline-end:16px;width:calc((var(--cr-default-input-max-width) - 16px) / 2)}#select-row{display:block;outline:none;transform:translate3d(0,0,0)}.md-select{--md-select-width:var(--cr-default-input-max-width)}.long{width:var(--cr-default-input-max-width)}cr-input{--cr-input-error-display:none}cr-input:not(.last-row),cr-textarea,.md-select{margin-bottom:var(--cr-form-field-bottom-spacing)}#dialog::part(body-container){max-height:550px}@media all and (max-height:714px){#dialog::part(body-container){max-height:270px}}#notices{margin-bottom:4px;margin-top:20px;white-space:initial}#validationError{color:var(--google-red-600)}@media (prefers-color-scheme:dark){#validationError{color:var(--google-red-300)}}

    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div slot="title">[[title_]]</div>
      <div slot="body">
        <div id="select-row" class="address-row">
          <label id="select-label" class="cr-form-field-label">
            $i18n{addressCountry}
          </label>
          <select id="country" class="md-select" aria-labelledby="select-label"
              value="[[countryCode_]]" on-change="onCountryCodeSelectChange_"
              autofocus>
            <!-- TODO(crbug.com/403312087): Use
                 $i18n{autofillDropdownNoOptionSelected} as a text for this
                 option once the string is approved. -->
            <option value="" hidden="[[isAccountAddress_]]"></option>
            <template is="dom-repeat" items="[[countries_]]">
              <option value="[[getCode_(item)]]"
                  disabled="[[isDivision_(item)]]">
                [[getName_(item)]]
              </option>
            </template>
          </select>
        </div>
        <template is="dom-repeat" items="[[components_]]">
          <div class="address-row">
            <template is="dom-repeat" items="[[item]]">
              <template is="dom-if" if="[[item.isTextarea]]">
                <cr-textarea label="[[item.label]]"
                    value="{{item.value}}"
                    class$="address-column [[item.additionalClassName]]"
                    spellcheck="false" maxlength="1000"
                    required="[[item.isRequired]]"
                    invalid="[[isVisuallyInvalid_(item.isValidatable,
                                                  item.isValid)]]">
                </cr-textarea>
              </template>
              <template is="dom-if" if="[[!item.isTextarea]]">
                <cr-input type="text" label="[[item.label]]"
                    value="{{item.value}}" spellcheck="false"
                    maxlength="1000"
                    class$="address-column [[item.additionalClassName]]
                    [[getPhoneNumberInputClass_(item.fieldType)]]"
                    required="[[item.isRequired]]"
                    invalid="[[isVisuallyInvalid_(item.isValidatable,
                                                  item.isValid)]]">
                </cr-input>
              </template>
            </template>
          </div>
        </template>
        <div id="notices" hidden="[[!isAccountAddress_]]">
          <div id="validationError" hidden="[[!validationError_]]">
            [[validationError_]]
          </div>
          <div id="accountRecordTypeNotice"
              hidden="[[!accountAddressRecordTypeNotice_]]">
            [[accountAddressRecordTypeNotice_]]
          </div>
        </div>
      </div>
      <div slot="button-container">
        <cr-button id="cancelButton" class="cancel-button"
            on-click="onCancelClick_">
          $i18n{cancel}
        </cr-button>
        <cr-button id="saveButton" class="action-button"
            disabled="[[!canSave_]]" on-click="onSaveButtonClick_">
          $i18n{save}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function isValueEmpty(value) {
    return value === undefined || value === '';
}
/**
 * The base class for data behind an address component. It exposes the `value`
 * property, which is how interface controls (e.g. input) communicate with it.
 */
class AddressComponentUi {
    fieldType_;
    originalValue_;
    existingAddress_;
    onValueUpdateListener_;
    skipValidation_;
    addressFields_;
    isValidatable_;
    isTextarea;
    isRequired;
    label;
    additionalClassName;
    constructor(addressFields, originalFields, fieldType, label, onValueUpdateListener, additionalClassName = '', isTextarea = false, skipValidation = false, isRequired = false) {
        this.addressFields_ = addressFields;
        this.existingAddress_ = originalFields !== undefined;
        this.originalValue_ = originalFields?.get(fieldType);
        this.fieldType_ = fieldType;
        this.label = label;
        this.onValueUpdateListener_ = onValueUpdateListener;
        this.additionalClassName = additionalClassName;
        this.isTextarea = isTextarea;
        this.isRequired = isRequired;
        this.skipValidation_ = skipValidation;
        this.isValidatable_ = false;
    }
    /**
     * Being validatable for an address component means that its invalid state
     * is visible to the user. Having a component not validatable initially
     * (before any interactions with controls) allows less aggressive validation
     * experience for the user.
     */
    get isValidatable() {
        return this.isValidatable_;
    }
    get isValid() {
        if (this.skipValidation_) {
            return true;
        }
        if (this.existingAddress_) {
            // "dont make it worse" validation for existing addresses:
            // consider a field valid as long as it is equal to the original value,
            // whether it is valid or not.
            if (this.originalValue_ === this.value ||
                (isValueEmpty(this.originalValue_) && isValueEmpty(this.value))) {
                return true;
            }
        }
        return !this.isRequired || !!this.value;
    }
    get value() {
        return this.addressFields_.get(this.fieldType_);
    }
    set value(value) {
        const changed = value !== this.value;
        this.addressFields_.set(this.fieldType_, value);
        if (changed) {
            this.onValueUpdateListener_();
        }
    }
    get hasValue() {
        return !isValueEmpty(this.value);
    }
    get fieldType() {
        return this.fieldType_;
    }
    makeValidatable() {
        this.isValidatable_ = true;
    }
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'address-edit-dialog' is the dialog that allows editing a saved
 * address.
 */
const AddressRecordType = chrome.autofillPrivate.AddressRecordType;
const FieldType = chrome.autofillPrivate.FieldType;
const SettingsAddressEditDialogElementBase = I18nMixin(PolymerElement);
class SettingsAddressEditDialogElement extends SettingsAddressEditDialogElementBase {
    static get is() {
        return 'settings-address-edit-dialog';
    }
    static get template() {
        return getTemplate$2f();
    }
    static get properties() {
        return {
            address: Object,
            accountInfo: Object,
            title_: String,
            validationError_: String,
            countries_: Array,
            /**
             * Updates the address wrapper.
             */
            countryCode_: {
                type: String,
                observer: 'onCountryCodeChanged_',
            },
            components_: {
                type: Array,
                value: () => [],
            },
            canSave_: Boolean,
            isAccountAddress_: {
                type: Boolean,
                computed: 'isAddressStoredInAccount_(address, accountInfo)',
                value: false,
            },
            accountAddressRecordTypeNotice_: {
                type: String,
                computed: 'getAccountAddressRecordTypeNotice_(address, accountInfo)',
            },
        };
    }
    addressFields_ = new Map();
    originalAddressFields_;
    countryDetailManager_ = CountryDetailManagerProxyImpl.getInstance();
    connectedCallback() {
        super.connectedCallback();
        assert(this.address);
        for (const entry of this.address.fields) {
            this.addressFields_.set(entry.type, entry.value);
        }
        const forAccountStorage = !!this.address.guid &&
            this.address.metadata !== undefined &&
            this.address.metadata.recordType === AddressRecordType.ACCOUNT;
        this.countryDetailManager_.getCountryList(forAccountStorage)
            .then(countryList => {
            this.countries_ = countryList;
            const isEditingExistingAddress = !!this.address.guid;
            this.title_ = this.i18n(isEditingExistingAddress ? 'editAddressTitle' :
                'addAddressTitle');
            this.originalAddressFields_ = isEditingExistingAddress ?
                new Map(this.addressFields_) :
                undefined;
            microTask.run(() => {
                const countryField = this.addressFields_.get(FieldType.ADDRESS_HOME_COUNTRY);
                if (!countryField) {
                    assert(countryList.length > 0);
                    // If the address is completely empty, the dialog is creating a
                    // new address. The first address in the country list is what we
                    // suspect the user's country is.
                    this.addressFields_.set(FieldType.ADDRESS_HOME_COUNTRY, countryList[0].countryCode);
                }
                this.countryCode_ =
                    this.addressFields_.get(FieldType.ADDRESS_HOME_COUNTRY);
            });
        });
        // Open is called on the dialog after the address wrapper has been
        // updated.
    }
    fire_(eventName, detail) {
        this.dispatchEvent(new CustomEvent(eventName, { bubbles: true, composed: true, detail }));
    }
    /**
     * Updates the wrapper that represents this address in the country's format.
     */
    async updateAddressComponents_() {
        // Default to the last country used if no country code is provided.
        const countryCode = this.countryCode_ || this.countries_[0].countryCode;
        const format = await this.countryDetailManager_.getAddressFormat(countryCode);
        this.address.languageCode = format.languageCode;
        // TODO(crbug.com/40253382): validation is performed for addresses
        // from the user account only now, this flag should be removed when it
        // becomes the only type of addresses
        const skipValidation = !this.isAccountAddress_;
        this.components_ = format.components.map((componentRow, rowIndex) => {
            return componentRow.row.map((component, colIndex) => {
                return new AddressComponentUi(this.addressFields_, this.originalAddressFields_, component.field, component.fieldName, this.notifyComponentValidity_.bind(this, rowIndex, colIndex), component.isLongField ? 'long' : '', component.field === FieldType.ADDRESS_HOME_STREET_ADDRESS, skipValidation, component.isRequired);
            });
        });
        // Phone and email do not come in the address format as fields, but
        // should be editable and saveable in the resulting address.
        const contactsRowIndex = this.components_.length;
        this.components_.push([
            new AddressComponentUi(this.addressFields_, this.originalAddressFields_, FieldType.PHONE_HOME_WHOLE_NUMBER, this.i18n('addressPhone'), this.notifyComponentValidity_.bind(this, contactsRowIndex, 0), 'last-row'),
            new AddressComponentUi(this.addressFields_, this.originalAddressFields_, FieldType.EMAIL_ADDRESS, this.i18n('addressEmail'), this.notifyComponentValidity_.bind(this, contactsRowIndex, 1), 'long last-row'),
        ]);
        // Flush dom before resize and savability updates.
        flush();
        this.updateCanSave_();
        this.fire_('on-update-address-wrapper'); // For easier testing.
        if (!this.$.dialog.open) {
            this.$.dialog.showModal();
        }
    }
    /**
     * Determines whether component with specified validation property
     * should be rendered as invalid in the template.
     */
    isVisuallyInvalid_(isValidatable, isValid) {
        return isValidatable && !isValid;
    }
    /**
     * Makes component's potentially invalid state visible, it makes
     * the component validatable and notifies the template engine.
     * The component is addressed by row/col to leverage Polymer's notifications.
     */
    notifyComponentValidity_(row, col) {
        this.components_[row][col].makeValidatable();
        const componentReference = `components_.${row}.${col}`;
        this.notifyPath(componentReference + '.isValidatable');
        this.notifyPath(componentReference + '.isValid');
        this.updateCanSave_();
    }
    /**
     * Notifies all components validity (see notifyComponentValidity_()).
     */
    notifyValidity_() {
        this.components_.forEach((row, i) => {
            row.forEach((_col, j) => this.notifyComponentValidity_(i, j));
        });
    }
    updateCanSave_() {
        this.validationError_ = '';
        if ((!this.countryCode_ && this.hasAnyValue_()) ||
            (this.countryCode_ &&
                (!this.hasInvalidComponent_() ||
                    this.hasUncoveredInvalidComponent_()))) {
            this.canSave_ = true;
            this.fire_('on-update-can-save'); // For easier testing.
            return;
        }
        if (this.isAccountAddress_) {
            const nInvalid = this.countInvalidComponent_();
            if (nInvalid === 1) {
                this.validationError_ = this.i18n('editAddressRequiredFieldError');
            }
            else if (nInvalid > 1) {
                this.validationError_ = this.i18n('editAddressRequiredFieldsError');
            }
        }
        this.canSave_ = false;
        this.fire_('on-update-can-save'); // For easier testing.
    }
    getCode_(country) {
        return country.countryCode || 'SPACER';
    }
    getName_(country) {
        return country.name || '------';
    }
    isDivision_(country) {
        return !country.countryCode;
    }
    getPhoneNumberInputClass_(fieldType) {
        if (fieldType ===
            chrome.autofillPrivate.FieldType.PHONE_HOME_WHOLE_NUMBER) {
            return 'phone-number-input';
        }
        return '';
    }
    isAddressStoredInAccount_() {
        if (this.address.guid) {
            return this.address.metadata !== undefined &&
                this.address.metadata.recordType === AddressRecordType.ACCOUNT;
        }
        return !!this.accountInfo?.isEligibleForAddressAccountStorage;
    }
    getAccountAddressRecordTypeNotice_() {
        if (this.accountInfo) {
            return this.i18n(this.address.guid ? 'editAccountAddressRecordTypeNotice' :
                'newAccountAddressRecordTypeNotice', this.accountInfo.email);
        }
        return '';
    }
    /**
     * Tells whether at least one address component (except country)
     * has a non empty value.
     */
    hasAnyValue_() {
        return this.components_.flat().some(component => component.hasValue);
    }
    /**
     * Tells whether at least one address component (except country) is not valid.
     */
    hasInvalidComponent_() {
        return this.countInvalidComponent_() > 0;
    }
    /**
     * Counts how many invalid address componets (except country) are in the form.
     */
    countInvalidComponent_() {
        return this.components_.flat()
            .filter(component => !component.isValid)
            .length;
    }
    /**
     * Tells whether at least one address component (except country)
     * is not valid and is not validatable also, i.e. its invalid state is
     * not visible to the user.
     */
    hasUncoveredInvalidComponent_() {
        return this.components_.flat().some(component => !component.isValid && !component.isValidatable);
    }
    onCancelClick_() {
        chrome.metricsPrivate.recordBoolean('Autofill.Settings.EditAddress', 
        /*confirmed=*/ false);
        this.$.dialog.cancel();
    }
    /**
     * Handler for tapping the save button.
     */
    onSaveButtonClick_() {
        this.notifyValidity_();
        this.updateCanSave_();
        if (!this.canSave_) {
            return;
        }
        this.address.fields = [];
        this.addressFields_.forEach((value, key, _map) => {
            this.address.fields.push({ type: key, value: value });
        });
        chrome.metricsPrivate.recordBoolean('Autofill.Settings.EditAddress', 
        /*confirmed=*/ true);
        this.fire_('save-address', this.address);
        this.$.dialog.close();
    }
    async onCountryCodeChanged_() {
        await this.updateAddressComponents_();
    }
    /**
     * Syncs the country code back to the address and rebuilds the address
     * components for the new location.
     */
    onCountryCodeSelectChange_() {
        this.addressFields_.set(FieldType.ADDRESS_HOME_COUNTRY, this.$.country.value);
        this.countryCode_ = this.$.country.value;
    }
}
customElements.define(SettingsAddressEditDialogElement.is, SettingsAddressEditDialogElement);

function getTemplate$2e() {
    return html `<!--_html_template_start_--><cr-dialog show-on-attach id="dialog" close-text="$i18n{close}">
  <div slot="title" id="title">[[confirmationTitle_]]</div>
  <div slot="body" id="description"
      inner-h-t-m-l="[[confirmationDescription_]]">
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelClick" id="cancel">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" on-click="onRemoveClick" id="remove">
      [[removeButtonLabel_]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'address-remove-confirmation-dialog' is the dialog that allows
 * removing a saved address.
 */
const SettingsAddressRemoveConfirmationDialogBase = I18nMixin(PolymerElement);
class SettingsAddressRemoveConfirmationDialogElement extends SettingsAddressRemoveConfirmationDialogBase {
    static get is() {
        return 'settings-address-remove-confirmation-dialog';
    }
    static get template() {
        return getTemplate$2e();
    }
    static get properties() {
        return {
            address: Object,
            accountInfo: Object,
            /**
             * The title of the confirmation dialog.
             */
            confirmationTitle_: {
                type: String,
                computed: 'computeConfirmationTitle_()',
            },
            /**
             * The body of the confirmation dialog.
             */
            confirmationDescription_: {
                type: String,
                computed: 'computeConfirmationDescription_(address, accountInfo)',
            },
            /**
             * The label for the remove button.
             */
            removeButtonLabel_: {
                type: String,
                computed: 'computeRemoveButtonLabel_()',
            },
        };
    }
    wasConfirmed() {
        return this.$.dialog.getNative().returnValue === 'success';
    }
    computeConfirmationTitle_() {
        if (this.isAccountHomeAddress_()) {
            return this.i18n('removeHomeAddressConfirmationTitle');
        }
        if (this.isAccountWorkAddress_()) {
            return this.i18n('removeWorkAddressConfirmationTitle');
        }
        return this.isAccountNameEmailAddress_() ?
            this.i18n('removeNameEmailAddressConfirmationTitle') :
            this.i18n('removeAddressConfirmationTitle');
    }
    computeConfirmationDescription_(address, accountInfo) {
        const isAccountAddress = address?.metadata?.recordType ===
            chrome.autofillPrivate.AddressRecordType.ACCOUNT;
        if (isAccountAddress) {
            return sanitizeInnerHtml(this.i18n('deleteAccountAddressRecordTypeNotice', accountInfo?.email || ''));
        }
        if (this.isAccountHomeAddress_()) {
            return sanitizeInnerHtml(loadTimeData.getStringF('deleteHomeAddressNotice', loadTimeData.getString('googleAccountHomeAddressUrl'), accountInfo?.email || ''));
        }
        if (this.isAccountWorkAddress_()) {
            return sanitizeInnerHtml(loadTimeData.getStringF('deleteWorkAddressNotice', loadTimeData.getString('googleAccountWorkAddressUrl'), accountInfo?.email || ''));
        }
        if (this.isAccountNameEmailAddress_()) {
            return sanitizeInnerHtml(loadTimeData.getStringF('deleteNameEmailAddressNotice', loadTimeData.getString('googleAccountNameEmailAddressEditUrl'), accountInfo?.email || ''));
        }
        const isSyncEnabled = !!accountInfo?.isSyncEnabledForAutofillProfiles;
        return sanitizeInnerHtml(this.i18n(isSyncEnabled ? 'removeSyncAddressConfirmationDescription' :
            'removeLocalAddressConfirmationDescription'));
    }
    computeRemoveButtonLabel_() {
        return this.isAccountHomeAddress_() || this.isAccountWorkAddress_() ||
            this.isAccountNameEmailAddress_() ?
            this.i18n('removeAddressFromChrome') :
            this.i18n('removeAddress');
    }
    isAccountHomeAddress_() {
        return this.address?.metadata?.recordType ===
            chrome.autofillPrivate.AddressRecordType.ACCOUNT_HOME;
    }
    isAccountWorkAddress_() {
        return this.address?.metadata?.recordType ===
            chrome.autofillPrivate.AddressRecordType.ACCOUNT_WORK;
    }
    isAccountNameEmailAddress_() {
        return this.address?.metadata?.recordType ===
            chrome.autofillPrivate.AddressRecordType.ACCOUNT_NAME_EMAIL;
    }
    onRemoveClick() {
        this.$.dialog.close();
    }
    onCancelClick() {
        this.$.dialog.cancel();
    }
}
customElements.define(SettingsAddressRemoveConfirmationDialogElement.is, SettingsAddressRemoveConfirmationDialogElement);

function getTemplate$2d() {
    return html `<!--_html_template_start_-->  <style include="cr-shared-style settings-shared passwords-shared
      your-saved-info-shared">#autofillSyncToggleWrapper{align-items:center;cursor:pointer;display:flex;min-height:var(--cr-section-two-line-min-height);padding:0 var(--cr-section-padding)}#autofillSyncToggleWrapper:hover{background-color:var(--cr-hover-background-color)}#addressList .start{display:flex;overflow:hidden}#addressSummary{display:flex;flex:1;overflow:hidden}#plusAddressSettingsButton{margin-top:16px}.dropdown-item.external-link-style{display:flex;justify-content:space-between;align-items:center;width:100%}.dropdown-item.external-link-style cr-icon{--cr-icon-color:var(--cr-secondary-text-color)}
  </style>
  <settings-subpage page-title="[[getPageTitleLabel_(isYourSavedInfoSubpage_)]]"
      hide-close-button
      learn-more-url="$i18n{addressesAndPaymentMethodsLearnMoreURL}"
      class$="[[getMultiCardClass_(isYourSavedInfoSubpage_)]]">
    <div class="card">
      <settings-toggle-button id="autofillProfileToggle"
          no-extension-indicator label="$i18n{enableProfilesLabel}"
          sub-label="$i18n{enableProfilesSublabel}"
          pref="{{prefs.autofill.profile_enabled}}"
          on-change="onAutofillProfileToggleChanged_">
      </settings-toggle-button>
      <div id="autofillSyncToggleWrapper"
          hidden$="[[!isAutofillSyncToggleVisible_(accountInfo_)]]">
        <div class="flex">
          <div class="label">$i18n{autofillSyncToggleLabel}</div>
          <div class="label cr-secondary-text">[[accountInfo_.email]]</div>
        </div>
        <cr-toggle id="autofillSyncToggle"
            checked="[[accountInfo_.isAutofillSyncToggleEnabled]]"
            on-change="onAutofillSyncEnabledChange_">
        </cr-toggle>
      </div>
      <template is="dom-if"
          if="[[prefs.autofill.profile_enabled.extensionId]]">
        <div class="cr-row continuation">
          <extension-controlled-indicator class="flex"
              id="autofillExtensionIndicator"
              extension-id="[[prefs.autofill.profile_enabled.extensionId]]"
              extension-name=
                  "[[prefs.autofill.profile_enabled.controlledByName]]"
              extension-can-be-disabled="[[
                  prefs.autofill.profile_enabled.extensionCanBeDisabled]]">
          </extension-controlled-indicator>
        </div>
      </template>
    </div>
    <div class="card">
      <div class="cr-row continuation">
        <h2 class="flex">$i18n{addresses}</h2>
        <cr-button id="addAddress" class="header-aligned-button"
            on-click="onAddAddressClick_" aria-label="$i18n{addAddressTitle}"
            hidden$="[[!prefs.autofill.profile_enabled.value]]">
          $i18n{add}
        </cr-button>
      </div>
      <div class="list-frame" aria-label="$i18n{addressesTableAriaLabel}"
          role="list">
        <div id="addressList" class="vertical-list" role="none">
          <template is="dom-repeat" items="[[addresses]]">
            <div class="list-item" role="listitem">
              <div class="start">
                <span id="addressSummary">
                  <span class="ellipses">
                    [[item.metadata.summaryLabel]]
                  </span>
                  <span class="ellipses">
                    [[item.metadata.summarySublabel]]
                  </span>
                </span>
                <cr-icon
                    id="address-row-icon"
                    icon="[[getAddressIcon_(item, accountInfo_)]]"
                    hidden$="[[!shouldShowAddressIcon_(item, accountInfo_)]]"
                    aria-label="[[getA11yLabelForIcon_(item, accountInfo_)]]"
                    role="img">
                </cr-icon>
              </div>
              <cr-icon-button class="icon-more-vert address-menu"
                  on-click="onAddressMenuClick_"
                  title="[[moreActionsTitle_(item)]]">
              </cr-icon-button>
            </div>
          </template>
        </div>
        <div id="noAddressesLabel" class="list-item"
            hidden$="[[hasSome_(addresses)]]">
          $i18n{noAddressesFound}
        </div>
      </div>
      <cr-action-menu id="addressSharedMenu" role-description="$i18n{menu}">
        <template is="dom-if" if="[[isGoogleProfileAddress]]" restamp>
          <button
              id="menuEditAddress"
              class="dropdown-item external-link-style"
              on-click="onMenuEditAddressClick_"
              aria-label="$i18n{homeWorkAddressAccessiblityLabel}">
            <span class="label">$i18n{edit}</span>
            <cr-icon icon="cr:open-in-new" aria-hidden="true"></cr-icon>
          </button>

          <button id="menuRemoveAddress"
              class="dropdown-item"
              on-click="onMenuRemoveAddressClick_">
            [[getMenuRemoveAddressLabel_(activeAddress)]]
          </button>
        </template>

        <template is="dom-if" if="[[!isGoogleProfileAddress]]" restamp>
          <button id="menuEditAddress" class="dropdown-item"
              on-click="onMenuEditAddressClick_">$i18n{edit}</button>

          <button id="menuRemoveAddress" class="dropdown-item"
              on-click="onMenuRemoveAddressClick_">
            [[getMenuRemoveAddressLabel_(activeAddress)]]
          </button>
        </template>
      </cr-action-menu>
      <template is="dom-if" if="[[showAddressDialog_]]" restamp>
        <settings-address-edit-dialog address="[[activeAddress]]"
            account-info="[[accountInfo_]]" on-close="onAddressDialogClose_">
        </settings-address-edit-dialog>
      </template>
      <template is="dom-if" if="[[showAddressRemoveConfirmationDialog_]]"
          restamp>
        <settings-address-remove-confirmation-dialog
            address="[[activeAddress]]" account-info="[[accountInfo_]]"
            on-close="onAddressRemoveConfirmationDialogClose_">
        </settings-address-remove-confirmation-dialog>
      </template>
      <template is="dom-if" if="[[isPlusAddressEnabled_]]">
        <cr-link-row class="cr-row" id="plusAddressSettingsButton"
            label="$i18n{plusAddressSettings}"
            sub-label="$i18n{plusAddressSettingsSublabel}"
            on-click="onPlusAddressClick_"
            role-description="$i18n{subpageArrowRoleDescription}"
            external>
        </cr-link-row>
      </template>
    </div>
  </settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-autofill-section' is the section containing saved
 * addresses for use in autofill and payments APIs.
 */
/**
 * The enum values for the Autofill.Address.IsEnabled.Change metric.
 * These values are persisted to logs. Entries should not be renumbered and
 * numeric values should never be reused.
 */
// LINT.IfChange(AutofillAddressOptInChange)
var AutofillAddressOptInChange;
(function (AutofillAddressOptInChange) {
    AutofillAddressOptInChange[AutofillAddressOptInChange["OPT_IN"] = 0] = "OPT_IN";
    AutofillAddressOptInChange[AutofillAddressOptInChange["OPT_OUT"] = 1] = "OPT_OUT";
    // Must be last.
    AutofillAddressOptInChange[AutofillAddressOptInChange["COUNT"] = 2] = "COUNT";
})(AutofillAddressOptInChange || (AutofillAddressOptInChange = {}));
const SettingsAutofillSectionElementBase = SettingsViewMixin(I18nMixin(PolymerElement));
class SettingsAutofillSectionElement extends SettingsAutofillSectionElementBase {
    static get is() {
        return 'settings-autofill-section';
    }
    static get template() {
        return getTemplate$2d();
    }
    static get properties() {
        return {
            prefs: Object,
            accountInfo_: {
                type: Object,
                value: null,
            },
            /** An array of saved addresses. */
            addresses: Array,
            /** The model for any address related action menus or dialogs. */
            activeAddress: Object,
            showAddressDialog_: Boolean,
            showAddressRemoveConfirmationDialog_: Boolean,
            isGoogleProfileAddress: {
                type: Boolean,
                computed: 'computeIsGoogleProfileAddress_(activeAddress)',
            },
            isPlusAddressEnabled_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('plusAddressEnabled'),
            },
            /**
             * Indicates if this element is used as a Your saved info subpage. Causes
             * slight adjustments like different title, no page shadow, cards being
             * visible.
             */
            isYourSavedInfoSubpage_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('enableYourSavedInfoSettingsPage'),
            },
        };
    }
    autofillManager_ = AutofillManagerImpl.getInstance();
    setPersonalDataListener_ = null;
    ready() {
        super.ready();
        this.addEventListener('save-address', this.saveAddress_);
        // This is to mimic the behaviour of <settings-toggle-button>.
        this.$.autofillSyncToggleWrapper.addEventListener('click', () => {
            this.$.autofillSyncToggle.click();
        });
    }
    connectedCallback() {
        super.connectedCallback();
        // Create listener functions.
        const setAddressesListener = (addressList) => {
            this.addresses = addressList;
        };
        const setAccountListener = (accountInfo) => {
            this.accountInfo_ = accountInfo || null;
        };
        const setPersonalDataListener = (addressList, _cardList, _ibans, _payOverTimeIssuerList, accountInfo) => {
            this.addresses = addressList;
            this.accountInfo_ = accountInfo || null;
        };
        // Remember the bound reference in order to detach.
        this.setPersonalDataListener_ = setPersonalDataListener;
        // Request initial data.
        this.autofillManager_.getAddressList().then(setAddressesListener);
        this.autofillManager_.getAccountInfo().then(setAccountListener);
        // Listen for changes.
        this.autofillManager_.setPersonalDataManagerListener(setPersonalDataListener);
        // Record that the user opened the address settings.
        chrome.metricsPrivate.recordUserAction('AutofillAddressesViewed');
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.autofillManager_.removePersonalDataManagerListener(this.setPersonalDataListener_);
        this.setPersonalDataListener_ = null;
    }
    getMultiCardClass_() {
        return this.isYourSavedInfoSubpage_ ? 'multi-card' : '';
    }
    getPageTitleLabel_() {
        return this.i18n(this.isYourSavedInfoSubpage_ ? 'contactInfoTitle' : 'addressesTitle');
    }
    /**
     * Returns the text for the remove button in the action menu.
     */
    getMenuRemoveAddressLabel_(address) {
        const isGoogleProfileAddress = this.isAccountHomeAddress_(address) ||
            this.isAccountWorkAddress_(address) ||
            this.isAccountNameEmailAddress_(address);
        return this.i18n(isGoogleProfileAddress ? 'removeFromChrome' : 'removeAddress');
    }
    /**
     * Open the address action menu.
     */
    onAddressMenuClick_(e) {
        const item = e.model.item;
        // Copy item so dialog won't update model on cancel.
        this.activeAddress = Object.assign({}, item);
        const dotsButton = e.target;
        this.$.addressSharedMenu.showAt(dotsButton);
    }
    /**
     * Handles tapping on the "Add address" button.
     */
    onAddAddressClick_(e) {
        e.preventDefault();
        this.activeAddress = { fields: [] };
        this.showAddressDialog_ = true;
    }
    onAddressDialogClose_() {
        this.showAddressDialog_ = false;
    }
    /**
     * Handles tapping on the "Edit" address button.
     */
    onMenuEditAddressClick_(e) {
        e.preventDefault();
        if (this.isAccountHomeAddress_(this.activeAddress)) {
            this.onAccountHomeAddressClick_();
        }
        else if (this.isAccountWorkAddress_(this.activeAddress)) {
            this.onAccountWorkAddressClick_();
        }
        else if (this.isAccountNameEmailAddress_(this.activeAddress)) {
            this.onAccountNameEmailAddressClick_();
        }
        else {
            this.showAddressDialog_ = true;
        }
        this.$.addressSharedMenu.close();
    }
    onAddressRemoveConfirmationDialogClose_() {
        // Check if the dialog was confirmed before closing it.
        const wasDeletionConfirmed = this.shadowRoot
            .querySelector('settings-address-remove-confirmation-dialog').wasConfirmed();
        const isHomeOrWorkAddress = this.isAccountHomeAddress_(this.activeAddress) ||
            this.isAccountWorkAddress_(this.activeAddress);
        const recordType = this.activeAddress?.metadata?.recordType;
        if (wasDeletionConfirmed) {
            // Two corner cases are handled:
            // 1. removing the only address: the focus goes to the Add button
            // 2. removing the last address: the focus goes to the previous address
            // In other cases the focus remaining on the same node (reused in
            // subsequently updated address list), but the next address, works fine.
            if (this.addresses.length === 1) {
                focusWithoutInk(this.$.addAddress);
            }
            else {
                const lastIndex = this.addresses.length - 1;
                if (this.activeAddress.guid === this.addresses[lastIndex].guid) {
                    focusWithoutInk(this.$.addressList.querySelectorAll('.address-menu')[lastIndex - 1]);
                }
            }
            this.autofillManager_.removeAddress(this.activeAddress.guid);
            if (isHomeOrWorkAddress) {
                getInstance().announce(loadTimeData.getString('homeAndWorkAddressRemovedMessage'));
            }
            else if (this.isAccountNameEmailAddress_(this.activeAddress)) {
                getInstance().announce(loadTimeData.getString('nameEmailAddressRemovedMessage'));
            }
            else {
                getInstance().announce(loadTimeData.getString('addressRemovedMessage'));
            }
        }
        if (recordType) {
            this.recordDeletionMetrics_(wasDeletionConfirmed, recordType);
        }
        this.showAddressRemoveConfirmationDialog_ = false;
    }
    /**
     * Handles tapping on the "Remove" address button.
     */
    onMenuRemoveAddressClick_() {
        this.showAddressRemoveConfirmationDialog_ = true;
        this.$.addressSharedMenu.close();
    }
    /**
     * @return Whether the list exists and has items.
     */
    hasSome_(list) {
        return !!(list && list.length);
    }
    /**
     * Listens for the save-address event, and calls the private API.
     */
    saveAddress_(event) {
        this.autofillManager_.saveAddress(event.detail);
    }
    isAccountHomeAddress_(address) {
        return address.metadata?.recordType ===
            chrome.autofillPrivate.AddressRecordType.ACCOUNT_HOME;
    }
    isAccountWorkAddress_(address) {
        return address.metadata?.recordType ===
            chrome.autofillPrivate.AddressRecordType.ACCOUNT_WORK;
    }
    isAccountNameEmailAddress_(address) {
        return address.metadata?.recordType ===
            chrome.autofillPrivate.AddressRecordType.ACCOUNT_NAME_EMAIL;
    }
    computeIsGoogleProfileAddress_(address) {
        if (!address) {
            return false;
        }
        return this.isAccountHomeAddress_(address) ||
            this.isAccountWorkAddress_(address) ||
            this.isAccountNameEmailAddress_(address);
    }
    onAccountHomeAddressClick_() {
        OpenWindowProxyImpl.getInstance().openUrl(this.i18n('googleAccountHomeAddressUrl'));
    }
    onAccountWorkAddressClick_() {
        OpenWindowProxyImpl.getInstance().openUrl(this.i18n('googleAccountWorkAddressUrl'));
    }
    onAccountNameEmailAddressClick_() {
        OpenWindowProxyImpl.getInstance().openUrl(this.i18n('googleAccountNameEmailAddressEditUrl'));
    }
    isCloudOffVisible_(address, accountInfo) {
        if (address.metadata?.recordType ===
            chrome.autofillPrivate.AddressRecordType.ACCOUNT ||
            address.metadata?.recordType ===
                chrome.autofillPrivate.AddressRecordType.ACCOUNT_HOME ||
            address.metadata?.recordType ===
                chrome.autofillPrivate.AddressRecordType.ACCOUNT_WORK ||
            address.metadata?.recordType ===
                chrome.autofillPrivate.AddressRecordType.ACCOUNT_NAME_EMAIL) {
            return false;
        }
        if (!accountInfo) {
            return false;
        }
        if (accountInfo.isSyncEnabledForAutofillProfiles) {
            return false;
        }
        // Local profile of a logged-in user with disabled address sync and
        // enabled feature.
        return true;
    }
    /**
     * Determines if an icon is to be shown for the given address.
     */
    shouldShowAddressIcon_(address, accountInfo) {
        return this.getAddressIcon_(address, accountInfo).length > 0;
    }
    /**
     * Determines which icon to show for a given address.
     *
     * @return The icon string or an empty string.
     */
    getAddressIcon_(address, accountInfo) {
        if (loadTimeData.getBoolean('enableSupportForHomeAndWork')) {
            if (this.isAccountHomeAddress_(address)) {
                return 'settings20:home';
            }
            if (this.isAccountWorkAddress_(address)) {
                return 'settings20:work';
            }
        }
        if (this.isCloudOffVisible_(address, accountInfo)) {
            return 'cr20:cloud-off';
        }
        return '';
    }
    /**
     * Determines which a11y string to announce for a given address.
     *
     * @return The a11y string or an empty string.
     */
    getA11yLabelForIcon_(address, accountInfo) {
        if (this.isCloudOffVisible_(address, accountInfo)) {
            return this.i18n('localAddressIconA11yLabel');
        }
        if (this.isAccountHomeAddress_(address)) {
            return this.i18n('homeAddressIconA11yLabel');
        }
        if (this.isAccountWorkAddress_(address)) {
            return this.i18n('workAddressIconA11yLabel');
        }
        return '';
    }
    /**
     * @returns the title for the More Actions button corresponding to the address
     */
    moreActionsTitle_(address) {
        const label = address.metadata?.summaryLabel;
        const subLabel = address.metadata?.summarySublabel;
        const fullLabel = label + (subLabel ?? '');
        let messageKey;
        if (this.isAccountHomeAddress_(address)) {
            messageKey = 'moreOptionsForHomeAddress';
        }
        else if (this.isAccountWorkAddress_(address)) {
            messageKey = 'moreOptionsForWorkAddress';
        }
        else {
            messageKey = 'moreActionsForAddress';
        }
        return this.i18n(messageKey, fullLabel);
    }
    isAutofillSyncToggleVisible_(accountInfo) {
        return !!(accountInfo?.isAutofillSyncToggleAvailable);
    }
    getRecordTypeSuffix_(recordType) {
        switch (recordType) {
            case chrome.autofillPrivate.AddressRecordType.LOCAL_OR_SYNCABLE:
                return 'LocalOrSyncable';
            case chrome.autofillPrivate.AddressRecordType.ACCOUNT:
                return 'Account';
            case chrome.autofillPrivate.AddressRecordType.ACCOUNT_HOME:
                return 'AccountHome';
            case chrome.autofillPrivate.AddressRecordType.ACCOUNT_WORK:
                return 'AccountWork';
            case chrome.autofillPrivate.AddressRecordType.ACCOUNT_NAME_EMAIL:
                return 'AccountNameEmail';
            default:
                assertNotReached();
        }
    }
    recordDeletionMetrics_(wasDeletionConfirmed, recordType) {
        const suffix = this.getRecordTypeSuffix_(recordType);
        chrome.metricsPrivate.recordBoolean('Autofill.ProfileDeleted.Settings.Total', wasDeletionConfirmed);
        chrome.metricsPrivate.recordBoolean('Autofill.ProfileDeleted.Any.Total', wasDeletionConfirmed);
        chrome.metricsPrivate.recordBoolean('Autofill.ProfileDeleted.Settings.' + suffix, wasDeletionConfirmed);
        chrome.metricsPrivate.recordBoolean('Autofill.ProfileDeleted.Any.' + suffix, wasDeletionConfirmed);
    }
    /**
     * Triggered by settings-toggle-button#autofillSyncToggle. It passes
     * the toggle state to the native code. If the data changed the page
     * content will be refreshed automatically via `PersonalDataChangedListener`.
     */
    onAutofillSyncEnabledChange_() {
        assert(this.accountInfo_ && this.accountInfo_.isAutofillSyncToggleAvailable);
        this.autofillManager_.setAutofillSyncToggleEnabled(this.$.autofillSyncToggle.checked);
    }
    onAutofillProfileToggleChanged_() {
        const value = this.$.autofillProfileToggle.checked ?
            AutofillAddressOptInChange.OPT_IN :
            AutofillAddressOptInChange.OPT_OUT;
        chrome.metricsPrivate.recordEnumerationValue('Autofill.Address.IsEnabled.Change', value, AutofillAddressOptInChange.COUNT);
    }
    onPlusAddressClick_() {
        chrome.metricsPrivate.recordUserAction('Settings.ManageOptionOnSettingsSelected');
        OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString('plusAddressManagementUrl'));
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsAutofillSectionElement.is, SettingsAutofillSectionElement);

function getTemplate$2c() {
    return html `<!--_html_template_start_--><style include="settings-shared passwords-shared md-select action-link">cr-icon-button{--cr-icon-button-icon-size:16px;margin-inline-start:2px}#footnote{margin-inline-start:2px;margin-top:16px}cr-input{--cr-input-error-display:none}#websiteInput[invalid].has-error-message,#usernameInput{margin-top:var(--cr-form-field-bottom-spacing)}#usernameInput[invalid]{--cr-input-error-display:block;margin-top:var(--cr-form-field-bottom-spacing)}</style>

<cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title" id="title">$i18n{editPasskeyDialogTitle}</div>
  <div slot="body">
    <cr-input id="websiteInput" label="$i18n{editPasskeySiteLabel}"
        placeholder="[[relyingPartyId]]" readonly="true">
    </cr-input>
    <cr-input id="usernameInput" label="$i18n{editPasskeyUsernameLabel}"
        value="{{username}}" invalid="[[usernameInputInvalid_]]"
        error-message="[[usernameInputErrorMessage_]]">
    </cr-input>
    <div id="footnote">[[dialogFootnote_]]</div>
  </div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button" on-click="onCancel_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="actionButton" class="action-button"
        on-click="onSaveButtonClick_" disabled="[[usernameInputInvalid_]]">
      $i18n{save}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'passkey-edit-dialog' is the dialog that allows showing or
 * editing a passkey.
 */
const PasskeyEditDialogElementBase = I18nMixin(PolymerElement);
class PasskeyEditDialogElement extends PasskeyEditDialogElementBase {
    static get is() {
        return 'passkey-edit-dialog';
    }
    static get template() {
        return getTemplate$2c();
    }
    static get properties() {
        return {
            username: String,
            relyingPartyId: String,
            usernameInputErrorMessage_: String,
            dialogFootnote_: String,
            usernameInputInvalid_: {
                type: Boolean,
                computed: 'computeUsernameInputInvalid_(username)',
            },
        };
    }
    ready() {
        super.ready();
        this.dialogFootnote_ =
            this.i18n('passkeyEditDialogFootnote', this.relyingPartyId);
    }
    onSaveButtonClick_() {
        this.dispatchEvent(new CustomEvent('saved-passkey-edited', {
            bubbles: true,
            composed: true,
            detail: this.username,
        }));
        this.close();
    }
    computeUsernameInputInvalid_() {
        if (this.username.length === 0) {
            this.usernameInputErrorMessage_ = this.i18n('passkeyLengthError');
            return true;
        }
        return false;
    }
    onCancel_() {
        this.$.dialog.cancel();
    }
    close() {
        this.$.dialog.close();
    }
}
customElements.define(PasskeyEditDialogElement.is, PasskeyEditDialogElement);

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PasskeysBrowserProxyImpl {
    hasPasskeys() {
        return sendWithPromise('passkeysHasPasskeys');
    }
    enumerate() {
        return sendWithPromise('passkeysEnumerate');
    }
    delete(credentialId) {
        return sendWithPromise('passkeysDelete', credentialId);
    }
    edit(credentialId, newUsername) {
        return sendWithPromise('passkeysEdit', credentialId, newUsername);
    }
    static getInstance() {
        return passkeysProxyInstance ||
            (passkeysProxyInstance = new PasskeysBrowserProxyImpl());
    }
    static setInstance(obj) {
        passkeysProxyInstance = obj;
    }
}
let passkeysProxyInstance = null;

function getTemplate$2b() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared passwords-shared">#passkeys-list-header{padding-inline-end:calc(var(--cr-icon-ripple-size) + var(--cr-icon-button-margin-start))}#iconContainer{height:24px;line-height:100%;margin-inline-end:20px;padding:4px;width:24px}</style>

<settings-subpage page-title="$i18n{managePasskeysTitle}"
    search-label="$i18n{managePasskeysSearch}"
    search-term="{{filter_}}">
<template is="dom-if" if="[[noManagement_]]">
  <div id="error" class="cr-row first">
    <div id="iconContainer">
      <cr-icon icon="cr:info"></cr-icon>
    </div>
    <p>$i18n{managePasskeysNoSupport}</p>
  </div>
</template>

<div class="cr-row first cr-secondary-text">
  $i18n{managePasskeysSubTitle}
</div>

<div class="list-frame">
  <div id="passkeys-list-header"
       class="list-item column-header right-pad"
       aria-hidden="true">
    <div class="website-column">$i18n{editPasskeySiteLabel}</div>
    <div class="username-column">$i18n{editPasskeyUsernameLabel}</div>
  </div>
  <div class="cr-separators list-with-header">
    <template is="dom-repeat" items="[[passkeys_]]"
        filter="[[filterFunction_(filter_)]]">
      <div class="list-item" focus-row-container>
        <div class="website-column no-min-width">
          <site-favicon url="[[getIconUrl_(item)]]"></site-favicon>
          <span class="text-elide elide-left">[[item.relyingPartyId]]</span>
        </div>

        <div id="username" class="username-column no-min-width text-elide">
          [[item.userName]]
        </div>

         <cr-icon-button id="moreActionsButton" class="icon-more-vert"
            data-credential-id$="[[item.credentialId]]"
            on-click="onDotsClick_" title="[[getMoreActionsLabel_(item)]]"
            focus-row-control focus-type="moreActionsButton"></cr-icon-button>
      </div>
    </template>
  </div>
</div>

<cr-action-menu id="menu" role-description="$i18n{menu}">
  
    <button class="dropdown-item" on-click="onEditClick_" id="edit">
      $i18n{edit}
    </button>
  
  <button class="dropdown-item" on-click="onDeleteClick_" id="delete">
    $i18n{delete}
  </button>
</cr-action-menu>

<cr-lazy-render id="deleteErrorDialog">
  <template>
    <cr-dialog close-text="$i18n{close}">
      <div slot="title">$i18n{managePasskeysCannotDeleteTitle}</div>
      <div slot="body">$i18n{managePasskeysCannotDeleteBody}</div>
      <div slot="button-container">
        <cr-button class="action-button" on-click="onErrorDialogOkClick_">
          $i18n{ok}
        </cr-button>
      </div>
    </cr-dialog>
  </template>
</cr-lazy-render>

<template is="dom-if" if="[[showDeleteConfirmationDialog_]]" restamp>
  <settings-simple-confirmation-dialog id="deleteConfirmDialog"
      title-text="$i18n{managePasskeysDeleteConfirmationTitle}"
      body-text="$i18n{managePasskeysDeleteConfirmationDescription}"
      confirm-text="$i18n{delete}" no-primary-button
      on-close="onConfirmDialogClose_">
  </settings-simple-confirmation-dialog>
</template>

  <template is="dom-if" if="[[showEditDialog_]]" restamp>
    <passkey-edit-dialog id="editPasskeyDialog" existing-entry="[[credential]]"
        on-saved-passkey-edited="onSavedPasskeyEdited_"
        relying-party-id="[[relyingPartyId_]]" username="[[username_]]"
        on-close="onEditDialogClose_">
    </passkey-edit-dialog>
  </template>

</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A settings subpage that allows the user to see and manage the
    passkeys on their computer.
 */
const SettingsPasskeysSubpageElementBase = SettingsViewMixin(PolymerElement);
class SettingsPasskeysSubpageElement extends SettingsPasskeysSubpageElementBase {
    static get is() {
        return 'settings-passkeys-subpage';
    }
    static get template() {
        return getTemplate$2b();
    }
    static get properties() {
        return {
            /** Substring to filter the passkeys by. */
            filter_: {
                type: String,
                value: '',
            },
            passkeys_: Array,
            showDeleteConfirmationDialog_: Boolean,
            noManagement_: Boolean,
            // 
            showEditDialog_: Boolean,
            username_: String,
            relyingPartyId_: String,
            // 
        };
    }
    // Contains the credentialId of the passkey that the action menu was opened
    // for.
    credentialIdForActionMenu_;
    browserProxy_ = PasskeysBrowserProxyImpl.getInstance();
    ready() {
        super.ready();
        this.browserProxy_.enumerate().then(this.onEnumerateComplete_.bind(this));
    }
    /**
     * Used to filter the displayed passkeys when search text is entered.
     */
    filterFunction_() {
        return passkey => [passkey.relyingPartyId, passkey.userName].some(str => str.toLowerCase().includes(this.filter_.trim().toLowerCase()));
    }
    /**
     * Called when the browser has a new list of passkeys.
     */
    onEnumerateComplete_(passkeys) {
        if (passkeys === null) {
            this.noManagement_ = true;
            this.passkeys_ = [];
            return;
        }
        // `passkeys` will have been sorted already because it's easier to do a
        // Public Suffix List-based sort in C++.
        this.passkeys_ = passkeys;
    }
    getIconUrl_(passkey) {
        // `passkey.relyingPartyId` comes from the OS and hopefully can be trusted,
        // but don't let bad data form an unexpected URL. Thus drop any passkeys
        // with characters in the RP ID that are meaningful in a host per
        // https://datatracker.ietf.org/doc/html/rfc1738#section-3.1
        if (['@', ':', '/'].every(c => passkey.relyingPartyId.indexOf(c) === -1)) {
            return 'https://' + passkey.relyingPartyId + '/';
        }
        return '';
    }
    /**
     * Called when the user clicks on the three-dots icon for a passkey.
     */
    onDotsClick_(e) {
        this.credentialIdForActionMenu_ =
            e.target.dataset['credentialId'];
        this.$.menu.showAt(e.target, {
            anchorAlignmentY: AnchorAlignment.AFTER_END,
        });
        // 
        const existingEntry = this.passkeys_.find(entry => {
            return entry.credentialId === this.credentialIdForActionMenu_;
        });
        this.username_ = existingEntry.userName;
        this.relyingPartyId_ = existingEntry.relyingPartyId;
        // 
    }
    /**
     * Called when the user clicks to delete a passkey.
     */
    onDeleteClick_() {
        assert(this.credentialIdForActionMenu_);
        this.$.menu.close();
        this.showDeleteConfirmationDialog_ = true;
    }
    /**
     * Called when a delete confirmation dialog is closed (whether successful or
     * not).
     */
    onConfirmDialogClose_() {
        const dialog = this.shadowRoot.querySelector('settings-simple-confirmation-dialog');
        assert(dialog);
        const confirmed = dialog.wasConfirmed();
        this.showDeleteConfirmationDialog_ = false;
        if (confirmed) {
            assert(this.credentialIdForActionMenu_);
            this.browserProxy_.delete(this.credentialIdForActionMenu_)
                .then(this.onDeleteComplete_.bind(this, this.credentialIdForActionMenu_));
        }
        this.credentialIdForActionMenu_ = null;
    }
    /**
     * Called when a delete operation has completed.
     */
    onDeleteComplete_(deletedCredentialId, newPasskeys) {
        if (newPasskeys !== null &&
            newPasskeys.findIndex((cred) => cred.credentialId === deletedCredentialId) !== -1) {
            // The passkey is still present thus the deletion failed.
            this.$.deleteErrorDialog.get().showModal();
        }
        this.onEnumerateComplete_(newPasskeys);
    }
    /**
     * Called when the user clicks the "ok" button on the error dialog.
     */
    onErrorDialogOkClick_() {
        this.$.deleteErrorDialog.get().close();
    }
    /**
     * Returns the a11y label for the "More actions" button next to a passkey.
     */
    getMoreActionsLabel_(passkey) {
        return loadTimeData.getStringF('managePasskeysMoreActionsLabel', passkey.userName, passkey.relyingPartyId);
    }
    // 
    onEditClick_() {
        this.shadowRoot.querySelector('cr-action-menu').close();
        this.showEditDialog_ = true;
    }
    onEditDialogClose_() {
        this.showEditDialog_ = false;
    }
    /**
     * Called when an edit operation has completed.
     */
    onEditComplete_(newPasskeys) {
        this.onEnumerateComplete_(newPasskeys);
    }
    /**
     * Called when the user clicks save in the passkey edit dialog.
     */
    onSavedPasskeyEdited_(event) {
        assert(this.credentialIdForActionMenu_);
        this.browserProxy_.edit(this.credentialIdForActionMenu_, event.detail)
            .then(this.onEditComplete_.bind(this));
    }
    // 
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsPasskeysSubpageElement.is, SettingsPasskeysSubpageElement);

function getTemplate$2a() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared md-select">cr-input{--cr-input-error-display:block;margin-bottom:0;width:var(--cr-default-input-max-width)}.md-select+.md-select{margin-inline-start:8px}#numberInput{margin-bottom:10px}#month{width:70px}#cvcInput{width:132px}#cvcImage{margin-inline-start:10px}#saved-to-this-device-only-label{margin-bottom:10px;margin-top:0}#year{width:100px}#nicknameInput{--cr-input-width:var(--cr-default-input-max-width);width:fit-content}#charCount{font-size:var(--cr-form-field-label-font-size);line-height:var(--cr-form-field-label-line-height);padding-inline-start:8px}#nicknameInput:not(:focus-within) #charCount{display:none}#expiredError{display:block;font-size:var(--cr-form-field-label-font-size);height:var(--cr-form-field-label-height);line-height:var(--cr-form-field-label-line-height);margin:8px 0;visibility:hidden}:host([expired_]) #expiredError{visibility:visible}#expiredError,:host([expired_]) #expiration{color:var(--google-red-600)}@media (prefers-color-scheme:dark){#expiredError,:host([expired_]) #expiration{color:var(--google-red-300)}}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div slot="title">[[title_]]</div>
      <div slot="body">
        <cr-input id="numberInput" label="$i18n{creditCardNumber}"
            on-blur="onNumberInputBlurred_"
            invalid="[[showErrorForCardNumber_(cardNumberValidationState_)]]"
            error-message="$i18n{creditCardNumberInvalid}"
            value="{{rawCardNumber_}}" autofocus>
        </cr-input>
        <!-- aria-hidden for creditCardExpiration label since
          creditCardExpirationMonth and creditCardExpirationYear provide
          sufficient labeling. -->
        <label id='expiration' class="cr-form-field-label" aria-hidden="true">
          $i18n{creditCardExpiration}
        </label>
        <select class="md-select" id="month" value="[[expirationMonth_]]"
            on-change="onMonthChange_"
            aria-label="$i18n{creditCardExpirationMonth}"
            aria-invalid$="[[getExpirationAriaInvalid_(expired_)]]">
          <template is="dom-repeat" items="[[monthList_]]">
            <option>[[item]]</option>
          </template>
        </select>
        <select class="md-select" id="year" value="[[expirationYear_]]"
            on-change="onYearChange_"
            aria-label="$i18n{creditCardExpirationYear}"
            aria-invalid$="[[getExpirationAriaInvalid_(expired_)]]">
          <template is="dom-repeat" items="[[yearList_]]">
            <option>[[item]]</option>
          </template>
        </select>
        <div id="expiredError">$i18n{creditCardExpired}</div>
        <template is="dom-if"
            if="[[checkIfCvcStorageIsAvailable_(
                  prefs.autofill.payment_cvc_storage.value,
                  cvcStorageAvailable_)]]">
          <cr-input id="cvcInput" label="$i18n{creditCardCvcInputTitle}"
              placeholder="$i18n{creditCardCvcInputPlaceholder}"
              value="{{cvc_}}">
            <img slot="suffix" id="cvcImage"
                src="[[getCvcImageSource_(sanitizedCardNumber_)]]"
                title="[[getCvcImageTooltip_(sanitizedCardNumber_)]]">
            </img>
          </cr-input>
        </template>
        <!-- Place cardholder name field and nickname field after CVC input.-->
        <cr-input id="nameInput" label="$i18n{creditCardName}"
            value="{{name_}}" spellcheck="false">
        </cr-input>
        <cr-input id="nicknameInput" label="$i18n{creditCardNickname}"
            value="{{nickname_}}" spellcheck="false" maxlength="25"
            on-input="validateNickname_"
            invalid="[[nicknameInvalid_]]"
            error-message="$i18n{creditCardNicknameInvalid}"
            aria-description="[[i18n('inputMaxLengthDescription', 25)]]">
            <div id="charCount" slot="suffix" aria-hidden="true">
              [[computeNicknameCharCount_(nickname_)]]/25
            </div>
        </cr-input>
        <div id="saved-to-this-device-only-label">
          $i18n{savedToThisDeviceOnly}
        </div>
      </div>
      <div slot="button-container">
        <cr-button id="cancelButton" class="cancel-button"
            on-click="onCancelButtonClick_">$i18n{cancel}</cr-button>
        <cr-button id="saveButton" class="action-button"
            on-click="onSaveButtonClick_"
            disabled="[[!saveEnabled_(nicknameInvalid_, cardNumberValidationState_,
                expired_, name_, sanitizedCardNumber_, nickname_)]]">
          $i18n{save}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-credit-card-edit-dialog' is the dialog that allows
 * editing or creating a credit card entry.
 */
/**
 * Regular expression for invalid nickname. Nickname containing any digits will
 * be treated as invalid.
 */
const NICKNAME_INVALID_REGEX = new RegExp('.*\\d+.*');
/**
 * Enum of possible states for the credit card number. A card number is valid
 * if it is of a supported length and passes a Luhn check. Otherwise, it is
 * invalid and we may show an error to the user in cases where we are certain
 * they have entered an invalid card (i.e. vs still typing).
 */
var CardNumberValidationState;
(function (CardNumberValidationState) {
    CardNumberValidationState["VALID"] = "valid";
    CardNumberValidationState["INVALID_NO_ERROR"] = "invalid-no-error";
    CardNumberValidationState["INVALID_WITH_ERROR"] = "invalid-with-error";
})(CardNumberValidationState || (CardNumberValidationState = {}));
const SettingsCreditCardEditDialogElementBase = I18nMixin(PolymerElement);
class SettingsCreditCardEditDialogElement extends SettingsCreditCardEditDialogElementBase {
    static get is() {
        return 'settings-credit-card-edit-dialog';
    }
    static get template() {
        return getTemplate$2a();
    }
    static get properties() {
        return {
            /**
             * User preferences state.
             */
            prefs: Object,
            /**
             * The underlying credit card object for the dialog. After initialization
             * of the dialog, this object is only modified once the 'Save' button is
             * clicked.
             */
            creditCard: Object,
            /**
             * The actual title that's used for this dialog. Will be context sensitive
             * based on if |creditCard| is being created or edited.
             */
            title_: String,
            /**
             * The list of months to show in the dropdown.
             */
            monthList_: {
                type: Array,
                value: [
                    '01',
                    '02',
                    '03',
                    '04',
                    '05',
                    '06',
                    '07',
                    '08',
                    '09',
                    '10',
                    '11',
                    '12',
                ],
            },
            /** The list of years to show in the dropdown. */
            yearList_: Array,
            /**
             * Backing data for inputs in the dialog, each bound to the corresponding
             * HTML elements.
             *
             * Note that rawCardNumber_ is unsanitized; code should instead use
             * `sanitizedCardNumber_`.
             */
            name_: String,
            rawCardNumber_: String,
            cvc_: String,
            nickname_: String,
            expirationYear_: String,
            expirationMonth_: String,
            /**
             * A sanitized version of `rawCardNumber_` that strips out commonly used
             * separators and trims whitespace.
             */
            sanitizedCardNumber_: {
                type: String,
                computed: 'sanitizeCardNumber_(rawCardNumber_)',
                observer: 'onSanitizedCardNumberChanged_',
            },
            /** Whether the current nickname input is invalid. */
            nicknameInvalid_: {
                type: Boolean,
                value: false,
            },
            /** Whether the current card number field is invalid. */
            cardNumberValidationState_: {
                type: CardNumberValidationState,
                value: false,
            },
            /**
             * Computed property that tracks if the entered credit card is expired -
             * that is, if its expiration month and year are in the past.
             */
            expired_: {
                type: Boolean,
                computed: 'computeExpired_(expirationMonth_, expirationYear_)',
                reflectToAttribute: true,
                observer: 'onExpiredChanged_',
            },
            /**
             * Checks if CVC storage is available based on the feature flag.
             */
            cvcStorageAvailable_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('cvcStorageAvailable');
                },
            },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.title_ = this.i18n(this.creditCard.guid ? 'editCreditCardTitle' : 'addCreditCardTitle');
        // Add a leading '0' if a month is 1 char.
        if (this.creditCard.expirationMonth.length === 1) {
            this.creditCard.expirationMonth = '0' + this.creditCard.expirationMonth;
        }
        const date = new Date();
        let firstYear = date.getFullYear();
        let lastYear = firstYear + 19; // Show next 19 years (20 total).
        let selectedYear = parseInt(this.creditCard.expirationYear, 10);
        // |selectedYear| must be valid and between first and last years.
        if (!selectedYear) {
            selectedYear = firstYear;
        }
        else if (selectedYear < firstYear) {
            firstYear = selectedYear;
        }
        else if (selectedYear > lastYear) {
            lastYear = selectedYear;
        }
        const yearList = [];
        for (let i = firstYear; i <= lastYear; ++i) {
            yearList.push(i.toString());
        }
        this.yearList_ = yearList;
        microTask.run(() => {
            this.expirationYear_ = selectedYear.toString();
            this.expirationMonth_ = this.creditCard.expirationMonth;
            this.cvc_ = this.creditCard.cvc;
            this.name_ = this.creditCard.name;
            this.rawCardNumber_ = this.creditCard.cardNumber || '';
            this.nickname_ = this.creditCard.nickname;
            this.$.dialog.showModal();
        });
    }
    /** Closes the dialog. */
    close() {
        this.$.dialog.close();
    }
    /**
     * Handler for tapping the 'cancel' button. Should just dismiss the dialog.
     */
    onCancelButtonClick_() {
        this.$.dialog.cancel();
    }
    /**
     * Handler for tapping the save button.
     */
    onSaveButtonClick_() {
        if (!this.saveEnabled_()) {
            return;
        }
        this.creditCard.expirationYear = this.expirationYear_;
        this.creditCard.expirationMonth = this.expirationMonth_;
        this.creditCard.name = this.name_;
        this.creditCard.cardNumber = this.sanitizedCardNumber_;
        this.creditCard.nickname = this.nickname_;
        // Take the user entered CVC input as-is. This is due to PCI compliance.
        this.creditCard.cvc = this.cvc_;
        this.trimCreditCard_();
        this.dispatchEvent(new CustomEvent('save-credit-card', { bubbles: true, composed: true, detail: this.creditCard }));
        this.close();
    }
    onSanitizedCardNumberChanged_() {
        this.cardNumberValidationState_ = this.computeCardNumberValidationState_(this.sanitizedCardNumber_, /*isBlur=*/ false);
    }
    onNumberInputBlurred_(event) {
        assert(event.type === 'blur');
        this.cardNumberValidationState_ = this.computeCardNumberValidationState_(this.sanitizedCardNumber_, /*isBlur=*/ true);
    }
    showErrorForCardNumber_(cardNumberValidationState) {
        return cardNumberValidationState ===
            CardNumberValidationState.INVALID_WITH_ERROR;
    }
    onMonthChange_() {
        this.expirationMonth_ = this.monthList_[this.$.month.selectedIndex];
    }
    onYearChange_() {
        this.expirationYear_ = this.yearList_[this.$.year.selectedIndex];
    }
    /**
     * Handles a11y error announcement the same way as in cr-input.
     */
    onExpiredChanged_() {
        const errorElement = this.$.expiredError;
        const ERROR_ID = errorElement.id;
        // Readding attributes is needed for consistent announcement by VoiceOver
        if (this.expired_) {
            errorElement.setAttribute('role', 'alert');
            this.shadowRoot.querySelector(`#month`).setAttribute('aria-errormessage', ERROR_ID);
            this.shadowRoot.querySelector(`#year`).setAttribute('aria-errormessage', ERROR_ID);
        }
        else {
            errorElement.removeAttribute('role');
            this.shadowRoot.querySelector(`#month`).removeAttribute('aria-errormessage');
            this.shadowRoot.querySelector(`#year`).removeAttribute('aria-errormessage');
        }
    }
    /**
     * @return 'true' or 'false' for the aria-invalid attribute
     *     of expiration selectors.
     */
    getExpirationAriaInvalid_() {
        return this.expired_ ? 'true' : 'false';
    }
    checkIfCvcStorageIsAvailable_(cvcStorageToggleEnabled) {
        return this.cvcStorageAvailable_ && cvcStorageToggleEnabled;
    }
    getCvcImageSource_() {
        // An icon is shown to the user to help them look for their CVC.
        // The location differs for AmEx and non-AmEx cards, so we have to get
        // the first two digits of the card number for AmEx cards before we can
        // update the icon.
        return this.isCardAmex_() ? 'chrome://settings/images/cvc_amex.svg' :
            'chrome://settings/images/cvc.svg';
    }
    getCvcImageTooltip_() {
        // An icon is shown to the user to help them look for their CVC.
        // The location differs for AmEx and non-AmEx cards, so we have to get
        // the first two digits of the card number for AmEx cards before we can
        // update the icon.
        return this.i18n(this.isCardAmex_() ? 'creditCardCvcAmexImageTitle' :
            'creditCardCvcImageTitle');
    }
    /**
     * Validate no digits are used in nickname. Display error message and disable
     * the save button when invalid.
     */
    validateNickname_() {
        this.nicknameInvalid_ = NICKNAME_INVALID_REGEX.test(this.nickname_);
    }
    /**
     * @param  nickname of the card, undefined when not set.
     * @return nickname character length.
     */
    computeNicknameCharCount_(nickname) {
        return (nickname || '').length;
    }
    saveEnabled_() {
        if (this.cardNumberValidationState_ !== CardNumberValidationState.VALID) {
            return false;
        }
        return !this.expired_ && !this.nicknameInvalid_;
    }
    /**
     * @return True iff the provided expiration date is passed.
     */
    computeExpired_() {
        if (this.expirationYear_ === undefined ||
            this.expirationMonth_ === undefined) {
            return false;
        }
        const now = new Date();
        // Convert string (e.g. '06') to number (e.g. 6) for comparison.
        const expirationYear = parseInt(this.expirationYear_, 10);
        const expirationMonth = parseInt(this.expirationMonth_, 10);
        return (expirationYear < now.getFullYear() ||
            (expirationYear === now.getFullYear() &&
                expirationMonth <= now.getMonth()));
    }
    /**
     * Trim credit card's name, cardNumber and nickname if exist.
     */
    trimCreditCard_() {
        if (this.creditCard.name) {
            this.creditCard.name = this.creditCard.name.trim();
        }
        if (this.creditCard.cardNumber) {
            this.creditCard.cardNumber = this.creditCard.cardNumber.trim();
        }
        if (this.creditCard.nickname) {
            this.creditCard.nickname = this.creditCard.nickname.trim();
        }
    }
    isCardAmex_() {
        const cardNumber = this.sanitizedCardNumber_;
        return !!cardNumber && cardNumber.length >= 2 &&
            !!cardNumber.match('^(34|37)');
    }
    /**
     * Sanitize the raw card number entered by the user, trimming whitespace and
     * removing commonly used separators.
     */
    sanitizeCardNumber_(cardNumber) {
        return cardNumber ? cardNumber.trim().replaceAll(/ |-/g, '') : '';
    }
    /**
     * Compute whether or not the provided card number is valid, i.e. that it is a
     * number and passes a Luhn check. If the card number isn't complete yet, it
     * is still considered invalid but no error will be shown.
     */
    computeCardNumberValidationState_(sanitizedCardNumber, isBlur = false) {
        // The card number field must only contain digits.
        if (/[^\d]/.test(sanitizedCardNumber)) {
            return CardNumberValidationState.INVALID_WITH_ERROR;
        }
        // A credit card number is only valid if it passes a Luhn check. We do not
        // want to show an 'invalid card' error to users if they have not yet
        // finished typing the card number, but unfortunately different credit cards
        // can have different card number lengths.
        //
        // In order to minimize false-positive errors, we implement the following
        // algorithm:
        //
        //   1. If the user enters < 12 digits (the minimum supported card
        //      number length) then no error will be shown but the Save button will
        //      not be enabled.
        //   2. If the user enters < 16 digits (the most common card number
        //      length) and the number fails a Luhn check, then no error will be
        //      shown but the Save button will not be enabled.
        //   3. If the user enters >= 16 digits and the number fails a Luhn check,
        //      then an error will be shown and the Save button will not be enabled.
        //   4. If the user enters > 19 digits (the maximum supported card number
        //      length) then an error will be shown and the Save button will not be
        //      enabled.
        //   5. If the user changes focus to another field and the number of digits
        //      is outside the allowed lengths or the card number fails a Luhn
        //      check, then an error will be shown and the Save button will not be
        //      enabled.
        //
        // The cases are handled in reverse for simplicity of code.
        // Case (5) - the user has switched focus to another element.
        if (isBlur) {
            return (sanitizedCardNumber.length >= 12 &&
                sanitizedCardNumber.length <= 19 &&
                this.passesLuhnCheck_(sanitizedCardNumber)) ?
                CardNumberValidationState.VALID :
                CardNumberValidationState.INVALID_WITH_ERROR;
        }
        // Case (4) - the user entered a card number that is too long.
        if (sanitizedCardNumber.length > 19) {
            return CardNumberValidationState.INVALID_WITH_ERROR;
        }
        // Case (3) - the user has entered at least 16 digits.
        if (sanitizedCardNumber.length >= 16) {
            return this.passesLuhnCheck_(sanitizedCardNumber) ?
                CardNumberValidationState.VALID :
                CardNumberValidationState.INVALID_WITH_ERROR;
        }
        // Case (2) - the user has entered at least 12 digits.
        if (sanitizedCardNumber.length >= 12) {
            return this.passesLuhnCheck_(sanitizedCardNumber) ?
                CardNumberValidationState.VALID :
                CardNumberValidationState.INVALID_NO_ERROR;
        }
        // Case (1) - the user has entered less than 12 digits.
        return CardNumberValidationState.INVALID_NO_ERROR;
    }
    /**
     * Validates if a given card number passes a Luhn check.
     *
     * http://en.wikipedia.org/wiki/Luhn_algorithm
     */
    passesLuhnCheck_(cardNumber) {
        let sum = 0;
        let odd = false;
        const cardNumberDigits = cardNumber.split('').reverse();
        for (const digit of cardNumberDigits) {
            let intDigit = Number(digit);
            if (Number.isNaN(intDigit)) {
                return false;
            }
            if (odd) {
                intDigit *= 2;
                sum += Math.floor(intDigit / 10) + (intDigit % 10);
            }
            else {
                sum += intDigit;
            }
            odd = !odd;
        }
        return (sum % 10) === 0;
    }
}
customElements.define(SettingsCreditCardEditDialogElement.is, SettingsCreditCardEditDialogElement);

function getTemplate$29() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">cr-input{--cr-input-error-display:block;margin-bottom:0;width:var(--cr-default-input-max-width)}div[slot='button-container']{padding-top:0}#saved-to-this-device-only-label{margin-bottom:26px;margin-top:0}#charCount{font-size:var(--cr-form-field-label-font-size);line-height:var(--cr-form-field-label-line-height);padding-inline-start:8px}#nicknameInput:not(:focus-within) #charCount{--cr-input-width:var(--cr-default-input-max-width);display:none;width:fit-content}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">[[title_]]</div>
  <div slot="body">
    <cr-input id="valueInput" label="$i18n{addPaymentMethodIban}"
        on-blur="onIbanInputBlurred_"
        invalid="[[showErrorForIban_(ibanValidationState_)]]"
        error-message="$i18n{ibanInvalid}"
        value="{{value_}}" autofocus>
    </cr-input>
    <cr-input id="nicknameInput" label="$i18n{ibanNickname}"
        value="{{nickname_}}" spellcheck="false" maxlength="25"
        aria-description="[[i18n('inputMaxLengthDescription', 25)]]">
      <div id="charCount" slot="suffix">
        [[computeNicknameCharCount_(nickname_)]]/25
      </div>
    </cr-input>
    <div id="saved-to-this-device-only-label">
      $i18n{ibanSavedToThisDeviceOnly}
    </div>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton" class="cancel-button"
        on-click="onCancelButtonClick_">$i18n{cancel}</cr-button>
    <cr-button id="saveButton" class="action-button"
        on-click="onIbanSaveButtonClick_">
      $i18n{save}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-iban-edit-dialog' is the dialog that allows
 * editing or creating an IBAN entry.
 */
/**
 * Enum of possible states for the iban. An iban is valid if it has the correct
 * structure, matches the length for its country code, and passes a checksum.
 * Otherwise, it is invalid and we may show an error to the user in cases where
 * we are certain they have entered an invalid iban (i.e. vs still typing).
 */
var IbanValidationState;
(function (IbanValidationState) {
    IbanValidationState["VALID"] = "valid";
    IbanValidationState["INVALID_NO_ERROR"] = "invalid-no-error";
    IbanValidationState["INVALID_WITH_ERROR"] = "invalid-with-error";
})(IbanValidationState || (IbanValidationState = {}));
const SettingsIbanEditDialogElementBase = I18nMixin(PolymerElement);
class SettingsIbanEditDialogElement extends SettingsIbanEditDialogElementBase {
    static get is() {
        return 'settings-iban-edit-dialog';
    }
    static get template() {
        return getTemplate$29();
    }
    static get properties() {
        return {
            /**
             * The IBAN being added or edited. Null means add a new IBAN, otherwise,
             * edit the existing IBAN.
             */
            iban: {
                type: Object,
                value: null,
            },
            /**
             * The actual title that's used for this dialog. Will be context sensitive
             * based on which type of IBAN method is being viewed, and if it is being
             * created or edited.
             */
            title_: String,
            /**
             * Backing data for inputs in the dialog, each bound to the corresponding
             * HTML elements.
             *
             * Note that value_ is unsanitized; code should instead use
             * `sanitizedIban_`.
             */
            value_: String,
            nickname_: String,
            /**
             * A sanitized version of `value_` with whitespace trimmed.
             */
            sanitizedIban_: {
                type: String,
                computed: 'sanitizeIban_(value_)',
                observer: 'onSanitizedIbanChanged_',
            },
            /** Whether the current iban field is invalid. */
            ibanValidationState_: {
                type: IbanValidationState,
                value: false,
            },
        };
    }
    paymentsManager_ = PaymentsManagerImpl.getInstance();
    connectedCallback() {
        super.connectedCallback();
        if (this.iban) {
            // Save IBAN button is by default enabled in 'EDIT' mode as IBAN value is
            // pre-populated.
            this.value_ = this.iban.value;
            this.nickname_ = this.iban.nickname;
            this.title_ = this.i18n('editIbanTitle');
        }
        else {
            this.title_ = this.i18n('addIbanTitle');
            // Save IBAN button is disabled in 'ADD' mode as IBAN value is empty.
            this.$.saveButton.disabled = true;
        }
        this.$.dialog.showModal();
    }
    /** Closes the dialog. */
    close() {
        this.$.dialog.close();
    }
    /**
     * Handler for clicking the 'cancel' button. Should just dismiss the dialog.
     */
    onCancelButtonClick_() {
        this.$.dialog.cancel();
    }
    /**
     * Handler for clicking the save button.
     */
    onIbanSaveButtonClick_() {
        const iban = {
            guid: this.iban?.guid,
            value: this.sanitizedIban_,
            nickname: this.nickname_ ? this.nickname_.trim() : '',
        };
        this.dispatchEvent(new CustomEvent('save-iban', { bubbles: true, composed: true, detail: iban }));
        this.close();
    }
    async onSanitizedIbanChanged_() {
        this.ibanValidationState_ =
            await this.computeIbanValidationState_(/*isBlur=*/ false);
        this.$.saveButton.disabled =
            this.ibanValidationState_ !== IbanValidationState.VALID;
    }
    async onIbanInputBlurred_(event) {
        assert(event.type === 'blur');
        this.ibanValidationState_ =
            await this.computeIbanValidationState_(/*isBlur=*/ true);
    }
    showErrorForIban_(ibanValidationState) {
        return ibanValidationState === IbanValidationState.INVALID_WITH_ERROR;
    }
    sanitizeIban_(value) {
        return value ? value.replace(/\s/g, '') : '';
    }
    async computeIbanValidationState_(isBlur) {
        const isValid = await this.isValidIban();
        if (isValid) {
            return IbanValidationState.VALID;
        }
        // We do not want to show an 'invalid iban' error to users if they have not
        // yet finished typing the iban, but unfortunately different countries can
        // have different iban lengths so we do not know when the user might be
        // finished.
        //
        // In order to minimize false-positive errors, we only show an error if the
        // user has entered at least 24 characters (the average IBAN length), or if
        // they unfocus the IBAN input (which implies they are finished entering
        // their IBAN).
        return (this.sanitizedIban_.length >= 24 || isBlur) ?
            IbanValidationState.INVALID_WITH_ERROR :
            IbanValidationState.INVALID_NO_ERROR;
    }
    async isValidIban() {
        if (!this.sanitizedIban_) {
            return false;
        }
        return this.paymentsManager_.isValidIban(this.sanitizedIban_);
    }
    /**
     * @param  nickname of the IBAN, undefined when not set.
     * @return nickname character length.
     */
    computeNicknameCharCount_() {
        return (this.nickname_ || '').length;
    }
}
customElements.define(SettingsIbanEditDialogElement.is, SettingsIbanEditDialogElement);

const styleMod$4 = document.createElement('dom-module');
styleMod$4.appendChild(html `
  <template>
    <style>
.screen-reader-only{clip-path:inset(100%);position:fixed}.screen-reader-only-host-node{position:relative}.screen-reader-only-host-node .screen-reader-only{height:100%;overflow:hidden;position:absolute;width:100%}
    </style>
  </template>
`.content);
styleMod$4.register('screen-reader-only');

function getTemplate$28() {
    return html `<!--_html_template_start_-->    <style include="settings-shared passwords-shared screen-reader-only">.expiration-column,.misc-column{align-items:center;display:flex}.misc-column{justify-content:flex-end}.list-item{margin-bottom:8px;margin-top:8px}.sub-label{color:var(--cr-secondary-text-color)}#paymentsIcon{vertical-align:middle}#cardImage{margin-inline-end:16px;vertical-align:middle}
    </style>
    <div class="list-item" role="row">
      <div class="type-column" role="cell">
        <img id="cardImage" srcset="[[getCardImage_(creditCard.imageSrc)]]" alt="">
        <div class="summary-column screen-reader-only-host-node">
          <div class="screen-reader-only">
            [[getCardIdentifierAriaLabel_(creditCard)]],
            [[getSummaryAriaLabel_(creditCard)]],
            [[getSummaryAriaSublabel_(creditCard)]]
          </div>
          <template is="dom-if" if="[[!shouldShowNewFopDisplay_()]]">
            <div id="summaryLabel" class="ellipses" aria-hidden="true">
              [[creditCard.metadata.summaryLabel]]
            </div>
          </template>
          <template is="dom-if" if="[[shouldShowNewFopDisplay_()]]">
            <div>
              <span id="label" class="ellipses" aria-hidden="true">
                [[creditCard.metadata.summaryLabel]]
              </span>
              <template is="dom-if" if="[[hasCardIdentifier_(creditCard)]]">
                <div class="sub-label" aria-hidden="true">
                  <span id="summaryLabel_1">
                    [[creditCard.metadata.summarySublabel]]
                  </span>
                  <span id="summaryLabel_2">
                    [[getExpirationlabel_(creditCard)]]
                  </span>
                </div>
              </template>
              <template is="dom-if" if="[[!hasCardIdentifier_(creditCard)]]">
                <span id="expirationLabel" class="sub-label">
                  [[getExpirationlabel_(creditCard)]]
                </span>
              </template>
            </div>
          </template>
          <div id="summarySublabel" class="sub-label">
            <span aria-hidden="true">[[getSummarySublabel_(creditCard)]]</span>
            <template is="dom-if"
                if="[[hasSummaryAndBenefitSublabel_(creditCard)]]">
              |
            </template>
            <template is="dom-if" if="[[isCardBenefitsProductUrlAvailable_(creditCard)]]">
              <a id="summaryTermsLink"
                aria-label="[[getBenefitsTermsAriaLabel_(creditCard)]]"
                aria-description="$i18n{opensInNewTab}"
                on-click="onSummarySublabelTermsLinkClick_"
                href="[[getCardBenefitsProductUrl_(creditCard)]]"
                target="_blank">$i18n{benefitsTermsTagForCreditCardListEntry}</a>
            </template>
          </div>
        </div>
      </div>
      <div class="expiration-column">
        <div role="cell" class="misc-column">
          <div id="paymentsIndicator"
              hidden$="[[!shouldShowPaymentsIndicator_(creditCard.metadata)]]">
            
            
              <span class="sub-label">
                $i18n{googlePayments}
              </span>
            
          </div>
          <template is="dom-if" if="[[showDots_(creditCard.metadata)]]">
            <cr-icon-button class="icon-more-vert" id="creditCardMenu"
                title="[[moreActionsTitle_(creditCard)]]"
                on-click="onDotsMenuClick_">
            </cr-icon-button>
          </template>
          <template is="dom-if" if="[[!showDots_(creditCard.metadata)]]">
            <cr-icon-button class="icon-external" id="remoteCreditCardLink"
                title="$i18n{remotePaymentMethodsLinkLabel}" role="link"
                on-click="onRemoteEditClick_"
                aria-description="$i18n{opensInNewTab}"></cr-icon-button>
          </template>
        </div>
      </div>
    </div>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'credit-card-list-entry' is a credit card row to be shown in
 * the settings page.
 */
const SettingsCreditCardListEntryElementBase = I18nMixin(PolymerElement);
class SettingsCreditCardListEntryElement extends SettingsCreditCardListEntryElementBase {
    static get is() {
        return 'settings-credit-card-list-entry';
    }
    static get template() {
        return getTemplate$28();
    }
    static get properties() {
        return {
            /** A saved credit card. */
            creditCard: Object,
            showNewFopDisplayEnabled_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('enableNewFopDisplay');
                },
                readOnly: true,
            },
        };
    }
    get dotsMenu() {
        return this.shadowRoot.getElementById('creditCardMenu');
    }
    /**
     * Opens the credit card action menu.
     */
    onDotsMenuClick_() {
        this.dispatchEvent(new CustomEvent('dots-card-menu-click', {
            bubbles: true,
            composed: true,
            detail: {
                creditCard: this.creditCard,
                anchorElement: this.shadowRoot.querySelector('#creditCardMenu'),
            },
        }));
    }
    onRemoteEditClick_() {
        this.dispatchEvent(new CustomEvent('remote-card-menu-click', {
            bubbles: true,
            composed: true,
            detail: {
                creditCard: this.creditCard,
                anchorElement: this.shadowRoot.querySelector('#creditCardMenu'),
            },
        }));
    }
    onSummarySublabelTermsLinkClick_() {
        // Log the metric for user clicking on the card benefits terms hyperlink.
        MetricsBrowserProxyImpl.getInstance().recordAction(CardBenefitsUserAction.CARD_BENEFITS_TERMS_LINK_CLICKED);
    }
    getCardNumberDescription_(creditCard) {
        const cardNumber = creditCard.cardNumber;
        if (cardNumber) {
            const lastFourDigits = cardNumber.substring(Math.max(0, cardNumber.length - 4));
            if (lastFourDigits) {
                const network = creditCard.network || this.i18n('genericCreditCard');
                return this.i18n('creditCardDescription', network, lastFourDigits);
            }
        }
        return undefined;
    }
    /**
     * @returns the title for the More Actions button corresponding to the card
     *     which is described by the nickname or the network name and last 4
     *     digits or name. If a card has CVC saved, there will be additional
     *     description to notify of the same.
     */
    moreActionsTitle_() {
        const cardDescription = this.creditCard.nickname ||
            this.getCardNumberDescription_(this.creditCard) ||
            this.creditCard.name;
        return this.i18n(this.creditCard.cvc ? 'moreActionsForCreditCardWithCvc' :
            'moreActionsForCreditCard', cardDescription);
    }
    /**
     * Returns true if the new FOP display should be shown.
     */
    shouldShowNewFopDisplay_() {
        return this.showNewFopDisplayEnabled_;
    }
    /**
     * The card has a product description or a nickname.
     */
    hasCardIdentifier_() {
        return (this.creditCard.metadata.summarySublabel || '').length > 0;
    }
    /**
     * The 3-dot menu should be shown if the card is not a masked server card or
     * if the card is eligible for virtual card enrollment.
     */
    showDots_() {
        return !!(this.creditCard.metadata.isLocal ||
            this.isVirtualCardEnrollmentEligible_());
    }
    isVirtualCardEnrollmentEligible_() {
        return this.creditCard.metadata.isVirtualCardEnrollmentEligible;
    }
    isVirtualCardEnrolled_() {
        return this.creditCard.metadata.isVirtualCardEnrolled;
    }
    getCardIdentifierAriaLabel_() {
        return this.creditCard.metadata.summaryLabel || '';
    }
    getSummaryAriaLabel_() {
        const cardNumberDescription = this.getCardNumberDescription_(this.creditCard);
        if (cardNumberDescription) {
            return this.i18n('creditCardA11yLabeled', cardNumberDescription);
        }
        return this.creditCard.metadata.summaryLabel;
    }
    /**
     * Returns an aria label for the benefits terms link such as "See terms for
     * Amex ending in 0001". If no card description is available, then the
     * default text such as "See terms here" is returned.
     */
    getBenefitsTermsAriaLabel_() {
        const cardNumberDescription = this.getCardNumberDescription_(this.creditCard);
        if (cardNumberDescription) {
            return this.i18n('benefitsTermsAriaLabel', cardNumberDescription);
        }
        return this.i18n('benefitsTermsTagForCreditCardListEntry');
    }
    getCardExpiryDate_() {
        assert(this.creditCard.expirationMonth);
        assert(this.creditCard.expirationYear);
        // Truncate the year down to two digits (eg. 2023 to 23).
        return this.creditCard.expirationMonth + '/' +
            this.creditCard.expirationYear.toString().substring(2);
    }
    getCardSublabelType() {
        if (this.isVirtualCardEnrolled_()) {
            if (this.isCardCvcAvailable_()) {
                return this.isCardBenefitsProductUrlAvailable_() ?
                    7 /* CardSummarySublabelType.VIRTUAL_CARD_WITH_CVC_AND_BENEFITS_TAG */ :
                    6 /* CardSummarySublabelType.VIRTUAL_CARD_WITH_CVC_TAG */;
            }
            return this.isCardBenefitsProductUrlAvailable_() ?
                5 /* CardSummarySublabelType.VIRTUAL_CARD_WITH_BENEFITS_TAG */ :
                4 /* CardSummarySublabelType.VIRTUAL_CARD */;
        }
        if (this.isCardCvcAvailable_()) {
            return this.isCardBenefitsProductUrlAvailable_() ?
                3 /* CardSummarySublabelType.EXPIRATION_DATE_WITH_CVC_AND_BENEFITS_TAG */ :
                2 /* CardSummarySublabelType.EXPIRATION_DATE_WITH_CVC_TAG */;
        }
        return this.isCardBenefitsProductUrlAvailable_() ?
            1 /* CardSummarySublabelType.EXPIRATION_DATE_WITH_BENEFITS_TAG */ :
            0 /* CardSummarySublabelType.EXPIRATION_DATE */;
    }
    /**
     * Returns expiration date.
     */
    getExpirationlabel_() {
        return ' · ' + this.getCardExpiryDate_();
    }
    /**
     * Returns one of the following sublabels, based on the card's status:
     *   Virtual card enrollment tag
     *   'CVC saved' tag
     *   Benefit tag (Place the benefit tag last because it includes a link to
     *                product terms.)
     * e.g., one of the following:
     *   CVC saved
     *   Card benefits available (terms apply)
     *   CVC saved | Card benefits available (terms apply)
     *   Virtual card turned on
     *   Virtual card turned on | CVC saved
     *   Virtual card turned on | Card benefits available (terms apply)
     *   Virtual card turned on | CVC saved | Card benefits available (terms
     *     apply)
     */
    getSummarySublabel_() {
        const separator = ' | ';
        let summarySublabel = this.isVirtualCardEnrolled_() ?
            this.i18n('virtualCardTurnedOn') :
            (this.shouldShowNewFopDisplay_() ? '' : this.getCardExpiryDate_());
        if (this.isCardCvcAvailable_()) {
            if (summarySublabel.length > 0) {
                summarySublabel += separator;
            }
            summarySublabel += this.i18n('cvcTagForCreditCardListEntry');
        }
        return summarySublabel;
    }
    hasSummaryAndBenefitSublabel_() {
        return this.getSummarySublabel_().length > 0 &&
            this.isCardBenefitsProductUrlAvailable_();
    }
    getSummaryAriaSublabel_() {
        switch (this.getCardSublabelType()) {
            case 7 /* CardSummarySublabelType.VIRTUAL_CARD_WITH_CVC_AND_BENEFITS_TAG */:
            case 5 /* CardSummarySublabelType.VIRTUAL_CARD_WITH_BENEFITS_TAG */:
            case 6 /* CardSummarySublabelType.VIRTUAL_CARD_WITH_CVC_TAG */:
            case 4 /* CardSummarySublabelType.VIRTUAL_CARD */:
                return this.shouldShowNewFopDisplay_() ?
                    this.i18n('creditCardExpDateA11yLabeled', this.getCardExpiryDate_()) +
                        this.getSummarySublabel_() :
                    this.getSummarySublabel_();
            case 3 /* CardSummarySublabelType.EXPIRATION_DATE_WITH_CVC_AND_BENEFITS_TAG */:
            case 1 /* CardSummarySublabelType.EXPIRATION_DATE_WITH_BENEFITS_TAG */:
            case 2 /* CardSummarySublabelType.EXPIRATION_DATE_WITH_CVC_TAG */:
            case 0 /* CardSummarySublabelType.EXPIRATION_DATE */:
                return this.i18n('creditCardExpDateA11yLabeled', this.shouldShowNewFopDisplay_() ? this.getCardExpiryDate_() :
                    this.getSummarySublabel_());
            default:
                assertNotReached();
        }
    }
    shouldShowVirtualCardSecondarySublabel_() {
        return this.creditCard.metadata.summarySublabel.trim() !== '' ||
            this.isVirtualCardEnrolled_() ||
            this.isVirtualCardEnrollmentEligible_();
    }
    shouldShowPaymentsIndicator_() {
        return !this.creditCard.metadata.isLocal;
    }
    isCardCvcAvailable_() {
        return loadTimeData.getBoolean('cvcStorageAvailable') &&
            !!this.creditCard.cvc;
    }
    isCardBenefitsProductUrlAvailable_() {
        return !!this.creditCard.productTermsUrl;
    }
    getCardBenefitsProductUrl_() {
        return this.creditCard.productTermsUrl || '';
    }
    /**
     * When the provided `imageSrc` points toward a processor's default card art,
     * this function returns a string that will scale the image based on the
     * user's screen resolution, otherwise it will return the unmodified
     * `imageSrc`.
     */
    getCardImage_(imageSrc) {
        return imageSrc.startsWith('chrome://theme') ?
            this.getScaledSrcSet_(imageSrc) :
            imageSrc;
    }
    /**
     * This function returns a string that can be used in a srcset to scale
     * the provided `url` based on the user's screen resolution.
     */
    getScaledSrcSet_(url) {
        return `${url} 1x, ${url}@2x 2x`;
    }
}
customElements.define(SettingsCreditCardListEntryElement.is, SettingsCreditCardListEntryElement);

function getTemplate$27() {
    return html `<!--_html_template_start_--><style include="settings-shared passwords-shared screen-reader-only">.second-column{align-items:center;display:flex;flex:1;justify-content:flex-end}.list-item{margin-bottom:8px;margin-top:8px}.sub-label{color:var(--cr-secondary-text-color)}#ibanImage{margin-inline-end:16px;vertical-align:middle}</style>
<div class="list-item type-column" role="row">
  <img id="ibanImage" src="[[getIbanImageSrc_(showNewFopDisplayEnabled_)]]" alt="">
  <div class="summary-column screen-reader-only-host-node" role="cell">
    <div class="screen-reader-only">
      [[getA11yIbanDescription_(iban)]], [[iban.nickname]]
    </div>
    <div id="label" class="ellipses" aria-hidden="true">
      [[getLabel_(iban)]]
    </div>
    <div id="subLabel" class="ellipses sub-label" aria-hidden="true">
      [[getSubLabel_(iban)]]
    </div>
  </div>
  <div role="cell" class="second-column">
    <div id="paymentsIndicator"
        hidden$="[[!shouldShowGooglePaymentsIndicator_(iban.metadata)]]">


        <span class="sub-label">$i18n{googlePayments}</span>

    </div>
    <template is="dom-if" if="[[showDotsMenu_(iban.metadata)]]">
      <cr-icon-button class="icon-more-vert" id="ibanMenu"
          title="[[getMoreActionsTitle_(iban)]]" on-click="onDotsMenuClick_">
      </cr-icon-button>
    </template>
    <template is="dom-if" if="[[!showDotsMenu_(iban.metadata)]]">
      <cr-icon-button class="icon-external" id="remoteIbanLink"
          title="$i18n{remotePaymentMethodsLinkLabel}" role="link"
          on-click="onRemoteEditClick_"
          aria-description="$i18n{opensInNewTab}"></cr-icon-button>
    </template>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'iban-list-entry' is an IBAN row to be shown on the settings
 * page.
 */
const SettingsIbanListEntryElementBase = I18nMixin(PolymerElement);
class SettingsIbanListEntryElement extends SettingsIbanListEntryElementBase {
    static get is() {
        return 'settings-iban-list-entry';
    }
    static get template() {
        return getTemplate$27();
    }
    static get properties() {
        return {
            /** A saved IBAN. */
            iban: Object,
            showNewFopDisplayEnabled_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('enableNewFopDisplay');
                },
                readOnly: true,
            },
        };
    }
    get dotsMenu() {
        return this.shadowRoot.getElementById('ibanMenu');
    }
    /**
     * The 3-dot menu should be shown if the IBAN is a local IBAN.
     */
    showDotsMenu_() {
        return !!this.iban.metadata.isLocal;
    }
    /**
     * The Google Payments icon should be shown if the IBAN is a server IBAN.
     */
    shouldShowGooglePaymentsIndicator_() {
        return !this.iban.metadata.isLocal;
    }
    /**
     * This function returns a string that can be used in a srcset to scale
     * the provided `url` based on the user's screen resolution.
     */
    getScaledSrcSet_(url) {
        return `${url} 1x, ${url}@2x 2x`;
    }
    /**
     * Opens the IBAN action menu.
     */
    onDotsMenuClick_() {
        this.dispatchEvent(new CustomEvent('dots-iban-menu-click', {
            bubbles: true,
            composed: true,
            detail: {
                iban: this.iban,
                anchorElement: this.dotsMenu,
            },
        }));
    }
    onRemoteEditClick_() {
        this.dispatchEvent(new CustomEvent('remote-iban-menu-click', {
            bubbles: true,
            composed: true,
            detail: {
                iban: this.iban,
                anchorElement: this.dotsMenu,
            },
        }));
    }
    getA11yIbanDescription_(iban) {
        // Strip all whitespace and get the pure last four digits of the value.
        const strippedSummaryLabel = iban.metadata ? iban.metadata.summaryLabel.replace(/\s/g, '') : '';
        const lastFourDigits = strippedSummaryLabel.substring(Math.max(0, strippedSummaryLabel.length - 4));
        return this.i18n('a11yIbanDescription', lastFourDigits);
    }
    getIbanImageSrc_() {
        return this.showNewFopDisplayEnabled_ ?
            'chrome://settings/images/iban.svg' :
            'chrome://settings/images/iban_old.svg';
    }
    getLabel_(iban) {
        if (this.showNewFopDisplayEnabled_ && iban.nickname) {
            return iban.nickname;
        }
        return iban.metadata.summaryLabel;
    }
    getSubLabel_(iban) {
        if (this.showNewFopDisplayEnabled_ && iban.nickname) {
            return iban.metadata.summaryLabel;
        }
        return iban.nickname || '';
    }
    /**
     * @return the title for the More Actions button corresponding to the IBAN
     *     which is described by the nickname or last 4 digits of the IBAN's
     *     value.
     */
    getMoreActionsTitle_(iban) {
        return this.i18n('moreActionsForIban', iban.nickname || this.getA11yIbanDescription_(iban));
    }
}
customElements.define(SettingsIbanListEntryElement.is, SettingsIbanListEntryElement);

function getTemplate$26() {
    return html `<!--_html_template_start_--><style include="settings-shared passwords-shared screen-reader-only">.misc-column{align-items:center;display:flex;justify-content:flex-end}.list-item{margin-bottom:8px;margin-top:8px}.sub-label{color:var(--cr-secondary-text-color)}#paymentsIcon{vertical-align:middle}#payOverTimeIssuerImage{line-height:0;margin-inline-end:16px;vertical-align:middle}</style>

<div class="list-item" role="row">
  <div class="type-column" role="cell">
    <picture id="payOverTimeIssuerImage">
      <source
          srcset="[[getIssuerImage_(payOverTimeIssuer.imageSrcDark)]]"
          media="(prefers-color-scheme: dark)">
      <img alt="" srcset="[[getIssuerImage_(payOverTimeIssuer.imageSrc)]]">
    </picture>
    <div class="summary-column screen-reader-only-host-node" role="cell">
      <div id="summaryLabel" class="ellipses">
        [[payOverTimeIssuer.displayName]]
      </div>
    </div>
  </div>
  <div class="misc-column" role="cell">
    <div id="paymentsIndicator">


      <span class="sub-label">$i18n{googlePayments}</span>

    </div>
    <cr-icon-button class="icon-external" id="remotePayOverTimeIssuerLink"
        title="$i18n{remotePaymentMethodsLinkLabel}" role="link"
        on-click="onRemoteEditClick_"
        aria-description="$i18n{opensInNewTab}"></cr-icon-button>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'pay-over-time-issuer-list-entry' is an Pay Over Time issuer
 * row to be shown on the settings page.
 */
class SettingsPayOverTimeIssuerListEntryElement extends PolymerElement {
    static get is() {
        return 'settings-pay-over-time-issuer-list-entry';
    }
    static get template() {
        return getTemplate$26();
    }
    static get properties() {
        return {
            payOverTimeIssuer: Object,
        };
    }
    /**
     * When the provided `imageSrc` points toward an issuer's default logo art,
     * this function returns a string that will scale the image based on the
     * user's screen resolution, otherwise it will return the unmodified
     * `imageSrc`.
     */
    getIssuerImage_(imageSrc) {
        return imageSrc.startsWith('chrome://theme') ?
            this.getScaledSrcSet_(imageSrc) :
            imageSrc;
    }
    /**
     * This function returns a string that can be used in a srcset to scale
     * the provided `url` based on the user's screen resolution.
     */
    getScaledSrcSet_(url) {
        return `${url} 1x, ${url}@2x 2x`;
    }
    onRemoteEditClick_() {
        OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString('managePaymentMethodsUrl'));
    }
}
customElements.define(SettingsPayOverTimeIssuerListEntryElement.is, SettingsPayOverTimeIssuerListEntryElement);

function getTemplate$25() {
    return html `<!--_html_template_start_-->    <style include="settings-shared passwords-shared">.expiration-column{align-items:center;display:flex;flex:1}.vertical-list:has(.payment-method)~.vertical-list:has(.payment-method){border-top:var(--cr-separator-line);width:100%}
    </style>
    <div role="table">
      <div class="vertical-list list-with-header" role="rowgroup">
        <template is="dom-repeat" items="[[creditCards]]">
          <settings-credit-card-list-entry id="[[getCreditCardId_(index)]]"
              class="payment-method" credit-card="[[item]]">
          </settings-credit-card-list-entry>
        </template>
      </div>
      <div class="vertical-list list-with-header" role="rowgroup">
        <template is="dom-repeat" items="[[ibans]]">
          <settings-iban-list-entry id="[[getIbanId_(index)]]"
              class="payment-method" iban="[[item]]">
          </settings-iban-list-entry>
        </template>
      </div>
      <div class="vertical-list list-with-header" role="rowgroup">
        <template is="dom-repeat" items="[[payOverTimeIssuers]]">
          <settings-pay-over-time-issuer-list-entry class="payment-method"
              pay-over-time-issuer="[[item]]">
          </settings-pay-over-time-issuer-list-entry>
        </template>
      </div>
    </div>
    <div id="noPaymentMethodsLabel" class="list-item"
        hidden$="[[showAnyPaymentMethods_]]">
      $i18n{noPaymentMethodsFound}
    </div>
<!--_html_template_end_-->`;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'payments-list' is a list of saved payment methods (credit
 * cards etc.) to be shown in the settings page.
 */
class SettingsPaymentsListElement extends PolymerElement {
    static get is() {
        return 'settings-payments-list';
    }
    static get template() {
        return getTemplate$25();
    }
    static get properties() {
        return {
            /**
             * An array of all saved credit cards.
             */
            creditCards: Array,
            /**
             * An array of all saved IBANs.
             */
            ibans: Array,
            /**
             * An array of all saved Pay Over Time issuers.
             */
            payOverTimeIssuers: Array,
            /**
             * True if displaying IBANs in settings is enabled.
             */
            enableIbans_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('showIbansSettings');
                },
            },
            /**
             * True if displaying Pay Over Time in settings is enabled.
             */
            enablePayOverTime_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('shouldShowPayOverTimeSettings');
                },
            },
            /**
             * True iff any payment methods will be shown.
             */
            showAnyPaymentMethods_: {
                type: Boolean,
                value: false,
                computed: 'computeShowAnyPaymentMethods_(' +
                    'creditCards, ibans, enableIbans_, payOverTimeIssuers, enablePayOverTime_)',
            },
        };
    }
    /**
     * Focuses the next most appropriate element after removing a specific
     * credit card. Returns `false` if it could not find such an element,
     * in this case the focus is supposed to be handled by someone else.
     */
    updateFocusBeforeCreditCardRemoval(cardIndex) {
        // The focused element is to be reset only if the last element is deleted,
        // when the number of "dom-repeat" nodes changes and the focus get lost.
        if (cardIndex === this.creditCards.length - 1) {
            return this.updateFocusBeforeRemoval_(this.getCreditCardId_(cardIndex));
        }
        else {
            return true;
        }
    }
    /**
     * Focuses the next most appropriate element after removing a specific
     * iban. Returns `false` if it could not find such an element,
     * in this case the focus is supposed to be handled by someone else.
     */
    updateFocusBeforeIbanRemoval(ibanIndex) {
        // The focused element is to be reset only if the last element is deleted,
        // when the number of "dom-repeat" nodes changes and the focus get lost.
        if (ibanIndex === this.ibans.length - 1) {
            return this.updateFocusBeforeRemoval_(this.getIbanId_(ibanIndex));
        }
        else {
            return true;
        }
    }
    /**
     * Handles focus resetting across all payment method lists. Returns `false`
     * only when the last payment method is removed, in other cases sets the focus
     * to either the next or previous payment method.
     */
    updateFocusBeforeRemoval_(id) {
        const paymentMethods = this.shadowRoot.querySelectorAll('.payment-method');
        if (paymentMethods.length <= 1) {
            return false;
        }
        const index = [...paymentMethods].findIndex((element) => element.id === id);
        const isLastItem = index === paymentMethods.length - 1;
        const indexToFocus = index + (isLastItem ? -1 : +1);
        const menu = paymentMethods[indexToFocus].dotsMenu;
        if (menu) {
            focusWithoutInk(menu);
            return true;
        }
        return false;
    }
    getCreditCardId_(index) {
        return `card-${index}`;
    }
    getIbanId_(index) {
        return `iban-${index}`;
    }
    /**
     * @return Whether the list exists and has items.
     */
    hasSome_(list) {
        return !!(list && list.length);
    }
    /**
     * @return true iff there are credit cards to be shown.
     */
    showCreditCards_() {
        return this.hasSome_(this.creditCards);
    }
    /**
     * @return true iff there are IBANs to be shown.
     */
    showIbans_() {
        return this.enableIbans_ && this.hasSome_(this.ibans);
    }
    /**
     * @return true iff there are Pay Over Time issuers to be shown.
     */
    showPayOverTimeIssuers_() {
        return this.enablePayOverTime_ && this.hasSome_(this.payOverTimeIssuers);
    }
    /**
     * @return true iff any payment methods will be shown.
     */
    computeShowAnyPaymentMethods_() {
        return this.showCreditCards_() || this.showIbans_() ||
            this.showPayOverTimeIssuers_();
    }
}
customElements.define(SettingsPaymentsListElement.is, SettingsPaymentsListElement);

function getTemplate$24() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared"></style>
<cr-dialog id="dialog" show-on-attach close-text="$i18n{close}">
  <div slot="title">$i18n{unenrollVirtualCardDialogTitle}</div>
  <div slot="body">
    <div class="cr-padded-text">$i18nRaw{unenrollVirtualCardDialogLabel}</div>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton" class="cancel-button"
        on-click="onCancelButtonClick_">$i18n{cancel}</cr-button>
    <cr-button id="confirmButton" class="action-button"
        on-click="onConfirmButtonClick_">
      $i18n{unenrollVirtualCardDialogConfirm}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-virtual-card-unenroll-dialog' is the dialog that is
 * shown when the action menu button "Remove virtual card" is clicked. It
 * requests user confirmation before unenrolling a card from the virtual card
 * feature.
 */
class SettingsVirtualCardUnenrollDialogElement extends PolymerElement {
    static get is() {
        return 'settings-virtual-card-unenroll-dialog';
    }
    static get template() {
        return getTemplate$24();
    }
    static get properties() {
        return {
            /**
             * The credit card being unenrolled from the virtual cards.
             */
            creditCard: Object,
        };
    }
    close() {
        this.$.dialog.close();
    }
    onCancelButtonClick_() {
        this.$.dialog.cancel();
    }
    onConfirmButtonClick_() {
        this.dispatchEvent(new CustomEvent('unenroll-virtual-card', { bubbles: true, composed: true, detail: this.creditCard.guid }));
        this.close();
    }
}
customElements.define(SettingsVirtualCardUnenrollDialogElement.is, SettingsVirtualCardUnenrollDialogElement);

function getTemplate$23() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared passwords-shared
    your-saved-info-shared">#cardBenefitsToggle{display:none}.expiration-column{align-items:center;display:flex;flex:1}.arrow-icon-down{fill:currentColor;flex-shrink:0;margin-inline-start:6px;margin-inline-end:-6px;width:var(--cr-icon-size)}.payment-list-margin-start{padding-inline-start:20px}
</style>
<settings-subpage page-title="[[getPageTitleLabel_(isYourSavedInfoSubpage_)]]"
    hide-close-button="[[hideCloseButton]]"
    learn-more-url="$i18n{addressesAndPaymentMethodsLearnMoreURL}"
    class$="[[getMultiCardClass_(isYourSavedInfoSubpage_)]]">

<div class="card">
<settings-toggle-button id="autofillCreditCardToggle"
    no-extension-indicator label="$i18n{enableCreditCardsLabel}"
    sub-label="$i18n{enableCreditCardsSublabel}"
    pref="{{prefs.autofill.credit_card_enabled}}">
</settings-toggle-button>

  <settings-toggle-button id="mandatoryAuthToggle"
      no-extension-indicator label="$i18n{enableMandatoryAuthToggleLabel}"
      sub-label="$i18n{enableMandatoryAuthToggleSublabel}"
      pref="{{prefs.autofill.payment_methods_mandatory_reauth}}" no-set-pref
      disabled="[[shouldDisableAuthToggle_(
                prefs.autofill.credit_card_enabled.value, deviceAuthAvailable_)]]"
      on-settings-boolean-control-change="onMandatoryAuthToggleChange_">
  </settings-toggle-button>

<template is="dom-if" if="[[cvcStorageAvailable_]]">
  <settings-toggle-button id="cvcStorageToggle"
        no-extension-indicator label="$i18n{enableCvcStorageLabel}"
        aria-label="[[getCvcStorageAriaLabel_(creditCards)]]"
        sub-label-with-link="[[getCvcStorageSublabel_(creditCards)]]"
        disabled="[[!prefs.autofill.credit_card_enabled.value]]"
        on-sub-label-link-clicked="onBulkRemoveCvcClick_"
        pref="{{prefs.autofill.payment_cvc_storage}}">
    </settings-toggle-button>
</template>
<template is="dom-if" if="[[cardBenefitsFlagEnabled_]]">
  <settings-toggle-button id="cardBenefitsToggle"
      no-extension-indicator label="$i18n{cardBenefitsLabel}"
      sub-label-with-link="[[cardBenefitsSublabel_]]"
      on-sub-label-link-clicked="onCardBenefitsSublabelLinkClick_"
      disabled="[[!prefs.autofill.credit_card_enabled.value]]"
      pref="{{prefs.autofill.payment_card_benefits}}">
  </settings-toggle-button>
</template>
<template is="dom-if" if="[[shouldShowPayOverTimeSettings_]]">
  <settings-toggle-button id="payOverTimeToggle"
      no-extension-indicator label="$i18n{autofillPayOverTimeSettingsLabel}"
      sub-label-with-link="[[payOverTimeSublabel_]]"
      on-sub-label-link-clicked="onPayOverTimeSublabelLinkClick_"
      disabled="[[!prefs.autofill.credit_card_enabled.value]]"
      pref="{{prefs.autofill.bnpl_enabled}}">
  </settings-toggle-button>
</template>
<settings-toggle-button id="canMakePaymentToggle"
    aria-label="$i18n{canMakePaymentToggleLabel}"
    label="$i18n{canMakePaymentToggleLabel}"
    pref="{{prefs.payments.can_make_payment_enabled}}"
    on-settings-boolean-control-change="onCanMakePaymentChange_">
</settings-toggle-button>
<template is="dom-if"
    if="[[prefs.autofill.credit_card_enabled.extensionId]]">
  <div class="cr-row continuation">
    <extension-controlled-indicator class="flex"
        id="autofillExtensionIndicator"
        extension-id="[[prefs.autofill.credit_card_enabled.extensionId]]"
        extension-name="[[
            prefs.autofill.credit_card_enabled.controlledByName]]"
        extension-can-be-disabled="[[
            prefs.autofill.credit_card_enabled.extensionCanBeDisabled]]">
    </extension-controlled-indicator>
  </div>
</template>

<div id="manageLink" class="cr-row first" hidden>
  <!-- This span lays out the link correctly, relative to the text. -->
  <div class="cr-padded-text">$i18nRaw{manageCreditCardsLabel}</div>
</div>

</div>

<div class="card">

<div class="cr-row continuation">
  <h2 class="flex">$i18n{creditCards}</h2>
  <template is="dom-if"
      if="[[!shouldShowIbanSettings_(showIbanSettingsEnabled_)]]">
    <cr-button id="addCreditCard" class="header-aligned-button"
        on-click="onAddCreditCardClick_" aria-label="$i18n{addCreditCardTitle}"
        hidden$="[[!prefs.autofill.credit_card_enabled.value]]">
      $i18n{add}
    </cr-button>
  </template>
  <template is="dom-if"
      if="[[shouldShowIbanSettings_(showIbanSettingsEnabled_)]]">
    <cr-button class="header-aligned-button"
        id="addPaymentMethods" on-click="onAddPaymentMethodClick_"
        aria-label="$i18n{addPaymentMethods}"
        hidden$="[[!prefs.autofill.credit_card_enabled.value]]">
      $i18n{add}
      <cr-icon icon="cr:arrow-drop-down" class="arrow-icon-down"></cr-icon>
    </cr-button>
    <cr-lazy-render id="paymentMethodsActionMenu">
      <template>
        <cr-action-menu role-description="$i18n{menu}">
          <button id="addCreditCard" class="dropdown-item"
              on-click="onAddCreditCardClick_">
            $i18n{addPaymentMethodCreditOrDebitCard}
          </button>
          <button id="addIban" class="dropdown-item"
              on-click="onAddIbanClick_">
            $i18n{addPaymentMethodIban}
          </button>
        </cr-action-menu>
      </template>
    </cr-lazy-render>
  </template>
</div>
<settings-payments-list id="paymentsList"
    class="list-frame payment-list-margin-start"
    credit-cards="[[creditCards]]"
    ibans="[[ibans]]"
    pay-over-time-issuers="[[payOverTimeIssuers]]"
    on-dots-iban-menu-click="onDotsIbanMenuClick_"
    on-remote-iban-menu-click="onRemoteEditIbanMenuClick_"
    on-dots-card-menu-click="onCreditCardDotsMenuClick_"
    on-remote-card-menu-click="onRemoteEditCreditCardClick_"
    aria-label="$i18n{paymentsMethodsTableAriaLabel}">
</settings-payments-list>

<cr-action-menu id="creditCardSharedMenu" role-description="$i18n{menu}">
  <button id="menuEditCreditCard" class="dropdown-item"
      on-click="onMenuEditCreditCardClick_">
    [[getMenuEditCardText_(activeCreditCard_.metadata.isLocal)]]
  </button>

  <button id="menuRemoveCreditCard" class="dropdown-item"
      hidden$="[[!activeCreditCard_.metadata.isLocal]]"
      on-click="onMenuRemoveCreditCardClick_">$i18n{delete}</button>

  <button id="menuAddVirtualCard" class="dropdown-item"
      on-click="onMenuAddVirtualCardClick_"
      hidden$="[[!shouldShowAddVirtualCardButton_(activeCreditCard_)]]">
    $i18n{addVirtualCard}
  </button>
  <button id="menuRemoveVirtualCard" class="dropdown-item"
      on-click="onMenuRemoveVirtualCardClick_"
      hidden$="[[!shouldShowRemoveVirtualCardButton_(activeCreditCard_)]]">
    $i18n{removeVirtualCard}
  </button>
</cr-action-menu>

<cr-lazy-render id="ibanSharedActionMenu">
  <template>
    <cr-action-menu id="ibanSharedMenu" role-description="$i18n{menu}">
      <button id="menuEditIban" class="dropdown-item"
          on-click="onMenuEditIbanClick_">
        $i18n{editIban}
      </button>
      <button id="menuRemoveIban" class="dropdown-item"
          on-click="onMenuRemoveIbanClick_">
        $i18n{delete}
      </button>
    </cr-action-menu>
  </template>
</cr-lazy-render>

<template is="dom-if" if="[[showCreditCardDialog_]]" restamp>
  <settings-credit-card-edit-dialog credit-card="[[activeCreditCard_]]"
      on-close="onCreditCardDialogClose_" on-save-credit-card="saveCreditCard_"
      prefs="{{prefs}}">
  </settings-credit-card-edit-dialog>
</template>
<template is="dom-if" if="[[showIbanDialog_]]" restamp>
  <settings-iban-edit-dialog iban="[[activeIban_]]"
      on-close="onIbanDialogClose_" on-save-iban="onSaveIban_">
  </settings-iban-edit-dialog>
</template>

<template is="dom-if" if="[[showVirtualCardUnenrollDialog_]]" restamp>
  <settings-virtual-card-unenroll-dialog credit-card="[[activeCreditCard_]]"
      on-close="onVirtualCardUnenrollDialogClose_"
      on-unenroll-virtual-card="unenrollVirtualCard_">
  </settings-virtual-card-unenroll-dialog>
</template>

<template is="dom-if" if="[[showLocalCreditCardRemoveConfirmationDialog_]]"
    restamp>
  <settings-simple-confirmation-dialog id="localCardDeleteConfirmDialog"
      title-text="$i18n{removeLocalCreditCardConfirmationTitle}"
      body-text="$i18n{removeLocalPaymentMethodConfirmationDescription}"
      confirm-text="$i18n{delete}"
      on-close="onLocalCreditCardRemoveConfirmationDialogClose_">
  </settings-simple-confirmation-dialog>
</template>

<template is="dom-if" if="[[showLocalIbanRemoveConfirmationDialog_]]" restamp>
  <settings-simple-confirmation-dialog id="localIbanDeleteConfirmationDialog"
      title-text="$i18n{removeLocalIbanConfirmationTitle}"
      body-text="$i18n{removeLocalPaymentMethodConfirmationDescription}"
      confirm-text="$i18n{delete}"
      on-close="onLocalIbanRemoveConfirmationDialogClose_">
  </settings-simple-confirmation-dialog>
</template>

<template is="dom-if" if="[[showBulkRemoveCvcConfirmationDialog_]]" restamp>
  <settings-simple-confirmation-dialog id="bulkDeleteCvcConfirmDialog"
      title-text="$i18n{bulkRemoveCvcConfirmationTitle}"
      body-text="$i18n{bulkRemoveCvcConfirmationDescription}"
      confirm-text="$i18n{delete}"
      on-close="onShowBulkRemoveCvcConfirmationDialogClose_">
  </settings-simple-confirmation-dialog>
</template>

</div>

</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-payments-section' is the section containing saved
 * credit cards for use in autofill and payments APIs.
 */
const SettingsPaymentsSectionElementBase = SettingsViewMixin(I18nMixin(PolymerElement));
class SettingsPaymentsSectionElement extends SettingsPaymentsSectionElementBase {
    static get is() {
        return 'settings-payments-section';
    }
    static get template() {
        return getTemplate$23();
    }
    static get properties() {
        return {
            prefs: Object,
            /**
             * Whether we should hide the "close" button to get to the previous page.
             */
            hideCloseButton: {
                type: Boolean,
                value: false,
            },
            /**
             * An array of all saved credit cards.
             */
            creditCards: {
                type: Array,
                value: () => [],
            },
            /**
             * An array of all saved IBANs.
             */
            ibans: {
                type: Array,
                value: () => [],
            },
            /**
             * An array of all saved pay over time issuers.
             */
            payOverTimeIssuers: {
                type: Array,
                value: () => [],
            },
            /**
             * Whether IBAN is supported in Settings page.
             */
            showIbanSettingsEnabled_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('showIbansSettings');
                },
                readOnly: true,
            },
            /**
             * The model for any credit card-related action menus or dialogs.
             */
            activeCreditCard_: Object,
            /**
             * The model for any IBAN-related action menus or dialogs.
             */
            activeIban_: Object,
            showCreditCardDialog_: Boolean,
            showIbanDialog_: Boolean,
            showLocalCreditCardRemoveConfirmationDialog_: Boolean,
            showLocalIbanRemoveConfirmationDialog_: Boolean,
            showVirtualCardUnenrollDialog_: Boolean,
            showBulkRemoveCvcConfirmationDialog_: Boolean,
            /**
             * Checks if we can use device authentication to authenticate the user.
             */
            // 
            deviceAuthAvailable_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('deviceAuthAvailable');
                },
            },
            // 
            /**
             * Checks if CVC storage is available based on the feature flag.
             */
            cvcStorageAvailable_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('cvcStorageAvailable');
                },
            },
            /**
             * Checks if a card benefits feature flag is enabled.
             */
            cardBenefitsFlagEnabled_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('autofillCardBenefitsAvailable');
                },
            },
            /**
             * Sublabel for the card benefits toggle. The sublabel text also includes
             * a link to learn about the card benefits.
             */
            cardBenefitsSublabel_: {
                type: String,
                value() {
                    return loadTimeData.getString('cardBenefitsToggleSublabel');
                },
            },
            /**
             * Checks if pay over time should be shown from the settings page.
             */
            shouldShowPayOverTimeSettings_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('shouldShowPayOverTimeSettings');
                },
                readOnly: true,
            },
            /**
             * Sublabel for the pay over time toggle. The sublabel text also includes
             * a link to learn about pay over time.
             */
            payOverTimeSublabel_: {
                type: String,
                value() {
                    return loadTimeData.getString('autofillPayOverTimeSettingsSublabel');
                },
            },
            /**
             * Indicates if this element is used as a Your saved info subpage. Causes
             * slight adjustments like different title, no page shadow, cards being
             * visible.
             */
            isYourSavedInfoSubpage_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('enableYourSavedInfoSettingsPage'),
            },
        };
    }
    paymentsManager_ = PaymentsManagerImpl.getInstance();
    setPersonalDataListener_ = null;
    connectedCallback() {
        super.connectedCallback();
        // Create listener function.
        const setCreditCardsListener = (cardList) => {
            this.setCreditCards_(cardList);
        };
        const setPersonalDataListener = (_addressList, cardList, ibanList, payOverTimeIssuerList) => {
            this.setCreditCards_(cardList);
            this.ibans = ibanList;
            if (this.shouldShowPayOverTimeSettings_) {
                this.payOverTimeIssuers = payOverTimeIssuerList;
            }
        };
        const setIbansListener = (ibanList) => {
            this.ibans = ibanList;
        };
        // Remember the bound reference in order to detach.
        this.setPersonalDataListener_ = setPersonalDataListener;
        // Request initial data.
        this.paymentsManager_.getCreditCardList().then(setCreditCardsListener);
        this.paymentsManager_.getIbanList().then(setIbansListener);
        if (this.shouldShowPayOverTimeSettings_) {
            this.paymentsManager_.getPayOverTimeIssuerList().then((issuers) => {
                this.payOverTimeIssuers = issuers;
            });
        }
        // Listen for changes.
        this.paymentsManager_.setPersonalDataManagerListener(setPersonalDataListener);
        // 
        this.paymentsManager_.checkIfDeviceAuthAvailable().then(result => this.deviceAuthAvailable_ = result);
        // 
        // Record that the user opened the payments settings.
        chrome.metricsPrivate.recordUserAction('AutofillCreditCardsViewed');
        // Measure clicks on the 'Google Account' link for managing payment methods.
        const manageAccountAnchor = this.$.manageLink.querySelector('a');
        if (manageAccountAnchor !== null) {
            manageAccountAnchor.addEventListener('click', () => {
                MetricsBrowserProxyImpl.getInstance().recordAction('Autofill.PaymentMethodsSettingsPage.ManagePaymentMethodsLinkClicked');
            });
        }
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        assert(this.setPersonalDataListener_);
        this.paymentsManager_.removePersonalDataManagerListener(this.setPersonalDataListener_);
        this.setPersonalDataListener_ = null;
    }
    getMultiCardClass_() {
        return this.isYourSavedInfoSubpage_ ? 'multi-card' : '';
    }
    getPageTitleLabel_() {
        return this.i18n(this.isYourSavedInfoSubpage_ ? 'paymentsTitle' : 'creditCards');
    }
    setCreditCards_(cardList) {
        this.creditCards = cardList;
        // To align with Android, only record this histogram when the pref is
        // enabled.
        const autofillEnabledPref = this.get('prefs.autofill.credit_card_enabled');
        if (!!autofillEnabledPref && autofillEnabledPref.value) {
            MetricsBrowserProxyImpl.getInstance().recordBooleanHistogram('Autofill.PaymentMethodsSettingsPage.CardsViewedWithoutExistingCards', this.creditCards.length === 0);
        }
    }
    /**
     * Returns true if IBAN should be shown from settings page.
     * TODO(crbug.com/40234941): Add additional check (starter country-list, or
     * the saved-pref-boolean on if the user has submitted an IBAN form).
     */
    shouldShowIbanSettings_() {
        return this.showIbanSettingsEnabled_;
    }
    /**
     * Opens the dropdown menu to add a credit/debit card or IBAN.
     */
    onAddPaymentMethodClick_(e) {
        const target = e.currentTarget;
        const menu = this.shadowRoot
            .querySelector('#paymentMethodsActionMenu').get();
        assert(menu);
        menu.showAt(target, {
            anchorAlignmentX: AnchorAlignment.BEFORE_END,
            anchorAlignmentY: AnchorAlignment.AFTER_END,
            noOffset: true,
        });
    }
    /**
     * Opens the credit card action menu.
     */
    onCreditCardDotsMenuClick_(e) {
        // Copy item so dialog won't update model on cancel.
        this.activeCreditCard_ = e.detail.creditCard;
        this.$.creditCardSharedMenu.showAt(e.detail.anchorElement);
    }
    /**
     * Opens the IBAN action menu.
     */
    onDotsIbanMenuClick_(e) {
        // Copy item so dialog won't update model on cancel.
        this.activeIban_ = e.detail.iban;
        this.$.ibanSharedActionMenu.get().showAt(e.detail.anchorElement);
    }
    /**
     * Handles clicking on the "Add credit card" button.
     */
    onAddCreditCardClick_(e) {
        e.preventDefault();
        MetricsBrowserProxyImpl.getInstance().recordBooleanHistogram('Autofill.PaymentMethodsSettingsPage.AddCardClicked2', true);
        MetricsBrowserProxyImpl.getInstance().recordBooleanHistogram('Autofill.PaymentMethodsSettingsPage.AddCardClickedWithoutExistingCards2', this.creditCards.length === 0);
        const date = new Date(); // Default to current month/year.
        const expirationMonth = date.getMonth() + 1; // Months are 0 based.
        this.activeCreditCard_ = {
            expirationMonth: expirationMonth.toString(),
            expirationYear: date.getFullYear().toString(),
        };
        this.showCreditCardDialog_ = true;
        if (this.showIbanSettingsEnabled_) {
            const menu = this.shadowRoot
                .querySelector('#paymentMethodsActionMenu').get();
            assert(menu);
            menu.close();
        }
    }
    onCreditCardDialogClose_() {
        this.showCreditCardDialog_ = false;
        this.activeCreditCard_ = null;
    }
    /**
     * Handles clicking on the add "IBAN" option.
     */
    onAddIbanClick_(e) {
        e.preventDefault();
        this.showIbanDialog_ = true;
        const menu = this.shadowRoot
            .querySelector('#paymentMethodsActionMenu').get();
        assert(menu);
        menu.close();
    }
    onIbanDialogClose_() {
        this.showIbanDialog_ = false;
        this.activeIban_ = null;
    }
    /**
     * Handles clicking on the "Edit" credit card button.
     */
    async onMenuEditCreditCardClick_(e) {
        e.preventDefault();
        assert(this.activeCreditCard_);
        if (this.activeCreditCard_.metadata.isLocal) {
            const unmaskedCreditCard = await this.paymentsManager_.getLocalCard(this.activeCreditCard_.guid);
            assert(unmaskedCreditCard);
            this.activeCreditCard_ = unmaskedCreditCard;
            this.showCreditCardDialog_ = true;
        }
        else {
            this.onRemoteCreditCardUrlClick_();
        }
        this.$.creditCardSharedMenu.close();
    }
    onRemoteEditCreditCardClick_(e) {
        this.activeCreditCard_ = e.detail.creditCard;
        this.onRemoteCreditCardUrlClick_();
    }
    onRemoteCreditCardUrlClick_() {
        this.paymentsManager_.logServerCardLinkClicked();
        const url = new URL(loadTimeData.getString('managePaymentMethodsUrl'));
        assert(this.activeCreditCard_);
        if (this.activeCreditCard_.instrumentId) {
            url.searchParams.append('id', this.activeCreditCard_.instrumentId);
        }
        OpenWindowProxyImpl.getInstance().openUrl(url.toString());
    }
    onRemoteEditIbanMenuClick_(e) {
        this.activeIban_ = e.detail.iban;
        this.paymentsManager_.logServerIbanLinkClicked();
        const url = new URL(loadTimeData.getString('managePaymentMethodsUrl'));
        assert(this.activeIban_);
        if (this.activeIban_.instrumentId) {
            url.searchParams.append('id', this.activeIban_.instrumentId);
        }
        OpenWindowProxyImpl.getInstance().openUrl(url.toString());
    }
    onLocalCreditCardRemoveConfirmationDialogClose_() {
        // Only remove the credit card entry if the user closed the dialog via the
        // confirmation button (instead of cancel or close).
        const confirmationDialog = this.shadowRoot.querySelector('#localCardDeleteConfirmDialog');
        assert(confirmationDialog);
        if (confirmationDialog.wasConfirmed()) {
            assert(this.activeCreditCard_);
            assert(this.activeCreditCard_.guid);
            const index = this.creditCards.findIndex((card) => card.guid === this.activeCreditCard_.guid);
            if (!this.$.paymentsList.updateFocusBeforeCreditCardRemoval(index)) {
                this.focusHeaderControls_();
            }
            this.paymentsManager_.removeCreditCard(this.activeCreditCard_.guid);
            this.activeCreditCard_ = null;
        }
        this.showLocalCreditCardRemoveConfirmationDialog_ = false;
    }
    /**
     * Handles clicking on the "Remove" credit card button.
     */
    onMenuRemoveCreditCardClick_() {
        this.showLocalCreditCardRemoveConfirmationDialog_ = true;
        this.$.creditCardSharedMenu.close();
    }
    /**
     * Handles clicking on the "Edit" IBAN button.
     */
    onMenuEditIbanClick_(e) {
        e.preventDefault();
        this.showIbanDialog_ = true;
        this.$.ibanSharedActionMenu.get().close();
    }
    onLocalIbanRemoveConfirmationDialogClose_() {
        // Only remove the IBAN entry if the user closed the dialog via the
        // confirmation button (instead of cancel or close).
        const confirmationDialog = this.shadowRoot.querySelector('#localIbanDeleteConfirmationDialog');
        assert(confirmationDialog);
        if (confirmationDialog.wasConfirmed()) {
            assert(this.activeIban_);
            assert(this.activeIban_.guid);
            const index = this.ibans.findIndex((iban) => iban.guid === this.activeIban_.guid);
            if (!this.$.paymentsList.updateFocusBeforeIbanRemoval(index)) {
                this.focusHeaderControls_();
            }
            this.paymentsManager_.removeIban(this.activeIban_.guid);
            this.activeIban_ = null;
        }
        this.showLocalIbanRemoveConfirmationDialog_ = false;
    }
    /**
     * Handles clicking on the "Remove" IBAN button.
     */
    onMenuRemoveIbanClick_() {
        assert(this.activeIban_);
        this.showLocalIbanRemoveConfirmationDialog_ = true;
        this.$.ibanSharedActionMenu.get().close();
    }
    onMenuAddVirtualCardClick_() {
        this.paymentsManager_.addVirtualCard(this.activeCreditCard_.guid);
        this.$.creditCardSharedMenu.close();
        this.activeCreditCard_ = null;
    }
    onMenuRemoveVirtualCardClick_() {
        this.showVirtualCardUnenrollDialog_ = true;
        this.$.creditCardSharedMenu.close();
    }
    onVirtualCardUnenrollDialogClose_() {
        this.showVirtualCardUnenrollDialog_ = false;
        this.activeCreditCard_ = null;
    }
    /**
     * Records changes made to the "Allow sites to check if you have payment
     * methods saved" setting to a histogram.
     */
    onCanMakePaymentChange_() {
        MetricsBrowserProxyImpl.getInstance().recordSettingsPageHistogram(PrivacyElementInteractions.PAYMENT_METHOD);
    }
    /**
     * Listens for the save-credit-card event, and calls the private API.
     */
    saveCreditCard_(event) {
        this.paymentsManager_.saveCreditCard(event.detail);
    }
    onSaveIban_(event) {
        this.paymentsManager_.saveIban(event.detail);
    }
    getMenuEditCardText_(isLocalCard) {
        return this.i18n(isLocalCard ? 'edit' : 'editServerCard');
    }
    shouldShowAddVirtualCardButton_() {
        if (this.activeCreditCard_ === null || !this.activeCreditCard_.metadata) {
            return false;
        }
        return !!this.activeCreditCard_.metadata.isVirtualCardEnrollmentEligible &&
            !this.activeCreditCard_.metadata.isVirtualCardEnrolled;
    }
    shouldShowRemoveVirtualCardButton_() {
        if (this.activeCreditCard_ === null || !this.activeCreditCard_.metadata) {
            return false;
        }
        return !!this.activeCreditCard_.metadata.isVirtualCardEnrollmentEligible &&
            !!this.activeCreditCard_.metadata.isVirtualCardEnrolled;
    }
    /**
     * Listens for the unenroll-virtual-card event, and calls the private API.
     */
    unenrollVirtualCard_(event) {
        this.paymentsManager_.removeVirtualCard(event.detail);
    }
    // 
    /**
     * Checks if we should disable the mandatory reauth toggle.
     * This method checks that one of the following conditions are met:
     * 1) Pref autofill.credit_card_enabled is false
     * 2) There is no support for device authentication
     * Under any of these circumstances, we should display a disabled mandatory
     * re-auth toggle to the user.
     */
    shouldDisableAuthToggle_(creditCardEnabled) {
        return !creditCardEnabled || !this.deviceAuthAvailable_;
    }
    // 
    focusHeaderControls_() {
        const element = this.shadowRoot.querySelector('.header-aligned-button');
        if (element) {
            focusWithoutInk(element);
        }
    }
    /**
     * Checks for user auth before flipping the mandatory auth toggle.
     */
    onMandatoryAuthToggleChange_(e) {
        const mandatoryAuthToggle = e.target;
        assert(mandatoryAuthToggle);
        // The toggle is reset to the value when it was clicked.
        // It will be flipped afterwards if the user auth is successful.
        mandatoryAuthToggle.checked = !mandatoryAuthToggle.checked;
        this.paymentsManager_.authenticateUserAndFlipMandatoryAuthToggle();
    }
    /**
     * Method to handle the clicking of bulk delete all the CVCs.
     */
    onBulkRemoveCvcClick_() {
        assert(this.cvcStorageAvailable_);
        // Log the metric for user clicking on the bulk delete hyperlink which
        // triggers the dialog window.
        MetricsBrowserProxyImpl.getInstance().recordAction(CvcDeletionUserAction.HYPERLINK_CLICKED);
        this.showBulkRemoveCvcConfirmationDialog_ = true;
    }
    /**
     * Method to bulk delete all the CVCs present on the local DB.
     */
    onShowBulkRemoveCvcConfirmationDialogClose_() {
        assert(this.cvcStorageAvailable_);
        const confirmationDialog = this.shadowRoot.querySelector('#bulkDeleteCvcConfirmDialog');
        assert(confirmationDialog);
        // Log the metric for user either clicking on "Delete" or "Cancel" on the
        // bulk delete dialog window.
        MetricsBrowserProxyImpl.getInstance().recordAction(confirmationDialog.wasConfirmed() ?
            CvcDeletionUserAction.DIALOG_ACCEPTED :
            CvcDeletionUserAction.DIALOG_CANCELLED);
        if (confirmationDialog.wasConfirmed()) {
            this.paymentsManager_.bulkDeleteAllCvcs();
        }
        this.showBulkRemoveCvcConfirmationDialog_ = false;
        // Focus on the CVC storage toggle, post deletion of CVCs for voice reader
        // correctness.
        const cvcStorageToggle = this.shadowRoot.querySelector('#cvcStorageToggle');
        assert(cvcStorageToggle);
        cvcStorageToggle.focus();
    }
    /**
     * Method to return the correct sublabel for the cvc storage toggle.
     * If any card from the list has a cvc, the sublabel with bulk delete
     * hyperlink is returned else return the regular sublabel.
     * @returns Cvc storage toggle sublabel string.
     */
    getCvcStorageSublabel_() {
        const card = this.creditCards.find(cc => !!cc.cvc);
        return this.i18nAdvanced(card === undefined ? 'enableCvcStorageSublabel' :
            'enableCvcStorageDeleteDataSublabel');
    }
    /**
     * Opens an article to learn about card benefits when the card benefits toggle
     * sublabel link is clicked.
     */
    onCardBenefitsSublabelLinkClick_() {
        OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString('cardBenefitsToggleLearnMoreUrl'));
    }
    /**
     * Get the CVC storage toggle aria label for a11y voice readers.
     * @returns CVC storage aria label.
     */
    getCvcStorageAriaLabel_() {
        const card = this.creditCards.find(cc => !!cc.cvc);
        return this.i18n(card === undefined ? 'enableCvcStorageAriaLabelForNoCvcSaved' :
            'enableCvcStorageLabel');
    }
    /**
     * Opens an article to learn about pay over time when the pay over time
     * toggle sublabel link is clicked.
     */
    onPayOverTimeSublabelLinkClick_() {
        OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString('autofillPayOverTimeSettingsLearnMoreUrl'));
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsPaymentsSectionElement.is, SettingsPaymentsSectionElement);

function getTemplate$22() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{--cr-section-padding:0;--shown-avatar-size:40px}#avatarRow{max-width:280px}#userInfo{padding-top:0;padding-bottom:0}.account-icon{border-radius:50%;flex-shrink:0;height:var(--shown-avatar-size);width:var(--shown-avatar-size)}</style>

<template is="dom-if" if="[[shouldShowAccountIndicator_]]" restamp>
  <div id="avatarRow" class="cr-row first two-line">
    <img class="account-icon" alt=""
        src="[[getProfileImageSrc_(shownAccount_.avatarImage)]]">
    <div id="userInfo" class="cr-row-gap cr-padded-text flex no-min-width">
      <div class="text-elide">[[shownAccount_.fullName]]</div>
      <div class="text-elide secondary">[[shownAccount_.email]]</div>
    </div>
  </div>
</template><!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Returns true if the deletion will affect account data. This is only the case
 * if the user is signed in to Chrome with valid credentials. If the user is
 * only signed in to the content area or if they need to re-authenticate (signed
 * in paused state), then account data will not be deleted.
 */
function canDeleteAccountData(syncStatus) {
    return isSignedIn(syncStatus) &&
        syncStatus.signedInState !== SignedInState.SIGNED_IN_PAUSED &&
        !isSyncPaused(syncStatus);
}
/** Returns true if the user is signed in to a Google account on Chrome. */
function isSignedIn(syncStatus) {
    if (!syncStatus) {
        return false;
    }
    switch (syncStatus.signedInState) {
        case SignedInState.SIGNED_IN_PAUSED:
        case SignedInState.SIGNED_IN:
        case SignedInState.SYNCING:
            return true;
        case SignedInState.WEB_ONLY_SIGNED_IN:
        case SignedInState.SIGNED_OUT:
            return false;
        default:
            assertNotReached('Invalid SignedInState');
    }
}
function isSyncPaused(syncStatus) {
    return !!syncStatus.hasError && !syncStatus.hasUnrecoverableError &&
        syncStatus.statusAction === StatusAction.REAUTHENTICATE;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-clear-browsing-data-account-indicator' is an
 * indicator that informs users of the primary signed-in account.
 */
const SettingsClearBrowsingDataAccountIndicatorBase = WebUiListenerMixin(PolymerElement);
class SettingsClearBrowsingDataAccountIndicator extends SettingsClearBrowsingDataAccountIndicatorBase {
    static get is() {
        return 'settings-clear-browsing-data-account-indicator';
    }
    static get template() {
        return getTemplate$22();
    }
    static get properties() {
        return {
            shouldShowAccountIndicator_: {
                type: Boolean,
                value: false,
                computed: 'computeShouldShowAvatarRow_(shownAccount_,' +
                    'syncStatus_.signedInState)',
            },
            /**
             * The primary signed-in account.
             */
            shownAccount_: String,
            /**
             * The current sync status, supplied by SyncBrowserProxy.
             */
            syncStatus_: Object,
        };
    }
    syncBrowserProxy_ = SyncBrowserProxyImpl.getInstance();
    ready() {
        super.ready();
        this.syncBrowserProxy_.getStoredAccounts().then(this.handleStoredAccounts_.bind(this));
        this.syncBrowserProxy_.getSyncStatus().then(this.handleSyncStatus_.bind(this));
        this.addWebUiListener('stored-accounts-updated', this.handleStoredAccounts_.bind(this));
        this.addWebUiListener('sync-status-changed', this.handleSyncStatus_.bind(this));
    }
    /**
     * Computes the shown account from the StoredAccounts list. The shown account
     * is the primary account which is the first element in the StoredAccounts
     * list.
     */
    handleStoredAccounts_(accounts) {
        if (!accounts) {
            this.shownAccount_ = null;
            return;
        }
        this.shownAccount_ = (accounts.length > 0) ? accounts[0] : null;
    }
    handleSyncStatus_(syncStatus) {
        this.syncStatus_ = syncStatus;
    }
    /**
     * Determines when the account indicator should be shown, in the case where
     * account data would be deleted.
     */
    computeShouldShowAvatarRow_() {
        if (!this.shownAccount_) {
            return false;
        }
        return canDeleteAccountData(this.syncStatus_);
    }
    getProfileImageSrc_() {
        assert(this.shownAccount_);
        // image can be undefined if the account has not set an avatar photo.
        return this.shownAccount_.avatarImage ||
            'chrome://theme/IDR_PROFILE_AVATAR_PLACEHOLDER_LARGE';
    }
}
customElements.define(SettingsClearBrowsingDataAccountIndicator.is, SettingsClearBrowsingDataAccountIndicator);

const styleMod$3 = document.createElement('dom-module');
styleMod$3.appendChild(html `
  <template>
    <style>
.spinner{--cr-spinner-size:28px;mask-image:url(//resources/images/throbber_small.svg);mask-position:center;mask-repeat:no-repeat;mask-size:var(--cr-spinner-size) var(--cr-spinner-size);background-color:var(--cr-spinner-color,var(--google-blue-500));height:var(--cr-spinner-size);width:var(--cr-spinner-size)}@media (prefers-color-scheme:dark){.spinner{background-color:var(--cr-spinner-color,var(--google-blue-300))}}
    </style>
  </template>
`.content);
styleMod$3.register('cr-spinner-style');

function getTemplate$21() {
    return html `<!--_html_template_start_--><style include="settings-shared"></style>

<cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title">$i18n{historyDeletionDialogTitle}</div>
  <div slot="body">$i18nRaw{historyDeletionDialogBody}</div>
  <div slot="button-container">
    <cr-button id="okButton" class="action-button" on-click="onOkClick_">
      $i18n{historyDeletionDialogOK}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-history-deletion-dialog' is a dialog that is
 * optionally shown inside settings-clear-browsing-data-dialog after deleting
 * browsing history. It informs the user about the existence of other forms
 * of browsing history in their account.
 */
class SettingsHistoryDeletionDialogElement extends PolymerElement {
    static get is() {
        return 'settings-history-deletion-dialog';
    }
    static get template() {
        return getTemplate$21();
    }
    /** Click handler for the "OK" button. */
    onOkClick_() {
        this.$.dialog.close();
    }
}
customElements.define(SettingsHistoryDeletionDialogElement.is, SettingsHistoryDeletionDialogElement);

function getTemplate$20() {
    return html `<!--_html_template_start_--><cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title">$i18n{passwordsDeletionDialogTitle}</div>
  <div slot="body">$i18nRaw{passwordsDeletionDialogBody}</div>
  <div slot="button-container">
    <cr-button class="action-button" on-click="onOkClick_">
      $i18n{ok}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-passwords-deletion-dialog' is a dialog that is
 * optionally shown inside settings-clear-browsing-data-dialog after deleting
 * passwords. It informs the user that not all password deletions were completed
 * successfully.
 */
class SettingsPasswordsDeletionDialogElement extends PolymerElement {
    static get is() {
        return 'settings-passwords-deletion-dialog';
    }
    static get template() {
        return getTemplate$20();
    }
    /** Click handler for the "OK" button. */
    onOkClick_() {
        this.$.dialog.close();
    }
}
customElements.define(SettingsPasswordsDeletionDialogElement.is, SettingsPasswordsDeletionDialogElement);

function getTemplate$1$() {
    return html `<!--_html_template_start_--><style include="cr-shared-style">#outerRow{align-items:center;display:flex;min-height:var(--cr-section-two-line-min-height);width:100%}#outerRow[noSubLabel]{min-height:var(--cr-section-min-height)}cr-checkbox{margin-bottom:4px;margin-top:var(--settings-checkbox-margin-top,4px);width:100%}cr-policy-pref-indicator{margin-inline-start:var(--cr-controlled-by-spacing)}a{color:var(--cr-link-color)}</style>
<div id="outerRow" noSubLabel$="[[!hasSubLabel_(subLabel, subLabelHtml)]]">
  <cr-checkbox id="checkbox" checked="{{checked}}"
      on-change="notifyChangedByUserInteraction"
      disabled="[[controlDisabled(disabled, pref.*)]]"
      aria-label="[[label]]">
    <div id="label">[[label]] <slot></slot></div>
    <div id="subLabel" class="cr-secondary-text">
      <div inner-h-t-m-l="[[sanitizeInnerHtml_(subLabelHtml)]]"
          on-click="onSubLabelClick_"></div>
      [[subLabel]]
    </div>
  </cr-checkbox>
  <template is="dom-if" if="[[pref.controlledBy]]">
    <cr-policy-pref-indicator pref="[[pref]]" icon-aria-label="[[label]]">
    </cr-policy-pref-indicator>
  </template>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * `settings-checkbox` is a checkbox that controls a supplied preference.
 */
const SettingsCheckboxElementBase = SettingsBooleanControlMixin(PolymerElement);
class SettingsCheckboxElement extends SettingsCheckboxElementBase {
    static get is() {
        return 'settings-checkbox';
    }
    static get template() {
        return getTemplate$1$();
    }
    static get properties() {
        return {
            /**
             * Alternative source for the sub-label that can contain html markup.
             * Only use with trusted input.
             */
            subLabelHtml: {
                type: String,
                value: '',
            },
        };
    }
    static get observers() {
        return [
            'onSubLabelChanged_(subLabel, subLabelHtml)',
        ];
    }
    /** Focus on the inner cr-checkbox. */
    focus() {
        this.$.checkbox.focus();
    }
    onSubLabelChanged_() {
        this.$.checkbox.ariaDescription = this.$.subLabel.textContent;
    }
    stopPropagation_(event) {
        event.stopPropagation();
    }
    hasSubLabel_(subLabel, subLabelHtml) {
        return !!subLabel || !!subLabelHtml;
    }
    sanitizeInnerHtml_(rawString) {
        return sanitizeInnerHtml(rawString, {
            attrs: [
                'id',
                'aria-label',
            ],
        });
    }
    onSubLabelClick_(e) {
        const target = e.target;
        if (target.tagName === 'A') {
            this.dispatchEvent(new CustomEvent('sub-label-link-clicked', { bubbles: true, composed: true, detail: { id: target.id } }));
            e.preventDefault();
            // Don't let link click events from the sub-label reach the checkbox.
            e.stopPropagation();
        }
    }
}
customElements.define(SettingsCheckboxElement.is, SettingsCheckboxElement);

function getTemplate$1_() {
    return html `<!--_html_template_start_-->    <style include="settings-shared cr-spinner-style">:host{--body-container-height:322px}#clearBrowsingDataDialog{--border-top-color:var(--google-grey-300);--cr-dialog-top-container-min-height:42px;--cr-dialog-body-border-top:1px solid var(--border-top-color)}@media (prefers-color-scheme:dark){#clearBrowsingDataDialog{--border-top-color:var(--cr-separator-color)}}#clearBrowsingDataDialog:not(.fully-rendered){visibility:hidden}#clearBrowsingDataDialog [slot=title]{padding-bottom:8px}#clearBrowsingDataDialog::part(body-container){height:var(--body-container-height);min-height:200px}#clearBrowsingDataDialog [slot=body]{padding-top:8px}#clearBrowsingDataDialog [slot=footer]{background:var(--google-grey-50);border-top:none;padding:0}@media (prefers-color-scheme:dark){#clearBrowsingDataDialog [slot=footer]{background:rgb(50,54,57)}}.row{align-items:center;display:flex;min-height:40px}.spinner{margin-bottom:auto;margin-inline-end:16px;margin-top:auto}settings-checkbox{--cr-section-two-line-min-height:48px}#basicTab settings-checkbox+settings-checkbox{--settings-checkbox-margin-top:12px}cr-tabs{--cr-tabs-font-size:100%;--cr-tabs-height:40px}.time-range-row{margin-bottom:12px}.time-range-select{margin-inline-start:12px}.dropdown-error::part(select){border-color:var(--settings-error-color);color:var(--settings-error-color)}.dropdown-error::part(select):focus{outline-color:var(--settings-error-color)}[slot=title] .secondary{font-size:calc(13 / 15 * 100%);padding-top:8px}.divider{border-top:var(--cr-separator-line);margin:0 16px}#footerDescription{color:var(--cr-secondary-text-color);padding:16px}#clearingDataAlert{clip:rect(0,0,0,0);position:fixed}.search-history-box{background-color:var(--google-grey-50);border:1px solid var(--google-grey-200);border-radius:4px;display:flex;margin-top:12px;padding:8px}@media (prefers-color-scheme:dark){.search-history-box{background-color:rgba(0,0,0,.3);border-color:transparent}}.search-history-box-icon{--iron-icon-fill-color:var(--cr-link-row-start-icon-color,var(--google-grey-700));display:flex;flex-shrink:0;margin:auto;padding-inline-end:10px;width:var(--cr-link-row-icon-width,var(--cr-icon-size))}@media (prefers-color-scheme:dark){.search-history-box-icon{--iron-icon-fill-color:var(--cr-link-row-start-icon-color,var(--google-grey-500))}}#nonGoogleSearchHistoryBox{margin-bottom:16px}
    </style>

    <cr-dialog id="clearBrowsingDataDialog"
        close-text="$i18n{close}" ignore-popstate has-tabs ignore-enter-key>
      <div slot="title">
        <div>$i18n{clearBrowsingData}</div>
      </div>
      <div slot="header">
        <cr-tabs id="tabs" tab-names="[[tabsNames_]]"
            selected="{{selectedTabIndex_}}"
            on-selected-changed="recordTabChange_">
        </cr-tabs>
      </div>
      <div slot="body">
        <cr-page-selector id="pages" selected="[[selectedTabIndex_]]"
            on-iron-select="updateClearButtonState_">
          <div id="basicTab">
            <div class="row time-range-row">
              <span class="time-range-label" aria-hidden="true">
                $i18n{clearTimeRange}
              </span>
              <settings-dropdown-menu id="clearFromBasic" no-set-pref
                  class="time-range-select"
                  label="$i18n{clearTimeRange}"
                  pref="{{prefs.browser.clear_data.time_period_basic}}"
                  menu-options="[[clearFromOptions_]]"
                  on-settings-control-change="onTimePeriodChanged_">
              </settings-dropdown-menu>
            </div>
            <!-- Note: whether these checkboxes are checked are ignored if
                 deleting history is disabled (i.e. supervised users, policy),
                 so it's OK to have a hidden checkbox that's also checked (as
                 the C++ accounts for whether a user is allowed to delete
                 history independently). -->
            <settings-checkbox id="browsingCheckboxBasic"
                pref="{{prefs.browser.clear_data.browsing_history_basic}}"
                label="$i18n{clearBrowsingHistory}"
                sub-label-html="[[browsingCheckboxLabel_(isSyncingHistory_,
                    '$i18nPolymer{clearBrowsingHistorySummary}',
                    '$i18nPolymer{clearBrowsingHistorySummarySignedInNoLink}'
                    )]]"
                disabled="[[clearingInProgress_]]"
                no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="cookiesCheckboxBasic"
                class="cookies-checkbox"
                pref="{{prefs.browser.clear_data.cookies_basic}}"
                label="$i18n{clearCookies}"
                sub-label="[[cookiesCheckboxLabel_(
                    syncStatus.signedInState,
                    shouldShowCookieException_,
                    '$i18nPolymer{clearCookiesSummary}',
                    '$i18nPolymer{clearCookiesSummarySignedIn}',
                    '$i18nPolymer{clearCookiesSummarySyncing}',
                    '$i18nPolymer{clearCookiesSummarySignedInSupervisedProfile}'
                    )]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="cacheCheckboxBasic"
                class="cache-checkbox"
                pref="{{prefs.browser.clear_data.cache_basic}}"
                label="$i18n{clearCache}"
                sub-label="[[counters_.cache_basic]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <div class="search-history-box"
                hidden="[[!showSearchHistoryBox_(syncStatus.signedInState)]]">
              <cr-icon class="search-history-box-icon" aria-hidden="true"
                  icon="settings20:googleg">
              </cr-icon>
              <div id="googleSearchHistoryLabel"
                  inner-h-t-m-l="[[googleSearchHistoryString_]]">
              </div>
            </div>
            <div id="nonGoogleSearchHistoryBox"
                class="search-history-box"
                hidden="[[!isNonGoogleDse_]]">
              <cr-icon class="search-history-box-icon" aria-hidden="true"
                  icon="cr:search">
              </cr-icon>
              <div id="nonGoogleSearchHistoryLabel"
                  inner-h-t-m-l="[[nonGoogleSearchHistoryString_]]">
              </div>
            </div>
          </div>
          <div id="advancedTab">
            <div class="row time-range-row">
              <span class="time-range-label" aria-hidden="true">
                $i18n{clearTimeRange}
              </span>
              <settings-dropdown-menu id="clearFrom" no-set-pref
                  class="time-range-select"
                  label="$i18n{clearTimeRange}"
                  pref="{{prefs.browser.clear_data.time_period}}"
                  menu-options="[[clearFromOptions_]]"
                  on-settings-control-change="onTimePeriodChanged_">
              </settings-dropdown-menu>
            </div>
            <settings-checkbox id="browsingCheckbox"
                pref="{{prefs.browser.clear_data.browsing_history}}"
                label="$i18n{clearBrowsingHistory}"
                sub-label="[[counters_.browsing_history]]"
                disabled="[[clearingInProgress_]]"
                no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="downloadCheckbox"
                pref="{{prefs.browser.clear_data.download_history}}"
                label="$i18n{clearDownloadHistory}"
                sub-label="[[counters_.download_history]]"
                disabled="[[clearingInProgress_]]"
                no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="cookiesCheckbox"
                class="cookies-checkbox"
                pref="{{prefs.browser.clear_data.cookies}}"
                label="$i18n{clearCookies}"
                sub-label="[[counters_.cookies]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="cacheCheckbox"
                class="cache-checkbox"
                pref="{{prefs.browser.clear_data.cache}}"
                label="$i18n{clearCache}"
                sub-label="[[counters_.cache]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox
                pref="{{prefs.browser.clear_data.passwords}}"
                label="$i18n{clearPasswords}"
                sub-label="[[counters_.passwords]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox
                pref="{{prefs.browser.clear_data.form_data}}"
                label="$i18n{clearFormData}"
                sub-label="[[counters_.form_data]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox
                pref="{{prefs.browser.clear_data.site_settings}}"
                label="$i18nPolymer{siteSettings}"
                sub-label="[[counters_.site_settings]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox
                pref="{{prefs.browser.clear_data.hosted_apps_data}}"
                label="$i18n{clearHostedAppData}"
                sub-label="[[counters_.hosted_apps_data]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
          </div>
        </cr-page-selector>
      </div>
      <div slot="button-container">
        <div class="spinner" hidden$="[[!clearingInProgress_]]"></div>
        <cr-button class="cancel-button" autofocus
            disabled="[[clearingInProgress_]]"
            on-click="onCancelClick_">
          $i18n{cancel}
        </cr-button>
        <cr-button id="clearButton" class="action-button"
            on-click="clearBrowsingData_"
            disabled="[[isClearButtonDisabled_(clearingInProgress_,
                                               clearButtonDisabled_)]]">
          $i18n{clearData}
        </cr-button>

        <!-- The alert must be inside the dialog for it to be read while the
             dialog is open. -->
        <div id="clearingDataAlert" role="alert">
          [[clearingDataAlertString_]]
        </div>
      </div>

      <template is="dom-if"
          if="[[shouldShowFooter_(
              syncStatus.signedInState, isClearPrimaryAccountAllowed_)]]"
          restamp>
        <div slot="footer">
          <settings-sync-account-control sync-status="[[syncStatus]]"
              prefs="{{prefs}}" hide-buttons hide-banner>
          </settings-sync-account-control>
          <div class="divider"></div>
          <div id="footerDescription" on-click="onSyncDescriptionLinkClicked_">
            <span id="signinInfo"
                hidden="[[!showSigninInfo_(
                    syncStatus.signedInState, isClearPrimaryAccountAllowed_)]]">
              $i18nRaw{clearBrowsingDataSignedIn}
            </span>
            <span id="syncInfo"
                hidden="[[!showSyncInfo_(
                    syncStatus.signedInState, isClearPrimaryAccountAllowed_)]]">
              $i18nRaw{clearBrowsingDataWithSync}
            </span>
            <span id="syncPausedInfo" hidden="[[!isSyncPaused_]]">
              $i18nRaw{clearBrowsingDataWithSyncPaused}
            </span>
            <span id="syncPassphraseErrorInfo"
                hidden="[[!hasPassphraseError_]]">
              $i18nRaw{clearBrowsingDataWithSyncPassphraseError}
            </span>
            <span id="syncOtherErrorInfo" hidden="[[!hasOtherSyncError_]]">
              $i18nRaw{clearBrowsingDataWithSyncError}
            </span>
          </div>
        </div>
      </template>

    </cr-dialog>

    <template is="dom-if" if="[[showHistoryDeletionDialog_]]" restamp>
      <settings-history-deletion-dialog id="historyNotice"
          on-close="onHistoryDeletionDialogClose_">
      </settings-history-deletion-dialog>
    </template>

    <template is="dom-if" if="[[showPasswordsDeletionDialog_]]" restamp>
      <settings-passwords-deletion-dialog id="passwordsNotice"
          on-close="onPasswordsDeletionDialogClose_">
      </settings-passwords-deletion-dialog>
    </template>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-clear-browsing-data-dialog' allows the user to
 * delete browsing data that has been cached by Chromium.
 */
/**
 * @param dialog the dialog to close
 * @param isLast whether this is the last CBD-related dialog
 */
function closeDialog$1(dialog, isLast) {
    // If this is not the last dialog, then stop the 'close' event from
    // propagating so that other (following) dialogs don't get closed as well.
    if (!isLast) {
        dialog.addEventListener('close', e => {
            e.stopPropagation();
        }, { once: true });
    }
    dialog.close();
}
const SettingsClearBrowsingDataDialogElementBase = RouteObserverMixin(WebUiListenerMixin(PrefsMixin(I18nMixin(PolymerElement))));
class SettingsClearBrowsingDataDialogElement extends SettingsClearBrowsingDataDialogElementBase {
    static get is() {
        return 'settings-clear-browsing-data-dialog';
    }
    static get template() {
        return getTemplate$1_();
    }
    static get properties() {
        return {
            /**
             * The current sync status, supplied by SyncBrowserProxy.
             */
            syncStatus: Object,
            /**
             * Results of browsing data counters, keyed by the suffix of
             * the corresponding data type deletion preference, as reported
             * by the C++ side.
             */
            counters_: {
                type: Object,
                // Will be filled as results are reported.
                value() {
                    return {};
                },
            },
            /**
             * List of options for the dropdown menu.
             */
            clearFromOptions_: {
                readOnly: true,
                type: Array,
                value: [
                    {
                        value: TimePeriod.LAST_HOUR,
                        name: loadTimeData.getString('clearPeriodHour'),
                    },
                    {
                        value: TimePeriod.LAST_DAY,
                        name: loadTimeData.getString('clearPeriod24Hours'),
                    },
                    {
                        value: TimePeriod.LAST_WEEK,
                        name: loadTimeData.getString('clearPeriod7Days'),
                    },
                    {
                        value: TimePeriod.FOUR_WEEKS,
                        name: loadTimeData.getString('clearPeriod4Weeks'),
                    },
                    {
                        value: TimePeriod.ALL_TIME,
                        name: loadTimeData.getString('clearPeriodEverything'),
                    },
                ],
            },
            clearingInProgress_: {
                type: Boolean,
                value: false,
            },
            clearingDataAlertString_: {
                type: String,
                value: '',
            },
            clearButtonDisabled_: {
                type: Boolean,
                value: false,
            },
            showHistoryDeletionDialog_: {
                type: Boolean,
                value: false,
            },
            showPasswordsDeletionDialogLater_: {
                type: Boolean,
                value: false,
            },
            showPasswordsDeletionDialog_: {
                type: Boolean,
                value: false,
            },
            isSyncingHistory_: {
                type: Boolean,
                value: false,
            },
            shouldShowCookieException_: {
                type: Boolean,
                value: false,
            },
            // 
            isClearPrimaryAccountAllowed_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('isClearPrimaryAccountAllowed');
                },
            },
            isSyncPaused_: {
                type: Boolean,
                value: false,
                computed: 'computeIsSyncPaused_(syncStatus)',
            },
            hasPassphraseError_: {
                type: Boolean,
                value: false,
                computed: 'computeHasPassphraseError_(syncStatus)',
            },
            hasOtherSyncError_: {
                type: Boolean,
                value: false,
                computed: 'computeHasOtherError_(syncStatus, isSyncPaused_, hasPassphraseError_)',
            },
            // 
            selectedTabIndex_: Number,
            tabsNames_: {
                type: Array,
                value: () => [loadTimeData.getString('basicPageTitle'),
                    loadTimeData.getString('advancedPageTitle'),
                ],
            },
            googleSearchHistoryString_: {
                type: String,
                computed: 'computeGoogleSearchHistoryString_(isNonGoogleDse_)',
            },
            isNonGoogleDse_: {
                type: Boolean,
                value: false,
            },
            nonGoogleSearchHistoryString_: String,
        };
    }
    static get observers() {
        return [
            `onTimePeriodAdvancedPrefUpdated_(
          prefs.browser.clear_data.time_period.value)`,
            `onTimePeriodBasicPrefUpdated_(
          prefs.browser.clear_data.time_period_basic.value)`,
            `onSelectedTabIndexPrefUpdated_(
          prefs.browser.last_clear_browsing_data_tab.value)`,
        ];
    }
    focusOutlineManager_;
    browserProxy_ = ClearBrowsingDataBrowserProxyImpl.getInstance();
    syncBrowserProxy_ = SyncBrowserProxyImpl.getInstance();
    ready() {
        super.ready();
        this.syncBrowserProxy_.getSyncStatus().then(this.handleSyncStatus_.bind(this));
        this.addWebUiListener('sync-status-changed', this.handleSyncStatus_.bind(this));
        this.addWebUiListener('update-sync-state', this.updateSyncState_.bind(this));
        this.addWebUiListener('browsing-data-counter-text-update', this.updateCounterText_.bind(this));
        this.addEventListener('settings-boolean-control-change', this.updateClearButtonState_);
    }
    connectedCallback() {
        super.connectedCallback();
        this.browserProxy_.initialize().then(() => {
            this.$.clearBrowsingDataDialog.showModal();
            // AutoFocus is not visible in mouse navigation by default. But in this
            // dialog the default focus is on cancel which is not a default button. To
            // make this clear to the user we make it visible to the user and remove
            // the focus after the next mouse event.
            this.focusOutlineManager_ = FocusOutlineManager.forDocument(document);
            this.focusOutlineManager_.visible = true;
            document.addEventListener('mousedown', () => {
                this.focusOutlineManager_.visible = false;
            }, { once: true });
        });
    }
    /**
     * Handler for when the sync state is pushed from the browser.
     */
    handleSyncStatus_(syncStatus) {
        this.syncStatus = syncStatus;
    }
    /**
     * @return Whether either clearing is in progress or no data type is selected.
     */
    isClearButtonDisabled_(clearingInProgress, clearButtonDisabled) {
        return clearingInProgress || clearButtonDisabled;
    }
    /**
     * Disables the Clear Data button if no data type is selected.
     */
    updateClearButtonState_() {
        // on-select-item-changed gets called with undefined during a tab change.
        // https://github.com/PolymerElements/iron-selector/issues/95
        const page = this.$.pages.selectedItem;
        if (!page) {
            return;
        }
        this.clearButtonDisabled_ =
            this.getSelectedDataTypes_(page).length === 0;
    }
    /**
     * Record visits to the CBD dialog.
     *
     * RouteObserverMixin
     */
    currentRouteChanged(currentRoute) {
        if (currentRoute === routes.CLEAR_BROWSER_DATA) {
            chrome.metricsPrivate.recordUserAction('ClearBrowsingData_DialogCreated');
        }
    }
    /**
     * Updates the history description to show the relevant information
     * depending on sync and signin state.
     */
    updateSyncState_(event) {
        this.isSyncingHistory_ = event.syncingHistory;
        this.shouldShowCookieException_ = event.shouldShowCookieException;
        this.$.clearBrowsingDataDialog.classList.add('fully-rendered');
        this.isNonGoogleDse_ = event.isNonGoogleDse;
        this.nonGoogleSearchHistoryString_ =
            sanitizeInnerHtml(event.nonGoogleSearchHistoryString);
    }
    /** Choose a label for the history checkbox. */
    browsingCheckboxLabel_(isSyncingHistory, historySummary, historySummarySignedInNoLink) {
        return isSyncingHistory ? historySummarySignedInNoLink : historySummary;
    }
    /**
     * Choose a label for the cookie checkbox
     * @param signedInState SignedInState
     * @param shouldShowCookieException boolean whether the exception about not
     * being signed out of your Google account should be shown when user is
     * sync.
     * @param cookiesSummary string explaining that deleting cookies and site data
     * will sign the user out of most websites.
     * @param clearCookiesSummarySignedIn string explaining that deleting cookies
     * and site data will sign the user out of most websites but Google sign in
     * will stay.
     * @param clearCookiesSummarySyncing string explaining that deleting cookies
     * and site data will sign the user out of most websites but Google sign in
     * will stay when user is syncing.
     * @param clearCookiesSummarySignedInSupervisedProfile string used for a
     * supervised user. Gives information about family link controls and that they
     * will not be signed out on clearing cookies
     */
    cookiesCheckboxLabel_(signedInState, shouldShowCookieException, cookiesSummary, clearCookiesSummarySignedIn, clearCookiesSummarySyncing, 
    // 
    clearCookiesSummarySignedInSupervisedProfile) {
        // 
        if (loadTimeData.getBoolean('isChildAccount')) {
            return clearCookiesSummarySignedInSupervisedProfile;
        }
        // 
        // The exception is not shown for SIGNED_IN_PAUSED.
        if (signedInState === SignedInState.SIGNED_IN) {
            return clearCookiesSummarySignedIn;
        }
        if (shouldShowCookieException) {
            return clearCookiesSummarySyncing;
        }
        return cookiesSummary;
    }
    /**
     * Updates the text of a browsing data counter corresponding to the given
     * preference.
     * @param prefName Browsing data type deletion preference.
     * @param text The text with which to update the counter
     */
    updateCounterText_(prefName, text) {
        // Data type deletion preferences are named "browser.clear_data.<datatype>".
        // Strip the common prefix, i.e. use only "<datatype>".
        const matches = prefName.match(/^browser\.clear_data\.(\w+)$/);
        assert(matches[1]);
        this.set('counters_.' + matches[1], text);
    }
    /**
     * @return A list of selected data types.
     */
    getSelectedDataTypes_(page) {
        const checkboxes = page.querySelectorAll('settings-checkbox');
        const dataTypes = [];
        checkboxes.forEach((checkbox) => {
            if (checkbox.checked && !checkbox.hidden) {
                dataTypes.push(checkbox.pref.key);
            }
        });
        return dataTypes;
    }
    getTimeRangeDropdownForCurrentPage_() {
        const page = this.$.pages.selectedItem;
        const dropdownMenu = page.querySelector('.time-range-select');
        assert(dropdownMenu);
        return dropdownMenu;
    }
    isBasicTabSelected_() {
        const page = this.$.pages.selectedItem;
        assert(page);
        switch (page.id) {
            case 'basicTab':
                return true;
            case 'advancedTab':
                return false;
            default:
                assertNotReached();
        }
    }
    /** Clears browsing data and maybe shows a history notice. */
    async clearBrowsingData_() {
        this.clearingInProgress_ = true;
        this.clearingDataAlertString_ = loadTimeData.getString('clearingData');
        const page = this.$.pages.selectedItem;
        const dataTypes = this.getSelectedDataTypes_(page);
        const dropdownMenu = this.getTimeRangeDropdownForCurrentPage_();
        const timePeriod = Number(dropdownMenu.getSelectedValue());
        if (this.isBasicTabSelected_()) {
            chrome.metricsPrivate.recordUserAction('ClearBrowsingData_BasicTab');
            this.browserProxy_
                .recordSettingsClearBrowsingDataBasicTimePeriodHistogram(timePeriod);
        }
        else {
            // Advanced tab.
            chrome.metricsPrivate.recordUserAction('ClearBrowsingData_AdvancedTab');
            this.browserProxy_
                .recordSettingsClearBrowsingDataAdvancedTimePeriodHistogram(timePeriod);
        }
        this.setPrefValue('browser.last_clear_browsing_data_tab', this.selectedTabIndex_);
        // Dropdown menu and checkbox selections of both tabs should be persisted
        // independently from the tab on which the user confirmed the deletion.
        this.shadowRoot
            .querySelectorAll('settings-checkbox[no-set-pref]')
            .forEach(checkbox => checkbox.sendPrefChange());
        this.shadowRoot
            .querySelectorAll('settings-dropdown-menu[no-set-pref]')
            .forEach(dropdown => dropdown.sendPrefChange());
        const { showHistoryNotice, showPasswordsNotice } = await this.browserProxy_.clearBrowsingData(dataTypes, dropdownMenu.pref.value);
        this.clearingInProgress_ = false;
        getInstance().announce(loadTimeData.getString('clearedData'));
        this.showHistoryDeletionDialog_ = showHistoryNotice;
        // If both the history notice and the passwords notice should be shown, show
        // the history notice first, and then show the passwords notice once the
        // history notice gets closed.
        this.showPasswordsDeletionDialog_ =
            showPasswordsNotice && !showHistoryNotice;
        this.showPasswordsDeletionDialogLater_ =
            showPasswordsNotice && showHistoryNotice;
        // Close the clear browsing data if it is open.
        const isLastDialog = !showHistoryNotice && !showPasswordsNotice;
        if (this.$.clearBrowsingDataDialog.open) {
            closeDialog$1(this.$.clearBrowsingDataDialog, isLastDialog);
        }
    }
    onCancelClick_() {
        this.$.clearBrowsingDataDialog.cancel();
    }
    /**
     * Handles the closing of the notice about other forms of browsing history.
     */
    onHistoryDeletionDialogClose_(e) {
        this.showHistoryDeletionDialog_ = false;
        if (this.showPasswordsDeletionDialogLater_) {
            // Stop the close event from propagating further and also automatically
            // closing other dialogs.
            e.stopPropagation();
            this.showPasswordsDeletionDialogLater_ = false;
            this.showPasswordsDeletionDialog_ = true;
        }
    }
    /**
     * Handles the closing of the notice about incomplete passwords deletion.
     */
    onPasswordsDeletionDialogClose_() {
        this.showPasswordsDeletionDialog_ = false;
    }
    onSelectedTabIndexPrefUpdated_(selectedTabIndex) {
        this.selectedTabIndex_ = selectedTabIndex;
    }
    /**
     * Records an action when the user changes between the basic and advanced tab.
     */
    recordTabChange_(event) {
        if (event.detail.value === 0) {
            chrome.metricsPrivate.recordUserAction('ClearBrowsingData_SwitchTo_BasicTab');
        }
        else {
            chrome.metricsPrivate.recordUserAction('ClearBrowsingData_SwitchTo_AdvancedTab');
        }
    }
    // 
    /** Called when the user clicks the link in the footer. */
    onSyncDescriptionLinkClicked_(e) {
        if (e.target.tagName === 'A') {
            e.preventDefault();
            if (this.showSigninInfo_()) {
                chrome.metricsPrivate.recordUserAction('ClearBrowsingData_SignOut');
                this.syncBrowserProxy_.signOut(/*delete_profile=*/ false);
            }
            else if (this.showSyncInfo_()) {
                chrome.metricsPrivate.recordUserAction('ClearBrowsingData_Sync_Pause');
                this.syncBrowserProxy_.pauseSync();
            }
            else if (this.isSyncPaused_) {
                chrome.metricsPrivate.recordUserAction('ClearBrowsingData_Sync_SignIn');
                this.syncBrowserProxy_.startSignIn();
            }
            else {
                if (this.hasPassphraseError_) {
                    chrome.metricsPrivate.recordUserAction('ClearBrowsingData_Sync_NavigateToPassphrase');
                }
                else {
                    chrome.metricsPrivate.recordUserAction('ClearBrowsingData_Sync_NavigateToError');
                }
                // In any other error case, navigate to the sync page.
                Router.getInstance().navigateTo(routes.SYNC);
            }
        }
    }
    computeIsSyncPaused_() {
        return !!this.syncStatus.hasError &&
            !this.syncStatus.hasUnrecoverableError &&
            this.syncStatus.statusAction === StatusAction.REAUTHENTICATE;
    }
    computeHasPassphraseError_() {
        return !!this.syncStatus.hasError &&
            this.syncStatus.statusAction === StatusAction.ENTER_PASSPHRASE;
    }
    computeHasOtherError_() {
        return this.syncStatus !== undefined && !!this.syncStatus.hasError &&
            !this.isSyncPaused_ && !this.hasPassphraseError_;
    }
    // 
    computeGoogleSearchHistoryString_(isNonGoogleDse) {
        return isNonGoogleDse ?
            this.i18nAdvanced('clearGoogleSearchHistoryNonGoogleDse') :
            this.i18nAdvanced('clearGoogleSearchHistoryGoogleDse');
    }
    // 
    shouldShowFooter_() {
        if (!this.syncStatus) {
            return false;
        }
        switch (this.syncStatus.signedInState) {
            case SignedInState.SIGNED_IN:
                return this.isClearPrimaryAccountAllowed_;
            case SignedInState.SYNCING:
                return true;
            case SignedInState.WEB_ONLY_SIGNED_IN:
            case SignedInState.SIGNED_OUT:
            case SignedInState.SIGNED_IN_PAUSED:
            default:
                return false;
        }
    }
    /**
     * @return Whether the signed info description should be shown in the footer.
     */
    showSigninInfo_() {
        if (!this.syncStatus) {
            return false;
        }
        return this.syncStatus.signedInState === SignedInState.SIGNED_IN &&
            this.isClearPrimaryAccountAllowed_;
    }
    /**
     * @return Whether the synced info description should be shown in the footer.
     */
    showSyncInfo_() {
        if (!this.syncStatus) {
            return false;
        }
        return !this.showSigninInfo_() && !this.syncStatus.hasError;
    }
    // 
    /**
     * @return Whether the search history box should be shown.
     */
    showSearchHistoryBox_() {
        if (!this.syncStatus) {
            return false;
        }
        switch (this.syncStatus.signedInState) {
            case SignedInState.SIGNED_IN_PAUSED:
            case SignedInState.SIGNED_IN:
            case SignedInState.SYNCING:
                return true;
            case SignedInState.WEB_ONLY_SIGNED_IN:
            case SignedInState.SIGNED_OUT:
            default:
                return false;
        }
    }
    onTimePeriodChanged_() {
        const dropdownMenu = this.getTimeRangeDropdownForCurrentPage_();
        const timePeriod = parseInt(dropdownMenu.getSelectedValue(), 10);
        assert(!Number.isNaN(timePeriod));
        this.browserProxy_.restartCounters(this.isBasicTabSelected_(), timePeriod);
    }
    onTimePeriodAdvancedPrefUpdated_() {
        this.onTimePeriodPrefUpdated_(false);
    }
    onTimePeriodBasicPrefUpdated_() {
        this.onTimePeriodPrefUpdated_(true);
    }
    onTimePeriodPrefUpdated_(isBasic) {
        const timePeriodPref = isBasic ? 'browser.clear_data.time_period_basic' :
            'browser.clear_data.time_period';
        const timePeriodValue = this.getPref(timePeriodPref).value;
        if (!this.clearFromOptions_.find(timePeriodOption => timePeriodOption.value === timePeriodValue)) {
            // If the synced time period is not supported, default to "Last hour".
            this.setPrefValue(timePeriodPref, TimePeriod.LAST_HOUR);
        }
    }
}
customElements.define(SettingsClearBrowsingDataDialogElement.is, SettingsClearBrowsingDataDialogElement);

function getTemplate$1Z() {
    return html `<!--_html_template_start_--><style>:host{--cr-menu-border-radius:12px}#timePicker{max-width:512px}.dropdown-item{padding:4px 16px}.row{align-items:center;display:flex}.time-period-chip{margin-inline-end:5px}</style>

<div class="row" id="timePicker">
  <template is="dom-repeat" items="[[expandedOptionList_]]"
      on-dom-change="onTimePickerDomChanged_">
    <cr-chip class="time-period-chip"
        selected="[[isTimePeriodSelected_(item.value)]]"
        on-click="onTimePeriodSelected_">
      <cr-icon icon="cr:check" hidden="[[!isTimePeriodSelected_(item.value)]]">
      </cr-icon>
      [[item.label]]
    </cr-chip>
  </template>
  <cr-chip id="moreButton" hidden="[[!moreOptionList_.length]]"
      on-click="onMoreTimePeriodsButtonClick_">
    $i18n{clearBrowsingDataMore}
    <cr-icon icon="cr:arrow-drop-down"></cr-icon>
  </cr-chip>
  <cr-lazy-render id="moreTimePeriodsMenu">
    <template>
      <cr-action-menu role-description="$i18n{menu}"
          on-close="onMoreOptionsMenuClose_">
        <template is="dom-repeat" items="[[moreOptionList_]]">
          <button class="dropdown-item" on-click="onMenuTimePeriodSelected_">
            [[item.label]]
          </button>
        </template>
      </cr-action-menu>
    </template>
  </cr-lazy-render>
</div><!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-clear-browsing-data-time-picker' is a control that
 * displays time period options for 'settings-clear-browsing-data-dialog-v2'.
 */
/** The offset between the 'More' button and the dropdown menu. */
const MENU_VERTICAL_OFFSET_PX = 5;
function getTimePeriodString(timePeriod, short = true) {
    switch (timePeriod) {
        case TimePeriod.LAST_15_MINUTES:
            return short ? loadTimeData.getString('clearPeriod15Min') :
                loadTimeData.getString('clearPeriod15Minutes');
        case TimePeriod.LAST_HOUR:
            return loadTimeData.getString('clearPeriodHour');
        case TimePeriod.LAST_DAY:
            return loadTimeData.getString('clearPeriod24Hours');
        case TimePeriod.LAST_WEEK:
            return loadTimeData.getString('clearPeriod7Days');
        case TimePeriod.FOUR_WEEKS:
            return loadTimeData.getString('clearPeriod4Weeks');
        case TimePeriod.ALL_TIME:
            return loadTimeData.getString('clearPeriodEverything');
        default:
            assertNotReachedCase();
    }
}
const SettingsClearBrowsingDataTimePickerBase = PrefsMixin(PolymerElement);
class SettingsClearBrowsingDataTimePicker extends SettingsClearBrowsingDataTimePickerBase {
    static get is() {
        return 'settings-clear-browsing-data-time-picker';
    }
    static get template() {
        return getTemplate$1Z();
    }
    static get properties() {
        return {
            selectedTimePeriod_: {
                type: Number,
                observer: 'onTimePeriodSelectionChanged_',
                value: TimePeriod.LAST_HOUR,
            },
            /**
             * The list of all available Time Periods ordered by duration in ascending
             * order.
             */
            allTimePeriodList_: {
                readOnly: true,
                type: Array,
                value: [
                    TimePeriod.LAST_15_MINUTES,
                    TimePeriod.LAST_HOUR,
                    TimePeriod.LAST_DAY,
                    TimePeriod.LAST_WEEK,
                    TimePeriod.FOUR_WEEKS,
                    TimePeriod.ALL_TIME,
                ],
            },
            /**
             * The list of Time Period options that are expanded by default, these
             * should include the currently selected time period.
             */
            expandedOptionList_: {
                type: Array,
                computed: 'computeExpandedOptionList_(maxChipsShown_, selectedTimePeriod_)',
            },
            /**
             * The list of Time Period options that are hidden in the 'More' dropdown
             * menu.
             */
            moreOptionList_: {
                type: Array,
                computed: 'computeMoreOptionList_(expandedOptionList_)',
            },
            /**
               Maximum number of expanded chips to be shown, this should be less than
               or equal to the `allTimePeriodList_.length` and greater than 0.
             */
            maxChipsShown_: {
                type: Number,
                value: 4,
            },
        };
    }
    static get observers() {
        return [
            'onTimePeriodPrefUpdated_(prefs.browser.clear_data.time_period.value)',
        ];
    }
    onTimePeriodPrefUpdated_() {
        const timePeriodValue = this.getPref('browser.clear_data.time_period').value;
        if (timePeriodValue in TimePeriod &&
            timePeriodValue !== this.selectedTimePeriod_) {
            this.selectedTimePeriod_ = timePeriodValue;
        }
    }
    onTimePeriodSelectionChanged_() {
        // Dispatch a |selected-time-period-change| event to notify that the
        // currently selected time period has changed due to an explicit user
        // selection or a pref change.
        this.dispatchEvent(new CustomEvent('selected-time-period-change', { bubbles: true, composed: true }));
    }
    computeExpandedOptionList_() {
        const expandedOptionsList = [];
        let selectedTimePeriodAdded = false;
        // Add the TimePeriods to the expanded options list up to maxChipsShow_, but
        // keep one slot for potentially the selected TimePeriod.
        for (let i = 0; i < this.maxChipsShown_ - 1; i++) {
            const timePeriod = this.allTimePeriodList_[i];
            selectedTimePeriodAdded ||= (timePeriod === this.selectedTimePeriod_);
            expandedOptionsList.push({ value: timePeriod, label: getTimePeriodString(timePeriod) });
        }
        // If the selected option is already added to the expandedOptionsList,
        // add another TimePeriod from the allTimePeriodList_ to fill the
        // maxChipsShown_ quota, otherwise add the selected time period.
        if (selectedTimePeriodAdded) {
            const timePeriod = this.allTimePeriodList_[this.maxChipsShown_ - 1];
            expandedOptionsList.push({
                value: timePeriod,
                label: getTimePeriodString(timePeriod),
            });
        }
        else {
            expandedOptionsList.push({
                value: this.selectedTimePeriod_,
                label: getTimePeriodString(this.selectedTimePeriod_),
            });
        }
        return expandedOptionsList;
    }
    computeMoreOptionList_() {
        const expandedTimePeriodsList = this.expandedOptionList_.map((option) => option.value);
        const moreOptionsList = [];
        // Add all options that were not included in the expandedOptionList_.
        this.allTimePeriodList_.forEach((timePeriod) => {
            if (!expandedTimePeriodsList.includes(timePeriod)) {
                moreOptionsList.push({ value: timePeriod, label: getTimePeriodString(timePeriod) });
            }
        });
        return moreOptionsList;
    }
    onTimePickerDomChanged_() {
        // Decrease the number of visible chips if the current expanded chips' width
        // exceeds the maximum width.
        const timePicker = this.$.timePicker;
        if (timePicker.scrollWidth > timePicker.clientWidth) {
            this.maxChipsShown_--;
        }
    }
    isTimePeriodSelected_(timePeriod) {
        return timePeriod === this.selectedTimePeriod_;
    }
    onTimePeriodSelected_(event) {
        const newTimePeriod = event.model.item.value;
        if (newTimePeriod !== this.selectedTimePeriod_) {
            this.selectedTimePeriod_ = event.model.item.value;
        }
    }
    onMenuTimePeriodSelected_(event) {
        this.onTimePeriodSelected_(event);
        const actionMenu = this.shadowRoot.querySelector('cr-action-menu');
        if (actionMenu) {
            actionMenu.close();
        }
    }
    onMoreTimePeriodsButtonClick_(e) {
        const target = e.currentTarget;
        // Position the menu below the 'More' button with a slight offset.
        this.$.moreTimePeriodsMenu.get().showAt(target, {
            anchorAlignmentX: AnchorAlignment.BEFORE_END,
            top: target.getBoundingClientRect().bottom + MENU_VERTICAL_OFFSET_PX,
        });
        MetricsBrowserProxyImpl.getInstance().recordAction('Settings.DeleteBrowsingData.TimePickerMoreClick');
    }
    onMoreOptionsMenuClose_(e) {
        // Stop propagation of the 'close' event so it doesn't close the outer
        // dialog.
        e.stopPropagation();
    }
    getSelectedTimePeriod() {
        return this.selectedTimePeriod_;
    }
    sendPrefChange() {
        this.setPrefValue('browser.clear_data.time_period', this.selectedTimePeriod_);
    }
}
customElements.define(SettingsClearBrowsingDataTimePicker.is, SettingsClearBrowsingDataTimePicker);

function getTemplate$1Y() {
    return html `<!--_html_template_start_--><style include="cr-icons cr-shared-style settings-shared">#subpageDescription{padding-bottom:16px}.cancel-button{margin:0}.icon-arrow-back{--cr-icon-button-margin-end:12px;--cr-icon-button-margin-start:0}.label{color:var(--cr-primary-text-color);font-weight:500}.link-rows-block>*{background-color:var(--dbd-container-color);padding:4px 16px}cr-link-row:first-of-type{border-bottom-left-radius:var(--dbd-container-stacked-border-radius);border-bottom-right-radius:var(--dbd-container-stacked-border-radius);border-top-left-radius:var(--dbd-container-border-radius);border-top-right-radius:var(--dbd-container-border-radius);margin-bottom:2px}cr-link-row:last-of-type{border-bottom-left-radius:var(--dbd-container-border-radius);border-bottom-right-radius:var(--dbd-container-border-radius);border-top-left-radius:var(--dbd-container-stacked-border-radius);border-top-right-radius:var(--dbd-container-stacked-border-radius);margin-bottom:0}cr-link-row:not(:first-of-type):not(:last-of-type){border-radius:var(--dbd-container-stacked-border-radius);margin-bottom:2px}cr-link-row:only-of-type{border-radius:var(--dbd-container-border-radius);margin-bottom:0}cr-link-row.hide-icon::part(icon){display:none}div[slot="title"]{--cr-dialog-title-slot-padding-bottom:12px;--cr-dialog-title-slot-padding-top:18px;align-items:center;display:flex;font-size:16px;font-weight:500}</style>

<cr-dialog id="dialog" show-on-attach>
  <div slot="title">
    <cr-icon-button class="icon-arrow-back" aria-label="$i18n{back}"
        on-click="onBackOrCancelClick_" autofocus></cr-icon-button>
    [[dialogTitle_]]
  </div>
  <div slot="body">
    <div id="subpageDescription">$i18n{otherDataDescription}
    </div>
    <div class="link-rows-block">
      <cr-link-row id="passwordManagerLink" external using-slotted-label
          sub-label="$i18n{manageInGooglePasswordManager}"
          on-click="onPasswordManagerClick_">
        <div slot="label" class="label">$i18n{passwordsAndPasskeys}</div>
      </cr-link-row>
      <template is="dom-if"
          if="[[shouldShowGoogleSearchHistoryLink_(syncStatus_, isGoogleDse_)]]"
          restamp>
        <cr-link-row id="googleSearchHistoryLink" external using-slotted-label
            sub-label="$i18n{manageInYourGoogleAccount}"
            on-click="onGoogleSearchHistoryLinkClick_">
          <div slot="label" class="label">$i18n{searchHistory}</div>
        </cr-link-row>
      </template>
      <template is="dom-if" if="[[shouldShowMyActivityLink_(syncStatus_)]]"
          restamp>
        <cr-link-row id="myActivityLink" external using-slotted-label
            sub-label="$i18n{manageInYourGoogleAccount}"
            on-click="onMyActivityLinkClick_">
          <div slot="label" class="label">$i18n{myActivity}</div>
        </cr-link-row>
      </template>
      <template is="dom-if"
          if="[[shouldShowGeminiAppsActivityLink_(syncStatus_)]]" restamp>
        <cr-link-row id="geminiAppsActivityLink" external using-slotted-label
            sub-label="$i18n{manageInYourGeminiAppsActivity}"
            on-click="onGeminiAppsActivityClick_">
          <div slot="label" class="label">$i18n{geminiAppsActivity}</div>
        </cr-link-row>
      </template>
      <template is="dom-if" if="[[!isGoogleDse_]]" restamp>
        <cr-link-row id="nonGoogleSearchHistoryLink" external
            using-slotted-label class="hide-icon"
            sub-label="[[nonGoogleSearchHistorySubLabel_]]">
          <div slot="label" class="label">$i18n{searchHistory}</div>
        </cr-link-row>
      </template>
    </div>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onBackOrCancelClick_">
      $i18n{done}
    </cr-button>
  </div>
</cr-dialog><!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-other-google-data-dialog' is a subpage
 * shown within the Clear Browsing Data dialog to provide links
 * for managing other Google data like passwords and activity.
 */
const SettingsOtherGoogleDataDialogElementBase = WebUiListenerMixin(PolymerElement);
class SettingsOtherGoogleDataDialogElement extends SettingsOtherGoogleDataDialogElementBase {
    static get is() {
        return 'settings-other-google-data-dialog';
    }
    static get template() {
        return getTemplate$1Y();
    }
    static get properties() {
        return {
            dialogTitle_: {
                type: String,
                computed: 'computeDialogTitle_(isGoogleDse_)',
            },
            isGoogleDse_: {
                type: Boolean,
                value: false,
            },
            nonGoogleSearchHistorySubLabel_: String,
            syncStatus_: Object,
        };
    }
    clearBrowsingDataBrowserProxy_ = ClearBrowsingDataBrowserProxyImpl.getInstance();
    syncBrowserProxy_ = SyncBrowserProxyImpl.getInstance();
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    ready() {
        super.ready();
        this.addWebUiListener('sync-status-changed', this.handleSyncStatus_.bind(this));
        this.syncBrowserProxy_.getSyncStatus().then(this.handleSyncStatus_.bind(this));
        this.addWebUiListener('update-sync-state', this.updateDseStatus_.bind(this));
        this.clearBrowsingDataBrowserProxy_.getSyncState().then(this.updateDseStatus_.bind(this));
    }
    updateDseStatus_(event) {
        this.isGoogleDse_ = !event.isNonGoogleDse;
        this.nonGoogleSearchHistorySubLabel_ =
            sanitizeInnerHtml(event.nonGoogleSearchHistoryString);
    }
    handleSyncStatus_(syncStatus) {
        this.syncStatus_ = syncStatus;
    }
    computeDialogTitle_() {
        return this.isGoogleDse_ ? loadTimeData.getString('otherGoogleDataTitle') :
            loadTimeData.getString('otherDataTitle');
    }
    onBackOrCancelClick_() {
        this.$.dialog.cancel();
    }
    onPasswordManagerClick_() {
        PasswordManagerImpl.getInstance().showPasswordManager(PasswordManagerPage.PASSWORDS);
        this.metricsBrowserProxy_.recordAction('Settings.DeleteBrowsingData.PasswordManagerLinkClick');
    }
    onMyActivityLinkClick_() {
        OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString('deleteBrowsingDataMyActivityUrl'));
        this.metricsBrowserProxy_.recordAction('Settings.DeleteBrowsingData.MyActivityLinkClick');
    }
    onGoogleSearchHistoryLinkClick_() {
        OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString('deleteBrowsingDataSearchHistoryUrl'));
        this.metricsBrowserProxy_.recordAction('Settings.DeleteBrowsingData.GoogleSearchHistoryLinkClick');
    }
    onGeminiAppsActivityClick_() {
        OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString('myActivityGeminiAppsUrl'));
        this.metricsBrowserProxy_.recordAction('Settings.DeleteBrowsingData.GeminiAppsActivityLinkClick');
    }
    onGeminiPersonalContextClick_() {
        OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString('geminiPersonalContextUrl'));
    }
    shouldShowMyActivityLink_() {
        return isSignedIn(this.syncStatus_);
    }
    shouldShowGoogleSearchHistoryLink_() {
        return isSignedIn(this.syncStatus_) && this.isGoogleDse_;
    }
    shouldShowGeminiAppsActivityLink_() {
        return isSignedIn(this.syncStatus_) &&
            loadTimeData.getBoolean('showGlicSettings') &&
            loadTimeData.getBoolean('enableBrowsingHistoryActorIntegrationM1');
    }
}
customElements.define(SettingsOtherGoogleDataDialogElement.is, SettingsOtherGoogleDataDialogElement);

function getTemplate$1X() {
    return html `<!--_html_template_start_--><style include="settings-shared cr-spinner-style">:host{--cr-dialog-button-container-padding-bottom:20px;--cr-dialog-button-container-padding-horizontal:20px;--cr-dialog-button-container-padding-top:20px;--cr-dialog-title-font-size:16px;--cr-dialog-title-slot-padding-bottom:14px;--cr-section-two-line-min-height:40px;--dbd-container-border-radius:12px;--dbd-container-color:var(--cr-fallback-color-surface3);--dbd-container-stacked-border-radius:4px;--dbd-dialog-body-max-height:400px;--dbd-dialog-max-height:600px;--settings-checkbox-margin-top:8px}#checkboxContainer{background-color:var(--dbd-container-color);border-radius:var(--dbd-container-border-radius);padding:8px var(--cr-section-padding) 12px var(--cr-section-padding)}#checkboxContainer:has(+#showMoreButton:not([hidden])){border-bottom-left-radius:var(--dbd-container-stacked-border-radius);border-bottom-right-radius:var(--dbd-container-stacked-border-radius);border-top-left-radius:var(--dbd-container-border-radius);border-top-right-radius:var(--dbd-container-border-radius);margin-bottom:2px}#deleteBrowsingDataDialog [slot=header]{padding-bottom:var(--cr-section-padding);padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}#deleteBrowsingDataDialog::part(body-container){max-height:var(--dbd-dialog-body-max-height)}#deleteBrowsingDataDialog::part(dialog){max-height:var(--dbd-dialog-max-height)}#deletingDataAlert{clip:rect(0,0,0,0);position:fixed}#manageOtherGoogleDataRow{border-radius:var(--dbd-container-border-radius);color:var(--cr-primary-text-color);background:var(--dbd-container-color);margin-top:12px;display:flex;align-items:center;font-weight:500}#showMoreButton{--cr-button-background-color:var(--dbd-container-color);--cr-button-height:auto;--cr-button-text-color:var(--cr-primary-text-color);border:none;border-bottom-left-radius:var(--dbd-container-border-radius);border-bottom-right-radius:var(--dbd-container-border-radius);border-top-left-radius:var(--dbd-container-stacked-border-radius);border-top-right-radius:var(--dbd-container-stacked-border-radius);padding:var(--cr-section-vertical-padding) 16px;width:100%}#spinner{margin-bottom:auto;margin-inline-end:16px;margin-top:auto}.checkbox-title{font-weight:500}.dialog-title{font-weight:500;line-height:24px}.row-aligned{align-items:center;display:flex}settings-clear-browsing-data-account-indicator{margin-inline-end:auto;overflow:hidden}</style>

<cr-dialog id="deleteBrowsingDataDialog" close-text="$i18n{close}"
    show-on-attach ignore-popstate ignore-enter-key
    hidden="[[showOtherGoogleDataDialog_]]">
  <div slot="title" class="dialog-title">$i18n{clearBrowsingData}</div>
  <div slot="header">
    <settings-clear-browsing-data-time-picker id="timePicker" prefs="{{prefs}}"
        on-selected-time-period-change="onTimePeriodChanged_">
    </settings-clear-browsing-data-time-picker>
  </div>
  <div slot="body">
    <div id="checkboxContainer">
      <template is="dom-repeat"
          items="[[expandedBrowsingDataTypeOptionsList_]]">
        <settings-checkbox pref="{{item.pref}}" no-set-pref
            sub-label-html="[[item.subLabel]]"
            disabled="[[isDeletionInProgress_]]"
            on-sub-label-link-clicked="onCheckboxSubLabelLinkClick_">
          <div class="checkbox-title">[[item.label]]</div>
        </settings-checkbox>
      </template>
      <div id="moreOptionsList">
        <template is="dom-if" if="[[dataTypesExpanded_]]">
          <template is="dom-repeat"
              items="[[moreBrowsingDataTypeOptionsList_]]">
            <settings-checkbox pref="{{item.pref}}" no-set-pref
                sub-label-html="[[item.subLabel]]"
                disabled="[[isDeletionInProgress_]]"
                on-sub-label-link-clicked="onCheckboxSubLabelLinkClick_">
              <div class="checkbox-title">[[item.label]]</div>
            </settings-checkbox>
          </template>
        </template>
      </div>
    </div>
    <cr-button id="showMoreButton" on-click="onShowMoreClick_"
        hidden="[[shouldHideShowMoreButton_(
            dataTypesExpanded_, moreBrowsingDataTypeOptionsList_)]]">
      $i18n{clearBrowsingDataShowMore}
      <cr-icon icon="cr:expand-more" aria-hidden="true" role="presentation">
      </cr-icon>
    </cr-button>
    <cr-link-row id="manageOtherGoogleDataRow"
        label="[[otherGoogleDataRowLabel_]]"
        sub-label="[[otherGoogleDataRowSubLabel_]]"
        on-click="onManageOtherGoogleDataRowClick_"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
  </div>
  <div slot="button-container" class="row-aligned">

    <settings-clear-browsing-data-account-indicator>
    </settings-clear-browsing-data-account-indicator>

    <div id="spinner" class="spinner" hidden="[[!isDeletionInProgress_]]"></div>
    <cr-button id="cancelButton" class="cancel-button" on-click="onCancelClick_"
        disabled="[[isDeletionInProgress_]]" autofocus>
      $i18n{cancel}
    </cr-button>
    <cr-button id="deleteButton" class="action-button"
        on-click="onDeleteBrowsingDataClick_"
        disabled="[[shouldDisableDeleteButton_(
            isDeletionInProgress_, isNoDatatypeSelected_)]]">
      [[deleteButtonLabel_]]
    </cr-button>
    <!-- The alert must be inside the dialog for it to be read while the
         dialog is open. -->
    <div id="deletingDataAlert" role="alert">
      [[deletingDataAlertString_]]
    </div>
  </div>
</cr-dialog>

<template is="dom-if" if="[[showHistoryDeletionDialog_]]" restamp>
  <settings-history-deletion-dialog id="historyNotice"
      on-close="onHistoryDeletionDialogClose_">
  </settings-history-deletion-dialog>
</template>

<template is="dom-if" if="[[showOtherGoogleDataDialog_]]" restamp>
  <settings-other-google-data-dialog on-cancel="onOtherGoogleDataDialogClose_">
  </settings-other-google-data-dialog>
</template><!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-clear-browsing-data-dialog-v2' allows the user to
 * delete browsing data that has been cached by Chromium.
 */
/**
 * @param dialog the dialog to close
 * @param isLast whether this is the last CBD-related dialog
 */
function closeDialog(dialog, isLast) {
    // If this is not the last dialog, then stop the 'close' event from
    // propagating so that other (following) dialogs don't get closed as well.
    if (!isLast) {
        dialog.addEventListener('close', e => {
            e.stopPropagation();
        }, { once: true });
    }
    dialog.close();
}
/**
 * The list of all available Browsing Data types in the default order they
 * should appear in the dialog.
 */
const ALL_BROWSING_DATATYPES_LIST = [
    BrowsingDataType.HISTORY,
    BrowsingDataType.SITE_DATA,
    BrowsingDataType.CACHE,
    BrowsingDataType.DOWNLOADS,
    BrowsingDataType.FORM_DATA,
    BrowsingDataType.SITE_SETTINGS,
    BrowsingDataType.HOSTED_APPS_DATA,
];
/** The list of Browsing Data types that should be expanded by default. */
const DEFAULT_BROWSING_DATATYPES_LIST = [
    BrowsingDataType.HISTORY,
    BrowsingDataType.SITE_DATA,
    BrowsingDataType.CACHE,
];
function getDataTypeLabel(datatypes) {
    switch (datatypes) {
        case BrowsingDataType.HISTORY:
            return loadTimeData.getString('clearBrowsingHistory');
        case BrowsingDataType.CACHE:
            return loadTimeData.getString('clearCache');
        case BrowsingDataType.SITE_DATA:
            return loadTimeData.getString('clearCookies');
        case BrowsingDataType.FORM_DATA:
            return loadTimeData.getString('clearFormData');
        case BrowsingDataType.SITE_SETTINGS:
            return loadTimeData.getString('siteSettings');
        case BrowsingDataType.DOWNLOADS:
            return loadTimeData.getString('clearDownloadHistory');
        case BrowsingDataType.HOSTED_APPS_DATA:
            return loadTimeData.getString('clearHostedAppData');
        default:
            assertNotReachedCase();
    }
}
function getDataTypePrefName(datatypes) {
    switch (datatypes) {
        case BrowsingDataType.HISTORY:
            return 'browser.clear_data.browsing_history';
        case BrowsingDataType.CACHE:
            return 'browser.clear_data.cache';
        case BrowsingDataType.SITE_DATA:
            return 'browser.clear_data.cookies';
        case BrowsingDataType.FORM_DATA:
            return 'browser.clear_data.form_data';
        case BrowsingDataType.SITE_SETTINGS:
            return 'browser.clear_data.site_settings';
        case BrowsingDataType.DOWNLOADS:
            return 'browser.clear_data.download_history';
        case BrowsingDataType.HOSTED_APPS_DATA:
            return 'browser.clear_data.hosted_apps_data';
        default:
            assertNotReachedCase();
    }
}
const SettingsClearBrowsingDataDialogV2ElementBase = RouteObserverMixin(WebUiListenerMixin(PrefsMixin(PolymerElement)));
class SettingsClearBrowsingDataDialogV2Element extends SettingsClearBrowsingDataDialogV2ElementBase {
    static get is() {
        return 'settings-clear-browsing-data-dialog-v2';
    }
    static get template() {
        return getTemplate$1X();
    }
    static get properties() {
        return {
            dataTypesExpanded_: {
                type: Boolean,
                value: false,
            },
            deleteButtonLabel_: {
                type: String,
                value: loadTimeData.getString('deleteDataFromDevice'),
                computed: 'computeDeleteButtonLabel_(syncStatus_.signedInState)',
            },
            deletingDataAlertString_: {
                type: String,
                value: '',
            },
            isDeletionInProgress_: {
                type: Boolean,
                value: false,
            },
            isNoDatatypeSelected_: {
                type: Boolean,
                value: false,
            },
            isGoogleDse_: {
                type: Boolean,
                value: false,
            },
            otherGoogleDataRowLabel_: {
                type: String,
                computed: 'computeOtherGoogleDataRowLabel_(isGoogleDse_)',
            },
            otherGoogleDataRowSubLabel_: {
                type: String,
                computed: 'computeOtherGoogleDataRowSubLabel_(syncStatus_.signedInState, isGoogleDse_)',
            },
            showHistoryDeletionDialog_: {
                type: Boolean,
                value: false,
            },
            showOtherGoogleDataDialog_: {
                type: Boolean,
                value: false,
            },
            expandedBrowsingDataTypeOptionsList_: Array,
            moreBrowsingDataTypeOptionsList_: Array,
            syncStatus_: {
                type: Object,
                observer: 'onSyncStatusChanged_',
            },
        };
    }
    clearBrowsingDataBrowserProxy_ = ClearBrowsingDataBrowserProxyImpl.getInstance();
    syncBrowserProxy_ = SyncBrowserProxyImpl.getInstance();
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    ready() {
        super.ready();
        this.addWebUiListener('browsing-data-counter-text-update', this.updateCounterText_.bind(this));
        this.addWebUiListener('sync-status-changed', this.handleSyncStatus_.bind(this));
        this.syncBrowserProxy_.getSyncStatus().then(this.handleSyncStatus_.bind(this));
        this.addEventListener('settings-boolean-control-change', this.updateDeleteButtonState_.bind(this));
        this.addWebUiListener('update-sync-state', (event) => this.updateDseStatus_(event.isNonGoogleDse));
        this.clearBrowsingDataBrowserProxy_.getSyncState().then((event) => this.updateDseStatus_(event.isNonGoogleDse));
        CrSettingsPrefs.initialized.then(() => {
            this.setUpDataTypeOptionLists_();
            // afterNextRender() is needed to wait for checkbox lists to be populated
            // via dom-repeat before checking if the delete button should be
            // disabled.
            afterNextRender(this, () => this.updateDeleteButtonState_());
        });
    }
    updateDseStatus_(isNonGoogleDse) {
        this.isGoogleDse_ = !isNonGoogleDse;
    }
    handleSyncStatus_(syncStatus) {
        this.syncStatus_ = syncStatus;
    }
    onSyncStatusChanged_() {
        this.clearBrowsingDataBrowserProxy_.restartCounters(
        /*isBasic=*/ false, this.$.timePicker.getSelectedTimePeriod());
    }
    connectedCallback() {
        super.connectedCallback();
        this.clearBrowsingDataBrowserProxy_.initialize();
        this.setFocusOutlineToVisible_();
    }
    currentRouteChanged(currentRoute) {
        if (currentRoute === routes.CLEAR_BROWSER_DATA) {
            this.metricsBrowserProxy_.recordAction('ClearBrowsingData_DialogCreated');
        }
    }
    setUpDataTypeOptionLists_() {
        const expandedOptionsList = [];
        const moreOptionsList = [];
        ALL_BROWSING_DATATYPES_LIST.forEach((datatype) => {
            const datatypeOption = {
                label: getDataTypeLabel(datatype),
                pref: this.getPref(getDataTypePrefName(datatype)),
            };
            if (this.shouldDataTypeBeExpanded_(datatype)) {
                expandedOptionsList.push(datatypeOption);
            }
            else {
                moreOptionsList.push(datatypeOption);
            }
        });
        this.expandedBrowsingDataTypeOptionsList_ = expandedOptionsList;
        this.moreBrowsingDataTypeOptionsList_ = moreOptionsList;
    }
    /**
     * Updates the text of a browsing data counter corresponding to the given
     * preference.
     * @param prefName Browsing data type deletion preference.
     * @param text The text with which to update the counter.
     */
    updateCounterText_(prefName, text) {
        // If the corresponding datatype is in the expanded options list, update the
        // sub-label.
        const expandedListIndex = this.expandedBrowsingDataTypeOptionsList_.map(option => option.pref.key)
            .indexOf(prefName);
        if (expandedListIndex !== -1) {
            this.set(`expandedBrowsingDataTypeOptionsList_.${expandedListIndex}.subLabel`, text);
            return;
        }
        // If the datatype is not found in the expanded options list, it should be
        // in the more options list.
        const moreListIndex = this.moreBrowsingDataTypeOptionsList_.map(option => option.pref.key)
            .indexOf(prefName);
        assert(moreListIndex !== -1);
        this.set(`moreBrowsingDataTypeOptionsList_.${moreListIndex}.subLabel`, text);
    }
    isSignedIn_() {
        return isSignedIn(this.syncStatus_);
    }
    shouldDataTypeBeExpanded_(datatype) {
        return DEFAULT_BROWSING_DATATYPES_LIST.includes(datatype) ||
            this.getPref(getDataTypePrefName(datatype)).value;
    }
    computeDeleteButtonLabel_() {
        return canDeleteAccountData(this.syncStatus_) ?
            loadTimeData.getString('clearData') :
            loadTimeData.getString('deleteDataFromDevice');
    }
    computeOtherGoogleDataRowLabel_() {
        return this.isGoogleDse_ ?
            loadTimeData.getString('manageOtherGoogleDataLabel') :
            loadTimeData.getString('manageOtherDataLabel');
    }
    computeOtherGoogleDataRowSubLabel_() {
        if (loadTimeData.getBoolean('showGlicSettings') &&
            loadTimeData.getBoolean('enableBrowsingHistoryActorIntegrationM1') &&
            this.isSignedIn_()) {
            return loadTimeData.getString('manageSearchGeminiPasswordsSubLabel');
        }
        if (this.isSignedIn_() || !this.isGoogleDse_) {
            return loadTimeData.getString('manageOtherDataSubLabel');
        }
        return loadTimeData.getString('managePasswordsSubLabel');
    }
    onTimePeriodChanged_() {
        this.clearBrowsingDataBrowserProxy_.restartCounters(
        /*isBasic=*/ false, this.$.timePicker.getSelectedTimePeriod());
    }
    onCancelClick_() {
        this.$.deleteBrowsingDataDialog.close();
    }
    /**
     * Triggers browsing data deletion on the selected DataTypes and within the
     * selected TimePeriod.
     */
    async onDeleteBrowsingDataClick_() {
        this.deletingDataAlertString_ = loadTimeData.getString('clearingData');
        this.isDeletionInProgress_ = true;
        const dataTypes = this.getSelectedDataTypes_();
        const timePeriod = this.$.timePicker.getSelectedTimePeriod();
        this.clearBrowsingDataBrowserProxy_
            .recordSettingsClearBrowsingDataAdvancedTimePeriodHistogram(timePeriod);
        // Update the DataType and TimePeriod prefs with the latest selection.
        this.$.deleteBrowsingDataDialog
            .querySelectorAll('settings-checkbox[no-set-pref]')
            .forEach(checkbox => 
        // Manually update the checkboxes' pref value. This is a
        // temporary fix as the `SettingsCheckbox.sendPrefChange` does
        // not update prefs when they are passed dynamically.
        // TODO(crbug.com/431174247): Figure out why
        // `SettingsCheckbox.sendPrefChange` is not working.
        this.setPrefValue(checkbox.pref.key, checkbox.checked));
        this.$.timePicker.sendPrefChange();
        const { showHistoryNotice } = await this.clearBrowsingDataBrowserProxy_.clearBrowsingData(dataTypes, timePeriod);
        this.isDeletionInProgress_ = false;
        this.showHistoryDeletionDialog_ = showHistoryNotice;
        this.showDeletionConfirmationToast_(timePeriod);
        if (this.$.deleteBrowsingDataDialog.open) {
            closeDialog(this.$.deleteBrowsingDataDialog, !showHistoryNotice);
        }
    }
    showDeletionConfirmationToast_(timePeriod) {
        const deletionConfirmationToastLabel = timePeriod === TimePeriod.ALL_TIME ?
            loadTimeData.getString('deletionConfirmationAllTimeToast') :
            loadTimeData.getStringF('deletionConfirmationToast', getTimePeriodString(timePeriod, /*short=*/ false));
        this.dispatchEvent(new CustomEvent('browsing-data-deleted', {
            bubbles: true,
            composed: true,
            detail: {
                deletionConfirmationText: deletionConfirmationToastLabel,
            },
        }));
    }
    getSelectedDataTypes_() {
        // Get all the visible checkboxes in the dialog. Hidden checkboxes, eg.
        // collapsed checkboxes in the 'More' list, would never be selected, so
        // there is no need to iterate over them.
        const checkboxes = this.$.deleteBrowsingDataDialog.querySelectorAll('settings-checkbox');
        const dataTypes = [];
        checkboxes.forEach((checkbox) => {
            if (checkbox.checked && !checkbox.hidden) {
                dataTypes.push(checkbox.pref.key);
            }
        });
        return dataTypes;
    }
    updateDeleteButtonState_() {
        this.isNoDatatypeSelected_ = this.getSelectedDataTypes_().length === 0;
    }
    onShowMoreClick_() {
        this.dataTypesExpanded_ = true;
        this.metricsBrowserProxy_.recordAction('Settings.DeleteBrowsingData.CheckboxesShowMoreClick');
        // Set the focus to the first checkbox in the 'more' options list.
        afterNextRender(this, () => {
            const toFocus = this.$.moreOptionsList.querySelector('settings-checkbox');
            assert(toFocus);
            toFocus.focus();
        });
    }
    shouldHideShowMoreButton_() {
        return this.dataTypesExpanded_ || !this.moreBrowsingDataTypeOptionsList_ ||
            this.moreBrowsingDataTypeOptionsList_.length === 0;
    }
    shouldDisableDeleteButton_() {
        return this.isDeletionInProgress_ || this.isNoDatatypeSelected_;
    }
    onHistoryDeletionDialogClose_() {
        this.showHistoryDeletionDialog_ = false;
    }
    onManageOtherGoogleDataRowClick_() {
        this.showOtherGoogleDataDialog_ = true;
        this.metricsBrowserProxy_.recordAction('Settings.DeleteBrowsingData.OtherDataEntryPointClick');
    }
    setFocusOutlineToVisible_() {
        // AutoFocus is not visible in mouse navigation by default. But in this
        // dialog the default focus is on cancel which is not a default button. To
        // make this clear to the user we make it visible to the user and remove
        // the focus after the next mouse event.
        const focusOutlineManager = FocusOutlineManager.forDocument(document);
        focusOutlineManager.visible = true;
        document.addEventListener('mousedown', () => {
            focusOutlineManager.visible = false;
        }, { once: true });
    }
    onOtherGoogleDataDialogClose_(e) {
        e.stopPropagation();
        this.showOtherGoogleDataDialog_ = false;
        afterNextRender(this, () => focusWithoutInk(this.$.manageOtherGoogleDataRow));
    }
    onCheckboxSubLabelLinkClick_(e) {
        // 
        if (e.detail.id === 'signOutLink') {
            this.syncBrowserProxy_.signOut(/*delete_profile=*/ false);
            this.metricsBrowserProxy_.recordAction('Settings.DeleteBrowsingData.CookiesSignOutLinkClick');
            return;
        }
        // 
        assertNotReached(`Invalid sub-label link with id: ${e.detail.id}`);
    }
}
customElements.define(SettingsClearBrowsingDataDialogV2Element.is, SettingsClearBrowsingDataDialogV2Element);

function getTemplate$1W() {
    return html `<!--_html_template_start_--><style include="settings-shared settings-columned-section">#description{padding:0 var(--cr-section-padding) var(--cr-section-vertical-padding)}#explanationText{padding:0 var(--cr-section-padding)}.sr-only{clip:rect(0 0 0 0);clip-path:inset(50%);height:1px;overflow:hidden;position:absolute;white-space:nowrap;width:1px}
</style>
<settings-subpage page-title="$i18n{incognitoTrackingProtectionsPageTitle}"
    learn-more-url="$i18n{incognitoTrackingProtectionsLearnMoreUrl}"
    route-path$="[[routePath]]">
<div id="explanationText" class="secondary">
  $i18n{incognitoTrackingProtectionsPageDescription}
</div>
<div id="generalControls">
  <div id="description" class="secondary">
    <h2 class="cr-title-text">$i18n{incognitoTrackingProtectionsHeader}</h2>
    <div>$i18nRaw{incognitoTrackingProtectionsDescription}</div>
  </div>
  <settings-toggle-button id="block3pcsToggle" disabled
      pref="{{block3pcsIncognitoPref_}}"
      label="$i18n{incognitoTrackingProtectionsBlock3pcsToggleLabel}"
      sub-label="$i18n{incognitoTrackingProtectionsBlock3pcsToggleSublabel}">
  </settings-toggle-button>
  <template is="dom-if" if="[[isIpProtectionAvailable_]]">
    <h3 class="sr-only">
      $i18n{incognitoTrackingProtectionsIpProtectionToggleLabel}
    </h3>
    <template is="dom-if" if="[[!isIpProtectionDisabledForEnterprise_]]">
      <settings-toggle-button id="ipProtectionToggle"
          pref="{{prefs.tracking_protection.ip_protection_enabled}}"
          label="$i18n{incognitoTrackingProtectionsIpProtectionToggleLabel}"
          sub-label="$i18n{incognitoTrackingProtectionsIpProtectionToggleSublabel}"
          on-settings-boolean-control-change="onIpProtectionChanged_">
      </settings-toggle-button>
    </template>
    <template is="dom-if" if="[[isIpProtectionDisabledForEnterprise_]]">
      <settings-toggle-button id="ipProtectionToggle" disabled
          pref="[[ipProtectionDisabledForEnterprisePref_]]"
          label="$i18n{incognitoTrackingProtectionsIpProtectionToggleLabel}"
          sub-label="$i18n{incognitoTrackingProtectionsIpProtectionToggleSublabel}">
      </settings-toggle-button>
    </template>
    <div class="settings-columned-section">
      <div class="column">
        <h4 class="description-header">$i18n{columnHeadingWhenOn}</h4>
        <ul class="icon-bulleted-list">
          <li>
            <cr-icon icon="settings20:network-ping" aria-hidden="true"></cr-icon>
            <div class="secondary">
              $i18n{incognitoTrackingProtectionsIpProtectionWhenOn}
            </div>
          </li>
        </ul>
      </div>
      <div class="column">
        <h4 class="description-header">$i18n{columnHeadingConsider}</h4>
        <ul class="icon-bulleted-list">
          <li>
            <cr-icon icon="settings20:preview" aria-hidden="true"></cr-icon>
            <div class="secondary">
              $i18n{incognitoTrackingProtectionsIpProtectionThingsToConsiderBulletOne}
            </div>
          </li>
          <li>
            <cr-icon icon="settings20:account-circle" aria-hidden="true"></cr-icon>
            <div class="secondary">
              $i18n{incognitoTrackingProtectionsIpProtectionThingsToConsiderBulletTwo}
            </div>
          </li>
          <li>
            <cr-icon icon="settings20:googleg" aria-hidden="true"></cr-icon>
            <div class="secondary">
              $i18n{incognitoTrackingProtectionsIpProtectionThingsToConsiderBulletThree}
            </div>
          </li>
        </ul>
      </div>
    </div>
  </template>
  <template is="dom-if" if="[[isFingerprintingProtectionAvailable_]]">
    <h3 class="sr-only">
      $i18n{incognitoTrackingProtectionsFingerprintingProtectionToggleLabel}
    </h3>
    <settings-toggle-button id="fingerprintingProtectionToggle"
        pref="{{prefs.tracking_protection.fingerprinting_protection_enabled}}"
        label="$i18n{incognitoTrackingProtectionsFingerprintingProtectionToggleLabel}"
        sub-label="
          $i18n{incognitoTrackingProtectionsFingerprintingProtectionToggleSublabel}"
        on-settings-boolean-control-change="onFpProtectionChanged_">
    </settings-toggle-button>
    <div class="settings-columned-section">
      <div class="column">
        <h4 class="description-header">$i18n{columnHeadingWhenOn}</h4>
        <ul class="icon-bulleted-list">
          <li>
            <cr-icon icon="settings20:privacy-screen" aria-hidden="true"></cr-icon>
            <div class="secondary">
              $i18n{incognitoTrackingProtectionsFingerprintingProtectionWhenOn}
            </div>
          </li>
        </ul>
      </div>
      <div class="column">
        <h4 class="description-header">$i18n{columnHeadingConsider}</h4>
        <ul class="icon-bulleted-list">
          <li>
            <cr-icon icon="settings20:preview" aria-hidden="true"></cr-icon>
            <div class="secondary">
              $i18n{incognitoTrackingProtectionsFingerprintingProtectionThingsToConsider}
            </div>
          </li>
        </ul>
      </div>
    </div>
  </template>
</div>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const IncognitoTrackingProtectionsPageElementBase = SettingsViewMixin(PrefsMixin(PolymerElement));
class IncognitoTrackingProtectionsPageElement extends IncognitoTrackingProtectionsPageElementBase {
    static get is() {
        return 'incognito-tracking-protections-page';
    }
    static get template() {
        return getTemplate$1W();
    }
    static get properties() {
        return {
            isIpProtectionAvailable_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('isIpProtectionUxEnabled'),
            },
            isFingerprintingProtectionAvailable_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('isFingerprintingProtectionUxEnabled'),
            },
            isIpProtectionDisabledForEnterprise_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('isIpProtectionDisabledForEnterprise'),
            },
            // Mock pref to show the IPP toggle as disabled by enterprise policy.
            ipProtectionDisabledForEnterprisePref_: {
                type: Object,
                value() {
                    return {
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: false,
                        enforcement: chrome.settingsPrivate.Enforcement.ENFORCED,
                        controlledBy: chrome.settingsPrivate.ControlledBy.DEVICE_POLICY,
                    };
                },
            },
            // Mock pref for the block 3PCs toggle. Required as all
            // `settings-toggle-button` elements must have an associated pref.
            block3pcsIncognitoPref_: {
                type: Object,
                value() {
                    return {
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: true,
                        enforcement: chrome.settingsPrivate.Enforcement.ENFORCED,
                    };
                },
            },
        };
    }
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    onFpProtectionChanged_(e) {
        if (e.target instanceof SettingsToggleButtonElement) {
            const actionName = e.target.checked ?
                'Settings.TrackingProtections.FingerprintingProtection.Enabled' :
                'Settings.TrackingProtections.FingerprintingProtection.Disabled';
            this.metricsBrowserProxy_.recordAction(actionName);
        }
        this.metricsBrowserProxy_.recordSettingsPageHistogram(PrivacyElementInteractions.FINGERPRINTING_PROTECTION);
    }
    onIpProtectionChanged_(e) {
        if (e.target instanceof SettingsToggleButtonElement) {
            const actionName = e.target.checked ?
                'Settings.TrackingProtections.IpProtection.Enabled' :
                'Settings.TrackingProtections.IpProtection.Disabled';
            this.metricsBrowserProxy_.recordAction(actionName);
        }
        this.metricsBrowserProxy_.recordSettingsPageHistogram(PrivacyElementInteractions.IP_PROTECTION);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(IncognitoTrackingProtectionsPageElement.is, IncognitoTrackingProtectionsPageElement);

function getTemplate$1V() {
    return html `<!--_html_template_start_-->    <style include="settings-shared">cr-input{display:inline-block;padding-inline-end:2em;--cr-input-width:8em}
    </style>

    <p>$i18n{securityKeysPINPrompt}</p>
    <cr-input id="pin" value="{{value_}}" min-length="[[minPinLength]]"
        max-length="255" spellcheck="false"
        on-input="onPinInput_"
        invalid="[[isNonEmpty_(error_)]]"
        label="$i18n{securityKeysPIN}"
        type$="[[inputType_(inputVisible_)]]"
        error-message="[[error_]]">
      <cr-icon-button slot="suffix" id="showButton"
          class$="[[showButtonClass_(inputVisible_)]]"
          title="[[showButtonTitle_(inputVisible_)]]"
          focus-row-control focus-type="showPassword"
          on-click="showButtonClick_"></cr-icon-button>
    </cr-input>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-security-keys-pin-field' is a component for entering
 * a security key PIN.
 */
const SettingsSecurityKeysPinFieldElementBase = I18nMixin(PolymerElement);
class SettingsSecurityKeysPinFieldElement extends SettingsSecurityKeysPinFieldElementBase {
    static get is() {
        return 'settings-security-keys-pin-field';
    }
    static get template() {
        return getTemplate$1V();
    }
    static get properties() {
        return {
            minPinLength: {
                value: 4,
                type: Number,
            },
            error_: {
                type: String,
                observer: 'errorChanged_',
            },
            value_: String,
            inputVisible_: {
                type: Boolean,
                value: false,
            },
        };
    }
    /** Focuses the PIN input field. */
    focus() {
        this.$.pin.focus();
    }
    /**
     * Validates the PIN and sets the validation error if it is not valid.
     * @return True iff the PIN is valid.
     */
    validate_() {
        const error = this.isValidPin_(this.value_);
        if (error !== '') {
            this.error_ = error;
            return false;
        }
        return true;
    }
    /**
     * Attempts submission of the PIN by invoking |submitFunc|. Updates the UI
     * to show an error if the PIN was incorrect.
     * @return A Promise that resolves if the PIN was correct, else rejects.
     */
    trySubmit(submitFunc) {
        if (!this.validate_()) {
            this.focus();
            return Promise.reject();
        }
        return submitFunc(this.value_).then(retries => {
            if (retries !== null) {
                this.showIncorrectPinError_(retries);
                this.focus();
                return Promise.reject();
            }
            return;
        });
    }
    /**
     * Sets the validation error to indicate the PIN was incorrect.
     * @param retries The number of retries remaining.
     */
    showIncorrectPinError_(retries) {
        // Warn the user if the number of retries is getting low.
        let error;
        if (1 < retries && retries <= 3) {
            error =
                this.i18n('securityKeysPINIncorrectRetriesPl', retries.toString());
        }
        else if (retries === 1) {
            error = this.i18n('securityKeysPINIncorrectRetriesSin');
        }
        else {
            error = this.i18n('securityKeysPINIncorrect');
        }
        this.error_ = error;
    }
    onPinInput_() {
        // Typing in the PIN box after an error makes the error message
        // disappear.
        this.error_ = '';
    }
    /**
     * Polymer helper function to detect when an error string is empty.
     * @return True iff |s| is non-empty.
     */
    isNonEmpty_(s) {
        return s !== '';
    }
    /**
     * @return The PIN-input element type.
     */
    inputType_() {
        return this.inputVisible_ ? 'text' : 'password';
    }
    /**
     * @return The class (and thus icon) to be displayed.
     */
    showButtonClass_() {
        return 'icon-visibility' + (this.inputVisible_ ? '-off' : '');
    }
    /**
     * @return The tooltip for the icon.
     */
    showButtonTitle_() {
        return this.i18n(this.inputVisible_ ? 'securityKeysHidePINs' : 'securityKeysShowPINs');
    }
    /**
     * onClick handler for the show/hide icon.
     */
    showButtonClick_() {
        this.inputVisible_ = !this.inputVisible_;
    }
    /**
     * @param pin A candidate PIN.
     * @return An error string or else '' to indicate validity.
     */
    isValidPin_(pin) {
        // The UTF-8 encoding of the PIN must be between minPinLength
        // and 63 bytes, and the final byte cannot be zero.
        const utf8Encoded = new TextEncoder().encode(pin);
        if (utf8Encoded.length < this.minPinLength) {
            return this.i18n('securityKeysPINTooShort');
        }
        if (utf8Encoded.length > 63 ||
            // If the PIN somehow has a NUL at the end then it's invalid, but this
            // is so obscure that we don't try to message it. Rather we just say
            // that it's too long because trimming the final character is the best
            // response by the user.
            utf8Encoded[utf8Encoded.length - 1] === 0) {
            return this.i18n('securityKeysPINTooLong');
        }
        // A PIN must contain at least minPinLength code-points. Javascript strings
        // are UCS-2 and the |length| property counts UCS-2 elements, not
        // code-points. (For example, '\u{1f6b4}'.length === 2, but it's a single
        // code-point.) Therefore, iterate over the string (which does yield
        // codepoints) and check that four or more were seen.
        let length = 0;
        for (const _codepoint of pin) {
            length++;
        }
        if (length < this.minPinLength) {
            return this.i18n('securityKeysPINTooShort');
        }
        return '';
    }
    errorChanged_() {
        // Make screen readers announce changes to the PIN validation error
        // label.
        getInstance().announce(this.error_);
    }
}
customElements.define(SettingsSecurityKeysPinFieldElement.is, SettingsSecurityKeysPinFieldElement);

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// clang-format off
// clang-format on
/**
 * Ctap2Status contains a subset of CTAP2 status codes. See
 * device::CtapDeviceResponseCode for the full list.
 */
var Ctap2Status;
(function (Ctap2Status) {
    Ctap2Status[Ctap2Status["OK"] = 0] = "OK";
    Ctap2Status[Ctap2Status["ERR_FP_DATABASE_FULL"] = 23] = "ERR_FP_DATABASE_FULL";
    Ctap2Status[Ctap2Status["ERR_INVALID_OPTION"] = 44] = "ERR_INVALID_OPTION";
    Ctap2Status[Ctap2Status["ERR_KEEPALIVE_CANCEL"] = 45] = "ERR_KEEPALIVE_CANCEL";
})(Ctap2Status || (Ctap2Status = {}));
/**
 * SampleStatus is the result for reading an individual sample ("touch")
 * during a fingerprint enrollment. This is a subset of the
 * lastEnrollSampleStatus enum defined in the CTAP spec.
 */
var SampleStatus;
(function (SampleStatus) {
    SampleStatus[SampleStatus["OK"] = 0] = "OK";
})(SampleStatus || (SampleStatus = {}));
class SecurityKeysPinBrowserProxyImpl {
    startSetPin() {
        return sendWithPromise('securityKeyStartSetPIN');
    }
    setPin(oldPIN, newPIN) {
        return sendWithPromise('securityKeySetPIN', oldPIN, newPIN);
    }
    close() {
        chrome.send('securityKeyPINClose');
    }
    static getInstance() {
        return pinBrowserProxyInstance ||
            (pinBrowserProxyInstance = new SecurityKeysPinBrowserProxyImpl());
    }
    static setInstance(obj) {
        pinBrowserProxyInstance = obj;
    }
}
let pinBrowserProxyInstance = null;
class SecurityKeysCredentialBrowserProxyImpl {
    startCredentialManagement() {
        return sendWithPromise('securityKeyCredentialManagementStart');
    }
    providePin(pin) {
        return sendWithPromise('securityKeyCredentialManagementPIN', pin);
    }
    enumerateCredentials() {
        return sendWithPromise('securityKeyCredentialManagementEnumerate');
    }
    deleteCredentials(ids) {
        return sendWithPromise('securityKeyCredentialManagementDelete', ids);
    }
    updateUserInformation(credentialId, userHandle, newUsername, newDisplayname) {
        return sendWithPromise('securityKeyCredentialManagementUpdate', credentialId, userHandle, newUsername, newDisplayname);
    }
    close() {
        chrome.send('securityKeyCredentialManagementClose');
    }
    static getInstance() {
        return credentialBrowserProxyInstance ||
            (credentialBrowserProxyInstance =
                new SecurityKeysCredentialBrowserProxyImpl());
    }
    static setInstance(obj) {
        credentialBrowserProxyInstance = obj;
    }
}
let credentialBrowserProxyInstance = null;
class SecurityKeysResetBrowserProxyImpl {
    reset() {
        return sendWithPromise('securityKeyReset');
    }
    completeReset() {
        return sendWithPromise('securityKeyCompleteReset');
    }
    close() {
        chrome.send('securityKeyResetClose');
    }
    static getInstance() {
        return resetBrowserProxyInstance ||
            (resetBrowserProxyInstance = new SecurityKeysResetBrowserProxyImpl());
    }
    static setInstance(obj) {
        resetBrowserProxyInstance = obj;
    }
}
let resetBrowserProxyInstance = null;
class SecurityKeysBioEnrollProxyImpl {
    startBioEnroll() {
        return sendWithPromise('securityKeyBioEnrollStart');
    }
    providePin(pin) {
        return sendWithPromise('securityKeyBioEnrollProvidePIN', pin);
    }
    getSensorInfo() {
        return sendWithPromise('securityKeyBioEnrollGetSensorInfo');
    }
    enumerateEnrollments() {
        return sendWithPromise('securityKeyBioEnrollEnumerate');
    }
    startEnrolling() {
        return sendWithPromise('securityKeyBioEnrollStartEnrolling');
    }
    cancelEnrollment() {
        chrome.send('securityKeyBioEnrollCancel');
    }
    deleteEnrollment(id) {
        return sendWithPromise('securityKeyBioEnrollDelete', id);
    }
    renameEnrollment(id, name) {
        return sendWithPromise('securityKeyBioEnrollRename', id, name);
    }
    close() {
        chrome.send('securityKeyBioEnrollClose');
    }
    static getInstance() {
        return bioEnrollProxyInstance ||
            (bioEnrollProxyInstance = new SecurityKeysBioEnrollProxyImpl());
    }
    static setInstance(obj) {
        bioEnrollProxyInstance = obj;
    }
}
let bioEnrollProxyInstance = null;

function getTemplate$1U() {
    return html `<!--_html_template_start_-->    <style include="settings-shared cr-spinner-style">.spinner{padding-bottom:12px}#header{display:flex;justify-content:flex-start}site-favicon{margin-inline-end:2px;min-width:16px}.icon-placeholder{margin-inline-end:var(--cr-icon-button-margin-end);margin-inline-start:var(--cr-icon-button-margin-start);width:var(--cr-icon-ripple-size)}.site{flex:1}.user-name{flex:1}.user-display-name{flex:0.8}.user-display-name,.user-name,.site{align-items:center;display:inline-block;overflow:hidden;overflow-wrap:break-word;padding-inline-start:0.3rem;text-align:start}#siteHeader,#userDisplayNameHeader,#userNameHeader{font-weight:bold}#siteHeader{margin-inline-start:1rem}.edit{display:flex;flex-direction:column}#title{user-select:none}
    </style>

    <cr-dialog id="dialog" close-text="$i18n{cancel}" ignore-popstate
        on-close="onDialogClosed_">
      <div id="title" slot="title">[[dialogTitle_]]</div>

      <div slot="body">
        <cr-page-selector attr-for-selected="id" selected="[[dialogPage_]]"
            on-iron-select="onIronSelect_">
          <div id="initial">
            <p>$i18n{securityKeysTouchToContinue}</p>
            <div class="spinner"></div>
          </div>

          <div id="pinPrompt">
            <settings-security-keys-pin-field id="pin"
                min-pin-length="[[minPinLength_]]">
            </settings-security-keys-pin-field>
          </div>

          <div id="credentials">
            <div id="header" class="list-item column-header">
              <div class="site" id="siteHeader">
                $i18n{securityKeysCredentialWebsiteLabel}
              </div>
              <div class="user-display-name" id="userDisplayNameHeader">
                $i18n{securityKeysCredentialDisplayNameLabel}
              </div>
              <div class="user-name" id="userNameHeader">
                $i18n{securityKeysCredentialUsernameLabel}
              </div>
              <div class="icon-placeholder"></div>
              <div class="icon-placeholder"></div>
            </div>

            <div id="container">
              <iron-list id="credentialList" items="[[credentials_]]"
                  class="cr-separators list-with-header">
                <template>
                  <div class="list-item">
                    <site-favicon url="[[item.relyingPartyId]]"></site-favicon>
                    <div class="site">[[item.relyingPartyId]]</div>
                    <div class="user-display-name">
                      [[item.userDisplayName]]
                    </div>
                    <div class="user-name">[[item.userName]]</div>
                    <cr-icon-button iron-icon="cr:create"
                        aria-label="$i18n{edit}"
                        class="edit-button"
                        on-click="onUpdateButtonClick_"
                        hidden="[[!editButtonVisible_]]"
                        data-credentialid$="[[item.credentialId]]">
                    </cr-icon-button>
                    <cr-icon-button iron-icon="cr:delete"
                        aria-label="$i18n{delete}"
                        class="delete-button"
                        on-click="onDeleteButtonClick_"
                        data-credentialid$="[[item.credentialId]]">
                    </cr-icon-button>
                  </div>
                </template>
              </iron-list>
            </div>
          </div>

          <div id="edit">
            <div class="edit-item">
              <cr-input id="displayNameInput"
                  value="{{newDisplayName_}}"
                  spellcheck="false"
                  on-input="validateInput_"
                  label="$i18n{securityKeysCredentialDisplayNameLabel}"
                  error-message="[[displayNameInputError_]]"
                  invalid="[[!isEmpty_(displayNameInputError_)]]">
              </cr-input>
            </div>
            <div class="edit-item">
              <cr-input id="userNameInput"
                  value="{{newUsername_}}"
                  spellcheck="false"
                  on-input="validateInput_"
                  label="$i18n{securityKeysCredentialUsernameLabel}"
                  error-message="[[userNameInputError_]]"
                  invalid="[[!isEmpty_(userNameInputError_)]]">
              </cr-input>
            </div>
          </div>
          <div id="pinError">[[errorMsg_]]</div>
          <div id="error">[[errorMsg_]]</div>
          <div id="confirm">[[confirmMsg_]]</div>
        </cr-page-selector>
      </div>

      <div slot="button-container">
        <cr-button id="cancelButton" class="cancel-button"
            on-click="onCancelButtonClick_" hidden="[[!cancelButtonVisible_]]">
          $i18n{cancel}
        </cr-button>
        <cr-button id="confirmButton" class="action-button"
            on-click="onConfirmButtonClick_"
            disabled="[[confirmButtonDisabled_]]"
            hidden="[[!confirmButtonVisible_]]">
          [[confirmButtonLabel_]]
        </cr-button>
        <cr-button id="closeButton" class="action-button"
            on-click="close_"
            hidden="[[!closeButtonVisible_]]">
          $i18n{close}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-security-keys-credential-management-dialog' is a
 * dialog for viewing and erasing credentials stored on a security key.
 */
var CredentialManagementDialogPage;
(function (CredentialManagementDialogPage) {
    CredentialManagementDialogPage["INITIAL"] = "initial";
    CredentialManagementDialogPage["PIN_PROMPT"] = "pinPrompt";
    CredentialManagementDialogPage["PIN_ERROR"] = "pinError";
    CredentialManagementDialogPage["CREDENTIALS"] = "credentials";
    CredentialManagementDialogPage["EDIT"] = "edit";
    CredentialManagementDialogPage["ERROR"] = "error";
    CredentialManagementDialogPage["CONFIRM"] = "confirm";
})(CredentialManagementDialogPage || (CredentialManagementDialogPage = {}));
const SettingsSecurityKeysCredentialManagementDialogElementBase = WebUiListenerMixin(I18nMixin(PolymerElement));
const MAX_INPUT_LENGTH = 62;
class SettingsSecurityKeysCredentialManagementDialogElement extends SettingsSecurityKeysCredentialManagementDialogElementBase {
    static get is() {
        return 'settings-security-keys-credential-management-dialog';
    }
    static get template() {
        return getTemplate$1U();
    }
    static get properties() {
        return {
            /**
             * The ID of the element currently shown in the dialog.
             */
            dialogPage_: {
                type: String,
                value: CredentialManagementDialogPage.INITIAL,
                observer: 'dialogPageChanged_',
            },
            dialogTitle_: String,
            /**
             * The list of credentials displayed in the dialog.
             */
            credentials_: {
                type: Array,
                notify: true,
            },
            /**
             * The message displayed on the "error" dialog page.
             */
            errorMsg_: String,
            cancelButtonVisible_: Boolean,
            closeButtonVisible_: Boolean,
            confirmButtonDisabled_: Boolean,
            confirmButtonLabel_: String,
            confirmButtonVisible_: Boolean,
            confirmMsg_: String,
            credentialIdToDelete_: String,
            displayNameInputError_: String,
            editingCredential_: Object,
            editButtonVisible_: Boolean,
            minPinLength_: Number,
            newDisplayName_: String,
            newUsername_: String,
            userNameInputError_: String,
        };
    }
    browserProxy_ = SecurityKeysCredentialBrowserProxyImpl.getInstance();
    showSetPINButton_ = false;
    connectedCallback() {
        super.connectedCallback();
        this.$.dialog.showModal();
        this.addWebUiListener('security-keys-credential-management-finished', (error, requiresPINChange = false) => this.onPinError_(error, requiresPINChange));
        this.browserProxy_.startCredentialManagement().then((response) => {
            this.minPinLength_ = response.minPinLength;
            this.editButtonVisible_ = response.supportsUpdateUserInformation;
            this.dialogPage_ = CredentialManagementDialogPage.PIN_PROMPT;
        });
    }
    onPinError_(error, requiresPINChange = false) {
        this.errorMsg_ = error;
        this.showSetPINButton_ = requiresPINChange;
        this.dialogPage_ = CredentialManagementDialogPage.PIN_ERROR;
    }
    onError_(error) {
        this.errorMsg_ = error;
        this.dialogPage_ = CredentialManagementDialogPage.ERROR;
    }
    submitPin_() {
        // Disable the confirm button to prevent concurrent submissions.
        this.confirmButtonDisabled_ = true;
        this.$.pin.trySubmit(pin => this.browserProxy_.providePin(pin))
            .then(() => {
            // Leave confirm button disabled while enumerating credentials.
            this.browserProxy_.enumerateCredentials().then((credentials) => this.onCredentials_(credentials));
        }, () => {
            // Wrong PIN.
            this.confirmButtonDisabled_ = false;
        });
    }
    onCredentials_(credentials) {
        this.credentials_ = credentials;
        this.$.credentialList.fire('iron-resize');
        this.dialogPage_ = CredentialManagementDialogPage.CREDENTIALS;
    }
    dialogPageChanged_() {
        switch (this.dialogPage_) {
            case CredentialManagementDialogPage.INITIAL:
                this.cancelButtonVisible_ = true;
                this.confirmButtonVisible_ = false;
                this.closeButtonVisible_ = false;
                this.dialogTitle_ =
                    this.i18n('securityKeysCredentialManagementDialogTitle');
                break;
            case CredentialManagementDialogPage.PIN_PROMPT:
                this.cancelButtonVisible_ = false;
                this.confirmButtonLabel_ = this.i18n('continue');
                this.confirmButtonDisabled_ = false;
                this.confirmButtonVisible_ = true;
                this.closeButtonVisible_ = false;
                this.dialogTitle_ =
                    this.i18n('securityKeysCredentialManagementDialogTitle');
                this.$.pin.focus();
                break;
            case CredentialManagementDialogPage.PIN_ERROR:
                this.cancelButtonVisible_ = true;
                this.confirmButtonLabel_ = this.i18n('securityKeysSetPinButton');
                this.confirmButtonVisible_ = this.showSetPINButton_;
                this.confirmButtonDisabled_ = false;
                this.closeButtonVisible_ = false;
                this.dialogTitle_ =
                    this.i18n('securityKeysCredentialManagementDialogTitle');
                break;
            case CredentialManagementDialogPage.CREDENTIALS:
                this.cancelButtonVisible_ = false;
                this.confirmButtonLabel_ = this.i18n('done');
                this.confirmButtonDisabled_ = false;
                this.confirmButtonVisible_ = true;
                this.closeButtonVisible_ = false;
                this.dialogTitle_ =
                    this.i18n('securityKeysCredentialManagementDialogTitle');
                break;
            case CredentialManagementDialogPage.EDIT:
                this.cancelButtonVisible_ = true;
                this.confirmButtonLabel_ = this.i18n('save');
                this.confirmButtonDisabled_ = false;
                this.confirmButtonVisible_ = true;
                this.closeButtonVisible_ = false;
                this.dialogTitle_ =
                    this.i18n('securityKeysUpdateCredentialDialogTitle');
                break;
            case CredentialManagementDialogPage.ERROR:
                this.cancelButtonVisible_ = false;
                this.confirmButtonLabel_ = this.i18n('continue');
                this.confirmButtonDisabled_ = false;
                this.confirmButtonVisible_ = true;
                this.closeButtonVisible_ = false;
                this.dialogTitle_ =
                    this.i18n('securityKeysCredentialManagementDialogTitle');
                break;
            case CredentialManagementDialogPage.CONFIRM:
                this.cancelButtonVisible_ = true;
                this.confirmButtonLabel_ = this.i18n('delete');
                this.confirmButtonVisible_ = true;
                this.closeButtonVisible_ = false;
                this.dialogTitle_ =
                    this.i18n('securityKeysCredentialManagementConfirmDeleteTitle');
                break;
            default:
                assertNotReached();
        }
        this.dispatchEvent(new CustomEvent('credential-management-dialog-ready-for-testing', { bubbles: true, composed: true }));
    }
    onConfirmButtonClick_() {
        switch (this.dialogPage_) {
            case CredentialManagementDialogPage.PIN_PROMPT:
                this.submitPin_();
                break;
            case CredentialManagementDialogPage.PIN_ERROR:
                this.$.dialog.close();
                this.dispatchEvent(new CustomEvent('credential-management-set-pin', { bubbles: true, composed: true }));
                break;
            case CredentialManagementDialogPage.CREDENTIALS:
                this.$.dialog.close();
                break;
            case CredentialManagementDialogPage.EDIT:
                this.updateUserInformation_();
                break;
            case CredentialManagementDialogPage.ERROR:
                this.dialogPage_ = CredentialManagementDialogPage.CREDENTIALS;
                break;
            case CredentialManagementDialogPage.CONFIRM:
                this.deleteCredential_();
                break;
            default:
                assertNotReached();
        }
    }
    onCancelButtonClick_() {
        switch (this.dialogPage_) {
            case CredentialManagementDialogPage.INITIAL:
            case CredentialManagementDialogPage.PIN_PROMPT:
            case CredentialManagementDialogPage.PIN_ERROR:
            case CredentialManagementDialogPage.CREDENTIALS:
                this.$.dialog.close();
                break;
            case CredentialManagementDialogPage.EDIT:
            case CredentialManagementDialogPage.ERROR:
            case CredentialManagementDialogPage.CONFIRM:
                this.dialogPage_ = CredentialManagementDialogPage.CREDENTIALS;
                break;
            default:
                assertNotReached();
        }
    }
    onDialogClosed_() {
        this.browserProxy_.close();
    }
    close_() {
        this.$.dialog.close();
    }
    isEmpty_(str) {
        return !str || str.length === 0;
    }
    onIronSelect_(e) {
        // Prevent this event from bubbling since it is unnecessarily triggering
        // the listener within settings-animated-pages.
        e.stopPropagation();
        // Asynchronously notify the iron-list of the possible resize.
        setTimeout(() => this.$.credentialList.notifyResize(), 0);
    }
    onDeleteButtonClick_(e) {
        const target = e.target;
        this.credentialIdToDelete_ = target.dataset['credentialid'];
        assert(!this.isEmpty_(this.credentialIdToDelete_));
        this.confirmMsg_ =
            this.i18n('securityKeysCredentialManagementConfirmDeleteCredential');
        this.dialogPage_ = CredentialManagementDialogPage.CONFIRM;
    }
    deleteCredential_() {
        this.browserProxy_.deleteCredentials([this.credentialIdToDelete_])
            .then((response) => {
            if (!response.success) {
                this.onError_(response.message);
                return;
            }
            for (let i = 0; i < this.credentials_.length; i++) {
                if (this.credentials_[i].credentialId ===
                    this.credentialIdToDelete_) {
                    this.credentials_.splice(i, 1);
                    break;
                }
            }
            this.dialogPage_ = CredentialManagementDialogPage.CREDENTIALS;
        });
    }
    validateInput_() {
        this.displayNameInputError_ =
            this.newDisplayName_.length > MAX_INPUT_LENGTH ?
                this.i18n('securityKeysInputTooLong') :
                '';
        this.userNameInputError_ = this.newUsername_.length > MAX_INPUT_LENGTH ?
            this.i18n('securityKeysInputTooLong') :
            '';
        this.confirmButtonDisabled_ =
            !this.isEmpty_(this.displayNameInputError_ + this.userNameInputError_);
    }
    onUpdateButtonClick_(e) {
        const target = e.target;
        for (const credential of this.credentials_) {
            if (credential.credentialId === target.dataset['credentialid']) {
                this.editingCredential_ = credential;
                break;
            }
        }
        this.newDisplayName_ = this.editingCredential_.userDisplayName;
        this.newUsername_ = this.editingCredential_.userName;
        this.dialogPage_ = CredentialManagementDialogPage.EDIT;
    }
    updateUserInformation_() {
        assert(this.dialogPage_ === CredentialManagementDialogPage.EDIT);
        if (this.isEmpty_(this.newUsername_)) {
            this.newUsername_ = this.editingCredential_.userName;
        }
        if (this.isEmpty_(this.newDisplayName_)) {
            this.newDisplayName_ = this.editingCredential_.userDisplayName;
        }
        this.browserProxy_
            .updateUserInformation(this.editingCredential_.credentialId, this.editingCredential_.userHandle, this.newUsername_, this.newDisplayName_)
            .then((response) => {
            if (!response.success) {
                this.onError_(response.message);
                return;
            }
            for (let i = 0; i < this.credentials_.length; i++) {
                if (this.credentials_[i].credentialId ===
                    this.editingCredential_.credentialId) {
                    const newCred = Object.assign({}, this.credentials_[i]);
                    newCred.userName = this.newUsername_;
                    newCred.userDisplayName = this.newDisplayName_;
                    this.credentials_.splice(i, 1, newCred);
                    this.$.credentialList.fire('iron-resize');
                    break;
                }
            }
        });
        this.dialogPage_ = CredentialManagementDialogPage.CREDENTIALS;
    }
}
customElements.define(SettingsSecurityKeysCredentialManagementDialogElement.is, SettingsSecurityKeysCredentialManagementDialogElement);

const div$2 = document.createElement('div');
div$2.innerHTML = getTrustedHTML `<cr-iconset name="fingerprint-icon" size="32">
  <svg>
    <defs>
      <g id="fingerprint-scanned-dark" viewBox="0 0 93 104">
        <path fill="#669df6" d="M75.346031,12.4513714 C65.426031,7.33637143 56.8487739,5.16637143 46.5674024,5.16637143 C36.3374024,5.16637143 26.6237739,7.595 17.7896596,12.4513714 C16.5487739,13.1227429 14.9987739,12.6577429 14.276031,11.4177429 C13.6046596,10.1777429 14.0696596,8.57637143 15.3096596,7.905 C24.9196596,2.68637143 35.4596596,0 46.5674024,0 C57.5732882,0 67.1824024,2.42774286 77.7232882,7.85274286 C79.0146596,8.525 79.4796596,10.075 78.8074024,11.315 C78.3424024,12.245 77.4646596,12.7613714 76.5346596,12.7613714 C76.121031,12.7613714 75.7074024,12.6577429 75.346031,12.4513714 Z">
        </path>
        <path fill="#5bb974" d="M1.10147387,39.4213714 C-0.0871547017,38.595 -0.344897559,36.9927429 0.480588155,35.805 C5.59647387,28.5713714 12.1055882,22.8877429 19.8555882,18.91 C36.0801024,10.54 56.8492167,10.4877429 73.1242167,18.8577429 C80.8742167,22.8363714 87.3851024,28.4677429 92.4992167,35.65 C93.3264739,36.7863714 93.0678453,38.44 91.8801024,39.2663714 C90.6914739,40.0927429 89.0892167,39.835 88.2628453,38.6463714 C83.6128453,32.1363714 77.7228453,27.0213714 70.7478453,23.4563714 C55.9192167,15.8613714 36.9578453,15.8613714 22.1805882,23.5077429 C15.1551024,27.125 9.26421673,32.2913714 4.61421673,38.8013714 C4.20147387,39.525 3.42647387,39.8863714 2.59921673,39.8863714 C2.0828453,39.8863714 1.56647387,39.7313714 1.10147387,39.4213714 Z">
        </path>
        <path fill="#fcc934" d="M33.0827567,101.473097 C28.5877567,96.9780971 26.1600139,94.0844686 22.6977567,87.8330971 C19.1327567,81.4780971 17.2727567,73.7280971 17.2727567,65.4094686 C17.2727567,50.0644686 30.3963853,37.5617257 46.5163853,37.5617257 C62.6354996,37.5617257 75.7600139,50.0644686 75.7600139,65.4094686 C75.7600139,66.8567257 74.6227567,67.9930971 73.1763853,67.9930971 C71.7300139,67.9930971 70.5927567,66.8567257 70.5927567,65.4094686 C70.5927567,52.9067257 59.7941282,42.7280971 46.5163853,42.7280971 C33.2377567,42.7280971 22.4391282,52.9067257 22.4391282,65.4094686 C22.4391282,72.8494686 24.0927567,79.7217257 27.2441282,85.3017257 C30.5513853,91.2430971 32.8241282,93.7744686 36.8027567,97.8044686 C37.7850139,98.8380971 37.7850139,100.439469 36.8027567,101.473097 C36.2350139,101.989469 35.5627567,102.248097 34.8913853,102.248097 C34.2191282,102.248097 33.5477567,101.989469 33.0827567,101.473097 Z">
        </path>
        <path fill="#ea4335" d="M55.9193939,88.0911057 C48.221651,82.8733629 43.6230224,74.3997343 43.6230224,65.4097343 C43.6230224,63.9633629 44.7593939,62.8261057 46.2057653,62.8261057 C47.6530224,62.8261057 48.7893939,63.9633629 48.7893939,65.4097343 C48.7893939,72.6947343 52.5093939,79.5661057 58.8130224,83.8033629 C62.4807653,86.2833629 66.7693939,87.4711057 71.9357653,87.4711057 C73.1757653,87.4711057 75.2421367,87.3161057 77.3093939,86.9547343 C78.7052796,86.6961057 80.0480224,87.6261057 80.3057653,89.0733629 C80.5643939,90.4683629 79.6343939,91.8111057 78.1880224,92.0697343 C75.2421367,92.6383629 72.6593939,92.6897343 71.9357653,92.6897343 C65.7880224,92.6897343 60.3630224,91.1397343 55.9193939,88.0911057 Z">
        </path>
        <path fill="#669df6" d="M60.8797482,103.229557 C52.6647482,100.955929 47.2911196,97.9081857 41.6597482,92.3795571 C34.4261196,85.1981857 30.4483767,75.6395571 30.4483767,65.4095571 C30.4483767,57.0395571 37.5783767,50.2195571 46.3611196,50.2195571 C55.1447482,50.2195571 62.2738624,57.0395571 62.2738624,65.4095571 C62.2738624,70.9381857 67.0797482,75.4331857 73.0211196,75.4331857 C78.962491,75.4331857 83.767491,70.9381857 83.767491,65.4095571 C83.767491,45.9309286 66.9761196,30.1218143 46.3097482,30.1218143 C31.6361196,30.1218143 18.2033767,38.2845571 12.157491,50.9431857 C10.142491,55.1281857 9.10974816,60.0359286 9.10974816,65.4095571 C9.10974816,69.4395571 9.47111958,75.7945571 12.5711196,84.0609286 C13.087491,85.4045571 12.4161196,86.9031857 11.0733767,87.3681857 C9.72974816,87.8845571 8.23111958,87.1609286 7.76611958,85.8695571 C5.23474816,79.1018143 3.99474816,72.3845571 3.99474816,65.4095571 C3.99474816,59.2095571 5.18249101,53.5781857 7.50749101,48.6695571 C14.3797482,34.2545571 29.6211196,24.9031857 46.3097482,24.9031857 C69.817491,24.9031857 88.9347482,43.0381857 88.9347482,65.3581857 C88.9347482,73.7281857 81.8047482,80.5481857 73.0211196,80.5481857 C64.237491,80.5481857 57.107491,73.7281857 57.107491,65.3581857 C57.107491,59.8295571 52.3033767,55.3345571 46.3611196,55.3345571 C40.4197482,55.3345571 35.6147482,59.8295571 35.6147482,65.3581857 C35.6147482,74.1931857 39.0238624,82.4595571 45.2761196,88.6595571 C50.1847482,93.5168143 54.8861196,96.2031857 62.1711196,98.2181857 C63.5661196,98.5795571 64.3411196,100.026814 63.9797482,101.369557 C63.7211196,102.558186 62.6361196,103.333186 61.5511196,103.333186 C61.3447482,103.333186 61.0861196,103.280929 60.8797482,103.229557 Z">
        </path>
      </g>
      <g id="fingerprint-scanned-light" viewBox="0 0 93 104">
        <path fill="#4285f4" d="M75.346031,12.4513714 C65.426031,7.33637143 56.8487739,5.16637143 46.5674024,5.16637143 C36.3374024,5.16637143 26.6237739,7.595 17.7896596,12.4513714 C16.5487739,13.1227429 14.9987739,12.6577429 14.276031,11.4177429 C13.6046596,10.1777429 14.0696596,8.57637143 15.3096596,7.905 C24.9196596,2.68637143 35.4596596,0 46.5674024,0 C57.5732882,0 67.1824024,2.42774286 77.7232882,7.85274286 C79.0146596,8.525 79.4796596,10.075 78.8074024,11.315 C78.3424024,12.245 77.4646596,12.7613714 76.5346596,12.7613714 C76.121031,12.7613714 75.7074024,12.6577429 75.346031,12.4513714 Z">
        </path>
        <path fill="#34a853" d="M1.10147387,39.4213714 C-0.0871547017,38.595 -0.344897559,36.9927429 0.480588155,35.805 C5.59647387,28.5713714 12.1055882,22.8877429 19.8555882,18.91 C36.0801024,10.54 56.8492167,10.4877429 73.1242167,18.8577429 C80.8742167,22.8363714 87.3851024,28.4677429 92.4992167,35.65 C93.3264739,36.7863714 93.0678453,38.44 91.8801024,39.2663714 C90.6914739,40.0927429 89.0892167,39.835 88.2628453,38.6463714 C83.6128453,32.1363714 77.7228453,27.0213714 70.7478453,23.4563714 C55.9192167,15.8613714 36.9578453,15.8613714 22.1805882,23.5077429 C15.1551024,27.125 9.26421673,32.2913714 4.61421673,38.8013714 C4.20147387,39.525 3.42647387,39.8863714 2.59921673,39.8863714 C2.0828453,39.8863714 1.56647387,39.7313714 1.10147387,39.4213714 Z">
        </path>
        <path fill="#fbbc04" d="M33.0827567,101.473097 C28.5877567,96.9780971 26.1600139,94.0844686 22.6977567,87.8330971 C19.1327567,81.4780971 17.2727567,73.7280971 17.2727567,65.4094686 C17.2727567,50.0644686 30.3963853,37.5617257 46.5163853,37.5617257 C62.6354996,37.5617257 75.7600139,50.0644686 75.7600139,65.4094686 C75.7600139,66.8567257 74.6227567,67.9930971 73.1763853,67.9930971 C71.7300139,67.9930971 70.5927567,66.8567257 70.5927567,65.4094686 C70.5927567,52.9067257 59.7941282,42.7280971 46.5163853,42.7280971 C33.2377567,42.7280971 22.4391282,52.9067257 22.4391282,65.4094686 C22.4391282,72.8494686 24.0927567,79.7217257 27.2441282,85.3017257 C30.5513853,91.2430971 32.8241282,93.7744686 36.8027567,97.8044686 C37.7850139,98.8380971 37.7850139,100.439469 36.8027567,101.473097 C36.2350139,101.989469 35.5627567,102.248097 34.8913853,102.248097 C34.2191282,102.248097 33.5477567,101.989469 33.0827567,101.473097 Z">
        </path>
        <path fill="#ea4335" d="M55.9193939,88.0911057 C48.221651,82.8733629 43.6230224,74.3997343 43.6230224,65.4097343 C43.6230224,63.9633629 44.7593939,62.8261057 46.2057653,62.8261057 C47.6530224,62.8261057 48.7893939,63.9633629 48.7893939,65.4097343 C48.7893939,72.6947343 52.5093939,79.5661057 58.8130224,83.8033629 C62.4807653,86.2833629 66.7693939,87.4711057 71.9357653,87.4711057 C73.1757653,87.4711057 75.2421367,87.3161057 77.3093939,86.9547343 C78.7052796,86.6961057 80.0480224,87.6261057 80.3057653,89.0733629 C80.5643939,90.4683629 79.6343939,91.8111057 78.1880224,92.0697343 C75.2421367,92.6383629 72.6593939,92.6897343 71.9357653,92.6897343 C65.7880224,92.6897343 60.3630224,91.1397343 55.9193939,88.0911057 Z">
        </path>
        <path fill="#4285f4" d="M60.8797482,103.229557 C52.6647482,100.955929 47.2911196,97.9081857 41.6597482,92.3795571 C34.4261196,85.1981857 30.4483767,75.6395571 30.4483767,65.4095571 C30.4483767,57.0395571 37.5783767,50.2195571 46.3611196,50.2195571 C55.1447482,50.2195571 62.2738624,57.0395571 62.2738624,65.4095571 C62.2738624,70.9381857 67.0797482,75.4331857 73.0211196,75.4331857 C78.962491,75.4331857 83.767491,70.9381857 83.767491,65.4095571 C83.767491,45.9309286 66.9761196,30.1218143 46.3097482,30.1218143 C31.6361196,30.1218143 18.2033767,38.2845571 12.157491,50.9431857 C10.142491,55.1281857 9.10974816,60.0359286 9.10974816,65.4095571 C9.10974816,69.4395571 9.47111958,75.7945571 12.5711196,84.0609286 C13.087491,85.4045571 12.4161196,86.9031857 11.0733767,87.3681857 C9.72974816,87.8845571 8.23111958,87.1609286 7.76611958,85.8695571 C5.23474816,79.1018143 3.99474816,72.3845571 3.99474816,65.4095571 C3.99474816,59.2095571 5.18249101,53.5781857 7.50749101,48.6695571 C14.3797482,34.2545571 29.6211196,24.9031857 46.3097482,24.9031857 C69.817491,24.9031857 88.9347482,43.0381857 88.9347482,65.3581857 C88.9347482,73.7281857 81.8047482,80.5481857 73.0211196,80.5481857 C64.237491,80.5481857 57.107491,73.7281857 57.107491,65.3581857 C57.107491,59.8295571 52.3033767,55.3345571 46.3611196,55.3345571 C40.4197482,55.3345571 35.6147482,59.8295571 35.6147482,65.3581857 C35.6147482,74.1931857 39.0238624,82.4595571 45.2761196,88.6595571 C50.1847482,93.5168143 54.8861196,96.2031857 62.1711196,98.2181857 C63.5661196,98.5795571 64.3411196,100.026814 63.9797482,101.369557 C63.7211196,102.558186 62.6361196,103.333186 61.5511196,103.333186 C61.3447482,103.333186 61.0861196,103.280929 60.8797482,103.229557 Z">
        </path>
      </g>
    </defs>
  </svg>
</cr-iconset>
`;
const iconsets$2 = div$2.querySelectorAll('cr-iconset');
for (const iconset of iconsets$2) {
    document.head.appendChild(iconset);
}

let instance$k = null;
function getCss$8() {
    return instance$k || (instance$k = [...[], css `canvas{height:100%;width:100%}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$8() {
    return html$1 `<canvas id="canvas" ?hidden="${this.hidden}"></canvas>`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-lottie' is a wrapper around the player for lottie
 * animations. Since the player runs on a worker thread, 'cr-lottie' requires
 * the document CSP to be set to "worker-src blob: chrome://resources 'self';".
 *
 * For documents that have TrustedTypes CSP checks enabled, it also requires the
 * document CSP to be set to "trusted-types lottie-worker-script-loader;".
 *
 * Fires a 'cr-lottie-initialized' event when the animation was successfully
 * initialized.
 * Fires a 'cr-lottie-playing' event when the animation starts playing.
 * Fires a 'cr-lottie-paused' event when the animation has paused.
 * Fires a 'cr-lottie-stopped' event when animation has stopped.
 * Fires a 'cr-lottie-resized' event when the canvas the animation is being
 * drawn on is resized.
 */
let workerLoaderPolicy = null;
function getLottieWorkerURL() {
    if (workerLoaderPolicy === null) {
        workerLoaderPolicy =
            window.trustedTypes.createPolicy('lottie-worker-script-loader', {
                createScriptURL: (_ignore) => {
                    const script = `import 'chrome://resources/lottie/lottie_worker.min.js';`;
                    // CORS blocks loading worker script from a different origin, even
                    // if chrome://resources/ is added in the 'worker-src' CSP header.
                    // (see https://crbug.com/1385477). Loading scripts as blob and then
                    // instantiating it as web worker is possible.
                    const blob = new Blob([script], { type: 'text/javascript' });
                    return URL.createObjectURL(blob);
                },
                createHTML: () => assertNotReached(),
                createScript: () => assertNotReached(),
            });
    }
    return workerLoaderPolicy.createScriptURL('');
}
class CrLottieElement extends CrLitElement {
    static get is() {
        return 'cr-lottie';
    }
    static get styles() {
        return getCss$8();
    }
    render() {
        return getHtml$8.bind(this)();
    }
    static get properties() {
        return {
            animationUrl: { type: String },
            autoplay: { type: Boolean },
            hidden: { type: Boolean },
            singleLoop: { type: Boolean },
        };
    }
    #animationUrl_accessor_storage = '';
    get animationUrl() { return this.#animationUrl_accessor_storage; }
    set animationUrl(value) { this.#animationUrl_accessor_storage = value; }
    #autoplay_accessor_storage = false;
    get autoplay() { return this.#autoplay_accessor_storage; }
    set autoplay(value) { this.#autoplay_accessor_storage = value; }
    #hidden_accessor_storage = false;
    get hidden() { return this.#hidden_accessor_storage; }
    set hidden(value) { this.#hidden_accessor_storage = value; }
    #singleLoop_accessor_storage = false;
    get singleLoop() { return this.#singleLoop_accessor_storage; }
    set singleLoop(value) { this.#singleLoop_accessor_storage = value; }
    canvasElement_ = null;
    isAnimationLoaded_ = false;
    offscreenCanvas_ = null;
    /** Whether the canvas has been transferred to the worker thread. */
    hasTransferredCanvas_ = false;
    resizeObserver_ = null;
    /**
     * The last state that was explicitly set via setPlay.
     * In case setPlay() is invoked before the animation is initialized, the
     * state is stored in this variable. Once the animation initializes, the
     * state is sent to the worker.
     */
    playState_ = false;
    /**
     * Whether the Worker needs to receive new size
     * information about the canvas. This is necessary for the corner case
     * when the size information is received when the animation is still being
     * loaded into the worker.
     */
    workerNeedsSizeUpdate_ = false;
    /**
     * Whether the Worker needs to receive new control
     * information about its desired state. This is necessary for the corner
     * case when the control information is received when the animation is still
     * being loaded into the worker.
     */
    workerNeedsPlayControlUpdate_ = false;
    worker_ = null;
    /** The current in-flight request. */
    xhr_ = null;
    connectedCallback() {
        super.connectedCallback();
        this.worker_ =
            new Worker(getLottieWorkerURL(), { type: 'module' });
        this.worker_.onmessage = this.onMessage_.bind(this);
        this.initialize_();
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        if (this.resizeObserver_) {
            this.resizeObserver_.disconnect();
        }
        if (this.worker_) {
            this.worker_.terminate();
            this.worker_ = null;
        }
        if (this.xhr_) {
            this.xhr_.abort();
            this.xhr_ = null;
        }
    }
    /**
     * Updates the animation that is being displayed.
     */
    updated(changedProperties) {
        super.updated(changedProperties);
        if (!changedProperties.has('animationUrl')) {
            return;
        }
        if (!this.worker_) {
            // The worker hasn't loaded yet. We will load the new animation once the
            // worker loads.
            return;
        }
        if (this.xhr_) {
            // There is an in-flight request to load the previous animation. Abort it
            // before loading a new image.
            this.xhr_.abort();
            this.xhr_ = null;
        }
        if (this.isAnimationLoaded_) {
            this.worker_.postMessage({ control: { stop: true } });
            this.isAnimationLoaded_ = false;
        }
        this.sendXmlHttpRequest_(this.animationUrl, 'json', this.initAnimation_.bind(this));
    }
    /**
     * Controls the animation based on the value of |shouldPlay|. If the
     * animation is being loaded into the worker when this method is invoked,
     * the action will be postponed to when the animation is fully loaded.
     * @param shouldPlay True for play, false for pause.
     */
    setPlay(shouldPlay) {
        this.playState_ = shouldPlay;
        if (this.isAnimationLoaded_) {
            this.sendPlayControlInformationToWorker_();
        }
        else {
            this.workerNeedsPlayControlUpdate_ = true;
        }
    }
    /**
     * Sends control (play/pause) information to the worker.
     */
    sendPlayControlInformationToWorker_() {
        assert(this.worker_);
        this.worker_.postMessage({ control: { play: this.playState_ } });
    }
    /**
     * Initializes all the members of this element.
     */
    initialize_() {
        // Generate an offscreen canvas.
        this.canvasElement_ = this.$.canvas;
        this.offscreenCanvas_ = this.canvasElement_.transferControlToOffscreen();
        this.resizeObserver_ =
            new ResizeObserver(this.onCanvasElementResized_.bind(this));
        this.resizeObserver_.observe(this.canvasElement_);
        if (this.isAnimationLoaded_) {
            return;
        }
        // Open animation file and start playing the animation.
        this.sendXmlHttpRequest_(this.animationUrl, 'json', this.initAnimation_.bind(this));
    }
    /**
     * Computes the draw buffer size for the canvas. This ensures that the
     * rasterization is crisp and sharp rather than blurry.
     * @return Size of the canvas draw buffer
     */
    getCanvasDrawBufferSize_() {
        const canvasElement = this.$.canvas;
        const devicePixelRatio = window.devicePixelRatio;
        const clientRect = canvasElement.getBoundingClientRect();
        const drawSize = {
            width: clientRect.width * devicePixelRatio,
            height: clientRect.height * devicePixelRatio,
        };
        return drawSize;
    }
    /**
     * Returns true if the |maybeValidUrl| provided is safe to use in an
     * XMLHTTPRequest.
     * @param maybeValidUrl The url string to check for validity.
     */
    isValidUrl_(maybeValidUrl) {
        const url = new URL(maybeValidUrl, document.location.href);
        return url.protocol === 'chrome:' ||
            (url.protocol === 'data:' &&
                url.pathname.startsWith('application/json;'));
    }
    /**
     * Sends an XMLHTTPRequest to load a resource and runs the callback on
     * getting a successful response.
     * @param url The URL to load the resource.
     * @param responseType The type of response the request would
     *     give on success.
     * @param successCallback The callback to run
     *     when a successful response is received.
     */
    sendXmlHttpRequest_(url, responseType, successCallback) {
        assert(this.isValidUrl_(url), 'Invalid scheme or data url used.');
        assert(!this.xhr_);
        this.xhr_ = new XMLHttpRequest();
        this.xhr_.open('GET', url, true);
        this.xhr_.responseType = responseType;
        this.xhr_.send();
        this.xhr_.onreadystatechange = () => {
            assert(this.xhr_);
            if (this.xhr_.readyState === 4 && this.xhr_.status === 200) {
                // |successCallback| might trigger another xhr, so we set to null before
                // calling it.
                const response = this.xhr_.response;
                this.xhr_ = null;
                successCallback(response);
            }
        };
    }
    /**
     * Handles the canvas element resize event. If the animation isn't fully
     * loaded, the canvas size is sent later, once the loading is done.
     */
    onCanvasElementResized_() {
        if (this.isAnimationLoaded_) {
            this.sendCanvasSizeToWorker_();
        }
        else {
            // Mark a size update as necessary once the animation is loaded.
            this.workerNeedsSizeUpdate_ = true;
        }
    }
    /**
     * This informs the offscreen canvas worker of the current canvas size.
     */
    sendCanvasSizeToWorker_() {
        assert(this.worker_);
        this.worker_.postMessage({ drawSize: this.getCanvasDrawBufferSize_() });
    }
    /**
     * Initializes the the animation on the web worker with the data provided.
     * @param animationData The animation that will be played.
     */
    initAnimation_(animationData) {
        const message = {
            animationData,
            drawSize: this.getCanvasDrawBufferSize_(),
            params: { loop: !this.singleLoop, autoplay: this.autoplay },
        };
        assert(this.worker_);
        if (!this.hasTransferredCanvas_) {
            message.canvas = this.offscreenCanvas_;
            this.hasTransferredCanvas_ = true;
            this.worker_.postMessage(message, [this.offscreenCanvas_]);
        }
        else {
            this.worker_.postMessage(message);
        }
    }
    /**
     * Handles the messages sent from the web worker to its parent thread.
     * @param event Event sent by the web worker.
     */
    onMessage_(event) {
        if (event.data.name === 'initialized' && event.data.success) {
            this.isAnimationLoaded_ = true;
            this.sendPendingInfo_();
            this.fire('cr-lottie-initialized');
        }
        else if (event.data.name === 'playing') {
            this.fire('cr-lottie-playing');
        }
        else if (event.data.name === 'paused') {
            this.fire('cr-lottie-paused');
        }
        else if (event.data.name === 'stopped') {
            this.fire('cr-lottie-stopped');
        }
        else if (event.data.name === 'resized') {
            this.fire('cr-lottie-resized', event.data.size);
        }
    }
    /**
     * Called once the animation is fully loaded into the worker. Sends any
     * size or control information that may have arrived while the animation
     * was not yet fully loaded.
     */
    sendPendingInfo_() {
        if (this.workerNeedsSizeUpdate_) {
            this.workerNeedsSizeUpdate_ = false;
            this.sendCanvasSizeToWorker_();
        }
        if (this.workerNeedsPlayControlUpdate_) {
            this.workerNeedsPlayControlUpdate_ = false;
            this.sendPlayControlInformationToWorker_();
        }
    }
}
customElements.define(CrLottieElement.is, CrLottieElement);

function getTemplate$1T() {
    return html `<!--_html_template_start_-->    <style>:host{user-select:none}.translucent{opacity:0.3}#canvasDiv{height:240px;overflow:hidden;position:relative;width:460px}cr-lottie{display:inline-block;position:absolute}#fingerprintScanned{position:absolute}
    </style>

    <div id="canvasDiv">
      <canvas id="canvas" height="240" width="460"></canvas>
      <cr-lottie id="scanningAnimation" aria-hidden="true"
          autoplay="[[autoplay]]">
      </cr-lottie>
      <cr-icon id="fingerprintScanned" hidden></cr-icon>
    </div>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The dark-mode fingerprint icon displayed temporarily each time a user scans
 * their fingerprint and persistently once the enrollment process is complete.
 */
const FINGERPRINT_SCANNED_ICON_DARK = 'fingerprint-icon:fingerprint-scanned-dark';
/**
 * The light-mode fingerprint icon displayed temporarily each time a user scans
 * their fingerprint and persistently once the enrollment process is complete.
 */
const FINGERPRINT_SCANNED_ICON_LIGHT = 'fingerprint-icon:fingerprint-scanned-light';
const FINGERPRINT_CHECK_DARK_URL = 'chrome://theme/IDR_FINGERPRINT_COMPLETE_CHECK_DARK';
const FINGERPRINT_CHECK_LIGHT_URL = 'chrome://theme/IDR_FINGERPRINT_COMPLETE_CHECK_LIGHT';
/**
 * The dark-mode color of the progress circle background: Google Grey 700.
 */
const PROGRESS_CIRCLE_BACKGROUND_COLOR_DARK = 'rgba(95, 99, 104, 1.0)';
/**
 * The light-mode color of the progress circle background: Google Grey 200.
 */
const PROGRESS_CIRCLE_BACKGROUND_COLOR_LIGHT = 'rgba(232, 234, 237, 1.0)';
/**
 * The dark-mode color of the setup progress arc: Google Blue 400.
 */
const PROGRESS_CIRCLE_FILL_COLOR_DARK = 'rgba(102, 157, 246, 1.0)';
/**
 * The light-mode color of the setup progress arc: Google Blue 500.
 */
const PROGRESS_CIRCLE_FILL_COLOR_LIGHT = 'rgba(66, 133, 244, 1.0)';
/**
 * The time in milliseconds of the animation updates.
 */
const ANIMATE_TICKS_MS = 20;
/**
 * The duration in milliseconds of the animation of the progress circle when the
 * user is touching the scanner.
 */
const ANIMATE_DURATION_MS = 200;
/**
 * The radius of the add fingerprint progress circle.
 */
const DEFAULT_PROGRESS_CIRCLE_RADIUS = 114;
/**
 * The default height of the icon located in the center of the fingerprint
 * progress circle.
 */
const ICON_HEIGHT = 118;
/**
 * The default width of the icon located in the center of the fingerprint
 * progress circle.
 */
const ICON_WIDTH = 106;
/**
 * The default size of the check mark located in the bottom-right corner of the
 * fingerprint progress circle.
 */
const CHECK_MARK_SIZE = 53;
/**
 * The time in milliseconds of the fingerprint scan success timeout.
 */
const FINGERPRINT_SCAN_SUCCESS_MS = 500;
/**
 * The thickness of the fingerprint progress circle.
 */
const PROGRESS_CIRCLE_STROKE_WIDTH = 4;
class FingerprintProgressArcElement extends PolymerElement {
    static get is() {
        return 'fingerprint-progress-arc';
    }
    static get template() {
        return getTemplate$1T();
    }
    static get properties() {
        return {
            /**
             * Radius of the fingerprint progress circle being displayed.
             */
            circleRadius: {
                type: Number,
                value: DEFAULT_PROGRESS_CIRCLE_RADIUS,
            },
            /**
             * Whether lottie animation should be autoplayed.
             */
            autoplay: {
                type: Boolean,
                value: false,
            },
            /**
             * Scale factor based the configured radius (circleRadius) vs the default
             * radius (DEFAULT_PROGRESS_CIRCLE_RADIUS).
             * This will affect the size of icons and check mark.
             */
            scale_: {
                type: Number,
                value: 1.0,
            },
            /**
             * Whether fingerprint enrollment is complete.
             */
            isComplete_: Boolean,
        };
    }
    isDarkModeActive_ = false;
    eventTracker_ = new EventTracker();
    // Animation ID for the fingerprint progress circle.
    progressAnimationIntervalId_ = undefined;
    // Percentage of the enrollment process completed as of the last update.
    progressPercentDrawn_ = 0;
    // Timer ID for fingerprint scan success update.
    updateTimerId_ = undefined;
    /**
     * Updates the current state to account for whether dark mode is enabled.
     */
    onDarkModeChanged_(e) {
        // Update media query states.
        this.isDarkModeActive_ = e.matches;
        this.clearCanvas_();
        this.drawProgressCircle_(this.progressPercentDrawn_);
        this.updateAnimationAsset_();
        this.updateIconAsset_();
    }
    connectedCallback() {
        super.connectedCallback();
        // Set media query initial states.
        const darkModeQuery = window.matchMedia('(prefers-color-scheme: dark)');
        this.isDarkModeActive_ = darkModeQuery.matches;
        this.eventTracker_.add(darkModeQuery, 'change', (e) => this.onDarkModeChanged_(e));
        this.scale_ = this.circleRadius / DEFAULT_PROGRESS_CIRCLE_RADIUS;
        this.updateIconAsset_();
        this.updateImages_();
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.eventTracker_.removeAll();
    }
    /**
     * Reset the element to initial state, when the enrollment just starts.
     */
    reset() {
        this.cancelAnimations_();
        this.clearCanvas_();
        this.isComplete_ = false;
        // Draw an empty background for the progress circle.
        this.drawProgressCircle_(/** currentPercent = */ 0);
        this.$.fingerprintScanned.hidden = true;
        const scanningAnimation = this.$.scanningAnimation;
        scanningAnimation.singleLoop = false;
        scanningAnimation.classList.add('translucent');
        this.updateAnimationAsset_();
        this.resizeAndCenterIcon_(scanningAnimation);
        scanningAnimation.hidden = false;
    }
    /**
     * Animates the progress circle. Animates an arc that starts at the top of
     * the circle to prevPercentComplete, to an arc that starts at the top of the
     * circle to currPercentComplete.
     * @param prevPercentComplete The previous progress indicates the start angle
     *     of the arc we want to draw.
     * @param currPercentComplete The current progress indicates the end angle of
     *    the arc we want to draw.
     * @param isComplete Indicate whether enrollment is complete.
     */
    setProgress(prevPercentComplete, currPercentComplete, isComplete) {
        if (this.isComplete_) {
            return;
        }
        this.isComplete_ = isComplete;
        this.cancelAnimations_();
        let nextPercentToDraw = prevPercentComplete;
        const endPercent = isComplete ? 100 : Math.min(100, currPercentComplete);
        // The value by which to update the progress percent each tick.
        const step = (endPercent - prevPercentComplete) /
            (ANIMATE_DURATION_MS / ANIMATE_TICKS_MS);
        // Function that is called every tick of the interval, draws the arc a bit
        // closer to the final destination each tick, until it reaches the final
        // destination.
        const doAnimate = () => {
            if (nextPercentToDraw >= endPercent) {
                if (this.progressAnimationIntervalId_) {
                    clearInterval(this.progressAnimationIntervalId_);
                    this.progressAnimationIntervalId_ = undefined;
                }
                nextPercentToDraw = endPercent;
            }
            this.clearCanvas_();
            this.drawProgressCircle_(nextPercentToDraw);
            if (!this.progressAnimationIntervalId_) {
                this.dispatchEvent(new CustomEvent('fingerprint-progress-arc-drawn', { bubbles: true, composed: true }));
            }
            nextPercentToDraw += step;
        };
        this.progressAnimationIntervalId_ =
            setInterval(doAnimate, ANIMATE_TICKS_MS);
        if (isComplete) {
            this.animateScanComplete_();
        }
        else {
            this.animateScanProgress_();
        }
    }
    /**
     * Controls the animation based on the value of |shouldPlay|.
     * @param shouldPlay Will play the animation if true else pauses it.
     */
    setPlay(shouldPlay) {
        this.$.scanningAnimation.setPlay(shouldPlay);
    }
    isComplete() {
        return this.isComplete_;
    }
    /**
     * Draws an arc on the canvas element around the center with radius
     * |circleRadius|.
     * @param startAngle The start angle of the arc we want to draw.
     * @param endAngle The end angle of the arc we want to draw.
     * @param color The color of the arc we want to draw. The string is
     *     in the format rgba(r',g',b',a'). r', g', b' are values from [0-255]
     *     and a' is a value from [0-1].
     */
    drawArc_(startAngle, endAngle, color) {
        const c = this.$.canvas;
        const ctx = c.getContext('2d');
        assert(!!ctx);
        ctx.beginPath();
        ctx.arc(c.width / 2, c.height / 2, this.circleRadius, startAngle, endAngle);
        ctx.lineWidth = PROGRESS_CIRCLE_STROKE_WIDTH;
        ctx.strokeStyle = color;
        ctx.stroke();
    }
    /**
     * Draws a circle on the canvas element around the center with radius
     * |circleRadius|. The first |currentPercent| of the circle, starting at the
     * top, is drawn with |PROGRESS_CIRCLE_FILL_COLOR|; the remainder of the
     * circle is drawn |PROGRESS_CIRCLE_BACKGROUND_COLOR|.
     * @param currentPercent A value from [0-100] indicating the
     *     percentage of progress to display.
     */
    drawProgressCircle_(currentPercent) {
        // Angles on HTML canvases start at 0 radians on the positive x-axis and
        // increase in the clockwise direction. We want to start at the top of the
        // circle, which is 3pi/2.
        const start = 3 * Math.PI / 2;
        const currentAngle = 2 * Math.PI * currentPercent / 100;
        // Drawing two arcs to form a circle gives a nicer look than drawing an arc
        // on top of a circle (i.e., compared to drawing a full background circle
        // first). If |currentAngle| is 0, draw from 3pi/2 to 7pi/2 explicitly;
        // otherwise, the regular draw from |start| + |currentAngle| to |start|
        // will do nothing.
        this.drawArc_(start, start + currentAngle, this.isDarkModeActive_ ? PROGRESS_CIRCLE_FILL_COLOR_DARK :
            PROGRESS_CIRCLE_FILL_COLOR_LIGHT);
        this.drawArc_(start + currentAngle, currentAngle <= 0 ? 7 * Math.PI / 2 : start, this.isDarkModeActive_ ? PROGRESS_CIRCLE_BACKGROUND_COLOR_DARK :
            PROGRESS_CIRCLE_BACKGROUND_COLOR_LIGHT);
        this.progressPercentDrawn_ = currentPercent;
    }
    /**
     * Updates the lottie animation taking into account the current state and
     * whether dark mode is enabled.
     */
    updateAnimationAsset_() {
        const scanningAnimation = this.$.scanningAnimation;
        if (this.isComplete_) {
            scanningAnimation.animationUrl = this.isDarkModeActive_ ?
                FINGERPRINT_CHECK_DARK_URL :
                FINGERPRINT_CHECK_LIGHT_URL;
            return;
        }
        scanningAnimation.animationUrl = this.isDarkModeActive_ ?
            'chrome://theme/IDR_FINGERPRINT_ICON_ANIMATION_DARK' :
            'chrome://theme/IDR_FINGERPRINT_ICON_ANIMATION_LIGHT';
    }
    /**
     * Updates the fingerprint-scanned icon based on whether dark mode is enabled.
     */
    updateIconAsset_() {
        this.$.fingerprintScanned.icon = this.isDarkModeActive_ ?
            FINGERPRINT_SCANNED_ICON_DARK :
            FINGERPRINT_SCANNED_ICON_LIGHT;
    }
    /*
     * Cleans up any pending animation update created by setInterval().
     */
    cancelAnimations_() {
        this.progressPercentDrawn_ = 0;
        if (this.progressAnimationIntervalId_) {
            clearInterval(this.progressAnimationIntervalId_);
            this.progressAnimationIntervalId_ = undefined;
        }
        if (this.updateTimerId_) {
            window.clearTimeout(this.updateTimerId_);
            this.updateTimerId_ = undefined;
        }
    }
    /**
     * Show animation for enrollment completion.
     */
    animateScanComplete_() {
        const scanningAnimation = this.$.scanningAnimation;
        scanningAnimation.singleLoop = true;
        scanningAnimation.autoplay = true;
        scanningAnimation.classList.remove('translucent');
        this.updateAnimationAsset_();
        this.resizeCheckMark_(scanningAnimation);
        this.$.fingerprintScanned.hidden = false;
    }
    /**
     * Show animation for enrollment in progress.
     */
    animateScanProgress_() {
        this.$.fingerprintScanned.hidden = false;
        this.$.scanningAnimation.hidden = true;
        this.updateTimerId_ = window.setTimeout(() => {
            this.$.scanningAnimation.hidden = false;
            this.$.fingerprintScanned.hidden = true;
        }, FINGERPRINT_SCAN_SUCCESS_MS);
    }
    /**
     * Clear the canvas of any renderings.
     */
    clearCanvas_() {
        const c = this.$.canvas;
        const ctx = c.getContext('2d');
        assert(!!ctx);
        ctx.clearRect(0, 0, c.width, c.height);
    }
    /**
     * Update the size and position of the animation images.
     */
    updateImages_() {
        this.resizeAndCenterIcon_(this.$.scanningAnimation);
        this.resizeAndCenterIcon_(this.$.fingerprintScanned);
    }
    /**
     * Resize the icon based on the scale and place it in the center of the
     * fingerprint progress circle.
     */
    resizeAndCenterIcon_(target) {
        // Resize icon based on the default width/height and scale.
        target.style.width = ICON_WIDTH * this.scale_ + 'px';
        target.style.height = ICON_HEIGHT * this.scale_ + 'px';
        // Place in the center of the canvas.
        const left = this.$.canvas.width / 2 - ICON_WIDTH * this.scale_ / 2;
        const top = this.$.canvas.height / 2 - ICON_HEIGHT * this.scale_ / 2;
        target.style.left = left + 'px';
        target.style.top = top + 'px';
    }
    /**
     * Resize the check mark based on the scale and place it in the bottom-right
     * corner of the fingerprint progress circle.
     */
    resizeCheckMark_(target) {
        // Resize check mark based on the default size and scale.
        target.style.width = CHECK_MARK_SIZE * this.scale_ + 'px';
        target.style.height = CHECK_MARK_SIZE * this.scale_ + 'px';
        // Place it in the bottom-right corner of the fingerprint progress circle.
        const top = this.$.canvas.height / 2 + this.circleRadius -
            CHECK_MARK_SIZE * this.scale_;
        const left = this.$.canvas.width / 2 + this.circleRadius -
            CHECK_MARK_SIZE * this.scale_;
        target.style.left = left + 'px';
        target.style.top = top + 'px';
    }
}
customElements.define(FingerprintProgressArcElement.is, FingerprintProgressArcElement);

function getTemplate$1S() {
    return html `<!--_html_template_start_-->    <style include="settings-shared cr-spinner-style">div[slot='body']{padding-inline-end:16px}#header{display:flex}#header .header-label{flex:auto}h3{font-size:inherit;font-weight:500;margin:0;padding-bottom:12px;padding-top:32px}cr-icon{padding-inline-end:12px}.list-item .name{word-break:break-word}.name{flex:3}#container{padding-inline-start:var(--cr-section-padding)}.spinner{padding-bottom:16px}@media (prefers-color-scheme:dark){#lightIcon{display:none}}@media (prefers-color-scheme:light){#darkIcon{display:none}}
    </style>

    <cr-dialog id="dialog" close-text="$i18n{cancel}" ignore-popstate
        on-close="onDialogClosed_">
      <div slot="title">[[dialogTitle_(dialogPage_)]]</div>

      <div slot="body">
        <cr-page-selector attr-for-selected="id" selected="[[dialogPage_]]"
            on-iron-select="onIronSelect_">
          <div id="initial">
            <p>$i18n{securityKeysTouchToContinue}</p>
            <div class="spinner"></div>
          </div>

          <div id="pinPrompt">
            <settings-security-keys-pin-field id="pin"
                min-pin-length="[[minPinLength_]]">
            </settings-security-keys-pin-field>
          </div>

          <div id="enrollments">
            <div id="header" class="list-item column-header">
              <h3 class="header-label">[[enrollmentsHeader_(enrollments_)]]</h3>
              <cr-button id="addButton" on-click="addButtonClick_"
                  class="secondary-button header-aligned-button">
                $i18n{add}
              </cr-button>
            </div>

            <div id="container">
              <iron-list id="enrollmentList" items="[[enrollments_]]"
                  class="cr-separators" role="list">
                <template>
                  <div class="list-item" first$="[[!index]]" role="listitem">
                    <cr-icon id="darkIcon"
                        icon="fingerprint-icon:fingerprint-scanned-dark">
                    </cr-icon>
                    <cr-icon id="lightIcon"
                        icon="fingerprint-icon:fingerprint-scanned-light">
                    </cr-icon>
                    <div class="name">
                      [[item.name]]
                    </div>
                    <cr-icon-button class="icon-clear"
                        aria-label="$i18n{securityKeysBioEnrollmentDelete}"
                        on-click="deleteEnrollment_"
                        disabled="[[deleteInProgress_]]">
                    </cr-icon-button>
                  </div>
                </template>
              </iron-list>
            </div>
          </div>

          <div id="enroll">
            <p>[[progressArcLabel_]]</p>
            <fingerprint-progress-arc id="arc" autoplay>
            </fingerprint-progress-arc>
          </div>

          <div id="chooseName">
            <p>$i18n{securityKeysBioEnrollmentChooseName}</p>
            <cr-input type="text" id="enrollmentName"
                max-length="[[enrollmentNameMaxUtf8Length_]]"
                value="{{recentEnrollmentName_}}"
                label="$i18n{securityKeysBioEnrollmentNameLabel}"
                on-input="onEnrollmentNameInput_"
                error-message="[[enrollmentNameError_]]"
                invalid="[[!isNullOrEmpty_(enrollmentNameError_)]]"
                spellcheck="false">
            </cr-input>
          </div>

          <div id="error">[[errorMsg_]]</div>
        </cr-page-selector>
      </div>

      <div slot="button-container">
        <cr-button id="cancelButton" class="cancel-button" on-click="cancel_"
            hidden="[[!cancelButtonVisible_]]"
            disabled="[[cancelButtonDisabled_]]">
          $i18n{cancel}
        </cr-button>
        <cr-button id="confirmButton" class="action-button"
            hidden="[[!confirmButtonVisible_]]"
            disabled="[[confirmButtonDisabled_]]"
            on-click="confirmButtonClick_">
          [[confirmButtonLabel_]]
        </cr-button>
        <cr-button id="doneButton" class="action-button"
            on-click="done_" hidden="[[!doneButtonVisible_]]">
          $i18n{done}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-security-keys-bio-enroll-dialog' is a dialog for
 * listing, adding, renaming, and deleting biometric enrollments stored on a
 * security key.
 */
var BioEnrollDialogPage;
(function (BioEnrollDialogPage) {
    BioEnrollDialogPage["INITIAL"] = "initial";
    BioEnrollDialogPage["PIN_PROMPT"] = "pinPrompt";
    BioEnrollDialogPage["ENROLLMENTS"] = "enrollments";
    BioEnrollDialogPage["ENROLL"] = "enroll";
    BioEnrollDialogPage["CHOOSE_NAME"] = "chooseName";
    BioEnrollDialogPage["ERROR"] = "error";
})(BioEnrollDialogPage || (BioEnrollDialogPage = {}));
const SettingsSecurityKeysBioEnrollDialogElementBase = WebUiListenerMixin(I18nMixin(PolymerElement));
class SettingsSecurityKeysBioEnrollDialogElement extends SettingsSecurityKeysBioEnrollDialogElementBase {
    static get is() {
        return 'settings-security-keys-bio-enroll-dialog';
    }
    static get template() {
        return getTemplate$1S();
    }
    static get properties() {
        return {
            cancelButtonDisabled_: Boolean,
            cancelButtonVisible_: Boolean,
            confirmButtonDisabled_: Boolean,
            confirmButtonVisible_: Boolean,
            confirmButtonLabel_: String,
            deleteInProgress_: Boolean,
            /**
             * The ID of the element currently shown in the dialog.
             */
            dialogPage_: {
                type: String,
                value: BioEnrollDialogPage.INITIAL,
                observer: 'dialogPageChanged_',
            },
            doneButtonVisible_: Boolean,
            /**
             * The list of enrollments displayed.
             */
            enrollments_: Array,
            minPinLength_: Number,
            progressArcLabel_: String,
            recentEnrollmentName_: String,
            enrollmentNameError_: String,
            enrollmentNameMaxUtf8Length_: Number,
            errorMsg_: String,
        };
    }
    browserProxy_ = SecurityKeysBioEnrollProxyImpl.getInstance();
    maxSamples_ = -1;
    recentEnrollmentId_ = '';
    showSetPINButton_ = false;
    connectedCallback() {
        super.connectedCallback();
        this.$.dialog.showModal();
        this.addWebUiListener('security-keys-bio-enroll-error', (error, requiresPINChange = false) => this.onError_(error, requiresPINChange));
        this.addWebUiListener('security-keys-bio-enroll-status', (response) => this.onEnrollmentSample_(response));
        this.browserProxy_.startBioEnroll().then(([minPinLength]) => {
            this.minPinLength_ = minPinLength;
            this.dialogPage_ = BioEnrollDialogPage.PIN_PROMPT;
        });
    }
    setDialogPageForTesting(page) {
        this.dialogPage_ = page;
    }
    fire_(eventName, detail) {
        this.dispatchEvent(new CustomEvent(eventName, { bubbles: true, composed: true, detail }));
    }
    onError_(error, requiresPINChange = false) {
        this.errorMsg_ = error;
        this.showSetPINButton_ = requiresPINChange;
        this.dialogPage_ = BioEnrollDialogPage.ERROR;
    }
    submitPin_() {
        // Disable the confirm button to prevent concurrent submissions.
        this.confirmButtonDisabled_ = true;
        this.$.pin.trySubmit(pin => this.browserProxy_.providePin(pin))
            .then(() => {
            this.browserProxy_.getSensorInfo().then(sensorInfo => {
                this.enrollmentNameMaxUtf8Length_ =
                    sensorInfo.maxTemplateFriendlyName;
                // Leave confirm button disabled while enumerating fingerprints.
                // It will be re-enabled by dialogPageChanged_() where
                // appropriate.
                this.showEnrollmentsPage_();
            });
        }, () => {
            // Wrong PIN.
            this.confirmButtonDisabled_ = false;
        });
    }
    onEnrollments_(enrollments) {
        this.enrollments_ =
            enrollments.slice().sort((a, b) => a.name.localeCompare(b.name));
        this.$.enrollmentList.fire('iron-resize');
        this.dialogPage_ = BioEnrollDialogPage.ENROLLMENTS;
    }
    setCancelButtonDisabledForTesting(disabled) {
        this.cancelButtonDisabled_ = disabled;
    }
    dialogPageChanged_() {
        switch (this.dialogPage_) {
            case BioEnrollDialogPage.INITIAL:
                this.cancelButtonVisible_ = true;
                this.cancelButtonDisabled_ = false;
                this.confirmButtonVisible_ = false;
                this.doneButtonVisible_ = false;
                break;
            case BioEnrollDialogPage.PIN_PROMPT:
                this.cancelButtonVisible_ = true;
                this.cancelButtonDisabled_ = false;
                this.confirmButtonVisible_ = true;
                this.confirmButtonLabel_ = this.i18n('continue');
                this.confirmButtonDisabled_ = false;
                this.doneButtonVisible_ = false;
                this.$.pin.focus();
                break;
            case BioEnrollDialogPage.ENROLLMENTS:
                this.cancelButtonVisible_ = false;
                this.confirmButtonVisible_ = false;
                this.doneButtonVisible_ = true;
                break;
            case BioEnrollDialogPage.ENROLL:
                this.cancelButtonVisible_ = true;
                this.cancelButtonDisabled_ = false;
                this.confirmButtonVisible_ = false;
                this.doneButtonVisible_ = false;
                break;
            case BioEnrollDialogPage.CHOOSE_NAME:
                this.cancelButtonVisible_ = false;
                this.confirmButtonVisible_ = true;
                this.confirmButtonLabel_ = this.i18n('continue');
                this.confirmButtonDisabled_ = !this.recentEnrollmentName_.length;
                this.doneButtonVisible_ = false;
                this.$.enrollmentName.focus();
                break;
            case BioEnrollDialogPage.ERROR:
                this.cancelButtonVisible_ = true;
                this.confirmButtonVisible_ = this.showSetPINButton_;
                this.confirmButtonLabel_ = this.i18n('securityKeysSetPinButton');
                this.doneButtonVisible_ = false;
                break;
            default:
                assertNotReached();
        }
        this.fire_('bio-enroll-dialog-ready-for-testing');
    }
    addButtonClick_() {
        assert(this.dialogPage_ === BioEnrollDialogPage.ENROLLMENTS);
        this.maxSamples_ = -1; // Reset maxSamples_ before enrolling starts.
        this.$.arc.reset();
        this.progressArcLabel_ =
            this.i18n('securityKeysBioEnrollmentEnrollingLabel');
        this.recentEnrollmentId_ = '';
        this.recentEnrollmentName_ = '';
        this.dialogPage_ = BioEnrollDialogPage.ENROLL;
        this.browserProxy_.startEnrolling().then(response => {
            this.onEnrollmentComplete_(response);
        });
    }
    onEnrollmentSample_(response) {
        if (response.status !== SampleStatus.OK) {
            this.progressArcLabel_ =
                this.i18n('securityKeysBioEnrollmentTryAgainLabel');
            getInstance().announce(this.progressArcLabel_);
            return;
        }
        this.progressArcLabel_ =
            this.i18n('securityKeysBioEnrollmentEnrollingLabel');
        assert(response.remaining >= 0);
        if (this.maxSamples_ === -1) {
            this.maxSamples_ = response.remaining + 1;
        }
        this.$.arc.setProgress(100 * (this.maxSamples_ - response.remaining - 1) / this.maxSamples_, 100 * (this.maxSamples_ - response.remaining) / this.maxSamples_, false);
    }
    onEnrollmentComplete_(response) {
        switch (response.code) {
            case Ctap2Status.OK:
                break;
            case Ctap2Status.ERR_KEEPALIVE_CANCEL:
                this.showEnrollmentsPage_();
                return;
            case Ctap2Status.ERR_FP_DATABASE_FULL:
                this.onError_(this.i18n('securityKeysBioEnrollmentStorageFullLabel'));
                return;
            default:
                this.onError_(this.i18n('securityKeysBioEnrollmentEnrollingFailedLabel'));
                return;
        }
        this.maxSamples_ = Math.max(this.maxSamples_, 1);
        this.$.arc.setProgress(100 * (this.maxSamples_ - 1) / this.maxSamples_, 100, true);
        assert(response.enrollment);
        this.recentEnrollmentId_ = response.enrollment.id;
        this.recentEnrollmentName_ = response.enrollment.name;
        this.cancelButtonVisible_ = false;
        this.confirmButtonVisible_ = true;
        this.confirmButtonDisabled_ = false;
        this.progressArcLabel_ =
            this.i18n('securityKeysBioEnrollmentEnrollingCompleteLabel');
        this.$.confirmButton.focus();
        // Make screen-readers announce enrollment completion.
        this.fire_('iron-announce', { text: this.progressArcLabel_ });
        this.fire_('bio-enroll-dialog-ready-for-testing');
    }
    confirmButtonClick_() {
        switch (this.dialogPage_) {
            case BioEnrollDialogPage.PIN_PROMPT:
                this.submitPin_();
                break;
            case BioEnrollDialogPage.ENROLL:
                assert(!!this.recentEnrollmentId_.length);
                this.dialogPage_ = BioEnrollDialogPage.CHOOSE_NAME;
                break;
            case BioEnrollDialogPage.CHOOSE_NAME:
                this.renameNewEnrollment_();
                break;
            case BioEnrollDialogPage.ERROR:
                this.$.dialog.close();
                this.fire_('bio-enroll-set-pin');
                break;
            default:
                assertNotReached();
        }
    }
    renameNewEnrollment_() {
        assert(this.dialogPage_ === BioEnrollDialogPage.CHOOSE_NAME);
        // Check that the user-provided name doesn't exceed the maximum permissible
        // length reported by the security key when encoded as UTF-8. (Note that
        // JavaScript String length counts code units, but string length maximums in
        // CTAP 2.1 are generally on UTF-8 bytes.)
        if (new TextEncoder().encode(this.recentEnrollmentName_).length >
            this.enrollmentNameMaxUtf8Length_) {
            this.enrollmentNameError_ =
                this.i18n('securityKeysBioEnrollmentNameLabelTooLong');
            return;
        }
        this.enrollmentNameError_ = null;
        // Disable the confirm button to prevent concurrent submissions. It will
        // be re-enabled by dialogPageChanged_() where appropriate.
        this.confirmButtonDisabled_ = true;
        this.browserProxy_
            .renameEnrollment(this.recentEnrollmentId_, this.recentEnrollmentName_)
            .then(enrollments => {
            this.onEnrollments_(enrollments);
        });
    }
    showEnrollmentsPage_() {
        this.browserProxy_.enumerateEnrollments().then(enrollments => {
            this.onEnrollments_(enrollments);
        });
    }
    cancel_() {
        if (this.dialogPage_ === BioEnrollDialogPage.ENROLL) {
            // Cancel an ongoing enrollment.  Will cause the pending
            // enumerateEnrollments() promise to be resolved and proceed to the
            // enrollments page.
            this.cancelButtonDisabled_ = true;
            this.browserProxy_.cancelEnrollment();
        }
        else {
            // On any other screen, simply close the dialog.
            this.done_();
        }
    }
    done_() {
        this.$.dialog.close();
    }
    onDialogClosed_() {
        this.browserProxy_.close();
    }
    onIronSelect_(e) {
        // Prevent this event from bubbling since it is unnecessarily triggering
        // the listener within settings-animated-pages.
        e.stopPropagation();
        // Also asynchronously notify iron-list of the possible resize.
        setTimeout(() => this.$.enrollmentList.notifyResize(), 0);
    }
    deleteEnrollment_(event) {
        if (this.deleteInProgress_) {
            return;
        }
        this.deleteInProgress_ = true;
        const enrollment = this.enrollments_[event.model.index];
        this.browserProxy_.deleteEnrollment(enrollment.id).then(enrollments => {
            this.deleteInProgress_ = false;
            this.onEnrollments_(enrollments);
        });
    }
    onEnrollmentNameInput_() {
        this.confirmButtonDisabled_ = !this.recentEnrollmentName_.length;
    }
    /**
     * @return The title string for the current dialog page.
     */
    dialogTitle_(dialogPage) {
        if (dialogPage === BioEnrollDialogPage.ENROLL ||
            dialogPage === BioEnrollDialogPage.CHOOSE_NAME) {
            return this.i18n('securityKeysBioEnrollmentAddTitle');
        }
        return this.i18n('securityKeysBioEnrollmentDialogTitle');
    }
    /**
     * @return The header label for the enrollments page.
     */
    enrollmentsHeader_(enrollments) {
        return this.i18n(enrollments && enrollments.length ?
            'securityKeysBioEnrollmentEnrollmentsLabel' :
            'securityKeysBioEnrollmentNoEnrollmentsLabel');
    }
    isNullOrEmpty_(s) {
        return s === '' || !s;
    }
}
customElements.define(SettingsSecurityKeysBioEnrollDialogElement.is, SettingsSecurityKeysBioEnrollDialogElement);

function getTemplate$1R() {
    return html `<!--_html_template_start_-->    <style include="settings-shared cr-spinner-style">cr-input{display:inline-block;--cr-input-width:8em}#newPIN{padding-inline-end:2em}#newPINRow{display:flex;flex-direction:row}#newPINRow cr-input{width:8em;--cr-input-error-white-space:nowrap}.spinner{padding-bottom:12px}
    </style>

    <cr-dialog id="dialog" close-text="$i18n{close}" ignore-popstate
        on-close="closeDialog_">
      <div slot="title">[[title_]]</div>
      <div slot="body">
        <cr-page-selector attr-for-selected="id" selected="[[shown_]]"
            on-iron-select="onIronSelect_">
          <div id="initial">
            <p>$i18n{securityKeysTouchToContinue}</p>
            <div class="spinner"></div>
          </div>

          <div id="noPINSupport">
            <p>$i18n{securityKeysNoPIN}</p>
          </div>

          <div id="pinPrompt">
            <div id="currentPINEntry" hidden="[[!showCurrentEntry_]]">
              <p>$i18nRaw{securityKeysCurrentPINIntro}</p>

              <div id="currentPINRow">
                <cr-input id="currentPIN" value="{{currentPIN_}}"
                    min-length="[[currentMinPinLength_]]"
                    max-length="255" spellcheck="false"
                    on-input="onCurrentPinInput_"
                    invalid="[[isNonEmpty_(currentPINError_)]]"
                    label="$i18n{securityKeysCurrentPIN}"
                    type$="[[inputType_(pinsVisible_)]]"
                    error-message="[[currentPINError_]]">
                  <cr-icon-button slot="suffix" id="showPINsButton"
                      class$="[[showPinsClass_(pinsVisible_)]]"
                      title="[[showPinsTitle_(pinsVisible_)]]"
                      focus-row-control focus-type="showPassword"
                      on-click="showPinsClick_"></cr-icon-button>
                </cr-input>

              </div>
            </div>

            <p>[[newPINDialogDescription_]]</p>

            <div id="newPINRow">
              <cr-input id="newPIN" value="{{newPIN_}}"
                  min-length="[[newMinPinLength_]]"
                  max-length="255" spellcheck="false" on-input="onNewPinInput_"
                  label="$i18n{securityKeysPIN}"
                  type$="[[inputType_(pinsVisible_)]]"
                  invalid="[[isNonEmpty_(newPINError_)]]"
                  error-message="[[newPINError_]]">
                <!-- If a show/hide icon is included in this row, this div is
                     needed to ensure that the cr-input is the same height
                     as the one to the right. Otherwise they don't vertically
                     align -->
                <div style="height: 36px" slot="suffix"
                     hidden="[[showCurrentEntry_]]"></div>
              </cr-input>
              <cr-input id="confirmPIN" value="{{confirmPIN_}}"
                  min-length="[[newMinPinLength_]]"
                  max-length="255" spellcheck="false"
                  on-input="onConfirmPinInput_"
                  label="$i18n{securityKeysConfirmPIN}"
                  invalid="[[isNonEmpty_(confirmPINError_)]]"
                  type$="[[inputType_(pinsVisible_)]]"
                  error-message="[[confirmPINError_]]">
                <cr-icon-button slot="suffix"
                    class$="[[showPinsClass_(pinsVisible_)]]"
                    title="[[showPinsTitle_(pinsVisible_)]]"
                    hidden="[[showCurrentEntry_]]"
                    focus-row-control focus-type="showPassword"
                    on-click="showPinsClick_"></cr-icon-button>
              </cr-input>
            </div>
          </div>

          <div id="success">
            <p>$i18n{securityKeysPINSuccess}</p>
          </div>

          <div id="error">
            <p>[[pinFailed_(errorCode_)]]</p>
          </div>

          <div id="locked">
            <p>$i18n{securityKeysPINHardLock}</p>
          </div>

          <div id="reinsert">
            <p>$i18n{securityKeysPINSoftLock}</p>
          </div>
        </cr-page-selector>
      </div>

      <div slot="button-container">
        <cr-button id="closeButton"
            class$="[[maybeActionButton_(complete_)]]"
            on-click="closeDialog_">
          [[closeText_(complete_)]]
        </cr-button>
        <cr-button id="pinSubmit" class="action-button"
            on-click="pinSubmitNew_" disabled="[[!setPINButtonValid_]]"
            hidden="[[complete_]]">
          $i18n{securityKeysSetPINConfirm}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-security-keys-set-pin-dialog' is a dialog for
 * setting and changing security key PINs.
 */
var SetPinDialogPage;
(function (SetPinDialogPage) {
    SetPinDialogPage["INITIAL"] = "initial";
    SetPinDialogPage["NO_PIN_SUPPORT"] = "noPINSupport";
    SetPinDialogPage["REINSERT"] = "reinsert";
    SetPinDialogPage["LOCKED"] = "locked";
    SetPinDialogPage["ERROR"] = "error";
    SetPinDialogPage["PIN_PROMPT"] = "pinPrompt";
    SetPinDialogPage["SUCCESS"] = "success";
})(SetPinDialogPage || (SetPinDialogPage = {}));
const SettingsSecurityKeysSetPinDialogElementBase = I18nMixin(PolymerElement);
class SettingsSecurityKeysSetPinDialogElement extends SettingsSecurityKeysSetPinDialogElementBase {
    static get is() {
        return 'settings-security-keys-set-pin-dialog';
    }
    static get template() {
        return getTemplate$1R();
    }
    static get properties() {
        return {
            /**
             * Whether the value of the current PIN textbox is a valid PIN or not.
             */
            currentPINValid_: Boolean,
            newPINValid_: Boolean,
            confirmPINValid_: Boolean,
            /**
             * Whether the dialog is in a state where the Set PIN button should be
             * enabled. Read by Polymer.
             */
            setPINButtonValid_: {
                type: Boolean,
                value: false,
            },
            /**
             * The value of the new PIN textbox. Read/write by Polymer.
             */
            newPIN_: {
                type: String,
                value: '',
            },
            confirmPIN_: {
                type: String,
                value: '',
            },
            currentPIN_: {
                type: String,
                value: '',
            },
            /**
             * The minimum length for the currently set PIN.
             */
            currentMinPinLength_: Number,
            /**
             * The minimum length to set a new PIN.
             */
            newMinPinLength_: {
                type: Number,
                observer: 'newMinPinLengthChanged_',
            },
            /**
             * The number of PIN attempts remaining.
             */
            retries_: Number,
            /**
             * A CTAP error code when we don't recognise the specific error. Read by
             * Polymer.
             */
            errorCode_: Number,
            /**
             * Whether an entry for the current PIN should be displayed. (If no PIN
             * has been set then it won't be shown.)
             */
            showCurrentEntry_: {
                type: Boolean,
                value: false,
            },
            /**
             * Error string to display under the current PIN entry, or empty.
             */
            currentPINError_: {
                type: String,
                value: '',
            },
            /**
             * Error string to display under the new PIN entry, or empty.
             */
            newPINError_: {
                type: String,
                value: '',
            },
            /**
             * Error string to display under the confirmation PIN entry, or empty.
             */
            confirmPINError_: {
                type: String,
                value: '',
            },
            /**
             * Whether the dialog process has completed, successfully or otherwise.
             */
            complete_: {
                type: Boolean,
                value: false,
            },
            /**
             * The id of an element on the page that is currently shown.
             */
            shown_: {
                type: String,
                value: SetPinDialogPage.INITIAL,
            },
            /**
             * Whether the contents of the PIN entries are visible, or are displayed
             * like passwords.
             */
            pinsVisible_: {
                type: Boolean,
                value: false,
            },
            title_: String,
            newPINDialogDescription_: String,
        };
    }
    browserProxy_ = SecurityKeysPinBrowserProxyImpl.getInstance();
    connectedCallback() {
        super.connectedCallback();
        this.title_ = this.i18n('securityKeysSetPINInitialTitle');
        this.$.dialog.showModal();
        this.browserProxy_.startSetPin().then(({ done, error, currentMinPinLength, newMinPinLength, retries }) => {
            if (done) {
                // Operation is complete. error is a CTAP error code. See
                // https://fidoalliance.org/specs/fido-v2.0-rd-20180702/fido-client-to-authenticator-protocol-v2.0-rd-20180702.html#error-responses
                if (error === 1 /* INVALID_COMMAND */) {
                    this.shown_ = SetPinDialogPage.NO_PIN_SUPPORT;
                    this.finish_();
                }
                else if (error === 52 /* temporarily locked */) {
                    this.shown_ = SetPinDialogPage.REINSERT;
                    this.finish_();
                }
                else if (error === 50 /* locked */) {
                    this.shown_ = SetPinDialogPage.LOCKED;
                    this.finish_();
                }
                else {
                    this.errorCode_ = error;
                    this.shown_ = SetPinDialogPage.ERROR;
                    this.finish_();
                }
            }
            else if (retries === 0) {
                // A device can also signal that it is locked by returning zero
                // retries.
                this.shown_ = SetPinDialogPage.LOCKED;
                this.finish_();
            }
            else {
                // Need to prompt for a pin. Initially set the text boxes to valid
                // so that they don't all appear red without the user typing
                // anything.
                this.currentPINValid_ = true;
                this.newPINValid_ = true;
                this.confirmPINValid_ = true;
                this.setPINButtonValid_ = true;
                this.currentMinPinLength_ = currentMinPinLength;
                this.newMinPinLength_ = newMinPinLength;
                this.retries_ = retries;
                // retries_ may be null to indicate that there is currently no PIN
                // set.
                let focusTarget;
                if (this.retries_ === null) {
                    this.showCurrentEntry_ = false;
                    focusTarget = this.$.newPIN;
                    this.title_ = this.i18n('securityKeysSetPINCreateTitle');
                }
                else {
                    this.showCurrentEntry_ = true;
                    focusTarget = this.$.currentPIN;
                    this.title_ = this.i18n('securityKeysSetPINChangeTitle');
                }
                this.shown_ = SetPinDialogPage.PIN_PROMPT;
                // Focus cannot be set directly from within a backend callback.
                window.setTimeout(function () {
                    focusTarget.focus();
                }, 0);
                this.fire_('ui-ready'); // for test synchronization.
            }
        });
    }
    fire_(eventName, detail) {
        this.dispatchEvent(new CustomEvent(eventName, { bubbles: true, composed: true, detail }));
    }
    closeDialog_() {
        this.$.dialog.close();
        this.finish_();
    }
    finish_() {
        if (this.complete_) {
            return;
        }
        this.complete_ = true;
        // Setting |complete_| to true hides the |pinSubmitNew| button while it
        // has focus, which in turn causes the browser to move focus to the <body>
        // element, which in turn prevents subsequent "Enter" keystrokes to be
        // handled by cr-dialog itself. Re-focusing manually fixes this.
        this.$.dialog.focus();
        this.browserProxy_.close();
    }
    onIronSelect_(e) {
        // Prevent this event from bubbling since it is unnecessarily triggering
        // the listener within settings-animated-pages.
        e.stopPropagation();
    }
    onCurrentPinInput_() {
        // Typing in the current PIN box after an error makes the error message
        // disappear.
        this.currentPINError_ = '';
    }
    onNewPinInput_() {
        // Typing in the new PIN box after an error makes the error message
        // disappear.
        this.newPINError_ = '';
    }
    onConfirmPinInput_() {
        // Typing in the confirm PIN box after an error makes the error message
        // disappear.
        this.confirmPINError_ = '';
    }
    /**
      @param pin A candidate PIN.
      @return An error string or else '' to indicate validity.
    */
    isValidPin_(pin, minLength) {
        // The UTF-8 encoding of the PIN must be between minLength and 63 bytes, and
        // the final byte cannot be zero.
        const utf8Encoded = new TextEncoder().encode(pin);
        if (utf8Encoded.length < minLength) {
            return this.i18n('securityKeysPINTooShort');
        }
        if (utf8Encoded.length > 63 ||
            // If the PIN somehow has a NUL at the end then it's invalid, but this
            // is so obscure that we don't try to message it. Rather we just say
            // that it's too long because trimming the final character is the best
            // response by the user.
            utf8Encoded[utf8Encoded.length - 1] === 0) {
            return this.i18n('securityKeysPINTooLong');
        }
        // A PIN must contain at least four code-points. Javascript strings are
        // UCS-2 and the |length| property counts UCS-2 elements, not code-points.
        // (For example, '\u{1f6b4}'.length === 2, but it's a single code-point.)
        // Therefore, iterate over the string (which does yield codepoints) and
        // check that |minLength| or more were seen.
        let length = 0;
        for (const _codepoint of pin) {
            length++;
        }
        if (length < minLength) {
            return this.i18n('securityKeysPINTooShort');
        }
        return '';
    }
    /**
     * @param retries The number of PIN attempts remaining.
     * @return The message to show under the text box.
     */
    mismatchError_(retries) {
        // Warn the user if the number of retries is getting low.
        if (1 < retries && retries <= 3) {
            return this.i18n('securityKeysPINIncorrectRetriesPl', retries.toString());
        }
        if (retries === 1) {
            return this.i18n('securityKeysPINIncorrectRetriesSin');
        }
        return this.i18n('securityKeysPINIncorrect');
    }
    /**
     * Called to set focus from inside a callback.
     */
    focusOn_(focusTarget) {
        // Focus cannot be set directly from within a backend callback. Also,
        // directly focusing |currentPIN| doesn't always seem to work(!). Thus
        // focus something else first, which is a hack that seems to solve the
        // problem.
        let preFocusTarget = this.$.newPIN;
        if (preFocusTarget === focusTarget) {
            preFocusTarget = this.$.currentPIN;
        }
        window.setTimeout(function () {
            preFocusTarget.focus();
            focusTarget.focus();
        }, 0);
    }
    /**
     * Called by Polymer when the Set PIN button is activated.
     */
    pinSubmitNew_() {
        if (this.showCurrentEntry_) {
            this.currentPINError_ =
                this.isValidPin_(this.currentPIN_, this.currentMinPinLength_);
            if (this.currentPINError_ !== '') {
                this.focusOn_(this.$.currentPIN);
                this.fire_('ui-ready'); // for test synchronization.
                return;
            }
        }
        this.newPINError_ = this.isValidPin_(this.newPIN_, this.newMinPinLength_);
        if (this.newPINError_ !== '') {
            this.focusOn_(this.$.newPIN);
            this.fire_('ui-ready'); // for test synchronization.
            return;
        }
        if (this.newPIN_ !== this.confirmPIN_) {
            this.confirmPINError_ = this.i18n('securityKeysPINMismatch');
            this.focusOn_(this.$.confirmPIN);
            this.fire_('ui-ready'); // for test synchronization.
            return;
        }
        if (this.newPIN_ === this.currentPIN_) {
            this.newPINError_ = this.i18n('securityKeysSamePINAsCurrent');
            this.focusOn_(this.$.newPIN);
            this.fire_('ui-ready'); // for test synchronization.
            return;
        }
        this.setPINButtonValid_ = false;
        this.browserProxy_.setPin(this.currentPIN_, this.newPIN_).then(response => {
            const error = response.error;
            // This call always completes the process so response.done is always
            // true. error is a CTAP2 error code. See
            // https://fidoalliance.org/specs/fido-v2.0-rd-20180702/fido-client-to-authenticator-protocol-v2.0-rd-20180702.html#error-responses
            if (error === 0 /* SUCCESS */) {
                this.shown_ = SetPinDialogPage.SUCCESS;
                this.finish_();
            }
            else if (error === 52 /* temporarily locked */) {
                this.shown_ = SetPinDialogPage.REINSERT;
                this.finish_();
            }
            else if (error === 50 /* locked */) {
                this.shown_ = SetPinDialogPage.LOCKED;
                this.finish_();
            }
            else if (error === 49 /* PIN_INVALID */) {
                this.currentPINValid_ = false;
                this.retries_--;
                this.currentPINError_ = this.mismatchError_(this.retries_);
                this.setPINButtonValid_ = true;
                this.focusOn_(this.$.currentPIN);
                this.fire_('ui-ready'); // for test synchronization.
            }
            else {
                // Unknown error.
                this.errorCode_ = error;
                this.shown_ = SetPinDialogPage.ERROR;
                this.finish_();
            }
        });
    }
    /**
     * onClick handler for the show/hide icon.
     */
    showPinsClick_() {
        this.pinsVisible_ = !this.pinsVisible_;
    }
    /**
     * Polymer helper function to detect when an error string is empty.
     */
    isNonEmpty_(s) {
        return s !== '';
    }
    /**
     * Called by Polymer when |errorCode_| changes to set the error string.
     */
    pinFailed_() {
        if (this.errorCode_ === null) {
            return '';
        }
        return this.i18n('securityKeysPINError', this.errorCode_.toString());
    }
    /**
     * @return The class of the Ok / Cancel button.
     */
    maybeActionButton_() {
        return this.complete_ ? 'action-button' : 'cancel-button';
    }
    /**
     * @return The label of the Ok / Cancel button.
     */
    closeText_() {
        return this.i18n(this.complete_ ? 'ok' : 'cancel');
    }
    newMinPinLengthChanged_() {
        PluralStringProxyImpl.getInstance()
            .getPluralString('securityKeysNewPIN', this.newMinPinLength_)
            .then(string => this.newPINDialogDescription_ = string);
    }
    /**
     * @return The class (and thus icon) to be displayed.
     */
    showPinsClass_() {
        return 'icon-visibility' + (this.pinsVisible_ ? '-off' : '');
    }
    /**
     * @return The tooltip for the icon.
     */
    showPinsTitle_() {
        return this.i18n(this.pinsVisible_ ? 'securityKeysHidePINs' : 'securityKeysShowPINs');
    }
    /**
     * @return The PIN-input element type.
     */
    inputType_() {
        return this.pinsVisible_ ? 'text' : 'password';
    }
}
customElements.define(SettingsSecurityKeysSetPinDialogElement.is, SettingsSecurityKeysSetPinDialogElement);

function getTemplate$1Q() {
    return html `<!--_html_template_start_-->    <style include="settings-shared cr-spinner-style">.spinner{padding-bottom:12px}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}" ignore-popstate
         on-close="closeDialog_">
      <div slot="title">[[title_]]</div>
      <div slot="body">
        <cr-page-selector attr-for-selected="id" selected="[[shown_]]"
            on-iron-select="onIronSelect_">
          <div id="initial">
            <p>$i18n{securityKeysResetStep1}</p>
            <div class="spinner"></div>
          </div>

          <div id="noReset">
            <p>$i18n{securityKeysNoReset}</p>
          </div>

          <div id="resetFailed">
            <p>[[resetFailed_(errorCode_)]]</p>
          </div>

          <div id="resetConfirm">
            <p>$i18n{securityKeysResetStep2}</p>
          </div>

          <div id="resetSuccess">
            <p>$i18n{securityKeysResetSuccess}</p>
          </div>

          <div id="resetNotAllowed">
            <p>$i18n{securityKeysResetNotAllowed}</p>
          </div>
        </cr-page-selector>
      </div>
      <div slot="button-container">
        <cr-button id="button" class$="[[maybeActionButton_(complete_)]]"
             on-click="closeDialog_">
          [[closeText_(complete_)]]
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-security-keys-reset-dialog' is a dialog for
 * triggering factory resets of security keys.
 */
var ResetDialogPage;
(function (ResetDialogPage) {
    ResetDialogPage["INITIAL"] = "initial";
    ResetDialogPage["NO_RESET"] = "noReset";
    ResetDialogPage["RESET_FAILED"] = "resetFailed";
    ResetDialogPage["RESET_CONFIRM"] = "resetConfirm";
    ResetDialogPage["RESET_SUCCESS"] = "resetSuccess";
    ResetDialogPage["RESET_NOT_ALLOWED"] = "resetNotAllowed";
})(ResetDialogPage || (ResetDialogPage = {}));
const SettingsSecurityKeysResetDialogElementBase = I18nMixin(PolymerElement);
class SettingsSecurityKeysResetDialogElement extends SettingsSecurityKeysResetDialogElementBase {
    static get is() {
        return 'settings-security-keys-reset-dialog';
    }
    static get template() {
        return getTemplate$1Q();
    }
    static get properties() {
        return {
            /**
             * A CTAP error code for when the specific error was not recognised.
             */
            errorCode_: Number,
            /**
             * True iff the process has completed, successfully or otherwise.
             */
            complete_: {
                type: Boolean,
                value: false,
            },
            /**
             * The id of an element on the page that is currently shown.
             */
            shown_: {
                type: String,
                value: ResetDialogPage.INITIAL,
            },
            title_: String,
        };
    }
    browserProxy_ = SecurityKeysResetBrowserProxyImpl.getInstance();
    connectedCallback() {
        super.connectedCallback();
        this.title_ = this.i18n('securityKeysResetTitle');
        this.$.dialog.showModal();
        this.browserProxy_.reset().then(code => {
            // code is a CTAP error code. See
            // https://fidoalliance.org/specs/fido-v2.0-rd-20180702/fido-client-to-authenticator-protocol-v2.0-rd-20180702.html#error-responses
            if (code === 1 /* INVALID_COMMAND */) {
                this.shown_ = ResetDialogPage.NO_RESET;
                this.finish_();
            }
            else if (code !== 0 /* unknown error */) {
                this.errorCode_ = code;
                this.shown_ = ResetDialogPage.RESET_FAILED;
                this.finish_();
            }
            else {
                this.title_ = this.i18n('securityKeysResetConfirmTitle');
                this.shown_ = ResetDialogPage.RESET_CONFIRM;
                this.browserProxy_.completeReset().then(code => {
                    this.title_ = this.i18n('securityKeysResetTitle');
                    if (code === 0 /* SUCCESS */) {
                        this.shown_ = ResetDialogPage.RESET_SUCCESS;
                    }
                    else if (code === 48 /* NOT_ALLOWED */) {
                        this.shown_ = ResetDialogPage.RESET_NOT_ALLOWED;
                    }
                    else /* unknown error */ {
                        this.errorCode_ = code;
                        this.shown_ = ResetDialogPage.RESET_FAILED;
                    }
                    this.finish_();
                });
            }
        });
    }
    closeDialog_() {
        this.$.dialog.close();
        this.finish_();
    }
    finish_() {
        if (this.complete_) {
            return;
        }
        this.complete_ = true;
        this.browserProxy_.close();
    }
    onIronSelect_(e) {
        // Prevent this event from bubbling since it is unnecessarily triggering
        // the listener within settings-animated-pages.
        e.stopPropagation();
    }
    /**
     * @param code CTAP error code.
     * @return Contents of the error string that may be displayed to the user.
     *     Used automatically by Polymer.
     */
    resetFailed_(code) {
        if (code === null) {
            return '';
        }
        return this.i18n('securityKeysResetError', code.toString());
    }
    /**
     * @param complete Whether the dialog process is complete.
     * @return The label of the dialog button. Used automatically by Polymer.
     */
    closeText_(complete) {
        return this.i18n(complete ? 'ok' : 'cancel');
    }
    /**
     * @param complete Whether the dialog process is complete.
     * @return The class of the dialog button. Used automatically by Polymer.
     */
    maybeActionButton_(complete) {
        return complete ? 'action-button' : 'cancel-button';
    }
}
customElements.define(SettingsSecurityKeysResetDialogElement.is, SettingsSecurityKeysResetDialogElement);

function getTemplate$1P() {
    return html `<!--_html_template_start_--><style include="settings-shared"></style>
<settings-subpage page-title="$i18n{securityKeysTitle}"
    route-path$="[[routePath]]">
  <cr-link-row
      id="setPINButton"
      class="hr"
      label="$i18n{securityKeysSetPIN}"
      sub-label="$i18n{securityKeysSetPINDesc}"
      on-click="onSetPin_"></cr-link-row>
  <cr-link-row
      id="credentialManagementButton"
      class="hr"
      label="$i18n{securityKeysCredentialManagementLabel}"
      sub-label="$i18n{securityKeysCredentialManagementDesc}"
      on-click="onCredentialManagement_"></cr-link-row>
  <template is="dom-if" if="[[enableBioEnrollment_]]">
    <cr-link-row
        id="bioEnrollButton"
        class="hr"
        label="$i18n{securityKeysBioEnrollmentSubpageLabel}"
        sub-label="$i18n{securityKeysBioEnrollmentSubpageDescription}"
        on-click="onBioEnroll_"></cr-link-row>
  </template>
  <cr-link-row
      id="resetButton"
      class="hr"
      label="$i18n{securityKeysReset}"
      sub-label="$i18n{securityKeysResetDesc}"
      on-click="onReset_"></cr-link-row>

  <template is="dom-if" if="[[showSetPINDialog_]]" restamp>
    <settings-security-keys-set-pin-dialog on-close="onSetPinDialogClosed_">
    </settings-security-keys-set-pin-dialog>
  </template>

  <template is="dom-if" if="[[showCredentialManagementDialog_]]" restamp>
    <settings-security-keys-credential-management-dialog
        on-credential-management-set-pin="onSetPin_"
        on-close="onCredentialManagementDialogClosed_">
    </settings-security-keys-credential-management-dialog>
  </template>

  <template is="dom-if" if="[[showResetDialog_]]" restamp>
    <settings-security-keys-reset-dialog on-close="onResetDialogClosed_">
    </settings-security-keys-reset-dialog>
  </template>

  <template is="dom-if" if="[[showBioEnrollDialog_]]" restamp>
    <settings-security-keys-bio-enroll-dialog
        on-bio-enroll-set-pin="onSetPin_"
        on-close="onBioEnrollDialogClosed_">
    </settings-security-keys-bio-enroll-dialog>
  </template>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'security-keys-subpage' is a settings subpage
 * containing operations on security keys.
 */
const SecurityKeysSubpageElementBase = SettingsViewMixin(PolymerElement);
class SecurityKeysSubpageElement extends SecurityKeysSubpageElementBase {
    static get is() {
        return 'security-keys-subpage';
    }
    static get template() {
        return getTemplate$1P();
    }
    static get properties() {
        return {
            enableBioEnrollment_: {
                type: Boolean,
                readOnly: true,
                value() {
                    return loadTimeData.getBoolean('enableSecurityKeysBioEnrollment');
                },
            },
            showSetPINDialog_: {
                type: Boolean,
                value: false,
            },
            showCredentialManagementDialog_: {
                type: Boolean,
                value: false,
            },
            showResetDialog_: {
                type: Boolean,
                value: false,
            },
            showBioEnrollDialog_: {
                type: Boolean,
                value: false,
            },
        };
    }
    onSetPin_() {
        this.showSetPINDialog_ = true;
    }
    onSetPinDialogClosed_() {
        this.showSetPINDialog_ = false;
        focusWithoutInk(this.$.setPINButton);
    }
    onCredentialManagement_() {
        this.showCredentialManagementDialog_ = true;
    }
    onCredentialManagementDialogClosed_() {
        this.showCredentialManagementDialog_ = false;
        const toFocus = this.shadowRoot.querySelector('#credentialManagementButton');
        assert(toFocus);
        focusWithoutInk(toFocus);
    }
    onReset_() {
        this.showResetDialog_ = true;
    }
    onResetDialogClosed_() {
        this.showResetDialog_ = false;
        focusWithoutInk(this.$.resetButton);
    }
    onBioEnroll_() {
        this.showBioEnrollDialog_ = true;
    }
    onBioEnrollDialogClosed_() {
        this.showBioEnrollDialog_ = false;
        const toFocus = this.shadowRoot.querySelector('#bioEnrollButton');
        assert(toFocus);
        focusWithoutInk(toFocus);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SecurityKeysSubpageElement.is, SecurityKeysSubpageElement);

function getTemplate$1O() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{display:block}</style>
<template is="dom-if" if="[[expanded]]" restamp>
  <settings-toggle-button id="toggleButton" pref="{{pref}}" label="[[label]]"
      sub-label="[[subLabel]]"
      numeric-unchecked-values="[[numericUncheckedValues]]">
    <div slot="more-actions-after">
      <cr-expand-button id="expandButton" expanded="{{expanded}}">
      </cr-expand-button>
    </div>
  </settings-toggle-button>
</template>
<template is="dom-if" if="[[!expanded]]" restamp>
  <cr-expand-button class="cr-row" id="expandButton" expanded="{{expanded}}">
    [[label]]
    <div class="cr-secondary-text">[[subLabel]]</div>
  </cr-expand-button>
</template>
<cr-collapse opened="[[expanded]]">
  <slot name="collapse"></slot>
</cr-collapse>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * `security-page-feature-row` is a toggle with an expand button that
 * controls a supplied preference and also allows for expanding and
 * collapsing so a user can learn more about a setting.
 */
class SecurityPageFeatureRowElement extends PolymerElement {
    static get is() {
        return 'security-page-feature-row';
    }
    static get template() {
        return getTemplate$1O();
    }
    static get properties() {
        return {
            expanded: {
                type: Boolean,
                notify: true,
                value: false,
            },
            label: String,
            /* The Preference associated with the feature row. */
            pref: Object,
            subLabel: String,
            numericUncheckedValues: Array,
        };
    }
}
customElements.define(SecurityPageFeatureRowElement.is, SecurityPageFeatureRowElement);

function getTemplate$1N() {
    return html `<!--_html_template_start_--><style include="cr-shared-style">:host{display:flex;flex-direction:column}.box{background-color:var(--cr-card-background-color);box-shadow:var(--cr-card-shadow)}.card{align-items:flex-start;aspect-ratio:1/1;display:inline-flex;justify-content:flex-start;min-width:44%;padding:20px}.card:hover{background-color:var(--cr-hover-background-color);cursor:pointer}.card-container{align-items:stretch;display:flex;gap:0;justify-content:center;width:100%}.section-header{color:var(--cr-primary-text-color);flex:1;font-size:108%;font-weight:400;letter-spacing:.25px;margin-bottom:16px;margin-top:30px;width:100%;user-select:none}.section-header.first{margin-top:0px}#securitySettingsBundleStandard{border-top-left-radius:var(--cr-card-border-radius)}#securitySettingsBundleEnhanced{border-top-right-radius:var(--cr-card-border-radius)}#safeBrowsingRadioGroup{padding-inline-start:40px}security-page-feature-row{border-bottom-left-radius:var(--cr-card-border-radius);border-bottom-right-radius:var(--cr-card-border-radius)}</style>
<settings-subpage page-title="$i18n{securityPageTitle}"
    learn-more-url="$i18n{safeBrowsingHelpCenterURL}"
    route-path$="[[routePath]]" class="multi-card" hide-close-button>
  <h2 class="section-header cr-secondary-text first">
    $i18n{securityTitle}
  </h2>
  <settings-radio-group id="bundlesRadioGroup"
      class="card-container"
      pref="{{prefs.generated.security_settings_bundle}}"
      selectable-elements="controlled-radio-button">
    <controlled-radio-button
        id="securitySettingsBundleStandard"
        name="[[securitySettingsBundleSettingEnum_.STANDARD]]"
        pref="{{prefs.generated.security_settings_bundle}}"
        label="$i18n{securityStandardBundleTitle}"
        class="card box">
    </controlled-radio-button>
    <controlled-radio-button
        id="securitySettingsBundleEnhanced"
        name="[[securitySettingsBundleSettingEnum_.ENHANCED]]"
        pref="{{prefs.generated.security_settings_bundle}}"
        label="$i18n{securityEnhancedBundleTitle}"
        class="card box">
    </controlled-radio-button>
  </settings-radio-group>
  <security-page-feature-row id="safeBrowsingRow"
      pref="{{prefs.generated.safe_browsing}}"
      label="$i18n{securitySafeBrowsingTitle}"
      sub-label="$i18n{securitySafeBrowsingDesc}"
      class="box"
      numeric-unchecked-values="[[safeBrowsingOff_]]">
    <div slot="collapse">
      <settings-radio-group id="safeBrowsingRadioGroup"
          pref="{{prefs.generated.safe_browsing}}"
          selectable-elements="controlled-radio-button">
        <controlled-radio-button
            label="$i18n{securitySafeBrowsingStandardTitle}"
            name="[[safeBrowsingSettingEnum_.STANDARD]]"
            pref="[[prefs.generated.safe_browsing]]">
        </controlled-radio-button>
        <controlled-radio-button id="enhancedProtectionButton"
            label="$i18n{securitySafeBrowsingEnhancedTitle}"
            name="[[safeBrowsingSettingEnum_.ENHANCED]]"
            pref="[[prefs.generated.safe_browsing]]">
        </controlled-radio-button>
      </settings-radio-group>
    </div>
  </security-page-feature-row>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/** Enumeration of all security settings bundle modes.*/
// LINT.IfChange(SecuritySettingsBundleSetting)
var SecuritySettingsBundleSetting;
(function (SecuritySettingsBundleSetting) {
    SecuritySettingsBundleSetting[SecuritySettingsBundleSetting["STANDARD"] = 0] = "STANDARD";
    SecuritySettingsBundleSetting[SecuritySettingsBundleSetting["ENHANCED"] = 1] = "ENHANCED";
})(SecuritySettingsBundleSetting || (SecuritySettingsBundleSetting = {}));
// LINT.ThenChange(/chrome/browser/safe_browsing/generated_security_settings_bundle_pref.h:SecuritySettingsBundleSetting)
/**
 * Enumeration of all Safe Browsing modes. Must be kept in sync with the enum
 * of the same name located in:
 * chrome/browser/safe_browsing/generated_safe_browsing_pref.h
 */
// LINT.IfChange(SafeBrowsingSetting)
var SafeBrowsingSetting;
(function (SafeBrowsingSetting) {
    SafeBrowsingSetting[SafeBrowsingSetting["ENHANCED"] = 0] = "ENHANCED";
    SafeBrowsingSetting[SafeBrowsingSetting["STANDARD"] = 1] = "STANDARD";
    SafeBrowsingSetting[SafeBrowsingSetting["DISABLED"] = 2] = "DISABLED";
})(SafeBrowsingSetting || (SafeBrowsingSetting = {}));
const SettingsSecurityPageV2ElementBase = SettingsViewMixin(PrefsMixin(PolymerElement));
class SettingsSecurityPageV2Element extends SettingsSecurityPageV2ElementBase {
    static get is() {
        return 'settings-security-page-v2';
    }
    static get template() {
        return getTemplate$1N();
    }
    static get properties() {
        return {
            securitySettingsBundleSettingEnum_: {
                type: Object,
                value: SecuritySettingsBundleSetting,
            },
            safeBrowsingSettingEnum_: {
                type: Object,
                value: SafeBrowsingSetting,
            },
            safeBrowsingOff_: {
                type: Array,
                value: () => [SafeBrowsingSetting.DISABLED],
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsSecurityPageV2Element.is, SettingsSecurityPageV2Element);

function getTemplate$1M() {
    return html `<!--_html_template_start_--><style include="settings-shared settings-columned-section">#disclaimer{padding:16px var(--cr-section-padding)}</style>
<settings-subpage page-title="$i18n{adMeasurementPageTitle}"
    learn-more-url="$i18n{adPrivacyLearnMoreURL}"
    route-path$="[[routePath]]">
  <settings-toggle-button
      id="adMeasurementToggle"
      pref="{{prefs.privacy_sandbox.m1.ad_measurement_enabled}}"
      label="$i18n{adMeasurementPageToggleLabel}"
      sub-label="$i18n{adMeasurementPageToggleSubLabel}"
      on-settings-boolean-control-change="onToggleChange_">
  </settings-toggle-button>
  <div class="settings-columned-section">
    <div class="column">
      <h2 class="description-header">$i18n{columnHeadingWhenOn}</h2>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:bar-chart" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{adMeasurementPageEnabledBullet1}</div>
        </li>
        <li>
          <cr-icon icon="settings20:auto-delete" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{adMeasurementPageEnabledBullet2}</div>
        </li>
        <li>
          <cr-icon icon="settings20:background-replace" aria-hidden="true">
          </cr-icon>
          <div class="secondary">$i18n{adMeasurementPageEnabledBullet3}</div>
        </li>
      </ul>
    </div>
    <div class="column">
      <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:delete" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{adMeasurementPageConsiderBullet1}</div>
        </li>
        <li>
          <cr-icon icon="settings20:filter-list" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{adMeasurementPageConsiderBullet2}</div>
        </li>
      </ul>
    </div>
  </div>
  <div id="disclaimer" class="cr-secondary-text hr">
    $i18nRaw{adMeasurementPageDisclaimer}
  </div>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPrivacySandboxAdMeasurementSubpageElementBase = SettingsViewMixin(PrefsMixin(PolymerElement));
class SettingsPrivacySandboxAdMeasurementSubpageElement extends SettingsPrivacySandboxAdMeasurementSubpageElementBase {
    static get is() {
        return 'settings-privacy-sandbox-ad-measurement-subpage';
    }
    static get template() {
        return getTemplate$1M();
    }
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    onToggleChange_(e) {
        const target = e.target;
        this.metricsBrowserProxy_.recordAction(target.checked ? 'Settings.PrivacySandbox.AdMeasurement.Enabled' :
            'Settings.PrivacySandbox.AdMeasurement.Disabled');
    }
    onPrivacyPolicyLinkClicked_() {
        this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.AdMeasurement.PrivacyPolicyLinkClicked');
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsPrivacySandboxAdMeasurementSubpageElement.is, SettingsPrivacySandboxAdMeasurementSubpageElement);

function getTemplate$1L() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">.interest-item{min-height:auto;padding-block-end:16px;padding-block-start:16px}#label{flex:1}site-favicon{margin-inline-end:16px}</style>
<div class="list-item interest-item" focus-row-container>
  <site-favicon hidden$="[[interest.topic]]" url="[[interest.site]]">
  </site-favicon>
  <div id="label">[[getDisplayString_(interest)]]</div>
  <cr-button role="button" on-click="onInterestChanged_"
      aria-label$="[[getButtonAriaLabel_(interest.removed)]]">
    [[getButtonLabel_(interest.removed)]]
  </cr-button>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'privacy-sandbox-interest-item' is the custom element to show a topics or
 * fledge interest in the privacy sandbox.
 */
const PrivacySandboxInterestItemElementBase = I18nMixin(PolymerElement);
class PrivacySandboxInterestItemElement extends PrivacySandboxInterestItemElementBase {
    static get is() {
        return 'privacy-sandbox-interest-item';
    }
    static get template() {
        return getTemplate$1L();
    }
    static get properties() {
        return {
            interest: Object,
        };
    }
    getDisplayString_() {
        if (this.interest.topic !== undefined) {
            assert(!this.interest.site);
            return this.interest.topic.displayString;
        }
        else {
            assert(!this.interest.topic);
            return this.interest.site;
        }
    }
    getButtonLabel_() {
        if (this.interest.topic !== undefined) {
            assert(!this.interest.site);
            return this.i18n(this.interest.removed ? 'unblockTopicButtonTextV2' :
                'topicsPageBlockTopic');
        }
        else {
            assert(!this.interest.topic);
            return this.i18n(this.interest.removed ? 'fledgePageAllowSite' :
                'fledgePageBlockSite');
        }
    }
    getButtonAriaLabel_() {
        if (this.interest.topic !== undefined) {
            assert(!this.interest.site);
            return this.i18n(this.interest.removed ? 'topicsPageUnblockTopicA11yLabel' :
                'topicsPageBlockTopicA11yLabel', this.interest.topic.displayString);
        }
        else {
            assert(!this.interest.topic);
            return this.i18n(this.interest.removed ? 'fledgePageAllowSiteA11yLabel' :
                'fledgePageBlockSiteA11yLabel', this.interest.site);
        }
    }
    onInterestChanged_(e) {
        e.stopPropagation();
        this.dispatchEvent(new CustomEvent('interest-changed', { bubbles: true, composed: true, detail: this.interest }));
    }
}
customElements.define(PrivacySandboxInterestItemElement.is, PrivacySandboxInterestItemElement);

function getTemplate$1K() {
    return html `<!--_html_template_start_--><style include="cr-shared-style">#currentSitesSection{align-items:center;display:flex;padding:0 var(--cr-section-padding)}#currentSitesSectionWrapper{width:100%}#currentSitesHeading{color:var(--cr-secondary-text-color);font-size:100%;font-weight:500;margin:0;padding-block-start:var(--cr-section-vertical-padding)}#currentSitesDescription{padding-block-end:var(--cr-section-vertical-padding)}#learnMoreLink,#learnMoreLinkV2{background:none;border:none;color:var(--cr-link-color);cursor:pointer;margin:0;padding:0;text-decoration:underline}.no-sites{padding-block-end:32px;padding-block-start:16px;padding-inline-start:40px}#blockedSitesDescription{min-height:auto;padding-block-end:16px;padding-block-start:16px}.no-blocked-sites{padding-inline-start:60px}#blockedSitesList{padding:0 var(--cr-section-padding)}#footer{padding-block-end:16px;padding-block-start:16px}#dialog p{margin:0;padding-block-end:16px;padding-block-start:4px}.footer{padding:16px var(--cr-section-padding)}#secondDescription,#secondDescriptionV2{padding:0 var(--cr-section-padding) var(--cr-section-vertical-padding)}a{color:var(--cr-link-color)}</style>

<settings-subpage page-title="$i18n{fledgePageTitle}"
    learn-more-url="$i18n{adPrivacyLearnMoreURL}"
    route-path$="[[routePath]]">
<settings-toggle-button
    id="siteSuggestedAdsToggleV2"
    pref="{{prefs.privacy_sandbox.m1.fledge_enabled}}"
    label="$i18n{fledgePageToggleLabel}"
    sub-label="$i18n{siteSuggestedAdsPageToggleSubLabelV2}"
    on-settings-boolean-control-change="onToggleChange_">
</settings-toggle-button>
<div id="secondDescriptionV2" class="cr-secondary-text">
  $i18n{siteSuggestedAdsPageExplanationV2}
  <button id="learnMoreLinkV2" on-click="onLearnMoreClick_"
      aria-label="$i18n{siteSuggestedAdsPageExplanationV2LinkAriaDescription}">
    $i18n{siteSuggestedAdsPageExplanationV2LinkText}
  </button>
</div>
<template is="dom-if" if="[[!isFledgePrefManaged_(
    prefs.privacy_sandbox.m1.fledge_enabled.enforcement)]]" restamp>
  <div id="currentSitesSection">
    <div id="currentSitesSectionWrapper" class="hr">
      <h2 id="currentSitesHeading">
        $i18n{fledgePageCurrentSitesHeading}
      </h2>
      <div id="currentSitesDescription" class="cr-secondary-text">
        $i18n{fledgePageCurrentSitesDescription}
      </div>
      <template is="dom-if" if="[[isFledgeEnabledAndLoaded_(
          prefs.privacy_sandbox.m1.fledge_enabled.value, isSitesListLoaded_)]]"
          restamp>
        <div role="region"
            aria-label="$i18n{fledgePageCurrentSitesRegionA11yDescription}">
          <template is="dom-repeat" items="[[mainSitesList_]]">
            <privacy-sandbox-interest-item interest="[[item]]"
                on-interest-changed="onInterestChanged_">
            </privacy-sandbox-interest-item>
          </template>
        </div>
        <template is="dom-if" if="[[!isRemainingSitesListEmpty_(
            remainingSitesList_.length)]]" restamp>
          <cr-expand-button id="seeAllSites"
              expanded="{{seeAllSitesExpanded_}}">
            $i18n{fledgePageSeeAllSitesLabel}
          </cr-expand-button>
          <cr-collapse opened="[[seeAllSitesExpanded_]]">
            <div role="region"
                aria-label="$i18n{fledgePageCurrentSitesRegionA11yDescription}">
              <template is="dom-repeat" items="[[remainingSitesList_]]">
                <privacy-sandbox-interest-item interest="[[item]]"
                    on-interest-changed="onInterestChanged_">
                </privacy-sandbox-interest-item>
              </template>
            </div>
          </cr-collapse>
        </template>
        <div id="currentSitesDescriptionEmpty"
            class="no-sites cr-secondary-text"
            hidden="[[!isSitesListEmpty_(sitesList_.length)]]">
          $i18n{fledgePageCurrentSitesDescriptionEmpty}
        </div>
      </template>
      <div id="currentSitesDescriptionDisabled"
          class="no-sites cr-secondary-text"
          hidden="[[prefs.privacy_sandbox.m1.fledge_enabled.value]]">
        $i18n{fledgePageCurrentSitesDescriptionDisabled}
      </div>
    </div>
  </div>
</template>
<cr-expand-button id="blockedSitesRow" class="cr-row"
    expanded="{{blockedSitesExpanded_}}">
  $i18n{fledgePageBlockedSitesHeading}
</cr-expand-button>
<cr-collapse opened="[[blockedSitesExpanded_]]">
  <div id="blockedSitesDescription"
      class$="[[getBlockedSitesDescriptionClass_(blockedSitesList_.length)]]">
    [[computeBlockedSitesDescription_(blockedSitesList_.length)]]
  </div>
  <div id="blockedSitesList" role="region"
      aria-label="$i18n{fledgePageBlockedSitesRegionA11yDescription}">
    <template is="dom-repeat" items="[[blockedSitesList_]]">
      <privacy-sandbox-interest-item interest="[[item]]"
          on-interest-changed="onInterestChanged_">
      </privacy-sandbox-interest-item>
    </template>
  </div>
</cr-collapse>

<div id="footerV2" class="cr-secondary-text hr footer">
  $i18nRaw{siteSuggestedAdsFooterV2Desktop}
</div>
<div id="disclaimer" class="cr-secondary-text footer">
  $i18nRaw{siteSuggestedAdsPageDisclaimer}
</div>
<template is="dom-if" if="[[isLearnMoreDialogOpen_]]" restamp>
  <cr-dialog id="dialog" on-close="onCloseDialog_" show-on-attach>
    <div slot="title">$i18n{fledgePageLearnMoreHeading}</div>
    <div id="bodyV2" slot="body">
      <p>$i18n{siteSuggestedAdsPageLearnMoreBullet1V2}</p>
      <p>$i18n{siteSuggestedAdsPageLearnMoreBullet2V2}</p>
      <p>$i18nRaw{siteSuggestedAdsPageLearnMoreBullet3V2}</p>
    </div>
    <div slot="button-container">
      <cr-button id="closeButton" class="cancel-button" autofocus
          on-click="onCloseDialog_">
        $i18n{close}
      </cr-button>
    </div>
  </cr-dialog>
</template>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const maxFledgeSitesCount = 15;
const SettingsPrivacySandboxFledgeSubpageElementBase = SettingsViewMixin(I18nMixin(PrefsMixin(PolymerElement)));
class SettingsPrivacySandboxFledgeSubpageElement extends SettingsPrivacySandboxFledgeSubpageElementBase {
    static get is() {
        return 'settings-privacy-sandbox-fledge-subpage';
    }
    static get template() {
        return getTemplate$1K();
    }
    static get properties() {
        return {
            sitesList_: {
                type: Array,
                observer: 'onSitesListChanged_',
                value() {
                    return [];
                },
            },
            /**
             * Helper list used to display the main sites in the current sites
             * section, above the "See all sites" expand button.
             */
            mainSitesList_: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * Helper list used to display the remaining sites in the current sites
             * section that are inside the "See all sites" expandable section.
             */
            remainingSitesList_: {
                type: Array,
                value() {
                    return [];
                },
            },
            blockedSitesList_: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * Used to determine that the Sites list was already fetched and to
             * display the current sites description only after the list is loaded,
             * to avoid displaying first the description for an empty list since the
             * array is empty at first when the page is loaded and switching to the
             * default description once the list is fetched.
             */
            isSitesListLoaded_: {
                type: Boolean,
                value: false,
            },
            isLearnMoreDialogOpen_: {
                type: Boolean,
                value: false,
            },
            seeAllSitesExpanded_: {
                type: Boolean,
                value: false,
                observer: 'onSeeAllSitesExpanded_',
            },
            blockedSitesExpanded_: {
                type: Boolean,
                value: false,
                observer: 'onBlockedSitesExpanded_',
            },
        };
    }
    static get maxFledgeSites() {
        return maxFledgeSitesCount;
    }
    privacySandboxBrowserProxy_ = PrivacySandboxBrowserProxyImpl.getInstance();
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    ready() {
        super.ready();
        this.privacySandboxBrowserProxy_.getFledgeState().then(state => this.onFledgeStateChanged_(state));
    }
    isFledgePrefManaged_() {
        const fledgeEnabledPref = this.getPref('privacy_sandbox.m1.fledge_enabled');
        if (fledgeEnabledPref.enforcement ===
            chrome.settingsPrivate.Enforcement.ENFORCED) {
            assert(!fledgeEnabledPref.value);
            return true;
        }
        return false;
    }
    onFledgeStateChanged_(state) {
        this.sitesList_ = state.joiningSites.map(site => {
            return { site, removed: false };
        });
        this.blockedSitesList_ = state.blockedSites.map(site => {
            return { site, removed: true };
        });
        this.isSitesListLoaded_ = true;
    }
    onSitesListChanged_() {
        this.mainSitesList_ = this.sitesList_.slice(0, maxFledgeSitesCount);
        this.remainingSitesList_ = this.sitesList_.slice(maxFledgeSitesCount);
    }
    isFledgeEnabledAndLoaded_() {
        return this.getPref('privacy_sandbox.m1.fledge_enabled').value &&
            this.isSitesListLoaded_;
    }
    isSitesListEmpty_() {
        return this.sitesList_.length === 0;
    }
    isRemainingSitesListEmpty_() {
        return this.remainingSitesList_.length === 0;
    }
    computeBlockedSitesDescription_() {
        return this.i18n(this.blockedSitesList_.length === 0 ?
            'fledgePageBlockedSitesDescriptionEmpty' :
            'fledgePageBlockedSitesDescription');
    }
    getBlockedSitesDescriptionClass_() {
        const defaultClass = 'cr-row continuation cr-secondary-text';
        return this.blockedSitesList_.length === 0 ?
            `${defaultClass} no-blocked-sites` :
            defaultClass;
    }
    onToggleChange_(e) {
        const target = e.target;
        this.metricsBrowserProxy_.recordAction(target.checked ? 'Settings.PrivacySandbox.Fledge.Enabled' :
            'Settings.PrivacySandbox.Fledge.Disabled');
        // Reset the list after the toggle changed. From disabled -> enabled, the
        // list should already be empty. From enabled -> disabled, the current list
        // is cleared.
        this.sitesList_ = [];
    }
    onLearnMoreClick_() {
        this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.Fledge.LearnMoreClicked');
        this.isLearnMoreDialogOpen_ = true;
    }
    onCloseDialog_() {
        this.isLearnMoreDialogOpen_ = false;
        afterNextRender(this, () => {
            // `learnMoreLink` might be null if the toggle was disabled after the
            // dialog was opened.
            this.shadowRoot.querySelector('#learnMoreLink')?.focus();
        });
    }
    onInterestChanged_(e) {
        const interest = e.detail;
        assert(!interest.topic);
        if (interest.removed) {
            this.blockedSitesList_.splice(this.blockedSitesList_.indexOf(interest), 1);
        }
        else {
            this.sitesList_.splice(this.sitesList_.indexOf(interest), 1);
            // Move the removed site automatically to the removed section.
            this.blockedSitesList_.push({ site: interest.site, removed: true });
            this.blockedSitesList_.sort((first, second) => (first.site < second.site) ? -1 : 1);
        }
        this.sitesList_ = this.sitesList_.slice();
        this.blockedSitesList_ = this.blockedSitesList_.slice();
        // If the interest was previously removed, set it to allowed, and vice
        // versa.
        this.privacySandboxBrowserProxy_.setFledgeJoiningAllowed(interest.site, /*allowed=*/ interest.removed);
        this.metricsBrowserProxy_.recordAction(interest.removed ? 'Settings.PrivacySandbox.Fledge.SiteAdded' :
            'Settings.PrivacySandbox.Fledge.SiteRemoved');
        // After allowing or blocking the last item, the focus is lost after the
        // item is removed. Set the focus to the #blockedSitesRow element.
        afterNextRender(this, () => {
            if (!this.shadowRoot.activeElement) {
                this.shadowRoot.querySelector('#blockedSitesRow')
                    ?.focus();
            }
        });
    }
    onSeeAllSitesExpanded_() {
        if (this.seeAllSitesExpanded_) {
            this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.Fledge.AllSitesOpened');
        }
    }
    onBlockedSitesExpanded_() {
        if (this.blockedSitesExpanded_) {
            this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.Fledge.BlockedSitesOpened');
        }
    }
    onPrivacyPolicyLinkClicked_() {
        this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.SiteSuggestedAds.PrivacyPolicyLinkClicked');
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsPrivacySandboxFledgeSubpageElement.is, SettingsPrivacySandboxFledgeSubpageElement);

const div$1 = document.createElement('div');
div$1.innerHTML = getTrustedHTML `<cr-iconset name="firstLevelTopics20" size="20">
    <svg>
      <defs>
        <g id="artist" viewBox="0 -960 960 960"><path d="M740-560h140v80h-80v220q0 42-29 71t-71 29q-42 0-71-29t-29-71q0-42 29-71t71-29q8 0 18 1.5t22 6.5v-208ZM120-160v-112q0-35 17.5-63t46.5-43q62-31 126-46.5T440-440q42 0 83.5 6.5T607-414q-20 12-36 29t-28 37q-26-6-51.5-9t-51.5-3q-57 0-112 14t-108 40q-9 5-14.5 14t-5.5 20v32h321q2 20 9.5 40t20.5 40H120Zm320-320q-66 0-113-47t-47-113q0-66 47-113t113-47q66 0 113 47t47 113q0 66-47 113t-113 47Zm0-80q33 0 56.5-23.5T520-640q0-33-23.5-56.5T440-720q-33 0-56.5 23.5T360-640q0 33 23.5 56.5T440-560Zm0-80Zm0 400Z"></path></g>
        <g id="bigtop-updates" viewBox="0 -960 960 960"><path d="M198-278q-57-57-87.5-129.5T80-560q0-80 30.5-152.5T198-842l48 48q-47 47-72.5 107.5T148-560q0 66 25.5 126.5T246-326l-48 48Zm92-92q-38-38-58-87t-20-103q0-54 20-103t58-87l48 48q-29 29-43.5 65.5T280-560q0 40 14.5 76.5T338-418l-48 48Zm150 250v-348q-27-12-43.5-37T380-560q0-42 29-71t71-29q42 0 71 29t29 71q0 30-16.5 55T520-468v348h-80Zm230-250-48-48q29-29 43.5-65.5T680-560q0-40-14.5-76.5T622-702l48-48q38 38 58 87t20 103q0 54-20 103t-58 87Zm92 92-48-48q47-47 72.5-107.5T812-560q0-66-25.5-126.5T714-794l48-48q57 57 87.5 129.5T880-560q0 80-30.5 152.5T762-278Z"></path></g>
        <g id="business-center" viewBox="0 -960 960 960"><path d="M160-120q-33 0-56.5-23.5T80-200v-440q0-33 23.5-56.5T160-720h160v-80q0-33 23.5-56.5T400-880h160q33 0 56.5 23.5T640-800v80h160q33 0 56.5 23.5T880-640v440q0 33-23.5 56.5T800-120H160Zm240-600h160v-80H400v80Zm400 360H600v80H360v-80H160v160h640v-160Zm-360 0h80v-80h-80v80Zm-280-80h200v-80h240v80h200v-200H160v200Zm320 40Z"></path></g>
        <g id="category" viewBox="0 -960 960 960"><path d="m260-520 220-360 220 360H260ZM700-80q-75 0-127.5-52.5T520-260q0-75 52.5-127.5T700-440q75 0 127.5 52.5T880-260q0 75-52.5 127.5T700-80Zm-580-20v-320h320v320H120Zm580-60q42 0 71-29t29-71q0-42-29-71t-71-29q-42 0-71 29t-29 71q0 42 29 71t71 29Zm-500-20h160v-160H200v160Zm202-420h156l-78-126-78 126Zm78 0ZM360-340Zm340 80Z"></path></g>
        <g id="communities" viewBox="0 -960 960 960"><path d="M360-320q33 0 56.5-23.5T440-400q0-33-23.5-56.5T360-480q-33 0-56.5 23.5T280-400q0 33 23.5 56.5T360-320Zm240 0q33 0 56.5-23.5T680-400q0-33-23.5-56.5T600-480q-33 0-56.5 23.5T520-400q0 33 23.5 56.5T600-320ZM480-520q33 0 56.5-23.5T560-600q0-33-23.5-56.5T480-680q-33 0-56.5 23.5T400-600q0 33 23.5 56.5T480-520Zm0 440q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q134 0 227-93t93-227q0-134-93-227t-227-93q-134 0-227 93t-93 227q0 134 93 227t227 93Zm0-320Z"></path></g>
        <g id="crowdsource" viewBox="0 -960 960 960"><path d="M660-570q-25 0-42.5-17.5T600-630q0-25 17.5-42.5T660-690q25 0 42.5 17.5T720-630q0 25-17.5 42.5T660-570Zm-360 0q-25 0-42.5-17.5T240-630q0-25 17.5-42.5T300-690q25 0 42.5 17.5T360-630q0 25-17.5 42.5T300-570Zm180 110q-25 0-42.5-17.5T420-520q0-25 17.5-42.5T480-580q25 0 42.5 17.5T540-520q0 25-17.5 42.5T480-460Zm0-220q-25 0-42.5-17.5T420-740q0-25 17.5-42.5T480-800q25 0 42.5 17.5T540-740q0 25-17.5 42.5T480-680Zm0 520q-20 0-40.5-3t-39.5-8v-143q0-35 23.5-60.5T480-400q33 0 56.5 25.5T560-314v143q-19 5-39.5 8t-40.5 3Zm-140-32q-20-8-38.5-18T266-232q-28-20-44.5-52T205-352q0-26-5.5-48.5T180-443q-10-13-37.5-39.5T92-532q-11-11-11-28t11-28q11-11 28-11t28 11l153 145q20 18 29.5 42.5T340-350v158Zm280 0v-158q0-26 10-51t29-42l153-145q12-11 28.5-11t27.5 11q11 11 11 28t-11 28q-23 23-50.5 49T780-443q-14 20-19.5 42.5T755-352q0 36-16.5 68.5T693-231q-16 11-34.5 21T620-192Z"></path></g>
        <g id="directions-car" viewBox="0 -960 960 960"><path d="M240-200v40q0 17-11.5 28.5T200-120h-40q-17 0-28.5-11.5T120-160v-320l84-240q6-18 21.5-29t34.5-11h440q19 0 34.5 11t21.5 29l84 240v320q0 17-11.5 28.5T800-120h-40q-17 0-28.5-11.5T720-160v-40H240Zm-8-360h496l-42-120H274l-42 120Zm-32 80v200-200Zm100 160q25 0 42.5-17.5T360-380q0-25-17.5-42.5T300-440q-25 0-42.5 17.5T240-380q0 25 17.5 42.5T300-320Zm360 0q25 0 42.5-17.5T720-380q0-25-17.5-42.5T660-440q-25 0-42.5 17.5T600-380q0 25 17.5 42.5T660-320Zm-460 40h560v-200H200v200Z"></path></g>
        <g id="keyboard" viewBox="0 -960 960 960"><path d="M160-200q-33 0-56.5-23.5T80-280v-400q0-33 23.5-56.5T160-760h640q33 0 56.5 23.5T880-680v400q0 33-23.5 56.5T800-200H160Zm0-80h640v-400H160v400Zm160-40h320v-80H320v80ZM200-440h80v-80h-80v80Zm120 0h80v-80h-80v80Zm120 0h80v-80h-80v80Zm120 0h80v-80h-80v80Zm120 0h80v-80h-80v80ZM200-560h80v-80h-80v80Zm120 0h80v-80h-80v80Zm120 0h80v-80h-80v80Zm120 0h80v-80h-80v80Zm120 0h80v-80h-80v80ZM160-280v-400 400Z"></path></g>
        <g id="menu-book" viewBox="0 -960 960 960"><path d="M560-564v-68q33-14 67.5-21t72.5-7q26 0 51 4t49 10v64q-24-9-48.5-13.5T700-600q-38 0-73 9.5T560-564Zm0 220v-68q33-14 67.5-21t72.5-7q26 0 51 4t49 10v64q-24-9-48.5-13.5T700-380q-38 0-73 9t-67 27Zm0-110v-68q33-14 67.5-21t72.5-7q26 0 51 4t49 10v64q-24-9-48.5-13.5T700-490q-38 0-73 9.5T560-454ZM260-320q47 0 91.5 10.5T440-278v-394q-41-24-87-36t-93-12q-36 0-71.5 7T120-692v396q35-12 69.5-18t70.5-6Zm260 42q44-21 88.5-31.5T700-320q36 0 70.5 6t69.5 18v-396q-33-14-68.5-21t-71.5-7q-47 0-93 12t-87 36v394Zm-40 118q-48-38-104-59t-116-21q-42 0-82.5 11T100-198q-21 11-40.5-1T40-234v-482q0-11 5.5-21T62-752q46-24 96-36t102-12q58 0 113.5 15T480-740q51-30 106.5-45T700-800q52 0 102 12t96 36q11 5 16.5 15t5.5 21v482q0 23-19.5 35t-40.5 1q-37-20-77.5-31T700-240q-60 0-116 21t-104 59ZM280-494Z"></path></g>
        <g id="fastfood" viewBox="0 -960 960 960"><path d="M533-440q-32-45-84.5-62.5T340-520q-56 0-108.5 17.5T147-440h386ZM40-360q0-109 91-174.5T340-600q118 0 209 65.5T640-360H40Zm0 160v-80h600v80H40ZM720-40v-80h56l56-560H450l-10-80h200v-160h80v160h200L854-98q-3 25-22 41.5T788-40h-68Zm0-80h56-56ZM80-40q-17 0-28.5-11.5T40-80v-40h600v40q0 17-11.5 28.5T600-40H80Zm260-400Z"></path></g>
        <g id="finance-mode" viewBox="0 -960 960 960"><path d="M320-414v-306h120v306l-60-56-60 56Zm200 60v-526h120v406L520-354ZM120-216v-344h120v224L120-216Zm0 98 258-258 142 122 224-224h-64v-80h200v200h-80v-64L524-146 382-268 232-118H120Z"></path></g>
        <g id="gavel" viewBox="0 -960 960 960"><path d="M160-120v-80h480v80H160Zm226-194L160-540l84-86 228 226-86 86Zm254-254L414-796l86-84 226 226-86 86Zm184 408L302-682l56-56 522 522-56 56Z"></path></g>
        <g id="health-and-beauty" viewBox="0 -960 960 960"><path d="M200-80 40-520l200-120v-240h160v240l200 120L440-80H200Zm480 0q-17 0-28.5-11.5T640-120q0-17 11.5-28.5T680-160h120v-80H680q-17 0-28.5-11.5T640-280q0-17 11.5-28.5T680-320h120v-80H680q-17 0-28.5-11.5T640-440q0-17 11.5-28.5T680-480h120v-80H680q-17 0-28.5-11.5T640-600q0-17 11.5-28.5T680-640h120v-80H680q-17 0-28.5-11.5T640-760q0-17 11.5-28.5T680-800h160q33 0 56.5 23.5T920-720v560q0 33-23.5 56.5T840-80H680Zm-424-80h128l118-326-124-74H262l-124 74 118 326Zm64-200Z"></path></g>
        <g id="home-and-garden" viewBox="0 -960 960 960"><path d="M641-26q-20 12-41.5 19T555 0q-64 0-109-45.5T401-156q0-23 6.5-44t19.5-40q-13-19-19.5-41t-6.5-45q0-64 45-109t109-45q23 0 45 6.5t41 19.5q19-13 41-19.5t45-6.5q64 0 109 44.5T881-328q0 23-6.5 45T855-242q13 20 19.5 42.5T881-154q0 64-45.5 109T725 0q-23 0-44-7t-40-19Zm134-183-36-32 40-34q11-9 16.5-22.5T801-326q0-31-21.5-52.5T727-400q-16 0-29.5 5.5T675-378l-35 40-34-40q-9-11-22.5-16.5T554-400q-30 0-51.5 22T481-324q0 15 6.5 28.5T506-271l36 30-40 34q-10 9-15.5 22t-5.5 29q0 32 21.5 54T554-80q15 0 29.5-7t26.5-21l30-34 35 40q9 11 22.5 16.5T727-80q31 0 52.5-22t21.5-54q0-14-6.5-28T775-209Zm-134 25q23 0 39.5-16.5T697-240q0-23-16.5-39.5T641-296q-23 0-39.5 16.5T585-240q0 23 16.5 39.5T641-184Zm-481 24v-402H40l440-358 440 358H800v42h-80v-102L480-818 240-622v382h120v80H160Zm481-80Z"></path></g>
        <g id="newsmode" viewBox="0 -960 960 960"><path d="M160-120q-33 0-56.5-23.5T80-200v-560q0-33 23.5-56.5T160-840h640q33 0 56.5 23.5T880-760v560q0 33-23.5 56.5T800-120H160Zm0-80h640v-560H160v560Zm80-80h480v-80H240v80Zm0-160h160v-240H240v240Zm240 0h240v-80H480v80Zm0-160h240v-80H480v80ZM160-200v-560 560Z"></path></g>
        <g id="pets" viewBox="0 -960 960 960"><path d="M180-475q-42 0-71-29t-29-71q0-42 29-71t71-29q42 0 71 29t29 71q0 42-29 71t-71 29Zm180-160q-42 0-71-29t-29-71q0-42 29-71t71-29q42 0 71 29t29 71q0 42-29 71t-71 29Zm240 0q-42 0-71-29t-29-71q0-42 29-71t71-29q42 0 71 29t29 71q0 42-29 71t-71 29Zm180 160q-42 0-71-29t-29-71q0-42 29-71t71-29q42 0 71 29t29 71q0 42-29 71t-71 29ZM266-75q-45 0-75.5-34.5T160-191q0-52 35.5-91t70.5-77q29-31 50-67.5t50-68.5q22-26 51-43t63-17q34 0 63 16t51 42q28 32 49.5 69t50.5 69q35 38 70.5 77t35.5 91q0 47-30.5 81.5T694-75q-54 0-107-9t-107-9q-54 0-107 9t-107 9Z"></path></g>
        <g id="real-estate-agent" viewBox="0 -960 960 960"><path d="M760-400v-260L560-800 360-660v60h-80v-100l280-200 280 200v300h-80ZM560-800Zm20 160h40v-40h-40v40Zm-80 0h40v-40h-40v40Zm80 80h40v-40h-40v40Zm-80 0h40v-40h-40v40ZM280-220l278 76 238-74q-5-9-14.5-15.5T760-240H558q-27 0-43-2t-33-8l-93-31 22-78 81 27q17 5 40 8t68 4q0-11-6.5-21T578-354l-234-86h-64v220ZM40-80v-440h304q7 0 14 1.5t13 3.5l235 87q33 12 53.5 42t20.5 66h80q50 0 85 33t35 87v40L560-60l-280-78v58H40Zm80-80h80v-280h-80v280Z"></path></g>
        <g id="sailing" viewBox="0 -960 960 960"><path d="m120-420 320-460v460H120Zm153-80h87v-125l-87 125Zm227 80q12-28 26-98t14-142q0-72-13.5-148T500-920q61 18 121.5 67t109 117q48.5 68 79 149.5T840-420H500Zm104-80h148q-17-77-55.5-141T615-750q2 21 3.5 43.5T620-660q0 47-4.5 87T604-500ZM360-200q-36 0-67-17t-53-43q-14 15-30.5 28T173-211q-35-26-59.5-64.5T80-360h800q-9 46-33.5 84.5T787-211q-20-8-36.5-21T720-260q-23 26-53.5 43T600-200q-36 0-67-17t-53-43q-22 26-53 43t-67 17ZM80-40v-80h40q32 0 62.5-10t57.5-30q27 20 57.5 29.5T360-121q32 0 62-9.5t58-29.5q27 20 57.5 29.5T600-121q32 0 62-9.5t58-29.5q28 20 58 30t62 10h40v80h-40q-31 0-61-7.5T720-70q-29 15-59 22.5T600-40q-31 0-61-7.5T480-70q-29 15-59 22.5T360-40q-31 0-61-7.5T240-70q-29 15-59 22.5T120-40H80Zm280-460Zm244 0Z"></path></g>
        <g id="school" viewBox="0 -960 960 960"><path d="M480-120 200-272v-240L40-600l440-240 440 240v320h-80v-276l-80 44v240L480-120Zm0-332 274-148-274-148-274 148 274 148Zm0 241 200-108v-151L480-360 280-470v151l200 108Zm0-241Zm0 90Zm0 0Z"></path></g>
        <g id="shopping-bag" viewBox="0 -960 960 960"><path d="M240-80q-33 0-56.5-23.5T160-160v-480q0-33 23.5-56.5T240-720h80q0-66 47-113t113-47q66 0 113 47t47 113h80q33 0 56.5 23.5T800-640v480q0 33-23.5 56.5T720-80H240Zm0-80h480v-480h-80v80q0 17-11.5 28.5T600-520q-17 0-28.5-11.5T560-560v-80H400v80q0 17-11.5 28.5T360-520q-17 0-28.5-11.5T320-560v-80h-80v480Zm160-560h160q0-33-23.5-56.5T480-800q-33 0-56.5 23.5T400-720ZM240-160v-480 480Z"></path></g>
        <g id="sports-and-outdoors" viewBox="0 -960 960 960"><path d="m414-168 12-56q3-13 12.5-21.5T462-256l124-10q13-2 24 5t16 19l16 38q39-23 70-55.5t52-72.5l-12-6q-11-8-16-19.5t-2-24.5l28-122q3-12 12.5-20t21.5-10q-5-25-12.5-48.5T764-628q-9 5-19.5 4.5T726-630l-106-64q-11-7-16-19t-2-25l8-34q-31-14-63.5-21t-66.5-7q-14 0-29 1.5t-29 4.5l30 68q5 12 2.5 25T442-680l-94 82q-10 9-23.5 10t-24.5-6l-92-56q-23 38-35.5 81.5T160-480q0 16 4 52l88-8q14-2 25.5 4.5T294-412l48 114q5 12 2.5 25T332-252l-38 32q27 20 57.5 33t62.5 19Zm72-172q-13 2-24-5t-16-19l-54-124q-5-12-1.5-25t13.5-21l102-86q9-9 22-10t24 6l112 66q11 7 17 19t3 25l-32 130q-3 13-12 21.5T618-352l-132 12Zm-6 260q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Z"></path></g>
        <g id="travel" viewBox="0 -960 960 960"><path d="m274-274-128-70 42-42 100 14 156-156-312-170 56-56 382 98 157-155q17-17 42.5-17t42.5 17q17 17 17 42.5T812-726L656-570l98 382-56 56-170-312-156 156 14 100-42 42-70-128Z"></path></g>
        <g id="videogame-asset" viewBox="0 -960 960 960"><path d="M160-240q-33 0-56.5-23.5T80-320v-320q0-33 23.5-56.5T160-720h640q33 0 56.5 23.5T880-640v320q0 33-23.5 56.5T800-240H160Zm0-80h640v-320H160v320Zm120-40h80v-80h80v-80h-80v-80h-80v80h-80v80h80v80Zm300 0q25 0 42.5-17.5T640-420q0-25-17.5-42.5T580-480q-25 0-42.5 17.5T520-420q0 25 17.5 42.5T580-360Zm120-120q25 0 42.5-17.5T760-540q0-25-17.5-42.5T700-600q-25 0-42.5 17.5T640-540q0 25 17.5 42.5T700-480ZM160-320v-320 320Z"></path></g>
      </defs>
    </svg>
</cr-iconset>
`;
const iconsets$1 = div$1.querySelectorAll('cr-iconset');
for (const iconset of iconsets$1) {
    document.head.appendChild(iconset);
}

function getTemplate$1J() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">#explanationText{padding:4px var(--cr-section-padding) 12px}.outer-row{align-items:center;display:flex;min-height:var(--cr-section-two-line-min-height);width:100%}.topic-toggle-row:hover{background-color:var(--cr-hover-background-color)}.topic-toggle-row{--cr-icon-button-margin-end:20px;padding:0 var(--cr-section-padding)}.icon{margin-inline-end:var(--cr-icon-button-margin-end)}.label-wrapper{padding:16px 0;margin-inline-end:20px}
</style>
<settings-subpage page-title="$i18n{manageTopicsHeading}"
    learn-more-url="$i18n{adPrivacyLearnMoreURL}"
    route-path$="[[routePath]]">
  <div id="explanationText">
    $i18n{manageTopicsPageDescription}
    <span id="learnMoreLink" on-click="onLearnMoreClick_">
      $i18nRaw{manageTopicsPageLearnMoreLink}
    </span>
  </div>
  <template is="dom-repeat" items="[[firstLevelTopicsList_]]">
    <div class="topic-toggle-row" on-click="onToggleRowClick_" actionable>
      <div class="outer-row">
        <span class="icon">
          <cr-icon slot="icon"
              icon="[[computeTopicIcon_(item.topic.topicId)]]">
          </cr-icon>
        </span>
        <div class="flex label-wrapper">
          <div class="label">[[item.topic.displayString]]</div>
          <div class="cr-secondary-text sub-label">
            <span class="sub-label-text">[[item.topic.description]]</span>
          </div>
        </div>
        <cr-toggle id="toggle-[[item.topic.topicId]]"
            on-change="onToggleChange_"
            checked="[[!item.removed]]"
            aria-label="[[item.topic.displayString]]"
            aria-description="[[item.topic.description]]"></cr-toggle>
      </div>
    </div>
  </template>
  <template is="dom-if" if="[[shouldShowBlockTopicDialog_]]" restamp>
    <settings-simple-confirmation-dialog id="blockTopicDialog"
        title-text="[[blockTopicDialogTitle_]]"
        body-text="[[blockTopicDialogBody_]]"
        confirm-text="$i18n{topicsPageBlockTopic}"
        on-close="onBlockTopicDialogClose_">
    </settings-simple-confirmation-dialog>
  </template>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPrivacySandboxManageTopicsSubpageElementBase = SettingsViewMixin(RouteObserverMixin(I18nMixin(PrefsMixin(PolymerElement))));
// First Level Topics for Taxonomy v2
// This list comes from here:
// https://github.com/patcg-individual-drafts/topics/blob/main/taxonomy_v2.md
const topicIdToIconName = new Map([
    [1, 'firstLevelTopics20:artist'],
    [57, 'firstLevelTopics20:directions-car'],
    [86, 'firstLevelTopics20:health-and-beauty'],
    [100, 'firstLevelTopics20:menu-book'],
    [103, 'firstLevelTopics20:business-center'],
    [126, 'firstLevelTopics20:keyboard'],
    [149, 'firstLevelTopics20:finance-mode'],
    [172, 'firstLevelTopics20:fastfood'],
    [180, 'firstLevelTopics20:videogame-asset'],
    [196, 'firstLevelTopics20:sailing'],
    [207, 'firstLevelTopics20:home-and-garden'],
    [215, 'firstLevelTopics20:bigtop-updates'],
    [226, 'firstLevelTopics20:school'],
    [239, 'firstLevelTopics20:gavel'],
    [243, 'firstLevelTopics20:newsmode'],
    [250, 'firstLevelTopics20:communities'],
    [254, 'firstLevelTopics20:crowdsource'],
    [263, 'firstLevelTopics20:pets'],
    [272, 'firstLevelTopics20:real-estate-agent'],
    [289, 'firstLevelTopics20:shopping-bag'],
    [299, 'firstLevelTopics20:sports-and-outdoors'],
    [332, 'firstLevelTopics20:travel'],
]);
class SettingsPrivacySandboxManageTopicsSubpageElement extends SettingsPrivacySandboxManageTopicsSubpageElementBase {
    static get is() {
        return 'settings-privacy-sandbox-manage-topics-subpage';
    }
    static get template() {
        return getTemplate$1J();
    }
    static get properties() {
        return {
            firstLevelTopicsList_: {
                type: Array,
                value() {
                    return [];
                },
            },
            blockTopicDialogTitle_: {
                type: String,
                value: '',
            },
            blockTopicDialogBody_: {
                type: String,
                value: '',
            },
            shouldShowBlockTopicDialog_: {
                type: Boolean,
                value: false,
            },
        };
    }
    privacySandboxBrowserProxy_ = PrivacySandboxBrowserProxyImpl.getInstance();
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    topicBeingToggled_;
    ready() {
        super.ready();
        this.privacySandboxBrowserProxy_.getFirstLevelTopics().then(state => this.onFirstLevelTopicsStateChanged_(state));
    }
    currentRouteChanged(newRoute, oldRoute) {
        super.currentRouteChanged(newRoute, oldRoute);
        if (newRoute === routes.PRIVACY_SANDBOX_MANAGE_TOPICS) {
            // Should not be able to navigate to Manage Topics page when topics is
            // disabled.
            if (!this.getPref('privacy_sandbox.m1.topics_enabled').value) {
                Router.getInstance().navigateTo(routes.PRIVACY_SANDBOX_TOPICS);
                return;
            }
            // Updating the FirstLevelTopicsState because it can be changed by being
            // blocked/unblocked in the Ad Topics Page. Need to keep the data between
            // the two pages up to date.
            this.privacySandboxBrowserProxy_.getFirstLevelTopics().then(state => this.onFirstLevelTopicsStateChanged_(state));
            this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.Topics.Manage.PageOpened');
        }
    }
    onFirstLevelTopicsStateChanged_(state) {
        const blockedTopicsList = state.blockedTopics.map(topic => {
            return { topic, removed: true };
        });
        this.firstLevelTopicsList_ = state.firstLevelTopics.map(firstLevelTopic => {
            return {
                topic: firstLevelTopic,
                removed: blockedTopicsList.some(interest => interest.topic?.topicId === firstLevelTopic.topicId),
            };
        });
    }
    // When the user clicks anywhere on the toggle row, we click the toggle itself
    // here to trigger its on-change event.
    onToggleRowClick_(e) {
        e.stopPropagation();
        assert(e.model.item?.topic);
        const toggleId = `#toggle-${e.model.item.topic.topicId}`;
        const toggleBeingChanged = this.shadowRoot.querySelector(toggleId);
        assert(toggleBeingChanged);
        toggleBeingChanged.click();
    }
    async onToggleChange_(e) {
        e.stopPropagation();
        this.topicBeingToggled_ = e.model.item;
        assert(this.topicBeingToggled_);
        assert(this.topicBeingToggled_.topic);
        const toggleId = `#toggle-${this.topicBeingToggled_.topic.topicId}`;
        const toggleBeingChanged = this.shadowRoot.querySelector(toggleId);
        assert(toggleBeingChanged);
        // At this point, the toggle checked state has already changed. If the
        // toggle is now checked, then the First Level Topic needs to be updated to
        // be unblocked.
        if (toggleBeingChanged.checked) {
            this.updateTopicState_({ blocked: false });
            return;
        }
        // Check if the attempted blocked topic has active child topics
        const childTopics = await this.privacySandboxBrowserProxy_.getChildTopicsCurrentlyAssigned(this.topicBeingToggled_.topic);
        if (childTopics.length !== 0) {
            this.blockTopicDialogTitle_ = loadTimeData.getStringF('manageTopicsDialogTitle', this.topicBeingToggled_.topic.displayString);
            this.blockTopicDialogBody_ = loadTimeData.getStringF('manageTopicsDialogBody', this.topicBeingToggled_.topic.displayString);
            this.shouldShowBlockTopicDialog_ = true;
            return;
        }
        // Blocking a topic without any assigned children. Should update the new
        // blocked state with the privacySandboxProxy.
        this.updateTopicState_({ blocked: true });
    }
    // Changes the state of the first level topic being toggled to be
    // blocked/unblocked. Calls the privacySandboxProxy to set the topic to
    // allowed/disallowed.
    updateTopicState_(blockedOptions) {
        assert(this.topicBeingToggled_);
        assert(this.topicBeingToggled_.topic);
        this.topicBeingToggled_.removed = blockedOptions.blocked;
        this.firstLevelTopicsList_ = this.firstLevelTopicsList_.slice();
        this.privacySandboxBrowserProxy_.setTopicAllowed(this.topicBeingToggled_.topic, !blockedOptions.blocked);
        this.topicBeingToggled_ = undefined;
        if (blockedOptions.blocked) {
            this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.Topics.Manage.TopicBlocked');
        }
        else {
            this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.Topics.Manage.TopicEnabled');
        }
    }
    onBlockTopicDialogClose_() {
        const dialog = this.shadowRoot.querySelector('settings-simple-confirmation-dialog');
        assert(dialog);
        if (dialog.wasConfirmed()) {
            this.onBlockButtonDialogHandler_();
        }
        else {
            this.onCancelButtonDialogHandler_();
        }
        this.blockTopicDialogBody_ = '';
        this.blockTopicDialogTitle_ = '';
        this.topicBeingToggled_ = undefined;
        this.shouldShowBlockTopicDialog_ = false;
    }
    onCancelButtonDialogHandler_() {
        this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.Topics.Manage.TopicBlockingCanceled');
        // This causes the list to be fully re-rendered, in order to revert the
        // toggle back to being checked after the user decides to block the topic.
        this.firstLevelTopicsList_ = this.firstLevelTopicsList_.map(topic => {
            return {
                ...topic,
            };
        });
    }
    onBlockButtonDialogHandler_() {
        this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.Topics.Manage.TopicBlockingConfirmed');
        this.updateTopicState_({ blocked: true });
    }
    onLearnMoreClick_() {
        this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.Topics.Manage.LearnMoreClicked');
    }
    // TODO(b/321007722): Add test to make sure there is always a icon based on
    // the variability of different taxonomies.
    computeTopicIcon_(topicId) {
        return topicIdToIconName.get(topicId) || 'firstLevelTopics20:category';
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsPrivacySandboxManageTopicsSubpageElement.is, SettingsPrivacySandboxManageTopicsSubpageElement);

function getTemplate$1I() {
    return html `<!--_html_template_start_--><style include="cr-shared-style"></style>
<settings-subpage page-title="$i18n{adPrivacyPageTitle}"
    learn-more-url="$i18n{adPrivacyLearnMoreURL}"
    route-path$="[[routePath]]">
  <template is="dom-if" if="[[!isPrivacySandboxRestricted_]]">
    <cr-link-row
        id="privacySandboxTopicsLinkRow"
        start-icon="settings20:interests"
        label="$i18n{adPrivacyPageTopicsLinkRowLabel}"
        sub-label="[[computePrivacySandboxTopicsSublabel_(
                      prefs.privacy_sandbox.m1.topics_enabled.value)]]"
        on-click="onPrivacySandboxTopicsClick_"></cr-link-row>
    <cr-link-row
        id="privacySandboxFledgeLinkRow"
        start-icon="settings20:checklist"
        class="hr"
        label="$i18n{adPrivacyPageFledgeLinkRowLabel}"
        sub-label="[[computePrivacySandboxFledgeSublabel_(
                      prefs.privacy_sandbox.m1.fledge_enabled.value)]]"
        on-click="onPrivacySandboxFledgeClick_"></cr-link-row>
  </template>
  <cr-link-row
      id="privacySandboxAdMeasurementLinkRow"
      start-icon="settings20:bar-chart"
      class$="[[measurementLinkRowClass_]]"
      label="$i18n{adPrivacyPageAdMeasurementLinkRowLabel}"
      sub-label="[[computePrivacySandboxAdMeasurementSublabel_(
                    prefs.privacy_sandbox.m1.ad_measurement_enabled.value)]]"
      on-click="onPrivacySandboxAdMeasurementClick_"></cr-link-row>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPrivacySandboxPageElementBase = SettingsViewMixin(I18nMixin(PrefsMixin(PolymerElement)));
class SettingsPrivacySandboxPageElement extends SettingsPrivacySandboxPageElementBase {
    static get is() {
        return 'settings-privacy-sandbox-page';
    }
    static get template() {
        return getTemplate$1I();
    }
    static get properties() {
        return {
            isPrivacySandboxRestricted_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('isPrivacySandboxRestricted'),
            },
            measurementLinkRowClass_: {
                type: String,
                value: () => loadTimeData.getBoolean('isPrivacySandboxRestricted') ? '' : 'hr',
            },
        };
    }
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    computePrivacySandboxTopicsSublabel_() {
        return this.i18n(this.isTopicsEnabled_() ? 'adPrivacyPageTopicsLinkRowSubLabelEnabled' :
            'adPrivacyPageTopicsLinkRowSubLabelDisabled');
    }
    computePrivacySandboxFledgeSublabel_() {
        return this.i18n(this.isFledgeEnabled_() ? 'adPrivacyPageFledgeLinkRowSubLabelEnabled' :
            'adPrivacyPageFledgeLinkRowSubLabelDisabled');
    }
    computePrivacySandboxAdMeasurementSublabel_() {
        return this.i18n(this.isAdMeasurementEnabled_() ?
            'adPrivacyPageAdMeasurementLinkRowSubLabelEnabled' :
            'adPrivacyPageAdMeasurementLinkRowSubLabelDisabled');
    }
    onPrivacySandboxTopicsClick_() {
        this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.Topics.Opened');
        Router.getInstance().navigateTo(routes.PRIVACY_SANDBOX_TOPICS);
    }
    onPrivacySandboxFledgeClick_() {
        this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.Fledge.Opened');
        Router.getInstance().navigateTo(routes.PRIVACY_SANDBOX_FLEDGE);
    }
    onPrivacySandboxAdMeasurementClick_() {
        this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.AdMeasurement.Opened');
        Router.getInstance().navigateTo(routes.PRIVACY_SANDBOX_AD_MEASUREMENT);
    }
    isTopicsEnabled_() {
        return this.getPref('privacy_sandbox.m1.topics_enabled').value;
    }
    isFledgeEnabled_() {
        return this.getPref('privacy_sandbox.m1.fledge_enabled').value;
    }
    isAdMeasurementEnabled_() {
        return this.getPref('privacy_sandbox.m1.ad_measurement_enabled').value;
    }
    // SettingsViewMixin implementation.
    getFocusConfig() {
        const map = new Map();
        if (routes.PRIVACY_SANDBOX_TOPICS) {
            map.set(routes.PRIVACY_SANDBOX_TOPICS.path, '#privacySandboxTopicsLinkRow');
        }
        if (routes.PRIVACY_SANDBOX_FLEDGE) {
            map.set(routes.PRIVACY_SANDBOX_FLEDGE.path, '#privacySandboxFledgeLinkRow');
        }
        if (routes.PRIVACY_SANDBOX_AD_MEASUREMENT) {
            map.set(routes.PRIVACY_SANDBOX_AD_MEASUREMENT.path, '#privacySandboxAdMeasurementLinkRow');
        }
        return map;
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsPrivacySandboxPageElement.is, SettingsPrivacySandboxPageElement);

function getTemplate$1H() {
    return html `<!--_html_template_start_--><style include="cr-shared-style">#currentTopicsSection{align-items:center;display:flex;padding:0 var(--cr-section-padding)}.topics-empty-text{width:100%;display:flex;flex-direction:column;justify-content:center;align-items:center;text-align:center;padding-top:48px;padding-bottom:48px}#currentTopicsSectionWrapper{width:100%}#currentTopicsHeading{color:var(--cr-secondary-text-color);font-size:100%;font-weight:500;margin:0;padding-block-start:var(--cr-section-vertical-padding)}#currentTopicsDescription{padding-block-end:var(--cr-section-vertical-padding)}#disclaimer{padding:0 var(--cr-section-padding);padding-bottom:var(--cr-section-vertical-padding);color:var(--cr-secondary-text-color)}#learnMoreLink{background:none;border:none;color:var(--cr-link-color);cursor:pointer;margin:0;padding:0;text-decoration:underline}.no-topics{padding-block-end:32px;padding-block-start:16px;padding-inline-start:40px}#blockedTopicsDescription{color:var(--cr-secondary-text-color)}.no-blocked-topics{padding-inline-start:60px}#blockedTopicsList{padding:0 var(--cr-section-padding)}.footer{padding:16px var(--cr-section-padding)}a{color:var(--cr-link-color)}#dialog p{margin:0;padding-block-end:16px;padding-block-start:4px}cr-toast{--cr-toast-max-width:80%}</style>

<settings-subpage page-title="$i18n{topicsPageTitle}"
    learn-more-url="$i18n{adPrivacyLearnMoreURL}"
    route-path$="[[routePath]]">
<settings-toggle-button
    id="topicsToggle"
    pref="{{prefs.privacy_sandbox.m1.topics_enabled}}"
    label="$i18n{topicsPageToggleLabel}"
    sub-label="[[adTopicsToggleSubLabel_]]"
    on-settings-boolean-control-change="onToggleChange_">
</settings-toggle-button>
<div id="disclaimer">
  $i18nRaw{topicsPageDisclaimerDesktop}
</div>
<template is="dom-if" if="[[!emptyState_]]" restamp>
  <template is="dom-if" if="[[!isTopicsPrefManaged_(
      prefs.privacy_sandbox.m1.topics_enabled.enforcement)]]" restamp>
    <div id="currentTopicsSection">
      <div id="currentTopicsSectionWrapper" class="hr">
        <h2 id="currentTopicsHeading">$i18n{topicsPageActiveTopicsHeading}</h2>
        <template is="dom-if" if="[[shouldShowAdTopicsContentParity_]]">
          <div id="currentTopicsDescriptionV2" class="cr-secondary-text">
            $i18n{adTopicsPageActiveTopicsDescription}
          </div>
        </template>
        <template is="dom-if" if="[[!shouldShowAdTopicsContentParity_]]">
          <div id="currentTopicsDescription" class="cr-secondary-text">
            $i18n{topicsPageActiveTopicsDescription}
          </div>
        </template>
        <template is="dom-if" if="[[isTopicsEnabledAndLoaded_(
            prefs.privacy_sandbox.m1.topics_enabled.value,
            isTopicsListLoaded_)]]" restamp>
          <div role="region" aria-label=
              "$i18n{topicsPageCurrentTopicsRegionA11yDescription}">
            <template is="dom-repeat" items="[[topicsList_]]">
              <privacy-sandbox-interest-item interest="[[item]]"
                  on-interest-changed="onInterestChanged_">
              </privacy-sandbox-interest-item>
            </template>
          </div>
          <div id="currentTopicsEmptyText"
              class="topics-empty-text"
              hidden="[[!isTopicsListEmpty_(topicsList_.length)]]">
            <span id="currentTopicsDescriptionEmptyTextHeading">
              $i18n{topicsPageCurrentTopicsDescriptionEmptyTextHeading}
            </span>
            <span id="currentTopicsDescriptionEmptyText"
                class="cr-secondary-text">
              $i18n{topicsPageCurrentTopicsDescriptionEmptyText}
            </span>
          </div>
        </template>
        <div id="currentTopicsDescriptionDisabled"
            class="no-topics cr-secondary-text"
            hidden="[[prefs.privacy_sandbox.m1.topics_enabled.value]]">
          $i18n{topicsPageCurrentTopicsDescriptionDisabled}
        </div>
      </div>
    </div>
  </template>
   <cr-expand-button id="blockedTopicsRow" class="cr-row"
      expanded="{{blockedTopicsExpanded_}}">
      $i18n{topicsPageBlockedTopicsHeading}
    <div id="blockedTopicsDescription">
      $i18n{topicsPageBlockedTopicsDescription}
    </div>
  </cr-expand-button>
  <cr-collapse opened="[[blockedTopicsExpanded_]]">
    <div id="blockedTopicsEmptyText"
        class="topics-empty-text"
        hidden="[[!isBlockedTopicsListEmpty_(blockedTopicsList_.length)]]">
      <span id="blockedTopicsDescriptionEmptyTextHeading">
          $i18n{topicsPageBlockedTopicsDescriptionEmptyTextHeading}
      </span>
      <span id="blockedTopicsDescriptionEmptyText"
          class="cr-secondary-text">
        $i18n{topicsPageBlockedTopicsDescriptionEmptyText}
      </span>
    </div>
    <div id="blockedTopicsList" role="region"
        aria-label="$i18n{topicsPageBlockedTopicsRegionA11yDescription}">
      <template is="dom-repeat" items="[[blockedTopicsList_]]">
        <privacy-sandbox-interest-item interest="[[item]]"
            on-interest-changed="onInterestChanged_">
        </privacy-sandbox-interest-item>
      </template>
    </div>
  </cr-collapse>
  <div id="manageTopicsSection" class="hr">
      <cr-link-row id="privacySandboxManageTopicsLinkRow"
          label="$i18n{manageTopicsHeading}"
          sub-label="$i18n{manageTopicsDescription}"
          on-click="onPrivacySandboxManageTopicsClick_">
      </cr-link-row>
  </div>
</template>
<div id="footerV2" class="cr-secondary-text hr footer">
  $i18nRaw{adTopicsPageFooterV2Desktop}
</div>
<template is="dom-if" if="[[shouldShowAdTopicsContentParity_]]">
  <div id="footerDisclaimerV2" class="cr-secondary-text footer">
    $i18nRaw{adTopicsPageDisclaimerV2Desktop}
  </div>
</template>
<template is="dom-if" if="[[!shouldShowAdTopicsContentParity_]]">
  <div id="footerDisclaimer" class="cr-secondary-text footer">
    $i18nRaw{adTopicsPageDisclaimer}
  </div>
</template>
<cr-toast id="unblockTopicToast" duration="10000">
  <div id="unblockTopicToastBody">$i18n{unblockTopicToastBody}</div>
  <cr-button id="closeToastButton" on-click="onHideToastClick_">
    $i18n{unblockTopicToastButtonText}
  </cr-button>
</cr-toast>
<template is="dom-if" if="[[shouldShowBlockTopicDialog_]]" restamp>
  <settings-simple-confirmation-dialog id="blockTopicDialog"
      title-text="[[blockTopicDialogTitle_]]"
      body-text="[[blockTopicDialogBody_]]"
      confirm-text="$i18n{topicsPageBlockTopic}"
      on-close="onBlockTopicDialogClose_">
  </settings-simple-confirmation-dialog>
</template>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsPrivacySandboxTopicsSubpageElementBase = SettingsViewMixin(RouteObserverMixin(I18nMixin(PrefsMixin(PolymerElement))));
class SettingsPrivacySandboxTopicsSubpageElement extends SettingsPrivacySandboxTopicsSubpageElementBase {
    static get is() {
        return 'settings-privacy-sandbox-topics-subpage';
    }
    static get template() {
        return getTemplate$1H();
    }
    static get properties() {
        return {
            topicsList_: {
                type: Array,
                value() {
                    return [];
                },
            },
            blockedTopicsList_: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * Used to determine that the Topics list was already fetched and to
             * display the current topics description only after the list is loaded,
             * to avoid displaying first the description for an empty list since the
             * array is empty at first when the page is loaded and switching to the
             * default description once the list is fetched.
             */
            isTopicsListLoaded_: {
                type: Boolean,
                value: false,
            },
            blockedTopicsExpanded_: {
                type: Boolean,
                value: false,
                observer: 'onBlockedTopicsExpanded_',
            },
            blockTopicDialogTitle_: {
                type: String,
                value: '',
            },
            blockTopicDialogBody_: {
                type: String,
                value: '',
            },
            shouldShowBlockTopicDialog_: {
                type: Boolean,
                value: false,
            },
            emptyState_: {
                type: Boolean,
                computed: 'computeEmptyState_(' +
                    'prefs.privacy_sandbox.m1.topics_enabled.value)',
            },
            /**
             * If true, the Ad Topics Content parity should be shown.
             */
            shouldShowAdTopicsContentParity_: {
                type: Boolean,
                value: false,
            },
            adTopicsToggleSubLabel_: {
                type: String,
                computed: 'computeAdTopicsToggleSubLabel_(shouldShowAdTopicsContentParity_)',
            },
        };
    }
    privacySandboxBrowserProxy_ = PrivacySandboxBrowserProxyImpl.getInstance();
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    currentChildTopics_;
    currentInterest_;
    ready() {
        super.ready();
        this.privacySandboxBrowserProxy_.getTopicsState().then(state => this.onTopicsStateChanged_(state));
        this.privacySandboxBrowserProxy_
            .shouldShowPrivacySandboxAdTopicsContentParity()
            .then(shouldShow => {
            this.shouldShowAdTopicsContentParity_ = shouldShow;
        });
    }
    // Goal is to not show anything but the toggle and disclaimer when the pref is
    // false.
    computeEmptyState_() {
        return !this.getPref('privacy_sandbox.m1.topics_enabled').value;
    }
    currentRouteChanged(newRoute, oldRoute) {
        super.currentRouteChanged(newRoute, oldRoute);
        if (newRoute === routes.PRIVACY_SANDBOX_TOPICS) {
            // Updating the TopicsState because it can be changed by being
            // blocked/unblocked in the Manage Topics Page. Need to keep the data
            // between the two pages up to date.
            this.privacySandboxBrowserProxy_.getTopicsState().then(state => this.onTopicsStateChanged_(state));
        }
    }
    isTopicsPrefManaged_() {
        const topicsEnabledPref = this.getPref('privacy_sandbox.m1.topics_enabled');
        if (topicsEnabledPref.enforcement ===
            chrome.settingsPrivate.Enforcement.ENFORCED) {
            assert(!topicsEnabledPref.value);
            return true;
        }
        return false;
    }
    onTopicsStateChanged_(state) {
        this.topicsList_ = state.topTopics.map(topic => {
            return { topic, removed: false };
        });
        this.blockedTopicsList_ = state.blockedTopics.map(topic => {
            return { topic, removed: true };
        });
        this.isTopicsListLoaded_ = true;
    }
    isTopicsEnabledAndLoaded_() {
        return this.getPref('privacy_sandbox.m1.topics_enabled').value &&
            this.isTopicsListLoaded_;
    }
    isTopicsListEmpty_() {
        return this.topicsList_.length === 0;
    }
    isBlockedTopicsListEmpty_() {
        return this.blockedTopicsList_.length === 0;
    }
    getBlockedTopicsDescriptionClass_() {
        const defaultClass = 'cr-row continuation cr-secondary-text';
        return this.blockedTopicsList_.length === 0 ?
            `${defaultClass} no-blocked-topics` :
            defaultClass;
    }
    onToggleChange_(e) {
        const target = e.target;
        this.metricsBrowserProxy_.recordAction(target.checked ? 'Settings.PrivacySandbox.Topics.Enabled' :
            'Settings.PrivacySandbox.Topics.Disabled');
        this.privacySandboxBrowserProxy_.topicsToggleChanged(target.checked);
        // Reset the list after the toggle changed. From disabled -> enabled, the
        // list should already be empty. From enabled -> disabled, the current list
        // is cleared.
        this.topicsList_ = [];
    }
    onBlockTopicDialogClose_() {
        const dialog = this.shadowRoot.querySelector('settings-simple-confirmation-dialog');
        assert(dialog);
        assert(this.currentInterest_);
        if (dialog.wasConfirmed()) {
            this.updateTopicsStateForSelectedTopic_(this.currentInterest_);
        }
        this.blockTopicDialogBody_ = '';
        this.blockTopicDialogTitle_ = '';
        this.currentChildTopics_ = [];
        this.shouldShowBlockTopicDialog_ = false;
        this.currentInterest_ = undefined;
    }
    updateTopicsStateForSelectedTopic_(currentSelectedInterest) {
        this.privacySandboxBrowserProxy_.setTopicAllowed(currentSelectedInterest.topic, 
        /*allowed=*/ currentSelectedInterest.removed);
        this.privacySandboxBrowserProxy_.getTopicsState().then(state => this.onTopicsStateChanged_(state));
        this.metricsBrowserProxy_.recordAction(currentSelectedInterest.removed ?
            'Settings.PrivacySandbox.Topics.TopicAdded' :
            'Settings.PrivacySandbox.Topics.TopicRemoved');
        // After allowing or blocking the last item, the focus is lost after the
        // item is removed. Set the focus to the #blockedTopicsRow element.
        afterNextRender(this, () => {
            if (!this.shadowRoot.activeElement) {
                this.shadowRoot.querySelector('#blockedTopicsRow')
                    ?.focus();
            }
        });
    }
    // This function is run anytime the interest item changes. Which means that it
    // runs when a user blocks/allows a topic.
    async onInterestChanged_(e) {
        this.currentInterest_ = e.detail;
        assert(!this.currentInterest_.site);
        assert(this.currentInterest_.topic);
        assert(this.currentInterest_.topic.displayString);
        // If topic is being unblocked, show toast and update topic state.
        if (this.currentInterest_.removed) {
            const toast = this.shadowRoot.querySelector('cr-toast');
            assert(toast);
            toast.show();
            this.updateTopicsStateForSelectedTopic_(this.currentInterest_);
            return;
        }
        this.currentChildTopics_ =
            await this.privacySandboxBrowserProxy_.getChildTopicsCurrentlyAssigned(this.currentInterest_.topic);
        // Check if currently selected topic to block has active child topics
        // if it does, show simple confirmation dialog.
        if (this.currentChildTopics_.length !== 0) {
            this.blockTopicDialogTitle_ = loadTimeData.getStringF('manageTopicsDialogTitle', this.currentInterest_.topic.displayString);
            this.blockTopicDialogBody_ = loadTimeData.getStringF('manageTopicsDialogBody', this.currentInterest_.topic.displayString);
            this.shouldShowBlockTopicDialog_ = true;
            return;
        }
        // Currently selected topic doesn't have active child topics.
        // Update topics state.
        this.updateTopicsStateForSelectedTopic_(this.currentInterest_);
        this.blockedTopicsExpanded_ = true;
    }
    onBlockedTopicsExpanded_() {
        if (this.blockedTopicsExpanded_) {
            this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.Topics.BlockedTopicsOpened');
        }
    }
    onPrivacySandboxManageTopicsClick_() {
        Router.getInstance().navigateTo(routes.PRIVACY_SANDBOX_MANAGE_TOPICS);
    }
    onHideToastClick_() {
        const toast = this.shadowRoot.querySelector('cr-toast');
        assert(toast);
        toast.hide();
    }
    onPrivacyPolicyLinkClicked_() {
        this.metricsBrowserProxy_.recordAction('Settings.PrivacySandbox.AdTopics.PrivacyPolicyLinkClicked');
    }
    computeAdTopicsToggleSubLabel_() {
        return this.i18n(this.shouldShowAdTopicsContentParity_ ? 'adTopicsPageToggleSubLabel' :
            'topicsPageToggleSubLabel');
    }
    // SettingsViewMixin implementation.
    getFocusConfig() {
        return new Map([
            [
                routes.PRIVACY_SANDBOX_MANAGE_TOPICS.path,
                '#privacySandboxManageTopicsLinkRow',
            ],
        ]);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsPrivacySandboxTopicsSubpageElement.is, SettingsPrivacySandboxTopicsSubpageElement);

function getTemplate$1G() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{flex-direction:column;display:flex;flex:1;padding:14px 16px}#header{font-weight:500;font-size:0.75rem;user-select:none}#subheader{font-size:0.6875rem;line-height:18px;user-select:none}cr-icon{height:var(--cr-icon-size);margin-bottom:10px;width:var(--cr-icon-size)}cr-icon.green{--iron-icon-fill-color:var(--google-green-700)}cr-icon.yellow{--iron-icon-fill-color:var(--google-yellow-700)}cr-icon.red{--iron-icon-fill-color:var(--google-red-600)}@media (prefers-color-scheme:dark){cr-icon.green{--iron-icon-fill-color:var(--google-green-300)}cr-icon.yellow{--iron-icon-fill-color:var(--google-yellow-300)}cr-icon.red{--iron-icon-fill-color:var(--google-red-300)}}</style>

<cr-icon id="icon" icon$="[[getStatusIcon(data.state)]]"
    class$="[[getColorClass(data.state)]]">
</cr-icon>
<div id="header">[[data.header]]</div>
<div id="subheader" class="cr-secondary-text">[[data.subheader]]</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-safety-hub-card' is used by the top cards in Safety Hub settings
 * page.
 */
class SettingsSafetyHubCardElement extends PolymerElement {
    static get is() {
        return 'settings-safety-hub-card';
    }
    static get template() {
        return getTemplate$1G();
    }
    static get properties() {
        return {
            // The object to hold Card Info.
            data: Object,
        };
    }
    // Returns the icon for the card state.
    getStatusIcon(state) {
        switch (state) {
            case CardState.WARNING:
            case CardState.WEAK:
                return 'cr:error';
            case CardState.INFO:
                return 'cr:info';
            case CardState.SAFE:
                return 'cr:check-circle';
            default:
                assertNotReached();
        }
    }
    // Returns the color class for the icon to paint it.
    getColorClass(state) {
        switch (state) {
            case CardState.WARNING:
                return 'red';
            case CardState.WEAK:
                return 'yellow';
            case CardState.INFO:
                return 'grey';
            case CardState.SAFE:
                return 'green';
            default:
                assertNotReached();
        }
    }
}
customElements.define(SettingsSafetyHubCardElement.is, SettingsSafetyHubCardElement);

function getTemplate$1F() {
    return html `<!--_html_template_start_--><style include="cr-shared-style">:host{display:flex;flex-direction:column}.box{background-color:var(--cr-card-background-color);border-radius:var(--cr-card-border-radius);box-shadow:var(--cr-card-shadow)}.card-container{align-items:stretch;display:flex;gap:16px;justify-content:space-between;width:100%}.card:hover{background-color:var(--cr-hover-background-color);cursor:pointer}.module{height:fit-content;margin-bottom:16px;padding:12px 20px}.section-header{color:var(--cr-primary-text-color);flex:1;font-size:108%;font-weight:400;letter-spacing:.25px;margin-bottom:16px;margin-top:30px;width:100%;user-select:none}.section-header.first{margin-top:0px}</style>

<settings-subpage class="multi-card" page-title="$i18n{safetyHub}"
    learn-more-url="$i18n{safetyHubHelpCenterURL}" route-path$="[[routePath]]">
<h2 class="section-header cr-secondary-text first">
  $i18n{safetyHubPageCardSectionHeader}
</h2>
<div class="card-container">
  <settings-safety-hub-card id="passwords" class="card box"
      data="[[passwordCardData_]]" on-click="onPasswordsClick_"
      tabindex="0" on-keydown="onPasswordsKeyPress_" role="link"
      aria-description="$i18n{safetyHubPasswordNavigationAriaLabel}">
  </settings-safety-hub-card>
  <settings-safety-hub-card id="version" class="card box"
      data="[[versionCardData_]]" on-click="onVersionClick_"
      tabindex="0" on-keydown="onVersionKeyPress_" role="[[versionCardRole_]]"
      aria-description="[[versionCardAriaDescription_]]">
  </settings-safety-hub-card>
  <settings-safety-hub-card id="safeBrowsing" class="card box"
      data="[[safeBrowsingCardData_]]" on-click="onSafeBrowsingClick_"
      tabindex="0" on-keydown="onSafeBrowsingKeyPress_" role="link"
      aria-description="$i18n{safetyHubSBNavigationAriaLabel}">
  </settings-safety-hub-card>
</div>
<h2 class="section-header cr-secondary-text">
  $i18n{safetyHubPageModuleSectionHeader}
</h2>
<template is="dom-if" if="[[showNotificationPermissions_]]">
  <settings-safety-hub-notification-permissions-module class="module box">
  </settings-safety-hub-notification-permissions-module>
</template>
<template is="dom-if" if="[[showUnusedSitePermissions_]]">
  <settings-safety-hub-unused-site-permissions class="module box">
  </settings-safety-hub-unused-site-permissions>
</template>
<template is="dom-if" if="[[showExtensions_]]">
  <settings-safety-hub-extensions-module class="module box">
  </settings-safety-hub-extensions-module>
</template>
<template is="dom-if" if="[[showNoRecommendationsState_]]">
  <settings-safety-hub-module id="emptyStateModule" class="module box"
      header="$i18n{safetyHubEmptyStateModuleHeader}"
      subheader="$i18n{safetyHubEmptyStateModuleSubheader}"
      header-icon="cr:check">
  </settings-safety-hub-module>
  <settings-safety-hub-module
      id="userEducationModule"
      on-sh-module-item-link-click="onEducationLinkClick_"
      class="module box"
      header="$i18n{safetyHubUserEduModuleHeader}"
      header-icon="settings20:lightbulb"
      sites="[[userEducationItemList_]]">
  </settings-safety-hub-module>
</template>

  <template is="dom-if" if="[[shouldShowRelaunchDialog]]" restamp>
    <relaunch-confirmation-dialog restart-type="[[restartTypeEnum.RELAUNCH]]"
        on-close="onRelaunchDialogClose" is-version-update>
    </relaunch-confirmation-dialog>
  </template>

</settings-supage>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-safety-hub-page' is the settings page that presents the safety
 * state of Chrome.
 */
const SettingsSafetyHubPageElementBase = RouteObserverMixin(SettingsViewMixin(RelaunchMixin(PrefsMixin(WebUiListenerMixin(I18nMixin(PolymerElement))))));
class SettingsSafetyHubPageElement extends SettingsSafetyHubPageElementBase {
    static get is() {
        return 'settings-safety-hub-page';
    }
    static get template() {
        return getTemplate$1F();
    }
    static get properties() {
        return {
            // The object that holds data of Password Check card.
            passwordCardData_: Object,
            // The object that holds data of Version Check card.
            versionCardData_: Object,
            // The object that holds data of Safe Browsing card.
            safeBrowsingCardData_: Object,
            // Whether Notification Permissions module should be visible.
            showNotificationPermissions_: {
                type: Boolean,
                value: false,
            },
            // Whether Unused Site Permissions module should be visible.
            showUnusedSitePermissions_: {
                type: Boolean,
                value: false,
            },
            // Whether Extensions module should be visible.
            showExtensions_: {
                type: Boolean,
                value: false,
            },
            showNoRecommendationsState_: {
                type: Boolean,
                computed: 'computeShowNoRecommendationsState_(showUnusedSitePermissions_.*, showExtensions_.*, showNotificationPermissions_.*)',
            },
            userEducationItemList_: Array,
            // Whether the data for notification permissions is ready.
            hasDataForNotificationPermissions_: Boolean,
            // Whether the data for unused site permissions is ready.
            hasDataForUnusedPermissions_: Boolean,
            // Whether the data for extensions is ready.
            hasDataForExtensions_: Boolean,
            // String that identifies version card's role announced by accessibility
            // voiceover.
            versionCardRole_: {
                type: String,
                computed: 'computeVersionCardRole_(versionCardData_)',
            },
            // String that identifies version card's description announced by
            // accessibility voiceover.
            versionCardAriaDescription_: {
                type: String,
                computed: 'computeVersionCardAriaDescription_(versionCardData_)',
            },
        };
    }
    static get observers() {
        return [
            'onAllModulesLoaded_(passwordCardData_, versionCardData_, safeBrowsingCardData_, hasDataForUnusedPermissions_, hasDataForNotificationPermissions_, hasDataForExtensions_)',
            'onSafeBrowsingPrefChanged_(prefs.generated.safe_browsing)',
        ];
    }
    shouldRecordMetric_ = false;
    browserProxy_ = SafetyHubBrowserProxyImpl.getInstance();
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    connectedCallback() {
        this.initializeCards_();
        this.initializeModules_();
        this.initializeUserEducation_();
        super.connectedCallback();
    }
    currentRouteChanged(newRoute, oldRoute) {
        super.currentRouteChanged(newRoute, oldRoute);
        if (Router.getInstance().getCurrentRoute() !== routes.SAFETY_HUB) {
            return;
        }
        // When the user navigates to the Safety Hub page, any active menu
        // notification is dismissed.
        this.browserProxy_.dismissActiveMenuNotification();
        // Record a visit to Safety Hub page if the user is still on the SH page
        // after 20 seconds.
        setTimeout(() => {
            if (Router.getInstance().getCurrentRoute() === routes.SAFETY_HUB) {
                this.browserProxy_.recordSafetyHubPageVisit();
            }
        }, 20000);
        this.metricsBrowserProxy_.recordSafetyHubImpression(SafetyHubSurfaces.SAFETY_HUB_PAGE);
        this.metricsBrowserProxy_.recordSafetyHubInteraction(SafetyHubSurfaces.SAFETY_HUB_PAGE);
        // Only record the metrics when the user navigates to the Safety Hub page.
        this.shouldRecordMetric_ = true;
        this.onAllModulesLoaded_();
    }
    initializeCards_() {
        // TODO(crbug.com/40267370): Add listeners for Password and Version cards.
        this.browserProxy_.getPasswordCardData().then((data) => {
            this.passwordCardData_ = data;
        });
        this.browserProxy_.getSafeBrowsingCardData().then((data) => {
            this.safeBrowsingCardData_ = data;
        });
        this.browserProxy_.getVersionCardData().then((data) => {
            this.versionCardData_ = data;
        });
    }
    initializeModules_() {
        this.addWebUiListener(SafetyHubEvent.NOTIFICATION_PERMISSIONS_MAYBE_CHANGED, (sites) => this.onNotificationPermissionListChanged_(sites));
        this.addWebUiListener(SafetyHubEvent.UNUSED_PERMISSIONS_MAYBE_CHANGED, (sites) => this.onUnusedSitePermissionListChanged_(sites));
        this.addWebUiListener(SafetyHubEvent.EXTENSIONS_CHANGED, (num) => this.onExtensionsChanged_(num));
        this.browserProxy_.getNotificationPermissionReview().then((sites) => this.onNotificationPermissionListChanged_(sites));
        this.browserProxy_.getRevokedUnusedSitePermissionsList().then((sites) => this.onUnusedSitePermissionListChanged_(sites));
        this.browserProxy_.getNumberOfExtensionsThatNeedReview().then((num) => this.onExtensionsChanged_(num));
    }
    initializeUserEducation_() {
        this.userEducationItemList_ = [
            {
                origin: this.i18n('safetyHubUserEduDataHeader'),
                detail: this.i18nAdvanced('safetyHubUserEduDataSubheader'),
                icon: 'settings20:chrome-filled',
            },
            {
                origin: this.i18n('safetyHubUserEduIncognitoHeader'),
                detail: this.i18nAdvanced('safetyHubUserEduIncognitoSubheader'),
                icon: 'settings20:incognito-unfilled',
            },
            {
                origin: this.i18n('safetyHubUserEduSafeBrowsingHeader'),
                detail: this.i18nAdvanced('safetyHubUserEduSafeBrowsingSubheader'),
                icon: 'cr:security',
            },
        ];
    }
    onPasswordsClick_() {
        this.metricsBrowserProxy_.recordSafetyHubCardStateClicked('Settings.SafetyHub.PasswordsCard.StatusOnClick', this.passwordCardData_.state);
        this.browserProxy_.recordSafetyHubInteraction();
        PasswordManagerImpl.getInstance().showPasswordManager(PasswordManagerPage.CHECKUP);
    }
    onPasswordsKeyPress_(e) {
        e.stopPropagation();
        if (this.isEnterOrSpaceClicked_(e)) {
            this.onPasswordsClick_();
        }
    }
    onVersionClick_() {
        this.metricsBrowserProxy_.recordSafetyHubCardStateClicked('Settings.SafetyHub.VersionCard.StatusOnClick', this.versionCardData_.state);
        this.browserProxy_.recordSafetyHubInteraction();
        if (this.versionCardData_.state === CardState.WARNING) {
            // Optional parameter alwaysShowDialog is set to true to always show the
            // confirmation dialog regardless of the incognito windows open.
            this.performRestart(RestartType.RELAUNCH, true);
        }
        else {
            Router.getInstance().navigateTo(routes.ABOUT, /* dynamicParams= */ undefined, 
            /* removeSearch= */ true);
        }
    }
    onEducationLinkClick_(event) {
        this.browserProxy_.recordSafetyHubInteraction();
        const headerString = event.detail.querySelector('.site-representation').textContent;
        switch (headerString) {
            case this.i18n('safetyHubUserEduDataHeader'):
                this.metricsBrowserProxy_.recordAction('Settings.SafetyHub.SafetyToolsLinkClicked');
                break;
            case this.i18n('safetyHubUserEduIncognitoHeader'):
                this.metricsBrowserProxy_.recordAction('Settings.SafetyHub.IncognitoLinkClicked');
                break;
            case this.i18n('safetyHubUserEduSafeBrowsingHeader'):
                this.metricsBrowserProxy_.recordAction('Settings.SafetyHub.SafeBrowsingLinkClicked');
                break;
            default:
                assertNotReached();
        }
    }
    onVersionKeyPress_(e) {
        e.stopPropagation();
        if (this.isEnterOrSpaceClicked_(e)) {
            this.onVersionClick_();
        }
    }
    onSafeBrowsingPrefChanged_() {
        this.browserProxy_.getSafeBrowsingCardData().then((data) => {
            this.safeBrowsingCardData_ = data;
        });
    }
    onSafeBrowsingClick_() {
        this.metricsBrowserProxy_.recordSafetyHubCardStateClicked('Settings.SafetyHub.SafeBrowsingCard.StatusOnClick', this.safeBrowsingCardData_.state);
        this.browserProxy_.recordSafetyHubInteraction();
        Router.getInstance().navigateTo(routes.SECURITY, /* dynamicParams= */ undefined, 
        /* removeSearch= */ true);
    }
    onSafeBrowsingKeyPress_(e) {
        e.stopPropagation();
        if (this.isEnterOrSpaceClicked_(e)) {
            this.onSafeBrowsingClick_();
        }
    }
    onNotificationPermissionListChanged_(permissions) {
        // The module should be visible if there is any item on the list, or if
        // there is no item on the list but the list was shown before.
        this.showNotificationPermissions_ =
            permissions.length > 0 || this.showNotificationPermissions_;
        this.hasDataForNotificationPermissions_ = true;
    }
    onUnusedSitePermissionListChanged_(permissions) {
        // The module should be visible if there is any item on the list, or if
        // there is no item on the list but the list was shown before.
        this.showUnusedSitePermissions_ =
            permissions.length > 0 || this.showUnusedSitePermissions_;
        this.hasDataForUnusedPermissions_ = true;
    }
    computeShowNoRecommendationsState_() {
        return !(this.showUnusedSitePermissions_ || this.showNotificationPermissions_ ||
            this.showExtensions_);
    }
    onExtensionsChanged_(numberOfExtensions) {
        this.showExtensions_ = !!numberOfExtensions;
        this.hasDataForExtensions_ = true;
    }
    computeVersionCardRole_() {
        return this.versionCardData_.state === CardState.WARNING ? 'button' : 'link';
    }
    computeVersionCardAriaDescription_() {
        return this.versionCardData_.state === CardState.WARNING ?
            this.i18n('safetyHubVersionRelaunchAriaLabel') :
            this.i18n('safetyHubVersionNavigationAriaLabel');
    }
    isEnterOrSpaceClicked_(e) {
        return e.key === 'Enter' || e.key === ' ';
    }
    onAllModulesLoaded_() {
        // If the metrics are recorded already, don't record again.
        if (!this.shouldRecordMetric_) {
            return;
        }
        // Wait till the data of the cards be ready.
        if (!this.passwordCardData_ || !this.safeBrowsingCardData_ ||
            !this.versionCardData_) {
            return;
        }
        // Wait till the data of the modules be ready.
        if (!this.hasDataForUnusedPermissions_ ||
            !this.hasDataForNotificationPermissions_ ||
            !this.hasDataForExtensions_) {
            return;
        }
        this.shouldRecordMetric_ = false;
        let hasAnyWarning = false;
        // TODO(crbug.com/40267370): Iterate over the cards/modules with for loop.
        if (this.passwordCardData_.state !== CardState.SAFE) {
            this.metricsBrowserProxy_.recordSafetyHubModuleWarningImpression(SafetyHubModuleType.PASSWORDS);
            hasAnyWarning = true;
        }
        if (this.safeBrowsingCardData_.state !== CardState.SAFE) {
            this.metricsBrowserProxy_.recordSafetyHubModuleWarningImpression(SafetyHubModuleType.SAFE_BROWSING);
            hasAnyWarning = true;
        }
        if (this.versionCardData_.state !== CardState.SAFE) {
            this.metricsBrowserProxy_.recordSafetyHubModuleWarningImpression(SafetyHubModuleType.VERSION);
            hasAnyWarning = true;
        }
        if (this.showNotificationPermissions_) {
            this.metricsBrowserProxy_.recordSafetyHubModuleWarningImpression(SafetyHubModuleType.NOTIFICATIONS);
            hasAnyWarning = true;
        }
        if (this.showUnusedSitePermissions_) {
            this.metricsBrowserProxy_.recordSafetyHubModuleWarningImpression(SafetyHubModuleType.PERMISSIONS);
            hasAnyWarning = true;
        }
        if (this.showExtensions_) {
            this.metricsBrowserProxy_.recordSafetyHubModuleWarningImpression(SafetyHubModuleType.EXTENSIONS);
            hasAnyWarning = true;
        }
        this.metricsBrowserProxy_.recordSafetyHubDashboardAnyWarning(hasAnyWarning);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsSafetyHubPageElement.is, SettingsSafetyHubPageElement);

function getTemplate$1E() {
    return html `<!--_html_template_start_-->    <style include="settings-shared">#policySubtitleContainer{gap:10px;display:flex;margin-bottom:16px}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div slot="title">[[dialogTitle_]]</div>
      <div slot="body" spellcheck="false">
        <template is="dom-if" if="[[showPolicySubtitle_]]">
          <div id="policySubtitleContainer">
            <cr-icon icon="cr:domain"></cr-icon>
            <span class="secondary">
              $i18n{searchEnginesDeleteConfirmationSubtitleForPolicy}
            </span>
          </div>
        </template>
        <cr-input id="searchEngine"
            label="$i18n{searchEnginesName}"
            readonly="[[readonly_]]"
            error-message="$i18n{notValid}"
            value="{{searchEngine_}}" on-input="validate_"
            autofocus>
        </cr-input>
        <cr-input id="keyword"
            label="$i18n{searchEnginesShortcut}"
            readonly="[[readonly_]]"
            error-message="$i18n{notValid}"
            value="{{keyword_}}" on-focus="validate_" on-input="validate_">
        </cr-input>
        <cr-input id="queryUrl"
            label="$i18n{searchEnginesQueryURLExplanation}"
            readonly="[[urlIsReadonly_]]"
            error-message="$i18n{notValid}"
            value="{{queryUrl_}}" on-focus="validate_" on-input="validate_">
        </cr-input>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="cancel_" id="cancel"
            hidden="[[readonly_]]">
          $i18n{cancel}</cr-button>
        <cr-button id="actionButton" class="action-button"
            on-click="onActionButtonClick_">
          [[actionButtonText_]]
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-search-engine-edit-dialog' is a component for adding
 * or editing a search engine entry.
 */
/**
 * The |modelIndex| to use when a new search engine is added. Must match
 * with kNewSearchEngineIndex constant specified at
 * chrome/browser/ui/webui/settings/search_engines_handler.cc
 */
const DEFAULT_MODEL_INDEX = -1;
const SettingsSearchEngineEditDialogElementBase = WebUiListenerMixin(PolymerElement);
class SettingsSearchEngineEditDialogElement extends SettingsSearchEngineEditDialogElementBase {
    static get is() {
        return 'settings-search-engine-edit-dialog';
    }
    static get template() {
        return getTemplate$1E();
    }
    static get properties() {
        return {
            /**
             * The search engine to be edited. If not populated a new search engine
             * should be added.
             */
            model: Object,
            searchEngine_: String,
            keyword_: String,
            queryUrl_: String,
            dialogTitle_: String,
            actionButtonText_: String,
            showPolicySubtitle_: Boolean,
            readonly_: Boolean,
            urlIsReadonly_: {
                type: Boolean,
                computed: 'computeUrlIsReadonly_(model, readonly_)',
            },
        };
    }
    browserProxy_ = SearchEnginesBrowserProxyImpl.getInstance();
    ready() {
        super.ready();
        if (this.model) {
            this.readonly_ = this.model.isManaged && !this.model.canBeEdited;
            if (this.model.isPrepopulated || this.model.default) {
                this.dialogTitle_ = loadTimeData.getString(this.readonly_ ? 'searchEnginesViewSearchEngine' :
                    'searchEnginesEditSearchEngine');
            }
            else {
                this.dialogTitle_ = loadTimeData.getString(this.readonly_ ? 'searchEnginesViewSiteSearch' :
                    'searchEnginesEditSiteSearch');
            }
            this.actionButtonText_ =
                loadTimeData.getString(this.readonly_ ? 'done' : 'save');
            this.showPolicySubtitle_ = this.model.isManaged;
            // If editing an existing search engine, pre-populate the input fields.
            this.searchEngine_ = this.model.name;
            this.keyword_ = this.model.keyword;
            this.queryUrl_ = this.model.url;
        }
        else {
            this.dialogTitle_ = loadTimeData.getString('searchEnginesAddSiteSearch');
            this.actionButtonText_ = loadTimeData.getString('add');
            this.readonly_ = false;
            this.showPolicySubtitle_ = false;
        }
        this.addEventListener('cancel', () => {
            this.browserProxy_.searchEngineEditCancelled();
        });
        this.addWebUiListener('search-engines-changed', this.enginesChanged_.bind(this));
    }
    connectedCallback() {
        super.connectedCallback();
        microTask.run(() => this.updateActionButtonState_());
        this.browserProxy_.searchEngineEditStarted(this.model ? this.model.modelIndex : DEFAULT_MODEL_INDEX);
        this.$.dialog.showModal();
    }
    enginesChanged_(searchEnginesInfo) {
        if (this.model) {
            const engineWasRemoved = ['defaults', 'actives', 'others', 'extensions'].every(engineType => searchEnginesInfo[engineType].every(e => e.id !== this.model.id));
            if (engineWasRemoved) {
                this.cancel_();
                return;
            }
        }
        [this.$.searchEngine, this.$.keyword, this.$.queryUrl].forEach(element => this.validateElement_(element));
    }
    cancel_() {
        this.$.dialog.cancel();
    }
    onActionButtonClick_() {
        this.browserProxy_.searchEngineEditCompleted(this.searchEngine_, this.keyword_, this.queryUrl_);
        this.$.dialog.close();
    }
    validateElement_(inputElement) {
        // No need to validate fields if the search engine is read-only, i.e.
        // created by policy. Those have been validated when the policy was
        // processed (b/348165485).
        if (this.readonly_) {
            return;
        }
        // If element is empty, disable the action button, but don't show the red
        // invalid message.
        if (inputElement.value === '') {
            inputElement.invalid = false;
            this.updateActionButtonState_();
            return;
        }
        this.browserProxy_
            .validateSearchEngineInput(inputElement.id, inputElement.value)
            .then(isValid => {
            inputElement.invalid = !isValid;
            this.updateActionButtonState_();
        });
    }
    validate_(event) {
        const inputElement = event.target;
        this.validateElement_(inputElement);
    }
    updateActionButtonState_() {
        const allValid = [
            this.$.searchEngine,
            this.$.keyword,
            this.$.queryUrl,
        ].every(function (inputElement) {
            return !inputElement.invalid && inputElement.value.length > 0;
        });
        this.$.actionButton.disabled = !allValid;
    }
    computeUrlIsReadonly_() {
        return this.readonly_ || (!!this.model && this.model.urlLocked);
    }
}
customElements.define(SettingsSearchEngineEditDialogElement.is, SettingsSearchEngineEditDialogElement);

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview <cr-auto-img> is a specialized <img> that facilitates embedding
 * images into WebUIs via its auto-src attribute. <cr-auto-img> automatically
 * determines if the image is local (e.g. data: or chrome://) or external (e.g.
 * https://), and embeds the image directly or via the chrome://image data
 * source accordingly. Usage:
 *
 *   1. In C++ register |SanitizedImageSource| for your WebUI.
 *
 *   2. In HTML instantiate
 *
 *      <img is="cr-auto-img" auto-src="https://foo.com/bar.png">
 *
 *      If your image URL points to Google Photos storage, meaning it needs an
 *      auth token, you can use the is-google-photos attribute as follows:
 *
 *      <img is="cr-auto-img" auto-src="https://foo.com/bar.png"
 *          is-google-photos>
 *
 *      If you want the image to reset to an empty state when auto-src changes
 *      and the new image is still loading, set the clear-src attribute:
 *
 *      <img is="cr-auto-img" auto-src="[[calculateSrc()]]" clear-src>
 *
 *      If you want your image to be always encoded as a static image (even if
 *      the source image is animated), set the static-encode attribute:
 *
 *      <img is="cr-auto-img" auto-src="https://foo.com/bar.png"
 *          static-encode>
 *
 *      Static images are encoded as PNG by default. If you want your image to
 *      be encoded as a Webp image, set the encode-type attribute to "webp".
 *
 *      <img is="cr-auto-img" auto-src="https://foo.com/bar.png"
 *          static-encode encode-type="webp">
 *
 * NOTE: Since <cr-auto-img> may use the chrome://image data source some images
 * may be transcoded to PNG.
 */
const AUTO_SRC = 'auto-src';
const CLEAR_SRC = 'clear-src';
const IS_GOOGLE_PHOTOS = 'is-google-photos';
const STATIC_ENCODE = 'static-encode';
const ENCODE_TYPE = 'encode-type';
class CrAutoImgElement extends HTMLImageElement {
    static get observedAttributes() {
        return [AUTO_SRC, IS_GOOGLE_PHOTOS, STATIC_ENCODE, ENCODE_TYPE];
    }
    attributeChangedCallback(name, oldValue, newValue) {
        if (name !== AUTO_SRC && name !== IS_GOOGLE_PHOTOS &&
            name !== STATIC_ENCODE && name !== ENCODE_TYPE) {
            return;
        }
        // Changes to |IS_GOOGLE_PHOTOS| are only interesting when the attribute is
        // being added or removed.
        if (name === IS_GOOGLE_PHOTOS &&
            ((oldValue === null) === (newValue === null))) {
            return;
        }
        if (this.hasAttribute(CLEAR_SRC)) {
            // Remove the src attribute so that the old image is not shown while the
            // new one is loading.
            this.removeAttribute('src');
        }
        let url = null;
        try {
            url = new URL(this.getAttribute(AUTO_SRC) || '');
        }
        catch (_) {
        }
        if (!url || url.protocol === 'chrome-untrusted:') {
            // Loading chrome-untrusted:// directly kills the renderer process.
            // Loading chrome-untrusted:// via the chrome://image data source
            // results in a broken image.
            this.removeAttribute('src');
            return;
        }
        if (url.protocol === 'data:' || url.protocol === 'chrome:') {
            this.src = url.href;
            return;
        }
        if (!this.hasAttribute(IS_GOOGLE_PHOTOS) &&
            !this.hasAttribute(STATIC_ENCODE) && !this.hasAttribute(ENCODE_TYPE)) {
            this.src = 'chrome://image?' + url.href;
            return;
        }
        this.src = `chrome://image?url=${encodeURIComponent(url.href)}`;
        if (this.hasAttribute(IS_GOOGLE_PHOTOS)) {
            this.src += `&isGooglePhotos=true`;
        }
        if (this.hasAttribute(STATIC_ENCODE)) {
            this.src += `&staticEncode=true`;
        }
        if (this.hasAttribute(ENCODE_TYPE)) {
            this.src += `&encodeType=${this.getAttribute(ENCODE_TYPE)}`;
        }
    }
    set autoSrc(src) {
        this.setAttribute(AUTO_SRC, src);
    }
    get autoSrc() {
        return this.getAttribute(AUTO_SRC) || '';
    }
    set clearSrc(_) {
        this.setAttribute(CLEAR_SRC, '');
    }
    get clearSrc() {
        return this.getAttribute(CLEAR_SRC) || '';
    }
    set isGooglePhotos(enabled) {
        if (enabled) {
            this.setAttribute(IS_GOOGLE_PHOTOS, '');
        }
        else {
            this.removeAttribute(IS_GOOGLE_PHOTOS);
        }
    }
    get isGooglePhotos() {
        return this.hasAttribute(IS_GOOGLE_PHOTOS);
    }
    set staticEncode(enabled) {
        if (enabled) {
            this.setAttribute(STATIC_ENCODE, '');
        }
        else {
            this.removeAttribute(STATIC_ENCODE);
        }
    }
    get staticEncode() {
        return this.hasAttribute(STATIC_ENCODE);
    }
    set encodeType(type) {
        if (type) {
            this.setAttribute(ENCODE_TYPE, type);
        }
        else {
            this.removeAttribute(ENCODE_TYPE);
        }
    }
    get encodeType() {
        return this.getAttribute(ENCODE_TYPE) || '';
    }
}
customElements.define('cr-auto-img', CrAutoImgElement, { extends: 'img' });

const styleMod$2 = document.createElement('dom-module');
styleMod$2.appendChild(html `
  <template>
    <style>
site-favicon{margin-inline-end:8px;min-width:16px}
    </style>
  </template>
`.content);
styleMod$2.register('search-engine-entry');

function getTemplate$1D() {
    return html `<!--_html_template_start_-->    <style include="settings-shared search-engine-entry">:host([is-default]) .list-item{font-weight:500}.additional-info-column-group{align-items:center;display:flex;flex:6}#controls-column-group{flex:auto;margin-left:auto;display:flex;justify-content:end;align-items:center}cr-policy-indicator{display:inline-flex;justify-content:center;margin-inline-start:16px;vertical-align:middle;width:36px}#downloadedIcon{display:block;height:var(--site-favicon-height,16px);margin-inline-end:8px;min-width:16px;width:var(--site-favicon-width,16px)}#name-column{align-items:center;display:flex;flex:3;word-break:break-word}#shortcut-column{word-break:break-word}#shortcut-column,#url-column{flex:auto;margin-inline-end:10px;max-width:200px}
    </style>

    <div class="list-item cr-row" role="row">
      <span role="cell" id="name-column">
        <site-favicon favicon-url="[[engine.iconURL]]" url="[[engine.url]]"
            icon-path="[[engine.iconPath]]"
            hidden="[[shouldShowDownloadedIcon_(showDownloadedIcon_, engine)]]">
        </site-favicon>
        <img id="downloadedIcon" is="cr-auto-img"
            auto-src="[[engine.iconURL]]" clear-src
            on-load="onDownloadedIconLoadSuccess_"
            on-error="onDownloadedIconLoadError_"
            hidden="[[!shouldShowDownloadedIcon_(showDownloadedIcon_, engine)]]">
        <div>[[engine.displayName]]</div>
      </span>
      <span class="additional-info-column-group">
        <span role="cell" id="shortcut-column" hidden="[[!showShortcut]]">
          <div>[[engine.keyword]]</div>
        </span>
        <span role="cell" id="url-column" hidden="[[!showQueryUrl]]">
          <div class="text-elide">[[engine.url]]</div>
        </span>
        <span role="cell" id="controls-column-group">
          <cr-button class="secondary-button" on-click="onActivateClick_"
              aria-label="[[getActivateButtonAriaLabel_(engine)]]"
              hidden="[[!engine.canBeActivated]]" id="activate">
            $i18n{searchEnginesActivate}
          </cr-button>
          <cr-button class="secondary-button" on-click="onViewOrEditClick_"
              hidden="[[!showSecondaryButton_]]" id="viewDetailsButton">
            $i18n{searchEnginesViewDetails}
          </cr-button>
          <cr-icon-button class="icon-edit" on-click="onViewOrEditClick_"
              title="$i18n{edit}" hidden="[[!showEditIcon_]]"
              aria-label="[[getEditButtonAriaLabel_(engine)]]"
              disabled$="[[!engine.canBeEdited]]" id="editIconButton">
          </cr-icon-button>
          <template is="dom-if" if="[[engine.isManaged]]">
            <cr-policy-indicator indicator-type="userPolicy">
            </cr-policy-indicator>
          </template>
          <cr-icon-button class="icon-more-vert" on-click="onDotsClick_"
              disabled$="[[disableDots_]]" title="$i18n{moreActions}"
              aria-label="[[getMoreActionsAriaLabel_(engine)]]">
          </cr-icon-button>
          <cr-action-menu role-description="$i18n{menu}">
            <button class="dropdown-item" on-click="onMakeDefaultClick_"
                disabled$="[[!engine.canBeDefault]]" id="makeDefault">
              $i18n{searchEnginesMakeDefault}
            </button>
            <button class="dropdown-item" on-click="onDeactivateClick_"
                hidden="[[!engine.canBeDeactivated]]" id="deactivate">
              $i18n{searchEnginesDeactivate}
            </button>
            <button class="dropdown-item" on-click="onDeleteClick_"
                hidden="[[!engine.canBeRemoved]]" id="delete">
              $i18n{delete}
            </button>
          </cr-action-menu>
        </span>
      </span>
    </div>
    <template is="dom-if" if="[[engine.extension]]">
      <extension-controlled-indicator
          extension-id="[[engine.extension.id]]"
          extension-name="[[engine.extension.name]]"
          extension-can-be-disabled="[[engine.extension.canBeDisabled]]">
      </extension-controlled-indicator>
    </template>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-search-engine-entry' is a component for showing a
 * search engine with its name, domain and query URL.
 */
const SettingsSearchEngineEntryElementBase = I18nMixin(PolymerElement);
class SettingsSearchEngineEntryElement extends SettingsSearchEngineEntryElementBase {
    static get is() {
        return 'settings-search-engine-entry';
    }
    static get template() {
        return getTemplate$1D();
    }
    static get properties() {
        return {
            engine: {
                type: Object,
                observer: 'onEngineChanged_',
            },
            showShortcut: { type: Boolean, value: false, reflectToAttribute: true },
            showQueryUrl: { type: Boolean, value: false, reflectToAttribute: true },
            isDefault: {
                reflectToAttribute: true,
                type: Boolean,
                computed: 'computeIsDefault_(engine)',
            },
            showEditIcon_: {
                type: Boolean,
                computed: 'computeShowEditIcon_(engine)',
            },
            showDownloadedIcon_: {
                type: Boolean,
                value: false,
            },
            showSecondaryButton_: {
                type: Boolean,
                computed: 'computeShowSecondaryButton_(engine)',
            },
            disableDots_: {
                type: Boolean,
                computed: 'computeDisableDots_(engine)',
            },
        };
    }
    browserProxy_ = SearchEnginesBrowserProxyImpl.getInstance();
    timeoutId_ = null;
    onEngineChanged_(newEngine, oldEngine) {
        if (oldEngine && newEngine.iconURL === oldEngine.iconURL) {
            return;
        }
        this.showDownloadedIcon_ = false;
        if (this.timeoutId_) {
            clearTimeout(this.timeoutId_);
            this.timeoutId_ = null;
        }
        this.timeoutId_ = setTimeout(() => {
            if (!this.$.downloadedIcon.complete) {
                // Reset src to cancel ongoing request.
                this.$.downloadedIcon.src = '';
                this.showDownloadedIcon_ = false;
            }
            this.timeoutId_ = null;
        }, 1000);
    }
    closePopupMenu_() {
        this.shadowRoot.querySelector('cr-action-menu').close();
    }
    computeIsDefault_() {
        return this.engine.default;
    }
    computeShowEditIcon_() {
        return !this.engine.isStarterPack && !this.engine.canBeActivated &&
            !(this.engine.isManaged && !this.engine.canBeEdited);
    }
    computeShowSecondaryButton_() {
        return !this.engine.canBeActivated &&
            (this.engine.isManaged && !this.engine.canBeEdited);
    }
    computeDisableDots_() {
        return this.engine.default ||
            (this.engine.isManaged && !this.engine.canBeActivated &&
                !this.engine.canBeDeactivated && !this.engine.canBeRemoved);
    }
    onDeleteClick_(e) {
        e.preventDefault();
        this.closePopupMenu_();
        if (!this.engine.shouldConfirmDeletion) {
            this.browserProxy_.removeSearchEngine(this.engine.modelIndex);
            return;
        }
        const dots = this.shadowRoot.querySelector('cr-icon-button.icon-more-vert');
        assert(dots);
        this.dispatchEvent(new CustomEvent('delete-search-engine', {
            bubbles: true,
            composed: true,
            detail: {
                engine: this.engine,
                anchorElement: dots,
            },
        }));
    }
    onDotsClick_() {
        const dots = this.shadowRoot.querySelector('cr-icon-button.icon-more-vert');
        assert(dots);
        this.shadowRoot.querySelector('cr-action-menu').showAt(dots, {
            anchorAlignmentY: AnchorAlignment.AFTER_END,
        });
    }
    onViewOrEditClick_(e) {
        e.preventDefault();
        this.closePopupMenu_();
        const anchor = this.shadowRoot.querySelector('cr-icon-button');
        assert(anchor);
        this.dispatchEvent(new CustomEvent('view-or-edit-search-engine', {
            bubbles: true,
            composed: true,
            detail: {
                engine: this.engine,
                anchorElement: anchor,
            },
        }));
    }
    onMakeDefaultClick_() {
        this.closePopupMenu_();
        this.browserProxy_.setDefaultSearchEngine(this.engine.modelIndex, ChoiceMadeLocation.SEARCH_ENGINE_SETTINGS, 
        /*saveGuestChoice=*/ null);
    }
    onActivateClick_() {
        this.closePopupMenu_();
        this.browserProxy_.setIsActiveSearchEngine(this.engine.modelIndex, /*is_active=*/ true);
    }
    onDeactivateClick_() {
        this.closePopupMenu_();
        this.browserProxy_.setIsActiveSearchEngine(this.engine.modelIndex, /*is_active=*/ false);
    }
    onDownloadedIconLoadError_() {
        this.showDownloadedIcon_ = false;
    }
    onDownloadedIconLoadSuccess_() {
        this.showDownloadedIcon_ = true;
        if (this.timeoutId_) {
            clearTimeout(this.timeoutId_);
        }
        this.timeoutId_ = null;
    }
    shouldShowDownloadedIcon_() {
        return this.showDownloadedIcon_ && !this.engine.iconPath &&
            !!this.engine.iconURL;
    }
    getMoreActionsAriaLabel_() {
        return this.i18n('searchEnginesMoreActionsAriaLabel', this.engine.displayName);
    }
    getActivateButtonAriaLabel_() {
        return this.i18n('searchEnginesActivateButtonAriaLabel', this.engine.displayName);
    }
    getEditButtonAriaLabel_() {
        return this.i18n('searchEnginesEditButtonAriaLabel', this.engine.displayName);
    }
}
customElements.define(SettingsSearchEngineEntryElement.is, SettingsSearchEngineEntryElement);

function getTemplate$1C() {
    return html `<!--_html_template_start_-->    <style include="settings-shared">#headers{display:flex;padding:10px 0}#headers .additional-info-column-group{align-items:center;display:flex;flex:6}#headers .controls-group{flex:auto;margin-left:auto;display:flex;justify-content:end;align-items:center}#headers .name{flex:3}#headers .shortcut,#headers .url{flex:auto;margin-inline-end:40px}settings-search-engine-entry{border-top:var(--cr-separator-line)}:host([fixed-height]) #container{max-height:calc((var(--cr-section-min-height) + var(--cr-separator-height)) * 6)}.icon-placeholder{margin-inline-end:0;margin-inline-start:var(--cr-icon-button-margin-start);width:var(--cr-icon-ripple-size)}.cr-row{padding-inline-end:7px;padding-inline-start:0}
    </style>
    <div id="outer" class="list-frame" role="table">
      <div role="rowgroup">
        <div role="row" id="headers" class="column-header">
          <span class="name" role="columnheader">$i18n{searchEnginesName}</span>
          <span class="additional-info-column-group">
            <span class="shortcut" role="columnheader"
                  hidden="[[!showShortcut]]">
              $i18n{searchEnginesShortcut}
            </span>
            <span class="url" role="columnheader"
                  hidden="[[!showQueryUrl]]">
              $i18n{searchEnginesQueryURL}
            </span>
            <span class="controls-group">
              <span class="icon-placeholder"></span>
              <span class="icon-placeholder"></span>
            </span>
          </span>
        </div>
      </div>
      <template is="dom-if" if="[[!collapseList]]">
        <div id="container" class="scroll-container"
            scrollable$="[[fixedHeight]]">
          <div role="rowgroup">
            <dom-repeat items="[[engines]]">
              <template>
                <settings-search-engine-entry engine="[[item]]"
                    show-query-url="[[showQueryUrl]]"
                    show-shortcut="[[showShortcut]]">
                </settings-search-engine-entry>
              </template>
            </dom-repeat>
          </div>
        </div>
      </template>

      <template is="dom-if" if="[[collapseList]]">
        <div id="containerWithCollapsibleSection" class="scroll-container"
            hidden="[[!collapseList]]"
            scrollable$="[[fixedHeight]]">
          <div role="rowgroup">
            <dom-repeat items="[[visibleEngines]]">
              <template>
                <settings-search-engine-entry engine="[[item]]"
                    show-shortcut="[[showShortcut]]"
                    show-query-url="[[showQueryUrl]]">
                </settings-search-engine-entry>
              </template>
            </dom-repeat>
          </div>

          <cr-expand-button no-hover class="cr-row"
              hidden="[[!collapsedEngines.length]]"
              expanded="{{enginesListExpanded_}}">
            <div>[[expandListText]]</div>
          </cr-expand-button>
          <cr-collapse opened="[[enginesListExpanded_]]">
            <div role="rowgroup">
              <dom-repeat items="[[collapsedEngines]]">
                <template>
                  <settings-search-engine-entry engine="[[item]]"
                      show-shortcut="[[showShortcut]]"
                      show-query-url="[[showQueryUrl]]">
                  </settings-search-engine-entry>
                </template>
              </dom-repeat>
            </div>
          </cr-collapse>
        </div>
      </template>
    </div>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-search-engines-list' is a component for showing a
 * list of search engines.
 */
class SettingsSearchEnginesListElement extends PolymerElement {
    static get is() {
        return 'settings-search-engines-list';
    }
    static get template() {
        return getTemplate$1C();
    }
    static get properties() {
        return {
            engines: Array,
            showShortcut: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            showQueryUrl: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            collapseList: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            /**
             * The number of engines visible when the list is collapsed.
             */
            visibleEnginesSize: {
                type: Number,
                value: 5,
            },
            /**
             * An array of the first 'visibleEnginesSize' engines in the `engines`
             * array.  These engines are visible even when 'collapsedEngines' is
             * collapsed.
             */
            visibleEngines: { type: Array, computed: 'computeVisibleEngines_(engines)' },
            /**
             * An array of all remaining engines not in the `visibleEngines` array.
             * These engines' visibility can be toggled by expanding or collapsing the
             * engines list.
             */
            collapsedEngines: { type: Array, computed: 'computeCollapsedEngines_(engines)' },
            lastFocused_: Object,
            listBlurred_: Boolean,
            expandListText: {
                type: String,
                reflectToAttribute: true,
            },
            fixedHeight: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
        };
    }
    computeVisibleEngines_(engines) {
        if (!engines || !engines.length) {
            return;
        }
        return engines.slice(0, this.visibleEnginesSize);
    }
    computeCollapsedEngines_(engines) {
        if (!engines || !engines.length) {
            return;
        }
        return engines.slice(this.visibleEnginesSize);
    }
}
customElements.define(SettingsSearchEnginesListElement.is, SettingsSearchEnginesListElement);

function getTemplate$1B() {
    return html `<!--_html_template_start_-->    <style include="settings-shared search-engine-entry">.name-column{align-items:center;display:flex;flex:3;word-break:break-word}.keyword-column{flex:7}
    </style>
    <div class="list-item" focus-row-container>
      <div class="name-column">
        <site-favicon favicon-url="[[engine.iconURL]]"></site-favicon>
        <span>[[engine.displayName]]</span>
      </div>
      <div class="keyword-column">[[engine.keyword]]</div>
      <cr-icon-button class="icon-more-vert" on-click="onDotsClick_"
          title="$i18n{moreActions}" focus-row-control focus-type="menu">
      </cr-icon-button>
      <cr-action-menu role-description="$i18n{menu}">
        <button class="dropdown-item" on-click="onManageClick_"
            id="manage">
          $i18n{searchEnginesManageExtension}
        </button>
        <button class="dropdown-item" on-click="onDisableClick_"
            id="disable">
          $i18n{disable}
        </button>
      </cr-action-menu>
    </div>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-omnibox-extension-entry' is a component for showing
 * an omnibox extension with its name and keyword.
 */
const SettingsOmniboxExtensionEntryElementBase = FocusRowMixin(PolymerElement);
class SettingsOmniboxExtensionEntryElement extends SettingsOmniboxExtensionEntryElementBase {
    static get is() {
        return 'settings-omnibox-extension-entry';
    }
    static get template() {
        return getTemplate$1B();
    }
    static get properties() {
        return {
            engine: Object,
        };
    }
    browserProxy_ = ExtensionControlBrowserProxyImpl.getInstance();
    onManageClick_() {
        this.closePopupMenu_();
        this.browserProxy_.manageExtension(this.engine.extension.id);
    }
    onDisableClick_() {
        this.closePopupMenu_();
        this.browserProxy_.disableExtension(this.engine.extension.id);
    }
    closePopupMenu_() {
        this.shadowRoot.querySelector('cr-action-menu').close();
    }
    onDotsClick_() {
        const dots = this.shadowRoot.querySelector('cr-icon-button');
        assert(dots);
        this.shadowRoot.querySelector('cr-action-menu').showAt(dots, {
            anchorAlignmentY: AnchorAlignment.AFTER_END,
        });
    }
}
customElements.define(SettingsOmniboxExtensionEntryElement.is, SettingsOmniboxExtensionEntryElement);

function getTemplate$1A() {
    return html `<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">settings-omnibox-extension-entry{border-top:var(--cr-separator-line)}
  </style>
  <settings-subpage
      page-title="$i18n{searchEnginesManageSiteSearch}"
      route-path$="[[routePath]]" search-label="$i18n{searchEnginesSearch}"
      search-term="{{filter_}}">
    <div class="cr-row first">
      <div class="secondary">$i18n{searchEnginesPageExplanation}</div>
    </div>
    <div class="cr-row first">
      <div class="flex cr-padded-text">
        <div id="keyboardShortcutsTitle">
          $i18n{searchEnginesKeyboardShortcutsTitle}
        </div>
        <div class="secondary">
          $i18n{searchEnginesKeyboardShortcutsDescription}
        </div>
      </div>
    </div>
    <div class="list-frame">
      <settings-radio-group id="keyboardShortcutSettingGroup"
          pref="{{prefs.omnibox.keyword_space_triggering_enabled}}"
          on-change="onKeyboardShortcutSettingChange_">
        <controlled-radio-button class="list-item" name="true"
            pref="{{prefs.omnibox.keyword_space_triggering_enabled}}"
            label="$i18n{searchEnginesKeyboardShortcutsSpaceOrTab}"
            aria-labelledby="keyboardShortcutsTitle"
            no-extension-indicator>
        </controlled-radio-button>
        <controlled-radio-button class="list-item" name="false"
            pref="{{prefs.omnibox.keyword_space_triggering_enabled}}"
            label="$i18n{searchEnginesKeyboardShortcutsTab}"
            aria-labelledby="keyboardShortcutsTitle"
            no-extension-indicator>
        </controlled-radio-button>
      </settings-radio-group>
    </div>

    <div class="cr-row first">
      <div class="flex cr-padded-text">
        <h2>$i18n{searchEnginesSearchEngines}</h2>
        <div class="secondary">
          $i18n{searchEnginesSearchEnginesExplanation}
        </div>
      </div>
    </div>
    <settings-search-engines-list hidden="[[!matchingDefaultEngines_.length]]"
        engines="[[matchingDefaultEngines_]]" show-shortcut>
    </settings-search-engines-list>

    <div class="no-search-results list-frame"
        hidden="[[matchingDefaultEngines_.length]]">
      $i18n{searchNoResults}
    </div>

    <template is="dom-if" if="[[showEditDialog_]]" restamp>
      <settings-search-engine-edit-dialog model="[[dialogModel_]]"
          on-close="onCloseEditDialog_">
      </settings-search-engine-edit-dialog>
    </template>

    <template is="dom-if" if="[[showDeleteConfirmationDialog_]]" restamp>
      <settings-simple-confirmation-dialog id="deleteConfirmDialog"
          title-text="$i18n{searchEnginesDeleteConfirmationTitle}"
          body-text="[[getDeleteConfirmationBodyText_(dialogModel_)]]"
          confirm-text="$i18n{delete}"
          on-close="onCloseDeleteConfirmationDialog_">
      </settings-simple-confirmation-dialog>
    </template>

    <div class="cr-row first">
        <div class="flex cr-padded-text">
          <h2>$i18n{searchEnginesSiteSearch}</h2>
          <div class="secondary">$i18n{searchEnginesSiteSearchExplanation}</div>
        </div>
        <cr-button class="secondary-button header-aligned-button"
                   aria-label="$i18n{searchEnginesAddButtonAriaLabel}"
                   on-click="onAddSearchEngineClick_" id="addSearchEngine">
          $i18n{add}
        </cr-button>
    </div>
    <div id="noActiveEngines" class="list-frame"
           hidden="[[activeEngines.length]]">
          $i18n{searchEnginesNoSitesAdded}
    </div>
    <div class="no-search-results list-frame"
           hidden="[[!showNoResultsMessage_(
          activeEngines, matchingActiveEngines_)]]">
          $i18n{searchNoResults}
    </div>
    <settings-search-engines-list id="activeEngines"
        hidden="[[!matchingActiveEngines_.length]]"
        engines="[[matchingActiveEngines_]]"
        scroll-target="[[subpageScrollTarget]]"
        show-shortcut collapse-list
        expand-list-text="$i18n{searchEnginesAdditionalSites}">
    </settings-search-engines-list>

    <div class="cr-row first">
        <h2>$i18n{searchEnginesInactiveShortcuts}</h2>
    </div>
    <settings-search-engines-list
        hidden="[[!matchingOtherEngines_.length]]"
        engines="[[matchingOtherEngines_]]"
        scroll-target="[[subpageScrollTarget]]"
        show-query-url collapse-list
        expand-list-text="$i18n{searchEnginesAdditionalInactiveSites}">
    </settings-search-engines-list>

    <div id="noOtherEngines" class="list-frame"
        hidden="[[otherEngines.length]]">
      $i18n{searchEnginesNoOtherEngines}
    </div>
    <div class="no-search-results list-frame"
        hidden="[[!showNoResultsMessage_(
            otherEngines, matchingOtherEngines_)]]">
      $i18n{searchNoResults}
    </div>

    <template is="dom-if" if="[[showExtensionsList_]]">
      <div class="cr-row first">
        <div class="flex cr-padded-text">
          <h2 class="flex">$i18n{searchEnginesExtension}</h2>
          <div class="secondary"> $i18n{searchEnginesExtensionExplanation}</div>
        </div>
      </div>
      <div class="no-search-results list-frame"
          hidden="[[matchingExtensions_.length]]">
        $i18n{searchNoResults}
      </div>
      <iron-list id="extensions" class="extension-engines list-frame"
          items="[[matchingExtensions_]]" preserve-focus risk-selection>
        <template>
          <settings-omnibox-extension-entry engine="[[item]]"
              focus-row-index="[[index]]"
              tabindex$="[[tabIndex]]" iron-list-tab-index="[[tabIndex]]"
              last-focused="{{omniboxExtensionlastFocused_}}"
              list-blurred="{{omniboxExtensionListBlurred_}}">
          </settings-omnibox-extension-entry>
        </template>
      </iron-list>
    </template>
  </settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-search-engines-page' is the settings page
 * containing search engines settings.
 */
const SettingsSearchEnginesPageElementBase = SettingsViewMixin(GlobalScrollTargetMixin(WebUiListenerMixin(I18nMixin(PolymerElement))));
class SettingsSearchEnginesPageElement extends SettingsSearchEnginesPageElementBase {
    static get is() {
        return 'settings-search-engines-page';
    }
    static get template() {
        return getTemplate$1A();
    }
    static get properties() {
        return {
            /**
             * Preferences state.
             */
            prefs: {
                type: Object,
                notify: true,
            },
            defaultEngines: Array,
            activeEngines: Array,
            otherEngines: Array,
            extensions: Array,
            /**
             * Needed by GlobalScrollTargetMixin.
             */
            subpageRoute: {
                type: Object,
                value: routes.SEARCH_ENGINES,
            },
            showExtensionsList_: {
                type: Boolean,
                computed: 'computeShowExtensionsList_(extensions)',
            },
            /** Filters out all search engines that do not match. */
            filter_: {
                type: String,
                value: '',
            },
            matchingDefaultEngines_: {
                type: Array,
                computed: 'computeMatchingEngines_(defaultEngines, filter_)',
            },
            matchingActiveEngines_: {
                type: Array,
                computed: 'computeMatchingEngines_(activeEngines, filter_)',
            },
            matchingOtherEngines_: {
                type: Array,
                computed: 'computeMatchingEngines_(otherEngines, filter_)',
            },
            matchingExtensions_: {
                type: Array,
                computed: 'computeMatchingEngines_(extensions, filter_)',
            },
            omniboxExtensionlastFocused_: Object,
            omniboxExtensionListBlurred_: Boolean,
            dialogModel_: {
                type: Object,
                value: null,
            },
            dialogAnchorElement_: {
                type: Object,
                value: null,
            },
            showEditDialog_: {
                type: Boolean,
                value: false,
            },
            showDeleteConfirmationDialog_: {
                type: Boolean,
                value: false,
            },
        };
    }
    static get observers() {
        return ['extensionsChanged_(extensions, showExtensionsList_)'];
    }
    browserProxy_ = SearchEnginesBrowserProxyImpl.getInstance();
    ready() {
        super.ready();
        this.browserProxy_.getSearchEnginesList().then(this.enginesChanged_.bind(this));
        this.addWebUiListener('search-engines-changed', this.enginesChanged_.bind(this));
        this.addEventListener('view-or-edit-search-engine', e => this.onEditSearchEngine_(e));
        this.addEventListener('delete-search-engine', e => this.onDeleteSearchEngine_(e));
    }
    openEditDialog_(searchEngine, anchorElement) {
        this.dialogModel_ = searchEngine;
        this.dialogAnchorElement_ = anchorElement;
        this.showEditDialog_ = true;
    }
    openDeleteConfirmationDialog_(searchEngine, anchorElement) {
        this.dialogModel_ = searchEngine;
        this.dialogAnchorElement_ = anchorElement;
        this.showDeleteConfirmationDialog_ = true;
    }
    getDeleteConfirmationBodyText_(searchEngine) {
        if (searchEngine && searchEngine.isManaged) {
            return this.i18n('searchEnginesDeleteConfirmationDescriptionForPolicy');
        }
        return this.i18n('searchEnginesDeleteConfirmationDescription');
    }
    onCloseEditDialog_() {
        this.showEditDialog_ = false;
        focusWithoutInk(this.dialogAnchorElement_);
        this.dialogModel_ = null;
        this.dialogAnchorElement_ = null;
    }
    onCloseDeleteConfirmationDialog_() {
        const dialog = this.shadowRoot.querySelector('settings-simple-confirmation-dialog');
        assert(dialog);
        const confirmed = dialog.wasConfirmed();
        this.showDeleteConfirmationDialog_ = false;
        if (confirmed) {
            assert(this.dialogModel_);
            this.browserProxy_.removeSearchEngine(this.dialogModel_.modelIndex);
            this.dialogAnchorElement_ = null;
        }
        this.dialogModel_ = null;
    }
    onEditSearchEngine_(e) {
        this.openEditDialog_(e.detail.engine, e.detail.anchorElement);
    }
    onDeleteSearchEngine_(e) {
        this.openDeleteConfirmationDialog_(e.detail.engine, e.detail.anchorElement);
    }
    extensionsChanged_() {
        if (this.showExtensionsList_ && this.$.extensions) {
            this.$.extensions.notifyResize();
        }
    }
    enginesChanged_(searchEnginesInfo) {
        this.defaultEngines = searchEnginesInfo.defaults;
        this.activeEngines = searchEnginesInfo.actives;
        this.otherEngines = searchEnginesInfo.others;
        this.extensions = searchEnginesInfo.extensions;
    }
    onAddSearchEngineClick_(e) {
        e.preventDefault();
        this.openEditDialog_(null, this.shadowRoot.querySelector('#addSearchEngine'));
    }
    computeShowExtensionsList_() {
        return this.extensions.length > 0;
    }
    /**
     * Filters the given list based on the currently existing filter string.
     */
    computeMatchingEngines_(list) {
        if (this.filter_ === '') {
            return list;
        }
        const filter = this.filter_.toLowerCase();
        return list.filter(e => {
            return [e.displayName, e.name, e.keyword, e.url].some(term => term.toLowerCase().includes(filter));
        });
    }
    /**
     * @param list The original list.
     * @param filteredList The filtered list.
     * @return Whether to show the "no results" message.
     */
    showNoResultsMessage_(list, filteredList) {
        return list.length > 0 && filteredList.length === 0;
    }
    onKeyboardShortcutSettingChange_() {
        const spaceEnabled = this.$.keyboardShortcutSettingGroup.selected === 'true';
        this.browserProxy_.recordSearchEnginesPageHistogram(spaceEnabled ?
            SearchEnginesInteractions.KEYBOARD_SHORTCUT_SPACE_OR_TAB :
            SearchEnginesInteractions.KEYBOARD_SHORTCUT_TAB);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsSearchEnginesPageElement.is, SettingsSearchEnginesPageElement);

function getTemplate$1z() {
    return html `<!--_html_template_start_-->    <style include="settings-shared">#incognito{padding-bottom:10px}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div slot="title">$i18n{addSiteTitle}</div>
      <div slot="body">
        <cr-input id="site" label="$i18n{addSite}"
            placeholder="$i18n{addSiteExceptionPlaceholder}"
            value="{{site_}}" on-input="validate_"
            error-message="{{errorMessage_}}" spellcheck="false"
            autofocus></cr-input>
        <cr-checkbox id="incognito"
            hidden$="[[!showIncognitoSessionOnly_(hasIncognito,
                contentSetting)]]">
          $i18n{incognitoSiteOnly}
        </cr-checkbox>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCancelClick_">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" id="add" on-click="onSubmit_"
            disabled>
          $i18n{add}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SiteSettingsMixin = dedupingMixin((superClass) => {
    class SiteSettingsMixin extends superClass {
        static get properties() {
            return {
                /**
                 * The string ID of the category this element is displaying data
                 * for. See site_settings/constants.js for possible values.
                 */
                category: String,
                /**
                 * A cached list of ContentSettingsTypes with a standard
                 * allow-block-ask pattern that are currently enabled for use. This
                 * property is the same across all elements with SiteSettingsMixin
                 * ('static').
                 */
                contentTypes_: {
                    type: Array,
                    value: [],
                },
            };
        }
        browserProxy;
        constructor(...args) {
            super(...args);
            /**
             * The browser proxy used to retrieve and change information about
             * site settings categories and the sites within.
             */
            this.browserProxy = SiteSettingsBrowserProxyImpl.getInstance();
        }
        /**
         * Ensures the URL has a scheme (assumes http if omitted).
         * @param url The URL with or without a scheme.
         * @return The URL with a scheme, or an empty string.
         */
        ensureUrlHasScheme(url) {
            if (url.length === 0) {
                return url;
            }
            return url.includes('://') ? url : 'http://' + url;
        }
        /**
         * Removes redundant ports, such as port 80 for http and 443 for https.
         * @param url The URL to sanitize.
         * @return The URL without redundant ports, if any.
         */
        sanitizePort(url) {
            const urlWithScheme = this.ensureUrlHasScheme(url);
            if (urlWithScheme.startsWith('https://') &&
                urlWithScheme.endsWith(':443')) {
                return url.slice(0, -4);
            }
            if (urlWithScheme.startsWith('http://') &&
                urlWithScheme.endsWith(':80')) {
                return url.slice(0, -3);
            }
            return url;
        }
        /**
         * Converts a string origin/pattern to a URL.
         * @param originOrPattern The origin/pattern to convert to URL.
         * @return The URL to return (or null if origin is not a valid URL).
         */
        toUrl(originOrPattern) {
            if (originOrPattern.length === 0) {
                return null;
            }
            // TODO(finnur): Hmm, it would probably be better to ensure scheme on
            // the JS/C++ boundary.
            // TODO(dschuyler): I agree. This filtering should be done in one go,
            // rather that during the sort. The URL generation should be wrapped
            // in a try/catch as well.
            originOrPattern = originOrPattern.replace('*://', '');
            originOrPattern = originOrPattern.replace('[*.]', '');
            return new URL(this.ensureUrlHasScheme(originOrPattern));
        }
        /**
         * @return a user-friendly name for the origin.
         */
        originRepresentation(origin) {
            try {
                const url = this.toUrl(origin);
                return url ? (url.host || url.origin) : '';
            }
            catch (error) {
                return '';
            }
        }
        /**
         * Convert an exception (received from the C++ handler) to a full
         * SiteException.
         * @param exception The raw site exception from C++.
         * @return The expanded (full) SiteException.
         */
        expandSiteException(exception) {
            const origin = exception.origin;
            const embeddingOrigin = exception.embeddingOrigin;
            // TODO(patricialor): |exception.source| should be one of the values
            // defined in |SiteSettingSource|.
            let enforcement = null;
            if (exception.source === SiteSettingSource.EXTENSION ||
                exception.source === SiteSettingSource.HOSTED_APP ||
                exception.source === SiteSettingSource.POLICY) {
                enforcement = chrome.settingsPrivate.Enforcement.ENFORCED;
            }
            let controlledBy = chrome.settingsPrivate.ControlledBy.PRIMARY_USER;
            if (exception.source === SiteSettingSource.EXTENSION ||
                exception.source === SiteSettingSource.HOSTED_APP) {
                controlledBy = chrome.settingsPrivate.ControlledBy.EXTENSION;
            }
            else if (exception.source === SiteSettingSource.POLICY) {
                controlledBy = chrome.settingsPrivate.ControlledBy.USER_POLICY;
            }
            return {
                category: exception.type,
                embeddingOrigin: embeddingOrigin,
                incognito: exception.incognito,
                isEmbargoed: exception.isEmbargoed,
                origin: origin,
                displayName: exception.displayName,
                setting: exception.setting,
                description: exception.description,
                enforcement: enforcement,
                controlledBy: controlledBy,
            };
        }
    }
    return SiteSettingsMixin;
});

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'add-site-dialog' provides a dialog to add exceptions for a given Content
 * Settings category.
 */
const AddSiteDialogElementBase = SiteSettingsMixin(PolymerElement);
class AddSiteDialogElement extends AddSiteDialogElementBase {
    static get is() {
        return 'add-site-dialog';
    }
    static get template() {
        return getTemplate$1z();
    }
    static get properties() {
        return {
            /**
             * Whether this is about an Allow, Block, SessionOnly, or other.
             */
            contentSetting: String,
            hasIncognito: {
                type: Boolean,
                observer: 'hasIncognitoChanged_',
            },
            /**
             * Controls what kind of patterns the created cookies exception will have
             * (based on the CookiesExceptionType):
             * - THIRD_PARTY: Exception that will have primary pattern as wildcard
             * (third-party cookie exceptions).
             * - SITE_DATA: Exception that will have secondary pattern as wildcard
             * (regular exceptions).
             * - COMBINED: Support both pattern types and have a checkbox to control
             * the mode.
             */
            cookiesExceptionType: String,
            /**
             * The site to add an exception for.
             */
            site_: String,
            /**
             * The error message to display when the pattern is invalid.
             */
            errorMessage_: String,
        };
    }
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    connectedCallback() {
        super.connectedCallback();
        assert(this.category);
        assert(this.contentSetting);
        assert(typeof this.hasIncognito !== 'undefined');
        this.$.dialog.showModal();
    }
    /**
     * Validates that the pattern entered is valid.
     */
    validate_() {
        // If input is empty, disable the action button, but don't show the red
        // invalid message.
        if (this.$.site.value.trim() === '') {
            this.$.site.invalid = false;
            this.$.add.disabled = true;
            return;
        }
        this.browserProxy.isPatternValidForType(this.site_, this.category)
            .then(({ isValid, reason }) => {
            this.$.site.invalid = !isValid;
            this.$.add.disabled = !isValid;
            this.errorMessage_ = reason || '';
        });
    }
    onCancelClick_() {
        this.$.dialog.cancel();
    }
    /**
     * The tap handler for the Add [Site] button (adds the pattern and closes
     * the dialog).
     */
    onSubmit_() {
        assert(!this.$.add.disabled);
        let primaryPattern = this.site_;
        let secondaryPattern = SITE_EXCEPTION_WILDCARD;
        if (this.cookiesExceptionType === CookiesExceptionType.THIRD_PARTY ||
            this.category === ContentSettingsTypes.TRACKING_PROTECTION) {
            primaryPattern = SITE_EXCEPTION_WILDCARD;
            secondaryPattern = this.site_;
        }
        if (this.showIncognitoSessionOnly_()) {
            // Record how many users are interacting with the incognito checkbox
            // when it is available.
            this.metricsBrowserProxy_.recordBooleanHistogram('Settings.AddSiteDialog.Incognito', this.$.incognito.checked);
        }
        this.browserProxy.setCategoryPermissionForPattern(primaryPattern, secondaryPattern, this.category, this.contentSetting, this.$.incognito.checked);
        this.$.dialog.close();
    }
    showIncognitoSessionOnly_() {
        return this.hasIncognito && !loadTimeData.getBoolean('isGuest') &&
            this.contentSetting !== ContentSetting.SESSION_ONLY;
    }
    hasIncognitoChanged_() {
        if (!this.hasIncognito) {
            this.$.incognito.checked = false;
        }
    }
}
customElements.define(AddSiteDialogElement.is, AddSiteDialogElement);

function getTemplate$1y() {
    return html `<!--_html_template_start_-->    <style include="settings-shared"></style>
    <cr-dialog id="dialog">
      <div slot="title">$i18n{editSiteTitle}</div>
      <div slot="body">
        <cr-input label="$i18n{addSite}" value="{{origin_}}"
            placeholder="$i18n{addSiteExceptionPlaceholder}"
            on-input="validate_" error-message="{{errorMessage_}}"
            invalid="[[invalid_]]" autofocus spellcheck="false">
        </cr-input>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCancelClick_"
            id="cancel">$i18n{cancel}</cr-button>
        <cr-button id="actionButton" class="action-button"
            on-click="onActionButtonClick_" disabled="[[invalid_]]">
          $i18n{save}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-edit-exception-dialog' is a component for editing a
 * site exception entry.
 */
class SettingsEditExceptionDialogElement extends PolymerElement {
    static get is() {
        return 'settings-edit-exception-dialog';
    }
    static get template() {
        return getTemplate$1y();
    }
    static get properties() {
        return {
            model: {
                type: Object,
                observer: 'modelChanged_',
            },
            origin_: String,
            /**
             * The localized error message to display when the pattern is invalid.
             */
            errorMessage_: String,
            /**
             * Whether the current input is invalid.
             */
            invalid_: {
                type: Boolean,
                value: false,
            },
        };
    }
    browserProxy_ = SiteSettingsBrowserProxyImpl.getInstance();
    connectedCallback() {
        super.connectedCallback();
        this.origin_ = this.model.origin;
        this.$.dialog.showModal();
    }
    onCancelClick_() {
        this.$.dialog.close();
    }
    onActionButtonClick_() {
        if (this.model.origin !== this.origin_) {
            // The way to "edit" an exception is to remove it and and a new one.
            this.browserProxy_.resetCategoryPermissionForPattern(this.model.origin, this.model.embeddingOrigin, this.model.category, this.model.incognito);
            this.browserProxy_.setCategoryPermissionForPattern(this.origin_, SITE_EXCEPTION_WILDCARD, this.model.category, this.model.setting, this.model.incognito);
        }
        this.$.dialog.close();
    }
    validate_() {
        if (this.shadowRoot.querySelector('cr-input').value.trim() === '') {
            this.invalid_ = true;
            return;
        }
        this.browserProxy_.isPatternValidForType(this.origin_, this.model.category)
            .then(({ isValid, reason }) => {
            this.invalid_ = !isValid;
            this.errorMessage_ = reason || '';
        });
    }
    modelChanged_() {
        if (!this.model) {
            this.$.dialog.cancel();
        }
    }
}
customElements.define(SettingsEditExceptionDialogElement.is, SettingsEditExceptionDialogElement);

function getTemplate$1x() {
    return html `<!--_html_template_start_-->    <style include="settings-shared">:host{padding-inline-end:4px}.settings-row{flex:1}cr-policy-pref-indicator::part(tooltip){clip:rect(0 0 0 0);height:1px;overflow:hidden;width:1px}
    </style>
    <div class="list-item" focus-row-container>
      <div class="settings-row" role="row"
          aria-label="[[computeAriaLabel_(model)]]">
        <div role="gridcell" class="settings-row" on-click="onOriginClick_"
            id="originArea" aria-label="[[computeAriaLabel_(model)]]"
            actionable$="[[allowNavigateToSiteDetail_]]">
          <site-favicon url="[[computeFaviconOrigin_(model)]]"></site-favicon>
          <div class="middle no-min-width">
            <div class="text-elide">
              <span class="url-directionality">
                [[computeDisplayName_(model)]]</span>
            </div>
            <!-- This div must not contain extra whitespace. -->
            <div class="secondary"
                id="siteDescription">[[computeSiteDescription_(model)]]</div>
          </div>

          <template is="dom-if" if="[[allowNavigateToSiteDetail_]]">
            <cr-icon-button class="subpage-arrow"
                aria-label$="[[computeViewButtonAriaLabel_(model)]]"
                aria-describedby="siteDescription"
                aria-roledescription="$i18n{subpageArrowRoleDescription}"
                focus-type="site-details" focus-row-control></cr-icon-button>
            <div class="separator"></div>
          </template>
        </div>
        <template is="dom-if" if="[[showPolicyPrefIndicator_]]">
          <div role="gridcell">
            <cr-policy-pref-indicator pref="[[model]]"
                on-mouseenter="onShowTooltip_"
                on-focus="onShowTooltip_" focus-row-control focus-type="policy">
            </cr-policy-pref-indicator>
          </div>
        </template>
        <template is="dom-if" if="[[model.incognito]]">
          <div role="gridcell">
            <cr-tooltip-icon id="incognitoTooltip"
                icon-aria-label="$i18n{incognitoSiteExceptionDesc}"
                icon-class="settings20:incognito"
                focus-row-control focus-type="incognito"
                on-mouseenter="onShowIncognitoTooltip_"
                on-focus="onShowIncognitoTooltip_"></cr-tooltip-icon>
          </div>
        </template>
        <template is="dom-if"
            if="[[shouldShowResetButton_(model, readOnlyList)]]">
          <div role="gridcell">
            <cr-icon-button id="resetSite" class="icon-delete-gray"
                on-click="onResetButtonClick_"
                aria-label="[[computeRemoveButtonAriaLabel_(model)]]"
                focus-row-control focus-type="reset"></cr-icon-button>
          </div>
        </template>
        <template is="dom-if"
            if="[[shouldShowActionMenu_(model, readOnlyList)]]">
          <div role="gridcell">
            <cr-icon-button id="actionMenuButton" class="icon-more-vert"
                on-click="onShowActionMenuClick_"
                title$="[[getActionMenuButtonLabel_(model)]]"
                focus-row-control focus-type="menu"></cr-icon-button>
          </div>
        </template>
      </div>
    </div>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'site-list-entry' shows an Allowed and Blocked site for a given category.
 */
const SiteListEntryElementBase = FocusRowMixin(BaseMixin(SiteSettingsMixin(I18nMixin(PolymerElement))));
class SiteListEntryElement extends SiteListEntryElementBase {
    static get is() {
        return 'site-list-entry';
    }
    static get template() {
        return getTemplate$1x();
    }
    static get properties() {
        return {
            /**
             * Some content types (like Location) do not allow the user to manually
             * edit the exception list from within Settings.
             */
            readOnlyList: {
                type: Boolean,
                value: false,
            },
            /** Site to display in the widget.*/
            model: {
                type: Object,
                observer: 'onModelChanged_',
            },
            /** Whether this entry is the only entry in the Allowed/Blocked section.*/
            singletonEntry: {
                type: Boolean,
            },
            /**
             * The header for the Allowed/Blocked section this entry is in. Used for
             * aria-label to fix cases where the screenreader hasn't already read it.
             */
            sectionHeader: {
                type: String,
            },
            /**
             * If the site represented is part of a chooser exception, the chooser
             * type will be stored here to allow the permission to be manipulated.
             */
            chooserType: {
                type: String,
                value: ChooserType.NONE,
            },
            /**
             * If the site represented is part of a chooser exception, the chooser
             * object will be stored here to allow the permission to be manipulated.
             */
            chooserObject: {
                type: Object,
                value: null,
            },
            showPolicyPrefIndicator_: {
                type: Boolean,
                computed: 'computeShowPolicyPrefIndicator_(model)',
            },
            allowNavigateToSiteDetail_: {
                type: Boolean,
                value: false,
            },
            /**
             * Type of cookies exceptions based on the use of wildcard in the
             * patterns. See `CookiesExceptionType`.
             */
            cookiesExceptionType: String,
        };
    }
    onShowTooltip_() {
        const indicator = this.shadowRoot.querySelector('cr-policy-pref-indicator');
        assert(!!indicator);
        // The tooltip text is used by an cr-tooltip contained inside the
        // cr-policy-pref-indicator. This text is needed here to send up to the
        // common tooltip component.
        const text = indicator.indicatorTooltip;
        this.fire('show-tooltip', { target: indicator, text });
    }
    onShowIncognitoTooltip_() {
        const tooltip = this.shadowRoot.querySelector('#incognitoTooltip');
        // The tooltip text is used by an cr-tooltip contained inside the
        // cr-policy-pref-indicator. The text is currently held in a private
        // property. This text is needed here to send up to the common tooltip
        // component.
        const text = loadTimeData.getString('incognitoSiteExceptionDesc');
        this.fire('show-tooltip', { target: tooltip, text });
    }
    isIsolatedWebApp_() {
        return this.model.origin.startsWith('isolated-app://');
    }
    /**
     * Returns true if this site exception can be edited by the user. Note that
     * this is not the same as readonly; an exception can be removable but not
     * editable.
     */
    isUserEditable_() {
        return !this.readOnlyList && !this.model.embeddingOrigin &&
            !this.isIsolatedWebApp_();
    }
    shouldShowResetButton_() {
        if (this.model === undefined) {
            return false;
        }
        return this.model.enforcement !==
            chrome.settingsPrivate.Enforcement.ENFORCED &&
            !this.isUserEditable_();
    }
    shouldShowActionMenu_() {
        if (this.model === undefined) {
            return false;
        }
        return this.model.enforcement !==
            chrome.settingsPrivate.Enforcement.ENFORCED &&
            this.isUserEditable_();
    }
    /**
     * A handler for selecting a site (by clicking on the origin).
     */
    onOriginClick_() {
        if (!this.allowNavigateToSiteDetail_) {
            return;
        }
        Router.getInstance().navigateTo(routes.SITE_SETTINGS_SITE_DETAILS, new URLSearchParams('site=' + this.model.origin));
    }
    /**
     * Returns the appropriate display name to show for the exception.
     * This can, for example, be the website that is affected itself,
     * or the website whose third parties are also affected.
     */
    computeDisplayName_() {
        if (this.model.embeddingOrigin &&
            ((this.model.category === ContentSettingsTypes.COOKIES &&
                this.model.origin.trim() === SITE_EXCEPTION_WILDCARD) ||
                this.model.category === ContentSettingsTypes.TRACKING_PROTECTION)) {
            return this.model.embeddingOrigin;
        }
        return this.model.displayName;
    }
    /**
     * Returns an appropriate aria-label for this entry. The reset (trash can)
     * button has a different aria-label, see the HTML.
     */
    computeAriaLabel_() {
        if (this.singletonEntry) {
            // Screen readers sometimes only read the grid's label (which is in
            // site_list.html) if the grid has more than 1 row. That contains the
            // important context of whether this site is allowed or blocked, so we
            // explicitly add it to the aria-label here to make sure it's read.
            return `${this.computeDisplayName_()} ${this.sectionHeader}`;
        }
        return this.computeDisplayName_();
    }
    /**
     * Returns an appropriate aria-label for the remove button. This aria-label
     * clearly indicates a site name and section header. It should help the
     * screenreader user understand that this button will remove the site from the
     * list. There are two lists, one for allowed sites and one for blocked sites.
     */
    computeRemoveButtonAriaLabel_() {
        return this.i18n('siteSettingsActionResetFromListA11y', this.computeDisplayName_(), this.sectionHeader);
    }
    /**
     * Returns an appropriate aria-label for the view button. This aria-label
     * clearly indicates a site name and section header. It should help the
     * screenreader user understand that this button will open a subpage for the
     * site from the list. There are two lists, one for allowed sites and one for
     * blocked sites.
     */
    computeViewButtonAriaLabel_() {
        return this.i18n('siteSettingsActionViewFromListA11y', this.computeDisplayName_(), this.sectionHeader);
    }
    /**
     * Returns the appropriate origin that a favicon will be fetched for.
     */
    computeFaviconOrigin_() {
        if (this.model.origin.trim() !== SITE_EXCEPTION_WILDCARD) {
            return this.model.origin.trim();
        }
        if (this.model.embeddingOrigin.trim() !== SITE_EXCEPTION_WILDCARD) {
            return this.model.embeddingOrigin.trim();
        }
        assertNotReached();
    }
    /**
     * Returns the appropriate site description to display. This can, for example,
     * be blank, an 'embedded on <site>' string, or a third-party exception
     * description string.
     */
    computeSiteDescription_() {
        let description = '';
        // If a description has been set by the handler, have it override others.
        // TODO(crbug.com/40276807): Move all possible descriptions in to this
        // field C++ side so this function can be greatly simplified.
        if (this.model.description) {
            description = this.model.description;
        }
        else if (this.model.isEmbargoed) {
            assert(!this.model.embeddingOrigin, 'Embedding origin should be empty for embargoed origin.');
            description = loadTimeData.getString('siteSettingsSourceEmbargo');
        }
        else if (this.model.embeddingOrigin) {
            if (this.model.category === ContentSettingsTypes.COOKIES &&
                this.model.origin.trim() === SITE_EXCEPTION_WILDCARD) {
                // Apply special label only if cookies exceptions are displayed in the
                // mixed list.
                if (this.cookiesExceptionType === CookiesExceptionType.COMBINED) {
                    description = loadTimeData.getString('siteSettingsCookiesThirdPartyExceptionLabel');
                }
            }
            else if (this.model.category !== ContentSettingsTypes.TRACKING_PROTECTION) {
                description = loadTimeData.getStringF('embeddedOnHost', this.sanitizePort(this.model.embeddingOrigin));
            }
        }
        try {
            const url = new URL(this.model.origin);
            if (url.protocol === 'chrome-extension:') {
                description = loadTimeData.getStringF('siteSettingsExtensionIdDescription', url.hostname);
            }
        }
        finally {
            return description;
        }
    }
    computeShowPolicyPrefIndicator_() {
        return this.model.enforcement ===
            chrome.settingsPrivate.Enforcement.ENFORCED &&
            !!this.model.controlledBy;
    }
    onResetButtonClick_() {
        this.fire('site-list-entry-reset-click');
        // Use the appropriate method to reset a chooser exception.
        if (this.chooserType !== ChooserType.NONE && this.chooserObject !== null) {
            this.browserProxy.resetChooserExceptionForSite(this.chooserType, this.model.origin, this.chooserObject);
            return;
        }
        this.browserProxy.resetCategoryPermissionForPattern(this.model.origin, this.model.embeddingOrigin, this.model.category, this.model.incognito);
    }
    onShowActionMenuClick_() {
        // Chooser exceptions do not support the action menu, so do nothing.
        if (this.chooserType !== ChooserType.NONE) {
            return;
        }
        this.fire('show-action-menu', {
            anchor: this.shadowRoot.querySelector('#actionMenuButton'),
            model: this.model,
        });
    }
    onModelChanged_() {
        if (!this.model) {
            this.allowNavigateToSiteDetail_ = false;
            return;
        }
        this.browserProxy.isOriginValid(this.model.origin).then((valid) => {
            this.allowNavigateToSiteDetail_ = valid;
        });
    }
    getActionMenuButtonLabel_() {
        return this.i18n('siteDataPageAddSiteContextMenuLabel', this.computeDisplayName_());
    }
    setSectionHeaderForTest(sectionHeader) {
        this.sectionHeader = sectionHeader;
    }
}
customElements.define(SiteListEntryElement.is, SiteListEntryElement);

function getTemplate$1w() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">#addSite{margin-inline-start:var(--cr-button-edge-spacing)}
    </style>
    <div id="category">
      <div class="cr-row first">
        <h2 id="listHeader" class="flex secondary" tabIndex="-1">
          [[categoryHeader]]
        </h2>
        <cr-button id="addSite" class="header-aligned-button"
            hidden$="[[!showAddSiteButton_]]" on-click="onAddSiteClick_"
            aria-label$="[[getAddButtonLabel_()]]">
          $i18n{add}
        </cr-button>
      </div>
      <div hidden$="[[!showHeaderWarning_(
              sites.*,systemPermissionWarningKey_)]]"
          id="systemPermissionDeclinedWarning"
          class="list-frame">
        <div class="list-item secondary">
          <div inner-h-t-m-l="[[getSystemPermissionWarning_(
                  systemPermissionWarningKey_)]]">
          </div>
        </div>
      </div>
      <cr-action-menu role-description="$i18n{menu}">
        <button class="dropdown-item" id="allow"
            on-click="onAllowClick_" hidden$="[[!showAllowAction_]]">
          $i18n{siteSettingsActionAllow}
        </button>
        <button class="dropdown-item" id="block"
            on-click="onBlockClick_" hidden$="[[!showBlockAction_]]">
          $i18n{siteSettingsActionBlock}
        </button>
        <button class="dropdown-item" id="sessionOnly"
            on-click="onSessionOnlyClick_"
            hidden$="[[!showSessionOnlyActionForSite_(actionMenuSite_)]]">
          $i18n{siteSettingsActionSessionOnly}
        </button>
        <button class="dropdown-item" id="edit"
            on-click="onEditClick_">
          $i18n{edit}
        </button>
        <button class="dropdown-item" id="reset"
            on-click="onResetClick_">
          $i18n{siteSettingsActionReset}
        </button>
      </cr-action-menu>

      <div class="list-frame" hidden$="[[hasSites_(sites.*)]]">
        <div class="list-item secondary">$i18n{noSitesAdded}</div>
      </div>
      <div class="list-frame"
          hidden$="[[!showNoSearchResults_(searchFilter, sites.*)]]">
        <div class="list-item secondary">$i18n{searchNoResults}</div>
      </div>
      <div class="list-frame menu-content vertical-list" id="listContainer"
          hidden$="[[!hasSites_(sites.*)]]">
        <iron-list items="[[getFilteredSites_(searchFilter, sites.*)]]"
            role="grid" aria-labelledby="listHeader"
            aria-describedby="[[categoryHeader]]" preserve-focus risk-selection>
          <template>
            <site-list-entry model="[[item]]" read-only-list="[[readOnlyList]]"
                on-show-action-menu="onShowActionMenu_"
                singleton-entry="[[hasOneFilteredSite_(searchFilter, sites.*)]]"
                section-header="[[categoryHeader]]" tabindex$="[[tabIndex]]"
                first$="[[!index]]" iron-list-tab-index="[[tabIndex]]"
                last-focused="{{lastFocused_}}" list-blurred="{{listBlurred_}}"
                on-show-tooltip="onShowTooltip_" focus-row-index="[[index]]"
                on-site-list-entry-reset-click="onResetEntry_"
                cookies-exception-type="[[cookiesExceptionType]]">
            </site-list-entry>
          </template>
        </iron-list>
      </div>
    </div>
    <cr-tooltip id="tooltip" hidden="[[!tooltipText_]]"
        fit-to-visible-bounds manual-mode position="top">
      [[tooltipText_]]
    </cr-tooltip>
    <template is="dom-if" if="[[showEditExceptionDialog_]]" restamp>
      <settings-edit-exception-dialog model="[[actionMenuSite_]]"
          on-close="onEditExceptionDialogClosed_">
      </settings-edit-exception-dialog>
    </template>
    <template is="dom-if" if="[[showAddSiteDialog_]]" restamp>
      <add-site-dialog has-incognito="[[hasIncognito_]]" category="[[category]]"
          content-setting="[[categorySubtype]]"
          on-close="onAddSiteDialogClosed_"
          cookies-exception-type="[[cookiesExceptionType]]">
      </add-site-dialog>
    </template>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'site-list' shows a list of Allowed and Blocked sites for a given
 * category.
 */
const SiteListElementBase = TooltipMixin(ListPropertyUpdateMixin(SiteSettingsMixin(WebUiListenerMixin(I18nMixin(PolymerElement)))));
class SiteListElement extends SiteListElementBase {
    static get is() {
        return 'site-list';
    }
    static get template() {
        return getTemplate$1w();
    }
    static get properties() {
        return {
            /**
             * Some content types (like Location) do not allow the user to manually
             * edit the exception list from within Settings.
             */
            readOnlyList: {
                type: Boolean,
                value: false,
            },
            categoryHeader: String,
            /**
             * Optional warning message to be displayed bellow the category header.
             */
            systemPermissionWarningKey_: {
                type: String,
                value: null,
                observer: 'attachSystemPermissionSettingsLinkClick_',
            },
            /**
             * The site serving as the model for the currently open action menu.
             */
            actionMenuSite_: Object,
            /**
             * Whether the "edit exception" dialog should be shown.
             */
            showEditExceptionDialog_: Boolean,
            /**
             * Array of sites to display in the widget.
             */
            sites: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * The type of category this widget is displaying data for. Normally
             * either 'allow' or 'block', representing which sites are allowed or
             * blocked respectively.
             */
            categorySubtype: {
                type: String,
                value: INVALID_CATEGORY_SUBTYPE,
            },
            /**
             * Filters cookies exceptions based on the type (CookiesExceptionType):
             * - THIRD_PARTY: Only show cookies exceptions that have primary pattern
             * as wildcard (third-party cookies exceptions).
             * - SITE_DATA: Only show cookies exceptions that have primary pattern
             * set. This includes site data exceptions (secondary pattern is wildcard)
             * and exceptions with both patterns set (currently possible only via
             * exceptions API).
             * - COMBINED: Doesn't apply any filters, will show exceptions with both
             * pattern types.
             */
            cookiesExceptionType: String,
            hasIncognito_: Boolean,
            /**
             * Whether to show the Add button next to the header.
             */
            showAddSiteButton_: {
                type: Boolean,
                computed: 'computeShowAddSiteButton_(readOnlyList, category, ' +
                    'categorySubtype)',
            },
            showAddSiteDialog_: Boolean,
            /**
             * Whether to show the Allow action in the action menu.
             */
            showAllowAction_: Boolean,
            /**
             * Whether to show the Block action in the action menu.
             */
            showBlockAction_: Boolean,
            /**
             * Whether to show the 'Clear on exit' action in the action
             * menu.
             */
            showSessionOnlyAction_: Boolean,
            lastFocused_: Object,
            listBlurred_: Boolean,
            tooltipText_: String,
            searchFilter: String,
        };
    }
    static get observers() {
        return ['configureWidget_(category, categorySubtype)'];
    }
    activeDialogAnchor_;
    browserProxy_ = SiteSettingsBrowserProxyImpl.getInstance();
    constructor() {
        super();
        this.updateCategoryWarning_();
        /**
         * The element to return focus to, when the currently active dialog is
         * closed.
         */
        this.activeDialogAnchor_ = null;
    }
    ready() {
        super.ready();
        this.addWebUiListener('contentSettingSitePermissionChanged', (category) => this.siteWithinCategoryChanged_(category));
        this.addWebUiListener('contentSettingCategoryChanged', (category) => this.siteWithinCategoryChanged_(category));
        this.addWebUiListener('onIncognitoStatusChanged', (hasIncognito) => this.onIncognitoStatusChanged_(hasIncognito));
        this.addWebUiListener('osGlobalPermissionChanged', (messages) => {
            this.setCategoryWarning_(messages.includes(this.category));
        });
        this.browserProxy.updateIncognitoStatus();
    }
    /**
     * Update the category warning when the OS permission for this category
     * changed.
     */
    updateCategoryWarning_() {
        this.browserProxy.getSystemDeniedPermissions().then((messages) => {
            this.setCategoryWarning_(messages.includes(this.category));
        });
    }
    /**
     * Sets the category warning when the OS permission for this category changed.
     */
    setCategoryWarning_(categoryBlocked) {
        this.set('systemPermissionWarningKey_', ((category) => {
            // We return null as warningKey in case the category is not one of
            // the listed, as the warning in case of an OS level block is
            // supported only for camera, microphone and location permissions.
            if (!categoryBlocked) {
                return null;
            }
            switch (category) {
                case ContentSettingsTypes.CAMERA:
                    return 'siteSettingsContentCameraBlockedByOs';
                case ContentSettingsTypes.MIC:
                    return 'siteSettingsContentMicBlockedByOs';
                case ContentSettingsTypes.GEOLOCATION:
                    return 'siteSettingsContentLocationBlockedByOs';
                default:
                    return null;
            }
        })(this.category));
    }
    /**
     * Called when a site changes permission.
     * @param category The category of the site that changed.
     */
    siteWithinCategoryChanged_(category) {
        if (category === this.category ||
            (this.category === ContentSettingsTypes.TRACKING_PROTECTION &&
                category === ContentSettingsTypes.COOKIES)) {
            this.configureWidget_();
        }
    }
    /**
     * Called for each site list when incognito is enabled or disabled. Only
     * called on change (opening N incognito windows only fires one message).
     * Another message is sent when the *last* incognito window closes.
     */
    onIncognitoStatusChanged_(hasIncognito) {
        this.hasIncognito_ = hasIncognito;
        // The SESSION_ONLY list won't have any incognito exceptions. (Minor
        // optimization, not required).
        if (this.categorySubtype === ContentSetting.SESSION_ONLY) {
            return;
        }
        // A change notification is not sent for each site. So we repopulate the
        // whole list when the incognito profile is created or destroyed.
        this.populateList_();
    }
    /**
     * Configures the action menu, visibility of the widget and shows the list.
     */
    configureWidget_() {
        if (this.category === undefined) {
            return;
        }
        this.setUpActionMenu_();
        this.populateList_();
        // The Session permissions are only for cookies.
        if (this.categorySubtype === ContentSetting.SESSION_ONLY) {
            this.$.category.hidden = this.category !== ContentSettingsTypes.COOKIES;
        }
    }
    /** Whether there are any site exceptions added for this content setting. */
    hasSites_() {
        return this.sites.length > 0;
    }
    /** Whether the header warning should be shown. */
    showHeaderWarning_() {
        return this.hasSites_() && (this.systemPermissionWarningKey_ !== null);
    }
    /** The text of the warning. Null if the warning is not to be shown. */
    getSystemPermissionWarning_() {
        const sanitizeOptions = { tags: ['a'], attrs: ['id'] };
        if (this.systemPermissionWarningKey_ !== null) {
            return this.i18nAdvanced(this.systemPermissionWarningKey_, sanitizeOptions);
        }
        return sanitizeInnerHtml('');
    }
    /** Attempts to open the system permission settings. */
    onSystemPermissionSettingsLinkClick_(event) {
        // Prevents navigation to href='#'.
        event.preventDefault();
        if (this.category !== null) {
            this.browserProxy.openSystemPermissionSettings(this.category);
        }
    }
    /** Attached the click action to the anchor element. */
    attachSystemPermissionSettingsLinkClick_() {
        const elementId = 'openSystemSettingsLink';
        const element = this.shadowRoot?.querySelector(`#${elementId}`);
        if (element !== null && element !== undefined) {
            element.addEventListener('click', (me) => {
                this.onSystemPermissionSettingsLinkClick_(me);
            });
            // Set the correct aria label describing the link target.
            const settingsPageName = (() => {
                switch (this.category) {
                    case ContentSettingsTypes.CAMERA:
                        return 'Camera';
                    case ContentSettingsTypes.MIC:
                        return 'Microphone';
                    case ContentSettingsTypes.GEOLOCATION:
                        return 'Location';
                    default:
                        return null;
                }
            })();
            if (settingsPageName) {
                element.setAttribute('aria-label', `System Settings: ${settingsPageName}`);
            }
        }
    }
    /**
     * Whether the Add Site button is shown in the header for the current category
     * and category subtype.
     */
    computeShowAddSiteButton_() {
        return !(this.readOnlyList ||
            (this.category === ContentSettingsTypes.FILE_SYSTEM_WRITE &&
                this.categorySubtype === ContentSetting.ALLOW));
    }
    showNoSearchResults_() {
        return this.sites.length > 0 && this.getFilteredSites_().length === 0;
    }
    /**
     * A handler for the Add Site button.
     */
    onAddSiteClick_() {
        assert(!this.readOnlyList);
        this.showAddSiteDialog_ = true;
    }
    onAddSiteDialogClosed_() {
        this.showAddSiteDialog_ = false;
        focusWithoutInk(this.$.addSite);
    }
    /**
     * Need to use common tooltip since the tooltip in the entry is cut off from
     * the iron-list.
     */
    onShowTooltip_(e) {
        this.tooltipText_ = e.detail.text;
        // cr-tooltip normally determines the target from the |for| property,
        // which is a selector. Here cr-tooltip is being reused by multiple
        // potential targets.
        this.showTooltipAtTarget(this.$.tooltip, e.detail.target);
    }
    /**
     * Populate the sites list for display.
     */
    populateList_() {
        this.browserProxy_.getExceptionList(this.category).then(exceptionList => {
            this.processExceptions_(exceptionList);
            this.closeActionMenu_();
        });
    }
    /**
     * Process the exception list returned from the native layer.
     */
    processExceptions_(exceptionList) {
        const sites = exceptionList
            .filter(site => site.setting !== ContentSetting.DEFAULT &&
            site.setting === this.categorySubtype)
            .filter(site => {
            if (this.category !== ContentSettingsTypes.COOKIES) {
                return true;
            }
            assert(this.cookiesExceptionType !== undefined);
            switch (this.cookiesExceptionType) {
                case CookiesExceptionType.THIRD_PARTY:
                    return site.origin === SITE_EXCEPTION_WILDCARD;
                case CookiesExceptionType.SITE_DATA:
                    // Site data exceptions include all exceptions that
                    // have `origin` set. This includes site data
                    // exceptions and exceptions with both patterns set
                    // (currently possible only via exceptions API).
                    return site.origin !== SITE_EXCEPTION_WILDCARD;
                case CookiesExceptionType.COMBINED:
                    // For cookies exception type COMBINED, don't apply
                    // any filters and show exceptions with both pattern
                    // types.
                    return true;
            }
        })
            .map(site => this.expandSiteException(site));
        this.updateList('sites', x => x.origin, sites);
    }
    /**
     * Set up the values to use for the action menu.
     */
    setUpActionMenu_() {
        this.showAllowAction_ = this.categorySubtype !== ContentSetting.ALLOW;
        this.showBlockAction_ = this.categorySubtype !== ContentSetting.BLOCK;
        this.showSessionOnlyAction_ =
            this.categorySubtype !== ContentSetting.SESSION_ONLY &&
                this.category === ContentSettingsTypes.COOKIES;
    }
    /**
     * @return Whether to show the "Session Only" menu item for the currently
     *     active site.
     */
    showSessionOnlyActionForSite_() {
        // It makes no sense to show "clear on exit" for exceptions that only apply
        // to incognito. It gives the impression that they might under some
        // circumstances not be cleared on exit, which isn't true.
        if (!this.actionMenuSite_ || this.actionMenuSite_.incognito) {
            return false;
        }
        return this.showSessionOnlyAction_;
    }
    setContentSettingForActionMenuSite_(contentSetting) {
        assert(this.actionMenuSite_);
        this.browserProxy.setCategoryPermissionForPattern(this.actionMenuSite_.origin, this.actionMenuSite_.embeddingOrigin, this.category, contentSetting, this.actionMenuSite_.incognito);
    }
    onAllowClick_() {
        // Removing the last visible item should focus the list's header.
        const shouldMoveFocus = this.hasOneFilteredSite_();
        this.setContentSettingForActionMenuSite_(ContentSetting.ALLOW);
        this.closeActionMenu_();
        if (shouldMoveFocus) {
            this.$.listHeader.focus();
        }
    }
    onBlockClick_() {
        // Removing the last visible item should focus the list's header.
        const shouldMoveFocus = this.hasOneFilteredSite_();
        this.setContentSettingForActionMenuSite_(ContentSetting.BLOCK);
        this.closeActionMenu_();
        if (shouldMoveFocus) {
            this.$.listHeader.focus();
        }
    }
    onSessionOnlyClick_() {
        this.setContentSettingForActionMenuSite_(ContentSetting.SESSION_ONLY);
        this.closeActionMenu_();
    }
    onEditClick_() {
        // Close action menu without resetting |this.actionMenuSite_| since it is
        // bound to the dialog.
        this.shadowRoot.querySelector('cr-action-menu').close();
        this.showEditExceptionDialog_ = true;
    }
    onEditExceptionDialogClosed_() {
        this.showEditExceptionDialog_ = false;
        this.actionMenuSite_ = null;
        if (this.activeDialogAnchor_) {
            this.activeDialogAnchor_.focus();
            this.activeDialogAnchor_ = null;
        }
    }
    onResetClick_() {
        // Removing the last visible item should focus the list's header.
        const shouldMoveFocus = this.hasOneFilteredSite_();
        assert(this.actionMenuSite_);
        this.browserProxy.resetCategoryPermissionForPattern(this.actionMenuSite_.origin, this.actionMenuSite_.embeddingOrigin, this.category, this.actionMenuSite_.incognito);
        this.closeActionMenu_();
        if (shouldMoveFocus) {
            this.$.listHeader.focus();
        }
    }
    onShowActionMenu_(e) {
        this.activeDialogAnchor_ = e.detail.anchor;
        this.actionMenuSite_ = e.detail.model;
        this.shadowRoot.querySelector('cr-action-menu').showAt(this.activeDialogAnchor_);
    }
    onResetEntry_() {
        // Removing the last visible item should focus the list's header.
        if (this.hasOneFilteredSite_()) {
            this.$.listHeader.focus();
        }
    }
    closeActionMenu_() {
        this.actionMenuSite_ = null;
        this.activeDialogAnchor_ = null;
        const actionMenu = this.shadowRoot.querySelector('cr-action-menu');
        if (actionMenu.open) {
            actionMenu.close();
        }
    }
    getFilteredSites_() {
        if (!this.searchFilter) {
            return this.sites.slice();
        }
        const propNames = ['displayName', 'origin', 'embeddingOrigin'];
        const searchFilter = this.searchFilter.toLowerCase();
        return this.sites.filter(site => propNames.some(propName => site[propName].toLowerCase().includes(searchFilter)));
    }
    hasOneFilteredSite_() {
        return this.getFilteredSites_().length === 1;
    }
    getAddButtonLabel_() {
        if (this.categorySubtype === ContentSetting.ALLOW) {
            return this.i18n('siteDataPageAddSiteToAllowListLabel');
        }
        else if (this.categorySubtype === ContentSetting.BLOCK) {
            return this.i18n('siteDataPageAddSiteToBlockListLabel');
        }
        else {
            return '';
        }
    }
}
customElements.define(SiteListElement.is, SiteListElement);

function getTemplate$1v() {
    return html `<!--_html_template_start_-->    <style include="settings-shared">#exceptionHeader{padding:0 var(--cr-section-padding)}
    </style>
    <div id="exceptionHeader">
      <h2>$i18n{siteSettingsCustomizedBehaviors}</h2>
      <div id="exceptionHeaderSubLabel" class="secondary">
        [[description]]
      </div>
    </div>
    <site-list
        category="[[category]]"
        category-subtype="[[contentSettingEnum_.BLOCK]]"
        category-header="[[blockHeader]]"
        read-only-list="[[getReadOnlyList_(readOnlyList, defaultManaged_)]]"
        search-filter="[[searchFilter]]">
    </site-list>
    <site-list
        category="[[category]]"
        category-subtype="[[contentSettingEnum_.SESSION_ONLY]]"
        category-header="$i18n{siteSettingsSessionOnly}"
        read-only-list="[[getReadOnlyList_(readOnlyList, defaultManaged_)]]"
        search-filter="[[searchFilter]]">
    </site-list>
    <site-list
        category="[[category]]"
        category-subtype="[[contentSettingEnum_.ALLOW]]"
        category-header="[[allowHeader]]"
        read-only-list="[[getReadOnlyList_(readOnlyList, defaultManaged_)]]"
        search-filter="[[searchFilter]]"
        hidden$="[[!showAllowSiteList_]]">
    </site-list>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'category-setting-exceptions' is the polymer element for showing a certain
 * category of exceptions under Site Settings.
 */
const CategorySettingExceptionsElementBase = SiteSettingsMixin(WebUiListenerMixin(PolymerElement));
class CategorySettingExceptionsElement extends CategorySettingExceptionsElementBase {
    static get is() {
        return 'category-setting-exceptions';
    }
    static get template() {
        return getTemplate$1v();
    }
    static get properties() {
        return {
            /**
             * The string description shown below the header.
             */
            description: {
                type: String,
                value: function () {
                    return loadTimeData.getString('siteSettingsCustomizedBehaviorsDescription');
                },
            },
            /**
             * Some content types (like Location) do not allow the user to manually
             * edit the exception list from within Settings.
             */
            readOnlyList: {
                type: Boolean,
                value: false,
            },
            /**
             * True if the default value is managed by a policy.
             */
            defaultManaged_: Boolean,
            /**
             * The heading text for the blocked exception list.
             */
            blockHeader: String,
            /**
             * The heading text for the allowed exception list.
             */
            allowHeader: String,
            searchFilter: String,
            /**
             * If true, displays the Allow site list. Defaults to true.
             */
            showAllowSiteList_: {
                type: Boolean,
                computed: 'computeShowAllowSiteList_(category)',
            },
            /**
             * Expose ContentSetting enum to HTML bindings.
             */
            contentSettingEnum_: {
                type: Object,
                value: ContentSetting,
            },
        };
    }
    static get observers() {
        return [
            'updateDefaultManaged_(category)',
        ];
    }
    ready() {
        super.ready();
        this.addWebUiListener('contentSettingCategoryChanged', () => this.updateDefaultManaged_());
    }
    /**
     * Hides particular category subtypes if |this.category| does not support the
     * content setting of that type.
     */
    computeShowAllowSiteList_() {
        // TODO(crbug.com/40101962): This function should return true when the
        // feature flag for Persistent Permissions is removed.
        return this.category !== ContentSettingsTypes.FILE_SYSTEM_WRITE;
    }
    /**
     * Updates whether or not the default value is managed by a policy.
     */
    updateDefaultManaged_() {
        if (this.category === undefined) {
            return;
        }
        this.browserProxy.getDefaultValueForContentType(this.category)
            .then(update => {
            this.defaultManaged_ = update.source === DefaultSettingSource.POLICY;
        });
    }
    /**
     * Returns true if this list is explicitly marked as readonly by a consumer
     * of this component or if the default value for these exceptions are managed
     * by a policy. User should not be able to set exceptions to managed default
     * values.
     */
    getReadOnlyList_() {
        return this.readOnlyList || this.defaultManaged_;
    }
}
customElements.define(CategorySettingExceptionsElement.is, CategorySettingExceptionsElement);

function getTemplate$1u() {
    return html `<!--_html_template_start_--><style include="settings-shared">#radioSection{padding:0 var(--cr-section-padding)}#radioGroupSubLabel{padding-bottom:10px}settings-collapse-radio-button{--settings-collapse-toggle-min-height:var(--cr-section-min-height)}settings-collapse-radio-button.two-line{--settings-collapse-toggle-min-height:var(--cr-section-two-line-min-height)}settings-collapse-radio-button:not(:first-of-type){--settings-collapse-separator-line:var(--cr-separator-line)}</style>
<div id="radioSection">
  <h2>[[header]]</h2>
  <div id="radioGroupSubLabel" class="secondary">
    [[description]]
  </div>
  <settings-radio-group
      id="settingsCategoryDefaultRadioGroup"
      pref="{{pref_}}"
      selectable-elements="settings-collapse-radio-button"
      on-change="onSelectedChanged_"
      group-aria-label=[[header]]>
    <settings-collapse-radio-button
        id="enabledRadioOption"
        class$="[[getEnabledButtonClass_(allowOptionSubLabel)]]"
        name="[[siteContentRadioSettingEnum_.ENABLED]]"
        pref="[[pref_]]"
        label="[[allowOptionLabel]]"
        sub-label="[[allowOptionSubLabel]]"
        disabled$="[[isRadioGroupDisabled_(category)]]"
        icon="[[allowOptionIcon]]"
        no-collapse>
    </settings-collapse-radio-button>
    <settings-collapse-radio-button
        id="disabledRadioOption"
        class$="[[getDisabledButtonClass_(blockOptionSubLabel)]]"
        name="[[siteContentRadioSettingEnum_.DISABLED]]"
        pref="[[pref_]]"
        label="[[blockOptionLabel]]"
        sub-label="[[blockOptionSubLabel]]"
        disabled$="[[isRadioGroupDisabled_(category)]]"
        icon="[[blockOptionIcon]]"
        no-collapse>
    </settings-collapse-radio-button>
  </settings-radio-group>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-category-default-radio-group' is the polymer element for showing
 * a certain category under Site Settings.
 */
/**
 * Selected content setting radio option.
 */
var SiteContentRadioSetting;
(function (SiteContentRadioSetting) {
    SiteContentRadioSetting[SiteContentRadioSetting["DISABLED"] = 0] = "DISABLED";
    SiteContentRadioSetting[SiteContentRadioSetting["ENABLED"] = 1] = "ENABLED";
})(SiteContentRadioSetting || (SiteContentRadioSetting = {}));
const SettingsCategoryDefaultRadioGroupElementBase = SiteSettingsMixin(WebUiListenerMixin(PolymerElement));
class SettingsCategoryDefaultRadioGroupElement extends SettingsCategoryDefaultRadioGroupElementBase {
    static get is() {
        return 'settings-category-default-radio-group';
    }
    static get template() {
        return getTemplate$1u();
    }
    static get properties() {
        return {
            header: {
                type: String,
                value() {
                    return loadTimeData.getString('siteSettingsDefaultBehavior');
                },
            },
            description: {
                type: String,
                value() {
                    return loadTimeData.getString('siteSettingsDefaultBehaviorDescription');
                },
            },
            allowOptionLabel: String,
            allowOptionSubLabel: String,
            allowOptionIcon: String,
            blockOptionLabel: String,
            blockOptionSubLabel: String,
            blockOptionIcon: String,
            siteContentRadioSettingEnum_: {
                type: Object,
                value: SiteContentRadioSetting,
            },
            /**
             * Preference object used to keep track of the selected content setting
             * option.
             */
            pref_: {
                type: Object,
                value() {
                    return {
                        type: chrome.settingsPrivate.PrefType.NUMBER,
                        value: -1, // No element is selected until the value is loaded.
                    };
                },
            },
        };
    }
    static get observers() {
        return [
            'onCategoryChanged_(category)',
        ];
    }
    selected;
    ready() {
        super.ready();
        this.addWebUiListener('contentSettingCategoryChanged', (category) => this.onCategoryChanged_(category));
    }
    getAllowOptionForCategory_() {
        // Keep elements in alphabetical order within their groups.
        switch (this.category) {
            case ContentSettingsTypes.ADS:
            case ContentSettingsTypes.AUTOMATIC_FULLSCREEN:
            case ContentSettingsTypes.BACKGROUND_SYNC:
            case ContentSettingsTypes.FEDERATED_IDENTITY_API:
            case ContentSettingsTypes.IMAGES:
            case ContentSettingsTypes.JAVASCRIPT:
            case ContentSettingsTypes.JAVASCRIPT_OPTIMIZER:
            case ContentSettingsTypes.MIXEDSCRIPT:
            case ContentSettingsTypes.PAYMENT_HANDLER:
            case ContentSettingsTypes.POPUPS:
            case ContentSettingsTypes.PROTECTED_CONTENT:
            case ContentSettingsTypes.PROTOCOL_HANDLERS:
            case ContentSettingsTypes.SENSORS:
            case ContentSettingsTypes.SOUND:
                // "Allowed" vs "Blocked".
                return ContentSetting.ALLOW;
            case ContentSettingsTypes.AR:
            case ContentSettingsTypes.AUTO_PICTURE_IN_PICTURE:
            case ContentSettingsTypes.AUTOMATIC_DOWNLOADS:
            case ContentSettingsTypes.BLUETOOTH_DEVICES:
            case ContentSettingsTypes.BLUETOOTH_SCANNING:
            case ContentSettingsTypes.CAMERA:
            case ContentSettingsTypes.CAPTURED_SURFACE_CONTROL:
            case ContentSettingsTypes.CLIPBOARD:
            case ContentSettingsTypes.FILE_SYSTEM_WRITE:
            case ContentSettingsTypes.GEOLOCATION:
            case ContentSettingsTypes.HAND_TRACKING:
            case ContentSettingsTypes.HID_DEVICES:
            case ContentSettingsTypes.IDLE_DETECTION:
            case ContentSettingsTypes.KEYBOARD_LOCK:
            case ContentSettingsTypes.LOCAL_FONTS:
            case ContentSettingsTypes.LOCAL_NETWORK_ACCESS:
            case ContentSettingsTypes.MIC:
            case ContentSettingsTypes.MIDI_DEVICES:
            case ContentSettingsTypes.NOTIFICATIONS:
            case ContentSettingsTypes.POINTER_LOCK:
            case ContentSettingsTypes.SERIAL_PORTS:
            case ContentSettingsTypes.SMART_CARD_READERS:
            case ContentSettingsTypes.STORAGE_ACCESS:
            case ContentSettingsTypes.USB_DEVICES:
            case ContentSettingsTypes.VR:
            case ContentSettingsTypes.WINDOW_MANAGEMENT:
            case ContentSettingsTypes.WEB_APP_INSTALLATION:
            case ContentSettingsTypes.WEB_PRINTING:
                // "Ask" vs "Blocked".
                return ContentSetting.ASK;
            default:
                assertNotReached('Invalid category: ' + this.category);
        }
    }
    getEnabledButtonClass_() {
        return this.allowOptionSubLabel ? 'two-line' : '';
    }
    getDisabledButtonClass_() {
        return this.blockOptionSubLabel ? 'two-line' : '';
    }
    /**
     * A handler for changing the default permission value for a content type.
     * This is also called during page setup after we get the default state.
     */
    onSelectedChanged_() {
        assert(this.pref_.enforcement !== chrome.settingsPrivate.Enforcement.ENFORCED);
        const allowOption = 
        /** @type {!ContentSetting} */ (this.getAllowOptionForCategory_());
        this.browserProxy.setDefaultValueForContentType(this.category, this.categoryEnabled_ ? allowOption : ContentSetting.BLOCK);
        if (this.selected !== this.categoryEnabled_) {
            this.selected = this.categoryEnabled_;
            this.dispatchEvent(new CustomEvent('selected-changed', { detail: { value: this.selected } }));
        }
    }
    /**
     * Update the pref values from the content settings.
     * @param update The updated content setting value.
     */
    updatePref_(update) {
        if (update.source !== undefined &&
            update.source !== DefaultSettingSource.PREFERENCE) {
            this.set('pref_.enforcement', chrome.settingsPrivate.Enforcement.ENFORCED);
            let controlledBy = chrome.settingsPrivate.ControlledBy.USER_POLICY;
            switch (update.source) {
                case DefaultSettingSource.POLICY:
                    controlledBy = chrome.settingsPrivate.ControlledBy.DEVICE_POLICY;
                    break;
                case DefaultSettingSource.SUPERVISED_USER:
                    controlledBy = chrome.settingsPrivate.ControlledBy.PARENT;
                    break;
                case DefaultSettingSource.EXTENSION:
                    controlledBy = chrome.settingsPrivate.ControlledBy.EXTENSION;
                    break;
            }
            this.set('pref_.controlledBy', controlledBy);
        }
        else {
            this.set('pref_.enforcement', undefined);
            this.set('pref_.controlledBy', undefined);
        }
        const enabled = isSettingEnabled(update.setting);
        const prefValue = enabled ? SiteContentRadioSetting.ENABLED :
            SiteContentRadioSetting.DISABLED;
        this.selected = enabled;
        this.set('pref_.value', prefValue);
    }
    async onCategoryChanged_(category) {
        if (category !== this.category) {
            return;
        }
        const defaultValue = await this.browserProxy.getDefaultValueForContentType(this.category);
        this.updatePref_(defaultValue);
    }
    get categoryEnabled_() {
        return this.pref_.value === SiteContentRadioSetting.ENABLED;
    }
    /**
     * Check if the category is popups and the user is logged in guest mode.
     * Users in guest mode are not allowed to modify pop-ups content setting.
     */
    isRadioGroupDisabled_() {
        return this.category === ContentSettingsTypes.POPUPS &&
            loadTimeData.getBoolean('isGuest');
    }
}
customElements.define(SettingsCategoryDefaultRadioGroupElement.is, SettingsCategoryDefaultRadioGroupElement);

const styleMod$1 = document.createElement('dom-module');
styleMod$1.appendChild(html `
  <template>
    <style include="cr-shared-style search-highlight-style">
.content-settings-header,.radio-group{padding:0 var(--cr-section-padding)}.radio-group-sub-heading{padding-bottom:10px}.padded-radio-section{padding-inline-start:50px}.cpss-heading{padding-bottom:13px;padding-top:13px}settings-collapse-radio-button{--settings-collapse-toggle-min-height:var(--cr-section-min-height)}settings-collapse-radio-button.two-line{--settings-collapse-toggle-min-height:var(--cr-section-two-line-min-height)}settings-collapse-radio-button:not(:first-of-type){--settings-collapse-separator-line:var(--cr-separator-line)}#exceptionHeader{padding:0 var(--cr-section-padding)}#exceptionHeaderSubLabel{padding-bottom:10px}
    </style>
  </template>
`.content);
styleMod$1.register('site-settings-shared');

function getTemplate$1t() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsAds}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsAdsDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.ADS]]"
      allow-option-label="$i18n{siteSettingsAdsAllowed}"
      allow-option-icon="privacy:web-asset"
      block-option-label="$i18n{siteSettingsAdsBlocked}"
      block-option-icon="privacy:web-asset-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.ADS]]"
      read-only-list
      allow-header="$i18n{siteSettingsAdsAllowedExceptions}"
      block-header="$i18n{siteSettingsAdsBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const AdsPageElementBase = SettingsViewMixin(PolymerElement);
class AdsPageElement extends AdsPageElementBase {
    static get is() {
        return 'settings-ads-page';
    }
    static get template() {
        return getTemplate$1t();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(AdsPageElement.is, AdsPageElement);

const div = document.createElement('div');
div.innerHTML = getTrustedHTML `<cr-iconset name="all-sites" size="20">
  <svg>
    <defs>
      <g id="logout" width="24px" height="24px" viewBox="0 0 24 24" fill="#757575"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm0 14.2c-2.5 0-4.71-1.28-6-3.22.03-1.99 4-3.08 6-3.08 1.99 0 5.97 1.09 6 3.08-1.29 1.94-3.5 3.22-6 3.22z"></path><path d="M0 0h24v24H0z" fill="none"></path></g>
      <g id="offline" viewBox="0 0 24 24" width="24px" height="24px" fill="#757575"><path clip-path="url(#b)" d="M12 2C6.5 2 2 6.5 2 12s4.5 10 10 10 10-4.5 10-10S17.5 2 12 2zm5 16H7v-2h10v2zm-6.7-4L7 10.7l1.4-1.4 1.9 1.9 5.3-5.3L17 7.3 10.3 14z"></path></g>
      <g id="tag" width="24px" height="24px" viewBox="0 0 24 24"><path transform="scale(-1, 1) translate(-24, 0)" d="M14.25 21.4q-.575.575-1.425.575-.85 0-1.425-.575l-8.8-8.8q-.275-.275-.437-.65Q2 11.575 2 11.15V4q0-.825.588-1.413Q3.175 2 4 2h7.15q.425 0 .8.162.375.163.65.438l8.8 8.825q.575.575.575 1.412 0 .838-.575 1.413ZM12.825 20l7.15-7.15L11.15 4H4v7.15ZM6.5 8q.625 0 1.062-.438Q8 7.125 8 6.5t-.438-1.062Q7.125 5 6.5 5t-1.062.438Q5 5.875 5 6.5t.438 1.062Q5.875 8 6.5 8ZM4 4Z"></g>
    </defs>
  </svg>
</cr-iconset>
`;
const iconsets = div.querySelectorAll('cr-iconset');
for (const iconset of iconsets) {
    document.head.appendChild(iconset);
}

const styleMod = document.createElement('dom-module');
styleMod.appendChild(html `
  <template>
    <style>
.detail-list{margin-top:12px}.detail{align-items:center;display:flex;margin-top:8px}.detail cr-icon{margin-inline-end:16px}
    </style>
  </template>
`.content);
styleMod.register('clear-storage-dialog-shared');

function getTemplate$1s() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">:host{padding:0 var(--cr-section-padding)}.row-aligned{align-items:center;display:flex}#toggleButton{min-height:var(--cr-section-min-height)}.site-representation{display:flex}.second-line{margin-top:0.1em;min-height:1.54em}.data-unit{direction:ltr;unicode-bidi:isolate}.list-frame{padding-inline-end:0}.origin-link{overflow:hidden}.spacing{padding-inline-start:1ch}
    </style>
    <div id="collapseParent" focus-row-container>
      <div class$="list-item [[getClassForIndex_(listIndex)]]">
        <div id="toggleButton" class="start row-aligned two-line text-elide"
            on-click="onSiteEntryClick_" actionable aria-expanded="false">
          <site-favicon url="[[getSiteGroupIcon_(siteGroup)]]"></site-favicon>
          <div class="middle text-elide" id="displayName">
            <div class="site-representation">
              <span class="url-directionality text-elide">
                [[displayName_]]
              </span>
              <span class="secondary"
                  hidden$="[[!siteGroupScheme_(siteGroup)]]">
                &nbsp;$i18nPolymer{siteSettingsSiteRepresentationSeparator}&nbsp;
              </span>
              <span class="secondary"
                  hidden$="[[!siteGroupScheme_(siteGroup)]]">
                [[siteGroupScheme_(siteGroup)]]
              </span>
            </div>
            <div class="second-line secondary">
              <span class="data-unit">[[overallUsageString_]]</span>
              <span id="cookies" hidden$="[[!siteGroup.numCookies]]">
                &middot; [[cookieString_]]
              </span>
              <span id="rwsMembership" hidden$=
                  "[[!isRwsMember_(siteGroup.rwsOwner, isRwsFiltered)]]">
                &middot; [[rwsMembershipLabel_]]
              </span>
              <span id="extensionIdDescription"
                  hidden$="[[!isExtension_(siteGroup)]]">
                &middot; [[extensionIdDescription_(siteGroup)]]
              </span>
            </div>
          </div>
          <template is="dom-if" restamp if="[[shouldShowPolicyPrefIndicator_(
                            siteGroup.rwsEnterpriseManaged)]]">
            <cr-policy-pref-indicator
                id="rwsPolicy" pref="[[rwsEnterprisePref_]]"
                icon-aria-label="[[label]]"
                focus-row-control focus-type="policy">
            </cr-policy-pref-indicator>
          </template>
          <cr-icon-button id="expandIcon" class="icon-expand-more"
              hidden$="[[!grouped_(siteGroup)]]" aria-label$="[[displayName_]]"
              aria-describedby="displayName" aria-expanded="false"
              focus-row-control focus-type="expand"></cr-icon-button>
          <cr-icon-button class="subpage-arrow"
              hidden$="[[grouped_(siteGroup)]]"
              aria-label$="[[getSubpageLabel_(siteGroup.displayName)]]"
              aria-roledescription="$i18n{subpageArrowRoleDescription}"
              focus-row-control focus-type="show-detail"></cr-icon-button>
        </div>
        <div class="row-aligned">
          <template is="dom-if" if=
              "[[shouldShowOverflowMenu(siteGroup.rwsOwner, isRwsFiltered)]]">
            <div class="separator"></div>
            <cr-icon-button class="icon-more-vert"
                id="rwsOverflowMenuButton"
                title="$i18n{moreActions}"
                on-click="showOverflowMenu_"
                focus-row-control focus-type="more-actions"
                aria-label$="[[getMoreActionsLabel_(siteGroup)]]">
            </cr-icon-button>
          </template>
          <template is="dom-if" if=
              "[[!shouldShowOverflowMenu(siteGroup.rwsOwner, isRwsFiltered)]]">
            <div class="separator"></div>
            <cr-icon-button class="icon-delete-gray" id="removeSiteButton"
                title$=
                  "[[i18n('siteSettingsCookieRemoveSite', displayName_)]]"
                on-click="onRemove_" focus-row-control focus-type="remove">
            </cr-icon-button>
          </template>
        </div>
      </div>

      <cr-lazy-render id="originList">
        <template>
          <cr-collapse id="collapseChild" no-animation>
            <div class="list-frame">
              <template is="dom-repeat" items="[[siteGroup.origins]]">
                <div class="list-item hr">
                  <div class="start row-aligned list-item origin-link"
                       on-click="onOriginClick_"
                       actionable$="[[!item.isPartitioned]]">
                    <site-favicon url="[[item.origin]]"></site-favicon>
                    <div class="site-representation middle text-elide">
                      <span id="originSiteRepresentation"
                          class="url-directionality text-elide">
                        [[originRepresentation(item.origin)]]
                      </span>
                      <span class="secondary"
                          hidden$="[[!originScheme_(item)]]">
                        &nbsp;
                        $i18nPolymer{siteSettingsSiteRepresentationSeparator}
                        &nbsp;
                      </span>
                      <span class="secondary"
                          hidden$="[[!originScheme_(item)]]">
                        [[originScheme_(item)]]
                      </span>
                      <!--Define a spacing span so that when the direction is
                         rtl, the spacing is still showing correctly. This is
                         because the data-unit class is set to be ltr so the
                         padding will be in wrong place if we put padding in
                         that span.-->
                      <span class="spacing" hidden$="[[!item.usage]]"></span>
                      <span class="secondary data-unit"
                            hidden$="[[!item.usage]]">
                        [[originUsagesItem_(originUsages_.*, index)]]
                      </span>
                      <span class="secondary" hidden$="[[!item.numCookies]]">
                          &nbsp;&middot;
                          [[originCookiesItem_(cookiesNum_.*, index)]]
                      </span>
                      <span class="secondary" hidden$="[[!item.isPartitioned]]">
                          &nbsp;&middot;
                          $i18n{siteSettingsSiteEntryPartitionedLabel}
                      </span>
                    </div>
                    <cr-icon-button class="subpage-arrow"
                        hidden$="[[item.isPartitioned]]"
                        aria-label$="[[getOriginSubpageLabel_(item.origin)]]"
                        aria-roledescription=
                            "$i18n{subpageArrowRoleDescription}"
                        focus-row-control focus-type="detailed-sites">
                    </cr-icon-button>
                  </div>
                  <div class="row-aligned">
                    <div class="separator"></div>
                    <cr-icon-button class="icon-delete-gray"
                        id="removeOriginButton"
                        title$="[[getRemoveOriginButtonTitle_(item.origin)]]"
                        data-origin$="[[item.origin]]" data-context="origin"
                        data-partitioned$="[[item.isPartitioned]]"
                        on-click="onRemove_" focus-row-control
                        focus-type="remove">
                    </cr-icon-button>
                  </div>
                </div>
              </template>
            </div>
          </cr-collapse>
      </template>
    </cr-lazy-render>
    </div>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'site-entry' is an element representing a single eTLD+1 site entity.
 */
const SiteEntryElementBase = FocusRowMixin(BaseMixin(SiteSettingsMixin(I18nMixin(PolymerElement))));
class SiteEntryElement extends SiteEntryElementBase {
    static get is() {
        return 'site-entry';
    }
    static get template() {
        return getTemplate$1s();
    }
    static get properties() {
        return {
            /**
             * An object representing a group of sites with the same eTLD+1.
             */
            siteGroup: {
                type: Object,
                observer: 'onSiteGroupChanged_',
            },
            /**
             * The name to display beside the icon. If grouped_() is true, it will be
             * the eTLD+1 for all the origins. For Isolated Web Apps instead of
             * displaying the origin, the short name of the app will be displayed.
             * Otherwise, it will return the host.
             */
            displayName_: String,
            /**
             * The string to display when there is a non-zero number of cookies.
             */
            cookieString_: String,
            /**
             * The related website set info for a site including owner and members
             * count.
             */
            rwsMembershipLabel_: {
                type: String,
                value: '',
            },
            /**
             * Mock preference used to power managed policy icon for related website
             * sets.
             */
            rwsEnterprisePref_: Object,
            /**
             * Whether site entry is shown with a related website set filter search.
             */
            isRwsFiltered: Boolean,
            /**
             * The position of this site-entry in its parent list.
             */
            listIndex: {
                type: Number,
                value: -1,
            },
            /**
             * The string to display showing the overall usage of this site-entry.
             */
            overallUsageString_: String,
            /**
             * An array containing the strings to display showing the individual disk
             * usage for each origin in |siteGroup|.
             */
            originUsages_: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * An array containing the strings to display showing the individual
             * cookies number for each origin in |siteGroup|.
             */
            cookiesNum_: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * The selected sort method.
             */
            sortMethod: { type: String, observer: 'updateOrigins_' },
        };
    }
    static get observers() {
        return [
            'updateRwsMembershipLabel_(siteGroup.rwsNumMembers, siteGroup.rwsOwner)',
            'updatePolicyPref_(siteGroup.rwsEnterpriseManaged)',
            'updateFocus_(siteGroup.rwsOwner)',
        ];
    }
    button_ = null;
    eventTracker_ = new EventTracker();
    disconnectedCallback() {
        super.disconnectedCallback();
        if (this.button_) {
            this.eventTracker_.remove(this.button_, 'keydown');
        }
    }
    onButtonKeydown_(e) {
        if (e.shiftKey && e.key === 'Tab') {
            this.focus();
        }
    }
    /**
     * Whether the list of origins displayed in this site-entry is a group of
     * eTLD+1 origins or not.
     * @param siteGroup The eTLD+1 group of origins.
     */
    grouped_(siteGroup) {
        if (!siteGroup) {
            return false;
        }
        if (siteGroup.origins.length > 1 ||
            siteGroup.numCookies > siteGroup.origins[0].numCookies ||
            siteGroup.origins.some(o => o.isPartitioned)) {
            return true;
        }
        return false;
    }
    /**
     * Returns a user-friendly name for the siteGroup.
     * @param siteGroup The group of origins.
     * @return The user-friendly name.
     */
    siteGroupRepresentation_(siteGroup) {
        if (!siteGroup) {
            return '';
        }
        return siteGroup.displayName;
    }
    /**
     * @param siteGroup The eTLD+1 group of origins.
     */
    onSiteGroupChanged_(siteGroup) {
        // Update the button listener.
        if (this.button_) {
            this.eventTracker_.remove(this.button_, 'keydown');
        }
        this.button_ =
            this.shadowRoot.querySelector('#toggleButton *:not([hidden])');
        assert(this.button_);
        this.eventTracker_.add(this.button_, 'keydown', (e) => this.onButtonKeydown_(e));
        if (!this.grouped_(siteGroup)) {
            // Ensure ungrouped |siteGroup|s do not get stuck in an opened state.
            const collapseChild = this.$.originList.getIfExists();
            if (collapseChild && collapseChild.opened) {
                this.toggleCollapsible_();
            }
        }
        if (!siteGroup) {
            return;
        }
        this.calculateUsageInfo_(siteGroup);
        this.getCookieNumString_(siteGroup.numCookies).then(string => {
            this.cookieString_ = string;
        });
        this.updateOrigins_(this.sortMethod);
        this.displayName_ = this.siteGroupRepresentation_(siteGroup);
    }
    /**
     * Returns any non-HTTPS scheme/protocol for the siteGroup that only contains
     * one origin. Otherwise, returns a empty string.
     * @param siteGroup The eTLD+1 group of origins.
     * @return The scheme if non-HTTPS, or empty string if HTTPS.
     */
    siteGroupScheme_(siteGroup) {
        if (!siteGroup || (this.grouped_(siteGroup))) {
            return '';
        }
        return this.originScheme_(siteGroup.origins[0]);
    }
    /**
     * Returns any non-HTTPS scheme/protocol for the origin. Otherwise, returns
     * an empty string.
     * @return The scheme if non-HTTPS, or empty string if HTTPS.
     */
    originScheme_(origin) {
        const url = this.toUrl(origin.origin);
        const scheme = url.protocol.replace(new RegExp(':*$'), '');
        const HTTPS_SCHEME = 'https';
        if (scheme === HTTPS_SCHEME) {
            return '';
        }
        return scheme;
    }
    /**
     * Get an appropriate favicon that represents this group of eTLD+1 sites as a
     * whole.
     * @param siteGroup The eTLD+1 group of origins.
     * @return URL that is used for fetching the favicon
     */
    getSiteGroupIcon_(siteGroup) {
        const origins = siteGroup.origins;
        assert(origins);
        assert(origins.length >= 1);
        if (origins.length === 1) {
            return origins[0].origin;
        }
        // If we can find a origin with format "www.etld+1", use the favicon of this
        // origin. Otherwise find the origin with largest storage, and use the
        // number of cookies as a tie breaker.
        for (const originInfo of origins) {
            if (siteGroup.etldPlus1 &&
                this.toUrl(originInfo.origin).host ===
                    'www.' + siteGroup.etldPlus1) {
                return originInfo.origin;
            }
        }
        const getMaxStorage = (max, originInfo) => {
            return (max.usage > originInfo.usage ||
                (max.usage === originInfo.usage &&
                    max.numCookies > originInfo.numCookies) ?
                max :
                originInfo);
        };
        return origins.reduce(getMaxStorage, origins[0]).origin;
    }
    /**
     * Calculates the amount of disk storage used by the given eTLD+1.
     * Also updates the corresponding display strings.
     * @param siteGroup The eTLD+1 group of origins.
     */
    calculateUsageInfo_(siteGroup) {
        let overallUsage = 0;
        siteGroup.origins.forEach(originInfo => {
            overallUsage += originInfo.usage;
        });
        this.browserProxy.getFormattedBytes(overallUsage).then(string => {
            this.overallUsageString_ = string;
        });
    }
    isRwsMember_() {
        return !!this.siteGroup && this.siteGroup.rwsOwner !== undefined;
    }
    /**
     * Evaluates whether the three dot menu should be shown for the site entry.
     * @returns True if site group is a related website set member and filter by
     * related website set owner is not applied.
     */
    shouldShowOverflowMenu() {
        return this.isRwsMember_() && !this.isRwsFiltered;
    }
    /**
     * Get display string for number of cookies.
     */
    getCookieNumString_(numCookies) {
        if (numCookies === 0) {
            return Promise.resolve('');
        }
        return this.browserProxy.getNumCookiesString(numCookies);
    }
    /**
     * Updates the display string for RWS information of owner and member count.
     * @param rwsNumMembers The number of members in the related website set.
     * @param rwsOwner The eTLD+1 for the related website set owner.
     */
    updateRwsMembershipLabel_() {
        if (!this.siteGroup.rwsOwner) {
            this.rwsMembershipLabel_ = '';
        }
        else {
            this.browserProxy
                .getRwsMembershipLabel(this.siteGroup.rwsNumMembers, this.siteGroup.rwsOwner)
                .then(label => this.rwsMembershipLabel_ = label);
        }
    }
    /**
     * Evaluates whether the policy icon should be shown.
     * @returns True when `this.siteGroup.rwsEnterpriseManaged` is true,
     * otherwise false.
     */
    shouldShowPolicyPrefIndicator_() {
        return !!this.siteGroup.rwsEnterpriseManaged;
    }
    /**
     * Updates `rwsEnterprisePref_` based on `siteGroup.rwsEnterpriseManaged`.
     */
    updatePolicyPref_() {
        this.rwsEnterprisePref_ = this.siteGroup.rwsEnterpriseManaged ?
            Object.assign({
                enforcement: chrome.settingsPrivate.Enforcement.ENFORCED,
                controlledBy: chrome.settingsPrivate.ControlledBy.DEVICE_POLICY,
            }) :
            Object.assign({
                enforcement: undefined,
                controlledBy: undefined,
            });
    }
    updateFocus_() {
        // TODO(crbug.com/40875159): Re-focusing a changed entry (such as when an
        // entry is removed from list) happens before the entry elements have been
        // updated (e.g. different buttons shown / hidden). This causes the
        // focusRowMixin to incorrectly identify an element which is about to be
        // hidden / removed as a valid focus target.
        const isCurrentlyFocused = this.isFocused;
        afterNextRender(this, () => {
            if (isCurrentlyFocused) {
                (this.shouldShowOverflowMenu() ?
                    this.$$('#rwsOverflowMenuButton') :
                    this.$$('#removeSiteButton')).focus();
            }
        });
    }
    /**
     * Array binding for the |originUsages_| array for use in the HTML.
     * @param change The change record for the array.
     * @param index The index of the array item.
     */
    originUsagesItem_(change, index) {
        return change.base[index];
    }
    /**
     * Array binding for the |cookiesNum_| array for use in the HTML.
     * @param change The change record for the array.
     * @param index The index of the array item.
     */
    originCookiesItem_(change, index) {
        return change.base[index];
    }
    /**
     * Navigates to the corresponding Site Details page for the given origin.
     * @param origin The origin to navigate to the Site Details page for it.
     */
    navigateToSiteDetails_(origin) {
        this.fire('site-entry-selected', { item: this.siteGroup, index: this.listIndex });
        Router.getInstance().navigateTo(routes.SITE_SETTINGS_SITE_DETAILS, new URLSearchParams('site=' + origin));
    }
    /**
     * A handler for selecting a site (by clicking on the origin).
     */
    onOriginClick_(e) {
        if (this.siteGroup.origins[e.model.index].isPartitioned) {
            return;
        }
        this.navigateToSiteDetails_(this.siteGroup.origins[e.model.index].origin);
        this.browserProxy.recordAction(AllSitesAction2.ENTER_SITE_DETAILS);
        chrome.metricsPrivate.recordUserAction('AllSites_EnterSiteDetails');
    }
    /**
     * A handler for clicking on a site-entry heading. This will either show a
     * list of origins or directly navigates to Site Details if there is only one.
     */
    onSiteEntryClick_() {
        // Individual origins don't expand - just go straight to Site Details.
        if (!this.grouped_(this.siteGroup)) {
            this.navigateToSiteDetails_(this.siteGroup.origins[0].origin);
            this.browserProxy.recordAction(AllSitesAction2.ENTER_SITE_DETAILS);
            chrome.metricsPrivate.recordUserAction('AllSites_EnterSiteDetails');
            return;
        }
        this.toggleCollapsible_();
        // Make sure the expanded origins can be viewed without further scrolling
        // (in case |this| is already at the bottom of the viewport).
        this.scrollIntoViewIfNeeded();
    }
    /**
     * Toggles open and closed the list of origins if there is more than one.
     */
    toggleCollapsible_() {
        const collapseChild = this.$.originList.get();
        collapseChild.toggle();
        this.$.toggleButton.setAttribute('aria-expanded', collapseChild.opened ? 'true' : 'false');
        this.$.expandIcon.setAttribute('aria-expanded', collapseChild.opened ? 'true' : 'false');
        this.$.expandIcon.classList.toggle('icon-expand-more');
        this.$.expandIcon.classList.toggle('icon-expand-less');
        this.fire('iron-resize');
    }
    /**
     * Fires a custom event when the menu button is clicked. Sends the details
     * of the site entry item and where the menu should appear.
     */
    showOverflowMenu_(e) {
        this.fire('open-menu', {
            target: e.target,
            index: this.listIndex,
            item: this.siteGroup,
            origin: e.target.dataset['origin'],
            isPartitioned: e.target.dataset['partitioned'],
            actionScope: e.target.dataset['context'],
        });
    }
    onRemove_(e) {
        this.fire('remove-site', {
            target: e.target,
            index: this.listIndex,
            item: this.siteGroup,
            origin: e.target.dataset['origin'],
            isPartitioned: e.target.dataset['partitioned'] !== undefined,
            actionScope: e.target.dataset['context'],
        });
    }
    /**
     * Returns the correct class to apply depending on this site-entry's position
     * in a list.
     */
    getClassForIndex_(index) {
        return index > 0 ? 'hr' : '';
    }
    getSubpageLabel_(target) {
        return this.i18n('siteSettingsSiteDetailsSubpageAccessibilityLabel', target);
    }
    getOriginSubpageLabel_(origin) {
        return this.getSubpageLabel_(this.originRepresentation(origin));
    }
    getRemoveOriginButtonTitle_(origin) {
        return this.i18n('siteSettingsCookieRemoveSite', this.originRepresentation(origin));
    }
    getMoreActionsLabel_() {
        return this.i18n('relatedWebsiteSetsMoreActionsTitle', this.siteGroup.displayName);
    }
    /**
     * Update the order and data display text for origins.
     */
    updateOrigins_(sortMethod) {
        if (!sortMethod || !this.siteGroup || !this.grouped_(this.siteGroup)) {
            return;
        }
        const origins = this.siteGroup.origins.slice();
        origins.sort(this.sortFunction_(sortMethod));
        this.set('siteGroup.origins', origins);
        this.originUsages_ = new Array(origins.length);
        origins.forEach((originInfo, i) => {
            this.browserProxy.getFormattedBytes(originInfo.usage).then((string) => {
                this.set(`originUsages_.${i}`, string);
            });
        });
        this.cookiesNum_ = new Array(this.siteGroup.origins.length);
        origins.forEach((originInfo, i) => {
            this.getCookieNumString_(originInfo.numCookies).then((string) => {
                this.set(`cookiesNum_.${i}`, string);
            });
        });
    }
    /**
     * Sort functions for sorting origins based on selected method.
     */
    sortFunction_(sortMethod) {
        if (sortMethod === SortMethod.MOST_VISITED) {
            return (origin1, origin2) => {
                return (origin1.isPartitioned ? 1 : 0) -
                    (origin2.isPartitioned ? 1 : 0) ||
                    origin2.engagement - origin1.engagement;
            };
        }
        else if (sortMethod === SortMethod.STORAGE) {
            return (origin1, origin2) => {
                return (origin1.isPartitioned ? 1 : 0) -
                    (origin2.isPartitioned ? 1 : 0) ||
                    origin2.usage - origin1.usage ||
                    origin2.numCookies - origin1.numCookies;
            };
        }
        else if (sortMethod === SortMethod.NAME) {
            return (origin1, origin2) => {
                return (origin1.isPartitioned ? 1 : 0) -
                    (origin2.isPartitioned ? 1 : 0) ||
                    origin1.origin.localeCompare(origin2.origin);
            };
        }
        assertNotReached();
    }
    /**
     * Get extension id description string for an extension |siteGroup|.
     */
    extensionIdDescription_(siteGroup) {
        const id = this.originRepresentation(siteGroup.origins[0].origin);
        return loadTimeData.getStringF('siteSettingsExtensionIdDescription', id);
    }
    /**
     * Check if the given |siteGroup| is an extension.
     */
    isExtension_(siteGroup) {
        return this.siteGroupScheme_(siteGroup) === 'chrome-extension';
    }
}
customElements.define(SiteEntryElement.is, SiteEntryElement);

function getTemplate$1r() {
    return html `<!--_html_template_start_-->  <style include="settings-shared md-select clear-storage-dialog-shared">cr-dialog div[slot=title]{line-height:20px}#sort{align-items:center;display:flex;margin:0 var(--cr-icon-button-margin-start);margin-bottom:8px;padding:0 var(--cr-section-padding)}#sortMethod{margin-inline-start:1em}.list-frame.without-heading{padding-inline-start:var(--cr-section-padding)}#clearAllContainer{align-items:center;display:flex;height:var(--cr-section-two-line-min-height);justify-content:space-between;margin:0 var(--cr-icon-button-margin-start);padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}#relatedWebsiteSetsLearnMore{margin:0 var(--cr-icon-button-margin-start);padding-bottom:16px;padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding);width:60%}#relatedWebsiteSetsDescription{margin:0 var(--cr-icon-button-margin-start);padding-bottom:8px;padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}#clearAllButton cr-button{white-space:nowrap}
  </style>
  <settings-subpage page-title="$i18n{siteSettingsAllSites}"
      search-label="$i18n{siteSettingsAllSitesSearch}"
      search-term="{{filter}}" preserve-search-term route-path$="[[routePath]]"
      hide-close-button>
    <div id="sort">
      <label id="sortLabel">$i18n{siteSettingsAllSitesSort}</label>
      <select id="sortMethod" class="md-select" aria-labelledby="sortLabel"
          on-change="onSortMethodChanged_">
        <option value="[[sortMethodEnum_.MOST_VISITED]]">
          $i18n{siteSettingsAllSitesSortMethodMostVisited}
        </option>
        <option value="[[sortMethodEnum_.STORAGE]]">
          $i18n{siteSettingsAllSitesSortMethodStorage}
        </option>
        <option value="[[sortMethodEnum_.NAME]]">
          $i18n{siteSettingsAllSitesSortMethodName}
        </option>
      </select>
    </div>
    <div id="clearAllContainer">
      <div id="clearLabel">
          [[getClearStorageDescription_(totalUsage_, filter, filteredList_)]]
      </div>
      <div id="clearAllButton"
          hidden$="[[!shouldShowClearAllButton_(filteredList_.length)]]">
        <cr-button type="button" on-click="onConfirmClearAllData_">
          [[getClearDataButtonString_(filter)]]
        </cr-button>
      </div>
    </div>
    <div id="relatedWebsiteSetsLearnMore"
        hidden$="[[!hasFilteredRwsSites_(filter, filteredList_)]]">
      [[getRwsLearnMoreLabel_(filter)]]
      <a href="$i18n{relatedWebsiteSetsLearnMoreURL}"
          aria-label="$i18n{siteSettingsRelatedWebsiteSetsLearnMoreAccessibility}">
        $i18n{learnMore}
      </a>
    </div>
    <div class="list-frame" hidden$="[[!siteGroupMapEmpty_(siteGroupMap)]]">
      <div class="list-item secondary">$i18n{emptyAllSitesPage}</div>
    </div>
    <div id="noSitesFoundText" class="list-frame"
        hidden$="[[!noSearchResultFound_(filteredList_)]]">
      <div class="list-item secondary">$i18n{noSitesFound}</div>
    </div>
    <div class="list-frame without-heading" id="listContainer">
      <iron-list id="allSitesList"
          items="[[filteredList_]]"
          scroll-target="[[subpageScrollTarget]]">
        <template>
          <site-entry site-group="[[item]]" list-index="[[index]]"
              iron-list-tab-index="[[tabIndex]]"
              focus-row-index="[[index]]"
              tabindex$="[[tabIndex]]"
              last-focused="{{lastFocused_}}"
              list-blurred="{{listBlurred_}}"
              sort-method="[[sortMethod_]]"
              is-rws-filtered="[[isRwsFiltered_(filter)]]">
          </site-entry>
        </template>
      </iron-list>
    </div>

    <!-- Overflow menu. -->
    <cr-lazy-render id="menu">
      <template>
        <cr-action-menu role-description="$i18n{menu}">
          <button class="dropdown-item" role="menuitem"
              on-click="onShowRelatedSites_">
            $i18n{relatedWebsiteSetsShowRelatedSitesButton}
          </button>
          <button class="dropdown-item" role="menuitem" on-click="onRemove_">
            $i18n{relatedWebsiteSetsSiteDeleteStorageButton}
          </button>
        </cr-action-menu>
      </template>
    </cr-lazy-render>

    <!-- Confirm remove site dialog. -->
    <cr-lazy-render id="confirmRemoveSite">
      <template>
        <cr-dialog close-text="$i18n{close}">
          <div id="removeSiteTitle" slot="title">
            [[getRemoveSiteTitle_(actionMenuModel_)]]
          </div>
          <div slot="body">
            <div id="logoutBulletPoint" class="detail">
              <cr-icon icon="all-sites:logout" aria-hidden="true"
                role="presentation"></cr-icon>
              [[getRemoveSiteLogoutBulletPoint_(actionMenuModel_)]]
            </div>
            <div class="detail">
              <cr-icon icon="all-sites:offline" aria-hidden="true"
                role="presentation"></cr-icon>
              $i18n{siteSettingsRemoveSiteOfflineData}
            </div>
            <div id="permissionsBulletPoint" class="detail"
                hidden$="[[!showPermissionsBulletPoint_(actionMenuModel_)]]">
              <cr-icon icon="privacy:page-info"></cr-icon>
              $i18n{siteSettingsRemoveSitePermissions}
            </div>
          </div>
          <div slot="button-container">
            <cr-button class="cancel-button" on-click="onCloseDialog_">
              $i18n{cancel}
            </cr-button>
            <cr-button class="action-button" on-click="onConfirmRemoveSite_">
              $i18n{siteSettingsRemoveSiteConfirm}
            </cr-button>
          </div>
        </cr-dialog>
      </template>
    </cr-lazy-render>

    <!-- Confirm clear all data dialog. -->
    <cr-lazy-render id="confirmClearAllData">
      <template>
        <cr-dialog close-text="$i18n{close}">
          <div slot="title">[[getClearAllStorageDialogTitle_(filter)]]</div>
          <div slot="body">
            <div id="clearAllStorageDialogDescription">
              [[getClearAllStorageDialogDescription_(totalUsage_,
                  filteredList_)]]
            </div>
            <div class="detail-list">
              <div id="clearAllStorageDialogSignOutLabel" class="detail">
                <cr-icon icon="all-sites:logout" aria-hidden="true"
                  role="presentation"></cr-icon>
                [[getClearAllStorageDialogSignOutLabel_(filter)]]
              </div>
              <div class="detail">
                <cr-icon icon="all-sites:offline" aria-hidden="true"
                  role="presentation"></cr-icon>
                $i18n{siteSettingsSiteGroupDeleteOfflineData}
              </div>
            </div>
          </div>
          <div slot="button-container">
            <cr-button class="cancel-button" on-click="onCloseDialog_">
              $i18n{cancel}
            </cr-button>
            <cr-button class="action-button" on-click="onClearAllData_">
              $i18n{siteSettingsSiteClearStorage}
            </cr-button>
          </div>
        </cr-dialog>
      </template>
    </cr-lazy-render>
  </settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'all-sites' is the polymer element for showing the list of all sites under
 * Site Settings.
 */
const AllSitesElementBase = SettingsViewMixin(GlobalScrollTargetMixin(WebUiListenerMixin(I18nMixin(SiteSettingsMixin(PolymerElement)))));
const RWS_RELATED_SEARCH_PREFIX = 'related:';
class AllSitesElement extends AllSitesElementBase {
    static get is() {
        return 'all-sites';
    }
    static get template() {
        return getTemplate$1r();
    }
    static get properties() {
        return {
            // TODO(crbug.com/40112954): Refactor siteGroupMap to use an Object
            // instead of a Map so that it's observable by Polymer more naturally. As
            // it stands, one cannot use computed properties based off the value of
            // siteGroupMap nor can one use observable functions to listen to changes
            // to siteGroupMap.
            /**
             * Map containing sites to display in the widget, grouped into their
             * group names.
             */
            siteGroupMap: {
                type: Object,
                value() {
                    return new Map();
                },
            },
            /**
             * Filtered site group list.
             */
            filteredList_: {
                type: Array,
            },
            /**
             * Needed by GlobalScrollTargetMixin.
             */
            subpageRoute: {
                type: Object,
                value: routes.SITE_SETTINGS_ALL,
                readOnly: true,
            },
            /**
             * The search query entered into the All Sites search textbox. Used to
             * filter the All Sites list.
             */
            filter: {
                type: String,
                value: '',
                observer: 'forceListUpdate_',
            },
            /**
             * All possible sort methods.
             */
            sortMethodEnum_: {
                type: Object,
                value: SortMethod,
                readOnly: true,
            },
            /**
             * Stores the last selected item in the All Sites list.
             */
            selectedItem_: Object,
            /**
             * Used to track the last-focused element across rows for the
             * FocusRowMixin.
             */
            lastFocused_: Object,
            /**
             * Used to track whether the list of row items has been blurred for the
             * FocusRowMixin.
             */
            listBlurred_: Boolean,
            actionMenuModel_: Object,
            /**
             * Used to determine if user is attempting to clear all site data
             * rather than a single site or origin's data.
             */
            clearAllData_: Boolean,
            /**
             * The selected sort method.
             */
            sortMethod_: String,
            /**
             * The total usage of all sites for this profile.
             */
            totalUsage_: {
                type: String,
                value: '0 B',
            },
        };
    }
    metricsBrowserProxy = MetricsBrowserProxyImpl.getInstance();
    ready() {
        super.ready();
        this.addWebUiListener('onStorageListFetched', this.onStorageListFetched.bind(this));
        this.addEventListener('site-entry-selected', (e) => {
            this.selectedItem_ = e.detail;
        });
        this.addEventListener('open-menu', this.onOpenMenu_.bind(this));
        this.addEventListener('remove-site', this.onRemoveSite_.bind(this));
        const sortParam = Router.getInstance().getQueryParameters().get('sort');
        if (sortParam !== null &&
            Object.values(SortMethod).includes(sortParam)) {
            this.$.sortMethod.value = sortParam;
        }
        this.sortMethod_ = this.$.sortMethod.value;
    }
    connectedCallback() {
        super.connectedCallback();
        // Set scrollOffset so the iron-list scrolling accounts for the space the
        // title takes.
        afterNextRender(this, () => {
            this.$.allSitesList.scrollOffset = this.$.allSitesList.offsetTop;
        });
    }
    /**
     * Reload the site list when the all sites page is visited.
     *
     * RouteObserverBehavior
     */
    currentRouteChanged(currentRoute, oldRoute) {
        super.currentRouteChanged(currentRoute, oldRoute);
        if (currentRoute === routes.SITE_SETTINGS_ALL &&
            currentRoute !== oldRoute) {
            this.populateList_();
        }
    }
    /**
     * Retrieves a list of all known sites with site details.
     */
    populateList_() {
        this.browserProxy.getAllSites().then((response) => {
            // Create a new map to make an observable change.
            const newMap = new Map(this.siteGroupMap);
            response.forEach(siteGroup => {
                newMap.set(siteGroup.groupingKey, siteGroup);
            });
            this.siteGroupMap = newMap;
            this.forceListUpdate_();
        });
    }
    /**
     * Integrate sites using storage into the existing sites map, as there
     * may be overlap between the existing sites.
     * @param list The list of sites using storage.
     */
    onStorageListFetched(list) {
        // Create a new map to make an observable change.
        const newMap = new Map(this.siteGroupMap);
        list.forEach(storageSiteGroup => {
            newMap.set(storageSiteGroup.groupingKey, storageSiteGroup);
        });
        this.siteGroupMap = newMap;
        this.forceListUpdate_();
        this.focusOnLastSelectedEntry_();
    }
    /**
     * Update the total usage by all sites for this profile after updates
     * to the list
     */
    updateTotalUsage_() {
        let usageSum = 0;
        for (const siteGroup of this.filteredList_) {
            siteGroup.origins.forEach(origin => {
                usageSum += origin.usage;
            });
        }
        this.browserProxy.getFormattedBytes(usageSum).then(totalUsage => {
            this.totalUsage_ = totalUsage;
        });
    }
    /**
     * Filters the all sites list with the given search query text.
     * @param siteGroupMap The map of sites to filter.
     * @param searchQuery The filter text.
     */
    filterPopulatedList_(siteGroupMap, searchQuery) {
        const result = [];
        for (const [_groupingKey, siteGroup] of siteGroupMap) {
            if (this.isRwsFiltered_()) {
                const rwsOwnerFilter = this.filter.substring(this.filter.indexOf(':') + 1);
                // Checking `siteGroup.rwsOwner` to ensure that we're not matching with
                // site entries that are not a member of a related website set.
                if (siteGroup.rwsOwner && siteGroup.rwsOwner === rwsOwnerFilter) {
                    result.push(siteGroup);
                }
            }
            else {
                if (siteGroup.origins.find(originInfo => originInfo.origin.includes(searchQuery))) {
                    result.push(siteGroup);
                }
            }
        }
        return this.sortSiteGroupList_(result);
    }
    /**
     * Sorts the given SiteGroup list with the currently selected sort method.
     * @param siteGroupList The list of sites to sort.
     */
    sortSiteGroupList_(siteGroupList) {
        const sortMethod = this.$.sortMethod.value;
        if (!sortMethod) {
            return siteGroupList;
        }
        if (sortMethod === SortMethod.MOST_VISITED) {
            siteGroupList.sort(this.mostVisitedComparator_);
        }
        else if (sortMethod === SortMethod.STORAGE) {
            siteGroupList.sort(this.storageComparator_);
        }
        else if (sortMethod === SortMethod.NAME) {
            siteGroupList.sort(this.nameComparator_);
        }
        return siteGroupList;
    }
    /**
     * Comparator used to sort SiteGroups by the amount of engagement the user has
     * with the origins listed inside it. Note only the maximum engagement is used
     * for each SiteGroup (as opposed to the sum) in order to prevent domains with
     * higher numbers of origins from always floating to the top of the list.
     */
    mostVisitedComparator_(siteGroup1, siteGroup2) {
        const getMaxEngagement = (max, originInfo) => {
            return (max > originInfo.engagement) ? max : originInfo.engagement;
        };
        const score1 = siteGroup1.origins.reduce(getMaxEngagement, 0);
        const score2 = siteGroup2.origins.reduce(getMaxEngagement, 0);
        return score2 - score1;
    }
    /**
     * Comparator used to sort SiteGroups by the amount of storage they use. Note
     * this sorts in descending order.
     */
    storageComparator_(siteGroup1, siteGroup2) {
        const getOverallUsage = (siteGroup) => {
            let usage = 0;
            siteGroup.origins.forEach(originInfo => {
                usage += originInfo.usage;
            });
            return usage;
        };
        const siteGroup1Size = getOverallUsage(siteGroup1);
        const siteGroup2Size = getOverallUsage(siteGroup2);
        // Use the number of cookies as a tie breaker.
        return siteGroup2Size - siteGroup1Size ||
            siteGroup2.numCookies - siteGroup1.numCookies;
    }
    /**
     * Comparator used to sort SiteGroups by their eTLD+1 name (domain).
     */
    nameComparator_(siteGroup1, siteGroup2) {
        return siteGroup1.displayName.localeCompare(siteGroup2.displayName);
    }
    /**
     * Called when the user chooses a different sort method to the default.
     */
    onSortMethodChanged_() {
        this.sortMethod_ = this.$.sortMethod.value;
        this.filteredList_ = this.sortSiteGroupList_(this.filteredList_);
        // Force the iron-list to rerender its items, as the order has changed.
        this.$.allSitesList.fire('iron-resize');
    }
    /**
     * Forces the all sites list to update its list of items, taking into account
     * the search query and the sort method, then re-renders it.
     */
    forceListUpdate_() {
        this.filteredList_ =
            this.filterPopulatedList_(this.siteGroupMap, this.filter);
        this.updateTotalUsage_();
        this.$.allSitesList.fire('iron-resize');
    }
    forceListUpdateForTesting() {
        this.forceListUpdate_();
    }
    /**
     * @return Whether the |siteGroupMap| is empty.
     */
    siteGroupMapEmpty_() {
        return !this.siteGroupMap.size;
    }
    /**
     * @return Whether the |filteredList_| is empty due to searching.
     */
    noSearchResultFound_() {
        return !this.filteredList_.length && !this.siteGroupMapEmpty_();
    }
    /**
     * Focus on previously selected entry.
     */
    focusOnLastSelectedEntry_() {
        if (!this.selectedItem_ || this.siteGroupMap.size === 0) {
            return;
        }
        // Focus the site-entry to ensure the iron-list renders it, otherwise
        // the query selector will not be able to find it. Note the index is
        // used here instead of the item, in case the item was already removed.
        const index = Math.max(0, Math.min(this.selectedItem_.index, this.siteGroupMap.size));
        this.$.allSitesList.focusItem(index);
        this.selectedItem_ = null;
    }
    /**
     * Open the overflow menu and ensure that the item is visible in the scroll
     * pane when its menu is opened (it is possible to open off-screen items using
     * keyboard shortcuts).
     */
    onOpenMenu_(e) {
        const index = e.detail.index;
        const list = this.$.allSitesList;
        if (index < list.firstVisibleIndex || index > list.lastVisibleIndex) {
            list.scrollToIndex(index);
        }
        const target = e.detail.target;
        this.actionMenuModel_ = e.detail;
        this.$.menu.get().showAt(target);
    }
    shouldShowClearAllButton_() {
        return this.filteredList_.length > 0;
    }
    hasFilteredRwsSites_() {
        return this.isRwsFiltered_() && this.filteredList_ &&
            this.filteredList_.length > 0;
    }
    onShowRelatedSites_() {
        this.browserProxy.recordAction(AllSitesAction2.FILTER_BY_FPS_OWNER);
        this.$.menu.get().close();
        const siteGroup = this.filteredList_[this.actionMenuModel_.index];
        const searchParams = new URLSearchParams('searchSubpage=' +
            encodeURIComponent(RWS_RELATED_SEARCH_PREFIX + siteGroup.rwsOwner));
        const currentRoute = Router.getInstance().getCurrentRoute();
        Router.getInstance().navigateTo(currentRoute, searchParams);
    }
    onRemoveSite_(e) {
        this.actionMenuModel_ = e.detail;
        this.$.confirmRemoveSite.get().showModal();
    }
    onRemove_() {
        this.$.confirmRemoveSite.get().showModal();
    }
    // Creates a placeholder origin used to hold cookies scoped at the eTLD+1
    // level.
    generatePlaceholderOrigin_(numCookies, origin, etldPlus1) {
        return {
            origin: etldPlus1 ? `http://${etldPlus1}/` : origin,
            engagement: 0,
            usage: 0,
            numCookies: numCookies,
            hasPermissionSettings: false,
            isInstalled: false,
            isPartitioned: false,
        };
    }
    onConfirmRemoveSite_(e) {
        const { index, actionScope, origin, isPartitioned } = this.actionMenuModel_;
        const siteGroupToUpdate = this.filteredList_[index];
        const updatedSiteGroup = {
            groupingKey: siteGroupToUpdate.groupingKey,
            displayName: siteGroupToUpdate.displayName,
            hasInstalledPWA: siteGroupToUpdate.hasInstalledPWA,
            numCookies: siteGroupToUpdate.numCookies,
            rwsOwner: siteGroupToUpdate.rwsOwner,
            rwsNumMembers: siteGroupToUpdate.rwsNumMembers,
            origins: [],
        };
        this.metricsBrowserProxy.recordDeleteBrowsingDataAction(DeleteBrowsingDataAction.SITES_SETTINGS_PAGE);
        if (actionScope === 'origin') {
            if (isPartitioned) {
                this.browserProxy.recordAction(AllSitesAction2.REMOVE_ORIGIN_PARTITIONED);
                this.browserProxy.clearPartitionedOriginDataAndCookies(this.toUrl(origin).href, siteGroupToUpdate.groupingKey);
            }
            else {
                this.browserProxy.recordAction(AllSitesAction2.REMOVE_ORIGIN);
                this.browserProxy.clearUnpartitionedOriginDataAndCookies(this.toUrl(origin).href);
                this.resetPermissionsForOrigin_(origin);
            }
            updatedSiteGroup.origins = siteGroupToUpdate.origins.filter(o => (o.isPartitioned !== isPartitioned || o.origin !== origin));
            updatedSiteGroup.hasInstalledPWA =
                updatedSiteGroup.origins.some(o => o.isInstalled);
            updatedSiteGroup.numCookies -=
                siteGroupToUpdate.origins
                    .find(o => o.isPartitioned === isPartitioned &&
                    o.origin === origin).numCookies;
            if (updatedSiteGroup.origins.length === 0 &&
                updatedSiteGroup.numCookies > 0) {
                const originPlaceHolder = this.generatePlaceholderOrigin_(updatedSiteGroup.numCookies, origin, updatedSiteGroup.etldPlus1);
                updatedSiteGroup.origins.push(originPlaceHolder);
            }
        }
        else {
            this.browserProxy.recordAction(AllSitesAction2.REMOVE_SITE_GROUP);
            this.browserProxy.clearSiteGroupDataAndCookies(siteGroupToUpdate.groupingKey);
            siteGroupToUpdate.origins.forEach(originEntry => {
                this.resetPermissionsForOrigin_(originEntry.origin);
            });
            if (updatedSiteGroup.rwsOwner) {
                this.decrementRwsNumMembers_(updatedSiteGroup.rwsOwner);
            }
        }
        this.updateSiteGroup_(index, updatedSiteGroup);
        this.$.allSitesList.fire('iron-resize');
        this.updateTotalUsage_();
        this.onCloseDialog_(e);
    }
    /**
     * Checks if a filter is applied.
     * @return True if a filter is applied.
     */
    isFiltered_() {
        return this.filter !== '';
    }
    /**
     * Checks if a related website set search filter is applied.
     * @return True if filter starts with `RWS_RELATED_SEARCH_PREFIX`.
     */
    isRwsFiltered_() {
        return this.filter.startsWith(RWS_RELATED_SEARCH_PREFIX);
    }
    getRwsLearnMoreLabel_() {
        const rwsOwner = this.filter.substring(this.filter.indexOf(':') + 1);
        return loadTimeData.getStringF('siteSettingsRelatedWebsiteSetsLearnMore', rwsOwner);
    }
    /**
     * Selects the appropriate string to display for clear button based on whether
     * a filter is applied.
     * @return The appropriate |clearAllButton| string based on whether a filter
     *     is applied.
     */
    getClearDataButtonString_() {
        return this.i18n(this.isFiltered_() ? 'siteSettingsDeleteDisplayedStorageLabel' :
            'siteSettingsDeleteAllStorageLabel');
    }
    /**
     * Selects the appropriate string to display for total usage based on whether
     * a filter is applied.
     * @return The appropriate |clearLabel| string based on whether a filter
     *     is applied.
     */
    getClearStorageDescription_() {
        const descriptionId = this.isFiltered_() ?
            'siteSettingsClearDisplayedStorageDescription' :
            'siteSettingsClearAllStorageDescription';
        return loadTimeData.substituteString(this.i18n(descriptionId), this.totalUsage_);
    }
    /**
     * Confirms the clearing of all storage data for all sites.
     */
    onConfirmClearAllData_(e) {
        e.preventDefault();
        this.clearAllData_ = true;
        const anyAppsInstalled = this.filteredList_.some(g => g.hasInstalledPWA);
        const scopes = [AllSitesDialog.CLEAR_DATA, 'All'];
        const installed = anyAppsInstalled ? 'Installed' : '';
        this.recordUserAction_([...scopes, installed, 'DialogOpened']);
        this.$.confirmClearAllData.get().showModal();
    }
    onCloseDialog_(e) {
        chrome.metricsPrivate.recordUserAction('AllSites_DialogClosed');
        e.target.closest('cr-dialog').close();
        this.actionMenuModel_ = null;
        this.$.menu.get().close();
    }
    getRemoveSiteTitle_() {
        if (this.actionMenuModel_ === null) {
            return '';
        }
        const originScoped = this.actionMenuModel_.actionScope === 'origin';
        const singleOriginSite = !originScoped && this.actionMenuModel_.item.origins.length === 1;
        if (this.actionMenuModel_.isPartitioned) {
            assert(originScoped);
            return loadTimeData.substituteString(this.i18n('siteSettingsRemoveSiteOriginPartitionedDialogTitle', this.originRepresentation(this.actionMenuModel_.origin), this.actionMenuModel_.item.displayName));
        }
        const numInstalledApps = this.actionMenuModel_.item.origins
            .filter(o => !originScoped || this.actionMenuModel_.origin === o.origin)
            .filter(o => o.isInstalled)
            .length;
        let messageId;
        if (originScoped || singleOriginSite) {
            if (numInstalledApps === 1) {
                messageId = 'siteSettingsRemoveSiteOriginAppDialogTitle';
            }
            else {
                assert(numInstalledApps === 0);
                messageId = 'siteSettingsRemoveSiteOriginDialogTitle';
            }
        }
        else {
            if (numInstalledApps > 1) {
                messageId = 'siteSettingsRemoveSiteGroupAppPluralDialogTitle';
            }
            else if (numInstalledApps === 1) {
                messageId = 'siteSettingsRemoveSiteGroupAppDialogTitle';
            }
            else {
                messageId = 'siteSettingsRemoveSiteGroupDialogTitle';
            }
        }
        let displayOrigin;
        if (originScoped) {
            displayOrigin = this.actionMenuModel_.origin;
        }
        else if (singleOriginSite) {
            displayOrigin = this.actionMenuModel_.item.origins[0].origin;
        }
        else {
            displayOrigin = this.actionMenuModel_.item.displayName;
        }
        return loadTimeData.substituteString(this.i18n(messageId), this.originRepresentation(displayOrigin));
    }
    getRemoveSiteLogoutBulletPoint_() {
        if (this.actionMenuModel_ === null) {
            return '';
        }
        const originScoped = this.actionMenuModel_.actionScope === 'origin';
        const singleOriginSite = !originScoped && this.actionMenuModel_.item.origins.length === 1;
        return originScoped || singleOriginSite ?
            this.i18n('siteSettingsRemoveSiteOriginLogout') :
            this.i18n('siteSettingsRemoveSiteGroupLogout');
    }
    showPermissionsBulletPoint_() {
        if (this.actionMenuModel_ === null) {
            return false;
        }
        // If the selected item if a site group, search all child origins for
        // permissions. If it is not, only look at the relevant origin.
        return this.actionMenuModel_.item.origins
            .filter(o => this.actionMenuModel_.actionScope !== 'origin' ||
            this.actionMenuModel_.origin === o.origin)
            .some(o => o.hasPermissionSettings);
    }
    /**
     * Selects the appropriate title to display for clear storage confirmation
     * dialog based on whether a filter is applied.
     * @return The appropriate title for clear storage confirmation dialog.
     */
    getClearAllStorageDialogTitle_() {
        return this.i18n(this.isFiltered_() ? 'siteSettingsDeleteDisplayedStorageDialogTitle' :
            'siteSettingsDeleteAllStorageDialogTitle');
    }
    /**
     * Get the appropriate label for the clear data confirmation dialog, depending
     * on whether any apps are installed, a filter is applied, and/or the RWS V2
     * view is shown.
     * @return The appropriate description for clear data confirmation dialog.
     */
    getClearAllStorageDialogDescription_() {
        const anyAppsInstalled = this.filteredList_.some(g => g.hasInstalledPWA);
        let messageId;
        if (anyAppsInstalled) {
            messageId = this.isFiltered_() ?
                'siteSettingsDeleteDisplayedStorageConfirmationInstalled' :
                'siteSettingsDeleteAllStorageConfirmationInstalled';
        }
        else {
            messageId = this.isFiltered_() ?
                'siteSettingsDeleteDisplayedStorageConfirmation' :
                'siteSettingsDeleteAllStorageConfirmation';
        }
        return loadTimeData.substituteString(this.i18n(messageId), this.totalUsage_);
    }
    /**
     * Selects the appropriate string to display for the sign-out string in
     * confirmation popup based on whether a filter is applied.
     * @return The appropriate sign out confirmation string based on whether a
     *     filter is applied and/or the RWS V2 view is shown.
     */
    getClearAllStorageDialogSignOutLabel_() {
        return this.i18n(this.isFiltered_() ? 'siteSettingsClearDisplayedStorageSignOut' :
            'siteSettingsClearAllStorageSignOut');
    }
    recordUserAction_(scopes) {
        chrome.metricsPrivate.recordUserAction(['AllSites', ...scopes].filter(Boolean).join('_'));
    }
    /**
     * Decrements the number of rws members for a given owner eTLD+1 by 1.
     * @param rwsOwner The related website set owner.
     */
    decrementRwsNumMembers_(rwsOwner) {
        this.filteredList_.forEach((siteGroup, index) => {
            if (siteGroup.rwsOwner === rwsOwner) {
                this.set('filteredList_.' + index + '.rwsNumMembers', siteGroup.rwsNumMembers - 1);
            }
        });
    }
    /**
     * Resets all permission settings for a single origin.
     */
    resetPermissionsForOrigin_(origin) {
        this.browserProxy.setOriginPermissions(origin, null, ContentSetting.DEFAULT);
    }
    /**
     * Helper to remove data and cookies for a group.
     * @param index The index of the target siteGroup in filteredList_ that should
     *     be cleared.
     */
    clearDataForSiteGroupIndex_(index) {
        const siteGroupToUpdate = this.filteredList_[index];
        const updatedSiteGroup = {
            groupingKey: siteGroupToUpdate.groupingKey,
            displayName: siteGroupToUpdate.displayName,
            hasInstalledPWA: siteGroupToUpdate.hasInstalledPWA,
            numCookies: 0,
            rwsOwner: siteGroupToUpdate.rwsOwner,
            rwsNumMembers: siteGroupToUpdate.rwsNumMembers,
            origins: [],
        };
        this.browserProxy.clearSiteGroupDataAndCookies(siteGroupToUpdate.groupingKey);
        for (let i = 0; i < siteGroupToUpdate.origins.length; ++i) {
            const updatedOrigin = Object.assign({}, siteGroupToUpdate.origins[i]);
            if (updatedOrigin.hasPermissionSettings) {
                updatedOrigin.numCookies = 0;
                updatedOrigin.usage = 0;
                updatedSiteGroup.origins.push(updatedOrigin);
            }
        }
        this.updateSiteGroup_(index, updatedSiteGroup);
    }
    /**
     * Updates the UI after permissions have been reset or data/cookies
     * have been cleared
     * @param index The index of the target siteGroup in filteredList_ that should
     *     be updated.
     * @param updatedSiteGroup The SiteGroup object that represents the new state.
     */
    updateSiteGroup_(index, updatedSiteGroup) {
        if (updatedSiteGroup.origins.length > 0) {
            this.set('filteredList_.' + index, updatedSiteGroup);
            this.siteGroupMap.set(updatedSiteGroup.groupingKey, updatedSiteGroup);
        }
        else {
            this.splice('filteredList_', index, 1);
            this.siteGroupMap.delete(updatedSiteGroup.groupingKey);
        }
    }
    /**
     * Clear data and cookies for all sites.
     */
    onClearAllData_(e) {
        this.browserProxy.recordAction(AllSitesAction2.CLEAR_ALL_DATA);
        const scopes = [AllSitesDialog.CLEAR_DATA, 'All'];
        const anyAppsInstalled = this.filteredList_.some(g => g.hasInstalledPWA);
        const installed = anyAppsInstalled ? 'Installed' : '';
        this.recordUserAction_([...scopes, installed, 'Confirm']);
        this.metricsBrowserProxy.recordDeleteBrowsingDataAction(DeleteBrowsingDataAction.SITES_SETTINGS_PAGE);
        if (this.isRwsFiltered_()) {
            this.browserProxy.recordAction(AllSitesAction2.DELETE_FOR_ENTIRE_FPS);
        }
        for (let index = this.filteredList_.length - 1; index >= 0; index--) {
            this.clearDataForSiteGroupIndex_(index);
        }
        // Needed to update the filteredList_ for the "No sites found" text to
        // appear.
        this.forceListUpdate_();
        this.totalUsage_ = '0 B';
        this.onCloseDialog_(e);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(AllSitesElement.is, AllSitesElement);

function getTemplate$1q() {
    return html `<!--_html_template_start_--><style include="settings-shared settings-columned-section"></style>
<settings-subpage page-title="$i18n{siteSettingsAntiAbuse}"
    route-path$="[[routePath]]">
  <settings-toggle-button
      id="toggleButton"
      pref="{{pref_}}"
      no-set-pref
      label="$i18n{siteSettingsAntiAbuse}"
      sub-label="$i18n{siteSettingsAntiAbuseDescription}"
      disabled="[[toggleDisabled_]]"
      on-settings-boolean-control-change="onToggleChange_">
  </settings-toggle-button>
  <div class="settings-columned-section">
    <div class="column">
      <h2 class="description-header">$i18n{columnHeadingWhenOn}</h2>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:archive" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{antiAbuseWhenOnSectionOne}</div>
        </li>
        <li>
          <cr-icon icon="settings20:dashboard" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{antiAbuseWhenOnSectionTwo}</div>
        </li>
        <li>
          <cr-icon icon="settings20:timer" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{antiAbuseWhenOnSectionThree}</div>
        </li>
      </ul>
    </div>
    <div class="column">
      <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:background-replace" aria-hidden="true">
          </cr-icon>
          <div class="secondary">$i18n{antiAbuseThingsToConsiderSectionOne}</div>
        </li>
      </ul>
    </div>
  </div>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-anti-abuse-page' is the settings page containing anti-abuse
 * settings.
 */
const AntiAbuseElementBase = SettingsViewMixin(SiteSettingsMixin(WebUiListenerMixin(PolymerElement)));
class SettingsAntiAbusePageElement extends AntiAbuseElementBase {
    static get is() {
        return 'settings-anti-abuse-page';
    }
    static get template() {
        return getTemplate$1q();
    }
    static get properties() {
        return {
            /**
             * Preference object used to keep track of the selected content setting
             * option.
             */
            pref_: {
                type: Object,
                value() {
                    return { type: chrome.settingsPrivate.PrefType.BOOLEAN };
                },
            },
            toggleDisabled_: Boolean,
        };
    }
    static get observers() {
        return [
            'onEnforcementChanged_(pref_.enforcement)',
        ];
    }
    ready() {
        super.ready();
        this.addWebUiListener('contentSettingCategoryChanged', (category) => this.onCategoryChanged_(category));
        this.updateToggleValue_();
    }
    onCategoryChanged_(category) {
        if (category !== ContentSettingsTypes.ANTI_ABUSE) {
            return;
        }
        this.updateToggleValue_();
    }
    onEnforcementChanged_(enforcement) {
        this.toggleDisabled_ =
            enforcement === chrome.settingsPrivate.Enforcement.ENFORCED;
    }
    async updateToggleValue_() {
        const defaultValue = await this.browserProxy.getDefaultValueForContentType(ContentSettingsTypes.ANTI_ABUSE);
        if (defaultValue.source !== undefined &&
            defaultValue.source !== DefaultSettingSource.PREFERENCE) {
            this.set('pref_.enforcement', chrome.settingsPrivate.Enforcement.ENFORCED);
            let controlledBy = chrome.settingsPrivate.ControlledBy.USER_POLICY;
            switch (defaultValue.source) {
                case DefaultSettingSource.POLICY:
                    controlledBy = chrome.settingsPrivate.ControlledBy.DEVICE_POLICY;
                    break;
                case DefaultSettingSource.SUPERVISED_USER:
                    controlledBy = chrome.settingsPrivate.ControlledBy.PARENT;
                    break;
                case DefaultSettingSource.EXTENSION:
                    controlledBy = chrome.settingsPrivate.ControlledBy.EXTENSION;
                    break;
            }
            this.set('pref_.controlledBy', controlledBy);
        }
        else {
            this.set('pref_.enforcement', null);
            this.set('pref_.controlledBy', null);
        }
        this.set('pref_.value', isSettingEnabled(defaultValue.setting));
    }
    /**
     * A handler for changing the default permission value for a the anti-abuse
     * content type.
     */
    onToggleChange_() {
        this.browserProxy.setDefaultValueForContentType(ContentSettingsTypes.ANTI_ABUSE, this.$.toggleButton.checked ? ContentSetting.ALLOW :
            ContentSetting.BLOCK);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsAntiAbusePageElement.is, SettingsAntiAbusePageElement);

function getTemplate$1p() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsAr}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsArDescription}
  </div>
  <!-- TODO(crbug.com/40176677): Fix redesign string when available.-->
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.AR]]"
      allow-option-label="$i18n{siteSettingsArAsk}"
      allow-option-icon="privacy:cardboard"
      block-option-label="$i18n{siteSettingsArBlock}"
      block-option-icon="privacy:cardboard-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.AR]]"
      read-only-list
      allow-header="$i18n{siteSettingsArAllowedExceptions}"
      block-header="$i18n{siteSettingsArBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ArPageElementBase = SettingsViewMixin(PolymerElement);
class ArPageElement extends ArPageElementBase {
    static get is() {
        return 'settings-ar-page';
    }
    static get template() {
        return getTemplate$1p();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(ArPageElement.is, ArPageElement);

function getTemplate$1o() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsAutomaticDownloads}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
      $i18n{siteSettingsAutomaticDownloadsDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.AUTOMATIC_DOWNLOADS]]"
      allow-option-label="$i18n{siteSettingsAutomaticDownloadsAllowed}"
      allow-option-icon="cr:file-download"
      block-option-label="$i18n{siteSettingsAutomaticDownloadsBlocked}"
      block-option-icon="privacy:file-download-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.AUTOMATIC_DOWNLOADS]]"
      allow-header="$i18n{siteSettingsAutomaticDownloadsAllowedExceptions}"
      block-header="$i18n{siteSettingsAutomaticDownloadsBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const AutomaticDownloadsPageElementBase = SettingsViewMixin(PolymerElement);
class AutomaticDownloadsPageElement extends AutomaticDownloadsPageElementBase {
    static get is() {
        return 'settings-automatic-downloads-page';
    }
    static get template() {
        return getTemplate$1o();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(AutomaticDownloadsPageElement.is, AutomaticDownloadsPageElement);

function getTemplate$1n() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage
    page-title="$i18n{siteSettingsCategoryAutomaticFullscreen}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsAutomaticFullscreenDescription}
  </div>
  <category-setting-exceptions read-only-list
      category="[[contentSettingsTypesEnum_.AUTOMATIC_FULLSCREEN]]"
      allow-header=
          "$i18n{siteSettingsAutomaticFullscreenAllowedExceptions}"
      block-header=
          "$i18n{siteSettingsAutomaticFullscreenBlockedExceptions}"
          search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const AutomaticFullScreenPageElementBase = SettingsViewMixin(PolymerElement);
class AutomaticFullScreenPageElement extends AutomaticFullScreenPageElementBase {
    static get is() {
        return 'settings-automatic-full-screen-page';
    }
    static get template() {
        return getTemplate$1n();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(AutomaticFullScreenPageElement.is, AutomaticFullScreenPageElement);

function getTemplate$1m() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsAutoPictureInPicture}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
   <div class="content-settings-header secondary">
     $i18n{siteSettingsAutoPictureInPictureDescription}
   </div>
   <settings-category-default-radio-group
       category="[[contentSettingsTypesEnum_.AUTO_PICTURE_IN_PICTURE]]"
       allow-option-label=
           "$i18n{siteSettingsAutoPictureInPictureAllowed}"
       allow-option-icon="settings:picture-in-picture"
       block-option-label="$i18n{siteSettingsAutoPictureInPictureBlocked}"
       block-option-icon="settings:picture-in-picture-off">
   </settings-category-default-radio-group>
   <category-setting-exceptions
       category="[[contentSettingsTypesEnum_.AUTO_PICTURE_IN_PICTURE]]"
       allow-header=
           "$i18n{siteSettingsAutoPictureInPictureAllowedExceptions}"
       block-header=
           "$i18n{siteSettingsAutoPictureInPictureBlockedExceptions}"
       search-filter="[[searchTerm]]">
   </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const AutoPictureInPicturePageElementBase = SettingsViewMixin(PolymerElement);
class AutoPictureInPicturePageElement extends AutoPictureInPicturePageElementBase {
    static get is() {
        return 'settings-auto-picture-in-picture-page';
    }
    static get template() {
        return getTemplate$1m();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(AutoPictureInPicturePageElement.is, AutoPictureInPicturePageElement);

function getTemplate$1l() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsBackgroundSync}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsBackgroundSyncDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.BACKGROUND_SYNC]]"
      allow-option-label="$i18n{siteSettingsBackgroundSyncAllowed}"
      allow-option-icon="cr:sync"
      block-option-label="$i18n{siteSettingsBackgroundSyncBlocked}"
      block-option-sub-label="$i18n{siteSettingsBackgroundSyncBlockedSubLabel}"
      block-option-icon="privacy:sync-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.BACKGROUND_SYNC]]"
      allow-header="$i18n{siteSettingsBackgroundSyncAllowedExceptions}"
      block-header="$i18n{siteSettingsBackgroundSyncBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const BackgroundSyncPageElementBase = SettingsViewMixin(PolymerElement);
class BackgroundSyncPageElement extends BackgroundSyncPageElementBase {
    static get is() {
        return 'settings-background-sync-page';
    }
    static get template() {
        return getTemplate$1l();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(BackgroundSyncPageElement.is, BackgroundSyncPageElement);

function getTemplate$1k() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared"></style>

    <div class="cr-row first">
      <h2 class="flex">[[exception.displayName]]</h2>
    </div>

    <div class="list-frame menu-content vertical-list" id="listContainer">
      <iron-list items="[[exception.sites]]" preserve-focus risk-selection>
        <template>
          <site-list-entry model="[[item]]"
              tabindex$="[[tabIndex]]"
              first$="[[!index]]"
              focus-row-index="[[index]]"
              iron-list-tab-index="[[tabIndex]]"
              last-focused="{{lastFocused_}}"
              chooser-type="[[exception.chooserType]]"
              chooser-object="[[exception.object]]"
              read-only-list>
          </site-list-entry>
        </template>
      </iron-list>
    </div>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'chooser-exception-list-entry' shows a single chooser exception for a given
 * chooser type.
 */
class ChooserExceptionListEntryElement extends PolymerElement {
    static get is() {
        return 'chooser-exception-list-entry';
    }
    static get template() {
        return getTemplate$1k();
    }
    static get properties() {
        return {
            /**
             * Chooser exception object to display in the widget.
             */
            exception: Object,
            lastFocused_: Object,
        };
    }
}
customElements.define(ChooserExceptionListEntryElement.is, ChooserExceptionListEntryElement);

function getTemplate$1j() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">#emptyListMessage{padding:0 var(--cr-section-padding);padding-top:30px}#exceptionList{padding-top:0}#resetSettingsButton{margin:0 var(--cr-section-padding);margin-top:24px}
    </style>

    <!-- Confirm reset settings dialog. -->
    <cr-dialog id="confirmResetSettings" close-text="$i18n{close}">
      <div slot="body">[[resetPermissionsMessage_]]</div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCloseDialog_">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" on-click="onResetSettings_">
          $i18n{siteSettingsSiteResetAll}
        </cr-button>
      </div>
    </cr-dialog>

    <div id="emptyListMessage"
        hidden$="[[hasExceptions_(chooserExceptions.*)]]">
      <div class="secondary">[[emptyListMessage_]]</div>
    </div>

    <div hidden$="[[!hasExceptions_(chooserExceptions.*)]]">
      <cr-button id="resetSettingsButton" role="button" aria-disabled="false"
          on-click="onConfirmClearSettings_">
        $i18n{siteSettingsReset}
      </cr-button>
    </div>

    <template id="exceptionList" is="dom-repeat" items="[[chooserExceptions]]">
      <chooser-exception-list-entry exception="[[item]]"
          on-show-tooltip="onShowTooltip_">
      </chooser-exception-list-entry>
    </template>

    <cr-tooltip id="tooltip" manual-mode position="top">
      [[tooltipText_]]
    </cr-tooltip>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'chooser-exception-list' shows a list of chooser exceptions for a given
 * chooser type.
 */
const ChooserExceptionListElementBase = TooltipMixin(ListPropertyUpdateMixin(SiteSettingsMixin(WebUiListenerMixin(I18nMixin(PolymerElement)))));
class ChooserExceptionListElement extends ChooserExceptionListElementBase {
    static get is() {
        return 'chooser-exception-list';
    }
    static get template() {
        return getTemplate$1j();
    }
    static get properties() {
        return {
            /**
             * Array of chooser exceptions to display in the widget.
             */
            chooserExceptions: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * The string ID of the chooser type that this element is displaying data
             * for.
             * See site_settings/constants.js for possible values.
             */
            chooserType: {
                observer: 'chooserTypeChanged_',
                type: String,
                value: ChooserType.NONE,
            },
            emptyListMessage_: {
                type: String,
                value: '',
            },
            hasIncognito_: Boolean,
            resetPermissionsMessage_: {
                type: String,
                value: '',
            },
            tooltipText_: String,
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('contentSettingChooserPermissionChanged', (category, chooserType) => {
            this.objectWithinChooserTypeChanged_(category, chooserType);
        });
        this.addWebUiListener('onIncognitoStatusChanged', (hasIncognito) => this.onIncognitoStatusChanged_(hasIncognito));
        this.browserProxy.updateIncognitoStatus();
    }
    /**
     * Called when a chooser exception changes permission and updates the element
     * if |category| is equal to the settings category of this element.
     * @param category The content settings type that represents this permission
     *     category.
     * @param chooserType The content settings type that represents the chooser
     *     data for this permission.
     */
    objectWithinChooserTypeChanged_(category, chooserType) {
        if (category === this.category && chooserType === this.chooserType) {
            this.chooserTypeChanged_();
        }
    }
    /**
     * Called for each chooser-exception-list when incognito is enabled or
     * disabled. Only called on change (opening N incognito windows only fires one
     * message). Another message is sent when the *last* incognito window closes.
     */
    onIncognitoStatusChanged_(hasIncognito) {
        this.hasIncognito_ = hasIncognito;
        this.populateList_();
    }
    /**
     * Configures the visibility of the widget and shows the list.
     */
    chooserTypeChanged_() {
        if (this.chooserType === ChooserType.NONE) {
            return;
        }
        // Set the message to display when the exception list is empty.
        switch (this.chooserType) {
            case ChooserType.USB_DEVICES:
                this.emptyListMessage_ = this.i18n('noUsbDevicesFound');
                this.resetPermissionsMessage_ = this.i18n('resetUsbConfirmation');
                break;
            case ChooserType.SERIAL_PORTS:
                this.emptyListMessage_ = this.i18n('noSerialPortsFound');
                this.resetPermissionsMessage_ =
                    this.i18n('resetSerialPortsConfirmation');
                break;
            case ChooserType.HID_DEVICES:
                this.emptyListMessage_ = this.i18n('noHidDevicesFound');
                this.resetPermissionsMessage_ = this.i18n('resetHidConfirmation');
                break;
            case ChooserType.BLUETOOTH_DEVICES:
                this.emptyListMessage_ = this.i18n('noBluetoothDevicesFound');
                this.resetPermissionsMessage_ = this.i18n('resetBluetoothConfirmation');
                break;
            // 
            default:
                this.emptyListMessage_ = '';
                this.resetPermissionsMessage_ = '';
        }
        this.populateList_();
    }
    /**
     * @return true if there are any chooser exceptions for this chooser type.
     */
    hasExceptions_() {
        return this.chooserExceptions.length > 0;
    }
    /**
     * Need to use a common tooltip since the tooltip in the entry is cut off from
     * the iron-list.
     */
    onShowTooltip_(e) {
        this.tooltipText_ = e.detail.text;
        // cr-tooltip normally determines the target from the |for| property,
        // which is a selector. Here cr-tooltip is being reused by multiple
        // potential targets.
        this.showTooltipAtTarget(this.$.tooltip, e.detail.target);
    }
    /**
     * Populate the chooser exception list for display.
     */
    populateList_() {
        this.browserProxy.getChooserExceptionList(this.chooserType)
            .then(exceptionList => this.processExceptions_(exceptionList));
    }
    /**
     * Process the chooser exception list returned from the native layer.
     */
    processExceptions_(exceptionList) {
        const exceptions = exceptionList.map(exception => {
            const sites = exception.sites.map(site => this.expandSiteException(site));
            return Object.assign(exception, { sites });
        });
        if (!this.updateList('chooserExceptions', x => x.displayName, exceptions, true /* identityBasedUpdate= */)) {
            // The chooser objects have not been changed, so check if their site
            // permissions have changed. The |exceptions| and |this.chooserExceptions|
            // arrays should be the same length.
            const siteUidGetter = (x) => x.origin + x.embeddingOrigin + x.incognito;
            exceptions.forEach((exception, index) => {
                const propertyPath = 'chooserExceptions.' + index + '.sites';
                this.updateList(propertyPath, siteUidGetter, exception.sites);
            }, this);
        }
    }
    /**
     * Confirms the resetting of all content settings for an origin.
     */
    onConfirmClearSettings_(e) {
        e.preventDefault();
        this.$.confirmResetSettings.showModal();
    }
    onCloseDialog_(e) {
        e.target.closest('cr-dialog').close();
    }
    /**
     * Resets all permissions for the current origin.
     */
    onResetSettings_(e) {
        this.chooserExceptions.forEach(exception => {
            exception.sites.forEach(site => {
                this.browserProxy.resetChooserExceptionForSite(exception.chooserType, site.origin, exception.object);
            });
        });
        this.onCloseDialog_(e);
    }
}
customElements.define(ChooserExceptionListElement.is, ChooserExceptionListElement);

function getTemplate$1i() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsBluetoothDevices}"
    learn-more-url="$i18n{bluetoothAdapterOffHelpURL}"
    route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsBluetoothDevicesDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.BLUETOOTH_DEVICES]]"
      allow-option-label="$i18n{siteSettingsBluetoothDevicesAllowed}"
      allow-option-icon="settings:bluetooth"
      block-option-label="$i18n{siteSettingsBluetoothDevicesBlocked}"
      block-option-icon="settings:bluetooth-off">
  </settings-category-default-radio-group>
  <chooser-exception-list
      category="[[contentSettingsTypesEnum_.BLUETOOTH_DEVICES]]"
      chooser-type="[[chooserTypeEnum_.BLUETOOTH_DEVICES]]">
  </chooser-exception-list>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const BluetoothDevicesPageElementBase = SettingsViewMixin(PolymerElement);
class BluetoothDevicesPageElement extends BluetoothDevicesPageElementBase {
    static get is() {
        return 'settings-bluetooth-devices-page';
    }
    static get template() {
        return getTemplate$1i();
    }
    static get properties() {
        return {
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
            // Expose ChooserType enum to the HTML template.
            chooserTypeEnum_: {
                type: Object,
                value: ChooserType,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(BluetoothDevicesPageElement.is, BluetoothDevicesPageElement);

function getTemplate$1h() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsBluetoothScanning}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsBluetoothScanningDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.BLUETOOTH_SCANNING]]"
      allow-option-label=
          "$i18n{siteSettingsBluetoothScanningAsk}"
      allow-option-icon="settings:bluetooth-scanning"
      block-option-label="$i18n{siteSettingsBluetoothScanningBlock}"
      block-option-icon="settings:bluetooth-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.BLUETOOTH_SCANNING]]"
      read-only-list
      block-header=
          "$i18n{siteSettingsBluetoothScanningBlockedExceptions}"
      allow-header=
          "$i18n{siteSettingsBluetoothScanningAllowedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const BluetoothScanningPageElementBase = SettingsViewMixin(PolymerElement);
class BluetoothScanningPageElement extends BluetoothScanningPageElementBase {
    static get is() {
        return 'settings-bluetooth-scanning-page';
    }
    static get template() {
        return getTemplate$1h();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(BluetoothScanningPageElement.is, BluetoothScanningPageElement);

function getTemplate$1g() {
    return html `<!--_html_template_start_-->    <style include="settings-shared md-select">:host{display:block}
    </style>
    <div class="cr-row first" id="picker" hidden>
      <select id="mediaPicker" class="md-select" on-change="onChange_"
          aria-label$="[[label]]">
        <template is="dom-repeat" items="[[devices]]">
          <option value$="[[item.id]]">[[item.name]]</option>
        </template>
      </select>
    </div>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'media-picker' handles showing the dropdown allowing users to select the
 * default camera/microphone.
 */
const MediaPickerElementBase = SiteSettingsMixin(WebUiListenerMixin(PolymerElement));
class MediaPickerElement extends MediaPickerElementBase {
    static get is() {
        return 'media-picker';
    }
    static get template() {
        return getTemplate$1g();
    }
    static get properties() {
        return {
            /**
             * The type of media picker, either 'camera' or 'mic'.
             */
            type: String,
            /** Label for a11y purposes. */
            label: String,
            /**
             * The devices available to pick from.
             */
            devices: Array,
        };
    }
    ready() {
        super.ready();
        this.addWebUiListener('updateDevicesMenu', (type, devices, selectedDevice) => this.updateDevicesMenu_(type, devices, selectedDevice));
        this.browserProxy.initializeCaptureDevices(this.type);
    }
    /**
     * Updates the microphone/camera devices menu with the given entries.
     * @param type The device type.
     * @param devices List of available devices.
     * @param defaultDevice The unique id of the current default device.
     */
    updateDevicesMenu_(type, devices, selectedDevice) {
        if (type !== this.type) {
            return;
        }
        this.$.picker.hidden = devices.length === 0;
        if (devices.length > 0) {
            this.devices = devices;
            // Wait for <select> to be populated.
            microTask.run(() => {
                this.$.mediaPicker.value = selectedDevice;
            });
        }
    }
    /**
     * A handler for when an item is selected in the media picker.
     */
    onChange_() {
        this.browserProxy.setPreferredCaptureDevice(this.type, this.$.mediaPicker.value);
    }
}
customElements.define(MediaPickerElement.is, MediaPickerElement);

function getTemplate$1f() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryCamera}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <media-picker label="$i18n{siteSettingsCameraLabel}" type="camera">
  </media-picker>
  <div class="content-settings-header secondary">
    $i18n{siteSettingsCameraDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.CAMERA]]"
      allow-option-label="$i18n{siteSettingsCameraAllowed}"
      allow-option-icon="cr:videocam"
      block-option-label="$i18n{siteSettingsCameraBlocked}"
      block-option-sub-label="$i18n{siteSettingsCameraBlockedSubLabel}"
      block-option-icon="privacy:videocam-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.CAMERA]]" read-only-list
      allow-header="$i18n{siteSettingsCameraAllowedExceptions}"
      block-header="$i18n{siteSettingsCameraBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CameraPageElementBase = SettingsViewMixin(PolymerElement);
class CameraPageElement extends CameraPageElementBase {
    static get is() {
        return 'settings-camera-page';
    }
    static get template() {
        return getTemplate$1f();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(CameraPageElement.is, CameraPageElement);

function getTemplate$1e() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCapturedSurfaceControl}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsCapturedSurfaceControlDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.CAPTURED_SURFACE_CONTROL]]"
      allow-option-label=
          "$i18n{siteSettingsCapturedSurfaceControlAllowed}"
      allow-option-icon="settings:touchpad-mouse"
      block-option-label="$i18n{siteSettingsCapturedSurfaceControlBlocked}"
      block-option-icon="settings:touchpad-mouse-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.CAPTURED_SURFACE_CONTROL]]"
      allow-header=
          "$i18n{siteSettingsCapturedSurfaceControlAllowedExceptions}"
      block-header=
          "$i18n{siteSettingsCapturedSurfaceControlBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CapturedSurfaceControlPageElementBase = SettingsViewMixin(PolymerElement);
class CapturedSurfaceControlPageElement extends CapturedSurfaceControlPageElementBase {
    static get is() {
        return 'settings-captured-surface-control-page';
    }
    static get template() {
        return getTemplate$1e();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(CapturedSurfaceControlPageElement.is, CapturedSurfaceControlPageElement);

function getTemplate$1d() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsClipboard}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsClipboardDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.CLIPBOARD]]"
      allow-option-label="$i18n{siteSettingsClipboardAllowed}"
      allow-option-icon="privacy:content-paste"
      block-option-label="$i18n{siteSettingsClipboardBlocked}"
      block-option-icon="privacy:content-paste-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.CLIPBOARD]]"
      allow-header="$i18n{siteSettingsClipboardAllowedExceptions}"
      block-header="$i18n{siteSettingsClipboardBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ClipboardPageElementBase = SettingsViewMixin(PolymerElement);
class ClipboardPageElement extends ClipboardPageElementBase {
    static get is() {
        return 'settings-clipboard-page';
    }
    static get template() {
        return getTemplate$1d();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(ClipboardPageElement.is, ClipboardPageElement);

function getTemplate$1c() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage
    page-title="$i18n{siteSettingsCategoryFederatedIdentityApi}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsFederatedIdentityApiDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.FEDERATED_IDENTITY_API]]"
      allow-option-label="$i18n{siteSettingsFederatedIdentityApiAllowed}"
      allow-option-icon="privacy:account-circle"
      block-option-label="$i18n{siteSettingsFederatedIdentityApiBlocked}"
      block-option-icon="privacy:account-circle-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.FEDERATED_IDENTITY_API]]"
      allow-header="$i18n{siteSettingsFederatedIdentityApiAllowedExceptions}"
      block-header="$i18n{siteSettingsFederatedIdentityApiBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const FederatedIdentityApiPageElementBase = SettingsViewMixin(PolymerElement);
class FederatedIdentityApiPageElement extends FederatedIdentityApiPageElementBase {
    static get is() {
        return 'settings-federated-identity-api-page';
    }
    static get template() {
        return getTemplate$1c();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(FederatedIdentityApiPageElement.is, FederatedIdentityApiPageElement);

function getTemplate$1b() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">.file-system{padding-inline-start:20px;padding-inline-end:20px}</style>
<div class="list-item file-system">
  <div id="fileTypeIcon"
      class$="cr-icon [[getClassForListItem_(grant)]]">
  </div>
  <div class="site-representation middle text-elide">
    <span class="display-name url-directionality text-elide">
        [[grant.displayName]]
    </span>
  </div>
  <cr-icon-button id="removeGrant" class="icon-delete-gray"
      on-click="onRemoveGrantClick_"
      aria-label=$i18n{siteSettingsFileSystemSiteListRemoveGrantLabel}>
  <cr-icon-button>
</div><!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'file-system-site-entry-item' is an element representing a single
 * permission grant for a given origin, granted via the File System Access API.
 */
const FileSystemSiteEntryItemElementBase = BaseMixin(PolymerElement);
class FileSystemSiteEntryItemElement extends FileSystemSiteEntryItemElementBase {
    static get is() {
        return 'file-system-site-entry-item';
    }
    static get template() {
        return getTemplate$1b();
    }
    static get properties() {
        return {
            /**
             * An Object representing an origin and its associated permission grants.
             */
            grant: Object,
        };
    }
    getClassForListItem_() {
        return this.grant.isDirectory ? 'icon-folder-open' : 'icon-file';
    }
    onRemoveGrantClick_() {
        this.fire('revoke-grant', this.grant);
    }
}
customElements.define(FileSystemSiteEntryItemElement.is, FileSystemSiteEntryItemElement);

function getTemplate$1a() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">.origin{flex-grow:1;padding-inline-start:20px}.origin-row{align-items:center;display:flex;padding-bottom:5px;padding-inline-end:10px;padding-top:5px}.subpage-arrow{margin-inline-end:2px}.separator{padding-inline-end:25px}</style>

<div class="list-frame">
  <div class="origin-row">
    <site-favicon url="[[grantsPerOrigin.origin]]"></site-favicon>
    <div class="origin">[[grantsPerOrigin.origin]]</div>
    <cr-icon-button id="fileSystemSiteDetails"
        class="subpage-arrow"
        aria-label$="[[grantsPerOrigin.origin]]"
        aria-roledescription="$i18n{subpageArrowRoleDescription}"
        on-click="onNavigateToDetailsPageClick_">
    </cr-icon-button>
    <div class="separator"></div>
    <cr-icon-button
        class="icon-delete-gray"
        id="removeGrants"
        on-click="onRemoveGrantsClick_">
      $i18n{siteSettingsFileSystemSiteListRemoveGrants}
    </cr-icon-button>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'file-system-site-entry' is an element representing a single origin's
 * permission grant(s), granted via the File System Access API.
 */
const FileSystemSiteEntryElementBase = BaseMixin(PolymerElement);
class FileSystemSiteEntryElement extends FileSystemSiteEntryElementBase {
    static get is() {
        return 'file-system-site-entry';
    }
    static get template() {
        return getTemplate$1a();
    }
    static get properties() {
        return {
            /**
             * An Object representing an origin and its associated permission grants.
             */
            grantsPerOrigin: Object,
        };
    }
    onNavigateToDetailsPageClick_() {
        /**
         * Navigates to the details page for a given origin.
         */
        Router.getInstance().navigateTo(routes.SITE_SETTINGS_FILE_SYSTEM_WRITE_DETAILS, new URLSearchParams('site=' + this.grantsPerOrigin.origin));
    }
    onRemoveGrantsClick_() {
        this.fire('revoke-grants', this.grantsPerOrigin);
    }
}
customElements.define(FileSystemSiteEntryElement.is, FileSystemSiteEntryElement);

function getTemplate$19() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared"></style>

<div class="cr-row first">
  <h2 class="cr-secondary-text">
    $i18n{siteSettingsFileSystemSiteListHeader}
  </h2>
</div>
<div class="list-frame"
    hidden$="[[hasAllowedGrants_(allowedGrants_.*)]]">
  <div class="list-item cr-secondary-text">$i18n{noSitesAdded}</div>
</div>
<template is="dom-repeat" items="[[allowedGrants_]]" as="grantsPerOrigin">
  <file-system-site-entry grants-per-origin="[[grantsPerOrigin]]"
      on-revoke-grants="onRevokeGrants_">
  </file-system-site-entry>
</template><!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'file-system-site-list' is an element representing a list of origin-specific
 * permission entries for the File System Access API.
 */
const FileSystemSiteListElementBase = WebUiListenerMixin(RouteObserverMixin(SiteSettingsMixin(PolymerElement)));
class FileSystemSiteListElement extends FileSystemSiteListElementBase {
    static get is() {
        return 'file-system-site-list';
    }
    static get template() {
        return getTemplate$19();
    }
    static get properties() {
        return {
            /**
             * Array of the File System permission grants that are actively displayed,
             * grouped by origin.
             */
            allowedGrants_: {
                type: Array,
                value: () => [],
            },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('contentSettingChooserPermissionChanged', (category) => {
            if (category === ContentSettingsTypes.FILE_SYSTEM_WRITE) {
                this.populateList_();
            }
        });
    }
    disconnectedCallback() {
        super.disconnectedCallback();
    }
    /**
     * Reload the site list when the chrome://settings/content/filesystem
     * page is visited.
     *
     * RouteObserverMixin
     */
    currentRouteChanged(currentRoute, oldRoute) {
        if (currentRoute === routes.SITE_SETTINGS_FILE_SYSTEM_WRITE &&
            currentRoute !== oldRoute) {
            this.populateList_();
        }
    }
    /**
     * Retrieves a list of all known origins with allowed permissions,
     * granted via the File System Access API.
     */
    async populateList_() {
        const response = await this.browserProxy.getFileSystemGrants();
        this.set('allowedGrants_', response);
    }
    /**
     * Determines whether there are any allowed File System Access permission
     * grants.
     */
    hasAllowedGrants_() {
        return this.allowedGrants_.length > 0;
    }
    /**
     * Revoke all permission grants for a given origin, then update the list
     * displayed on the UI.
     */
    onRevokeGrants_(e) {
        this.browserProxy.revokeFileSystemGrants(e.detail.origin);
    }
}
customElements.define(FileSystemSiteListElement.is, FileSystemSiteListElement);

function getTemplate$18() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsFileSystemWrite}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsFileSystemWriteDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.FILE_SYSTEM_WRITE]]"
      allow-option-label="$i18n{siteSettingsFileSystemWriteAllowed}"
      allow-option-icon="privacy:file-save"
      block-option-label="$i18n{siteSettingsFileSystemWriteBlocked}"
      block-option-icon="privacy:file-save-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.FILE_SYSTEM_WRITE]]"
      read-only-list
      block-header="$i18n{siteSettingsFileSystemWriteBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
  <template is="dom-if" if="[[enablePersistentPermissions_]]">
    <file-system-site-list></file-system-site-list>
  </template>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const FilesystemPageElementBase = SettingsViewMixin(PolymerElement);
class FilesystemPageElement extends FilesystemPageElementBase {
    static get is() {
        return 'settings-filesystem-page';
    }
    static get template() {
        return getTemplate$18();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
            /**
             * Whether the File System Access Persistent Permissions UI should be
             * displayed.
             */
            enablePersistentPermissions_: {
                type: Boolean,
                readOnly: true,
                value: () => {
                    return loadTimeData.getBoolean('enablePersistentPermissions');
                },
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(FilesystemPageElement.is, FilesystemPageElement);

function getTemplate$17() {
    return html `<!--_html_template_start_--><style>.grants-list-header{padding-inline-start:20px;padding-bottom:20px}.view-grants{padding-top:20px}</style>
<settings-subpage page-title="[[pageTitle_]]" route-path$="[[routePath]]">
  <div class="grants-list-header"
      hidden$="[[!grantsPerOrigin.editGrants.length]]">
    $i18n{siteSettingsFileSystemSiteListEditHeader}
  </div>
  <template is="dom-repeat" items="[[grantsPerOrigin.editGrants]]"
      as="editGrant">
    <file-system-site-entry-item grant="[[editGrant]]"
        on-revoke-grant="onRevokeGrant_">
    </file-system-site-entry-item>
  </template>
  <div class="grants-list-header view-grants"
      hidden$="[[!grantsPerOrigin.viewGrants.length]]">
    $i18n{siteSettingsFileSystemSiteListViewHeader}
  </div>
  <template is="dom-repeat" items="[[grantsPerOrigin.viewGrants]]"
      as="viewGrant">
    <file-system-site-entry-item grant="[[viewGrant]]"
        on-revoke-grant="onRevokeGrant_">
    </file-system-site-entry-item>
  </template>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'file-system-site-details' shows the individual permission grant details
 * for permissions granted via the File System Access API, under Site Settings.
 */
const FileSystemSiteDetailsElementBase = WebUiListenerMixin(BaseMixin(RouteObserverMixin(SettingsViewMixin(SiteSettingsMixin(I18nMixin(PolymerElement))))));
class FileSystemSiteDetailsElement extends FileSystemSiteDetailsElementBase {
    static get is() {
        return 'file-system-site-details';
    }
    static get template() {
        return getTemplate$17();
    }
    static get properties() {
        return {
            /**
             * Use the string representing the origin or extension name as the page
             * title of the settings-subpage parent.
             */
            pageTitle_: {
                type: String,
                notify: true,
            },
            /**
             * The origin that this details page is showing information for.
             */
            origin_: String,
            /**
             * An Object representing an origin and its associated permission grants.
             */
            grantsPerOrigin: Object,
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('contentSettingChooserPermissionChanged', (category) => {
            if (category === ContentSettingsTypes.FILE_SYSTEM_WRITE) {
                this.populateList_();
            }
        });
    }
    /**
     * RouteObserverMixin
     */
    currentRouteChanged(route, oldRoute) {
        super.currentRouteChanged(route, oldRoute);
        if (route !== routes.SITE_SETTINGS_FILE_SYSTEM_WRITE_DETAILS) {
            return;
        }
        const site = Router.getInstance().getQueryParameters().get('site');
        if (!site) {
            return;
        }
        this.browserProxy.isOriginValid(site).then(valid => {
            if (!valid) {
                Router.getInstance().navigateToPreviousRoute();
            }
            this.origin_ = site;
            this.pageTitle_ = this.origin_;
        });
        this.populateList_();
    }
    /**
     * Retrieves a list of all known origins with allowed permissions,
     * granted via the File System Access API.
     */
    async populateList_() {
        const response = await this.browserProxy.getFileSystemGrants();
        const originFileSystemGrantsObj = response.find(grantObj => grantObj.origin === this.origin_);
        // Return to the file system site settings page if the given origin has
        // no file system grants.
        if (!originFileSystemGrantsObj) {
            Router.getInstance().navigateTo(routes.SITE_SETTINGS_FILE_SYSTEM_WRITE);
            return;
        }
        this.grantsPerOrigin = originFileSystemGrantsObj;
    }
    /**
     * Revoke an individual permission grant for a given origin and filePath,
     * then update the list displayed on the UI.
     */
    onRevokeGrant_(e) {
        this.browserProxy.revokeFileSystemGrant(this.origin_, e.detail.filePath);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(FileSystemSiteDetailsElement.is, FileSystemSiteDetailsElement);

function getTemplate$16() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryLocation}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
<div class="content-settings-header secondary">
  $i18n{siteSettingsLocationDescription}
</div>
<template is="dom-if"
    if="[[!enablePermissionSiteSettingsRadioButton_]]">
  <div id="locationRadioGroup" class="radio-group">
    <h2>$i18n{siteSettingsDefaultBehavior}</h2>
    <div id="geolocationSubHeading"
        class="secondary radio-sub-heading">
        $i18n{siteSettingsDefaultBehaviorDescription}
    </div>
    <cr-radio-group
        on-selected-changed="onLocationTopLevelRadioChanged_">
      <cr-radio-button no-collapse
          id="locationAskRadioButton"
          name="location-ask-radio-button"
          checked$="[[isLocationAllowed_]]">
        <cr-icon icon="settings:location-on"></cr-icon>
        $i18n{siteSettingsLocationAllowed}
      </cr-radio-button>
      <settings-radio-group
          id="locationCpssRadioGroup"
          pref="{{prefs.generated.geolocation}}"
          selectable-elements="cr-radio-button"
          hidden$="[[!isLocationAllowed_]]">
        <cr-radio-button class="padded-radio-section"
            name="[[settingsStateEnum_.QUIET]]"
            pref="[[prefs.generated.geolocation]]"
            label="$i18n{siteSettingsLocationAskQuiet}">
        </cr-radio-button>
        <cr-radio-button class="padded-radio-section"
            name="[[settingsStateEnum_.CPSS]]"
            pref="[[prefs.generated.geolocation]]"
            label="$i18n{siteSettingsLocationAskCPSS}">
        </cr-radio-button>
        <cr-radio-button class="padded-radio-section"
            name="[[settingsStateEnum_.LOUD]]"
            pref="[[prefs.generated.geolocation]]"
            label="$i18n{siteSettingsLocationAskLoud}">
        </cr-radio-button>
      </settings-radio-group>
      <cr-radio-button class="two-line"
          id="locationBlockRadioButton"
          name="location-block-radio-button"
          sub-label="$i18n{siteSettingsLocationBlockedSubLabel}"
          checked$="[[!isLocationAllowed_]]">
        <cr-icon icon="privacy:location-off"></cr-icon>
        $i18n{siteSettingsLocationBlocked}
      </cr-radio-button>
    </cr-radio-group>
  </div>
</template>
<template is="dom-if"
    if="[[enablePermissionSiteSettingsRadioButton_]]">
  <settings-category-default-radio-group
      id="locationDefaultRadioGroup"
      category="[[contentSettingsTypesEnum_.GEOLOCATION]]"
      allow-option-label="$i18n{siteSettingsLocationAllowed}"
      allow-option-icon="settings:location-on"
      block-option-label="$i18n{siteSettingsLocationBlocked}"
      block-option-icon="privacy:location-off"
      on-selected-changed="onLocationTopLevelRadioChanged2_">
  </settings-category-default-radio-group>
  <div class="radio-group"
      id="locationCpssRadioGroup"
      hidden$="[[!isLocationAllowed_]]">
    <h2 class="cpss-heading">
      $i18n{siteSettingsHowToShowRequests}
    </h2>
    <settings-radio-group
        pref="{{prefs.generated.geolocation}}"
        selectable-elements="settings-collapse-radio-button">
      <settings-collapse-radio-button
          name="[[settingsStateEnum_.QUIET]]"
          pref="[[prefs.generated.geolocation]]"
          label="$i18n{siteSettingsLocationAskQuiet}"
          no-collapse>
      </settings-collapse-radio-button>
      <settings-collapse-radio-button
          name="[[settingsStateEnum_.CPSS]]"
          pref="[[prefs.generated.geolocation]]"
          label="$i18n{siteSettingsLocationAskCPSS}"
          no-collapse>
      </settings-collapse-radio-button>
      <settings-collapse-radio-button
          name="[[settingsStateEnum_.LOUD]]"
          pref="[[prefs.generated.geolocation]]"
          label="$i18n{siteSettingsLocationAskLoud}"
          no-collapse>
      </settings-collapse-radio-button>
    </settings-radio-group>
  </div>
</template>
<category-setting-exceptions
    category="[[contentSettingsTypesEnum_.GEOLOCATION]]"
    read-only-list
    allow-header="$i18n{siteSettingsLocationAllowedExceptions}"
    block-header="$i18n{siteSettingsLocationBlockedExceptions}"
    search-filter="[[searchTerm]]">
</category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const GeolocationPageElementBase = SettingsViewMixin(PrefsMixin(PolymerElement));
class GeolocationPageElement extends GeolocationPageElementBase {
    static get is() {
        return 'settings-geolocation-page';
    }
    static get template() {
        return getTemplate$16();
    }
    static get properties() {
        return {
            searchTerm: {
                type: String,
                notify: true,
                value: '',
            },
            enablePermissionSiteSettingsRadioButton_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('enablePermissionSiteSettingsRadioButton'),
            },
            /** Expose the Permissions SettingsState enum to HTML bindings. */
            settingsStateEnum_: {
                type: Object,
                value: SettingsState,
            },
            /** Expose ContentSettingsTypes enum to HTML bindings. */
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
            /** Expose ContentSetting enum to HTML bindings. */
            contentSettingEnum_: {
                type: Object,
                value: ContentSetting,
            },
            isLocationAllowed_: Boolean,
        };
    }
    siteSettingsBrowserProxy_ = SiteSettingsBrowserProxyImpl.getInstance();
    ready() {
        super.ready();
        this.updateLocationState_();
    }
    async updateLocationState_() {
        const [locationDefaultValue] = await Promise.all([
            this.siteSettingsBrowserProxy_.getDefaultValueForContentType(ContentSettingsTypes.GEOLOCATION),
        ]);
        this.isLocationAllowed_ =
            (locationDefaultValue.setting === ContentSetting.ASK);
    }
    onLocationTopLevelRadioChanged_(event) {
        const radioButtonName = event.detail.value;
        switch (radioButtonName) {
            case 'location-block-radio-button':
                this.setPrefValue('generated.geolocation', SettingsState.BLOCK);
                this.isLocationAllowed_ = false;
                break;
            case 'location-ask-radio-button':
                this.setPrefValue('generated.geolocation', SettingsState.CPSS);
                this.isLocationAllowed_ = true;
                break;
        }
    }
    onLocationTopLevelRadioChanged2_(event) {
        const selected = event.detail.value;
        if (selected) {
            this.setPrefValue('generated.geolocation', SettingsState.CPSS);
            this.isLocationAllowed_ = true;
        }
        else {
            this.setPrefValue('generated.geolocation', SettingsState.BLOCK);
            this.isLocationAllowed_ = false;
        }
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(GeolocationPageElement.is, GeolocationPageElement);

function getTemplate$15() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsHandTracking}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsHandTrackingDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.HAND_TRACKING]]"
      allow-option-label="$i18n{siteSettingsHandTrackingAsk}"
      allow-option-icon="privacy:hand-gesture"
      block-option-label="$i18n{siteSettingsHandTrackingBlock}"
      block-option-icon="privacy:hand-gesture-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.HAND_TRACKING]]"
      read-only-list
      allow-header="$i18n{siteSettingsHandTrackingAllowedExceptions}"
      block-header="$i18n{siteSettingsHandTrackingBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const HandTrackingPageElementBase = SettingsViewMixin(PolymerElement);
class HandTrackingPageElement extends HandTrackingPageElementBase {
    static get is() {
        return 'settings-hand-tracking-page';
    }
    static get template() {
        return getTemplate$15();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(HandTrackingPageElement.is, HandTrackingPageElement);

function getTemplate$14() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsHidDevices}"
    learn-more-url="$i18n{chooserHidOverviewUrl}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsHidDevicesDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.HID_DEVICES]]"
      allow-option-label="$i18n{siteSettingsHidDevicesAllowed}"
      allow-option-icon="privacy:videogame-asset"
      block-option-label="$i18n{siteSettingsHidDevicesBlocked}"
      block-option-icon="privacy:videogame-asset-off">
  </settings-category-default-radio-group>
  <chooser-exception-list
      category="[[contentSettingsTypesEnum_.HID_DEVICES]]"
      chooser-type="[[chooserTypeEnum_.HID_DEVICES]]">
  </chooser-exception-list>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const HidDevicesPageElementBase = SettingsViewMixin(PolymerElement);
class HidDevicesPageElement extends HidDevicesPageElementBase {
    static get is() {
        return 'settings-hid-devices-page';
    }
    static get template() {
        return getTemplate$14();
    }
    static get properties() {
        return {
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
            // Expose ChooserType enum to the HTML template.
            chooserTypeEnum_: {
                type: Object,
                value: ChooserType,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(HidDevicesPageElement.is, HidDevicesPageElement);

function getTemplate$13() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsIdleDetection}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsDeviceUseDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.IDLE_DETECTION]]"
      allow-option-label="$i18n{siteSettingsDeviceUseAllowed}"
      allow-option-icon="settings:devices"
      block-option-label="$i18n{siteSettingsDeviceUseBlocked}"
      block-option-icon="privacy:devices-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.IDLE_DETECTION]]"
      allow-header="$i18n{siteSettingsDeviceUseAllowedExceptions}"
      block-header="$i18n{siteSettingsDeviceUseBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const IdleDetectionPageElementBase = SettingsViewMixin(PolymerElement);
class IdleDetectionPageElement extends IdleDetectionPageElementBase {
    static get is() {
        return 'settings-idle-detection-page';
    }
    static get template() {
        return getTemplate$13();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(IdleDetectionPageElement.is, IdleDetectionPageElement);

function getTemplate$12() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryImages}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsImagesDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.IMAGES]]"
      allow-option-label="$i18n{siteSettingsImagesAllowed}"
      allow-option-icon="privacy:imagesmode"
      block-option-label="$i18n{siteSettingsImagesBlocked}"
      block-option-sub-label="$i18n{siteSettingsImagesBlockedSubLabel}"
      block-option-icon="privacy:hide-image">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.IMAGES]]"
      allow-header="$i18n{siteSettingsImagesAllowedExceptions}"
      block-header="$i18n{siteSettingsImagedBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ImagesPageElementBase = SettingsViewMixin(PolymerElement);
class ImagesPageElement extends ImagesPageElementBase {
    static get is() {
        return 'settings-images-page';
    }
    static get template() {
        return getTemplate$12();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(ImagesPageElement.is, ImagesPageElement);

function getTemplate$11() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage
    page-title="$i18n{siteSettingsCategoryInsecureContent}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsInsecureContentDescription}
  </div>
  <div class="cr-row first secondary">
    $i18n{siteSettingsInsecureContentBlock}
  </div>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.MIXEDSCRIPT]]"
      allow-header="$i18n{siteSettingsInsecureContentAllowedExceptions}"
      block-header="$i18n{siteSettingsInsecureContentBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const InsecureContentPageElementBase = SettingsViewMixin(PolymerElement);
class InsecureContentPageElement extends InsecureContentPageElementBase {
    static get is() {
        return 'settings-insecure-content-page';
    }
    static get template() {
        return getTemplate$11();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(InsecureContentPageElement.is, InsecureContentPageElement);

function getTemplate$10() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryJavascript}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsJavascriptDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.JAVASCRIPT]]"
      allow-option-label="$i18n{siteSettingsJavascriptAllowed}"
      allow-option-icon="privacy:code"
      block-option-label="$i18n{siteSettingsJavascriptBlocked}"
      block-option-icon="privacy:code-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.JAVASCRIPT]]"
      allow-header="$i18n{siteSettingsJavascriptAllowedExceptions}"
      block-header="$i18n{siteSettingsJavascriptBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const JavascriptPageElementBase = SettingsViewMixin(PolymerElement);
class JavascriptPageElement extends JavascriptPageElementBase {
    static get is() {
        return 'settings-javascript-page';
    }
    static get template() {
        return getTemplate$10();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(JavascriptPageElement.is, JavascriptPageElement);

function getTemplate$$() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsKeyboardLock}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsKeyboardLockDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.KEYBOARD_LOCK]]"
      allow-option-label=
          "$i18n{siteSettingsKeyboardLockAllowed}"
      allow-option-icon="settings20:keyboard-lock"
      block-option-label="$i18n{siteSettingsKeyboardLockBlocked}"
      block-option-icon="settings20:keyboard-lock-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.KEYBOARD_LOCK]]"
      allow-header=
          "$i18n{siteSettingsKeyboardLockAllowedExceptions}"
      block-header=
          "$i18n{siteSettingsKeyboardLockBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const KeyboardLockPageElementBase = SettingsViewMixin(PolymerElement);
class KeyboardLockPageElement extends KeyboardLockPageElementBase {
    static get is() {
        return 'settings-keyboard-lock-page';
    }
    static get template() {
        return getTemplate$$();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(KeyboardLockPageElement.is, KeyboardLockPageElement);

function getTemplate$_() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{fonts}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsFontsDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.LOCAL_FONTS]]"
      allow-option-label="$i18n{siteSettingsFontsAllowed}"
      allow-option-icon="privacy:font-download"
      block-option-label="$i18n{siteSettingsFontsBlocked}"
      block-option-icon="privacy:font-download-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.LOCAL_FONTS]]"
      block-header="$i18n{siteSettingsFontsBlockedExceptions}"
      allow-header="$i18n{siteSettingsFontsAllowedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const LocalFontsPageElementBase = SettingsViewMixin(PolymerElement);
class LocalFontsPageElement extends LocalFontsPageElementBase {
    static get is() {
        return 'settings-local-fonts-page';
    }
    static get template() {
        return getTemplate$_();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(LocalFontsPageElement.is, LocalFontsPageElement);

function getTemplate$Z() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsLocalNetworkAccess}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsLocalNetworkAccessDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.LOCAL_NETWORK_ACCESS]]"
      allow-option-label="$i18n{siteSettingsLocalNetworkAccessAsk}"
      allow-option-icon="settings20:router"
      block-option-label="$i18n{siteSettingsLocalNetworkAccessBlock}"
      block-option-icon="settings20:router-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.LOCAL_NETWORK_ACCESS]]"
      block-header=
          "$i18n{siteSettingsLocalNetworkAccessBlockedExceptions}"
      allow-header=
          "$i18n{siteSettingsLocalNetworkAccessAllowedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const LocalNetworkAcessPageElementBase = SettingsViewMixin(PolymerElement);
class LocalNetworkAcessPageElement extends LocalNetworkAcessPageElementBase {
    static get is() {
        return 'settings-local-network-access-page';
    }
    static get template() {
        return getTemplate$Z();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(LocalNetworkAcessPageElement.is, LocalNetworkAcessPageElement);

function getTemplate$Y() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryMicrophone}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <media-picker label="$i18n{siteSettingsMicrophoneLabel}" type="mic">
  </media-picker>
  <div class="content-settings-header secondary">
    $i18n{siteSettingsMicDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.MIC]]"
      allow-option-label="$i18n{siteSettingsMicAllowed}"
      allow-option-icon="privacy:mic"
      block-option-label="$i18n{siteSettingsMicBlocked}"
      block-option-sub-label="$i18n{siteSettingsMicBlockedSubLabel}"
      block-option-icon="privacy:mic-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.MIC]]" read-only-list
      allow-header="$i18n{siteSettingsMicAllowedExceptions}"
      block-header="$i18n{siteSettingsMicBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MicrophonePageElementBase = SettingsViewMixin(PolymerElement);
class MicrophonePageElement extends MicrophonePageElementBase {
    static get is() {
        return 'settings-microphone-page';
    }
    static get template() {
        return getTemplate$Y();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(MicrophonePageElement.is, MicrophonePageElement);

function getTemplate$X() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsMidiDevices}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsMidiDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.MIDI_DEVICES]]"
      allow-option-label="$i18n{siteSettingsMidiAllowed}"
      allow-option-icon="privacy:piano"
      block-option-label="$i18n{siteSettingsMidiBlocked}"
      block-option-icon="privacy:piano-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.MIDI_DEVICES]]"
      read-only-list
      allow-header="$i18n{siteSettingsMidiAllowedExceptions}"
      block-header="$i18n{siteSettingsMidiBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MidiDevicesPageElementBase = SettingsViewMixin(PolymerElement);
class MidiDevicesPageElement extends MidiDevicesPageElementBase {
    static get is() {
        return 'settings-midi-devices-page';
    }
    static get template() {
        return getTemplate$X();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(MidiDevicesPageElement.is, MidiDevicesPageElement);

function getTemplate$W() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryNotifications}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
<template is="dom-if"
    if="[[enablePermissionSiteSettingsRadioButton_]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsNotificationsDescription}
  </div>
</template>
<div id="notificationRadioGroup" class="radio-group">
  <template is="dom-if" if="[[showNotificationPermissionsReview_]]">
    <template is="dom-if" if="[[shouldShowSafetyHub_]]">
      <h2>$i18n{safetyHub}</h2>
      <settings-safety-hub-module id="safetyHubEntryPoint"
          header="[[notificationPermissionsReviewHeader_]]"
          subheader="[[notificationPermissionsReviewSubheader_]]"
          header-icon="cr:security" header-icon-color="blue">
        <cr-button id="safetyHubButton" slot="button-container"
            class="action-button" on-click="onSafetyHubButtonClick_">
          $i18n{safetyHubEntryPointButtonLabel}
        </cr-button>
      </settings-safety-hub-module>
    </template>
  </template>
  <template is="dom-if"
      if="[[!enablePermissionSiteSettingsRadioButton_]]">
    <h2>$i18n{siteSettingsDefaultBehavior}</h2>
    <div id="notificationSubHeading"
        class="secondary radio-sub-heading">
      $i18n{siteSettingsNotificationsDefaultBehaviorDescription}
    </div>
    <cr-radio-group
        on-selected-changed="onNotificationTopLevelRadioChanged_">
      <cr-radio-button
          id="notificationAskRadioButton"
          name="notification-ask-radio-button"
          checked$="[[isNotificationAllowed_]]">
        <cr-icon icon="privacy:notifications"></cr-icon>
        $i18n{siteSettingsNotificationsAskState}
      </cr-radio-button>
      <settings-radio-group
          id="notificationCpssRadioGroup"
          pref="{{prefs.generated.notification}}"
          selectable-elements="cr-radio-button"
          hidden$="[[!isNotificationAllowed_]]">
        <cr-radio-button class="padded-radio-section"
            id="notificationAskQuiet"
            name="[[settingsStateEnum_.QUIET]]"
            pref="[[prefs.generated.notification]]"
            label="$i18n{siteSettingsNotificationsAskQuiet}">
        </cr-radio-button>
        <cr-radio-button class="padded-radio-section"
            id="notificationAskCpss"
            name="[[settingsStateEnum_.CPSS]]"
            pref="[[prefs.generated.notification]]"
            label="$i18n{siteSettingsNotificationsAskCPSS}">
        </cr-radio-button>
        <cr-radio-button class="padded-radio-section"
            id="notificationAskLoud"
            name="[[settingsStateEnum_.LOUD]]"
            pref="[[prefs.generated.notification]]"
            label="$i18n{siteSettingsNotificationsAskLoud}">
        </cr-radio-button>
      </settings-radio-group>
      <cr-radio-button class="two-line"
          id="notificationBlock"
          name="notification-block-radio-button"
          sub-label="$i18n{siteSettingsNotificationsBlockedSubLabel}"
          checked$="[[!isNotificationAllowed_]]">
        <cr-icon icon="privacy:notifications-off"></cr-icon>
        $i18n{siteSettingsNotificationsBlocked}
      </cr-radio-button>
    </cr-radio-group>
  </template>
</div>
<template is="dom-if"
    if="[[enablePermissionSiteSettingsRadioButton_]]">
  <settings-category-default-radio-group
      id="notificationDefaultRadioGroup"
      category="[[contentSettingsTypesEnum_.NOTIFICATIONS]]"
      allow-option-label="$i18n{siteSettingsNotificationsAskState}"
      allow-option-icon="privacy:notifications"
      block-option-label="$i18n{siteSettingsNotificationsBlocked}"
      block-option-icon="privacy:notifications-off"
      on-selected-changed="onNotificationTopLevelRadioChanged2_">
  </settings-category-default-radio-group>
  <div class="radio-group"
      hidden$="[[!isNotificationAllowed_]]">
    <h2 class="cpss-heading">$i18n{siteSettingsHowToShowRequests}</h2>
    <settings-radio-group
        id="notificationCpssRadioGroup"
        pref="{{prefs.generated.notification}}"
        selectable-elements="settings-collapse-radio-button">
      <settings-collapse-radio-button
          id="notificationAskQuiet"
          name="[[settingsStateEnum_.QUIET]]"
          pref="[[prefs.generated.notification]]"
          label="$i18n{siteSettingsNotificationsAskQuiet}"
          no-collapse>
      </settings-collapse-radio-button>
      <settings-collapse-radio-button
          id="notificationAskCpss"
          name="[[settingsStateEnum_.CPSS]]"
          pref="[[prefs.generated.notification]]"
          label="$i18n{siteSettingsNotificationsAskCPSS}"
          no-collapse>
      </settings-collapse-radio-button>
      <settings-collapse-radio-button
          id="notificationAskLoud"
          name="[[settingsStateEnum_.LOUD]]"
          pref="[[prefs.generated.notification]]"
          label="$i18n{siteSettingsNotificationsAskLoud}"
          no-collapse>
      </settings-collapse-radio-button>
    </settings-radio-group>
  </div>
</template>
<category-setting-exceptions
    category="[[contentSettingsTypesEnum_.NOTIFICATIONS]]"
    allow-header="$i18n{siteSettingsNotificationsAllowedExceptions}"
    block-header="$i18n{siteSettingsNotificationsBlockedExceptions}"
    search-filter="[[searchTerm]]">
</category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-notifications-subpage' contains the settings for notifications
 * under Site Settings.
 */
const NotificationsPageElementBase = RouteObserverMixin(SettingsViewMixin(WebUiListenerMixin(PrefsMixin(PolymerElement))));
class NotificationsPageElement extends NotificationsPageElementBase {
    static get is() {
        return 'settings-notifications-page';
    }
    static get template() {
        return getTemplate$W();
    }
    static get properties() {
        return {
            searchTerm: {
                type: String,
                notify: true,
                value: '',
            },
            isGuest_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('isGuest');
                },
            },
            enablePermissionSiteSettingsRadioButton_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('enablePermissionSiteSettingsRadioButton'),
            },
            /** Expose the Permissions SettingsState enum to HTML bindings. */
            settingsStateEnum_: {
                type: Object,
                value: SettingsState,
            },
            /** Expose ContentSettingsTypes enum to HTML bindings. */
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
            showNotificationPermissionsReview_: {
                type: Boolean,
                value: false,
            },
            /** Expose ContentSetting enum to HTML bindings. */
            contentSettingEnum_: {
                type: Object,
                value: ContentSetting,
            },
            shouldShowSafetyHub_: {
                type: Boolean,
                value() {
                    return !loadTimeData.getBoolean('isGuest');
                },
            },
            isNotificationAllowed_: Boolean,
            notificationPermissionsReviewHeader_: String,
            notificationPermissionsReviewSubheader_: String,
        };
    }
    siteSettingsBrowserProxy_ = SiteSettingsBrowserProxyImpl.getInstance();
    safetyHubBrowserProxy_ = SafetyHubBrowserProxyImpl.getInstance();
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    ready() {
        super.ready();
        this.updateNotificationState_();
        if (this.isGuest_) {
            return;
        }
        this.addWebUiListener(SafetyHubEvent.NOTIFICATION_PERMISSIONS_MAYBE_CHANGED, (sites) => this.onReviewNotificationPermissionListChanged_(sites));
        this.safetyHubBrowserProxy_.getNotificationPermissionReview().then((sites) => this.onReviewNotificationPermissionListChanged_(sites));
    }
    currentRouteChanged(newRoute, oldRoute) {
        super.currentRouteChanged(newRoute, oldRoute);
        // Only record the metrics when the user navigates to the notification
        // settings page that shows the entry point.
        if (this.showNotificationPermissionsReview_) {
            this.metricsBrowserProxy_.recordSafetyHubEntryPointShown(SafetyHubEntryPoint.NOTIFICATIONS);
        }
    }
    async onReviewNotificationPermissionListChanged_(permissions) {
        // The notification permissions review is shown when there are items to
        // review (provided the feature is enabled and should be shown). Once
        // visible it remains that way to show completion info, even if the list is
        // emptied.
        if (this.showNotificationPermissionsReview_) {
            return;
        }
        this.showNotificationPermissionsReview_ =
            !this.isGuest_ && permissions.length > 0;
        this.notificationPermissionsReviewHeader_ =
            await PluralStringProxyImpl.getInstance().getPluralString('safetyHubNotificationPermissionsPrimaryLabel', permissions.length);
        this.notificationPermissionsReviewSubheader_ =
            await PluralStringProxyImpl.getInstance().getPluralString('safetyHubNotificationPermissionsSecondaryLabel', permissions.length);
    }
    async updateNotificationState_() {
        const [notificationDefaultValue] = await Promise.all([
            this.siteSettingsBrowserProxy_.getDefaultValueForContentType(ContentSettingsTypes.NOTIFICATIONS),
        ]);
        this.isNotificationAllowed_ =
            (notificationDefaultValue.setting === ContentSetting.ASK);
    }
    onNotificationTopLevelRadioChanged_(event) {
        const radioButtonName = event.detail.value;
        switch (radioButtonName) {
            case 'notification-block-radio-button':
                this.setPrefValue('generated.notification', SettingsState.BLOCK);
                this.isNotificationAllowed_ = false;
                break;
            case 'notification-ask-radio-button':
                this.setPrefValue('generated.notification', SettingsState.CPSS);
                this.isNotificationAllowed_ = true;
                break;
        }
    }
    onNotificationTopLevelRadioChanged2_(event) {
        const selected = event.detail.value;
        if (selected) {
            this.setPrefValue('generated.notification', SettingsState.CPSS);
            this.isNotificationAllowed_ = true;
        }
        else {
            this.setPrefValue('generated.notification', SettingsState.BLOCK);
            this.isNotificationAllowed_ = false;
        }
    }
    onSafetyHubButtonClick_() {
        this.metricsBrowserProxy_.recordSafetyHubEntryPointClicked(SafetyHubEntryPoint.NOTIFICATIONS);
        Router.getInstance().navigateTo(routes.SAFETY_HUB);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(NotificationsPageElement.is, NotificationsPageElement);

function getTemplate$V() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsPaymentHandler}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsPaymentHandlersDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.PAYMENT_HANDLER]]"
      allow-option-label=
          "$i18n{siteSettingsPaymentHandlersAllowed}"
      allow-option-icon="privacy:credit-card"
      block-option-label="$i18n{siteSettingsPaymentHandlersBlocked}"
      block-option-icon="privacy:credit-card-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.PAYMENT_HANDLER]]"
      allow-header=
          "$i18n{siteSettingsPaymentHandlersAllowedExceptions}"
      block-header=
          "$i18n{siteSettingsPaymentHandlersBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PaymentHandlerPageElementBase = SettingsViewMixin(PolymerElement);
class PaymentHandlerPageElement extends PaymentHandlerPageElementBase {
    static get is() {
        return 'settings-payment-handler-page';
    }
    static get template() {
        return getTemplate$V();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(PaymentHandlerPageElement.is, PaymentHandlerPageElement);

function getTemplate$U() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsPdfDocuments}">
  <div class="radio-group">
    <div class="secondary">$i18n{siteSettingsPdfsDescription}</div>
    <h2>$i18n{siteSettingsDefaultBehavior}</h2>
    <div class="secondary radio-sub-heading">
      $i18n{siteSettingsDefaultBehaviorDescription}
    </div>
    <settings-radio-group
        pref="{{prefs.plugins.always_open_pdf_externally}}"
        selectable-elements="settings-collapse-radio-button">
      <settings-collapse-radio-button no-collapse
          pref="[[prefs.plugins.always_open_pdf_externally]]"
          label="$i18n{siteSettingsPdfsAllowed}"
          name="true"
          disabled="[[isGuest_]]"
          icon="cr:file-download">
      </settings-collapse-radio-button>
      <settings-collapse-radio-button no-collapse
          pref="[[prefs.plugins.always_open_pdf_externally]]"
          label="$i18n{siteSettingsPdfsBlocked}"
          name="false"
          disabled="[[isGuest_]]"
          icon="privacy:open-in-browser">
      </settings-collapse-radio-button>
    </settings-radio-group>
  </div>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PdfDocumentsPageElementBase = SettingsViewMixin(PolymerElement);
class PdfDocumentsPageElement extends PdfDocumentsPageElementBase {
    static get is() {
        return 'settings-pdf-documents-page';
    }
    static get template() {
        return getTemplate$U();
    }
    static get properties() {
        return {
            isGuest_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('isGuest');
                },
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(PdfDocumentsPageElement.is, PdfDocumentsPageElement);

function getTemplate$T() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryPopups}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsPopupsDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.POPUPS]]"
      allow-option-label="$i18n{siteSettingsPopupsAllowed}"
      allow-option-icon="cr:open-in-new"
      block-option-label="$i18n{siteSettingsPopupsBlocked}"
      block-option-icon="privacy:open-in-new-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.POPUPS]]"
      allow-header="$i18n{siteSettingsPopupsAllowedExceptions}"
      block-header="$i18n{siteSettingsPopupsBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PopupsPageElementBase = SettingsViewMixin(PolymerElement);
class PopupsPageElement extends PopupsPageElementBase {
    static get is() {
        return 'settings-popups-page';
    }
    static get template() {
        return getTemplate$T();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(PopupsPageElement.is, PopupsPageElement);

function getTemplate$S() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style settings-shared site-settings-shared"></style>

<settings-subpage page-title="$i18n{siteSettingsProtectedContent}"
    route-path$="[[routePath]]">


  <div class="radio-group">
    <div class="secondary">
      $i18n{siteSettingsProtectedContentDescription}
    </div>
    <h2>$i18n{siteSettingsDefaultBehavior}</h2>
    <div class="secondary radio-sub-heading">
      $i18n{siteSettingsDefaultBehaviorDescription}
    </div>
    <settings-radio-group
        pref="{{prefs.webkit.webprefs.encrypted_media_enabled}}"
        selectable-elements="settings-collapse-radio-button">
      <settings-collapse-radio-button no-collapse
          pref="[[prefs.webkit.webprefs.encrypted_media_enabled]]"
          label="$i18n{siteSettingsProtectedContentAllowed}"
          name="true"
          disabled$="[[isGuest_]]"
          icon="privacy:sync-saved-locally">
      </settings-collapse-radio-button>
      <settings-collapse-radio-button no-collapse
          pref="[[prefs.webkit.webprefs.encrypted_media_enabled]]"
          label="$i18n{siteSettingsProtectedContentBlocked}"
          sub-label="$i18n{siteSettingsProtectedContentBlockedSubLabel}"
          name="false"
          disabled$="[[isGuest_]]"
          icon="privacy:sync-saved-locally-off">
      </settings-collapse-radio-button>
    </settings-radio-group>
  </div>

</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ProtectedContentPageElementBase = SettingsViewMixin(PrefsMixin(PolymerElement));
class ProtectedContentPageElement extends ProtectedContentPageElementBase {
    static get is() {
        return 'settings-protected-content-page';
    }
    static get template() {
        return getTemplate$S();
    }
    static get properties() {
        return {
            searchTerm: {
                type: String,
                notify: true,
                value: '',
            },
            isGuest_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('isGuest');
                },
            },
            /** Expose ContentSettingsTypes enum to HTML bindings. */
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(ProtectedContentPageElement.is, ProtectedContentPageElement);

function getTemplate$R() {
    return html `<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">:host{display:block}.column-header{margin-bottom:15px;margin-inline-start:20px;margin-top:15px}#radioGroup{padding:0 var(--cr-section-padding)}#radioGroupSubHeading{padding-bottom:10px}#appHandlerSubHeading{padding-bottom:10px}#appIcon{width:16px;height:16px;background-repeat:no-repeat;background-size:contain}settings-collapse-radio-button{--settings-collapse-toggle-min-height:var(--cr-section-min-height)}settings-collapse-radio-button:not(:first-of-type){--settings-collapse-separator-line:var(--cr-separator-line)}
  </style>
  <settings-subpage page-title="$i18n{siteSettingsCategoryHandlers}"
      route-path$="[[routePath]]">
    <div id="radioGroup">
      <div class="secondary">
        $i18n{siteSettingsProtocolHandlersDescription}
      </div>
      <h2>$i18n{siteSettingsDefaultBehavior}</h2>
      <div id="radioSubHeading" class="secondary">
        $i18n{siteSettingsDefaultBehaviorDescription}
      </div>
      <settings-radio-group
        id="protcolHandlersRadio"
        pref="[[handlersEnabledPref_]]"
        on-change="onToggleChange_"
        selectable-elements="settings-collapse-radio-button">
        <settings-collapse-radio-button no-collapse
            id="protcolHandlersRadioAllow"
            pref="[[handlersEnabledPref_]]"
            label="$i18n{siteSettingsProtocolHandlersAllowed}"
            name="true"
            disabled$="[[isGuest_]]"
            icon="privacy:protocol-handler">
        </settings-collapse-radio-button>
        <settings-collapse-radio-button no-collapse
            id="protcolHandlersRadioBlock"
            pref="[[handlersEnabledPref_]]"
            label="$i18n{siteSettingsProtocolHandlersBlocked}"
            name="false"
            disabled$="[[isGuest_]]"
            icon="privacy:protocol-handler-off">
        </settings-collapse-radio-button>
      </settings-radio-group>
    </div>

    <template is="dom-repeat" items="[[protocols]]" as="protocol">
      <div class="column-header">[[protocol.protocol_display_name]]</div>

      <div class="list-frame menu-content vertical-list">
        <template is="dom-repeat" items="[[protocol.handlers]]">

          <div class="list-item">
            <site-favicon url="[[item.host]]"></site-favicon>
            <div class="middle" >
              <div class="protocol-host">
                <span class="url-directionality">[[item.host]]</span>
              </div>
              <div class="secondary protocol-default"
                  hidden$="[[!item.is_default]]">
                $i18n{handlerIsDefault}
              </div>
            </div>

            <cr-icon-button class="icon-more-vert" on-click="showMenu_"
                title="$i18n{moreActions}"></cr-icon-button>
          </div>
        </template>
      </div>
    </template>

    <cr-action-menu role-description="$i18n{menu}">
      <button class="dropdown-item" on-click="onDefaultClick_"
          id="defaultButton" disabled$="[[actionMenuModel_.is_default]]">
        $i18n{handlerSetDefault}
      </button>
      <button class="dropdown-item" on-click="onRemoveClick_"
          id="removeButton">
        $i18n{handlerRemove}
      </button>
    </cr-action-menu>

    <template is="dom-if" if="[[ignoredProtocols.length]]">
      <div class="column-header">
        $i18n{siteSettingsProtocolHandlersBlockedExceptions}
      </div>
      <div class="list-frame menu-content vertical-list">
        <template is="dom-repeat" items="[[ignoredProtocols]]">
          <div class="list-item">
            <site-favicon url="[[item.host]]"></site-favicon>
            <div class="middle" >
              <div class="protocol-host">
                <span class="url-directionality">[[item.host]]</span></div>
              <div class="secondary protocol-protocol">
                [[item.protocol_display_name]]
              </div>
            </div>
            <cr-icon-button class="icon-clear" id="removeIgnoredButton"
                on-click="onRemoveIgnored_" title="$i18n{handlerRemove}">
            </cr-icon-button>
          </div>
        </template>
      </div>
    </template>

    <div class="column-header" hidden$="[[!showAppsProtocolHandlersTitle_]]">
      <h2>$i18n{siteSettingsAppProtocolHandlers}</h2>
    </div>

    <div class="column-header" hidden$="[[!appAllowedProtocols.length]]">
      <div id="appHandlerSubHeading" class="secondary">
        $i18n{siteSettingsAppAllowedProtocolHandlersDescription}
      </div>
    </div>

    <template is="dom-repeat" items="[[appAllowedProtocols]]" as="appProtocol">
      <div class="column-header">[[appProtocol.protocol_display_name]]</div>
      <div class="list-frame menu-content vertical-list">
        <template is="dom-repeat" items="[[appProtocol.handlers]]">
          <div class="list-item">
            <div id="appIcon"
                style="background-image: url('chrome://app-icon/[[item.app_id]]/16')">
            </div>
            <div class="middle protocol-app-name">
              <span class$="[[getNameCssClass_(item)]]">
                [[getNameText_(item)]]
              </span>
            </div>
            <cr-icon-button class="icon-clear" id="removeAppHandlerButton"
                on-click="onRemoveAppAllowedHandlerButtonClick_"
                title="$i18n{handlerRemove}">
            </cr-icon-button>
          </div>
        </template>
      </div>
    </template>

    <div class="column-header" hidden$="[[!appDisallowedProtocols.length]]">
      <div id="appHandlerSubHeading" class="secondary">
        $i18n{siteSettingsAppDisallowedProtocolHandlersDescription}
      </div>
    </div>

    <template is="dom-repeat" items="[[appDisallowedProtocols]]"
        as="appProtocol">
      <div class="column-header">[[appProtocol.protocol_display_name]]</div>
      <div class="list-frame menu-content vertical-list">
        <template is="dom-repeat" items="[[appProtocol.handlers]]">
          <div class="list-item">
            <div id="appIcon"
                style="background-image: url('chrome://app-icon/[[item.app_id]]/16')">
            </div>
            <div class="middle protocol-app-name">
              <span class$="[[getNameCssClass_(item)]]">
                [[getNameText_(item)]]
              </span>
            </div>
            <cr-icon-button class="icon-clear" id="removeAppHandlerButton"
                on-click="onRemoveAppDisallowedHandlerButtonClick_"
                title="$i18n{handlerRemove}">
            </cr-icon-button>
          </div>
        </template>
      </div>
    </template>
  </settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'protocol-handlers' is the polymer element for showing the
 * protocol handlers category under Site Settings.
 */
const ProtocolHandlersElementBase = SettingsViewMixin(WebUiListenerMixin(SiteSettingsMixin(PolymerElement)));
class ProtocolHandlersElement extends ProtocolHandlersElementBase {
    static get is() {
        return 'protocol-handlers';
    }
    static get template() {
        return getTemplate$R();
    }
    static get properties() {
        return {
            /**
             * Array of protocols and their handlers.
             */
            protocols: Array,
            /**
             * Array of allowed app protocols and their handlers.
             */
            appAllowedProtocols: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * Array of disallowed app protocols and their handlers.
             */
            appDisallowedProtocols: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * Used to determine if the apps title should be shown.
             */
            showAppsProtocolHandlersTitle_: {
                type: Boolean,
                value: false,
            },
            /**
             * The targeted object for menu operations.
             */
            actionMenuModel_: Object,
            /* Labels for the toggle on/off positions. */
            toggleOffLabel: String,
            toggleOnLabel: String,
            /**
             * Array of ignored (blocked) protocols.
             */
            ignoredProtocols: Array,
            handlersEnabledPref_: {
                type: Object,
                value() {
                    return {
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: false,
                    };
                },
            },
        };
    }
    ready() {
        super.ready();
        this.addWebUiListener('setHandlersEnabled', (enabled) => this.setHandlersEnabled_(enabled));
        this.addWebUiListener('setProtocolHandlers', (protocols) => this.setProtocolHandlers_(protocols));
        this.addWebUiListener('setIgnoredProtocolHandlers', (ignoredProtocols) => this.setIgnoredProtocolHandlers_(ignoredProtocols));
        this.browserProxy.observeProtocolHandlers();
        // Web App Observer
        this.addWebUiListener('setAppAllowedProtocolHandlers', this.setAppAllowedProtocolHandlers_.bind(this));
        this.addWebUiListener('setAppDisallowedProtocolHandlers', this.setAppDisallowedProtocolHandlers_.bind(this));
        this.browserProxy.observeAppProtocolHandlers();
    }
    /**
     * Obtains the description for the main toggle.
     * @return The description to use.
     */
    computeHandlersDescription_() {
        return this.handlersEnabledPref_.value ? this.toggleOnLabel :
            this.toggleOffLabel;
    }
    /**
     * Updates the main toggle to set it enabled/disabled.
     * @param enabled The state to set.
     */
    setHandlersEnabled_(enabled) {
        this.set('handlersEnabledPref_.value', enabled);
    }
    /**
     * Updates the list of protocol handlers.
     * @param protocols The new protocol handler list.
     */
    setProtocolHandlers_(protocols) {
        this.protocols = protocols;
    }
    /**
     * Updates the list of ignored protocol handlers.
     * @param ignoredProtocols The new (ignored) protocol handler list.
     */
    setIgnoredProtocolHandlers_(ignoredProtocols) {
        this.ignoredProtocols = ignoredProtocols;
    }
    /**
     * Updates the list of allowed app protocol handlers.
     * @param appAllowedProtocols The new allowed app protocol handler list.
     */
    setAppAllowedProtocolHandlers_(appAllowedProtocols) {
        this.appAllowedProtocols = appAllowedProtocols;
        this.updateShowAppsProtocolHandlersTitle_();
    }
    /**
     * Updates the list of disallowed app protocol handlers.
     * @param appDisallowedProtocols The new disallowed app protocol
     *     handler list.
     */
    setAppDisallowedProtocolHandlers_(appDisallowedProtocols) {
        this.appDisallowedProtocols = appDisallowedProtocols;
        this.updateShowAppsProtocolHandlersTitle_();
    }
    /**
     * Determines if the app header should be shown.
     */
    updateShowAppsProtocolHandlersTitle_() {
        this.showAppsProtocolHandlersTitle_ =
            (this.appAllowedProtocols && this.appAllowedProtocols.length > 0) ||
                (this.appDisallowedProtocols && this.appDisallowedProtocols.length > 0);
    }
    /**
     * Closes action menu and resets action menu model
     */
    closeActionMenu_() {
        this.shadowRoot.querySelector('cr-action-menu').close();
        this.actionMenuModel_ = null;
    }
    /**
     * A handler when the toggle is flipped.
     */
    onToggleChange_() {
        this.browserProxy.setProtocolHandlerDefault(!!this.handlersEnabledPref_.value);
    }
    /**
     * The handler for when "Set Default" is selected in the action menu.
     */
    onDefaultClick_() {
        const item = this.actionMenuModel_;
        this.browserProxy.setProtocolDefault(item.protocol, item.spec);
        this.closeActionMenu_();
    }
    /**
     * The handler for when "Remove" is selected in the action menu.
     */
    onRemoveClick_() {
        const item = this.actionMenuModel_;
        this.browserProxy.removeProtocolHandler(item.protocol, item.spec);
        this.closeActionMenu_();
    }
    /**
     * Handler for removing web app protocol handlers that were allowed.
     */
    onRemoveAppAllowedHandlerButtonClick_(event) {
        const item = event.model.item;
        this.browserProxy.removeAppAllowedHandler(item.protocol, item.spec, item.app_id);
    }
    /**
     * Handler for removing web app protocol handlers that were disallowed.
     */
    onRemoveAppDisallowedHandlerButtonClick_(event) {
        const item = event.model.item;
        this.browserProxy.removeAppDisallowedHandler(item.protocol, item.spec, item.app_id);
    }
    /**
     * Handler for removing handlers that were blocked
     */
    onRemoveIgnored_(event) {
        const item = event.model.item;
        this.browserProxy.removeProtocolHandler(item.protocol, item.spec);
    }
    /**
     * A handler to show the action menu next to the clicked menu button.
     */
    showMenu_(event) {
        this.actionMenuModel_ = event.model.item;
        this.shadowRoot.querySelector('cr-action-menu').showAt(event.target);
    }
    getNameCssClass_(item) {
        return item.app_name ? '' : 'url-directionality';
    }
    getNameText_(item) {
        return item.app_name || item.host;
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(ProtocolHandlersElement.is, ProtocolHandlersElement);

function getTemplate$Q() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsSensors}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsMotionSensorsDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.SENSORS]]"
      allow-option-label="$i18n{siteSettingsMotionSensorsAllowed}"
      allow-option-icon="privacy:sensors"
      block-option-label="$i18n{siteSettingsMotionSensorsBlocked}"
      block-option-sub-label=
          "$i18n{siteSettingsMotionSensorsBlockedSubLabel}"
      block-option-icon="privacy:sensors-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.SENSORS]]" read-only-list
      allow-header="$i18n{siteSettingsMotionSensorsAllowedExceptions}"
      block-header="$i18n{siteSettingsMotionSensorsBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SensorsPageElementBase = SettingsViewMixin(PolymerElement);
class SensorsPageElement extends SensorsPageElementBase {
    static get is() {
        return 'settings-sensors-page';
    }
    static get template() {
        return getTemplate$Q();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SensorsPageElement.is, SensorsPageElement);

function getTemplate$P() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsSerialPorts}"
    learn-more-url="$i18n{chooserSerialOverviewUrl}"
    route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsSerialPortsDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.SERIAL_PORTS]]"
      allow-option-label="$i18n{siteSettingsSerialPortsAllowed}"
      allow-option-icon="privacy:developer-board"
      block-option-label="$i18n{siteSettingsSerialPortsBlocked}"
      block-option-icon="privacy:developer-board-off">
  </settings-category-default-radio-group>
  <chooser-exception-list
      category="[[contentSettingsTypesEnum_.SERIAL_PORTS]]"
      chooser-type="[[chooserTypeEnum_.SERIAL_PORTS]]">
  </chooser-exception-list>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SerialPortsPageElementBase = SettingsViewMixin(PolymerElement);
class SerialPortsPageElement extends SerialPortsPageElementBase {
    static get is() {
        return 'settings-serial-ports-page';
    }
    static get template() {
        return getTemplate$P();
    }
    static get properties() {
        return {
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
            // Expose ChooserType enum to the HTML template.
            chooserTypeEnum_: {
                type: Object,
                value: ChooserType,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SerialPortsPageElement.is, SerialPortsPageElement);

function getTemplate$O() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteDataPageTitle}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
<div class="content-settings-header secondary">
  $i18n{siteDataPageDescription}
</div>
<div class="radio-group">
  <h2>$i18n{siteDataPageDefaultBehavior}</h2>
  <div class="secondary radio-group-sub-heading">
    $i18n{siteDataPagedefaultBehaviorDescription}
  </div>
  <settings-radio-group id="defaultGroup" no-set-pref
      pref="{{prefs.generated.cookie_default_content_setting}}"
      selectable-elements="cr-radio-button, settings-collapse-radio-button"
      on-change="onDefaultRadioChange_">
    <settings-collapse-radio-button id="defaultAllow" no-collapse
        name="[[contentSettingEnum_.ALLOW]]"
        pref="[[prefs.generated.cookie_default_content_setting]]"
        label="$i18n{siteDataPageAllowRadioLabel}"
        sub-label="$i18n{siteDataPageAllowRadioSubLabel}"
        icon="privacy:database">
    </settings-collapse-radio-button>
    <settings-collapse-radio-button id="defaultSessionOnly" no-collapse
        class="two-line"
        name="[[contentSettingEnum_.SESSION_ONLY]]"
        pref="[[prefs.generated.cookie_default_content_setting]]"
        label="$i18n{siteDataPageClearOnExitRadioLabel}"
        sub-label="$i18n{siteDataPageClearOnExitRadioSubLabel}"
        icon="privacy:database">
    </settings-collapse-radio-button>
    <settings-collapse-radio-button id="defaultBlock" no-collapse
        class="two-line"
        name="[[contentSettingEnum_.BLOCK]]"
        pref="[[prefs.generated.cookie_default_content_setting]]"
        label="$i18n{siteDataPageBlockRadioLabel}"
        sub-label="$i18n{siteDataPageBlockRadioSublabel}"
        icon="privacy:database-off">
    </settings-collapse-radio-button>
  </settings-radio-group>
</div>
<div id="exceptionHeader">
  <h2>$i18n{siteDataPageCustomizedBehaviorHeading}</h2>
  <div id="exceptionHeaderSubLabel" class="secondary">
    $i18n{siteDataPageCustomizedBehaviorDescription}
  </div>
</div>
<site-list id="allowExceptionsList"
    category="[[cookiesContentSettingType_]]"
    category-subtype="[[contentSettingEnum_.ALLOW]]"
    category-header="$i18n{siteDataPageAllowExceptionsSubHeading}"
    read-only-list="[[exceptionListsReadOnly_]]"
    search-filter="[[searchTerm]]"
    cookies-exception-type="site-data">
</site-list>
<site-list id="sessionOnlyExceptionsList"
    category="[[cookiesContentSettingType_]]"
    category-subtype="[[contentSettingEnum_.SESSION_ONLY]]"
    category-header="$i18n{siteDataPageDeleteOnExitExceptionsSubHeading}"
    read-only-list="[[exceptionListsReadOnly_]]"
    search-filter="[[searchTerm]]"
    cookies-exception-type="site-data">
</site-list>
<!-- Shows all block-exceptions (in contrast to allow and session above). -->
<site-list id="blockExceptionsList"
    category="[[cookiesContentSettingType_]]"
    category-subtype="[[contentSettingEnum_.BLOCK]]"
    category-header="$i18n{siteDataPageBlockExceptionsSubHeading}"
    read-only-list="[[exceptionListsReadOnly_]]"
    search-filter="[[searchTerm]]"
    cookies-exception-type="combined">
</site-list>
<template is="dom-if" if="[[showDefaultBlockDialog_]]" restamp>
  <cr-dialog id="defaultBlockDialog" show-on-attach>
    <div slot="title">$i18n{siteDataPageBlockConfirmDialogTitle}</div>
    <div slot="body">$i18n{siteDataPageBlockConfirmDialogDescription}</div>
    <div slot="button-container">
    <cr-button id="defaultBlockDialogCancel" class="cancel-button"
        on-click="onDefaultBlockDialogCancel_">
        $i18n{siteDataPageBlockConfirmDialogCancelButton}
    </cr-button>
    <cr-button id="defaultBlockDialogConfirm" class="action-button"
        on-click="onDefaultBlockDialogConfirm_">
        $i18n{siteDataPageBlockConfirmDialogConfirmButton}
    </cr-button>
    </div>
  </cr-dialog>
</template>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-site-data' is the polymer element for showing the
 * settings for site data under Site Settings.
 */
const SettingsSiteDataElementBase = SettingsViewMixin(PrefsMixin(PolymerElement));
class SettingsSiteDataElement extends SettingsSiteDataElementBase {
    static get is() {
        return 'settings-site-data';
    }
    static get template() {
        return getTemplate$O();
    }
    static get properties() {
        return {
            /** Current search term. */
            searchTerm: {
                type: String,
                notify: true,
                value: '',
            },
            cookiesContentSettingType_: {
                type: String,
                value: ContentSettingsTypes.COOKIES,
            },
            /** Expose ContentSetting enum to HTML bindings. */
            contentSettingEnum_: {
                type: Object,
                value: ContentSetting,
            },
            exceptionListsReadOnly_: {
                type: Boolean,
                value: false,
            },
            showDefaultBlockDialog_: Boolean,
        };
    }
    static get observers() {
        return [`onGeneratedPrefsUpdated_(
        prefs.generated.cookie_default_content_setting)`];
    }
    onGeneratedPrefsUpdated_() {
        const pref = this.getPref('generated.cookie_default_content_setting');
        // If the pref is managed this implies a content setting policy is present
        // and the exception lists should be disabled.
        this.exceptionListsReadOnly_ =
            pref.enforcement === chrome.settingsPrivate.Enforcement.ENFORCED;
    }
    onDefaultRadioChange_() {
        const selected = this.$.defaultGroup.selected;
        if (selected === ContentSetting.BLOCK) {
            this.showDefaultBlockDialog_ = true;
        }
        else {
            this.$.defaultGroup.sendPrefChange();
        }
    }
    onDefaultBlockDialogCancel_() {
        this.$.defaultGroup.resetToPrefValue();
        this.showDefaultBlockDialog_ = false;
        // Set focus back to the block button regardless of user interaction
        // with the dialog, as it was the entry point to the dialog.
        focusWithoutInk(this.$.defaultBlock);
    }
    onDefaultBlockDialogConfirm_() {
        this.$.defaultGroup.sendPrefChange();
        this.showDefaultBlockDialog_ = false;
        // Set focus back to the block button regardless of user interaction
        // with the dialog, as it was the entry point to the dialog.
        focusWithoutInk(this.$.defaultBlock);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsSiteDataElement.is, SettingsSiteDataElement);

function getTemplate$N() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{align-items:center;position:relative;vertical-align:middle}.policy-icon{margin-inline-start:16px;padding:8px}.settings-row{flex:1}</style>

<div class="list-item focus-row-active">
  <div class="settings-row middle no-min-width text-elide">
    <span class="url-directionality">[[exception.displayName]]</span>
  </div>
  <template is="dom-if" if="[[shouldShowPolicyPrefIndicator_(exception)]]">
    <cr-policy-pref-indicator class="policy-icon"
        pref="[[getPolicyPref_(exception)]]"
        icon-aria-label="[[label]]">
    </cr-policy-pref-indicator>
  </template>
  <cr-icon-button id="resetSite" class="icon-delete-gray"
      hidden="[[shouldShowPolicyPrefIndicator_(exception)]]"
      on-click="onResetButtonClick_"
      aria-label="$i18n{siteSettingsActionReset}">
  </cr-icon-button>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'site-details-permission-device-entry' shows a single device for a given
 * chooser exception.
 */
class SiteDetailsPermissionDeviceEntryElement extends PolymerElement {
    static get is() {
        return 'site-details-permission-device-entry';
    }
    static get template() {
        return getTemplate$N();
    }
    static get properties() {
        return {
            /**
             * The chooser exception to display in the widget.
             */
            exception: Object,
        };
    }
    /**
     * Get the SiteException that is enforced from |this.exception.sites| if any.
     */
    getPolicyPref_() {
        return this.exception.sites.find(site => {
            return site.enforcement === chrome.settingsPrivate.Enforcement.ENFORCED &&
                !!site.controlledBy;
        }) ||
            null;
    }
    shouldShowPolicyPrefIndicator_() {
        return !!this.getPolicyPref_();
    }
    onResetButtonClick_() {
        assert(this.exception.sites.length > 0);
        SiteSettingsBrowserProxyImpl.getInstance().resetChooserExceptionForSite(this.exception.chooserType, this.exception.sites[0].origin, this.exception.object);
    }
}
customElements.define(SiteDetailsPermissionDeviceEntryElement.is, SiteDetailsPermissionDeviceEntryElement);

function getTemplate$M() {
    return html `<!--_html_template_start_-->    <style include="settings-shared md-select"></style>
    <div id="details" hidden$="[[shouldHideCategory_(site)]]">
      <div id="permissionItem"
          class$="list-item [[permissionInfoStringClass_(site.source,
                                            category,
                                            site.setting,
                                            systemPermissionWarningKey_)]]">
        <div>
          <cr-icon icon="[[icon]]" aria-hidden="true" role="presentation">
          </cr-icon>
        </div>
        <div class="middle" id="permissionHeader">
          [[label]]
          <div class="secondary" id="permissionSecondary"
              hidden$="[[!showSystemPermissionWarning_(site.source,
                  category,site.setting,systemPermissionWarningKey_)]]"
              inner-h-t-m-l="[[getSystemPermissionWarning_(
                  systemPermissionWarningKey_)]]">
          </div>
          <div class="secondary" id="permissionSecondary"
              hidden$="[[!hasPermissionInfoString_(site.source,
                                        category,
                                        site.setting, 
                                        systemPermissionWarningKey_)]]"
              inner-h-t-m-l="[[permissionInfoString_(
                site.source,
                category,
                site.setting,
                '$i18nPolymer{siteSettingsAllowlisted}',
                '$i18nPolymer{siteSettingsAdsBlockBlocklistedSingular}',
                '$i18nPolymer{siteSettingsAdsBlockNotBlocklistedSingular}',
                '$i18nPolymer{siteSettingsSourceEmbargo}',
                '$i18nPolymer{siteSettingsSourceInsecureOrigin}',
                '$i18nPolymer{siteSettingsSourceKillSwitch}',

                '$i18nPolymer{siteSettingsSourceExtensionAllow}',
                '$i18nPolymer{siteSettingsSourceExtensionBlock}',
                '$i18nPolymer{siteSettingsSourceExtensionAsk}',
                '$i18nPolymer{siteSettingsSourcePolicyAllow}',
                '$i18nPolymer{siteSettingsSourcePolicyBlock}',
                '$i18nPolymer{siteSettingsSourcePolicyAsk}')]]">
          </div>
        </div>
        <select id="permission" class="md-select"
            aria-label$="[[label]]"
            aria-describedby="permissionSecondary"
            on-change="onPermissionSelectionChange_"
            disabled$="[[!isPermissionUserControlled_(site.source, category,
                              site.setting, systemPermissionWarningKey_)]]">
          <option id="default" value$="[[contentSettingEnum_.DEFAULT]]">
            [[defaultSettingString_(
                defaultSetting_,
                category,
                useAutomaticLabel,
                useBlockIfUnfamiliarLabelForDefault)]]
          </option>
          <option id="allow" value$="[[contentSettingEnum_.ALLOW]]"
              hidden$="[[!showAllowedSetting_(category)]]">
            $i18n{siteSettingsActionAllow}
          </option>
          <option id="block" value$="[[contentSettingEnum_.BLOCK]]">
            [[blockSettingString_(
                category,
                '$i18n{siteSettingsActionBlock}',
                '$i18n{siteSettingsActionMute}')]]
          </option>
          <option id="ask" value$="[[contentSettingEnum_.ASK]]"
              hidden$="[[!showAskSetting_(category, site.setting,
                                          site.source)]]">
            $i18n{siteSettingsActionAsk}
          </option>
        </select>
      </div>
      <div class="list-frame" role="table">
        <template is="dom-repeat" items="[[chooserExceptions_]]">
          <site-details-permission-device-entry exception="[[item]]">
          </site-details-permission-device-entry>
        </template>
      </div>
    </div>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'site-details-permission' handles showing the state of one permission, such
 * as Geolocation, for a given origin.
 */
const SiteDetailsPermissionElementBase = ListPropertyUpdateMixin(SiteSettingsMixin(WebUiListenerMixin(I18nMixin(PolymerElement))));
class SiteDetailsPermissionElement extends SiteDetailsPermissionElementBase {
    static get is() {
        return 'site-details-permission';
    }
    static get template() {
        return getTemplate$M();
    }
    static get properties() {
        return {
            /**
             * If this is a sound content setting, then this controls whether it
             * should use "Automatic" instead of "Allow" as the default setting
             * allow label.
             */
            useAutomaticLabel: { type: Boolean, value: false },
            /**
             * Controls whether the content setting should use "Block if site is
             * unfamiliar" as the default setting label.
             */
            useBlockIfUnfamiliarLabelForDefault: { type: Boolean, value: false },
            /**
             * The site that this widget is showing details for, or null if this
             * widget should be hidden.
             */
            site: Object,
            /**
             * The default setting for this permission category.
             */
            defaultSetting_: String,
            label: String,
            icon: String,
            /**
             * Expose ContentSetting enum to HTML bindings.
             */
            contentSettingEnum_: {
                type: Object,
                value: ContentSetting,
            },
            /**
             * Array of chooser exceptions to display in the widget.
             */
            chooserExceptions_: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * The chooser type that this element is displaying data for.
             * See site_settings/constants.js for possible values.
             */
            chooserType: {
                type: String,
                value: ChooserType.NONE,
            },
            /**
             * If the permission for this category permission is blocked on the system
             * level, this will be populated with the key that can be used to look up
             * the warning to be shown in the UI.
             */
            systemPermissionWarningKey_: {
                type: String,
                value: null,
                observer: 'attachSystemPermissionSettingsLinkClick_',
            },
        };
    }
    static get observers() {
        return [
            'siteChanged_(site)',
            'updateChooserExceptions_(site, chooserType)',
        ];
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('contentSettingCategoryChanged', (category) => this.onDefaultSettingChanged_(category));
        this.addWebUiListener('contentSettingChooserPermissionChanged', (category, chooserType) => {
            if (category === this.category && chooserType === this.chooserType) {
                this.updateChooserExceptions_();
            }
        });
        this.addWebUiListener('osGlobalPermissionChanged', (messages) => {
            this.setSystemPermissionWarningKey_(messages);
        });
    }
    /**
     * Update the chooser exception list for display.
     */
    updateChooserExceptions_() {
        if (!this.site || this.chooserType === ChooserType.NONE) {
            return;
        }
        // TODO(crbug.com/40887747): Use a backend handler to get chooser
        // exceptions with a given origin so avoid complex logic in
        // processChooserExceptions_.
        this.browserProxy.getChooserExceptionList(this.chooserType)
            .then(exceptionList => this.processChooserExceptions_(exceptionList));
    }
    updateOsPermissionWarning_() {
        this.browserProxy.getSystemDeniedPermissions().then((messages) => {
            this.setSystemPermissionWarningKey_(messages);
        });
    }
    /**
     * Process the chooser exception list returned from the native layer by
     * keeping the exception that is relevant to |this.site| and filtering out
     * sites of exception that doesn't match |this.site|.
     */
    processChooserExceptions_(exceptionList) {
        // TODO(crbug.com/40887747): Move this processing logic to the backend and
        // remove this function.
        const siteFilter = (site) => {
            // Site's origin from backend will have forward slash ending,
            // hence converting it to URL and using URL.origin for
            // comparison to avoid mismatch due to the slash ending.
            const url = this.toUrl(site.origin);
            const targetUrl = this.toUrl(this.site.origin);
            if (!url || !targetUrl) {
                return false;
            }
            return site.incognito === this.site.incognito &&
                url.origin === targetUrl.origin;
        };
        const exceptions = exceptionList
            .filter(exception => {
            // Filters out exceptions that don't have any site matching
            // |this.site|.
            return exception.sites.some(site => siteFilter(site));
        })
            .map(exception => {
            // Filters out any site of |exception.sites| that doesn't match
            // |this.site|.
            const sites = exception.sites.filter(site => siteFilter(site))
                .map(site => this.expandSiteException(site));
            return Object.assign(exception, { sites });
        });
        this.updateList('chooserExceptions_', x => x.displayName, exceptions, 
        /*identityBasedUpdate=*/ true);
    }
    /**
     * Updates the drop-down value after |site| has changed. If |site| is null,
     * this element will hide.
     * @param site The site to display.
     */
    siteChanged_(site) {
        if (!site) {
            return;
        }
        this.updateOsPermissionWarning_();
        if (site.source === SiteSettingSource.DEFAULT) {
            this.defaultSetting_ = site.setting;
            this.$.permission.value = ContentSetting.DEFAULT;
        }
        else {
            // The default setting is unknown, so consult the C++ backend for it.
            this.updateDefaultPermission_();
            this.$.permission.value = site.setting;
        }
        if (this.isNonDefaultAsk_(site.setting, site.source)) {
            assert(this.$.permission.value === ContentSetting.ASK, '\'Ask\' should only show up when it\'s currently selected.');
        }
    }
    /**
     * Updates the default permission setting for this permission category.
     */
    updateDefaultPermission_() {
        this.browserProxy.getDefaultValueForContentType(this.category)
            .then((defaultValue) => {
            this.defaultSetting_ = defaultValue.setting;
        });
    }
    /**
     * Handles the category permission changing for this origin.
     * @param category The permission category that has changed default
     *     permission.
     */
    onDefaultSettingChanged_(category) {
        if (category === this.category) {
            this.updateDefaultPermission_();
        }
    }
    /**
     * Handles the category permission changing for this origin.
     */
    onPermissionSelectionChange_() {
        this.browserProxy.setOriginPermissions(this.site.origin, this.category, this.$.permission.value);
    }
    /**
     * @param category The permission type.
     * @return if we should use the custom labels for the sound type.
     */
    useCustomSoundLabels_(category) {
        return category === ContentSettingsTypes.SOUND;
    }
    /**
     * Updates the string used for this permission category's default setting.
     * @param defaultSetting Value of the default setting for this permission
     *     category.
     * @param category The permission type.
     * @param useAutomaticLabel Whether to use the automatic label if the default
     *     setting value is allow.
     */
    defaultSettingString_(defaultSetting, category, useAutomaticLabel, useBlockIfUnfamiliarLabel) {
        if (defaultSetting === undefined || category === undefined ||
            useAutomaticLabel === undefined) {
            return '';
        }
        if (useBlockIfUnfamiliarLabel) {
            return this.i18n('siteSettingsActionBlockOnUnfamiliarSitesDefaultMenu');
        }
        if (defaultSetting === ContentSetting.ASK) {
            return this.i18n('siteSettingsActionAskDefault');
        }
        else if (defaultSetting === ContentSetting.ALLOW) {
            if (this.useCustomSoundLabels_(category) && useAutomaticLabel) {
                return this.i18n('siteSettingsActionAutomaticDefault');
            }
            return this.i18n('siteSettingsActionAllowDefault');
        }
        else if (defaultSetting === ContentSetting.BLOCK) {
            if (this.useCustomSoundLabels_(category)) {
                return this.i18n('siteSettingsActionMuteDefault');
            }
            return this.i18n('siteSettingsActionBlockDefault');
        }
        assertNotReached(`No string for ${this.category}'s default of ${defaultSetting}`);
    }
    /**
     * Updates the string used for this permission category's block setting.
     * @param category The permission type.
     * @param blockString 'Block' label.
     * @param muteString 'Mute' label.
     */
    blockSettingString_(category, blockString, muteString) {
        if (this.useCustomSoundLabels_(category)) {
            return muteString;
        }
        return blockString;
    }
    /**
     * @return true if |this| should be hidden.
     */
    shouldHideCategory_() {
        return !this.site;
    }
    /**
     * Returns true if there's a string to display that provides more information
     * about this permission's setting. Currently, this only gets called when
     * |this.site| is updated.
     * @param source The source of the permission.
     * @param category The permission type.
     * @param setting The permission setting.
     * @return Whether the permission will have a source string to display.
     */
    hasPermissionInfoString_(source, category, setting) {
        // This method assumes that an empty string will be returned for categories
        // that have no permission info string.
        return String(this.permissionInfoString_(source, category, setting, 
        // Set all permission info string arguments as null. This is OK
        // because there is no need to know what the information string
        // will be, just whether there is one or not.
        null, null, null, null, null, null, 
        // 
        null, null, null, null, null, null)) !== '';
    }
    /**
     * Checks if there's a additional information to display, and returns the
     * class name to apply to permissions if so.
     * @param source The source of the permission.
     * @param category The permission type.
     * @param setting The permission setting.
     * @return CSS class applied when there is an additional description string.
     */
    permissionInfoStringClass_(source, category, setting) {
        return (this.hasPermissionInfoString_(source, category, setting) ||
            this.hasSystemPermissionWarning_()) ?
            'two-line' :
            '';
    }
    /**
     * @param source The source of the permission.
     * @return Whether this permission can be controlled by the user.
     */
    isPermissionUserControlled_(source) {
        return !(source === SiteSettingSource.ALLOWLIST ||
            source === SiteSettingSource.POLICY ||
            source === SiteSettingSource.EXTENSION ||
            source === SiteSettingSource.KILL_SWITCH ||
            source === SiteSettingSource.INSECURE_ORIGIN) &&
            !this.hasSystemPermissionWarning_();
    }
    /**
     * @param category The permission type.
     * @return Whether if the 'allow' option should be shown.
     */
    showAllowedSetting_(category) {
        return !(category === ContentSettingsTypes.SERIAL_PORTS ||
            category === ContentSettingsTypes.USB_DEVICES ||
            category === ContentSettingsTypes.BLUETOOTH_SCANNING ||
            category === ContentSettingsTypes.FILE_SYSTEM_WRITE ||
            category === ContentSettingsTypes.HID_DEVICES ||
            category === ContentSettingsTypes.BLUETOOTH_DEVICES
        // 
        );
    }
    /**
     * @param category The permission type.
     * @param setting The setting of the permission.
     * @param source The source of the permission.
     * @return Whether the 'ask' option should be shown.
     */
    showAskSetting_(category, setting, source) {
        // For chooser-based permissions 'ask' takes the place of 'allow'.
        if (category === ContentSettingsTypes.SERIAL_PORTS ||
            category === ContentSettingsTypes.USB_DEVICES ||
            category === ContentSettingsTypes.HID_DEVICES ||
            category === ContentSettingsTypes.BLUETOOTH_DEVICES) {
            return true;
        }
        // For Bluetooth scanning permission, File System write permission
        // and Smart card readers permission 'ask' takes the place of 'allow'.
        if (category === ContentSettingsTypes.BLUETOOTH_SCANNING ||
            category === ContentSettingsTypes.FILE_SYSTEM_WRITE
        // 
        ) {
            return true;
        }
        return this.isNonDefaultAsk_(setting, source);
    }
    /**
     * @param messages The message with the blocked permission types.
     * @return The key to lookup the warning. Null if the warning is not to be
     * shown.
     */
    setSystemPermissionWarningKey_(messages) {
        this.set('systemPermissionWarningKey_', ((category) => {
            // We return null as warningKey in case the category is not one of
            // the listed, as the warning in case of an OS level block is
            // supported only for camera, microphone and location permissions.
            if (!messages.includes(category)) {
                return null;
            }
            switch (category) {
                case ContentSettingsTypes.CAMERA:
                    return 'siteSettingsCameraBlockedByOs';
                case ContentSettingsTypes.MIC:
                    return 'siteSettingsMicrophoneBlockedByOs';
                case ContentSettingsTypes.GEOLOCATION:
                    return 'siteSettingsLocationBlockedByOs';
                default:
                    return null;
            }
        })(this.category));
    }
    /** Attempts to open the system permission settings. */
    onSystemPermissionSettingsLinkClick_(event) {
        // Prevents navigation to href='#'.
        event.preventDefault();
        if (this.category !== null) {
            this.browserProxy.openSystemPermissionSettings(this.category);
        }
    }
    /**
     * @param category The permission type.
     * @return The text of the warning. Null if the warning is not to be shown.
     */
    getSystemPermissionWarning_() {
        if (this.systemPermissionWarningKey_ !== null) {
            return this.i18nAdvanced(this.systemPermissionWarningKey_, { tags: ['a'], attrs: ['id'] });
        }
        return sanitizeInnerHtml('');
    }
    /** Attaches the click action to the anchor element. */
    attachSystemPermissionSettingsLinkClick_() {
        const element = this.shadowRoot?.querySelector('#openSystemSettingsLink');
        if (element !== null && element !== undefined) {
            element.addEventListener('click', (me) => {
                this.onSystemPermissionSettingsLinkClick_(me);
            });
            // Set the correct aria label describing the link target.
            const settingsPageName = (() => {
                switch (this.category) {
                    case ContentSettingsTypes.CAMERA:
                        return 'Camera';
                    case ContentSettingsTypes.MIC:
                        return 'Microphone';
                    case ContentSettingsTypes.GEOLOCATION:
                        return 'Location';
                    default:
                        return null;
                }
            })();
            if (settingsPageName) {
                element.setAttribute('aria-label', `System Settings: ${settingsPageName}`);
            }
        }
    }
    /**
     * @return The text of the warning. Null if the permission is not blocked by
     *     the OS.
     */
    hasSystemPermissionWarning_() {
        return (this.systemPermissionWarningKey_ !== null);
    }
    /**
     * @param category The permission type.
     * @return The text of the warning. Null if the permission is not to be
     *     displayed.
     */
    showSystemPermissionWarning_(source, category, setting) {
        if (this.hasPermissionInfoString_(source, category, setting)) {
            return false;
        }
        return this.hasSystemPermissionWarning_();
    }
    /**
     * Returns true if the permission is set to a non-default 'ask'. Currently,
     * this only gets called when |this.site| is updated.
     * @param setting The setting of the permission.
     * @param source The source of the permission.
     */
    isNonDefaultAsk_(setting, source) {
        if (setting !== ContentSetting.ASK ||
            source === SiteSettingSource.DEFAULT) {
            return false;
        }
        assert(source === SiteSettingSource.EXTENSION ||
            source === SiteSettingSource.POLICY ||
            source === SiteSettingSource.PREFERENCE, 'Only extensions, enterprise policy or preferences can change ' +
            'the setting to ASK.');
        return true;
    }
    /**
     * Updates the information string for the current permission.
     * Currently, this only gets called when |this.site| is updated.
     * @param source The source of the permission.
     * @param category The permission type.
     * @param setting The permission setting.
     * @param  allowlistString The string to show if the permission is
     *     allowlisted.
     * @param adsBlocklistString The string to show if the site is
     *     blocklisted for showing bad ads.
     * @param adsBlockString The string to show if ads are blocked, but
     *     the site is not blocklisted.
     * @return The permission information string to display in the HTML.
     */
    permissionInfoString_(source, category, setting, allowlistString, adsBlocklistString, adsBlockString, embargoString, insecureOriginString, killSwitchString, 
    // 
    extensionAllowString, extensionBlockString, extensionAskString, policyAllowString, policyBlockString, policyAskString) {
        if (source === undefined || category === undefined ||
            setting === undefined) {
            return window.trustedTypes.emptyHTML;
        }
        const extensionStrings = {};
        extensionStrings[ContentSetting.ALLOW] = extensionAllowString;
        extensionStrings[ContentSetting.BLOCK] = extensionBlockString;
        extensionStrings[ContentSetting.ASK] = extensionAskString;
        const policyStrings = {};
        policyStrings[ContentSetting.ALLOW] = policyAllowString;
        policyStrings[ContentSetting.BLOCK] = policyBlockString;
        policyStrings[ContentSetting.ASK] = policyAskString;
        function htmlOrNull(str) {
            return str === null ? null : sanitizeInnerHtml(str);
        }
        if (source === SiteSettingSource.ALLOWLIST) {
            return htmlOrNull(allowlistString);
        }
        else if (source === SiteSettingSource.ADS_FILTER_BLACKLIST) {
            assert(ContentSettingsTypes.ADS === category, 'The ads filter blocklist only applies to Ads.');
            return htmlOrNull(adsBlocklistString);
        }
        else if (category === ContentSettingsTypes.ADS &&
            setting === ContentSetting.BLOCK) {
            return htmlOrNull(adsBlockString);
        }
        else if (source === SiteSettingSource.EMBARGO) {
            assert(ContentSetting.BLOCK === setting, 'Embargo is only used to block permissions.');
            return htmlOrNull(embargoString);
        }
        else if (source === SiteSettingSource.EXTENSION) {
            return htmlOrNull(extensionStrings[setting]);
        }
        else if (source === SiteSettingSource.INSECURE_ORIGIN) {
            assert(ContentSetting.BLOCK === setting, 'Permissions can only be blocked due to insecure origins.');
            return htmlOrNull(insecureOriginString);
        }
        else if (source === SiteSettingSource.KILL_SWITCH) {
            assert(ContentSetting.BLOCK === setting, 'The permissions kill switch can only be used to block permissions.');
            return htmlOrNull(killSwitchString);
        }
        else if (source === SiteSettingSource.POLICY) {
            return htmlOrNull(policyStrings[setting]);
            // 
        }
        else if (source === SiteSettingSource.DEFAULT ||
            source === SiteSettingSource.PREFERENCE) {
            return window.trustedTypes.emptyHTML;
        }
        assertNotReached(`No string for ${category} setting source '${source}'`);
    }
}
customElements.define(SiteDetailsPermissionElement.is, SiteDetailsPermissionElement);

function getTemplate$L() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared action-link">.favicon-image{margin:2px}#storage{padding-inline-end:0}#storageText{display:flex}#resetSettingsButton{margin-top:24px}#usageHeader{padding:0 var(--cr-section-padding)}#usageDetails{align-items:center;display:flex;flex:1;flex-direction:row}#fpsPolicyContainer{display:flex;padding:8px}
    </style>

  <settings-subpage page-title="[[pageTitle_]]" route-path$="[[routePath]]">
    <!-- Confirm reset settings dialog. -->
    <cr-dialog id="confirmResetSettings" close-text="$i18n{close}"
        on-close="onResetSettingsDialogClosed_">
      <div slot="title">$i18n{siteSettingsSiteResetDialogTitle}</div>
      <div slot="body">
        [[i18n('siteSettingsSiteResetConfirmation', pageTitle_)]]
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCloseDialog_">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" on-click="onResetSettings_">
          $i18n{siteSettingsSiteResetAll}
        </cr-button>
      </div>
    </cr-dialog>

    <!-- Confirm clear storage dialog. -->
    <cr-dialog id="confirmClearStorage" close-text="$i18n{close}"
        on-close="onClearStorageDialogClosed_">
      <style include="clear-storage-dialog-shared"></style>
      <div slot="title">
        $i18n{siteSettingsSiteDeleteStorageDialogTitle}
      </div>
      <div slot="body">
        [[i18n('siteSettingsSiteClearStorageConfirmationNew', pageTitle_)]]
        <div class="detail-list">
          <div class="detail">
            <cr-icon icon="all-sites:logout" aria-hidden="true"
                role="presentation"></cr-icon>
            $i18n{siteSettingsSiteClearStorageSignOut}
          </div>
          <div class="detail">
            <cr-icon icon="all-sites:offline" aria-hidden="true"
                role="presentation"></cr-icon>
            $i18n{siteSettingsSiteDeleteStorageOfflineData}
          </div>
          <div class="detail" id="adPersonalization">
            <cr-icon icon="all-sites:tag" aria-hidden="true"
                role="presentation"></cr-icon>
            $i18n{siteSettingsRemoveSiteAdPersonalization}
          </div>
        </div>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCloseDialog_">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" on-click="onClearStorage_">
          $i18n{siteSettingsSiteClearStorage}
        </cr-button>
      </div>
    </cr-dialog>

    <div id="usage">
      <div id="usageHeader">
        <h2 class="first">$i18n{siteSettingsUsage}</h2>
      </div>
      <div class="list-frame">
        <div class="list-item" id="noStorage"
            hidden$="[[hasUsage_(storedData_, numCookies_)]]">
          <div class="start">$i18n{siteSettingsUsageNone}</div>
        </div>
        <div class="list-item" id="storage"
            hidden$="[[!hasUsage_(storedData_, numCookies_)]]">
          <div id="usageDetails">
            <div>
              <div id="storageText">
                <div id="storedData" hidden$="[[!storedData_]]">
                  [[storedData_]]
                </div>
                <div hidden$="[[!hasDataAndCookies_(
                    storedData_,numCookies_)]]">
                  &nbsp;&middot;&nbsp;
                </div>
                <div id="numCookies" hidden$="[[!numCookies_]]">
                  [[numCookies_]]
                </div>
              </div>
              <div id="rwsMembership" class="secondary"
                  hidden$="[[!rwsMembership_]]">
                [[rwsMembership_]]
              </div>
            </div>
            <template is="dom-if" if="[[rwsEnterprisePref_]]">
              <div id="fpsPolicyContainer">
                <cr-policy-pref-indicator
                    id="rwsPolicy" pref="[[rwsEnterprisePref_]]"
                    icon-aria-label="[[label]]" focus-row-control
                    focus-type="policy">
                </cr-policy-pref-indicator>
              </div>
            </template>
          </div>
          <cr-button id="clearStorage" role="button" aria-disabled="false"
              on-click="onConfirmClearStorage_"
              aria-label="$i18n{siteSettingsDelete}">
            $i18n{siteSettingsDelete}
          </cr-button>
        </div>
      </div>
    </div>

    <div class="cr-row first">
      <h2 class="flex">$i18n{siteSettingsPermissions}</h2>
      <cr-button id="resetSettingsButton" class="header-aligned-button"
          role="button" aria-disabled="false"
          on-click="onConfirmClearSettings_">
        $i18n{siteSettingsReset}
      </cr-button>
    </div>

    <div class="list-frame">
      <site-details-permission category="[[contentSettingsTypesEnum_.GEOLOCATION]]"
          icon="settings:location-on" label="$i18n{siteSettingsLocation}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.CAMERA]]"
          icon="cr:videocam" label="$i18n{siteSettingsCamera}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.MIC]]"
          icon="privacy:mic" label="$i18n{siteSettingsMic}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.SENSORS]]"
          icon="privacy:sensors" label="$i18n{siteSettingsSensors}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.NOTIFICATIONS]]"
          icon="privacy:notifications"
          label="$i18n{siteSettingsNotifications}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.JAVASCRIPT]]"
          icon="privacy:code" label="$i18n{siteSettingsJavascript}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.IMAGES]]"
          icon="privacy:imagesmode" label="$i18n{siteSettingsImages}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.POPUPS]]"
          icon="cr:open-in-new" label="$i18n{siteSettingsPopups}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.ADS]]"
          icon="privacy:web-asset" label="$i18n{siteSettingsAds}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.BACKGROUND_SYNC]]"
          icon="cr:sync" label="$i18n{siteSettingsBackgroundSync}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.SOUND]]"
          icon="privacy:volume-up" label="$i18n{siteSettingsSound}"
          use-automatic-label="[[blockAutoplayEnabled_]]">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.AUTOMATIC_DOWNLOADS]]"
          icon="cr:file-download" label="$i18n{siteSettingsAutomaticDownloads}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.MIDI_DEVICES]]"
          icon="privacy:piano" label="$i18n{siteSettingsMidiDevices}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.USB_DEVICES]]"
          icon="privacy:usb" label="$i18n{siteSettingsUsbDevices}"
          chooser-type="[[chooserTypeEnum_.USB_DEVICES]]">
      </site-details-permission>

      <site-details-permission category="[[contentSettingsTypesEnum_.SERIAL_PORTS]]"
          icon="privacy:developer-board" label="$i18n{siteSettingsSerialPorts}"
          chooser-type="[[chooserTypeEnum_.SERIAL_PORTS]]">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.WEB_PRINTING]]"
          icon="settings:printer"
          label="$i18n{siteSettingsWebPrinting}">
      </site-details-permission>
      <template is="dom-if" if="[[enableWebBluetoothNewPermissionsBackend_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.BLUETOOTH_DEVICES]]"
            icon="settings:bluetooth"
            chooser-type="[[chooserTypeEnum_.BLUETOOTH_DEVICES]]"
            label="$i18n{siteSettingsBluetoothDevices}">
        </site-details-permission>
      </template>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.FILE_SYSTEM_WRITE]]"
          icon="privacy:file-save"
          label="$i18n{siteSettingsFileSystemWrite}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.HID_DEVICES]]"
          chooser-type="[[chooserTypeEnum_.HID_DEVICES]]"
          icon="privacy:videogame-asset" label="$i18n{siteSettingsHidDevices}">
      </site-details-permission>

      <site-details-permission category="[[contentSettingsTypesEnum_.CLIPBOARD]]"
          icon="privacy:content-paste" label="$i18n{siteSettingsClipboard}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.PAYMENT_HANDLER]]"
          icon="privacy:credit-card"
          label="$i18n{siteSettingsPaymentHandler}">
      </site-details-permission>
      <template is="dom-if" if="[[enableExperimentalWebPlatformFeatures_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.BLUETOOTH_SCANNING]]"
            icon="settings:bluetooth-scanning"
            label="$i18n{siteSettingsBluetoothScanning}">
        </site-details-permission>
      </template>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.MIXEDSCRIPT]]"
          icon="privacy:warning"
          label="$i18n{siteSettingsInsecureContent}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.JAVASCRIPT_OPTIMIZER]]"
          use-block-if-unfamiliar-label-for-default="[[
              useBlockIfUnfamiliarLabelForV8OptimizerDefault_]]"
          icon="privacy:v8"
          label="$i18n{siteSettingsJavascriptOptimizer}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.FEDERATED_IDENTITY_API]]"
          icon="privacy:account-circle"
          label="$i18n{siteSettingsFederatedIdentityApi}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.AR]]"
          icon="privacy:cardboard" label="$i18n{siteSettingsAr}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.VR]]"
          icon="privacy:cardboard" label="$i18n{siteSettingsVr}">
      </site-details-permission>
      <template is="dom-if" if="[[enableHandTrackingContentSetting_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.HAND_TRACKING]]"
            icon="privacy:hand-gesture" label="$i18n{siteSettingsHandTracking}">
        </site-details-permission>
      </template>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.IDLE_DETECTION]]"
          icon="settings:devices"
          label="$i18n{siteSettingsIdleDetection}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.WINDOW_MANAGEMENT]]"
          icon="privacy:select-window"
          label="$i18n{siteSettingsWindowManagement}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.LOCAL_FONTS]]"
          icon="privacy:font-download" label="$i18n{fonts}">
      </site-details-permission>
      <template is="dom-if" if="[[enableAutoPictureInPicture_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.AUTO_PICTURE_IN_PICTURE]]"
            icon="settings:picture-in-picture"
            label="$i18n{siteSettingsAutoPictureInPicture}">
        </site-details-permission>
      </template>
      <template is="dom-if" if="[[enableCapturedSurfaceControl_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.CAPTURED_SURFACE_CONTROL]]"
            icon="settings:touchpad-mouse"
            label="$i18n{siteSettingsCapturedSurfaceControl}">
        </site-details-permission>
      </template>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.AUTOMATIC_FULLSCREEN]]"
          icon="cr:fullscreen" label="$i18n{siteSettingsAutomaticFullscreen}">
      </site-details-permission>
      <template is="dom-if" if="[[enableKeyboardLockPrompt_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.KEYBOARD_LOCK]]"
            icon="settings20:keyboard-lock"
            label="$i18n{siteSettingsKeyboardLock}">
        </site-details-permission>
      </template>
      <template is="dom-if" if="[[enableWebAppInstallation_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.WEB_APP_INSTALLATION]]"
            icon="settings:install-desktop"
            label="$i18n{siteSettingsWebAppInstallation}">
        </site-details-permission>
      </template>
      <template is="dom-if" if="[[enableLocalNetworkAccessSetting_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.LOCAL_NETWORK_ACCESS]]"
            icon="settings20:router"
            label="$i18n{siteSettingsLocalNetworkAccess}">
        </site-details-permission>
      </template>
    </div>
  </settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class WebsiteUsageBrowserProxyImpl {
    fetchUsageTotal(host) {
        chrome.send('fetchUsageTotal', [host]);
    }
    clearUsage(origin) {
        chrome.send('clearUnpartitionedUsage', [origin]);
    }
    static getInstance() {
        return instance$j || (instance$j = new WebsiteUsageBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance$j = obj;
    }
}
let instance$j = null;

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'site-details' show the details (permissions and usage) for a given origin
 * under Site Settings.
 */
loadTimeData.applyOwlOverrides();
const SiteDetailsElementBase = RouteObserverMixin(SiteSettingsMixin(SettingsViewMixin(WebUiListenerMixin(PrefsMixin(I18nMixin(PolymerElement))))));
class SiteDetailsElement extends SiteDetailsElementBase {
    static get is() {
        return 'site-details';
    }
    static get template() {
        return getTemplate$L();
    }
    static get properties() {
        return {
            /**
             * Whether unified autoplay blocking is enabled.
             */
            blockAutoplayEnabled_: Boolean,
            /**
             * Use the string representing the origin or extension name as the page
             * title of the settings-subpage parent.
             */
            pageTitle_: {
                type: String,
                notify: true,
            },
            /**
             * The origin that this widget is showing details for.
             */
            origin_: String,
            /**
             * The amount of data stored for the origin.
             */
            storedData_: {
                type: String,
                value: '',
            },
            /**
             * The number of cookies stored for the origin.
             */
            numCookies_: {
                type: String,
                value: '',
            },
            /**
             * The related website set info for a site including owner and members
             * count.
             */
            rwsMembership_: {
                type: String,
                value: '',
            },
            /**
             * Mock preference used to power managed policy icon for related website
             * sets.
             */
            rwsEnterprisePref_: Object,
            enableExperimentalWebPlatformFeatures_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('enableExperimentalWebPlatformFeatures');
                },
            },
            enableWebBluetoothNewPermissionsBackend_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('enableWebBluetoothNewPermissionsBackend'),
            },
            // 
            enableAutoPictureInPicture_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('enableAutoPictureInPicture'),
            },
            enableHandTrackingContentSetting_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('enableHandTrackingContentSetting'),
            },
            enableCapturedSurfaceControl_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('enableCapturedSurfaceControl'),
            },
            enablePermissionSiteSettingsRadioButton_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('enablePermissionSiteSettingsRadioButton'),
            },
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
            chooserTypeEnum_: {
                type: Object,
                value: ChooserType,
            },
            enableKeyboardLockPrompt_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('enableKeyboardLockPrompt'),
            },
            enableWebAppInstallation_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('enableWebAppInstallation'),
            },
            enableLocalNetworkAccessSetting_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('enableLocalNetworkAccessSetting'),
            },
            /**
             * Whether the "Block if site is unfamiliar" label should be used for the
             * default javascript-optimizer content setting.
             */
            useBlockIfUnfamiliarLabelForV8OptimizerDefault_: {
                type: Boolean,
                computed: 'computeShouldUseBlockIfUnfamiliarLabelForV8OptimizerDefault_(' +
                    'prefs.generated.javascript_optimizer.value)',
            },
        };
    }
    websiteUsageProxy_ = WebsiteUsageBrowserProxyImpl.getInstance();
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('usage-total-changed', (host, data, cookies, rws, rwsPolicy) => {
            this.onUsageTotalChanged_(host, data, cookies, rws, rwsPolicy);
        });
        this.addWebUiListener('contentSettingSitePermissionChanged', (category, origin) => this.onPermissionChanged_(category, origin));
        this.addWebUiListener('onBlockAutoplayStatusChanged', (status) => this.onBlockAutoplayStatusChanged_(status));
        // Refresh block autoplay status from the backend.
        this.browserProxy.fetchBlockAutoplayStatus();
    }
    /**
     * RouteObserverMixin
     */
    currentRouteChanged(route, oldRoute) {
        super.currentRouteChanged(route, oldRoute);
        if (route !== routes.SITE_SETTINGS_SITE_DETAILS) {
            return;
        }
        const site = Router.getInstance().getQueryParameters().get('site') ?? '';
        this.origin_ = site;
        this.browserProxy.isOriginValid(this.origin_).then((valid) => {
            if (!valid) {
                Router.getInstance().navigateToPreviousRoute();
            }
            else {
                this.storedData_ = '';
                this.websiteUsageProxy_.fetchUsageTotal(this.origin_);
                this.browserProxy.getCategoryList(this.origin_).then((categoryList) => {
                    this.updatePermissions_(categoryList, /*hideOthers=*/ true);
                });
            }
        });
    }
    /**
     * Called when a site within a category has been changed.
     * @param category The category that changed.
     * @param origin The origin of the site that changed.
     */
    onPermissionChanged_(category, origin) {
        if (this.origin_ === undefined || this.origin_ === '' ||
            origin === undefined || origin === '') {
            return;
        }
        this.browserProxy.getCategoryList(this.origin_).then((categoryList) => {
            if (categoryList.includes(category)) {
                this.updatePermissions_([category], /*hideOthers=*/ false);
            }
        });
    }
    /**
     * Callback for when the usage total is known.
     * @param origin The origin that the usage was fetched for.
     * @param usage The string showing how much data the given host is using.
     * @param cookies The string showing how many cookies the given host is using.
     * @param rwsMembership The string showing related website set membership
     *     details.
     * @param rwsPolicy Whether a policy is applied to this RWS member.
     */
    onUsageTotalChanged_(origin, usage, cookies, rwsMembership, rwsPolicy) {
        if (this.origin_ === origin) {
            this.storedData_ = usage;
            this.numCookies_ = cookies;
            this.rwsMembership_ = rwsMembership;
            this.rwsEnterprisePref_ = rwsPolicy ? Object.assign({
                enforcement: chrome.settingsPrivate.Enforcement.ENFORCED,
                controlledBy: chrome.settingsPrivate.ControlledBy.DEVICE_POLICY,
            }) :
                undefined;
        }
    }
    /**
     * Retrieves the permissions listed in |categoryList| from the backend for
     * |this.origin_|.
     * @param categoryList The list of categories to update permissions for.
     * @param hideOthers If true, permissions for categories not in
     *     |categoryList| will be hidden.
     */
    updatePermissions_(categoryList, hideOthers) {
        const permissionsMap = Array.prototype.reduce.call(this.shadowRoot.querySelectorAll('site-details-permission'), (map, element) => {
            if (categoryList.includes(element.category)) {
                map[element.category] = element;
            }
            else if (hideOthers) {
                // This will hide any permission not in the category list.
                element.site = null;
            }
            return map;
        }, {});
        this.browserProxy.getOriginPermissions(this.origin_, categoryList)
            .then((exceptionList) => {
            exceptionList.forEach((exception, i) => {
                // |exceptionList| should be in the same order as
                // |categoryList|.
                if (permissionsMap[categoryList[i]]) {
                    permissionsMap[categoryList[i]].site = exception;
                }
            });
            // The displayName won't change, so just use the first
            // exception.
            assert(exceptionList.length > 0);
            this.pageTitle_ = exceptionList[0].displayName;
        });
    }
    onCloseDialog_(e) {
        e.target.closest('cr-dialog').close();
    }
    /**
     * Confirms the resetting of all content settings for an origin.
     */
    onConfirmClearSettings_(e) {
        e.preventDefault();
        this.$.confirmResetSettings.showModal();
    }
    /**
     * Confirms the clearing of storage for an origin.
     */
    onConfirmClearStorage_(e) {
        e.preventDefault();
        this.$.confirmClearStorage.showModal();
    }
    /**
     * Resets all permissions for the current origin.
     */
    onResetSettings_(e) {
        this.browserProxy.setOriginPermissions(this.origin_, null, ContentSetting.DEFAULT);
        this.onCloseDialog_(e);
    }
    /**
     * Clears all data stored, except cookies, for the current origin.
     */
    onClearStorage_(e) {
        MetricsBrowserProxyImpl.getInstance().recordSettingsPageHistogram(PrivacyElementInteractions.SITE_DETAILS_CLEAR_DATA);
        if (this.hasUsage_(this.storedData_, this.numCookies_)) {
            this.websiteUsageProxy_.clearUsage(this.toUrl(this.origin_).href);
            this.storedData_ = '';
            this.numCookies_ = '';
        }
        this.onCloseDialog_(e);
        const toFocus = this.shadowRoot.querySelector('#resetSettingsButton');
        assert(toFocus);
        focusWithoutInk(toFocus);
    }
    /**
     * Checks whether this site has any usage information to show.
     * @return Whether there is any usage information to show (e.g. disk or
     *     battery).
     */
    hasUsage_(storage, cookies) {
        return storage !== '' || cookies !== '';
    }
    /**
     * Checks whether this site has both storage and cookies information to show.
     * @return Whether there are both storage and cookies information to show.
     */
    hasDataAndCookies_(storage, cookies) {
        return storage !== '' && cookies !== '';
    }
    /**
     * Returns whether the "Block if site is unfamiliar" label should be used for
     * the default javascript-optimizer content setting.
     */
    computeShouldUseBlockIfUnfamiliarLabelForV8OptimizerDefault_() {
        const pref = this.getPref('generated.javascript_optimizer').value;
        return pref === JavascriptOptimizerSetting.BLOCKED_FOR_UNFAMILIAR_SITES;
    }
    onResetSettingsDialogClosed_() {
        const toFocus = this.shadowRoot.querySelector('#resetSettingsButton');
        assert(toFocus);
        focusWithoutInk(toFocus);
    }
    onClearStorageDialogClosed_() {
        const toFocus = this.shadowRoot.querySelector('#clearStorage');
        assert(toFocus);
        focusWithoutInk(toFocus);
    }
    // Called when the block autoplay status changes.
    onBlockAutoplayStatusChanged_(autoplayStatus) {
        this.blockAutoplayEnabled_ = autoplayStatus.pref.value;
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SiteDetailsElement.is, SiteDetailsElement);

function getTemplate$K() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">site-favicon{padding-inline-end:24px}.link-button[disabled]{cursor:auto;pointer-events:none}.incognito-icon{cursor:auto;pointer-events:auto}.display-name{flex:1;max-width:100%}
    </style>
    <div id="noPermissionsText" class="list-frame"
        hidden$="[[!noRecentPermissions]]">
      <div class="list-item secondary">$i18n{noRecentPermissions}</div>
    </div>
    <template is="dom-repeat" id="recentPermissionsList"
        items="[[recentSitePermissionsList_]]" on-dom-change="onDomChange_">
      <div class$="cr-row link-button [[getClassForIndex_(index)]]"
          on-click="onRecentSitePermissionClick_" actionable
          disabled$="[[item.incognito]]">
        <site-favicon url="[[item.origin]]"></site-favicon>
        <div id="displayName_[[index]]" class="display-name cr-padded-text">
          <div class="site-representation">
            <span class="url-directionality">[[getDisplayName_(item)]]</span>
            <span class="secondary"
                hidden$="[[!getSiteScheme_(item)]]">
            &nbsp;$i18nPolymer{siteSettingsSiteRepresentationSeparator}&nbsp;
            </span>
            <span class="secondary"
                hidden$="[[!getSiteScheme_(item)]]">
              [[getSiteScheme_(item)]]
            </span>
          </div>
          <div class="second-line secondary">
              [[getPermissionsText_(item)]]
          </div>
        </div>
        <cr-icon-button id="siteEntryButton_[[index]]" class="subpage-arrow"
            hidden$="[[item.incognito]]"
            aria-label$="[[getDisplayName_(item)]]"
            aria-describedby$="displayName_[[index]]"
            focus-row-control focus-type="show-detail"></cr-icon-button>
        <cr-tooltip-icon id="incognitoInfoIcon_[[index]]"
            class="incognito-icon"
            hidden$="[[!item.incognito]]"
            disabled$="[[item.incognito]]"
            icon-aria-label="$i18n{incognitoSiteExceptionDesc}"
            icon-class="settings20:incognito"
            on-click="onShowIncognitoTooltip_"
            on-mouseenter="onShowIncognitoTooltip_"
            on-focus="onShowIncognitoTooltip_"></cr-tooltip-icon>
      </div>
    </template>
    <cr-tooltip id="tooltip"
        fit-to-visible-bounds manual-mode
        position="top">
      $i18n{incognitoSiteExceptionDesc}
    </cr-tooltip>
<!--_html_template_end_-->`;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SettingsRecentSitePermissionsElementBase = TooltipMixin(RouteObserverMixin(SiteSettingsMixin(WebUiListenerMixin(I18nMixin(PolymerElement)))));
class SettingsRecentSitePermissionsElement extends SettingsRecentSitePermissionsElementBase {
    static get is() {
        return 'settings-recent-site-permissions';
    }
    static get template() {
        return getTemplate$K();
    }
    static get properties() {
        return {
            noRecentPermissions: {
                type: Boolean,
                computed: 'computeNoRecentPermissions_(recentSitePermissionsList_)',
                notify: true,
            },
            shouldFocusAfterPopulation_: Boolean,
            /**
             * List of recent site permissions grouped by source.
             */
            recentSitePermissionsList_: {
                type: Array,
                value: () => [],
            },
        };
    }
    lastSelected_;
    constructor() {
        super();
        /**
         * When navigating to a site details sub-page, |lastSelected_| holds the
         * origin and incognito bit associated with the link that sent the user
         * there, as well as the index in recent permission list for that entry.
         * This allows for an intelligent re-focus upon a back navigation.
         */
        this.lastSelected_ = null;
    }
    getFocusConfig() {
        return new Map([
            [
                routes.SITE_SETTINGS_SITE_DETAILS.path + '_' +
                    routes.SITE_SETTINGS.path,
                () => {
                    this.shouldFocusAfterPopulation_ = true;
                },
            ],
        ]);
    }
    /**
     * Reload the site recent site permission list whenever the user navigates
     * to the site settings page.
     */
    currentRouteChanged(currentRoute) {
        if (currentRoute.path === routes.SITE_SETTINGS.path) {
            this.populateList_();
        }
    }
    ready() {
        super.ready();
        this.addWebUiListener('onIncognitoStatusChanged', (hasIncognito) => this.onIncognitoStatusChanged_(hasIncognito));
        this.browserProxy.updateIncognitoStatus();
    }
    /**
     * @return a user-friendly name for the origin a set of recent permissions
     *     is associated with.
     */
    getDisplayName_(recentSitePermissions) {
        return recentSitePermissions.displayName;
    }
    /**
     * @return the site scheme for the origin of a set of recent permissions.
     */
    getSiteScheme_({ origin }) {
        const scheme = this.toUrl(origin).protocol.slice(0, -1);
        return scheme === 'https' ? '' : scheme;
    }
    /**
     * @return the display text which describes the set of recent permissions.
     */
    getPermissionsText_({ recentPermissions }) {
        // Recently changed permisisons for a site are grouped into three buckets,
        // each described by a single sentence.
        const groupSentences = [
            this.getPermissionGroupText_('Allowed', recentPermissions.filter(exception => exception.setting === ContentSetting.ALLOW)),
            this.getPermissionGroupText_('AutoBlocked', recentPermissions.filter(exception => exception.source === SiteSettingSource.EMBARGO)),
            this.getPermissionGroupText_('Blocked', recentPermissions.filter(exception => exception.setting === ContentSetting.BLOCK &&
                exception.source !== SiteSettingSource.EMBARGO)),
        ].filter(string => string.length > 0);
        let finalText = '';
        // The final text may be composed of multiple sentences, so may need the
        // appropriate sentence separators.
        for (const sentence of groupSentences) {
            if (finalText.length > 0) {
                // Whitespace is a valid sentence separator w.r.t i18n.
                finalText += `${this.i18n('sentenceEnd')} ${sentence}`;
            }
            else {
                finalText = sentence;
            }
        }
        if (groupSentences.length > 1) {
            finalText += this.i18n('sentenceEnd');
        }
        return finalText;
    }
    /**
     * @return the display sentence which groups the provided |exceptions|
     *    together and applies the appropriate description based on |setting|.
     */
    getPermissionGroupText_(setting, exceptions) {
        if (exceptions.length === 0) {
            return '';
        }
        const typeStrings = exceptions.map(exception => {
            const localizationString = getLocalizationStringForContentType(exception.type);
            return localizationString ? this.i18n(localizationString) : '';
        });
        if (exceptions.length === 1) {
            return this.i18n(`recentPermission${setting}OneItem`, ...typeStrings);
        }
        if (exceptions.length === 2) {
            return this.i18n(`recentPermission${setting}TwoItems`, ...typeStrings);
        }
        return this.i18n(`recentPermission${setting}MoreThanTwoItems`, typeStrings[0], exceptions.length - 1);
    }
    /**
     * @return the correct CSS class to apply depending on this recent site
     *     permissions entry based on the index.
     */
    getClassForIndex_(index) {
        return index === 0 ? 'first' : '';
    }
    /**
     * @return true if there are no recent site permissions to display
     */
    computeNoRecentPermissions_() {
        return this.recentSitePermissionsList_.length === 0;
    }
    /**
     * Called for when incognito is enabled or disabled. Only called on change
     * (opening N incognito windows only fires one message). Another message is
     * sent when the *last* incognito window closes.
     */
    onIncognitoStatusChanged_(hasIncognito) {
        // We're only interested in the case where we transition out of incognito
        // and we are currently displaying an incognito entry.
        if (hasIncognito === false &&
            this.recentSitePermissionsList_.some(p => p.incognito)) {
            this.populateList_();
        }
    }
    /**
     * A handler for selecting a recent site permissions entry.
     */
    onRecentSitePermissionClick_(e) {
        const origin = this.recentSitePermissionsList_[e.model.index].origin;
        Router.getInstance().navigateTo(routes.SITE_SETTINGS_SITE_DETAILS, new URLSearchParams({ site: origin }));
        this.browserProxy.recordAction(AllSitesAction2.ENTER_SITE_DETAILS);
        this.lastSelected_ = {
            index: e.model.index,
            origin: e.model.item.origin,
            incognito: e.model.item.incognito,
        };
    }
    onShowIncognitoTooltip_(e) {
        e.stopPropagation();
        this.showTooltipAtTarget(this.$.tooltip, e.target);
    }
    /**
     * Called after the list has finished populating and |lastSelected_| contains
     * a valid entry that should attempt to be focused. If lastSelected_ cannot
     * be found the index where it used to be is focused. This may result in
     * focusing another link arrow, or an incognito information icon. If the
     * recent permission list is empty, focus is lost.
     */
    focusLastSelected_() {
        if (this.noRecentPermissions) {
            return;
        }
        const currentIndex = this.recentSitePermissionsList_.findIndex((permissions) => {
            return permissions.origin === this.lastSelected_.origin &&
                permissions.incognito === this.lastSelected_.incognito;
        });
        const fallbackIndex = Math.min(this.lastSelected_.index, this.recentSitePermissionsList_.length - 1);
        const index = currentIndex > -1 ? currentIndex : fallbackIndex;
        if (this.recentSitePermissionsList_[index].incognito) {
            const icon = this.shadowRoot.querySelector(`#incognitoInfoIcon_${index}`);
            assert(!!icon);
            const toFocus = icon.getFocusableElement();
            assert(!!toFocus);
            focusWithoutInk(toFocus);
        }
        else {
            const toFocus = this.shadowRoot.querySelector(`#siteEntryButton_${index}`);
            assert(!!toFocus);
            focusWithoutInk(toFocus);
        }
    }
    /**
     * Retrieve the list of recently changed permissions and implicitly trigger
     * the update of the display list.
     */
    async populateList_() {
        this.recentSitePermissionsList_ =
            await this.browserProxy.getRecentSitePermissions(3);
    }
    /**
     * Called when the dom-repeat DOM has changed. This allows updating the
     * focused element after the elements have been adjusted.
     */
    onDomChange_() {
        if (this.shouldFocusAfterPopulation_) {
            this.focusLastSelected_();
            this.shouldFocusAfterPopulation_ = false;
        }
    }
}
customElements.define(SettingsRecentSitePermissionsElement.is, SettingsRecentSitePermissionsElement);

function getTemplate$J() {
    return html `<!--_html_template_start_-->    <style include="settings-shared">cr-link-row{--cr-icon-button-margin-start:20px}cr-link-row:first-of-type{border-top:none}
    </style>
    <template is="dom-repeat" items="[[categoryList]]">
      <cr-link-row class="hr two-line" data-route$="[[item.route]]"
          id="[[item.id]]" label="[[i18n(item.label)]]"
          on-click="onClick_" start-icon="[[item.icon]]"
          sub-label="[[item.subLabel]]"
          role-description="$i18n{subpageArrowRoleDescription}"></cr-link-row>
    </template>
<!--_html_template_end_-->`;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function defaultSettingLabel(setting, enabled, disabled, other) {
    if (setting === ContentSetting.BLOCK) {
        return disabled;
    }
    if (setting === ContentSetting.ALLOW) {
        return enabled;
    }
    return other || enabled;
}
const SettingsSiteSettingsListElementBase = PrefsMixin(BaseMixin(WebUiListenerMixin(I18nMixin(PolymerElement))));
class SettingsSiteSettingsListElement extends SettingsSiteSettingsListElementBase {
    static get is() {
        return 'settings-site-settings-list';
    }
    static get template() {
        return getTemplate$J();
    }
    static get properties() {
        return {
            categoryList: Array,
            categoryMap_: {
                type: Map,
                computed: 'computeCategoryMap(categoryList)',
            },
        };
    }
    static get observers() {
        return [
            'updateNotificationsLabel_(prefs.generated.notification.*)',
            'updateLocationLabel_(prefs.generated.geolocation.*)',
            'updateSiteDataLabel_(prefs.generated.cookie_default_content_setting.*)',
            'updateThirdPartyCookiesLabel_(prefs.profile.cookie_controls_mode.*,' +
                'prefs.tracking_protection.block_all_3pc_toggle_enabled.*,' +
                'prefs.generated.third_party_cookie_blocking_setting.*)',
            'updateOfferWritingHelpLabel_(prefs.compose.proactive_nudge_enabled.*)',
        ];
    }
    browserProxy_ = SiteSettingsBrowserProxyImpl.getInstance();
    getFocusConfig() {
        const focusConfig = new Map();
        // Populate the |focusConfig| map with entries that correspond to subpage
        // trigger elements residing in this element's Shadow DOM.
        for (const item of this.categoryList) {
            focusConfig.set(item.route.path, () => {
                const toFocus = this.shadowRoot.querySelector(`#${item.id}`);
                assert(!!toFocus);
                focusWithoutInk(toFocus);
            });
        }
        return focusConfig;
    }
    computeCategoryMap(categoryList) {
        return new Map(categoryList.map((e, index) => [e.id, index]));
    }
    ready() {
        super.ready();
        Promise
            .all(this.categoryList.map(item => this.refreshDefaultValueLabel_(item.id)))
            .then(() => {
            this.fire('site-settings-list-labels-updated-for-testing');
        });
        this.addWebUiListener('contentSettingCategoryChanged', (category) => this.refreshDefaultValueLabel_(category));
        const hasProtocolHandlers = this.categoryMap_.has(ContentSettingsTypes.PROTOCOL_HANDLERS);
        if (hasProtocolHandlers) {
            // The protocol handlers have a separate enabled/disabled notifier.
            this.addWebUiListener('setHandlersEnabled', (enabled) => {
                this.updateDefaultValueLabel_(ContentSettingsTypes.PROTOCOL_HANDLERS, enabled ? ContentSetting.ALLOW : ContentSetting.BLOCK);
            });
            this.browserProxy_.observeProtocolHandlersEnabledState();
        }
    }
    /**
     * @param category The category to refresh (fetch current value + update UI)
     * @return A promise firing after the label has been updated.
     */
    refreshDefaultValueLabel_(category) {
        // Default labels are not applicable to ZOOM_LEVELS, PDF, PROTECTED_CONTENT,
        // SITE_DATA, or OFFER_WRITING_HELP.
        if (category === ContentSettingsTypes.ZOOM_LEVELS ||
            category === ContentSettingsTypes.PROTECTED_CONTENT ||
            category === ContentSettingsTypes.PDF_DOCUMENTS ||
            category === ContentSettingsTypes.SITE_DATA ||
            category === ContentSettingsTypes.OFFER_WRITING_HELP ||
            // Updates to the cookies label are handled by the
            // cookieSettingDescriptionChanged event listener.
            category === ContentSettingsTypes.COOKIES) {
            return Promise.resolve();
        }
        if (category === ContentSettingsTypes.NOTIFICATIONS) {
            // Updates to the notifications label are handled by a preference
            // observer.
            return Promise.resolve();
        }
        if (category === ContentSettingsTypes.PERFORMANCE) {
            const index = this.categoryMap_.get(ContentSettingsTypes.PERFORMANCE);
            this.set(`categoryList.${index}.subLabel`, this.i18n('siteSettingsPerformanceSublabel'));
            return Promise.resolve();
        }
        if (!this.categoryMap_.has(category)) {
            return Promise.resolve();
        }
        return this.browserProxy_.getDefaultValueForContentType(category).then(defaultValue => {
            this.updateDefaultValueLabel_(category, defaultValue.setting);
        });
    }
    /**
     * Updates the DOM for the given |category| to display a label that
     * corresponds to the given |setting|.
     */
    updateDefaultValueLabel_(category, setting) {
        const element = this.$$(`#${category}`);
        if (!element) {
            // |category| is not part of this list.
            return;
        }
        const index = this.shadowRoot.querySelector('dom-repeat').indexForElement(element);
        const dataItem = this.categoryList[index];
        this.set(`categoryList.${index}.subLabel`, defaultSettingLabel(setting, dataItem.enabledLabel ? this.i18n(dataItem.enabledLabel) : '', dataItem.disabledLabel ? this.i18n(dataItem.disabledLabel) : '', dataItem.otherLabel ? this.i18n(dataItem.otherLabel) : undefined));
    }
    /**
     * Update the cookies link row label when the cookies setting description
     * changes.
     */
    updateCookiesLabel_(label) {
        const index = this.shadowRoot.querySelector('dom-repeat').indexForElement(this.shadowRoot.querySelector('#cookies'));
        this.set(`categoryList.${index}.subLabel`, label);
    }
    /**
     * Update the geolocation link row label when the geolocation setting
     * description changes.
     */
    updateLocationLabel_() {
        const state = this.getPref('generated.geolocation').value;
        const index = this.categoryMap_.get(ContentSettingsTypes.GEOLOCATION);
        // The location row might not be part of the current site-settings-list
        // but the class always observes the preference.
        if (index === -1) {
            return;
        }
        let label = 'siteSettingsLocationBlocked';
        if (state === SettingsState.LOUD) {
            label = 'siteSettingsLocationAskLoud';
        }
        else if (state === SettingsState.QUIET) {
            label = 'siteSettingsLocationAskQuiet';
        }
        else if (state === SettingsState.CPSS) {
            label = 'siteSettingsLocationAskCPSS';
        }
        this.set(`categoryList.${index}.subLabel`, this.i18n(label));
    }
    /**
     * Update the notifications link row label when the notifications setting
     * description changes.
     */
    updateNotificationsLabel_() {
        const state = this.getPref('generated.notification').value;
        const index = this.categoryMap_.get(ContentSettingsTypes.NOTIFICATIONS);
        // The notification row might not be part of the current site-settings-list
        // but the class always observes the preference.
        if (index === -1) {
            return;
        }
        let label = 'siteSettingsNotificationsBlocked';
        if (state === SettingsState.LOUD) {
            label = 'siteSettingsNotificationsAskLoud';
        }
        else if (state === SettingsState.QUIET) {
            label = 'siteSettingsNotificationsAskQuiet';
        }
        else if (state === SettingsState.CPSS) {
            label = 'siteSettingsNotificationsAskCPSS';
        }
        this.set(`categoryList.${index}.subLabel`, this.i18n(label));
    }
    /**
     * Update the site data link row label when the default cookies content
     * setting changes.
     */
    updateSiteDataLabel_() {
        const state = this.getPref('generated.cookie_default_content_setting').value;
        const index = this.categoryMap_.get(ContentSettingsTypes.SITE_DATA);
        // The site data row might not be part of the current site-settings-list
        // but the class always observes the preference.
        if (index === -1) {
            return;
        }
        let label;
        if (state === ContentSetting.ALLOW) {
            label = 'siteSettingsSiteDataAllowedSubLabel';
        }
        else if (state === ContentSetting.SESSION_ONLY) {
            label = 'siteSettingsSiteDataDeleteOnExitSubLabel';
        }
        else if (state === ContentSetting.BLOCK) {
            label = 'siteSettingsSiteDataBlockedSubLabel';
        }
        assert(!!label);
        this.set(`categoryList.${index}.subLabel`, this.i18n(label));
    }
    /**
     * Update the third-party cookies link row label when the pref changes.
     */
    updateThirdPartyCookiesLabel_() {
        const index = this.categoryMap_.get(ContentSettingsTypes.COOKIES);
        // The third-party cookies might not be part of the current
        // site-settings-list but the class always observes the preference.
        if (index === -1) {
            return;
        }
        let label;
        if (loadTimeData.getBoolean('is3pcdCookieSettingsRedesignEnabled')) {
            if (this.getPref('tracking_protection.block_all_3pc_toggle_enabled')
                .value) {
                label = 'thirdPartyCookiesLinkRowSublabelDisabled';
            }
            else {
                label = 'thirdPartyCookiesLinkRowSublabelLimited';
            }
        }
        else {
            const state = this.getPref('profile.cookie_controls_mode').value;
            if (state === CookieControlsMode.OFF ||
                state === CookieControlsMode.INCOGNITO_ONLY) {
                label = 'thirdPartyCookiesLinkRowSublabelEnabled';
            }
            else if (state === CookieControlsMode.BLOCK_THIRD_PARTY) {
                label = 'thirdPartyCookiesLinkRowSublabelDisabled';
            }
        }
        assert(!!label);
        this.set(`categoryList.${index}.subLabel`, this.i18n(label));
    }
    updateOfferWritingHelpLabel_() {
        if (!loadTimeData.getBoolean('enableComposeProactiveNudge')) {
            return;
        }
        const enabled = this.getPref('compose.proactive_nudge_enabled').value;
        const index = this.categoryMap_.get(ContentSettingsTypes.OFFER_WRITING_HELP);
        // The writing help data row might not be part of the current
        // site-settings-list but the class always observes the preference.
        if (index === -1) {
            return;
        }
        const label = enabled ? 'siteSettingsOfferWritingHelpEnabledSublabel' :
            'siteSettingsOfferWritingHelpDisabledSublabel';
        this.set(`categoryList.${index}.subLabel`, this.i18n(label));
    }
    onClick_(event) {
        Router.getInstance().navigateTo(this.categoryList[event.model.index].route);
    }
}
customElements.define(SettingsSiteSettingsListElement.is, SettingsSiteSettingsListElement);

function getTemplate$I() {
    return html `<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">.no-min-height{min-height:0}#safetyHubModule{padding:0 var(--cr-section-padding)}
  </style>
  <settings-subpage hide-close-button page-title="$i18n{siteSettings}"
      learn-more-url="$i18n{exceptionsLearnMoreURL}"
      route-path$="[[routePath]]">
    <template is="dom-if" if="[[showUnusedSitePermissions_]]">
      <div class="cr-row first">
        <h2>$i18n{safetyHub}</h2>
      </div>
      <settings-safety-hub-module id="safetyHubModule"
          header="[[unusedSitePermissionsHeader_]]"
          subheader="[[unusedSitePermissionsSubheader_]]"
          header-icon="cr:security" header-icon-color="blue">
        <cr-button id="safetyHubButton" slot="button-container"
            class="action-button" on-click="onSafetyHubButtonClick_">
          $i18n{safetyHubEntryPointButtonLabel}
        </cr-button>
      </settings-safety-hub-module>
    </template>
    <div class="cr-row first">
      <h2>$i18n{siteSettingsRecentPermissionsSectionLabel}</h2>
    </div>
    <settings-recent-site-permissions id="recentSitePermissions"
        no-recent-permissions="{{noRecentSitePermissions_}}">
    </settings-recent-site-permissions>

    <cr-link-row data-route="SITE_SETTINGS_ALL" id="allSites"
        class$="[[getClassForSiteSettingsAllLink_(noRecentSitePermissions_)]]"
        label="$i18n{siteSettingsAllSitesDescription}"
        on-click="onSiteSettingsAllClick_"
        role-description="$i18n{subpageArrowRoleDescription}"></cr-link-row>
    <div class="cr-row first line-only">
      <h2>$i18n{siteSettingsPermissions}</h2>
    </div>

    <settings-site-settings-list id="basicPermissionsList" prefs="{{prefs}}"
        category-list="[[lists_.permissionsBasic]]">
    </settings-site-settings-list>
    <cr-expand-button class="cr-row"
        expanded="{{permissionsExpanded_}}">
      <div>$i18n{siteSettingsPermissionsMore}</div>
    </cr-expand-button>
    <cr-collapse opened="[[permissionsExpanded_]]">
      <settings-site-settings-list id="advancedPermissionsList"
          category-list="[[lists_.permissionsAdvanced]]">
      </settings-site-settings-list>
    </cr-collapse>

    <div class="cr-row first line-only">
      <h2>$i18n{siteSettingsContent}</h2>
    </div>
    <settings-site-settings-list id="basicContentList" prefs="{{prefs}}"
        category-list="[[lists_.contentBasic]]">
    </settings-site-settings-list>
    <cr-expand-button id="expandContent" class="cr-row"
        expanded="{{contentExpanded_}}">
      <div>$i18n{siteSettingsContentMore}</div>
    </cr-expand-button>
    <cr-collapse opened="[[contentExpanded_]]">
      <settings-site-settings-list id="advancedContentList" prefs="{{prefs}}"
          category-list="[[lists_.contentAdvanced]]">
      </settings-site-settings-list>
    </cr-collapse>
    <settings-toggle-button
        id="unusedSitePermissionsRevocationToggle"
        pref="{{
            prefs.safety_hub.unused_site_permissions_revocation.enabled}}"
        label="$i18n{safetyHubUnusedSitePermissionsSettingLabel}"
        sub-label=
            "$i18n{safetyHubUnusedSitePermissionsSettingSublabel}">
    </settings-toggle-button>
  </settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-site-settings-page' is the settings page containing privacy and
 * security site settings.
 */
const Id = ContentSettingsTypes;
let categoryItemMap = null;
function getCategoryItemMap() {
    if (categoryItemMap !== null) {
        return categoryItemMap;
    }
    // The following list is ordered alphabetically by |id|. The order in which
    // these appear in the UI is determined elsewhere in this file.
    const categoryList = [
        {
            route: routes.SITE_SETTINGS_ADS,
            id: Id.ADS,
            label: 'siteSettingsAds',
            icon: 'privacy:web-asset',
            enabledLabel: 'siteSettingsAdsAllowed',
            disabledLabel: 'siteSettingsAdsBlocked',
            shouldShow: () => loadTimeData.getBoolean('enableSafeBrowsingSubresourceFilter'),
        },
        {
            route: routes.SITE_SETTINGS_AUTO_VERIFY,
            id: Id.ANTI_ABUSE,
            label: 'siteSettingsAntiAbuse',
            icon: 'privacy20:person-check',
            enabledLabel: 'siteSettingsAntiAbuseEnabledSubLabel',
            disabledLabel: 'siteSettingsAntiAbuseDisabledSubLabel',
        },
        {
            route: routes.SITE_SETTINGS_AR,
            id: Id.AR,
            label: 'siteSettingsAr',
            icon: 'privacy:cardboard',
            enabledLabel: 'siteSettingsArAsk',
            disabledLabel: 'siteSettingsArBlock',
        },
        {
            route: routes.SITE_SETTINGS_AUTOMATIC_DOWNLOADS,
            id: Id.AUTOMATIC_DOWNLOADS,
            label: 'siteSettingsAutomaticDownloads',
            icon: 'cr:file-download',
            enabledLabel: 'siteSettingsAutomaticDownloadsAllowed',
            disabledLabel: 'siteSettingsAutomaticDownloadsBlocked',
        },
        {
            route: routes.SITE_SETTINGS_AUTOMATIC_FULLSCREEN,
            id: Id.AUTOMATIC_FULLSCREEN,
            label: 'siteSettingsAutomaticFullscreen',
            icon: 'cr:fullscreen',
        },
        {
            route: routes.SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE,
            id: Id.AUTO_PICTURE_IN_PICTURE,
            label: 'siteSettingsAutoPictureInPicture',
            icon: 'settings:picture-in-picture',
            enabledLabel: 'siteSettingsAutoPictureInPictureAllowed',
            disabledLabel: 'siteSettingsAutoPictureInPictureBlocked',
            shouldShow: () => loadTimeData.getBoolean('enableAutoPictureInPicture'),
        },
        {
            route: routes.SITE_SETTINGS_BACKGROUND_SYNC,
            id: Id.BACKGROUND_SYNC,
            label: 'siteSettingsBackgroundSync',
            icon: 'cr:sync',
            enabledLabel: 'siteSettingsBackgroundSyncAllowed',
            disabledLabel: 'siteSettingsBackgroundSyncBlocked',
        },
        {
            route: routes.SITE_SETTINGS_BLUETOOTH_DEVICES,
            id: Id.BLUETOOTH_DEVICES,
            label: 'siteSettingsBluetoothDevices',
            icon: 'settings:bluetooth',
            enabledLabel: 'siteSettingsBluetoothDevicesAllowed',
            disabledLabel: 'siteSettingsBluetoothDevicesBlocked',
            shouldShow: () => loadTimeData.getBoolean('enableWebBluetoothNewPermissionsBackend'),
        },
        {
            route: routes.SITE_SETTINGS_BLUETOOTH_SCANNING,
            id: Id.BLUETOOTH_SCANNING,
            label: 'siteSettingsBluetoothScanning',
            icon: 'settings:bluetooth-scanning',
            enabledLabel: 'siteSettingsBluetoothScanningAsk',
            disabledLabel: 'siteSettingsBluetoothScanningBlock',
            shouldShow: () => loadTimeData.getBoolean('enableExperimentalWebPlatformFeatures'),
        },
        {
            route: routes.SITE_SETTINGS_CAMERA,
            id: Id.CAMERA,
            label: 'siteSettingsCamera',
            icon: 'cr:videocam',
            enabledLabel: 'siteSettingsCameraAllowed',
            disabledLabel: 'siteSettingsCameraBlocked',
        },
        {
            route: routes.SITE_SETTINGS_CAPTURED_SURFACE_CONTROL,
            id: Id.CAPTURED_SURFACE_CONTROL,
            label: 'siteSettingsCapturedSurfaceControl',
            icon: 'settings:touchpad-mouse',
            enabledLabel: 'siteSettingsCapturedSurfaceControlAllowed',
            disabledLabel: 'siteSettingsCapturedSurfaceControlBlocked',
            shouldShow: () => loadTimeData.getBoolean('enableCapturedSurfaceControl'),
        },
        {
            route: routes.SITE_SETTINGS_CLIPBOARD,
            id: Id.CLIPBOARD,
            label: 'siteSettingsClipboard',
            icon: 'privacy:content-paste',
            enabledLabel: 'siteSettingsClipboardAllowed',
            disabledLabel: 'siteSettingsClipboardBlocked',
        },
        {
            route: routes.SITE_SETTINGS_FEDERATED_IDENTITY_API,
            id: Id.FEDERATED_IDENTITY_API,
            label: 'siteSettingsFederatedIdentityApi',
            icon: 'privacy:account-circle',
            enabledLabel: 'siteSettingsFederatedIdentityApiAllowed',
            disabledLabel: 'siteSettingsFederatedIdentityApiBlocked',
            shouldShow: () => loadTimeData.getBoolean('enableFederatedIdentityApiContentSetting'),
        },
        {
            route: routes.SITE_SETTINGS_FILE_SYSTEM_WRITE,
            id: Id.FILE_SYSTEM_WRITE,
            label: 'siteSettingsFileSystemWrite',
            icon: 'privacy:file-save',
            enabledLabel: 'siteSettingsFileSystemWriteAllowed',
            disabledLabel: 'siteSettingsFileSystemWriteBlocked',
        },
        {
            route: routes.SITE_SETTINGS_LOCATION,
            id: Id.GEOLOCATION,
            label: 'siteSettingsLocation',
            icon: 'settings:location-on',
            enabledLabel: 'siteSettingsLocationAllowed',
            disabledLabel: 'siteSettingsLocationBlocked',
        },
        {
            route: routes.SITE_SETTINGS_HAND_TRACKING,
            id: Id.HAND_TRACKING,
            label: 'siteSettingsHandTracking',
            icon: 'privacy:hand-gesture',
            enabledLabel: 'siteSettingsHandTrackingAsk',
            disabledLabel: 'siteSettingsHandTrackingBlock',
            shouldShow: () => loadTimeData.getBoolean('enableHandTrackingContentSetting'),
        },
        {
            route: routes.SITE_SETTINGS_HID_DEVICES,
            id: Id.HID_DEVICES,
            label: 'siteSettingsHidDevices',
            icon: 'privacy:videogame-asset',
            enabledLabel: 'siteSettingsHidDevicesAsk',
            disabledLabel: 'siteSettingsHidDevicesBlock',
        },
        {
            route: routes.SITE_SETTINGS_IDLE_DETECTION,
            id: Id.IDLE_DETECTION,
            label: 'siteSettingsIdleDetection',
            icon: 'settings:devices',
            enabledLabel: 'siteSettingsDeviceUseAllowed',
            disabledLabel: 'siteSettingsDeviceUseBlocked',
        },
        {
            route: routes.SITE_SETTINGS_IMAGES,
            id: Id.IMAGES,
            label: 'siteSettingsImages',
            icon: 'privacy:imagesmode',
            enabledLabel: 'siteSettingsImagesAllowed',
            disabledLabel: 'siteSettingsImagesBlocked',
        },
        {
            route: routes.SITE_SETTINGS_JAVASCRIPT,
            id: Id.JAVASCRIPT,
            label: 'siteSettingsJavascript',
            icon: 'privacy:code',
            enabledLabel: 'siteSettingsJavascriptAllowed',
            disabledLabel: 'siteSettingsJavascriptBlocked',
        },
        {
            route: routes.SITE_SETTINGS_JAVASCRIPT_OPTIMIZER,
            id: Id.JAVASCRIPT_OPTIMIZER,
            label: 'siteSettingsJavascriptOptimizer',
            icon: 'privacy:v8',
            enabledLabel: 'siteSettingsJavascriptOptimizerAllowed',
            disabledLabel: 'siteSettingsJavascriptOptimizerBlocked',
        },
        {
            route: routes.SITE_SETTINGS_KEYBOARD_LOCK,
            id: Id.KEYBOARD_LOCK,
            label: 'siteSettingsKeyboardLock',
            icon: 'settings20:keyboard-lock',
            enabledLabel: 'siteSettingsKeyboardLockAllowed',
            disabledLabel: 'siteSettingsKeyboardLockBlocked',
            shouldShow: () => loadTimeData.getBoolean('enableKeyboardLockPrompt'),
        },
        {
            route: routes.SITE_SETTINGS_LOCAL_FONTS,
            id: Id.LOCAL_FONTS,
            label: 'fonts',
            icon: 'privacy:font-download',
            enabledLabel: 'siteSettingsFontsAllowed',
            disabledLabel: 'siteSettingsFontsBlocked',
        },
        {
            route: routes.SITE_SETTINGS_LOCAL_NETWORK_ACCESS,
            id: Id.LOCAL_NETWORK_ACCESS,
            label: 'siteSettingsLocalNetworkAccess',
            icon: 'settings20:router',
            enabledLabel: 'siteSettingsLocalNetworkAccessAsk',
            disabledLabel: 'siteSettingsLocalNetworkAccessBlock',
            shouldShow: () => loadTimeData.getBoolean('enableLocalNetworkAccessSetting'),
        },
        {
            route: routes.SITE_SETTINGS_MICROPHONE,
            id: Id.MIC,
            label: 'siteSettingsMic',
            icon: 'privacy:mic',
            enabledLabel: 'siteSettingsMicAllowed',
            disabledLabel: 'siteSettingsMicBlocked',
        },
        {
            route: routes.SITE_SETTINGS_MIDI_DEVICES,
            id: Id.MIDI_DEVICES,
            label: 'siteSettingsMidiDevices',
            icon: 'privacy:piano',
            enabledLabel: 'siteSettingsMidiAllowed',
            disabledLabel: 'siteSettingsMidiBlocked',
        },
        {
            route: routes.SITE_SETTINGS_MIXEDSCRIPT,
            id: Id.MIXEDSCRIPT,
            label: 'siteSettingsInsecureContent',
            icon: 'privacy:warning',
            disabledLabel: 'siteSettingsInsecureContentBlock',
        },
        {
            route: routes.SITE_SETTINGS_NOTIFICATIONS,
            id: Id.NOTIFICATIONS,
            label: 'siteSettingsNotifications',
            icon: 'privacy:notifications',
        },
        {
            route: routes.OFFER_WRITING_HELP,
            id: Id.OFFER_WRITING_HELP,
            label: 'siteSettingsOfferWritingHelp',
            icon: 'settings:compose',
            shouldShow: () => loadTimeData.getBoolean('enableComposeProactiveNudge'),
        },
        {
            route: routes.SITE_SETTINGS_PAYMENT_HANDLER,
            id: Id.PAYMENT_HANDLER,
            label: 'siteSettingsPaymentHandler',
            icon: 'privacy:credit-card',
            enabledLabel: 'siteSettingsPaymentHandlersAllowed',
            disabledLabel: 'siteSettingsPaymentHandlersBlocked',
            shouldShow: () => loadTimeData.getBoolean('enablePaymentHandlerContentSetting'),
        },
        {
            route: routes.SITE_SETTINGS_PDF_DOCUMENTS,
            id: Id.PDF_DOCUMENTS,
            label: 'siteSettingsPdfDocuments',
            icon: 'privacy:drive-pdf',
            enabledLabel: 'siteSettingsPdfsAllowed',
            disabledLabel: 'siteSettingsPdfsBlocked',
        },
        {
            route: routes.PERFORMANCE,
            id: Id.PERFORMANCE,
            label: 'siteSettingsPerformance',
            icon: 'settings:performance',
            enabledLabel: 'siteSettingsPerformanceSublabel',
            disabledLabel: 'siteSettingsPerformanceSublabel',
        },
        {
            route: routes.SITE_SETTINGS_POPUPS,
            id: Id.POPUPS,
            label: 'siteSettingsPopups',
            icon: 'cr:open-in-new',
            enabledLabel: 'siteSettingsPopupsAllowed',
            disabledLabel: 'siteSettingsPopupsBlocked',
        },
        {
            route: routes.SITE_SETTINGS_PROTECTED_CONTENT,
            id: Id.PROTECTED_CONTENT,
            label: 'siteSettingsProtectedContent',
            icon: 'privacy:sync-saved-locally',
            enabledLabel: 'siteSettingsProtectedContentAllowed',
            disabledLabel: 'siteSettingsProtectedContentBlocked',
        },
        {
            route: routes.SITE_SETTINGS_HANDLERS,
            id: Id.PROTOCOL_HANDLERS,
            label: 'siteSettingsHandlers',
            icon: 'privacy:protocol-handler',
            enabledLabel: 'siteSettingsProtocolHandlersAllowed',
            disabledLabel: 'siteSettingsProtocolHandlersBlocked',
            shouldShow: () => !loadTimeData.getBoolean('isGuest'),
        },
        {
            route: routes.SITE_SETTINGS_SENSORS,
            id: Id.SENSORS,
            label: 'siteSettingsSensors',
            icon: 'privacy:sensors',
            enabledLabel: 'siteSettingsMotionSensorsAllowed',
            disabledLabel: 'siteSettingsMotionSensorsBlocked',
        },
        {
            route: routes.SITE_SETTINGS_SERIAL_PORTS,
            id: Id.SERIAL_PORTS,
            label: 'siteSettingsSerialPorts',
            icon: 'privacy:developer-board',
            enabledLabel: 'siteSettingsSerialPortsAllowed',
            disabledLabel: 'siteSettingsSerialPortsBlocked',
        },
        {
            route: routes.SITE_SETTINGS_SITE_DATA,
            id: Id.SITE_DATA,
            label: 'siteDataPageTitle',
            icon: 'privacy:database',
        },
        // 
        {
            route: routes.SITE_SETTINGS_SOUND,
            id: Id.SOUND,
            label: 'siteSettingsSound',
            icon: 'privacy:volume-up',
            enabledLabel: 'siteSettingsSoundAllowed',
            disabledLabel: 'siteSettingsSoundBlocked',
        },
        {
            route: routes.SITE_SETTINGS_STORAGE_ACCESS,
            id: Id.STORAGE_ACCESS,
            label: 'siteSettingsStorageAccess',
            icon: 'privacy:storage-access',
            enabledLabel: 'storageAccessAllowed',
            disabledLabel: 'storageAccessBlocked',
        },
        {
            route: routes.SITE_SETTINGS_USB_DEVICES,
            id: Id.USB_DEVICES,
            label: 'siteSettingsUsbDevices',
            icon: 'privacy:usb',
            enabledLabel: 'siteSettingsUsbAllowed',
            disabledLabel: 'siteSettingsUsbBlocked',
        },
        {
            route: routes.SITE_SETTINGS_VR,
            id: Id.VR,
            label: 'siteSettingsVr',
            icon: 'privacy:cardboard',
            enabledLabel: 'siteSettingsVrAllowed',
            disabledLabel: 'siteSettingsVrBlocked',
        },
        {
            route: routes.SITE_SETTINGS_WEB_APP_INSTALLATION,
            id: Id.WEB_APP_INSTALLATION,
            label: 'siteSettingsWebAppInstallation',
            icon: 'settings:install-desktop',
            enabledLabel: 'siteSettingsWebAppInstallationAsk',
            disabledLabel: 'siteSettingsWebAppInstallationBlock',
            shouldShow: () => loadTimeData.getBoolean('enableWebAppInstallation'),
        },
        {
            route: routes.SITE_SETTINGS_WEB_PRINTING,
            id: Id.WEB_PRINTING,
            label: 'siteSettingsWebPrinting',
            icon: 'settings:printer',
            enabledLabel: 'siteSettingsWebPrintingAsk',
            disabledLabel: 'siteSettingsWebPrintingBlock',
            shouldShow: () => loadTimeData.getBoolean('enableWebPrintingContentSetting'),
        },
        {
            route: routes.SITE_SETTINGS_WINDOW_MANAGEMENT,
            id: Id.WINDOW_MANAGEMENT,
            label: 'siteSettingsWindowManagement',
            icon: 'privacy:select-window',
            enabledLabel: 'siteSettingsWindowManagementAsk',
            disabledLabel: 'siteSettingsWindowManagementBlocked',
        },
        {
            route: routes.SITE_SETTINGS_ZOOM_LEVELS,
            id: Id.ZOOM_LEVELS,
            label: 'siteSettingsZoomLevels',
            icon: 'privacy:zoom-in',
        },
        {
            route: routes.COOKIES,
            id: Id.COOKIES,
            label: 'thirdPartyCookiesLinkRowLabel',
            icon: 'privacy:cookie',
        },
    ];
    categoryItemMap = new Map(categoryList.map(item => [item.id, item]));
    return categoryItemMap;
}
function buildItemListFromIds(orderedIdList) {
    const map = getCategoryItemMap();
    const orderedList = [];
    for (const id of orderedIdList) {
        const item = map.get(id);
        if (item.shouldShow === undefined || item.shouldShow()) {
            orderedList.push(item);
        }
    }
    return orderedList;
}
const SettingsSiteSettingsPageElementBase = RouteObserverMixin(SettingsViewMixin(WebUiListenerMixin(PolymerElement)));
class SettingsSiteSettingsPageElement extends SettingsSiteSettingsPageElementBase {
    static get is() {
        return 'settings-site-settings-page';
    }
    static get template() {
        return getTemplate$I();
    }
    static get properties() {
        return {
            /**
             * Preferences state.
             */
            prefs: {
                type: Object,
                notify: true,
            },
            lists_: {
                type: Object,
                value: function () {
                    return {
                        permissionsBasic: buildItemListFromIds([
                            Id.GEOLOCATION,
                            Id.CAMERA,
                            Id.MIC,
                            Id.NOTIFICATIONS,
                            Id.STORAGE_ACCESS,
                        ]),
                        permissionsAdvanced: buildItemListFromIds([
                            Id.BACKGROUND_SYNC,
                            Id.SENSORS,
                            Id.AUTOMATIC_DOWNLOADS,
                            Id.PROTOCOL_HANDLERS,
                            Id.MIDI_DEVICES,
                            Id.USB_DEVICES,
                            Id.SERIAL_PORTS,
                            Id.BLUETOOTH_DEVICES,
                            Id.FILE_SYSTEM_WRITE,
                            Id.HID_DEVICES,
                            Id.CLIPBOARD,
                            Id.PAYMENT_HANDLER,
                            Id.BLUETOOTH_SCANNING,
                            Id.AR,
                            Id.VR,
                            Id.HAND_TRACKING,
                            Id.IDLE_DETECTION,
                            Id.WEB_PRINTING,
                            Id.WINDOW_MANAGEMENT,
                            Id.LOCAL_FONTS,
                            Id.AUTO_PICTURE_IN_PICTURE,
                            Id.CAPTURED_SURFACE_CONTROL,
                            Id.KEYBOARD_LOCK,
                            // 
                            Id.WEB_APP_INSTALLATION,
                            Id.LOCAL_NETWORK_ACCESS,
                        ]),
                        contentBasic: buildItemListFromIds([
                            Id.COOKIES,
                            Id.JAVASCRIPT,
                            Id.IMAGES,
                            Id.POPUPS,
                        ]),
                        contentAdvanced: buildItemListFromIds([
                            Id.SOUND,
                            Id.ADS,
                            Id.ZOOM_LEVELS,
                            Id.PDF_DOCUMENTS,
                            Id.PROTECTED_CONTENT,
                            Id.MIXEDSCRIPT,
                            Id.FEDERATED_IDENTITY_API,
                            Id.ANTI_ABUSE,
                            Id.SITE_DATA,
                            Id.PERFORMANCE,
                            Id.JAVASCRIPT_OPTIMIZER,
                            Id.AUTOMATIC_FULLSCREEN,
                            Id.OFFER_WRITING_HELP,
                        ]),
                    };
                },
            },
            permissionsExpanded_: Boolean,
            contentExpanded_: Boolean,
            noRecentSitePermissions_: Boolean,
            showUnusedSitePermissions_: {
                type: Boolean,
                value: false,
            },
            unusedSitePermissionsHeader_: String,
            unusedSitePermissionsSubheader_: String,
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener(SafetyHubEvent.UNUSED_PERMISSIONS_MAYBE_CHANGED, (sites) => this.onUnusedSitePermissionListChanged_(sites));
        this.safetyHubBrowserProxy_.getRevokedUnusedSitePermissionsList().then((sites) => this.onUnusedSitePermissionListChanged_(sites));
    }
    safetyHubBrowserProxy_ = SafetyHubBrowserProxyImpl.getInstance();
    metricsBrowserProxy_ = MetricsBrowserProxyImpl.getInstance();
    currentRouteChanged(newRoute, oldRoute) {
        super.currentRouteChanged(newRoute, oldRoute);
        if (Router.getInstance().getCurrentRoute() !== routes.SITE_SETTINGS) {
            return;
        }
        // Only record the metrics when the user navigates to the privacy page
        // that shows the entry point.
        if (this.showUnusedSitePermissions_) {
            this.metricsBrowserProxy_.recordSafetyHubEntryPointShown(SafetyHubEntryPoint.SITE_SETTINGS);
        }
    }
    onSiteSettingsAllClick_() {
        Router.getInstance().navigateTo(routes.SITE_SETTINGS_ALL);
    }
    async onUnusedSitePermissionListChanged_(permissions) {
        // The unused site permissions review is shown when there are items to
        // review (provided the feature is enabled). Once visible it remains that
        // way to show completion info, even if the list is emptied.
        if (this.showUnusedSitePermissions_) {
            return;
        }
        this.showUnusedSitePermissions_ =
            permissions.length > 0 && !loadTimeData.getBoolean('isGuest');
        this.unusedSitePermissionsHeader_ =
            await PluralStringProxyImpl.getInstance().getPluralString('safetyHubUnusedSitePermissionsPrimaryLabel', permissions.length);
        // TODO(crbug/342210522): Add test for this.
        this.unusedSitePermissionsSubheader_ =
            await PluralStringProxyImpl.getInstance().getPluralString('safetyHubRevokedPermissionsSecondaryLabel', permissions.length);
    }
    /** @return Class for the all site settings link */
    getClassForSiteSettingsAllLink_() {
        return this.noRecentSitePermissions_ ? '' : 'hr';
    }
    onSafetyHubButtonClick_() {
        this.metricsBrowserProxy_.recordSafetyHubEntryPointClicked(SafetyHubEntryPoint.SITE_SETTINGS);
        Router.getInstance().navigateTo(routes.SAFETY_HUB);
    }
    // SettingsViewMixin implementation.
    getFocusConfig() {
        const focusConfig = new Map([
            [
                `${routes.SITE_SETTINGS_ALL.path}`,
                '#allSites',
            ],
        ]);
        const siteSettingsLists = this.shadowRoot.querySelectorAll('settings-site-settings-list');
        for (const list of siteSettingsLists) {
            for (const [key, value] of list.getFocusConfig()) {
                focusConfig.set(key, value);
            }
        }
        for (const [key, value] of this.$.recentSitePermissions.getFocusConfig()) {
            focusConfig.set(key, value);
        }
        return focusConfig;
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SettingsSiteSettingsPageElement.is, SettingsSiteSettingsPageElement);

function getTemplate$H() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsSound}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsSoundDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.SOUND]]"
      allow-option-label="$i18n{siteSettingsSoundAllowed}"
      allow-option-icon="privacy:volume-up"
      block-option-label="$i18n{siteSettingsSoundBlocked}"
      block-option-sub-label="$i18n{siteSettingsSoundBlockedSubLabel}"
      block-option-icon="privacy:volume-off">
  </settings-category-default-radio-group>
  <settings-toggle-button
      id="blockAutoplaySetting"
      class="hr"
      label="$i18n{siteSettingsBlockAutoplaySetting}"
      pref="{{blockAutoplayStatus_.pref}}"
      disabled="[[!blockAutoplayStatus_.enabled]]"
      hidden="[[!enableBlockAutoplayContentSetting_]]"
      on-settings-boolean-control-change="onBlockAutoplayToggleChange_"
      no-set-pref>
  </settings-toggle-button>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.SOUND]]"
      allow-header="$i18n{siteSettingsSoundAllowedExceptions}"
      block-header="$i18n{siteSettingsSoundBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SoundPageElementBase = SettingsViewMixin(WebUiListenerMixin(PolymerElement));
class SoundPageElement extends SoundPageElementBase {
    static get is() {
        return 'settings-sound-page';
    }
    static get template() {
        return getTemplate$H();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
            blockAutoplayStatus_: {
                type: Object,
                value() {
                    return {};
                },
            },
            enableBlockAutoplayContentSetting_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('enableBlockAutoplayContentSetting');
                },
            },
        };
    }
    browserProxy_ = SiteSettingsBrowserProxyImpl.getInstance();
    ready() {
        super.ready();
        this.onBlockAutoplayStatusChanged_({
            pref: {
                key: '',
                type: chrome.settingsPrivate.PrefType.BOOLEAN,
                value: false,
            },
            enabled: false,
        });
        this.addWebUiListener('onBlockAutoplayStatusChanged', (status) => this.onBlockAutoplayStatusChanged_(status));
    }
    // Called when the block autoplay status changes.
    onBlockAutoplayStatusChanged_(autoplayStatus) {
        this.blockAutoplayStatus_ = autoplayStatus;
    }
    // Updates the block autoplay pref when the toggle is changed.
    onBlockAutoplayToggleChange_(event) {
        const target = event.target;
        this.browserProxy_.setBlockAutoplayEnabled(target.checked);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(SoundPageElement.is, SoundPageElement);

function getTemplate$G() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared"></style>
<div class="cr-row first">
  <h2 class="cr-secondary-text">[[categoryHeader]]</h2>
</div>
<div class="list-frame"
    hidden$="[[hasExceptions_(storageAccessExceptions_.*)]]">
  <div class="list-item cr-secondary-text">$i18n{noSitesAdded}</div>
</div>
<div class="list-frame" hidden$=
    "[[!showNoSearchResults_(searchFilter, storageAccessExceptions_.*)]]">
  <div class="list-item cr-secondary-text">$i18n{searchNoResults}</div>
</div>
<div class="list-frame vertical-list" id="listContainer" hidden$=
    "[[!hasExceptions_(storageAccessExceptions_.*)]]">
  <template is="dom-repeat" items=
      "[[getFilteredExceptions_(searchFilter, storageAccessExceptions_.*)]]">
    <storage-access-site-list-entry model="[[item]]">
    </storage-access-site-list-entry>
  </template>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'storage-access-site-list' is an element representing a list of storage
 * access permissions group with the same type of permission (e.g. allow,
 * block).
 */
const StorageAccessSiteListElementBase = ListPropertyUpdateMixin(SiteSettingsMixin(WebUiListenerMixin(PolymerElement)));
class StorageAccessSiteListElement extends StorageAccessSiteListElementBase {
    static get is() {
        return 'storage-access-site-list';
    }
    static get template() {
        return getTemplate$G();
    }
    static get properties() {
        return {
            /**
             * Header shown for the |categorySubtype|.
             */
            categoryHeader: String,
            /**
             * Array of group of storage access site exceptions of |categorySubtype|
             * to display in the widget.
             */
            storageAccessExceptions_: {
                type: Array,
                value() {
                    return [];
                },
            },
            /**
             * The type of category this widget is displaying data for. Normally
             * either 'allow' or 'block', representing which sites are allowed or
             * blocked respectively from Storage Access while embedded on another
             * site.
             */
            categorySubtype: {
                type: String,
                value: INVALID_CATEGORY_SUBTYPE,
            },
            searchFilter: {
                type: String,
                observer: 'getFilteredExceptions_',
            },
        };
    }
    static get observers() {
        return ['populateList_(categorySubtype, storageAccessExceptions_)'];
    }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('contentSettingSitePermissionChanged', (category) => {
            if (category !== ContentSettingsTypes.STORAGE_ACCESS) {
                return;
            }
            this.populateList_();
        });
        this.addWebUiListener('onIncognitoStatusChanged', () => this.populateList_());
        this.browserProxy.updateIncognitoStatus();
    }
    /**
     * Populates the StorageAccessSiteList for display.
     */
    async populateList_() {
        if (this.categorySubtype === undefined) {
            return;
        }
        const exceptionList = await this.browserProxy.getStorageAccessExceptionList(this.categorySubtype);
        this.updateList('storageAccessExceptions_', x => x.origin, exceptionList);
    }
    /**
     * Whether there are any results to show to the user according with the
     * |searchFilter|.
     */
    showNoSearchResults_() {
        return this.storageAccessExceptions_.length > 0 &&
            this.getFilteredExceptions_().length === 0;
    }
    /**
     * Whether there are any storage access site exceptions of |categorySubtype|.
     */
    hasExceptions_() {
        return this.storageAccessExceptions_.length > 0;
    }
    /**
     * Returns the filtered |StorageAccessSiteException|s that match the
     * |searchFilter|.
     *
     * It looks for matches in |displayName|, and |origin|. If the |origin| or
     * |displayName| don't match, it looks for matches in |embeddingDisplayName|,
     * and |embeddingOrigin|.
     */
    getFilteredExceptions_() {
        if (!this.searchFilter) {
            return this.storageAccessExceptions_.slice();
        }
        const searchFilter = this.searchFilter.toLowerCase();
        const propNames = ['displayName', 'origin'];
        return this.storageAccessExceptions_.filter(site => propNames.some(propName => {
            return site[propName].toLowerCase().includes(searchFilter) ||
                this.getFilteredEmbeddingExceptions_(site.exceptions, searchFilter)
                    .length;
        }));
    }
    getFilteredEmbeddingExceptions_(exceptions, searchFilter) {
        const propNamesEmbedding = ['embeddingDisplayName', 'embeddingOrigin'];
        return exceptions.filter(embedding => propNamesEmbedding.some(propNamesEmbedding => embedding[propNamesEmbedding].toLowerCase().includes(searchFilter)));
    }
}
customElements.define(StorageAccessSiteListElement.is, StorageAccessSiteListElement);

function getTemplate$F() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsStorageAccess}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{storageAccessDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.STORAGE_ACCESS]]"
      allow-option-label="$i18n{storageAccessAllowed}"
      allow-option-icon="privacy:storage-access"
      block-option-label="$i18n{storageAccessBlocked}"
      block-option-icon="privacy:storage-access-off">
  </settings-category-default-radio-group>
  <!-- Exceptions section. -->
  <div class="content-settings-header">
    <h2>$i18n{siteSettingsCustomizedBehaviors}</h2>
    <div class="cr-secondary-text">
      $i18n{siteSettingsCustomizedBehaviorsDescription}
    </div>
  </div>
  <storage-access-site-list
      category-subtype="[[contentSettingEnum_.BLOCK]]"
      category-header="$i18n{storageAccessBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </storage-access-site-list>
  <storage-access-site-list
      category-subtype="[[contentSettingEnum_.ALLOW]]"
      category-header="$i18n{storageAccessAllowedExceptions}"
      search-filter="[[searchTerm]]">
  </storage-access-site-list>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const StorageAccessPageElementBase = SettingsViewMixin(PolymerElement);
class StorageAccessPageElement extends StorageAccessPageElementBase {
    static get is() {
        return 'settings-storage-access-page';
    }
    static get template() {
        return getTemplate$F();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
            // Expose ContentSetting enum to the HTML template.
            contentSettingEnum_: {
                type: Object,
                value: ContentSetting,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(StorageAccessPageElement.is, StorageAccessPageElement);

function getTemplate$E() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsUsbDevices}"
    learn-more-url="$i18n{chooserUsbOverviewURL}"
    route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsUsbDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.USB_DEVICES]]"
      allow-option-label="$i18n{siteSettingsUsbAllowed}"
      allow-option-icon="privacy:usb"
      block-option-label="$i18n{siteSettingsUsbBlocked}"
      block-option-icon="privacy:usb-off">
  </settings-category-default-radio-group>
  <chooser-exception-list
      category="[[contentSettingsTypesEnum_.USB_DEVICES]]"
      chooser-type="[[chooserTypeEnum_.USB_DEVICES]]">
  </chooser-exception-list>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const UsbDevicesPageElementBase = SettingsViewMixin(PolymerElement);
class UsbDevicesPageElement extends UsbDevicesPageElementBase {
    static get is() {
        return 'settings-usb-devices-page';
    }
    static get template() {
        return getTemplate$E();
    }
    static get properties() {
        return {
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
            // Expose ChooserType enum to the HTML template.
            chooserTypeEnum_: {
                type: Object,
                value: ChooserType,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(UsbDevicesPageElement.is, UsbDevicesPageElement);

function getTemplate$D() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage
    page-title="$i18n{siteSettingsCategoryJavascriptOptimizer}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsJavascriptOptimizerDescription}
  </div>
  <div class="radio-group">
    <h2>$i18n{siteSettingsDefaultBehavior}</h2>
    <div id="radioGroupSubLabel" class="secondary">
      $i18n{siteSettingsDefaultBehaviorDescription}
    </div>
    <settings-radio-group
        id="javascriptOptimizerRadioGroup"
        pref="{{prefs.generated.javascript_optimizer}}"
        selectable-elements="settings-collapse-radio-button"
        group-aria-label="$i18n{siteSettingsDefaultBehavior}">
      <settings-collapse-radio-button
          id="enableForAllSites"
          class="two-line"
          name="[[javascriptOptimizerSettingEnum_.ALLOWED]]"
          pref="[[prefs.generated.javascript_optimizer]]"
          label="$i18n{siteSettingsJavascriptOptimizerAllowed}"
          sub-label="$i18n{siteSettingsJavascriptOptimizerAllowedSubLabel}"
          no-collapse>
      </settings-collapse-radio-button>
      <template is="dom-if"
          if="[[enableBlockV8OptimizerOnUnfamiliarSites_]]">
        <settings-collapse-radio-button
            id="blockForUnfamiliarSites"
            class="two-line"
            name="[[javascriptOptimizerSettingEnum_.BLOCKED_FOR_UNFAMILIAR_SITES]]"
            pref="[[prefs.generated.javascript_optimizer]]"
            label="$i18n{siteSettingsJavascriptOptimizerBlockedUnfamiliarSites}"
            sub-label="[[getBlockForUnfamiliarSitesSubLabel_(
                prefs.generated.javascript_optimizer.value)]]"
            no-collapse>
        </settings-collapse-radio-button>
      </template>
      <settings-collapse-radio-button
          id="blockForAllSites"
          class="two-line"
          name="[[javascriptOptimizerSettingEnum_.BLOCKED]]"
          pref="[[prefs.generated.javascript_optimizer]]"
          label="$i18n{siteSettingsJavascriptOptimizerBlocked}"
          sub-label="$i18n{siteSettingsJavascriptOptimizerBlockedSubLabel}"
          no-collapse>
      </settings-collapse-radio-button>
    </settings-radio-group>
  </div>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.JAVASCRIPT_OPTIMIZER]]"
      allow-header="$i18n{siteSettingsJavascriptOptimizerAllowedExceptions}"
      block-header="$i18n{siteSettingsJavascriptOptimizerBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const V8PageElementBase = SettingsViewMixin(I18nMixin(PrefsMixin(PolymerElement)));
class V8PageElement extends V8PageElementBase {
    static get is() {
        return 'settings-v8-page';
    }
    static get template() {
        return getTemplate$D();
    }
    static get properties() {
        return {
            searchTerm: String,
            enableBlockV8OptimizerOnUnfamiliarSites_: {
                type: Boolean,
                value() {
                    return loadTimeData.getBoolean('enableBlockV8OptimizerOnUnfamiliarSites');
                },
            },
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
            // Expose JavascriptOptimizerSetting enum to the HTML template.
            javascriptOptimizerSettingEnum_: {
                type: Object,
                value: JavascriptOptimizerSetting,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
    getBlockForUnfamiliarSitesSubLabel_() {
        const safeBrowsingSetting = this.getPref('generated.safe_browsing').value;
        return this.i18n(safeBrowsingSetting === SafeBrowsingSetting$1.DISABLED
            ? 'siteSettingsJavascriptOptimizerBlockedUnfamiliarSitesSafeBrowsingOffSubLabel'
            : 'siteSettingsJavascriptOptimizerBlockedUnfamiliarSitesSubLabel');
    }
}
customElements.define(V8PageElement.is, V8PageElement);

function getTemplate$C() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsVr}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsVrDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.VR]]"
      allow-option-label="$i18n{siteSettingsVrAllowed}"
      allow-option-icon="privacy:cardboard"
      block-option-label="$i18n{siteSettingsVrBlocked}"
      block-option-icon="privacy:cardboard-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.VR]]"
      read-only-list
      allow-header="$i18n{siteSettingsVrAllowedExceptions}"
      block-header="$i18n{siteSettingsVrBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const VrPageElementBase = SettingsViewMixin(PolymerElement);
class VrPageElement extends VrPageElementBase {
    static get is() {
        return 'settings-vr-page';
    }
    static get template() {
        return getTemplate$C();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(VrPageElement.is, VrPageElement);

function getTemplate$B() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsWebAppInstallation}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsWebAppInstallationDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.WEB_APP_INSTALLATION]]"
      allow-option-label="$i18n{siteSettingsWebAppInstallationAsk}"
      allow-option-icon="settings:install-desktop"
      block-option-label="$i18n{siteSettingsWebAppInstallationBlock}"
      block-option-icon="settings:install-desktop-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.WEB_APP_INSTALLATION]]"
      block-header=
          "$i18n{siteSettingsWebAppInstallationBlockedExceptions}"
      allow-header=
          "$i18n{siteSettingsWebAppInstallationAllowedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const WebApplicationsPageElementBase = SettingsViewMixin(PolymerElement);
class WebApplicationsPageElement extends WebApplicationsPageElementBase {
    static get is() {
        return 'settings-web-applications-page';
    }
    static get template() {
        return getTemplate$B();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(WebApplicationsPageElement.is, WebApplicationsPageElement);

function getTemplate$A() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsWebPrinting}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
      $i18n{siteSettingsWebPrintingDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.WEB_PRINTING]]"
      allow-option-label="$i18n{siteSettingsWebPrintingAsk}"
      allow-option-icon="settings:printer"
      block-option-label="$i18n{siteSettingsWebPrintingBlock}"
      block-option-icon="settings:printer-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.WEB_PRINTING]]"
      allow-header="$i18n{siteSettingsWebPrintingAllowedExceptions}"
      block-header="$i18n{siteSettingsWebPrintingBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const WebPrintingPageElementBase = SettingsViewMixin(PolymerElement);
class WebPrintingPageElement extends WebPrintingPageElementBase {
    static get is() {
        return 'settings-web-printing-page';
    }
    static get template() {
        return getTemplate$A();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(WebPrintingPageElement.is, WebPrintingPageElement);

function getTemplate$z() {
    return html `<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsWindowManagement}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsWindowManagementDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.WINDOW_MANAGEMENT]]"
      allow-option-label="$i18n{siteSettingsWindowManagementAsk}"
      allow-option-icon="privacy:select-window"
      block-option-label="$i18n{siteSettingsWindowManagementBlocked}"
      block-option-icon="privacy:select-window-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.WINDOW_MANAGEMENT]]"
      allow-header="$i18n{siteSettingsWindowManagementAskExceptions}"
      block-header=
          "$i18n{siteSettingsWindowManagementBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const WindowManagementPageElementBase = SettingsViewMixin(PolymerElement);
class WindowManagementPageElement extends WindowManagementPageElementBase {
    static get is() {
        return 'settings-window-management-page';
    }
    static get template() {
        return getTemplate$z();
    }
    static get properties() {
        return {
            searchTerm: String,
            // Expose ContentSettingsTypes enum to the HTML template.
            contentSettingsTypesEnum_: {
                type: Object,
                value: ContentSettingsTypes,
            },
        };
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(WindowManagementPageElement.is, WindowManagementPageElement);

function getTemplate$y() {
    return html `<!--_html_template_start_-->  <style include="settings-shared">:host{display:block}.zoom-label{color:var(--cr-secondary-text-color);margin-inline-end:16px}#empty{margin-top:15px}.list-item site-favicon{flex-shrink:0}.list-item .middle{overflow-x:hidden;text-overflow:ellipsis}.content-settings-header{padding:0 var(--cr-section-padding)}
  </style>
  <settings-subpage page-title="$i18n{siteSettingsCategoryZoomLevels}">
    <div class="content-settings-header secondary">
      $i18n{siteSettingsZoomLevelsDescription}
    </div>
    <div class="list-frame vertical-list" id="listContainer">
      <iron-list id="list" preserve-focus items="[[sites_]]"
          class="cr-separators" risk-selection>
        <template>
          <div class="list-item" first$="[[!index]]">
            <site-favicon url="[[item.originForFavicon]]"></site-favicon>
            <div class="middle">
              <span class="url-directionality">[[item.displayName]]</span>
            </div>
            <div class="zoom-label">[[item.zoom]]</div>
            <cr-icon-button class="icon-clear" on-click="removeZoomLevel_"
                title="$i18n{siteSettingsRemoveZoomLevel}"
                tabindex$="[[tabIndex]]"></cr-icon-button>
          </div>
        </template>
      </iron-list>
      <div id="empty" hidden$="[[!showNoSites_]]">
        $i18n{siteSettingsNoZoomedSites}
      </div>
    </div>
  </settings-subpage>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'zoom-levels' is the polymer element for showing the sites that are zoomed in
 * or out.
 */
const ZoomLevelsElementBase = SettingsViewMixin(ListPropertyUpdateMixin(SiteSettingsMixin(WebUiListenerMixin(PolymerElement))));
class ZoomLevelsElement extends ZoomLevelsElementBase {
    static get is() {
        return 'zoom-levels';
    }
    static get template() {
        return getTemplate$y();
    }
    static get properties() {
        return {
            /**
             * Array of sites that are zoomed in or out.
             */
            sites_: {
                type: Array,
                value: () => [],
            },
            showNoSites_: {
                type: Boolean,
                value: false,
            },
        };
    }
    ready() {
        super.ready();
        this.addWebUiListener('onZoomLevelsChanged', (sites) => this.onZoomLevelsChanged_(sites));
        this.browserProxy.fetchZoomLevels();
    }
    /**
     * A handler for when zoom levels change.
     * @param sites The up to date list of sites and their zoom levels.
     */
    onZoomLevelsChanged_(sites) {
        this.updateList('sites_', item => item.hostOrSpec, sites);
        this.showNoSites_ = this.sites_.length === 0;
    }
    /**
     * A handler for when a zoom level for a site is deleted.
     */
    removeZoomLevel_(event) {
        const site = this.sites_[event.model.index];
        this.browserProxy.removeZoomLevel(site.hostOrSpec);
    }
    // SettingsViewMixin implementation.
    focusBackButton() {
        this.shadowRoot.querySelector('settings-subpage').focusBackButton();
    }
}
customElements.define(ZoomLevelsElement.is, ZoomLevelsElement);

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A helper object used from the Chrome captions section to
 * interact with the browser. Used on operating system that is not Chrome OS.
 */
class CaptionsBrowserProxyImpl {
    openSystemCaptionsDialog() {
        chrome.send('openSystemCaptionsDialog');
    }
    liveCaptionSectionReady() {
        chrome.send('liveCaptionSectionReady');
    }
    getInstalledLanguagePacks() {
        return sendWithPromise('getInstalledLanguagePacks');
    }
    getAvailableLanguagePacks() {
        return sendWithPromise('getAvailableLanguagePacks');
    }
    removeLanguagePack(languageCode) {
        chrome.send('removeLanguagePack', [languageCode]);
    }
    installLanguagePacks(languageCodes) {
        chrome.send('installLanguagePacks', languageCodes);
    }
    static getInstance() {
        return instance$i || (instance$i = new CaptionsBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance$i = obj;
    }
}
let instance$i = null;

function getTemplate$x() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">.cr-row-with-template{padding:0}#liveCaptionToggleButton{width:100%}.language-dropdown{margin-inline-start:auto}#defaultLanguageLabel{color:var(--cr-secondary-text-color)}</style>
<template is="dom-if" if="[[!enableLiveCaptionMultiLanguage_]]">
  <div class="cr-row cr-row-with-template first">
    <settings-toggle-button id="liveCaptionToggleButton"
        pref="{{prefs.accessibility.captions.live_caption_enabled}}"
        on-change="onLiveCaptionEnabledChanged_"
        label="$i18n{captionsEnableLiveCaptionTitle}"
        sub-label="[[enableLiveCaptionSubtitle_]]">
    </settings-toggle-button>
  </div>
  <cr-collapse
      opened="[[prefs.accessibility.captions.live_caption_enabled.value]]">
    <settings-toggle-button id="maskOffensiveWordsToggleButton"
        pref="{{prefs.accessibility.captions.live_caption_mask_offensive_words}}"
        on-change="onLiveCaptionMaskOffensiveWordsChanged_"
        label="$i18n{captionsMaskOffensiveWordsTitle}">
    </settings-toggle-button>
  </cr-collapse>
</template>

<template is="dom-if" if="[[enableLiveCaptionMultiLanguage_]]">
  <div class="cr-row cr-row-with-template first">
    <settings-toggle-button id="liveCaptionToggleButton"
        pref="{{prefs.accessibility.captions.live_caption_enabled}}"
        on-change="onLiveCaptionEnabledChanged_"
        label="$i18n{captionsEnableLiveCaptionTitle}"
        sub-label="$i18n{captionsEnableLiveCaptionSubtitle}">
    </settings-toggle-button>
  </div>
  <cr-collapse
      opened="[[prefs.accessibility.captions.live_caption_enabled.value]]">
    <div class="cr-row continuation">
      <div class="flex settings-box-text">
        $i18n{captionsManageLanguagesTitle}
        <div class="secondary">$i18n{captionsManageLanguagesSubtitle}</div>
      </div>
      <cr-button id="addLanguage" on-click="onAddLanguagesClick_">
        $i18n{addLanguages}
      </cr-button>
    </div>
    <div class="list-frame">
      <div id="languageList" class="vertical-list" role="list">
        <template is="dom-repeat" items="[[installedLanguagePacks_]]">
          <div class="list-item" role="listitem">
            <div class="start cr-padded-text">[[item.displayName]]
              <span id="defaultLanguageLabel"
                  hidden$="[[!isDefaultLanguage_(item.code,
                 prefs.accessibility.captions.live_caption_language.value)]]">
                $i18n{defaultLanguageLabel}
              </span>
            </div>
            <span aria-live="polite" role="region"
                class="cr-secondary-text cr-row-gap">
              [[item.downloadProgress]]
            </span>
            <cr-icon-button class="icon-more-vert" title="$i18n{moreActions}"
                id="more-[[item.language.code]]" on-click="onDotsClick_"
                aria-label="[[computeMoreButtonAriaLabel_(item.displayName,
              item.code,
              prefs.accessibility.captions.live_caption_language.value)]]">
            </cr-icon-button>
          </div>
        </template>
      </div>
    </div>
    <settings-toggle-button id="maskOffensiveWordsToggleButton"
        pref="{{prefs.accessibility.captions.live_caption_mask_offensive_words}}"
        on-change="onLiveCaptionMaskOffensiveWordsChanged_"
        label="$i18n{captionsMaskOffensiveWordsTitle}">
    </settings-toggle-button>
  </cr-collapse>
  <template is="dom-if" if="[[enableLiveTranslate_]]">
    <settings-live-translate prefs="{{prefs}}"></settings-live-translate>
  </template>
</template>
<template is="dom-if" if="[[showAddLanguagesDialog_]]" restamp>
  <settings-add-languages-dialog id="addLanguagesDialog"
      languages="[[filterAvailableLanguagePacks_(availableLanguagePacks_,
                   installedLanguagePacks_)]]"
      on-close="onAddLanguagesDialogClose_"
      on-languages-added="onLanguagesAdded_">
  </settings-add-languages-dialog>
</template>
<cr-lazy-render id="menu">
  <template>
    <cr-action-menu role-description="$i18n{menu}">
      <button class="dropdown-item" role="menuitem" id="make-default-button"
          on-click="onMakeDefaultClick_">
        $i18n{makeDefaultLanguageLabel}
      </button>
      <button class="dropdown-item" role="menuitem" id="remove-button"
          on-click="onRemoveLanguageClick_">
        $i18n{removeLanguageLabel}
      </button>
    </cr-action-menu>
  </template>
</cr-lazy-render>

<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class LanguagesBrowserProxyImpl {
    // 
    getLanguageSettingsPrivate() {
        return chrome.languageSettingsPrivate;
    }
    static getInstance() {
        return instance$h || (instance$h = new LanguagesBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance$h = obj;
    }
}
let instance$h = null;

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-languages' handles Chrome's language and input
 * method settings. The 'languages' property, which reflects the current
 * language settings, must not be changed directly. Instead, changes to
 * language settings should be made using the LanguageHelper APIs provided by
 * this class via the LanguageHelper singleton instance.
 */
const MoveType = chrome.languageSettingsPrivate.MoveType;
// The fake language name used for ARC IMEs. The value must be in sync with the
// one in ui/base/ime/ash/extension_ime_util.h.
const kArcImeLanguage = '_arc_ime_language_';
let instance$g = null;
function getLanguageHelperInstance() {
    assert(instance$g);
    return instance$g;
}
/**
 * Singleton element that generates the languages model on start-up and
 * updates it whenever Chrome's pref store and other settings change.
 */
const SettingsLanguagesElementBase = PrefsMixin(PolymerElement);
class SettingsLanguagesElement extends SettingsLanguagesElementBase {
    static get is() {
        return 'settings-languages';
    }
    static get properties() {
        return {
            languages: {
                type: Object,
                notify: true,
            },
        };
    }
    static get observers() {
        return [
            // All observers wait for the model to be populated by including the
            // |languages| property.
            'alwaysTranslateLanguagesPrefChanged_(' +
                'prefs.translate_allowlists.value.*, languages)',
            'neverTranslateLanguagesPrefChanged_(' +
                'prefs.translate_blocked_languages.value.*, languages)',
            'neverTranslateSitesPrefChanged_(' +
                'prefs.translate_site_blocklist_with_time.value.*, languages)',
            // 
            'preferredLanguagesPrefChanged_(' +
                'prefs.intl.accept_languages.value, languages)',
            'preferredLanguagesPrefChanged_(' +
                'prefs.intl.forced_languages.value.*, languages)',
            'spellCheckDictionariesPrefChanged_(' +
                'prefs.spellcheck.dictionaries.value.*, ' +
                'prefs.spellcheck.forced_dictionaries.value.*, ' +
                'prefs.spellcheck.blocked_dictionaries.value.*, languages)',
            'translateLanguagesPrefChanged_(' +
                'prefs.translate_blocked_languages.value.*, languages)',
            'translateTargetPrefChanged_(' +
                'prefs.translate_recent_target.value, languages)',
            'updateRemovableLanguages_(' +
                'prefs.intl.app_locale.value, languages.enabled)',
            'updateRemovableLanguages_(' +
                'prefs.translate_blocked_languages.value.*)',
        ];
    }
    resolver_ = new PromiseResolver();
    supportedLanguageMap_ = new Map();
    enabledLanguageSet_ = new Set();
    // 
    // 
    browserProxy_ = LanguagesBrowserProxyImpl.getInstance();
    languageSettingsPrivate_;
    constructor() {
        super();
        this.languageSettingsPrivate_ =
            this.browserProxy_.getLanguageSettingsPrivate();
    }
    connectedCallback() {
        super.connectedCallback();
        assert(!instance$g);
        instance$g = this;
        const promises = [];
        /**
         * An object passed into createModel to keep track of platform-specific
         * arguments, populated by the "promises" array.
         */
        const args = {
            supportedLanguages: [],
            translateTarget: '',
            alwaysTranslateCodes: [],
            neverTranslateCodes: [],
            neverTranslateSites: [],
            startingUILanguage: '',
            // Only used by ChromeOS
            supportedInputMethods: [],
            currentInputMethodId: '',
        };
        // Wait until prefs are initialized before creating the model, so we can
        // include information about enabled languages.
        promises.push(CrSettingsPrefs.initialized);
        // Get the language list.
        promises.push(this.languageSettingsPrivate_.getLanguageList().then(result => {
            args.supportedLanguages = result;
        }));
        // Get the translate target language.
        promises.push(this.languageSettingsPrivate_.getTranslateTargetLanguage().then(result => {
            args.translateTarget = result;
        }));
        // Get the list of language-codes to always translate.
        promises.push(this.languageSettingsPrivate_.getAlwaysTranslateLanguages().then(result => {
            args.alwaysTranslateCodes = result;
        }));
        // Get the list of language-codes to never translate.
        promises.push(this.languageSettingsPrivate_.getNeverTranslateLanguages().then(result => {
            args.neverTranslateCodes = result;
        }));
        // 
        Promise.all(promises).then(() => {
            if (!this.isConnected) {
                // Return early if this element was detached from the DOM before
                // this async callback executes (can happen during testing).
                return;
            }
            this.createModel_(args);
            // 
            this.resolver_.resolve();
        });
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        instance$g = null;
        this.resolver_ = new PromiseResolver();
        // 
    }
    // 
    /**
     * Updates the list of enabled languages from the preferred languages pref.
     */
    preferredLanguagesPrefChanged_() {
        if (this.prefs === undefined || this.languages === undefined) {
            return;
        }
        const enabledLanguageStates = this.getEnabledLanguageStates_(this.languages.translateTarget, this.languages.prospectiveUILanguage);
        // Recreate the enabled language set before updating languages.enabled.
        this.enabledLanguageSet_.clear();
        for (let i = 0; i < enabledLanguageStates.length; i++) {
            this.enabledLanguageSet_.add(enabledLanguageStates[i].language.code);
        }
        this.set('languages.enabled', enabledLanguageStates);
        // 
        // Update translate target language.
        this.languageSettingsPrivate_.getTranslateTargetLanguage().then(result => {
            this.set('languages.translateTarget', result);
        });
    }
    /**
     * Updates the spellCheckEnabled state of each enabled language.
     */
    spellCheckDictionariesPrefChanged_() {
        if (this.prefs === undefined || this.languages === undefined) {
            return;
        }
        const spellCheckSet = this.makeSetFromArray_(this.getPref('spellcheck.dictionaries').value);
        const spellCheckForcedSet = this.makeSetFromArray_(this.getPref('spellcheck.forced_dictionaries').value);
        const spellCheckBlockedSet = this.makeSetFromArray_(this.getPref('spellcheck.blocked_dictionaries').value);
        for (let i = 0; i < this.languages.enabled.length; i++) {
            const languageState = this.languages.enabled[i];
            const isUser = spellCheckSet.has(languageState.language.code);
            const isForced = spellCheckForcedSet.has(languageState.language.code);
            const isBlocked = spellCheckBlockedSet.has(languageState.language.code);
            this.set(`languages.enabled.${i}.spellCheckEnabled`, (isUser && !isBlocked) || isForced);
            this.set(`languages.enabled.${i}.isManaged`, isForced || isBlocked);
        }
        const { on: spellCheckOnLanguages, off: spellCheckOffLanguages } = this.getSpellCheckLanguages_(this.languages.supported);
        this.set('languages.spellCheckOnLanguages', spellCheckOnLanguages);
        this.set('languages.spellCheckOffLanguages', spellCheckOffLanguages);
    }
    /**
     * Returns two arrays of SpellCheckLanguageStates for spell check languages:
     * one for spell check on, one for spell check off.
     * @param supportedLanguages The list of supported languages, normally
     *     this.languages.supported.
     */
    getSpellCheckLanguages_(supportedLanguages) {
        // The spell check preferences are prioritised in this order:
        // forced_dictionaries, blocked_dictionaries, dictionaries.
        // The set of all language codes seen thus far.
        const seenCodes = new Set();
        /**
         * Gets the list of language codes indicated by the preference name, and
         * de-duplicates it with all other language codes.
         */
        const getPrefAndDedupe = (prefName) => {
            const result = this.getPref(prefName).value.filter(x => !seenCodes.has(x));
            result.forEach((code) => seenCodes.add(code));
            return result;
        };
        const forcedCodes = getPrefAndDedupe('spellcheck.forced_dictionaries');
        const forcedCodesSet = new Set(forcedCodes);
        const blockedCodes = getPrefAndDedupe('spellcheck.blocked_dictionaries');
        const blockedCodesSet = new Set(blockedCodes);
        const enabledCodes = getPrefAndDedupe('spellcheck.dictionaries');
        const on = [];
        // We want to add newly enabled languages to the end of the "on" list, so we
        // should explicitly move the forced languages to the front of the list.
        for (const code of [...forcedCodes, ...enabledCodes]) {
            const language = this.supportedLanguageMap_.get(code);
            // language could be undefined if code is not in supportedLanguageMap_.
            // This should be rare, but could happen if supportedLanguageMap_ is
            // missing languages or the prefs are manually modified. We want to fail
            // gracefully if this happens - throwing an error here would cause
            // language settings to not load.
            if (language) {
                on.push({
                    language,
                    isManaged: forcedCodesSet.has(code),
                    spellCheckEnabled: true,
                    downloadDictionaryStatus: null,
                    downloadDictionaryFailureCount: 0,
                });
            }
        }
        // Because the list of "spell check supported" languages is only exposed
        // through "supported languages", we need to filter that list along with
        // whether we've seen the language before.
        // We don't want to split this list in "forced" / "not-forced" like the
        // spell check on list above, as we don't want to explicitly surface / hide
        // blocked languages to the user.
        const off = [];
        for (const language of supportedLanguages) {
            // If spell check is off for this language, it must either not be in any
            // spell check pref, or be in the blocked dictionaries pref.
            if (language.supportsSpellcheck &&
                (!seenCodes.has(language.code) ||
                    blockedCodesSet.has(language.code))) {
                off.push({
                    language,
                    isManaged: blockedCodesSet.has(language.code),
                    spellCheckEnabled: false,
                    downloadDictionaryStatus: null,
                    downloadDictionaryFailureCount: 0,
                });
            }
        }
        return {
            on,
            off,
        };
    }
    /**
     * Updates the list of always translate languages from translate prefs.
     */
    alwaysTranslateLanguagesPrefChanged_() {
        if (this.prefs === undefined || this.languages === undefined) {
            return;
        }
        const alwaysTranslateCodes = Object.keys(this.getPref('translate_allowlists').value);
        const alwaysTranslateLanguages = alwaysTranslateCodes.map((code) => this.getLanguage(code));
        this.set('languages.alwaysTranslate', alwaysTranslateLanguages);
    }
    /**
     * Updates the list of never translate languages from translate prefs.
     */
    neverTranslateLanguagesPrefChanged_() {
        if (this.prefs === undefined || this.languages === undefined) {
            return;
        }
        const neverTranslateCodes = this.getPref('translate_blocked_languages').value;
        const neverTranslateLanguages = neverTranslateCodes.map(code => this.getLanguage(code));
        this.set('languages.neverTranslate', neverTranslateLanguages);
    }
    /**
     * Updates the list of never translate sites from translate prefs.
     */
    neverTranslateSitesPrefChanged_() {
        if (this.prefs === undefined || this.languages === undefined) {
            return;
        }
        const neverTranslateSites = Object.keys(this.getPref('translate_site_blocklist_with_time').value);
        this.set('languages.neverTranslateSites', neverTranslateSites);
    }
    translateLanguagesPrefChanged_() {
        if (this.prefs === undefined || this.languages === undefined) {
            return;
        }
        const translateBlockedPrefValue = this.getPref('translate_blocked_languages').value;
        const translateBlockedSet = this.makeSetFromArray_(translateBlockedPrefValue);
        for (let i = 0; i < this.languages.enabled.length; i++) {
            const language = this.languages.enabled[i].language;
            const translateEnabled = this.isTranslateEnabled_(language.code, !!language.supportsTranslate, translateBlockedSet, this.languages.translateTarget, this.languages.prospectiveUILanguage);
            this.set('languages.enabled.' + i + '.translateEnabled', translateEnabled);
        }
    }
    translateTargetPrefChanged_() {
        if (this.prefs === undefined || this.languages === undefined) {
            return;
        }
        this.set('languages.translateTarget', this.getPref('translate_recent_target').value);
    }
    /**
     * Constructs the languages model.
     * @param args used to populate the model above.
     */
    createModel_(args) {
        // Populate the hash map of supported languages.
        for (let i = 0; i < args.supportedLanguages.length; i++) {
            const language = args.supportedLanguages[i];
            language.supportsUI = !!language.supportsUI;
            language.supportsTranslate = !!language.supportsTranslate;
            language.supportsSpellcheck = !!language.supportsSpellcheck;
            language.isProhibitedLanguage = !!language.isProhibitedLanguage;
            this.supportedLanguageMap_.set(language.code, language);
        }
        let prospectiveUILanguage;
        // 
        // Create a list of enabled languages from the supported languages.
        const enabledLanguageStates = this.getEnabledLanguageStates_(args.translateTarget, prospectiveUILanguage);
        // Populate the hash set of enabled languages.
        for (let l = 0; l < enabledLanguageStates.length; l++) {
            this.enabledLanguageSet_.add(enabledLanguageStates[l].language.code);
        }
        const { on: spellCheckOnLanguages, off: spellCheckOffLanguages } = this.getSpellCheckLanguages_(args.supportedLanguages);
        const alwaysTranslateLanguages = args.alwaysTranslateCodes.map(code => this.getLanguage(code));
        const neverTranslateLanguages = args.neverTranslateCodes.map(code => this.getLanguage(code));
        const model = {
            supported: args.supportedLanguages,
            enabled: enabledLanguageStates,
            translateTarget: args.translateTarget,
            alwaysTranslate: alwaysTranslateLanguages,
            neverTranslate: neverTranslateLanguages,
            neverTranslateSites: args.neverTranslateSites,
            spellCheckOnLanguages,
            spellCheckOffLanguages,
            // 
        };
        // Initialize the Polymer languages model.
        this.languages = model;
    }
    /**
     * Returns a list of LanguageStates for each enabled language in the supported
     * languages list.
     * @param translateTarget Language code of the default translate
     *     target language.
     * @param prospectiveUILanguage Prospective UI display language. Only defined
     *     on Windows and Chrome OS.
     */
    getEnabledLanguageStates_(translateTarget, prospectiveUILanguage) {
        assert(CrSettingsPrefs.isInitialized);
        const pref = this.getPref('intl.accept_languages');
        const enabledLanguageCodes = pref.value.split(',');
        const languagesForcedPref = this.getPref('intl.forced_languages');
        const spellCheckPref = this.getPref('spellcheck.dictionaries');
        const spellCheckForcedPref = this.getPref('spellcheck.forced_dictionaries');
        const spellCheckBlockedPref = this.getPref('spellcheck.blocked_dictionaries');
        const languageForcedSet = this.makeSetFromArray_(languagesForcedPref.value);
        const spellCheckSet = this.makeSetFromArray_(spellCheckPref.value.concat(spellCheckForcedPref.value));
        const spellCheckForcedSet = this.makeSetFromArray_(spellCheckForcedPref.value);
        const spellCheckBlockedSet = this.makeSetFromArray_(spellCheckBlockedPref.value);
        const translateBlockedPrefValue = this.getPref('translate_blocked_languages').value;
        const translateBlockedSet = this.makeSetFromArray_(translateBlockedPrefValue);
        const enabledLanguageStates = [];
        for (let i = 0; i < enabledLanguageCodes.length; i++) {
            const code = enabledLanguageCodes[i];
            const language = this.supportedLanguageMap_.get(code);
            // Skip unsupported languages.
            if (!language) {
                continue;
            }
            const languageState = {
                language: language,
                spellCheckEnabled: spellCheckSet.has(code) && !spellCheckBlockedSet.has(code) ||
                    spellCheckForcedSet.has(code),
                translateEnabled: this.isTranslateEnabled_(code, !!language.supportsTranslate, translateBlockedSet, translateTarget, prospectiveUILanguage),
                isManaged: spellCheckForcedSet.has(code) || spellCheckBlockedSet.has(code),
                isForced: languageForcedSet.has(code),
                downloadDictionaryFailureCount: 0,
                removable: false,
                downloadDictionaryStatus: null,
            };
            enabledLanguageStates.push(languageState);
        }
        return enabledLanguageStates;
    }
    /**
     * True iff we translate pages that are in the given language.
     * @param code Language code.
     * @param supportsTranslate If translation supports the given language.
     * @param translateBlockedSet Set of languages for which translation is
     *     blocked.
     * @param translateTarget Language code of the default translate target
     *     language.
     * @param prospectiveUILanguage Prospective UI display language. Only define
     *     on Windows and Chrome OS.
     */
    isTranslateEnabled_(code, supportsTranslate, translateBlockedSet, translateTarget, prospectiveUILanguage) {
        const translateCode = convertLanguageCodeForTranslate(code);
        return supportsTranslate && !translateBlockedSet.has(translateCode) &&
            translateCode !== translateTarget &&
            (!prospectiveUILanguage || code !== prospectiveUILanguage);
    }
    // 
    /**
     * Updates the |removable| property of the enabled language states based
     * on what other languages and input methods are enabled.
     */
    updateRemovableLanguages_() {
        if (this.prefs === undefined || this.languages === undefined) {
            return;
        }
        for (let i = 0; i < this.languages.enabled.length; i++) {
            const languageState = this.languages.enabled[i];
            this.set('languages.enabled.' + i + '.removable', this.canDisableLanguage(languageState));
        }
    }
    /**
     * Creates a Set from the elements of the array.
     */
    makeSetFromArray_(list) {
        return new Set(list);
    }
    // LanguageHelper implementation.
    whenReady() {
        return this.resolver_.promise;
    }
    // 
    /**
     * @return True if the language is for ARC IMEs.
     */
    isLanguageCodeForArcIme_(languageCode) {
        return languageCode === kArcImeLanguage;
    }
    /**
     * @return True if the language is enabled.
     */
    isLanguageEnabled(languageCode) {
        return this.enabledLanguageSet_.has(languageCode);
    }
    /**
     * Enables the language, making it available for spell check and input.
     */
    enableLanguage(languageCode) {
        if (!CrSettingsPrefs.isInitialized) {
            return;
        }
        this.languageSettingsPrivate_.enableLanguage(languageCode);
    }
    /**
     * Disables the language.
     */
    disableLanguage(languageCode) {
        if (!CrSettingsPrefs.isInitialized) {
            return;
        }
        // Remove the language from spell check.
        this.deletePrefListItem('spellcheck.dictionaries', languageCode);
        // Remove the language from preferred languages.
        this.languageSettingsPrivate_.disableLanguage(languageCode);
    }
    canDisableLanguage(_languageState) {
        // 
        // Cannot disable the only enabled language.
        if (this.languages.enabled.length === 1) {
            return false;
        }
        return true;
    }
    canEnableLanguage(language) {
        return !((this.isLanguageEnabled(language.code) ||
            language.isProhibitedLanguage ||
            this.isLanguageCodeForArcIme_(language.code)) /* internal use only */);
    }
    /**
     * Sets whether a given language should always be automatically translated.
     */
    setLanguageAlwaysTranslateState(languageCode, alwaysTranslate) {
        this.languageSettingsPrivate_.setLanguageAlwaysTranslateState(languageCode, alwaysTranslate);
    }
    /**
     * Moves the language in the list of enabled languages either up (toward the
     * front of the list) or down (toward the back).
     * @param upDirection True if we need to move up, false if we need to move
     *     down
     */
    moveLanguage(languageCode, upDirection) {
        if (!CrSettingsPrefs.isInitialized) {
            return;
        }
        if (upDirection) {
            this.languageSettingsPrivate_.moveLanguage(languageCode, MoveType.UP);
        }
        else {
            this.languageSettingsPrivate_.moveLanguage(languageCode, MoveType.DOWN);
        }
    }
    /**
     * Moves the language directly to the front of the list of enabled languages.
     */
    moveLanguageToFront(languageCode) {
        if (!CrSettingsPrefs.isInitialized) {
            return;
        }
        this.languageSettingsPrivate_.moveLanguage(languageCode, MoveType.TOP);
    }
    /**
     * Enables translate for the given language by removing the translate
     * language from the blocked languages preference.
     */
    enableTranslateLanguage(languageCode) {
        this.languageSettingsPrivate_.setEnableTranslationForLanguage(languageCode, true);
    }
    /**
     * Disables translate for the given language by adding the translate
     * language to the blocked languages preference.
     */
    disableTranslateLanguage(languageCode) {
        this.languageSettingsPrivate_.setEnableTranslationForLanguage(languageCode, false);
    }
    /**
     * Sets the translate target language.
     */
    setTranslateTargetLanguage(languageCode) {
        this.languageSettingsPrivate_.setTranslateTargetLanguage(languageCode);
    }
    /**
     * Enables or disables spell check for the given language.
     */
    toggleSpellCheck(languageCode, enable) {
        if (!this.languages) {
            return;
        }
        if (enable) {
            this.getPref('spellcheck.dictionaries');
            this.appendPrefListItem('spellcheck.dictionaries', languageCode);
        }
        else {
            this.deletePrefListItem('spellcheck.dictionaries', languageCode);
        }
    }
    getLanguage(languageCode) {
        if (this.supportedLanguageMap_.has(languageCode)) {
            return this.supportedLanguageMap_.get(languageCode);
        }
        // If no languageCode is found, try the base Chrome format.
        const chromeLanguage = convertLanguageCodeForChrome(getBaseLanguage(languageCode));
        return this.supportedLanguageMap_.get(chromeLanguage);
    }
    /**
     * Retries downloading the dictionary for |languageCode|.
     */
    retryDownloadDictionary(languageCode) {
        this.languageSettingsPrivate_.retryDownloadDictionary(languageCode);
    }
}
customElements.define(SettingsLanguagesElement.is, SettingsLanguagesElement);

function getTemplate$w() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared">.cr-row-with-template{padding:0}#liveCaptionToggleButton{width:100%}.language-dropdown{margin-inline-start:auto}.subsection-group{padding-bottom:10px}#liveTranslateToggleButton{width:100%}</style>
<div class="cr-row cr-row-with-template">
  <settings-toggle-button id="liveTranslateToggleButton"
      pref="{{prefs.accessibility.captions.live_translate_enabled}}"
      on-change="onLiveTranslateEnabledChange_"
      label="$i18n{captionsEnableLiveTranslateTitle}"
      sub-label="$i18n{captionsEnableLiveTranslateSubtitle}">
  </settings-toggle-button>
</div>
<cr-collapse
    opened="[[prefs.accessibility.captions.live_translate_enabled.value]]">
  <div class="cr-row continuation subsection-group">
    <div class="start cr-padded-text" aria-hidden="true">
        $i18n{captionsLiveTranslateTargetLanguage}
        <div class="secondary">
          $i18n{captionsLiveTranslateTargetLanguageSubtitle}
        </div>
    </div>
    <settings-dropdown-menu id="targetLanguageDropdown"
        class="language-dropdown"
        pref="{{prefs.accessibility.captions.live_translate_target_language}}"
        menu-options="[[translatableLanguages_]]"
        label="$i18n{captionsLiveTranslateTargetLanguage}">
    </settings-dropdown-menu>
  </div>
</cr-collapse>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-live-translate' is a component for showing Live
 * Translate settings. It appears on the accessibility subpage
 * (chrome://settings/accessibility) on Mac and some versions of Windows and on
 * the captions subpage (chrome://settings/captions) on Linux, ChromeOS, and
 * other versions of Windows.
 */
const SettingsLiveTranslateElementBase = WebUiListenerMixin(PrefsMixin(PolymerElement));
class SettingsLiveTranslateElement extends SettingsLiveTranslateElementBase {
    static get is() {
        return 'settings-live-translate';
    }
    static get template() {
        return getTemplate$w();
    }
    static get properties() {
        return {
            enableLiveTranslateSubtitle_: {
                type: String,
                value: loadTimeData.getString('captionsEnableLiveTranslateSubtitle'),
            },
            languageOptions_: {
                type: Array,
                value: () => [],
            },
            translatableLanguages_: {
                type: Array,
                value: () => [],
            },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        const languageHelper = getLanguageHelperInstance();
        languageHelper.whenReady().then(() => {
            this.translatableLanguages_ =
                languageHelper.languages.supported
                    .filter(language => {
                    return isTranslateBaseLanguage(language);
                })
                    .map(language => {
                    return { value: language.code, name: language.displayName };
                });
        });
    }
    onLiveTranslateEnabledChange_() {
        chrome.metricsPrivate.recordBoolean('Accessibility.LiveTranslate.EnableFromSettings', this.$.liveTranslateToggleButton.checked);
    }
}
customElements.define(SettingsLiveTranslateElement.is, SettingsLiveTranslateElement);

function getTemplate$v() {
    return html `<!--_html_template_start_-->    <style include="settings-shared">#dialog-title{align-items:center;display:flex}#dialog-body{display:flex;flex-direction:column;height:350px;overflow:auto;padding-inline-start:0;padding-inline-end:0}settings-checkbox-list-entry::part(checkbox){padding-inline-start:40px}#dialog-title>span,iron-list{flex:1}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div id="dialog-title" slot="title">
        <span>$i18n{addLanguagesDialogTitle}</span>
        <cr-search-field label="$i18n{searchLanguages}" id="search"
            clear-label="$i18n{clearSearch}"
            on-search-changed="onSearchChanged_"
            on-keydown="onKeydown_" autofocus>
        </cr-search-field>
      </div>
      <div id="dialog-body" slot="body" scrollable>
        <iron-list scroll-target="dialog-body" role="listbox"
            items="[[getLanguages_(filterValue_)]]">
          <template>
            <settings-checkbox-list-entry role="option"
                checked="[[willAdd_(item.code)]]" tabindex="[[tabIndex]]"
                aria-posinset$="[[getAriaPosinset_(index)]]"
                aria-setsize$="[[getLanguagesCount_(filterValue_)]]"
                aria-label="[[i18n('addLanguageAriaLabel', item.displayName)]]"
                on-change="onLanguageCheckboxChange_">
              <div class="text-elide">
                [[getDisplayText_(item)]]
              </div>
            </settings-checkbox-list-entry>
          </template>
        </iron-list>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCancelButtonClick_">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" on-click="onActionButtonClick_"
            disabled="[[disableActionButton_]]">
          $i18n{add}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'settings-add-languages-dialog' is a dialog for enabling
 * languages.
 */
const SettingsAddLanguagesDialogElementBase = ScrollableMixin(FindShortcutMixin(I18nMixin(PolymerElement)));
class SettingsAddLanguagesDialogElement extends SettingsAddLanguagesDialogElementBase {
    static get is() {
        return 'settings-add-languages-dialog';
    }
    static get template() {
        return getTemplate$v();
    }
    static get properties() {
        return {
            languages: Object,
            languagesToAdd_: {
                type: Object,
                value() {
                    return new Set();
                },
            },
            disableActionButton_: {
                type: Boolean,
                value: true,
            },
            filterValue_: {
                type: String,
                value: '',
            },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.$.dialog.showModal();
    }
    // Override FindShortcutMixin methods.
    handleFindShortcut(_modalContextOpen) {
        // Assumes this is the only open modal.
        const searchInput = this.$.search.getSearchInput();
        searchInput.scrollIntoViewIfNeeded();
        if (!this.searchInputHasFocus()) {
            searchInput.focus();
        }
        return true;
    }
    // Override FindShortcutMixin methods.
    searchInputHasFocus() {
        return this.$.search.getSearchInput() ===
            this.$.search.shadowRoot.activeElement;
    }
    onSearchChanged_(e) {
        this.filterValue_ = e.detail;
    }
    /** @return A list of languages to be displayed. */
    getLanguages_() {
        if (!this.filterValue_) {
            return this.languages;
        }
        const filterValue = this.filterValue_.toLowerCase();
        return this.languages.filter(language => {
            return language.displayName.toLowerCase().includes(filterValue) ||
                language.nativeDisplayName.toLowerCase().includes(filterValue);
        });
    }
    /** @return The number of languages to be displayed. */
    getLanguagesCount_() {
        return this.getLanguages_().length;
    }
    /** @return A 1-based index for aria-posinset. */
    getAriaPosinset_(index) {
        return index + 1;
    }
    getDisplayText_(language) {
        return getFullName(language);
    }
    /**
     * @return Whether the user has chosen to add this language (checked its
     *     checkbox).
     */
    willAdd_(languageCode) {
        return this.languagesToAdd_.has(languageCode);
    }
    /** Handler for checking or unchecking a language item. */
    onLanguageCheckboxChange_(e) {
        // Add or remove the item to the Set. No need to worry about data binding:
        // willAdd_ is called to initialize the checkbox state (in case the
        // iron-list re-uses a previous checkbox), and the checkbox can only be
        // changed after that by user action.
        const language = e.model.item;
        if (e.target.checked) {
            this.languagesToAdd_.add(language.code);
        }
        else {
            this.languagesToAdd_.delete(language.code);
        }
        this.disableActionButton_ = !this.languagesToAdd_.size;
    }
    onCancelButtonClick_() {
        this.$.dialog.close();
    }
    /** Enables the checked languages. */
    onActionButtonClick_() {
        this.dispatchEvent(new CustomEvent('languages-added', {
            bubbles: true,
            composed: true,
            detail: Array.from(this.languagesToAdd_),
        }));
        this.$.dialog.close();
    }
    onKeydown_(e) {
        // Close dialog if 'esc' is pressed and the search box is already empty.
        if (e.key === 'Escape' && !this.$.search.getValue().trim()) {
            this.$.dialog.close();
        }
        else if (e.key !== 'PageDown' && e.key !== 'PageUp') {
            this.$.search.scrollIntoViewIfNeeded();
        }
    }
}
customElements.define(SettingsAddLanguagesDialogElement.is, Se