import { CustomElement } from 'chrome://resources/js/custom_element.js';
export declare class SearchBarElement extends CustomElement {
    static get is(): string;
    static get template(): string | TrustedHTML;
    private searchInput_;
    constructor();
    connectedCallback(): void;
    /**
     * Sets the search input's value. This is used to programmatically
     * update the search bar's text, for example when a query is
     * present in the URL on page load.
     */
    setQuery(query: string): void;
    /**
     * Sets focus on the search input element. This is used to maintain focus
     * after a search causes the UI to re-render, preventing the user from
     * having to click the search bar again to continue typing.
     */
    focusInput(): void;
    private onSearchInput;
}
declare global {
    interface HTMLElementTagNameMap {
        'search-bar': SearchBarElement;
    }
}
