// chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { ContentSettingPatternSourceSpec as contentSettings_mojom_ContentSettingPatternSourceSpec, ContentSettingsPatternSpec as contentSettings_mojom_ContentSettingsPatternSpec } from './content_settings.mojom-webui.js';
import { ContentSettingsTypeSpec as contentSettings_mojom_ContentSettingsTypeSpec } from './content_settings_types.mojom-webui.js';
import { ValueSpec as mojoBase_mojom_ValueSpec } from '//resources/mojo/mojo/public/mojom/base/values.mojom-webui.js';
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'privacy_sandbox_internals.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    readPrefsWithPrefixes(prefPrefixes) {
        return this.proxy.sendMessage(0, PageHandler_ReadPrefsWithPrefixes_ParamsSpec.$, PageHandler_ReadPrefsWithPrefixes_ResponseParamsSpec.$, [
            prefPrefixes
        ], false);
    }
    readContentSettings(type) {
        return this.proxy.sendMessage(1, PageHandler_ReadContentSettings_ParamsSpec.$, PageHandler_ReadContentSettings_ResponseParamsSpec.$, [
            type
        ], false);
    }
    getTpcdMetadataGrants() {
        return this.proxy.sendMessage(2, PageHandler_GetTpcdMetadataGrants_ParamsSpec.$, PageHandler_GetTpcdMetadataGrants_ResponseParamsSpec.$, [], false);
    }
    contentSettingsPatternToString(pattern) {
        return this.proxy.sendMessage(3, PageHandler_ContentSettingsPatternToString_ParamsSpec.$, PageHandler_ContentSettingsPatternToString_ResponseParamsSpec.$, [
            pattern
        ], false);
    }
    stringToContentSettingsPattern(s) {
        return this.proxy.sendMessage(4, PageHandler_StringToContentSettingsPattern_ParamsSpec.$, PageHandler_StringToContentSettingsPattern_ResponseParamsSpec.$, [
            s
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_ReadPrefsWithPrefixes_ParamsSpec.$, PageHandler_ReadPrefsWithPrefixes_ResponseParamsSpec.$, impl.readPrefsWithPrefixes.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_ReadContentSettings_ParamsSpec.$, PageHandler_ReadContentSettings_ResponseParamsSpec.$, impl.readContentSettings.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_GetTpcdMetadataGrants_ParamsSpec.$, PageHandler_GetTpcdMetadataGrants_ResponseParamsSpec.$, impl.getTpcdMetadataGrants.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_ContentSettingsPatternToString_ParamsSpec.$, PageHandler_ContentSettingsPatternToString_ResponseParamsSpec.$, impl.contentSettingsPatternToString.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_StringToContentSettingsPattern_ParamsSpec.$, PageHandler_StringToContentSettingsPattern_ResponseParamsSpec.$, impl.stringToContentSettingsPattern.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "privacy_sandbox_internals.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    readPrefsWithPrefixes;
    readContentSettings;
    getTpcdMetadataGrants;
    contentSettingsPatternToString;
    stringToContentSettingsPattern;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.readPrefsWithPrefixes =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_ReadPrefsWithPrefixes_ParamsSpec.$, PageHandler_ReadPrefsWithPrefixes_ResponseParamsSpec.$, this.readPrefsWithPrefixes.createReceiverHandler(true /* expectsResponse */), false);
        this.readContentSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_ReadContentSettings_ParamsSpec.$, PageHandler_ReadContentSettings_ResponseParamsSpec.$, this.readContentSettings.createReceiverHandler(true /* expectsResponse */), false);
        this.getTpcdMetadataGrants =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_GetTpcdMetadataGrants_ParamsSpec.$, PageHandler_GetTpcdMetadataGrants_ResponseParamsSpec.$, this.getTpcdMetadataGrants.createReceiverHandler(true /* expectsResponse */), false);
        this.contentSettingsPatternToString =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_ContentSettingsPatternToString_ParamsSpec.$, PageHandler_ContentSettingsPatternToString_ResponseParamsSpec.$, this.contentSettingsPatternToString.createReceiverHandler(true /* expectsResponse */), false);
        this.stringToContentSettingsPattern =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_StringToContentSettingsPattern_ParamsSpec.$, PageHandler_StringToContentSettingsPattern_ResponseParamsSpec.$, this.stringToContentSettingsPattern.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'privacy_sandbox_internals.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(_impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "privacy_sandbox_internals.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PrivacySandboxInternalsPrefSpec = { $: {} };
export const PageHandler_ReadPrefsWithPrefixes_ParamsSpec = { $: {} };
export const PageHandler_ReadPrefsWithPrefixes_ResponseParamsSpec = { $: {} };
export const PageHandler_ReadContentSettings_ParamsSpec = { $: {} };
export const PageHandler_ReadContentSettings_ResponseParamsSpec = { $: {} };
export const PageHandler_GetTpcdMetadataGrants_ParamsSpec = { $: {} };
export const PageHandler_GetTpcdMetadataGrants_ResponseParamsSpec = { $: {} };
export const PageHandler_ContentSettingsPatternToString_ParamsSpec = { $: {} };
export const PageHandler_ContentSettingsPatternToString_ResponseParamsSpec = { $: {} };
export const PageHandler_StringToContentSettingsPattern_ParamsSpec = { $: {} };
export const PageHandler_StringToContentSettingsPattern_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(PrivacySandboxInternalsPrefSpec.$, 'PrivacySandboxInternalsPref', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 8, 0, mojoBase_mojom_ValueSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandler_ReadPrefsWithPrefixes_ParamsSpec.$, 'PageHandler_ReadPrefsWithPrefixes_Params', [
    mojo.internal.StructField('prefPrefixes', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ReadPrefsWithPrefixes_ResponseParamsSpec.$, 'PageHandler_ReadPrefsWithPrefixes_ResponseParams', [
    mojo.internal.StructField('prefs', 0, 0, mojo.internal.Array(PrivacySandboxInternalsPrefSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ReadContentSettings_ParamsSpec.$, 'PageHandler_ReadContentSettings_Params', [
    mojo.internal.StructField('type', 0, 0, contentSettings_mojom_ContentSettingsTypeSpec.$, -1, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ReadContentSettings_ResponseParamsSpec.$, 'PageHandler_ReadContentSettings_ResponseParams', [
    mojo.internal.StructField('contentSettings', 0, 0, mojo.internal.Array(contentSettings_mojom_ContentSettingPatternSourceSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetTpcdMetadataGrants_ParamsSpec.$, 'PageHandler_GetTpcdMetadataGrants_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetTpcdMetadataGrants_ResponseParamsSpec.$, 'PageHandler_GetTpcdMetadataGrants_ResponseParams', [
    mojo.internal.StructField('contentSettings', 0, 0, mojo.internal.Array(contentSettings_mojom_ContentSettingPatternSourceSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ContentSettingsPatternToString_ParamsSpec.$, 'PageHandler_ContentSettingsPatternToString_Params', [
    mojo.internal.StructField('pattern', 0, 0, contentSettings_mojom_ContentSettingsPatternSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ContentSettingsPatternToString_ResponseParamsSpec.$, 'PageHandler_ContentSettingsPatternToString_ResponseParams', [
    mojo.internal.StructField('s', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_StringToContentSettingsPattern_ParamsSpec.$, 'PageHandler_StringToContentSettingsPattern_Params', [
    mojo.internal.StructField('s', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_StringToContentSettingsPattern_ResponseParamsSpec.$, 'PageHandler_StringToContentSettingsPattern_ResponseParams', [
    mojo.internal.StructField('pattern', 0, 0, contentSettings_mojom_ContentSettingsPatternSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
