import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export declare const SiteTypeSpec: {
    $: mojo.internal.MojomType;
};
export declare enum SiteType {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kPrimary = 0,
    kAssociated = 1,
    kService = 2
}
export type RelatedWebsiteSetsPageHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<RelatedWebsiteSetsPageHandlerPendingReceiver>;
export declare class RelatedWebsiteSetsPageHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<RelatedWebsiteSetsPageHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<RelatedWebsiteSetsPageHandlerPendingReceiver>;
    constructor(handle: MojoHandle | RelatedWebsiteSetsPageHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface RelatedWebsiteSetsPageHandlerInterface {
    getRelatedWebsiteSets(): Promise<{
        relatedWebsiteSetsInfo: GetRelatedWebsiteSetsResponse;
    }>;
}
export declare class RelatedWebsiteSetsPageHandlerRemote implements RelatedWebsiteSetsPageHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<RelatedWebsiteSetsPageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | RelatedWebsiteSetsPageHandlerPendingReceiverEndpoint);
    getRelatedWebsiteSets(): Promise<{
        relatedWebsiteSetsInfo: GetRelatedWebsiteSetsResponse;
    }>;
}
/**
 * An object which receives request messages for the RelatedWebsiteSetsPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class RelatedWebsiteSetsPageHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<RelatedWebsiteSetsPageHandlerRemote, RelatedWebsiteSetsPageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: RelatedWebsiteSetsPageHandlerInterface);
}
export declare class RelatedWebsiteSetsPageHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): RelatedWebsiteSetsPageHandlerRemote;
}
/**
 * An object which receives request messages for the RelatedWebsiteSetsPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class RelatedWebsiteSetsPageHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<RelatedWebsiteSetsPageHandlerRemote, RelatedWebsiteSetsPageHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    getRelatedWebsiteSets: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const MemberSpec: {
    $: mojo.internal.MojomType;
};
export declare const RelatedWebsiteSetSpec: {
    $: mojo.internal.MojomType;
};
export declare const RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const GetRelatedWebsiteSetsResponseSpec: {
    $: mojo.internal.MojomType;
};
export interface MemberMojoType {
    site: string;
    type: SiteType;
}
export type Member = MemberMojoType;
export interface RelatedWebsiteSetMojoType {
    primarySite: string;
    memberSites: Member[];
    managedByEnterprise: boolean;
}
export type RelatedWebsiteSet = RelatedWebsiteSetMojoType;
export interface RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ParamsMojoType {
}
export type RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_Params = RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ParamsMojoType;
export interface RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParamsMojoType {
    relatedWebsiteSetsInfo: GetRelatedWebsiteSetsResponse;
}
export type RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParams = RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParamsMojoType;
export interface GetRelatedWebsiteSetsResponse {
    relatedWebsiteSets?: RelatedWebsiteSet[];
    errorMessage?: string;
}
export declare enum GetRelatedWebsiteSetsResponseFieldTags {
    RELATED_WEBSITE_SETS = 0,
    ERROR_MESSAGE = 1
}
export declare function whichGetRelatedWebsiteSetsResponse(u: GetRelatedWebsiteSetsResponse): GetRelatedWebsiteSetsResponseFieldTags;
