import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="shared-style cr-input-style cr-shared-style
                credential-details-card cr-icons">#passkeyIcon{margin:auto 2px auto 0}#infoLabelContent{margin-top:auto;margin-bottom:auto}</style>
<div class="card" aria-label="[[getAriaLabelForPasswordCard_(passkey)]]"
    role="region">
  <div class="credential-container">
    <div class="row-container">
      <div class="column-container">
        <credential-field value="[[getDisplayNameValue_(passkey)]]"
            id="displayNameValue" label="$i18n{displayNameLabel}"
            copy-button-label="$i18n{copyDisplayName}"
            value-copied-toast-label="$i18n{displayNameCopiedToClipboard}"
            interaction-id="[[
                interactionsEnum_.PASSKEY_DISPLAY_NAME_COPY_BUTTON_CLICKED]]">
        </credential-field>
      </div>
      <div class="column-container">
        <div id="domainLabel" class="cr-form-field-label">
          $i18n{sitesLabel}
        </div>
        <template id="links" is="dom-repeat"
            items="[[passkey.affiliatedDomains]]">
          <div class="elide-left">
            <a href="[[item.url]]" class="site-link" target="_blank">
              [[item.name]]
            </a>
          </div>
        </template>
      </div>
    </div>
    <div class="row-container">
      <div class="column-container">
        <credential-field value="[[getUsernameValue_(passkey)]]"
            id="usernameValue" label="$i18n{usernameLabel}"
            copy-button-label="$i18n{copyUsername}"
            value-copied-toast-label="$i18n{usernameCopiedToClipboard}"
            interaction-id="[[interactionsEnum_.USERNAME_COPY_BUTTON_CLICKED]]">
        </credential-field>
      </div>
    </div>
    <div class="row-container">
      <cr-icon icon="passwords-icon:passkey" id="passkeyIcon"></cr-icon>
      <div id="infoLabelContent" class="cr-secondary-text"
          inner-h-t-m-l="[[getInfoLabelText_(passkey)]]">
      </div>
    </div>
  </div>
  <div class="button-container">
    <cr-button id="editButton" class="edit-button" on-click="onEditClicked_"
        aria-label="[[getAriaLabelForEditButton_(passkey)]]"
        disabled="[[passkey.hidden]]">
      $i18n{edit}
    </cr-button>
    <cr-button id="deleteButton" on-click="onDeleteClick_"
        aria-label="[[getAriaLabelForDeleteButton_(passkey)]]">
      $i18n{delete}
    </cr-button>
  </div>
</div>
<template is="dom-if" if="[[showEditPasskeyDialog_]]" restamp
          id="editPasskeyTemplate">
  <edit-passkey-dialog on-close="onEditPasskeyDialogClosed_"
      id="editPasskeyDialog" passkey="{{passkey}}">
  </edit-passkey-dialog>
</template>
<template is="dom-if" if="[[showDeletePasskeyDialog_]]" restamp
          id="deletePasskeyTemplate">
  <delete-passkey-dialog on-close="onDeletePasskeyDialogClosed_"
      id="deletePasskeyDialog" passkey="{{passkey}}">
  </delete-passkey-dialog>
</template>
<!--_html_template_end_-->`;
}