// services/on_device_model/public/mojom/on_device_model_service.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  LoadModelResultSpec as onDeviceModel_mojom_LoadModelResultSpec,
  LoadModelResult as onDeviceModel_mojom_LoadModelResult,
  PerformanceClassSpec as onDeviceModel_mojom_PerformanceClassSpec,
  PerformanceClass as onDeviceModel_mojom_PerformanceClass,
  OnDeviceModelPendingReceiver as onDeviceModel_mojom_OnDeviceModelPendingReceiver,
  TextSafetyModelPendingReceiver as onDeviceModel_mojom_TextSafetyModelPendingReceiver,
  CapabilitiesSpec as onDeviceModel_mojom_CapabilitiesSpec,
  Capabilities as onDeviceModel_mojom_Capabilities,
  DeviceInfoSpec as onDeviceModel_mojom_DeviceInfoSpec,
  DeviceInfo as onDeviceModel_mojom_DeviceInfo,
  DevicePerformanceInfoSpec as onDeviceModel_mojom_DevicePerformanceInfoSpec,
  DevicePerformanceInfo as onDeviceModel_mojom_DevicePerformanceInfo,
  SafetyInfoSpec as onDeviceModel_mojom_SafetyInfoSpec,
  SafetyInfo as onDeviceModel_mojom_SafetyInfo
} from './on_device_model.mojom-webui.js';
import {
  FileSpec as mojoBase_mojom_FileSpec,
  File as mojoBase_mojom_File,
  ReadOnlyFileSpec as mojoBase_mojom_ReadOnlyFileSpec,
  ReadOnlyFile as mojoBase_mojom_ReadOnlyFile
} from '//resources/mojo/mojo/public/mojom/base/file.mojom-webui.js';
import {
  FilePathSpec as mojoBase_mojom_FilePathSpec,
  FilePath as mojoBase_mojom_FilePath
} from '//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js';
import {
  UuidSpec as mojoBase_mojom_UuidSpec,
  Uuid as mojoBase_mojom_Uuid
} from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';





export const ModelBackendTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ModelBackendType {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kGpu = 0,
  kApu = 1,
  kCpu = 2,
}

export const ModelPerformanceHintSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ModelPerformanceHint {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kHighestQuality = 0,
  kFastestInference = 1,
}

export const PlatformModelStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum PlatformModelState {

  MIN_VALUE = 0,
  MAX_VALUE = 9,
  kUnknownState = 0,
  kInstalledOnDisk = 1,
  kInvalidUuid = 2,
  kInvalidDlcClient = 3,
  kInvalidDlcPackage = 4,
  kInvalidDlcVerifiedState = 5,
  kInvalidDlcInstall = 6,
  kInvalidModelFormat = 7,
  kInvalidModelDescriptor = 8,
  kInvalidBaseModelDescriptor = 9,
}

export const FormatFeatureSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum FormatFeature {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kNone = 0,
  kPrompt = 1,
  kAudioSummary = 2,
  kAudioTitle = 3,
}

export const SafetyFeatureSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SafetyFeature {

  MIN_VALUE = 0,
  MAX_VALUE = 6,
  kGeneral = 0,
  kAudioSummaryRequest = 1,
  kAudioTitleRequest = 2,
  kAudioSummaryResponse = 3,
  kAudioTitleResponse = 4,
  kAudioSummaryResponseV2 = 5,
  kAudioTitleResponseV2 = 6,
}



export type PlatformModelProgressObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PlatformModelProgressObserverPendingReceiver>;

export class PlatformModelProgressObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PlatformModelProgressObserver> {

  handle: mojo.internal.interfaceSupport.Endpoint<PlatformModelProgressObserverPendingReceiver>;
  constructor(handle: MojoHandle|PlatformModelProgressObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_model.mojom.PlatformModelProgressObserver',
        scope);
  }
}

export interface PlatformModelProgressObserverInterface {
  progress(progress: number): void;
}

export class PlatformModelProgressObserverRemote implements PlatformModelProgressObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PlatformModelProgressObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PlatformModelProgressObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PlatformModelProgressObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PlatformModelProgressObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  progress(
      progress: number): void {
    this.proxy.sendMessage(
        0,
        PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        [
          progress
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PlatformModelProgressObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PlatformModelProgressObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PlatformModelProgressObserverRemote, PlatformModelProgressObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PlatformModelProgressObserverRemote, PlatformModelProgressObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PlatformModelProgressObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PlatformModelProgressObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        impl.progress.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PlatformModelProgressObserver {
  static get $interfaceName(): string {
    return "on_device_model.mojom.PlatformModelProgressObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PlatformModelProgressObserverRemote {
    let remote = new PlatformModelProgressObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PlatformModelProgressObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PlatformModelProgressObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PlatformModelProgressObserverRemote, PlatformModelProgressObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PlatformModelProgressObserverRemote, PlatformModelProgressObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  progress: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PlatformModelProgressObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.progress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        this.progress.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type OnDeviceModelServicePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<OnDeviceModelServicePendingReceiver>;

export class OnDeviceModelServicePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<OnDeviceModelService> {

  handle: mojo.internal.interfaceSupport.Endpoint<OnDeviceModelServicePendingReceiver>;
  constructor(handle: MojoHandle|OnDeviceModelServicePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_model.mojom.OnDeviceModelService',
        scope);
  }
}

export interface OnDeviceModelServiceInterface {
  loadModel(params: LoadModelParams, model: onDeviceModel_mojom_OnDeviceModelPendingReceiver): Promise<{
        result: onDeviceModel_mojom_LoadModelResult, }>;
  getCapabilities(weights: ModelFile): Promise<{
        capabilities: onDeviceModel_mojom_Capabilities, }>;
  loadTextSafetyModel(params: TextSafetyModelParams, model: onDeviceModel_mojom_TextSafetyModelPendingReceiver): void;
  getDeviceAndPerformanceInfo(): Promise<{
        performanceInfo: onDeviceModel_mojom_DevicePerformanceInfo,
        deviceInfo: onDeviceModel_mojom_DeviceInfo, }>;
}

export class OnDeviceModelServiceRemote implements OnDeviceModelServiceInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<OnDeviceModelServicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<OnDeviceModelServicePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|OnDeviceModelServicePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OnDeviceModelServicePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  loadModel(
      params: LoadModelParams,
      model: onDeviceModel_mojom_OnDeviceModelPendingReceiver): Promise<{
        result: onDeviceModel_mojom_LoadModelResult, }> {
    return this.proxy.sendMessage(
        0,
        OnDeviceModelService_LoadModel_ParamsSpec.$,
        OnDeviceModelService_LoadModel_ResponseParamsSpec.$,
        [
          params,
          model
        ],
        false);
  }

  getCapabilities(
      weights: ModelFile): Promise<{
        capabilities: onDeviceModel_mojom_Capabilities, }> {
    return this.proxy.sendMessage(
        1,
        OnDeviceModelService_GetCapabilities_ParamsSpec.$,
        OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,
        [
          weights
        ],
        false);
  }

  loadTextSafetyModel(
      params: TextSafetyModelParams,
      model: onDeviceModel_mojom_TextSafetyModelPendingReceiver): void {
    this.proxy.sendMessage(
        2,
        OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,
        null,
        [
          params,
          model
        ],
        false);
  }

  getDeviceAndPerformanceInfo(): Promise<{
        performanceInfo: onDeviceModel_mojom_DevicePerformanceInfo,
        deviceInfo: onDeviceModel_mojom_DeviceInfo, }> {
    return this.proxy.sendMessage(
        3,
        OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,
        OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the OnDeviceModelService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OnDeviceModelServiceReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    OnDeviceModelServiceRemote, OnDeviceModelServicePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    OnDeviceModelServiceRemote, OnDeviceModelServicePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: OnDeviceModelServiceInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OnDeviceModelServiceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OnDeviceModelService_LoadModel_ParamsSpec.$,
        OnDeviceModelService_LoadModel_ResponseParamsSpec.$,
        impl.loadModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        OnDeviceModelService_GetCapabilities_ParamsSpec.$,
        OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,
        impl.getCapabilities.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,
        null,
        impl.loadTextSafetyModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,
        OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
        impl.getDeviceAndPerformanceInfo.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OnDeviceModelService {
  static get $interfaceName(): string {
    return "on_device_model.mojom.OnDeviceModelService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): OnDeviceModelServiceRemote {
    let remote = new OnDeviceModelServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the OnDeviceModelService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OnDeviceModelServiceCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    OnDeviceModelServiceRemote, OnDeviceModelServicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    OnDeviceModelServiceRemote, OnDeviceModelServicePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  loadModel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getCapabilities: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  loadTextSafetyModel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getDeviceAndPerformanceInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OnDeviceModelServiceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.loadModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OnDeviceModelService_LoadModel_ParamsSpec.$,
        OnDeviceModelService_LoadModel_ResponseParamsSpec.$,
        this.loadModel.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getCapabilities =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        OnDeviceModelService_GetCapabilities_ParamsSpec.$,
        OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,
        this.getCapabilities.createReceiverHandler(true /* expectsResponse */),
        false);
    this.loadTextSafetyModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,
        null,
        this.loadTextSafetyModel.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getDeviceAndPerformanceInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,
        OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
        this.getDeviceAndPerformanceInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type OnDeviceModelPlatformServicePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<OnDeviceModelPlatformServicePendingReceiver>;

export class OnDeviceModelPlatformServicePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<OnDeviceModelPlatformService> {

  handle: mojo.internal.interfaceSupport.Endpoint<OnDeviceModelPlatformServicePendingReceiver>;
  constructor(handle: MojoHandle|OnDeviceModelPlatformServicePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_model.mojom.OnDeviceModelPlatformService',
        scope);
  }
}

export interface OnDeviceModelPlatformServiceInterface {
  loadPlatformModel(uuid: mojoBase_mojom_Uuid, model: onDeviceModel_mojom_OnDeviceModelPendingReceiver, progressObserver: (PlatformModelProgressObserverRemote | null)): Promise<{
        result: onDeviceModel_mojom_LoadModelResult, }>;
  getPlatformModelState(uuid: mojoBase_mojom_Uuid): Promise<{
        result: PlatformModelState, }>;
  getEstimatedPerformanceClass(): Promise<{
        performanceClass: onDeviceModel_mojom_PerformanceClass, }>;
  formatInput(uuid: mojoBase_mojom_Uuid, feature: FormatFeature, fields: {[key: string]: string}): Promise<{
        result: (string | null), }>;
  validateSafetyResult(safetyFeature: SafetyFeature, text: string, safetyInfo: onDeviceModel_mojom_SafetyInfo): Promise<{
        result: boolean, }>;
}

export class OnDeviceModelPlatformServiceRemote implements OnDeviceModelPlatformServiceInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<OnDeviceModelPlatformServicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<OnDeviceModelPlatformServicePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|OnDeviceModelPlatformServicePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OnDeviceModelPlatformServicePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  loadPlatformModel(
      uuid: mojoBase_mojom_Uuid,
      model: onDeviceModel_mojom_OnDeviceModelPendingReceiver,
      progressObserver: (PlatformModelProgressObserverRemote | null)): Promise<{
        result: onDeviceModel_mojom_LoadModelResult, }> {
    return this.proxy.sendMessage(
        0,
        OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,
        OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,
        [
          uuid,
          model,
          progressObserver
        ],
        false);
  }

  getPlatformModelState(
      uuid: mojoBase_mojom_Uuid): Promise<{
        result: PlatformModelState, }> {
    return this.proxy.sendMessage(
        1,
        OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,
        OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,
        [
          uuid
        ],
        false);
  }

  getEstimatedPerformanceClass(): Promise<{
        performanceClass: onDeviceModel_mojom_PerformanceClass, }> {
    return this.proxy.sendMessage(
        2,
        OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,
        OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  formatInput(
      uuid: mojoBase_mojom_Uuid,
      feature: FormatFeature,
      fields: {[key: string]: string}): Promise<{
        result: (string | null), }> {
    return this.proxy.sendMessage(
        3,
        OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,
        OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,
        [
          uuid,
          feature,
          fields
        ],
        false);
  }

  validateSafetyResult(
      safetyFeature: SafetyFeature,
      text: string,
      safetyInfo: onDeviceModel_mojom_SafetyInfo): Promise<{
        result: boolean, }> {
    return this.proxy.sendMessage(
        4,
        OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,
        OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,
        [
          safetyFeature,
          text,
          safetyInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the OnDeviceModelPlatformService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OnDeviceModelPlatformServiceReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    OnDeviceModelPlatformServiceRemote, OnDeviceModelPlatformServicePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    OnDeviceModelPlatformServiceRemote, OnDeviceModelPlatformServicePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: OnDeviceModelPlatformServiceInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OnDeviceModelPlatformServiceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,
        OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,
        impl.loadPlatformModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,
        OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,
        impl.getPlatformModelState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,
        OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,
        impl.getEstimatedPerformanceClass.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,
        OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,
        impl.formatInput.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,
        OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,
        impl.validateSafetyResult.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OnDeviceModelPlatformService {
  static get $interfaceName(): string {
    return "on_device_model.mojom.OnDeviceModelPlatformService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): OnDeviceModelPlatformServiceRemote {
    let remote = new OnDeviceModelPlatformServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the OnDeviceModelPlatformService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OnDeviceModelPlatformServiceCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    OnDeviceModelPlatformServiceRemote, OnDeviceModelPlatformServicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    OnDeviceModelPlatformServiceRemote, OnDeviceModelPlatformServicePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  loadPlatformModel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getPlatformModelState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getEstimatedPerformanceClass: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  formatInput: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  validateSafetyResult: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OnDeviceModelPlatformServiceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.loadPlatformModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,
        OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,
        this.loadPlatformModel.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getPlatformModelState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,
        OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,
        this.getPlatformModelState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getEstimatedPerformanceClass =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,
        OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,
        this.getEstimatedPerformanceClass.createReceiverHandler(true /* expectsResponse */),
        false);
    this.formatInput =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,
        OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,
        this.formatInput.createReceiverHandler(true /* expectsResponse */),
        false);
    this.validateSafetyResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,
        OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,
        this.validateSafetyResult.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ModelAssetsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LoadModelParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TextSafetyModelAssetsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BertSafetyModelAssetsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LanguageModelAssetsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TextSafetyModelParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PlatformModelProgressObserver_Progress_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelService_LoadModel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelService_LoadModel_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelService_GetCapabilities_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelService_GetCapabilities_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelService_LoadTextSafetyModel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelPlatformService_FormatInput_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ModelFileSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SafetyModelAssetsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ModelAssetsMojoType {
  weights: ModelFile;
  spModelPath: (mojoBase_mojom_FilePath | null);
  cache: (mojoBase_mojom_File | null);
  encoderCache: (mojoBase_mojom_File | null);
  adapterCache: (mojoBase_mojom_File | null);
}


export type ModelAssets = ModelAssetsMojoType;
mojo.internal.Struct<ModelAssetsMojoType>(
    ModelAssetsSpec.$,
    'ModelAssets',
    [
      mojo.internal.StructField<ModelAssetsMojoType, ModelFile>(
        'weights', 0,
        0,
        ModelFileSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ModelAssetsMojoType, mojoBase_mojom_FilePath>(
        'spModelPath', 16,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ModelAssetsMojoType, mojoBase_mojom_File>(
        'cache', 24,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ModelAssetsMojoType, mojoBase_mojom_File>(
        'encoderCache', 32,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ModelAssetsMojoType, mojoBase_mojom_File>(
        'adapterCache', 40,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface LoadModelParamsMojoType {
  backendType: ModelBackendType;
  maxTokens: number;
  assets: ModelAssets;
  adaptationRanks: number[];
  performanceHint: ModelPerformanceHint;
}


export type LoadModelParams = LoadModelParamsMojoType;
mojo.internal.Struct<LoadModelParamsMojoType>(
    LoadModelParamsSpec.$,
    'LoadModelParams',
    [
      mojo.internal.StructField<LoadModelParamsMojoType, ModelBackendType>(
        'backendType', 0,
        0,
        ModelBackendTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LoadModelParamsMojoType, ModelAssets>(
        'assets', 8,
        0,
        ModelAssetsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LoadModelParamsMojoType, number>(
        'maxTokens', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LoadModelParamsMojoType, number[]>(
        'adaptationRanks', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LoadModelParamsMojoType, ModelPerformanceHint>(
        'performanceHint', 24,
        0,
        ModelPerformanceHintSpec.$,
        ModelPerformanceHint.kHighestQuality,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface TextSafetyModelAssetsMojoType {
  data: mojoBase_mojom_ReadOnlyFile;
  spModel: mojoBase_mojom_ReadOnlyFile;
}


export type TextSafetyModelAssets = TextSafetyModelAssetsMojoType;
mojo.internal.Struct<TextSafetyModelAssetsMojoType>(
    TextSafetyModelAssetsSpec.$,
    'TextSafetyModelAssets',
    [
      mojo.internal.StructField<TextSafetyModelAssetsMojoType, mojoBase_mojom_ReadOnlyFile>(
        'data', 0,
        0,
        mojoBase_mojom_ReadOnlyFileSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TextSafetyModelAssetsMojoType, mojoBase_mojom_ReadOnlyFile>(
        'spModel', 8,
        0,
        mojoBase_mojom_ReadOnlyFileSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BertSafetyModelAssetsMojoType {
  model: mojoBase_mojom_ReadOnlyFile;
}


export type BertSafetyModelAssets = BertSafetyModelAssetsMojoType;
mojo.internal.Struct<BertSafetyModelAssetsMojoType>(
    BertSafetyModelAssetsSpec.$,
    'BertSafetyModelAssets',
    [
      mojo.internal.StructField<BertSafetyModelAssetsMojoType, mojoBase_mojom_ReadOnlyFile>(
        'model', 0,
        0,
        mojoBase_mojom_ReadOnlyFileSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LanguageModelAssetsMojoType {
  model: mojoBase_mojom_ReadOnlyFile;
}


export type LanguageModelAssets = LanguageModelAssetsMojoType;
mojo.internal.Struct<LanguageModelAssetsMojoType>(
    LanguageModelAssetsSpec.$,
    'LanguageModelAssets',
    [
      mojo.internal.StructField<LanguageModelAssetsMojoType, mojoBase_mojom_ReadOnlyFile>(
        'model', 0,
        0,
        mojoBase_mojom_ReadOnlyFileSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TextSafetyModelParamsMojoType {
  safetyAssets: (SafetyModelAssets | null);
  languageAssets: (LanguageModelAssets | null);
}


export type TextSafetyModelParams = TextSafetyModelParamsMojoType;
mojo.internal.Struct<TextSafetyModelParamsMojoType>(
    TextSafetyModelParamsSpec.$,
    'TextSafetyModelParams',
    [
      mojo.internal.StructField<TextSafetyModelParamsMojoType, SafetyModelAssets>(
        'safetyAssets', 0,
        0,
        SafetyModelAssetsSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TextSafetyModelParamsMojoType, LanguageModelAssets>(
        'languageAssets', 16,
        0,
        LanguageModelAssetsSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PlatformModelProgressObserver_Progress_ParamsMojoType {
  progress: number;
}


export type PlatformModelProgressObserver_Progress_Params = PlatformModelProgressObserver_Progress_ParamsMojoType;
mojo.internal.Struct<PlatformModelProgressObserver_Progress_ParamsMojoType>(
    PlatformModelProgressObserver_Progress_ParamsSpec.$,
    'PlatformModelProgressObserver_Progress_Params',
    [
      mojo.internal.StructField<PlatformModelProgressObserver_Progress_ParamsMojoType, number>(
        'progress', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OnDeviceModelService_LoadModel_ParamsMojoType {
  params: LoadModelParams;
  model: onDeviceModel_mojom_OnDeviceModelPendingReceiver;
}


export type OnDeviceModelService_LoadModel_Params = OnDeviceModelService_LoadModel_ParamsMojoType;
mojo.internal.Struct<OnDeviceModelService_LoadModel_ParamsMojoType>(
    OnDeviceModelService_LoadModel_ParamsSpec.$,
    'OnDeviceModelService_LoadModel_Params',
    [
      mojo.internal.StructField<OnDeviceModelService_LoadModel_ParamsMojoType, LoadModelParams>(
        'params', 0,
        0,
        LoadModelParamsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OnDeviceModelService_LoadModel_ParamsMojoType, onDeviceModel_mojom_OnDeviceModelPendingReceiver>(
        'model', 8,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel_mojom_OnDeviceModelPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface OnDeviceModelService_LoadModel_ResponseParamsMojoType {
  result: onDeviceModel_mojom_LoadModelResult;
}


export type OnDeviceModelService_LoadModel_ResponseParams = OnDeviceModelService_LoadModel_ResponseParamsMojoType;
mojo.internal.Struct<OnDeviceModelService_LoadModel_ResponseParamsMojoType>(
    OnDeviceModelService_LoadModel_ResponseParamsSpec.$,
    'OnDeviceModelService_LoadModel_ResponseParams',
    [
      mojo.internal.StructField<OnDeviceModelService_LoadModel_ResponseParamsMojoType, onDeviceModel_mojom_LoadModelResult>(
        'result', 0,
        0,
        onDeviceModel_mojom_LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OnDeviceModelService_GetCapabilities_ParamsMojoType {
  weights: ModelFile;
}


export type OnDeviceModelService_GetCapabilities_Params = OnDeviceModelService_GetCapabilities_ParamsMojoType;
mojo.internal.Struct<OnDeviceModelService_GetCapabilities_ParamsMojoType>(
    OnDeviceModelService_GetCapabilities_ParamsSpec.$,
    'OnDeviceModelService_GetCapabilities_Params',
    [
      mojo.internal.StructField<OnDeviceModelService_GetCapabilities_ParamsMojoType, ModelFile>(
        'weights', 0,
        0,
        ModelFileSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface OnDeviceModelService_GetCapabilities_ResponseParamsMojoType {
  capabilities: onDeviceModel_mojom_Capabilities;
}


export type OnDeviceModelService_GetCapabilities_ResponseParams = OnDeviceModelService_GetCapabilities_ResponseParamsMojoType;
mojo.internal.Struct<OnDeviceModelService_GetCapabilities_ResponseParamsMojoType>(
    OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,
    'OnDeviceModelService_GetCapabilities_ResponseParams',
    [
      mojo.internal.StructField<OnDeviceModelService_GetCapabilities_ResponseParamsMojoType, onDeviceModel_mojom_Capabilities>(
        'capabilities', 0,
        0,
        onDeviceModel_mojom_CapabilitiesSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OnDeviceModelService_LoadTextSafetyModel_ParamsMojoType {
  params: TextSafetyModelParams;
  model: onDeviceModel_mojom_TextSafetyModelPendingReceiver;
}


export type OnDeviceModelService_LoadTextSafetyModel_Params = OnDeviceModelService_LoadTextSafetyModel_ParamsMojoType;
mojo.internal.Struct<OnDeviceModelService_LoadTextSafetyModel_ParamsMojoType>(
    OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,
    'OnDeviceModelService_LoadTextSafetyModel_Params',
    [
      mojo.internal.StructField<OnDeviceModelService_LoadTextSafetyModel_ParamsMojoType, TextSafetyModelParams>(
        'params', 0,
        0,
        TextSafetyModelParamsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OnDeviceModelService_LoadTextSafetyModel_ParamsMojoType, onDeviceModel_mojom_TextSafetyModelPendingReceiver>(
        'model', 8,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel_mojom_TextSafetyModelPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsMojoType {
}


export type OnDeviceModelService_GetDeviceAndPerformanceInfo_Params = OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsMojoType;
mojo.internal.Struct<OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsMojoType>(
    OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,
    'OnDeviceModelService_GetDeviceAndPerformanceInfo_Params',
    [
    ],
    [[0, 8],]);





export interface OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsMojoType {
  performanceInfo: onDeviceModel_mojom_DevicePerformanceInfo;
  deviceInfo: onDeviceModel_mojom_DeviceInfo;
}


export type OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams = OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsMojoType;
mojo.internal.Struct<OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsMojoType>(
    OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
    'OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams',
    [
      mojo.internal.StructField<OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsMojoType, onDeviceModel_mojom_DevicePerformanceInfo>(
        'performanceInfo', 0,
        0,
        onDeviceModel_mojom_DevicePerformanceInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsMojoType, onDeviceModel_mojom_DeviceInfo>(
        'deviceInfo', 8,
        0,
        onDeviceModel_mojom_DeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface OnDeviceModelPlatformService_LoadPlatformModel_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
  model: onDeviceModel_mojom_OnDeviceModelPendingReceiver;
  progressObserver: (PlatformModelProgressObserverRemote | null);
}


export type OnDeviceModelPlatformService_LoadPlatformModel_Params = OnDeviceModelPlatformService_LoadPlatformModel_ParamsMojoType;
mojo.internal.Struct<OnDeviceModelPlatformService_LoadPlatformModel_ParamsMojoType>(
    OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,
    'OnDeviceModelPlatformService_LoadPlatformModel_Params',
    [
      mojo.internal.StructField<OnDeviceModelPlatformService_LoadPlatformModel_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OnDeviceModelPlatformService_LoadPlatformModel_ParamsMojoType, onDeviceModel_mojom_OnDeviceModelPendingReceiver>(
        'model', 8,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel_mojom_OnDeviceModelPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OnDeviceModelPlatformService_LoadPlatformModel_ParamsMojoType, PlatformModelProgressObserverRemote>(
        'progressObserver', 12,
        0,
        mojo.internal.InterfaceProxy(PlatformModelProgressObserverRemote),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsMojoType {
  result: onDeviceModel_mojom_LoadModelResult;
}


export type OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams = OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsMojoType;
mojo.internal.Struct<OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsMojoType>(
    OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams',
    [
      mojo.internal.StructField<OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsMojoType, onDeviceModel_mojom_LoadModelResult>(
        'result', 0,
        0,
        onDeviceModel_mojom_LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OnDeviceModelPlatformService_GetPlatformModelState_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
}


export type OnDeviceModelPlatformService_GetPlatformModelState_Params = OnDeviceModelPlatformService_GetPlatformModelState_ParamsMojoType;
mojo.internal.Struct<OnDeviceModelPlatformService_GetPlatformModelState_ParamsMojoType>(
    OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,
    'OnDeviceModelPlatformService_GetPlatformModelState_Params',
    [
      mojo.internal.StructField<OnDeviceModelPlatformService_GetPlatformModelState_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsMojoType {
  result: PlatformModelState;
}


export type OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams = OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsMojoType;
mojo.internal.Struct<OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsMojoType>(
    OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams',
    [
      mojo.internal.StructField<OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsMojoType, PlatformModelState>(
        'result', 0,
        0,
        PlatformModelStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsMojoType {
}


export type OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params = OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsMojoType;
mojo.internal.Struct<OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsMojoType>(
    OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,
    'OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params',
    [
    ],
    [[0, 8],]);





export interface OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsMojoType {
  performanceClass: onDeviceModel_mojom_PerformanceClass;
}


export type OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams = OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsMojoType;
mojo.internal.Struct<OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsMojoType>(
    OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams',
    [
      mojo.internal.StructField<OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsMojoType, onDeviceModel_mojom_PerformanceClass>(
        'performanceClass', 0,
        0,
        onDeviceModel_mojom_PerformanceClassSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OnDeviceModelPlatformService_FormatInput_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
  feature: FormatFeature;
  fields: {[key: string]: string};
}


export type OnDeviceModelPlatformService_FormatInput_Params = OnDeviceModelPlatformService_FormatInput_ParamsMojoType;
mojo.internal.Struct<OnDeviceModelPlatformService_FormatInput_ParamsMojoType>(
    OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,
    'OnDeviceModelPlatformService_FormatInput_Params',
    [
      mojo.internal.StructField<OnDeviceModelPlatformService_FormatInput_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OnDeviceModelPlatformService_FormatInput_ParamsMojoType, FormatFeature>(
        'feature', 8,
        0,
        FormatFeatureSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OnDeviceModelPlatformService_FormatInput_ParamsMojoType, {[key: string]: string}>(
        'fields', 16,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface OnDeviceModelPlatformService_FormatInput_ResponseParamsMojoType {
  result: (string | null);
}


export type OnDeviceModelPlatformService_FormatInput_ResponseParams = OnDeviceModelPlatformService_FormatInput_ResponseParamsMojoType;
mojo.internal.Struct<OnDeviceModelPlatformService_FormatInput_ResponseParamsMojoType>(
    OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_FormatInput_ResponseParams',
    [
      mojo.internal.StructField<OnDeviceModelPlatformService_FormatInput_ResponseParamsMojoType, string>(
        'result', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OnDeviceModelPlatformService_ValidateSafetyResult_ParamsMojoType {
  safetyFeature: SafetyFeature;
  text: string;
  safetyInfo: onDeviceModel_mojom_SafetyInfo;
}


export type OnDeviceModelPlatformService_ValidateSafetyResult_Params = OnDeviceModelPlatformService_ValidateSafetyResult_ParamsMojoType;
mojo.internal.Struct<OnDeviceModelPlatformService_ValidateSafetyResult_ParamsMojoType>(
    OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,
    'OnDeviceModelPlatformService_ValidateSafetyResult_Params',
    [
      mojo.internal.StructField<OnDeviceModelPlatformService_ValidateSafetyResult_ParamsMojoType, SafetyFeature>(
        'safetyFeature', 0,
        0,
        SafetyFeatureSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OnDeviceModelPlatformService_ValidateSafetyResult_ParamsMojoType, string>(
        'text', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OnDeviceModelPlatformService_ValidateSafetyResult_ParamsMojoType, onDeviceModel_mojom_SafetyInfo>(
        'safetyInfo', 16,
        0,
        onDeviceModel_mojom_SafetyInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsMojoType {
  result: boolean;
}


export type OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams = OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsMojoType;
mojo.internal.Struct<OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsMojoType>(
    OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams',
    [
      mojo.internal.StructField<OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsMojoType, boolean>(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



mojo.internal.Union(
    ModelFileSpec.$, 'ModelFile',
    {
      'file': {
        'ordinal': 0,
        'type': mojoBase_mojom_FileSpec.$,
      },
      'path': {
        'ordinal': 1,
        'type': mojoBase_mojom_FilePathSpec.$,
      },
    });

export interface ModelFile {
  file?: mojoBase_mojom_File,
  path?: mojoBase_mojom_FilePath,
}

export enum ModelFileFieldTags {
  FILE,
  PATH,
}

export function whichModelFile(u: ModelFile): ModelFileFieldTags {
  if (u.file !== null && u.file !== undefined) {
    return ModelFileFieldTags.FILE;
  }
  if (u.path !== null && u.path !== undefined) {
    return ModelFileFieldTags.PATH;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    SafetyModelAssetsSpec.$, 'SafetyModelAssets',
    {
      'tsAssets': {
        'ordinal': 0,
        'type': TextSafetyModelAssetsSpec.$,
      },
      'bsAssets': {
        'ordinal': 1,
        'type': BertSafetyModelAssetsSpec.$,
      },
    });

export interface SafetyModelAssets {
  tsAssets?: TextSafetyModelAssets,
  bsAssets?: BertSafetyModelAssets,
}

export enum SafetyModelAssetsFieldTags {
  TS_ASSETS,
  BS_ASSETS,
}

export function whichSafetyModelAssets(u: SafetyModelAssets): SafetyModelAssetsFieldTags {
  if (u.tsAssets !== null && u.tsAssets !== undefined) {
    return SafetyModelAssetsFieldTags.TS_ASSETS;
  }
  if (u.bsAssets !== null && u.bsAssets !== undefined) {
    return SafetyModelAssetsFieldTags.BS_ASSETS;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
